/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.util.Map;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.TimeoutTracker;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.monitors.support.FtpResponse;
import org.opennms.netmgt.poller.support.AbstractServiceMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Distributable
public class FtpMonitor
extends AbstractServiceMonitor {
    public static final Logger LOG = LoggerFactory.getLogger(FtpMonitor.class);
    private static final int DEFAULT_PORT = 21;
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 3000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        TimeoutTracker tracker = new TimeoutTracker(parameters, 0, 3000);
        int port = ParameterMap.getKeyedInteger(parameters, (String)"port", (int)21);
        String userid = ParameterMap.getKeyedString(parameters, (String)"userid", null);
        String password = ParameterMap.getKeyedString(parameters, (String)"password", null);
        InetAddress ipAddr = svc.getAddress();
        PollStatus serviceStatus = PollStatus.unavailable();
        tracker.reset();
        while (tracker.shouldRetry() && !serviceStatus.isAvailable()) {
            String reason;
            LOG.debug("FtpMonitor.poll: Polling interface: {} {}", (Object)InetAddressUtils.str((InetAddress)ipAddr), (Object)tracker);
            Socket socket = null;
            try {
                tracker.startAttempt();
                socket = new Socket();
                socket.connect(new InetSocketAddress(ipAddr, port), tracker.getConnectionTimeout());
                socket.setSoTimeout(tracker.getSoTimeout());
                LOG.debug("FtpMonitor: connected to host: {} on port: {}", (Object)ipAddr, (Object)port);
                serviceStatus = PollStatus.unresponsive();
                BufferedReader lineRdr = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                FtpResponse bannerResponse = FtpResponse.readResponse((BufferedReader)lineRdr);
                if (bannerResponse.isSuccess()) {
                    boolean loggedInSuccessfully = false;
                    LOG.debug("FtpMonitor: Banner response successful.");
                    if (userid == null || userid.length() == 0 || password == null || password.length() == 0) {
                        loggedInSuccessfully = true;
                    } else {
                        FtpResponse.sendCommand((Socket)socket, (String)("USER " + userid));
                        FtpResponse userResponse = FtpResponse.readResponse((BufferedReader)lineRdr);
                        if (userResponse.isSuccess() || userResponse.isIntermediate()) {
                            LOG.debug("FtpMonitor: User response successful.");
                            FtpResponse.sendCommand((Socket)socket, (String)("PASS " + password));
                            FtpResponse passResponse = FtpResponse.readResponse((BufferedReader)lineRdr);
                            if (passResponse.isSuccess()) {
                                LOG.debug("FtpMonitor.poll: Login successful, parsed return code: {}", (Object)passResponse.getCode());
                                loggedInSuccessfully = true;
                            } else {
                                LOG.debug("FtpMonitor.poll: Login failed, parsed return code: {}, full response: {}", (Object)passResponse.getCode(), (Object)passResponse);
                                loggedInSuccessfully = false;
                            }
                        }
                    }
                    double responseTime = tracker.elapsedTimeInMillis();
                    if (loggedInSuccessfully) {
                        FtpResponse.sendCommand((Socket)socket, (String)"QUIT");
                        FtpResponse quitResponse = FtpResponse.readResponse((BufferedReader)lineRdr);
                        if (quitResponse.isSuccess() || quitResponse.getCode() == 530 || quitResponse.getCode() == 425) {
                            serviceStatus = PollStatus.available(responseTime);
                        }
                    }
                }
                if (!serviceStatus.isAvailable()) {
                    serviceStatus = PollStatus.unavailable();
                }
            }
            catch (NumberFormatException e) {
                reason = "NumberFormatException while polling address: " + ipAddr;
                LOG.debug(reason, (Throwable)e);
                serviceStatus = PollStatus.unavailable(reason);
            }
            catch (NoRouteToHostException e) {
                reason = "No route to host exception for address: " + ipAddr;
                LOG.debug(reason, (Throwable)e);
                serviceStatus = PollStatus.unavailable(reason);
            }
            catch (InterruptedIOException e) {
                reason = "did not connect to host with " + tracker;
                LOG.debug(reason);
                serviceStatus = PollStatus.unavailable(reason);
            }
            catch (ConnectException e) {
                reason = "Connection exception for address: " + ipAddr;
                LOG.debug(reason, (Throwable)e);
                serviceStatus = PollStatus.unavailable(reason);
            }
            catch (IOException e) {
                reason = "IOException while polling address: " + ipAddr;
                LOG.debug(reason, (Throwable)e);
                serviceStatus = PollStatus.unavailable(reason);
            }
            finally {
                try {
                    if (socket != null) {
                        socket.close();
                    }
                }
                catch (IOException e) {
                    LOG.debug("FtpMonitor.poll: Error closing socket", (Throwable)e);
                }
            }
            tracker.nextAttempt();
        }
        return serviceStatus;
    }
}

