/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd;

import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgent;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgents;
import org.opennms.netmgt.enlinkd.EnLinkdBuilderITCase;
import org.opennms.netmgt.model.BridgeMacLink;
import org.opennms.netmgt.model.IpNetToMedia;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.topology.BridgeForwardingTableEntry;
import org.opennms.netmgt.model.topology.BridgePort;
import org.opennms.netmgt.nb.Nms4930NetworkBuilder;

public class Nms4930EnIT
extends EnLinkdBuilderITCase {
    Nms4930NetworkBuilder builder = new Nms4930NetworkBuilder();
    String[] macsonbbport = new String[]{"001e58a6aed7", "00265abd0b08", "1caff72905d8", "1caff702cffd", "00e0d8107c0c", "001562cae2cf", "001cf0d18441", "001e58a31b47"};
    String[] forwardersdlink2on10bbport = new String[]{"001195256302", "f07d68a13d67", "001517028e04", "00254591887c", "1cbdb9419a98", "90e6ba8893ee", "001731b83f34", "001485dc7db9", "00269994d3b9", "485b39d72458", "0064406c2980", "0018f307910c", "001bd4b0be80", "0080c84575f5", "001c0e9c5c19", "0055d0e72011", "0040c7ea5fe9", "0021913f50bd", "0019d1b4e835", "00000000fe00", "0015f260a0e3", "60eb69ebacb5", "001cf0e1c11f", "001b0ceae240", "0021918f4ab0", "000fea5fe504", "001b119f90af", "00024496a17e", "5a003b0012f8", "00270dc21568", "0019d1397a9a", "00016c90f20c", "00e0424505c1", "0013463cd236", "001349b4afc9", "0021913fe8db", "0016e63ffb0d", "00304872e5b5", "0014d1e14f92", "000e082dfd5a", "1cbdb941a0d8", "0040c7f6c3b9", "001cb0b4a540", "00e04ca2029e", "1caff70801cb", "00c12800d4fa", "0040c7f6c3df", "0019d14497ec", "0019666ed685", "68efbd000be9", "0002a403541c", "0019d15fa04e", "001930faf384", "00e0f41aceb9", "001bfcff30db", "bcaec511d055", "0011115256a1", "0019d1b4e80c", "00192140817a", "003048917410", "001d602a19ca", "001fca590145", "001d92d7f2da", "001c10595252", "0015174634bc", "001e14a15486", "0011f5d6ec7b", "001e589f0f14", "00055d45975c", "001349a9dde4", "0019d10e5894", "0018199e7989", "001731b1c081", "f07d6897870d", "001346ddc2a4", "14d64d778af3", "00055d3203d8", "0040c7f640cd", "000ab8614718", "0018f375e902", "f07d684dd3cd", "00012345678a", "00e04c1aad77", "0015623c3c81", "0010f31197a1", "0021914221f7", "0021918bb9ed", "0080484ddb79", "00308488e5ae", "00138063ded1", "0012d9ade6b7", "001ef6331e9b", "001731e58a9e", "00195b12b1c0", "0080484ddb74", "3c5a37aa1795", "000d88b5b911", "0016e09f8f20", "0040c7f63992", "0015e940ff75", "0019db86ea8d", "00c026a15735", "0019d1841171", "00251129ca15", "0019d1aa0366", "001c57c387c3", "001b4f38905f", "8843e109d550", "000f3d1bf298", "00252231abe7", "000c293d638f", "0019e258d000", "f4ec38ac74c5", "0015171778e8", "1caff79e904d", "90e6baacfb18", "000ff77595a6", "00195b3819e4", "f07d68825ef9", "0040c7f6c304", "0040c7f63882", "001fc6b5deed", "1caff79b1a75", "0021918e8504", "1cbdb972002d", "00c12802479e", "1caff79798f3", "000000000010", "000021fa6bcb", "0040c7ea28db", "000c7650f682", "f4ec38bdc71b", "001e58a32fcd", "000af4aa34b0", "f4ec38e915fd", "68bdabb72100", "0021919703aa", "00904cc00000", "0021913f0927", "001bfc200be1", "588d091ba9f3", "00265aac5b9b", "001e58a32fc0", "00265aac5a7d", "001bfc9d93c2", "00260bb55cf1", "4c0010131109", "00134991f9ac", "8418880d214a", "00215ec7fd9c", "00024456d458", "001d7dca473d", "001a2fe8f182", "00016cf6556a", "0016b68e676d", "e05fb9597072", "7071bc71b4fb", "00096b63547d", "0040c7f639e9", "000c29e050ff", "0040c7f639e7", "1cbdb9ff6056", "c471feb243f9", "00173154a2f1", "0019aac19fd0", "0040c7f69000", "001346716177", "0040c7f6380a", "0018ba493d90", "0002d110cfa4", "0019dbd93f4a", "0080485b607c", "0016c70e9c05", "0015177c6310", "00a0c944c29f", "001346657f51", "00046144b053", "001e58f445ee", "000fd9044246", "00089bc57a61", "001bfc9d93dd", "00195bfe5563", "009027a7f87b", "001731775384", "00252273200b", "0022b0e20455", "000ff8ccd000", "0016e661c8ae", "0040c7f6216c", "0040c7f6c390", "001e49761304", "1caff79e9259", "001d92d7f309", "001517818b44", "f07d684f84bb", "0016c70e9c10", "0040c7f6261f", "001f6cce0000", "5cf3fc4c2458", "0019d1987d52", "001517e84a53", "14d64dcf4239", "000cf1c8a902", "0025456debe0", "001517e84a54", "0024be033412", "000fd904421a", "0021915a54a7", "005056b00169", "001195dd2f89", "001d607cdd31", "002413f4f390", "c0c1c050c88a", "001bfcf65947", "001d923db8bf", "0040c7f6bfd0", "00112f0f1054", "64168dfa8d48", "001517e84b82", "0016761846ee", "000d28dd2a80", "001cf0ab5a8d", "0016e63ffc96", "001873f92003", "0002442e35d2", "00304866bbdd", "00908f0fd9e2", "0026ca9df81b", "00211bf7dac4", "002522c0e539", "340804144361", "1caff702cfe9", "0020d2286bdd", "001cf0e1c18b", "00908f0fd9d6", "005056904c94", "00e051800166", "001e589c2d44", "0007e912739f", "000d613ff745", "00229064ffd1", "0000855c70f5", "0019d184546f", "0021918f1181", "000a5e60098d", "0013d3e3ac23", "001e589ee128", "001e589c2d3d", "001f6cce336a", "00145ea49072", "000bbea07216", "00265abd0b0c", "001f6cce336b", "0010b5ad1577", "000bbea07214", "3ce5a681a5c3", "00a0c993afbf", "001562cae2ce", "1caff7825a8f", "0002d10f5466", "001125f29b67", "0002d10f15dc", "001cf0a569c3", "1078d2155840", "0015e941a6e9", "0015e9416070", "0023544434d7", "00e01833e66f", "000ea662910d", "00265abd0b09", "0040c7f63ccc", "e0cb4ec5fdb9", "0019d1840a08", "00161712258b", "0002a40264f4", "0016c7f99e43", "00265aac58bb", "001bfc89b026", "006440893da1", "0013c495d611", "f07d689f027f", "0002a4027786", "00269994e318", "1caff702d132", "e0cb4eaa2626", "000fd9044177", "00242124a1ee", "1caff79b3883", "002191546029", "002191546028", "0090fb23836e", "00e052140240", "fcfbfb8ceac0", "3037a6483ae0", "001d922221dc", "000c29b9824c", "005056901ad2", "0040c7f63ce6", "000ea63553d2", "d4c1fc48acac", "485b39264ce6", "000fd90440bd", "0020d22c2140", "0021913b7f07", "001e8cac2271", "0019d1840b45", "0040c7f639d7", "00248ce65505", "00265abe2df4", "0016e6616ba3", "001b11055570", "00265a154b0a", "0015177c630f", "001b0db8881a", "20cf309a1738", "1caff7a5822e", "00000000fe01", "081ff3a89099", "0040c7f639d5", "001b0db8881b", "c84c75e4055b", "00187d09df0c", "000c292a1a11", "00179a5504ae", "00142af18edf", "00304886ccbd", "14d64d358e89", "0002d10f7852", "5a003b011e1a", "001e58af957b", "0002d10f7855", "0002d10f7853", "0040c7ea5b78", "005056b0661e"};
    String[] forwardersdlink1on24bbport = new String[]{"00270e0a788a", "00c0266a1d1d", "1c6f65b3599a", "0013774b4ab2"};

    @Before
    public void setUpNetwork4930() throws Exception {
        this.builder.setNodeDao(this.m_nodeDao);
        this.builder.setIpNetToMediaDao(this.m_ipNetToMediaDao);
        this.builder.buildNetwork4930();
        this.builder.addMacNodeWithSnmpInterface("001e58a6aed7", "10.100.1.7", 101);
        this.builder.addMacNode("000ffeb10e26", "10.100.2.6");
        Assert.assertEquals((long)4L, (long)this.m_nodeDao.countAll());
        Assert.assertEquals((long)2L, (long)this.m_ipNetToMediaDao.countAll());
        IpNetToMedia at0 = (IpNetToMedia)this.m_ipNetToMediaDao.findByPhysAddress("001e58a6aed7").get(0);
        Assert.assertNotNull((Object)at0);
        Assert.assertEquals((Object)"10.100.1.7", (Object)at0.getNetAddress().getHostAddress());
        IpNetToMedia at1 = (IpNetToMedia)this.m_ipNetToMediaDao.findByPhysAddress("000ffeb10e26").get(0);
        Assert.assertNotNull((Object)at1);
        Assert.assertEquals((Object)"10.100.2.6", (Object)at1.getNetAddress().getHostAddress());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.1.1.2", port=161, resource="classpath:/linkd/nms4930/dlink_DES-3026.properties")})
    public void testNms4930Bft() throws Exception {
        OnmsNode dlink1 = this.m_nodeDao.findByForeignId("linkd", "dlink1");
        this.m_linkdConfig.getConfiguration().setUseBridgeDiscovery(Boolean.valueOf(true));
        this.m_linkdConfig.getConfiguration().setUseCdpDiscovery(Boolean.valueOf(false));
        this.m_linkdConfig.getConfiguration().setUseOspfDiscovery(Boolean.valueOf(false));
        this.m_linkdConfig.getConfiguration().setUseLldpDiscovery(Boolean.valueOf(false));
        this.m_linkdConfig.getConfiguration().setUseIsisDiscovery(Boolean.valueOf(false));
        Assert.assertTrue((!this.m_linkdConfig.useLldpDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((!this.m_linkdConfig.useCdpDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((!this.m_linkdConfig.useOspfDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.m_linkdConfig.useBridgeDiscovery());
        Assert.assertTrue((!this.m_linkdConfig.useIsisDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(dlink1.getId().intValue()));
        Assert.assertEquals((long)0L, (long)this.m_bridgeBridgeLinkDao.countAll());
        Assert.assertEquals((long)0L, (long)this.m_bridgeMacLinkDao.countAll());
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(dlink1.getId().intValue()));
        Assert.assertEquals((long)0L, (long)this.m_bridgeBridgeLinkDao.countAll());
        Assert.assertEquals((long)0L, (long)this.m_bridgeMacLinkDao.countAll());
        Set links = this.m_linkd.getQueryManager().useBridgeTopologyUpdateBFT(dlink1.getId().intValue());
        Assert.assertEquals((long)59L, (long)links.size());
        for (BridgeForwardingTableEntry link : links) {
            System.err.println(link.printTopology());
            if (BridgeForwardingTableEntry.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_SELF == link.getBridgeDot1qTpFdbStatus()) continue;
            Assert.assertEquals((Object)BridgeForwardingTableEntry.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED, (Object)link.getBridgeDot1qTpFdbStatus());
            BridgeMacLink maclink = BridgeForwardingTableEntry.create((BridgePort)BridgePort.getFromBridgeForwardingTableEntry((BridgeForwardingTableEntry)link), (String)link.getMacAddress(), (BridgeMacLink.BridgeMacLinkType)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK);
            maclink.setBridgeMacLinkLastPollTime(maclink.getBridgeMacLinkCreateTime());
            this.m_bridgeMacLinkDao.save((Object)maclink);
        }
        Assert.assertEquals((long)58L, (long)this.m_bridgeMacLinkDao.countAll());
        for (BridgeMacLink maclink : this.m_bridgeMacLinkDao.findAll()) {
            Assert.assertNotNull((Object)maclink.getBridgePortIfIndex());
            Assert.assertNotNull((Object)maclink.getBridgePort());
            Assert.assertNotNull((Object)maclink.getNode());
            Assert.assertNotNull((Object)maclink.getMacAddress());
            System.err.println(maclink.printTopology());
        }
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.1.1.2", port=161, resource="classpath:/linkd/nms4930/dlink_DES-3026.properties")})
    public void testNms4930Dlink1() throws Exception {
        OnmsNode dlink1 = this.m_nodeDao.findByForeignId("linkd", "dlink1");
        this.m_linkdConfig.getConfiguration().setUseBridgeDiscovery(Boolean.valueOf(true));
        this.m_linkdConfig.getConfiguration().setUseCdpDiscovery(Boolean.valueOf(false));
        this.m_linkdConfig.getConfiguration().setUseOspfDiscovery(Boolean.valueOf(false));
        this.m_linkdConfig.getConfiguration().setUseLldpDiscovery(Boolean.valueOf(false));
        this.m_linkdConfig.getConfiguration().setUseIsisDiscovery(Boolean.valueOf(false));
        Assert.assertTrue((!this.m_linkdConfig.useLldpDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((!this.m_linkdConfig.useCdpDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((!this.m_linkdConfig.useOspfDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.m_linkdConfig.useBridgeDiscovery());
        Assert.assertTrue((!this.m_linkdConfig.useIsisDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(dlink1.getId().intValue()));
        Assert.assertEquals((long)0L, (long)this.m_bridgeBridgeLinkDao.countAll());
        Assert.assertEquals((long)0L, (long)this.m_bridgeMacLinkDao.countAll());
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(dlink1.getId().intValue()));
        this.m_linkd.runTopologyDiscovery();
        this.checkTopologyDlink1(dlink1);
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.1.2.2", port=161, resource="classpath:/linkd/nms4930/dlink_DGS-3612G.properties")})
    public void testNms4930Dlink2() throws Exception {
        OnmsNode dlink2 = this.m_nodeDao.findByForeignId("linkd", "dlink2");
        this.m_linkdConfig.getConfiguration().setUseBridgeDiscovery(Boolean.valueOf(true));
        this.m_linkdConfig.getConfiguration().setUseCdpDiscovery(Boolean.valueOf(false));
        this.m_linkdConfig.getConfiguration().setUseOspfDiscovery(Boolean.valueOf(false));
        this.m_linkdConfig.getConfiguration().setUseLldpDiscovery(Boolean.valueOf(false));
        this.m_linkdConfig.getConfiguration().setUseIsisDiscovery(Boolean.valueOf(false));
        Assert.assertTrue((!this.m_linkdConfig.useLldpDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((!this.m_linkdConfig.useCdpDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((!this.m_linkdConfig.useOspfDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.m_linkdConfig.useBridgeDiscovery());
        Assert.assertTrue((!this.m_linkdConfig.useIsisDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(dlink2.getId().intValue()));
        Assert.assertEquals((long)0L, (long)this.m_bridgeBridgeLinkDao.countAll());
        Assert.assertEquals((long)0L, (long)this.m_bridgeMacLinkDao.countAll());
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(dlink2.getId().intValue()));
        this.m_linkd.runTopologyDiscovery();
        this.checkTopologyDlink2(dlink2);
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.1.1.2", port=161, resource="classpath:/linkd/nms4930/dlink_DES-3026.properties"), @JUnitSnmpAgent(host="10.1.2.2", port=161, resource="classpath:/linkd/nms4930/dlink_DGS-3612G.properties")})
    public void testNms4930Network() throws Exception {
        OnmsNode dlink1 = this.m_nodeDao.findByForeignId("linkd", "dlink1");
        OnmsNode dlink2 = this.m_nodeDao.findByForeignId("linkd", "dlink2");
        OnmsNode nodebetweendlink1dlink2 = this.m_nodeDao.findByForeignId("linkd", "10.100.1.7");
        OnmsNode nodeonlink1dport6 = this.m_nodeDao.findByForeignId("linkd", "10.100.2.6");
        Assert.assertNotNull((Object)nodebetweendlink1dlink2);
        Assert.assertNotNull((Object)nodeonlink1dport6);
        this.m_linkdConfig.getConfiguration().setUseBridgeDiscovery(Boolean.valueOf(true));
        this.m_linkdConfig.getConfiguration().setUseCdpDiscovery(Boolean.valueOf(false));
        this.m_linkdConfig.getConfiguration().setUseOspfDiscovery(Boolean.valueOf(false));
        this.m_linkdConfig.getConfiguration().setUseLldpDiscovery(Boolean.valueOf(false));
        this.m_linkdConfig.getConfiguration().setUseIsisDiscovery(Boolean.valueOf(false));
        Assert.assertTrue((!this.m_linkdConfig.useLldpDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((!this.m_linkdConfig.useCdpDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((!this.m_linkdConfig.useOspfDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.m_linkdConfig.useBridgeDiscovery());
        Assert.assertTrue((!this.m_linkdConfig.useIsisDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(dlink1.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(dlink2.getId().intValue()));
        Assert.assertEquals((long)0L, (long)this.m_bridgeBridgeLinkDao.countAll());
        Assert.assertEquals((long)0L, (long)this.m_bridgeMacLinkDao.countAll());
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(dlink1.getId().intValue()));
        this.m_linkd.runTopologyDiscovery();
        this.checkTopologyDlink1(dlink1);
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(dlink2.getId().intValue()));
        this.m_linkd.runTopologyDiscovery();
        this.checkTopology(dlink1, dlink2, nodeonlink1dport6, nodebetweendlink1dlink2, false);
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.1.1.2", port=161, resource="classpath:/linkd/nms4930/dlink_DES-3026.properties"), @JUnitSnmpAgent(host="10.1.2.2", port=161, resource="classpath:/linkd/nms4930/dlink_DGS-3612G.properties")})
    public void testNms4930NetworkReverse() throws Exception {
        OnmsNode dlink1 = this.m_nodeDao.findByForeignId("linkd", "dlink1");
        OnmsNode dlink2 = this.m_nodeDao.findByForeignId("linkd", "dlink2");
        OnmsNode nodebetweendlink1dlink2 = this.m_nodeDao.findByForeignId("linkd", "10.100.1.7");
        OnmsNode nodeonlink1dport6 = this.m_nodeDao.findByForeignId("linkd", "10.100.2.6");
        Assert.assertNotNull((Object)nodebetweendlink1dlink2);
        Assert.assertNotNull((Object)nodeonlink1dport6);
        this.m_linkdConfig.getConfiguration().setUseBridgeDiscovery(Boolean.valueOf(true));
        this.m_linkdConfig.getConfiguration().setUseCdpDiscovery(Boolean.valueOf(false));
        this.m_linkdConfig.getConfiguration().setUseOspfDiscovery(Boolean.valueOf(false));
        this.m_linkdConfig.getConfiguration().setUseLldpDiscovery(Boolean.valueOf(false));
        this.m_linkdConfig.getConfiguration().setUseIsisDiscovery(Boolean.valueOf(false));
        Assert.assertTrue((!this.m_linkdConfig.useLldpDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((!this.m_linkdConfig.useCdpDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((!this.m_linkdConfig.useOspfDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.m_linkdConfig.useBridgeDiscovery());
        Assert.assertTrue((!this.m_linkdConfig.useIsisDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(dlink2.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(dlink1.getId().intValue()));
        Assert.assertEquals((long)0L, (long)this.m_bridgeBridgeLinkDao.countAll());
        Assert.assertEquals((long)0L, (long)this.m_bridgeMacLinkDao.countAll());
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(dlink2.getId().intValue()));
        this.m_linkd.runTopologyDiscovery();
        this.checkTopologyDlink2(dlink2);
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(dlink1.getId().intValue()));
        this.m_linkd.runTopologyDiscovery();
        this.checkTopology(dlink1, dlink2, nodeonlink1dport6, nodebetweendlink1dlink2, true);
    }

    private void checkTopologyDlink1(OnmsNode dlink1) {
        Assert.assertEquals((long)0L, (long)this.m_bridgeBridgeLinkDao.countAll());
        Assert.assertEquals((long)1L, (long)this.m_bridgeMacLinkDao.findByNodeIdBridgePort(dlink1.getId(), Integer.valueOf(1)).size());
        Assert.assertEquals((long)1L, (long)this.m_bridgeMacLinkDao.findByNodeIdBridgePort(dlink1.getId(), Integer.valueOf(2)).size());
        Assert.assertEquals((long)1L, (long)this.m_bridgeMacLinkDao.findByNodeIdBridgePort(dlink1.getId(), Integer.valueOf(3)).size());
        Assert.assertEquals((long)8L, (long)this.m_bridgeMacLinkDao.findByNodeIdBridgePort(dlink1.getId(), Integer.valueOf(4)).size());
        Assert.assertEquals((long)1L, (long)this.m_bridgeMacLinkDao.findByNodeIdBridgePort(dlink1.getId(), Integer.valueOf(5)).size());
        Assert.assertEquals((long)14L, (long)this.m_bridgeMacLinkDao.findByNodeIdBridgePort(dlink1.getId(), Integer.valueOf(6)).size());
        Assert.assertEquals((long)30L, (long)this.m_bridgeMacLinkDao.findByNodeIdBridgePort(dlink1.getId(), Integer.valueOf(24)).size());
        Assert.assertEquals((long)56L, (long)this.m_bridgeMacLinkDao.countAll());
        for (BridgeMacLink maclink : this.m_bridgeMacLinkDao.findAll()) {
            System.err.println(maclink.printTopology());
            Assert.assertNotNull((Object)maclink.getBridgePortIfIndex());
            Assert.assertNotNull((Object)maclink.getBridgePort());
            Assert.assertNotNull((Object)maclink.getNode());
            Assert.assertNotNull((Object)maclink.getMacAddress());
            Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)maclink.getLinkType());
        }
    }

    private void checkTopology(OnmsNode dlink1, OnmsNode dlink2, OnmsNode nodeonlink1dport6, OnmsNode nodebetweendlink1dlink2, boolean reverse) {
        List maclinks;
        Assert.assertEquals((long)1L, (long)this.m_bridgeMacLinkDao.findByNodeIdBridgePort(dlink1.getId(), Integer.valueOf(1)).size());
        Assert.assertEquals((long)1L, (long)this.m_bridgeMacLinkDao.findByNodeIdBridgePort(dlink1.getId(), Integer.valueOf(2)).size());
        Assert.assertEquals((long)1L, (long)this.m_bridgeMacLinkDao.findByNodeIdBridgePort(dlink1.getId(), Integer.valueOf(3)).size());
        Assert.assertEquals((long)8L, (long)this.m_bridgeMacLinkDao.findByNodeIdBridgePort(dlink1.getId(), Integer.valueOf(4)).size());
        Assert.assertEquals((long)1L, (long)this.m_bridgeMacLinkDao.findByNodeIdBridgePort(dlink1.getId(), Integer.valueOf(5)).size());
        Assert.assertEquals((long)14L, (long)this.m_bridgeMacLinkDao.findByNodeIdBridgePort(dlink1.getId(), Integer.valueOf(6)).size());
        Assert.assertEquals((long)35L, (long)this.m_bridgeMacLinkDao.findByNodeIdBridgePort(dlink2.getId(), Integer.valueOf(1)).size());
        Assert.assertEquals((long)70L, (long)this.m_bridgeMacLinkDao.findByNodeIdBridgePort(dlink2.getId(), Integer.valueOf(2)).size());
        Assert.assertEquals((long)29L, (long)this.m_bridgeMacLinkDao.findByNodeIdBridgePort(dlink2.getId(), Integer.valueOf(3)).size());
        Assert.assertEquals((long)142L, (long)this.m_bridgeMacLinkDao.findByNodeIdBridgePort(dlink2.getId(), Integer.valueOf(5)).size());
        Assert.assertEquals((long)47L, (long)this.m_bridgeMacLinkDao.findByNodeIdBridgePort(dlink2.getId(), Integer.valueOf(6)).size());
        Assert.assertEquals((long)5L, (long)this.m_bridgeMacLinkDao.findByNodeIdBridgePort(dlink2.getId(), Integer.valueOf(7)).size());
        Assert.assertEquals((long)122L, (long)this.m_bridgeMacLinkDao.findByNodeIdBridgePort(dlink2.getId(), Integer.valueOf(8)).size());
        Assert.assertEquals((long)163L, (long)this.m_bridgeMacLinkDao.findByNodeIdBridgePort(dlink2.getId(), Integer.valueOf(12)).size());
        if (reverse) {
            Assert.assertEquals((long)4L, (long)this.m_bridgeMacLinkDao.findByNodeIdBridgePort(dlink1.getId(), Integer.valueOf(24)).size());
            Assert.assertEquals((long)342L, (long)this.m_bridgeMacLinkDao.findByNodeIdBridgePort(dlink2.getId(), Integer.valueOf(10)).size());
        } else {
            Assert.assertEquals((long)12L, (long)this.m_bridgeMacLinkDao.findByNodeIdBridgePort(dlink1.getId(), Integer.valueOf(24)).size());
            Assert.assertEquals((long)334L, (long)this.m_bridgeMacLinkDao.findByNodeIdBridgePort(dlink2.getId(), Integer.valueOf(10)).size());
        }
        Assert.assertEquals((long)985L, (long)this.m_bridgeMacLinkDao.countAll());
        Assert.assertEquals((long)1L, (long)this.m_bridgeBridgeLinkDao.countAll());
        for (BridgeMacLink link : this.m_bridgeMacLinkDao.findAll()) {
            Assert.assertNotNull((Object)link.getNode());
            Assert.assertNotNull((Object)link.getBridgePort());
            Assert.assertNotNull((Object)link.getBridgePortIfIndex());
            Assert.assertNotNull((Object)link.getMacAddress());
        }
        for (String mac : this.macsonbbport) {
            maclinks = this.m_bridgeMacLinkDao.findByMacAddress(mac);
            Assert.assertEquals((long)1L, (long)maclinks.size());
            for (BridgeMacLink link : maclinks) {
                Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link.getLinkType());
                Assert.assertEquals((Object)mac, (Object)link.getMacAddress());
                if (reverse) {
                    Assert.assertEquals((long)10L, (long)link.getBridgePort().intValue());
                    Assert.assertEquals((long)10L, (long)link.getBridgePortIfIndex().intValue());
                    Assert.assertEquals((long)dlink2.getId().intValue(), (long)link.getNode().getId().intValue());
                    continue;
                }
                Assert.assertEquals((long)24L, (long)link.getBridgePort().intValue());
                Assert.assertEquals((long)24L, (long)link.getBridgePortIfIndex().intValue());
                Assert.assertEquals((long)dlink1.getId().intValue(), (long)link.getNode().getId().intValue());
            }
        }
        for (String mac : this.forwardersdlink1on24bbport) {
            maclinks = this.m_bridgeMacLinkDao.findByMacAddress(mac);
            Assert.assertEquals((long)1L, (long)maclinks.size());
            for (BridgeMacLink link : maclinks) {
                Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_FORWARDER, (Object)link.getLinkType());
                Assert.assertEquals((Object)mac, (Object)link.getMacAddress());
                Assert.assertEquals((long)24L, (long)link.getBridgePort().intValue());
                Assert.assertEquals((long)24L, (long)link.getBridgePortIfIndex().intValue());
                Assert.assertEquals((long)dlink1.getId().intValue(), (long)link.getNode().getId().intValue());
            }
        }
        for (String mac : this.forwardersdlink2on10bbport) {
            maclinks = this.m_bridgeMacLinkDao.findByMacAddress(mac);
            Assert.assertEquals((long)1L, (long)maclinks.size());
            for (BridgeMacLink link : maclinks) {
                Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_FORWARDER, (Object)link.getLinkType());
                Assert.assertEquals((Object)mac, (Object)link.getMacAddress());
                Assert.assertEquals((long)10L, (long)link.getBridgePort().intValue());
                Assert.assertEquals((long)10L, (long)link.getBridgePortIfIndex().intValue());
                Assert.assertEquals((long)dlink2.getId().intValue(), (long)link.getNode().getId().intValue());
            }
        }
    }

    private void checkTopologyDlink2(OnmsNode dlink2) {
        Assert.assertEquals((long)0L, (long)this.m_bridgeBridgeLinkDao.countAll());
        Assert.assertEquals((long)35L, (long)this.m_bridgeMacLinkDao.findByNodeIdBridgePort(dlink2.getId(), Integer.valueOf(1)).size());
        Assert.assertEquals((long)70L, (long)this.m_bridgeMacLinkDao.findByNodeIdBridgePort(dlink2.getId(), Integer.valueOf(2)).size());
        Assert.assertEquals((long)29L, (long)this.m_bridgeMacLinkDao.findByNodeIdBridgePort(dlink2.getId(), Integer.valueOf(3)).size());
        Assert.assertEquals((long)142L, (long)this.m_bridgeMacLinkDao.findByNodeIdBridgePort(dlink2.getId(), Integer.valueOf(5)).size());
        Assert.assertEquals((long)47L, (long)this.m_bridgeMacLinkDao.findByNodeIdBridgePort(dlink2.getId(), Integer.valueOf(6)).size());
        Assert.assertEquals((long)5L, (long)this.m_bridgeMacLinkDao.findByNodeIdBridgePort(dlink2.getId(), Integer.valueOf(7)).size());
        Assert.assertEquals((long)122L, (long)this.m_bridgeMacLinkDao.findByNodeIdBridgePort(dlink2.getId(), Integer.valueOf(8)).size());
        Assert.assertEquals((long)362L, (long)this.m_bridgeMacLinkDao.findByNodeIdBridgePort(dlink2.getId(), Integer.valueOf(10)).size());
        Assert.assertEquals((long)163L, (long)this.m_bridgeMacLinkDao.findByNodeIdBridgePort(dlink2.getId(), Integer.valueOf(12)).size());
        Assert.assertEquals((long)975L, (long)this.m_bridgeMacLinkDao.countAll());
        for (BridgeMacLink maclink : this.m_bridgeMacLinkDao.findAll()) {
            Assert.assertNotNull((Object)maclink.getBridgePortIfIndex());
            Assert.assertNotNull((Object)maclink.getBridgePort());
            Assert.assertNotNull((Object)maclink.getNode());
            Assert.assertNotNull((Object)maclink.getMacAddress());
            Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)maclink.getLinkType());
        }
    }
}

