/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.io.File;
import java.io.FileWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.core.collection.test.MockCollectionAgent;
import org.opennms.core.db.DataSourceFactory;
import org.opennms.core.rpc.api.RpcClientFactory;
import org.opennms.core.rpc.mock.MockRpcClientFactory;
import org.opennms.core.test.MockLogAppender;
import org.opennms.core.test.db.MockDatabase;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.collectd.AliasedResource;
import org.opennms.netmgt.collectd.GenericIndexResource;
import org.opennms.netmgt.collectd.GenericIndexResourceType;
import org.opennms.netmgt.collectd.IfInfo;
import org.opennms.netmgt.collectd.IfResourceType;
import org.opennms.netmgt.collectd.NodeInfo;
import org.opennms.netmgt.collectd.NodeResourceType;
import org.opennms.netmgt.collectd.NumericAttributeType;
import org.opennms.netmgt.collectd.OnmsSnmpCollection;
import org.opennms.netmgt.collectd.ResourceType;
import org.opennms.netmgt.collectd.SnmpAttributeType;
import org.opennms.netmgt.collectd.SnmpCollectionAgent;
import org.opennms.netmgt.collectd.SnmpCollectionResource;
import org.opennms.netmgt.collectd.SnmpIfData;
import org.opennms.netmgt.collection.api.AttributeGroupType;
import org.opennms.netmgt.collection.api.AttributeType;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionSet;
import org.opennms.netmgt.collection.api.CollectionSetVisitor;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.collection.dto.CollectionSetDTO;
import org.opennms.netmgt.collection.support.IndexStorageStrategy;
import org.opennms.netmgt.collection.support.PersistAllSelectorStrategy;
import org.opennms.netmgt.collection.support.builder.CollectionSetBuilder;
import org.opennms.netmgt.collection.support.builder.GenericTypeResource;
import org.opennms.netmgt.collection.support.builder.NodeLevelResource;
import org.opennms.netmgt.collection.support.builder.Resource;
import org.opennms.netmgt.config.DatabaseSchemaConfigFactory;
import org.opennms.netmgt.config.PollOutagesConfigFactory;
import org.opennms.netmgt.config.ThreshdConfigFactory;
import org.opennms.netmgt.config.ThresholdingConfigFactory;
import org.opennms.netmgt.config.api.DataCollectionConfigDao;
import org.opennms.netmgt.config.api.DatabaseSchemaConfig;
import org.opennms.netmgt.config.datacollection.MibObject;
import org.opennms.netmgt.config.datacollection.PersistenceSelectorStrategy;
import org.opennms.netmgt.config.datacollection.StorageStrategy;
import org.opennms.netmgt.config.threshd.Package;
import org.opennms.netmgt.config.threshd.Parameter;
import org.opennms.netmgt.config.threshd.Service;
import org.opennms.netmgt.dao.api.ResourceStorageDao;
import org.opennms.netmgt.dao.mock.EventAnticipator;
import org.opennms.netmgt.dao.mock.MockEventIpcManager;
import org.opennms.netmgt.dao.support.FilesystemResourceStorageDao;
import org.opennms.netmgt.dao.support.SiblingColumnStorageStrategy;
import org.opennms.netmgt.events.api.EventIpcManager;
import org.opennms.netmgt.events.api.EventIpcManagerFactory;
import org.opennms.netmgt.filter.FilterDaoFactory;
import org.opennms.netmgt.filter.JdbcFilterDao;
import org.opennms.netmgt.filter.api.FilterDao;
import org.opennms.netmgt.mock.MockDataCollectionConfig;
import org.opennms.netmgt.mock.MockNetwork;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.model.ResourcePath;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.rrd.RrdRepository;
import org.opennms.netmgt.snmp.InetAddrUtils;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.snmp.proxy.LocationAwareSnmpClient;
import org.opennms.netmgt.snmp.proxy.common.LocationAwareSnmpClientRpcImpl;
import org.opennms.netmgt.threshd.CollectionResourceWrapper;
import org.opennms.netmgt.threshd.ThresholdGroup;
import org.opennms.netmgt.threshd.ThresholdInitializationException;
import org.opennms.netmgt.threshd.ThresholdingVisitor;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.test.FileAnticipator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;

public class ThresholdingVisitorIT {
    private static final Logger LOG = LoggerFactory.getLogger(ThresholdingVisitorIT.class);
    FilterDao m_filterDao;
    EventAnticipator m_anticipator;
    FileAnticipator m_fileAnticipator;
    Map<Integer, File> m_hrStorageProperties;
    List<Event> m_anticipatedEvents;
    private FilesystemResourceStorageDao m_resourceStorageDao;
    private LocationAwareSnmpClient m_locationAwareSnmpClient = new LocationAwareSnmpClientRpcImpl((RpcClientFactory)new MockRpcClientFactory());
    private static final Comparator<Parm> PARM_COMPARATOR = new Comparator<Parm>(){

        @Override
        public int compare(Parm o1, Parm o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null && o2 != null) {
                return 1;
            }
            if (o1 != null && o2 == null) {
                return -1;
            }
            int retVal = o1.getParmName().compareTo(o2.getParmName());
            if (retVal == 0) {
                String c1 = o1.getValue().getContent();
                String c2 = o2.getValue().getContent();
                if (c1 == null && c2 == null) {
                    return 0;
                }
                if (c1 == null && c2 != null) {
                    return 1;
                }
                if (c1 != null && c2 == null) {
                    return -1;
                }
                retVal = c1.compareTo(c2);
            }
            return retVal;
        }
    };
    private static final Comparator<Event> EVENT_COMPARATOR = new Comparator<Event>(){

        private int compareStrings(String s1, String s2) {
            if (s1 == null && s2 == null) {
                return 0;
            }
            if (s1 == null && s2 != null) {
                return 1;
            }
            if (s1 != null && s2 == null) {
                return -1;
            }
            return s1.compareTo(s2);
        }

        @Override
        public int compare(Event e1, Event e2) {
            if (e1 == null && e2 == null) {
                return 0;
            }
            if (e1 == null && e2 != null) {
                return 1;
            }
            if (e1 != null && e2 == null) {
                return -1;
            }
            int retVal = this.compareStrings(e1.getUei(), e2.getUei());
            if (retVal == 0) {
                retVal = InetAddressUtils.toInteger((InetAddress)e1.getInterfaceAddress()).compareTo(InetAddressUtils.toInteger((InetAddress)e2.getInterfaceAddress()));
            }
            if (retVal == 0) {
                retVal = this.compareStrings(e1.getService(), e2.getService());
            }
            if (retVal == 0) {
                List anticipatedParms = e1.getParmCollection();
                List receivedParms = e2.getParmCollection();
                Collections.sort(anticipatedParms, PARM_COMPARATOR);
                Collections.sort(receivedParms, PARM_COMPARATOR);
                if (anticipatedParms.size() != receivedParms.size()) {
                    retVal = Integer.valueOf(anticipatedParms.size()).compareTo(receivedParms.size());
                }
                if (retVal == 0) {
                    for (int i = 0; i < anticipatedParms.size(); ++i) {
                        Parm anticipated = (Parm)anticipatedParms.get(i);
                        Parm received = (Parm)receivedParms.get(i);
                        retVal = this.compareStrings(anticipated.getParmName(), received.getParmName());
                        if (retVal == 0) {
                            retVal = this.compareStrings(anticipated.getValue().getContent(), received.getValue().getContent());
                        }
                        if (retVal != 0) break;
                    }
                }
            }
            return retVal;
        }
    };

    @Before
    public void setUp() throws Exception {
        CollectionResourceWrapper.s_cache.clear();
        MockLogAppender.setupLogging();
        this.m_fileAnticipator = new FileAnticipator();
        this.m_hrStorageProperties = new HashMap<Integer, File>();
        this.m_resourceStorageDao = new FilesystemResourceStorageDao();
        this.m_resourceStorageDao.setRrdDirectory(new File(this.m_fileAnticipator.getTempDir(), "snmp"));
        this.m_filterDao = (FilterDao)EasyMock.createMock(FilterDao.class);
        EasyMock.expect((Object)this.m_filterDao.getActiveIPAddressList((String)EasyMock.anyObject())).andReturn(Collections.singletonList(InetAddressUtils.addr((String)"127.0.0.1"))).anyTimes();
        this.m_filterDao.flushActiveIpAddressListCache();
        EasyMock.expectLastCall().anyTimes();
        FilterDaoFactory.setInstance((FilterDao)this.m_filterDao);
        EasyMock.replay((Object[])new Object[]{this.m_filterDao});
        this.m_anticipator = new EventAnticipator();
        MockEventIpcManager eventMgr = new MockEventIpcManager();
        eventMgr.setEventAnticipator(this.m_anticipator);
        eventMgr.setSynchronous(true);
        MockEventIpcManager eventdIpcMgr = eventMgr;
        EventIpcManagerFactory.setIpcManager((EventIpcManager)eventdIpcMgr);
        SimpleDateFormat formatter = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
        StringBuilder sb = new StringBuilder("<?xml version=\"1.0\"?>");
        sb.append("<outages>");
        sb.append("<outage name=\"junit outage\" type=\"specific\">");
        sb.append("<time begins=\"");
        sb.append(formatter.format(new Date(System.currentTimeMillis() - 3600000L)));
        sb.append("\" ends=\"");
        sb.append(formatter.format(new Date(System.currentTimeMillis() + 3600000L)));
        sb.append("\"/>");
        sb.append("<interface address=\"match-any\"/>");
        sb.append("</outage>");
        sb.append("</outages>");
        File file = new File("target/poll-outages.xml");
        FileWriter writer = new FileWriter(file);
        writer.write(sb.toString());
        writer.close();
        PollOutagesConfigFactory.setInstance((PollOutagesConfigFactory)new PollOutagesConfigFactory((org.springframework.core.io.Resource)new FileSystemResource(file)));
        PollOutagesConfigFactory.getInstance().afterPropertiesSet();
        this.initFactories("/threshd-configuration.xml", "/test-thresholds.xml");
        this.m_anticipatedEvents = new ArrayList<Event>();
    }

    private void initFactories(String threshd, String thresholds) throws Exception {
        LOG.info("Initialize Threshold Factories");
        ThresholdingConfigFactory.setInstance((ThresholdingConfigFactory)new ThresholdingConfigFactory(this.getClass().getResourceAsStream(thresholds)));
        ThreshdConfigFactory.setInstance((ThreshdConfigFactory)new ThreshdConfigFactory(this.getClass().getResourceAsStream(threshd)));
    }

    @After
    public void checkWarnings() throws Throwable {
        this.m_fileAnticipator.deleteExpected();
    }

    @After
    public void tearDown() throws Exception {
        EasyMock.verify((Object[])new Object[]{this.m_filterDao});
        this.m_fileAnticipator.deleteExpected(true);
        this.m_fileAnticipator.tearDown();
    }

    @Test
    public void testCreateVisitor() throws Exception {
        this.createVisitor();
    }

    @Test
    public void testResourceGaugeData() throws Exception {
        this.addHighThresholdEvent(1, 10000.0, 5000.0, 15000.0, "node", "node", "freeMem", null, null);
        ThresholdingVisitor visitor = this.createVisitor();
        this.runGaugeDataTest(visitor, 15000L);
        this.verifyEvents(0);
    }

    @Test
    public void testTriggersNodeResource() throws Exception {
        this.initFactories("/threshd-configuration.xml", "/test-thresholds-triggers.xml");
        this.addHighThresholdEvent(3, 10000.0, 5000.0, 22000.0, "node", "node", "freeMem", null, null);
        ThresholdingVisitor visitor = this.createVisitor();
        this.runGaugeDataTest(visitor, 15000L);
        this.runGaugeDataTest(visitor, 18000L);
        this.runGaugeDataTest(visitor, 8000L);
        this.runGaugeDataTest(visitor, 20000L);
        this.runGaugeDataTest(visitor, 21000L);
        this.runGaugeDataTest(visitor, 22000L);
        this.verifyEvents(0);
    }

    @Test
    public void testTriggersGenericResource() throws Exception {
        this.initFactories("/threshd-configuration.xml", "/test-thresholds-triggers.xml");
        ThresholdingVisitorIT.addEvent("uei.opennms.org/threshold/lowThresholdExceeded", "127.0.0.1", "SNMP", 3, 10.0, 15.0, 7.0, "/opt", "1", "hrStorageSize-hrStorageUsed", null, null, this.m_anticipator, this.m_anticipatedEvents);
        ThresholdingVisitor visitor = this.createVisitor();
        this.runFileSystemDataTest(visitor, 1, "/opt", 95L, 100L);
        this.runFileSystemDataTest(visitor, 1, "/opt", 96L, 100L);
        this.runFileSystemDataTest(visitor, 1, "/opt", 80L, 100L);
        this.runFileSystemDataTest(visitor, 1, "/opt", 91L, 100L);
        this.runFileSystemDataTest(visitor, 1, "/opt", 92L, 100L);
        this.runFileSystemDataTest(visitor, 1, "/opt", 93L, 100L);
        this.verifyEvents(0);
    }

    @Test
    public void testResourceCounterData() throws Exception {
        this.initFactories("/threshd-configuration.xml", "/test-thresholds-counters.xml");
        ThresholdingVisitor visitor = this.createVisitor();
        SnmpCollectionAgent agent = ThresholdingVisitorIT.createCollectionAgent();
        NodeResourceType resourceType = this.createNodeResourceType(agent);
        MibObject mibObject = ThresholdingVisitorIT.createMibObject("counter", "myCounter", "0");
        NumericAttributeType attributeType = new NumericAttributeType((ResourceType)resourceType, "default", mibObject, new AttributeGroupType("mibGroup", "ignore"));
        this.addHighThresholdEvent(1, 10.0, 5.0, 15.0, "node", "node", "myCounter", null, null);
        this.addHighRearmEvent(1, 10.0, 5.0, 2.0, "node", "node", "myCounter", null, null);
        long baseDate = new Date().getTime();
        visitor.visitCollectionSet(ThresholdingVisitorIT.createAnonymousCollectionSet(baseDate));
        NodeInfo resource = new NodeInfo(resourceType, (CollectionAgent)agent);
        resource.setAttributeValue((SnmpAttributeType)attributeType, SnmpUtils.getValueFactory().getCounter32(1000L));
        resource.visit((CollectionSetVisitor)visitor);
        visitor.visitCollectionSet(ThresholdingVisitorIT.createAnonymousCollectionSet(baseDate + 300000L));
        resource = new NodeInfo(resourceType, (CollectionAgent)agent);
        resource.setAttributeValue((SnmpAttributeType)attributeType, SnmpUtils.getValueFactory().getCounter32(5500L));
        resource.visit((CollectionSetVisitor)visitor);
        visitor.visitCollectionSet(ThresholdingVisitorIT.createAnonymousCollectionSet(baseDate + 600000L));
        resource = new NodeInfo(resourceType, (CollectionAgent)agent);
        resource.setAttributeValue((SnmpAttributeType)attributeType, SnmpUtils.getValueFactory().getCounter32(6100L));
        resource.visit((CollectionSetVisitor)visitor);
        EasyMock.verify((Object[])new Object[]{agent});
        this.verifyEvents(0);
    }

    @Test
    public void testZeroIntervalResourceCounterData() throws Exception {
        this.initFactories("/threshd-configuration.xml", "/test-thresholds-counters.xml");
        ThresholdingVisitor visitor = this.createVisitor();
        SnmpCollectionAgent agent = ThresholdingVisitorIT.createCollectionAgent();
        NodeResourceType resourceType = this.createNodeResourceType(agent);
        MibObject mibObject = ThresholdingVisitorIT.createMibObject("counter", "myCounter", "0");
        NumericAttributeType attributeType = new NumericAttributeType((ResourceType)resourceType, "default", mibObject, new AttributeGroupType("mibGroup", "ignore"));
        this.addHighThresholdEvent(1, 10.0, 5.0, 15.0, "node", "node", "myCounter", null, null);
        this.addHighRearmEvent(1, 10.0, 5.0, 2.0, "node", "node", "myCounter", null, null);
        long baseDate = new Date().getTime();
        visitor.visitCollectionSet(ThresholdingVisitorIT.createAnonymousCollectionSet(baseDate));
        NodeInfo resource = new NodeInfo(resourceType, (CollectionAgent)agent);
        resource.setAttributeValue((SnmpAttributeType)attributeType, SnmpUtils.getValueFactory().getCounter32(1000L));
        resource.visit((CollectionSetVisitor)visitor);
        visitor.visitCollectionSet(ThresholdingVisitorIT.createAnonymousCollectionSet(baseDate));
        resource = new NodeInfo(resourceType, (CollectionAgent)agent);
        resource.setAttributeValue((SnmpAttributeType)attributeType, SnmpUtils.getValueFactory().getCounter32(5500L));
        resource.visit((CollectionSetVisitor)visitor);
        visitor.visitCollectionSet(ThresholdingVisitorIT.createAnonymousCollectionSet(baseDate + 300000L));
        resource = new NodeInfo(resourceType, (CollectionAgent)agent);
        resource.setAttributeValue((SnmpAttributeType)attributeType, SnmpUtils.getValueFactory().getCounter32(5500L));
        resource.visit((CollectionSetVisitor)visitor);
        visitor.visitCollectionSet(ThresholdingVisitorIT.createAnonymousCollectionSet(baseDate + 600000L));
        resource = new NodeInfo(resourceType, (CollectionAgent)agent);
        resource.setAttributeValue((SnmpAttributeType)attributeType, SnmpUtils.getValueFactory().getCounter32(6100L));
        resource.visit((CollectionSetVisitor)visitor);
        EasyMock.verify((Object[])new Object[]{agent});
        this.verifyEvents(0);
    }

    @Test
    public void testInterfaceResourceWithDBAttributeFilter() throws Exception {
        Integer ifIndex = 1;
        Long ifSpeed = 10000000L;
        String ifName = "wlan0";
        this.addHighThresholdEvent(1, 90.0, 50.0, 120.0, ifName, ifIndex.toString(), "ifOutOctets", ifName, ifIndex.toString());
        this.addHighThresholdEvent(1, 90.0, 50.0, 120.0, ifName, ifIndex.toString(), "ifInOctets", ifName, ifIndex.toString());
        ThresholdingVisitor visitor = this.createVisitor();
        visitor.visitCollectionSet(ThresholdingVisitorIT.createAnonymousCollectionSet(new Date().getTime()));
        this.runInterfaceResource(visitor, "127.0.0.1", ifName, ifSpeed, ifIndex, 10000L, 46000L);
        this.verifyEvents(0);
    }

    @Test
    public void testInterfaceResourceWithStringAttributeFilter() throws Exception {
        Integer ifIndex = 1;
        Long ifSpeed = 10000000L;
        String ifName = "sis0";
        this.addHighThresholdEvent(1, 90.0, 50.0, 120.0, ifName, ifIndex.toString(), "ifOutOctets", ifName, ifIndex.toString());
        this.addHighThresholdEvent(1, 90.0, 50.0, 120.0, ifName, ifIndex.toString(), "ifInOctets", ifName, ifIndex.toString());
        ResourcePath path = ResourcePath.get((String[])new String[]{"snmp", "1", ifName});
        this.m_resourceStorageDao.setStringAttribute(path, "myMockParam", "myMockValue");
        ThresholdingVisitor visitor = this.createVisitor();
        visitor.visitCollectionSet(ThresholdingVisitorIT.createAnonymousCollectionSet(new Date().getTime()));
        this.runInterfaceResource(visitor, "127.0.0.1", ifName, ifSpeed, ifIndex, 10000L, 46000L);
        this.verifyEvents(0);
    }

    @Test
    public void testReloadThresholdsConfig() throws Exception {
        ThresholdingVisitor visitor = this.createVisitor();
        this.addHighThresholdEvent(1, 10000.0, 5000.0, 4500.0, "node", "node", "freeMem", null, null);
        this.runGaugeDataTest(visitor, 4500L);
        this.verifyEvents(1);
        this.initFactories("/threshd-configuration.xml", "/test-thresholds-2.xml");
        visitor.reload();
        this.resetAnticipator();
        this.addHighThresholdEvent(1, 4000.0, 2000.0, 4500.0, "node", "node", "freeMem", null, null);
        this.runGaugeDataTest(visitor, 4500L);
        this.verifyEvents(0);
    }

    @Test
    public void testReloadThreshdConfig() throws Exception {
        int i;
        int i2;
        String baseIpAddress = "10.0.0.";
        MockNetwork network = new MockNetwork();
        network.setCriticalService("ICMP");
        for (int i3 = 1; i3 <= 5; ++i3) {
            String ipAddress = baseIpAddress + i3;
            network.addNode(i3, "testNode-" + ipAddress);
            network.addInterface(ipAddress);
            network.setIfAlias("eth0");
            network.addService("ICMP");
            network.addService("SNMP");
            if (i3 != 5) continue;
            network.addService("HTTP");
        }
        network.addPathOutage(1, InetAddressUtils.addr((String)"192.168.1.1"), "ICMP");
        MockDatabase db = new MockDatabase();
        db.populate(network);
        db.update("insert into categories (categoryid, categoryname) values (?, ?)", new Object[]{10, "CAT1"});
        db.update("insert into categories (categoryid, categoryname) values (?, ?)", new Object[]{11, "CAT2"});
        for (i2 = 1; i2 <= 5; ++i2) {
            db.update("update snmpinterface set snmpifname=?, snmpifdescr=? where id=?", new Object[]{"eth0", "eth0", i2});
            db.update("update node set nodesysoid=? where nodeid=?", new Object[]{".1.3.6.1.4.1.9.1.222", i2});
        }
        for (i2 = 1; i2 <= 2; ++i2) {
            db.update("insert into category_node values (?, ?)", new Object[]{10, i2});
        }
        for (i2 = 3; i2 <= 5; ++i2) {
            db.update("insert into category_node values (?, ?)", new Object[]{11, i2});
        }
        DataSourceFactory.setInstance((DataSource)db);
        System.setProperty("opennms.home", "src/test/resources");
        DatabaseSchemaConfigFactory.init();
        JdbcFilterDao jdbcFilterDao = new JdbcFilterDao();
        jdbcFilterDao.setDataSource((DataSource)db);
        jdbcFilterDao.setDatabaseSchemaConfigFactory((DatabaseSchemaConfig)DatabaseSchemaConfigFactory.getInstance());
        jdbcFilterDao.afterPropertiesSet();
        FilterDaoFactory.setInstance((FilterDao)jdbcFilterDao);
        this.initFactories("/threshd-configuration-reload-use-case-a.xml", "/test-thresholds-reload-use-cases.xml");
        System.err.println("-----------------------------------------------------------------------------------");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("thresholding-enabled", "true");
        ServiceParameters svcParams = new ServiceParameters(params);
        ArrayList<ThresholdingVisitor> visitors = new ArrayList<ThresholdingVisitor>();
        for (i = 1; i <= 5; ++i) {
            String ipAddress = baseIpAddress + i;
            ThresholdingVisitor visitor = ThresholdingVisitor.create((int)i, (String)ipAddress, (String)"SNMP", (RrdRepository)this.getRepository(), (ServiceParameters)svcParams, (ResourceStorageDao)this.m_resourceStorageDao);
            Assert.assertNotNull((Object)visitor);
            visitors.add(visitor);
            if (i != 5) continue;
            ThresholdingVisitor httpVisitor = ThresholdingVisitor.create((int)i, (String)ipAddress, (String)"HTTP", (RrdRepository)this.getRepository(), (ServiceParameters)svcParams, (ResourceStorageDao)this.m_resourceStorageDao);
            Assert.assertNotNull((Object)httpVisitor);
            visitors.add(httpVisitor);
        }
        System.err.println("-----------------------------------------------------------------------------------");
        for (i = 0; i < 2; ++i) {
            Assert.assertTrue((boolean)((ThresholdingVisitor)visitors.get(i)).hasThresholds());
            Assert.assertEquals((long)1L, (long)((ThresholdingVisitor)visitors.get(i)).getThresholdGroups().size());
        }
        for (i = 2; i < 6; ++i) {
            Assert.assertFalse((boolean)((ThresholdingVisitor)visitors.get(i)).hasThresholds());
            Assert.assertEquals((long)0L, (long)((ThresholdingVisitor)visitors.get(i)).getThresholdGroups().size());
        }
        this.initFactories("/threshd-configuration-reload-use-case-b.xml", "/test-thresholds-reload-use-cases.xml");
        System.err.println("-----------------------------------------------------------------------------------");
        for (ThresholdingVisitor visitor : visitors) {
            visitor.reload();
        }
        System.err.println("-----------------------------------------------------------------------------------");
        for (int i4 = 0; i4 < 6; ++i4) {
            Assert.assertTrue((boolean)((ThresholdingVisitor)visitors.get(i4)).hasThresholds());
            Assert.assertEquals((long)1L, (long)((ThresholdingVisitor)visitors.get(i4)).getThresholdGroups().size());
            if (i4 != 5) continue;
            Assert.assertEquals((Object)"web-services", (Object)((ThresholdGroup)((ThresholdingVisitor)visitors.get(i4)).getThresholdGroups().get(0)).getName());
        }
    }

    @Test
    public void testBug2746() throws Exception {
        this.initFactories("/threshd-configuration.xml", "/test-thresholds-bug2746.xml");
        ThresholdingVisitor visitor = this.createVisitor();
        SnmpCollectionAgent agent = ThresholdingVisitorIT.createCollectionAgent();
        NodeResourceType resourceType = this.createNodeResourceType(agent);
        MibObject mibObject = ThresholdingVisitorIT.createMibObject("gauge", "bug2746", "0");
        NumericAttributeType attributeType = new NumericAttributeType((ResourceType)resourceType, "default", mibObject, new AttributeGroupType("mibGroup", "ignore"));
        this.addHighThresholdEvent(1, 50.0, 40.0, 60.0, "node", "node", "bug2746", null, null);
        NodeInfo resource = new NodeInfo(resourceType, (CollectionAgent)agent);
        resource.setAttributeValue((SnmpAttributeType)attributeType, SnmpUtils.getValueFactory().getGauge32(20L));
        resource.visit((CollectionSetVisitor)visitor);
        resource.visit((CollectionSetVisitor)visitor);
        resource.visit((CollectionSetVisitor)visitor);
        resource.visit((CollectionSetVisitor)visitor);
        resource = new NodeInfo(resourceType, (CollectionAgent)agent);
        resource.setAttributeValue((SnmpAttributeType)attributeType, SnmpUtils.getValueFactory().getGauge32(60L));
        resource.visit((CollectionSetVisitor)visitor);
        resource = new NodeInfo(resourceType, (CollectionAgent)agent);
        resource.setAttributeValue((SnmpAttributeType)attributeType, SnmpUtils.getValueFactory().getGauge32(45L));
        resource.visit((CollectionSetVisitor)visitor);
        resource = new NodeInfo(resourceType, (CollectionAgent)agent);
        resource.setAttributeValue((SnmpAttributeType)attributeType, SnmpUtils.getValueFactory().getGauge32(55L));
        resource.visit((CollectionSetVisitor)visitor);
        EasyMock.verify((Object[])new Object[]{agent});
        this.verifyEvents(0);
    }

    @Test
    public void testBug3146_unrelatedChange() throws Exception {
        ThresholdingVisitor visitor = this.createVisitor();
        this.addHighThresholdEvent(1, 10000.0, 5000.0, 12000.0, "node", "node", "freeMem", null, null);
        this.addHighRearmEvent(1, 10000.0, 5000.0, 1000.0, "node", "node", "freeMem", null, null);
        this.runGaugeDataTest(visitor, 12000L);
        visitor.reload();
        this.runGaugeDataTest(visitor, 1000L);
        this.verifyEvents(0);
    }

    @Test
    public void testBug3146_reduceTrigger() throws Exception {
        ThresholdingVisitor visitor = this.createVisitor();
        this.addHighThresholdEvent(1, 10000.0, 5000.0, 12000.0, "node", "node", "freeMem", null, null);
        this.addHighRearmEvent(1, 10000.0, 5000.0, Double.NaN, "node", "node", "freeMem", null, null);
        this.addHighThresholdEvent(1, 4000.0, 2000.0, 5000.0, "node", "node", "freeMem", null, null);
        this.addHighRearmEvent(1, 4000.0, 2000.0, 1000.0, "node", "node", "freeMem", null, null);
        this.runGaugeDataTest(visitor, 12000L);
        this.initFactories("/threshd-configuration.xml", "/test-thresholds-2.xml");
        visitor.reload();
        this.runGaugeDataTest(visitor, 5000L);
        this.runGaugeDataTest(visitor, 1000L);
        this.verifyEvents(0);
    }

    @Test
    public void testBug3146_inceaseTrigger() throws Exception {
        ThresholdingVisitor visitor = this.createVisitor();
        this.addHighThresholdEvent(1, 10000.0, 5000.0, 12000.0, "node", "node", "freeMem", null, null);
        this.addHighRearmEvent(1, 10000.0, 5000.0, Double.NaN, "node", "node", "freeMem", null, null);
        this.runGaugeDataTest(visitor, 12000L);
        this.initFactories("/threshd-configuration.xml", "/test-thresholds-3.xml");
        visitor.reload();
        this.verifyEvents(0);
        this.resetAnticipator();
        this.addHighThresholdEvent(1, 15000.0, 14000.0, 13000.0, "node", "node", "freeMem", null, null);
        this.runGaugeDataTest(visitor, 13000L);
        this.verifyEvents(1);
        this.resetAnticipator();
        this.addHighThresholdEvent(1, 15000.0, 14000.0, 16000.0, "node", "node", "freeMem", null, null);
        this.addHighRearmEvent(1, 15000.0, 14000.0, 1000.0, "node", "node", "freeMem", null, null);
        this.runGaugeDataTest(visitor, 16000L);
        this.runGaugeDataTest(visitor, 1000L);
        this.verifyEvents(0);
    }

    @Test
    public void testBug3146_replaceThreshold() throws Exception {
        ThresholdingVisitor visitor = this.createVisitor();
        String lowThresholdUei = "uei.opennms.org/threshold/lowThresholdExceeded";
        String highExpression = "(((hrStorageAllocUnits*hrStorageUsed)/(hrStorageAllocUnits*hrStorageSize))*100)";
        String lowExpression = "(100-((hrStorageAllocUnits*hrStorageUsed)/(hrStorageAllocUnits*hrStorageSize))*100)";
        this.addHighThresholdEvent(1, 30.0, 25.0, 50.0, "/opt", "1", highExpression, null, null);
        this.addHighRearmEvent(1, 30.0, 25.0, Double.NaN, "/opt", "1", highExpression, null, null);
        ThresholdingVisitorIT.addEvent(lowThresholdUei, "127.0.0.1", "SNMP", 1, 10.0, 20.0, 5.0, "/opt", "1", lowExpression, null, null, this.m_anticipator, this.m_anticipatedEvents);
        this.runFileSystemDataTest(visitor, 1, "/opt", 500L, 1000L);
        this.initFactories("/threshd-configuration.xml", "/test-thresholds-4.xml");
        visitor.reload();
        this.runFileSystemDataTest(visitor, 1, "/opt", 950L, 1000L);
        this.verifyEvents(0);
    }

    @Test
    public void testBug3193() throws Exception {
        this.initFactories("/threshd-configuration.xml", "/test-thresholds-bug3193.xml");
        ThresholdingVisitor visitor = this.createVisitor();
        SnmpCollectionAgent agent = ThresholdingVisitorIT.createCollectionAgent();
        NodeResourceType resourceType = this.createNodeResourceType(agent);
        MibObject mibObject = ThresholdingVisitorIT.createMibObject("counter", "myCounter", "0");
        NumericAttributeType attributeType = new NumericAttributeType((ResourceType)resourceType, "default", mibObject, new AttributeGroupType("mibGroup", "ignore"));
        this.addHighThresholdEvent(1, 100.0, 90.0, 110.0, "node", "node", "myCounter", null, null);
        this.addHighThresholdEvent(1, 70.0, 60.0, 80.0, "node", "node", "myCounter - 30", null, null);
        this.addHighRearmEvent(1, 100.0, 90.0, 40.0, "node", "node", "myCounter", null, null);
        this.addHighRearmEvent(1, 70.0, 60.0, 10.0, "node", "node", "myCounter - 30", null, null);
        long baseDate = new Date().getTime();
        visitor.visitCollectionSet(ThresholdingVisitorIT.createAnonymousCollectionSet(baseDate));
        NodeInfo resource = new NodeInfo(resourceType, (CollectionAgent)agent);
        resource.setAttributeValue((SnmpAttributeType)attributeType, SnmpUtils.getValueFactory().getCounter32(2000L));
        resource.visit((CollectionSetVisitor)visitor);
        visitor.visitCollectionSet(ThresholdingVisitorIT.createAnonymousCollectionSet(baseDate + 300000L));
        resource = new NodeInfo(resourceType, (CollectionAgent)agent);
        resource.setAttributeValue((SnmpAttributeType)attributeType, SnmpUtils.getValueFactory().getCounter32(20000L));
        resource.visit((CollectionSetVisitor)visitor);
        visitor.visitCollectionSet(ThresholdingVisitorIT.createAnonymousCollectionSet(baseDate + 600000L));
        resource = new NodeInfo(resourceType, (CollectionAgent)agent);
        resource.setAttributeValue((SnmpAttributeType)attributeType, SnmpUtils.getValueFactory().getCounter32(53000L));
        resource.visit((CollectionSetVisitor)visitor);
        visitor.visitCollectionSet(ThresholdingVisitorIT.createAnonymousCollectionSet(baseDate + 900000L));
        resource = new NodeInfo(resourceType, (CollectionAgent)agent);
        resource.setAttributeValue((SnmpAttributeType)attributeType, SnmpUtils.getValueFactory().getCounter32(65000L));
        resource.visit((CollectionSetVisitor)visitor);
        EasyMock.verify((Object[])new Object[]{agent});
        this.verifyEvents(0);
    }

    @Test
    public void testBug2711_noIpAddress() throws Exception {
        this.runTestForBug2711(2, 0);
    }

    @Test
    public void testBug2711_noIP_badIfIndex() throws Exception {
        this.runTestForBug2711(-100, 2);
    }

    @Test
    public void testBug3227() throws Exception {
        this.initFactories("/threshd-configuration.xml", "/test-thresholds-bug3227.xml");
        ThresholdingVisitor visitor = this.createVisitor();
        SnmpCollectionAgent agent = ThresholdingVisitorIT.createCollectionAgent();
        GenericIndexResourceType resourceType = this.createGenericIndexResourceType(agent, "frCircuitIfIndex");
        SnmpInstId inst = new SnmpInstId(100);
        GenericIndexResource resource = new GenericIndexResource((ResourceType)resourceType, "frCircuitIfIndex", inst);
        ThresholdingVisitorIT.addAttributeToCollectionResource((SnmpCollectionResource)resource, (ResourceType)resourceType, "frReceivedOctets", "counter", "frCircuitIfIndex", 1000L);
        ThresholdingVisitorIT.addAttributeToCollectionResource((SnmpCollectionResource)resource, (ResourceType)resourceType, "frSentOctets", "counter", "frCircuitIfIndex", 1000L);
        resource.visit((CollectionSetVisitor)visitor);
    }

    @Test
    public void testBug3194_32bits() throws Exception {
        this.runCounterWrapTest(32.0, 200.0);
    }

    @Test
    public void testBug3194_64bits() throws Exception {
        this.runCounterWrapTest(64.0, 201.6);
    }

    @Test
    public void testBug3333() throws Exception {
        this.initFactories("/threshd-configuration.xml", "/test-thresholds-bug3333.xml");
        ThresholdingVisitor visitor = this.createVisitor();
        String expression = "hrStorageSize-hrStorageUsed";
        ThresholdingVisitorIT.addEvent("uei.opennms.org/threshold/lowThresholdExceeded", "127.0.0.1", "SNMP", 1, 10.0, 15.0, 5.0, "/opt", "1", expression, null, null, this.m_anticipator, this.m_anticipatedEvents);
        this.runFileSystemDataTest(visitor, 1, "/opt", 95L, 100L);
        this.verifyEvents(0);
        ThresholdingVisitorIT.addEvent("uei.opennms.org/threshold/lowThresholdRearmed", "127.0.0.1", "SNMP", 1, 10.0, 15.0, 60.0, "/opt", "1", expression, null, null, this.m_anticipator, this.m_anticipatedEvents);
        this.addHighThresholdEvent(1, 50.0, 45.0, 60.0, "/opt", "1", expression, null, null);
        this.runFileSystemDataTest(visitor, 1, "/opt", 40L, 100L);
        this.verifyEvents(0);
    }

    @Test
    public void testBug3390() throws Exception {
        this.initFactories("/threshd-configuration-bug3390.xml", "/test-thresholds-bug3390.xml");
        ThreshdConfigFactory configManager = ThreshdConfigFactory.getInstance();
        List packages = configManager.getConfiguration().getPackages();
        Assert.assertEquals((long)1L, (long)packages.size());
        Package pkg = (Package)packages.get(0);
        List services = pkg.getServices();
        Assert.assertEquals((long)1L, (long)services.size());
        Service svc = (Service)services.get(0);
        List parameters = svc.getParameters();
        Assert.assertEquals((long)5L, (long)parameters.size());
        int count = 0;
        for (Parameter parameter : parameters) {
            if (!parameter.getKey().equals("thresholding-group")) continue;
            ++count;
        }
        Assert.assertEquals((long)5L, (long)count);
        ThresholdingVisitor visitor = this.createVisitor();
        Assert.assertEquals((long)5L, (long)visitor.getThresholdGroups().size());
    }

    @Test
    public void testBug3554_withMockFilterDao() throws Exception {
        this.initFactories("/threshd-configuration-bug3554.xml", "/test-thresholds-bug3554.xml");
        ThresholdingVisitor visitor = this.createVisitor();
        visitor.visitCollectionSet(ThresholdingVisitorIT.createAnonymousCollectionSet(new Date().getTime()));
        this.runInterfaceResource(visitor, "127.0.0.1", "eth0", 10000000L, 1, 10000L, 46000L);
        this.runGaugeDataTest(visitor, 12000L);
        SnmpCollectionAgent agent = ThresholdingVisitorIT.createCollectionAgent();
        GenericIndexResourceType resourceType = this.createGenericIndexResourceType(agent, "ciscoEnvMonTemperatureStatusIndex");
        GenericIndexResource resource = new GenericIndexResource((ResourceType)resourceType, "ciscoEnvMonTemperatureStatusIndex", new SnmpInstId(45));
        resource.visit((CollectionSetVisitor)visitor);
        EasyMock.verify((Object[])new Object[]{agent});
    }

    @Test
    public void testBug3554_withDBFilterDao() throws Exception {
        this.runTestForBug3554();
    }

    @Test
    public void testBug3720() throws Exception {
        this.runTestForBug3554();
        HashSet<Object> filters = new HashSet<Object>();
        for (Package pkg : ThreshdConfigFactory.getInstance().getConfiguration().getPackages()) {
            filters.add(pkg.getFilter().getContent().orElse(null));
        }
    }

    @Test
    public void testBug3748() throws Exception {
        this.initFactories("/threshd-configuration-bug3748.xml", "/test-thresholds-bug3748.xml");
        ThresholdingVisitorIT.addEvent("uei.opennms.org/threshold/absoluteChangeExceeded", "127.0.0.1", "SNMP", 1, null, null, 6.0, "node", "node", "freeMem", null, null, this.m_anticipator, this.m_anticipatedEvents);
        ThresholdingVisitor visitor = this.createVisitor();
        this.runGaugeDataTest(visitor, 2L);
        this.runGaugeDataTest(visitor, 6L);
        this.verifyEvents(0);
    }

    @Test
    public void testNMS5115() throws Exception {
        this.initFactories("/threshd-configuration.xml", "/test-thresholds-NMS5115.xml");
        ThresholdingVisitorIT.addEvent("uei.opennms.org/threshold/lowThresholdExceeded", "127.0.0.1", "SNMP", 1, null, null, 5.0, "node", "node", "memAvailSwap / memTotalSwap * 100.0", null, null, this.m_anticipator, this.m_anticipatedEvents);
        ThresholdingVisitor visitor = this.createVisitor();
        SnmpCollectionAgent agent = ThresholdingVisitorIT.createCollectionAgent();
        NodeResourceType resourceType = this.createNodeResourceType(agent);
        NodeInfo resource = new NodeInfo(resourceType, (CollectionAgent)agent);
        ThresholdingVisitorIT.addAttributeToCollectionResource((SnmpCollectionResource)resource, (ResourceType)resourceType, "memAvailSwap", "gauge", "0", 5L);
        ThresholdingVisitorIT.addAttributeToCollectionResource((SnmpCollectionResource)resource, (ResourceType)resourceType, "memTotalSwap", "gauge", "0", 100L);
        resource.visit((CollectionSetVisitor)visitor);
        EasyMock.verify((Object[])new Object[]{agent});
        this.verifyEvents(0);
    }

    private void runTestForBug2711(Integer ifIndex, Integer remainingEvents) throws Exception {
        Long ifSpeed = 10000000L;
        String ifName = "wlan0";
        this.initFactories("/threshd-configuration.xml", "/test-thresholds-2.xml");
        ThresholdingVisitorIT.addEvent("uei.opennms.org/threshold/highThresholdExceeded", "127.0.0.1", "SNMP", 1, 90.0, 50.0, 120.0, ifName, ifIndex.toString(), "ifOutOctets", ifName, ifIndex.toString(), this.m_anticipator, this.m_anticipatedEvents);
        ThresholdingVisitorIT.addEvent("uei.opennms.org/threshold/highThresholdExceeded", "127.0.0.1", "SNMP", 1, 90.0, 50.0, 120.0, ifName, ifIndex.toString(), "ifInOctets", ifName, ifIndex.toString(), this.m_anticipator, this.m_anticipatedEvents);
        ThresholdingVisitor visitor = this.createVisitor();
        visitor.visitCollectionSet(ThresholdingVisitorIT.createAnonymousCollectionSet(new Date().getTime()));
        this.runInterfaceResource(visitor, "0.0.0.0", ifName, ifSpeed, ifIndex, 10000L, 46000L);
        this.verifyEvents(remainingEvents);
    }

    private void runTestForBug3554() throws Exception {
        MockLogAppender.resetState();
        System.err.println("----------------------------------------------------------------------------------- begin test");
        String baseIpAddress = "10.0.0.";
        int numOfNodes = 5;
        MockNetwork network = new MockNetwork();
        network.setCriticalService("ICMP");
        for (int i = 1; i <= numOfNodes; ++i) {
            String ipAddress = baseIpAddress + i;
            network.addNode(i, "testNode-" + ipAddress);
            network.addInterface(ipAddress);
            network.setIfAlias("eth0");
            network.addService("ICMP");
            network.addService("SNMP");
        }
        network.addPathOutage(1, InetAddressUtils.addr((String)"192.168.1.1"), "ICMP");
        MockDatabase db = new MockDatabase();
        db.populate(network);
        db.update("insert into categories (categoryid, categoryname) values (?, ?)", new Object[]{10, "IPRA"});
        db.update("insert into categories (categoryid, categoryname) values (?, ?)", new Object[]{11, "NAS"});
        for (int i = 1; i <= numOfNodes; ++i) {
            db.update("update snmpinterface set snmpifname=?, snmpifdescr=? where id=?", new Object[]{"eth0", "eth0", i});
            db.update("update node set nodesysoid=? where nodeid=?", new Object[]{".1.3.6.1.4.1.9.1.222", i});
            db.update("insert into category_node values (?, ?)", new Object[]{10, i});
            db.update("insert into category_node values (?, ?)", new Object[]{11, i});
        }
        DataSourceFactory.setInstance((DataSource)db);
        System.setProperty("opennms.home", "src/test/resources");
        DatabaseSchemaConfigFactory.init();
        JdbcFilterDao jdbcFilterDao = new JdbcFilterDao();
        jdbcFilterDao.setDataSource((DataSource)db);
        jdbcFilterDao.setDatabaseSchemaConfigFactory((DatabaseSchemaConfig)DatabaseSchemaConfigFactory.getInstance());
        jdbcFilterDao.afterPropertiesSet();
        FilterDaoFactory.setInstance((FilterDao)jdbcFilterDao);
        this.initFactories("/threshd-configuration-bug3554.xml", "/test-thresholds-bug3554.xml");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("thresholding-enabled", "true");
        ServiceParameters svcParams = new ServiceParameters(params);
        for (int i = 1; i <= numOfNodes; ++i) {
            System.err.println("----------------------------------------------------------------------------------- visitor #" + i);
            String ipAddress = baseIpAddress + i;
            ThresholdingVisitor visitor = ThresholdingVisitor.create((int)1, (String)ipAddress, (String)"SNMP", (RrdRepository)this.getRepository(), (ServiceParameters)svcParams, (ResourceStorageDao)this.m_resourceStorageDao);
            Assert.assertNotNull((Object)visitor);
            Assert.assertEquals((long)4L, (long)visitor.getThresholdGroups().size());
        }
        System.err.println("----------------------------------------------------------------------------------- end");
    }

    @Test
    public void testBug3487() throws Exception {
        this.initFactories("/threshd-configuration-bug3487.xml", "/test-thresholds.xml");
        Assert.assertNotNull((Object)this.createVisitor());
    }

    @Test
    public void testBug3428_noMatch() throws Exception {
        this.initFactories("/threshd-configuration.xml", "/test-thresholds-bug3428.xml");
        Integer ifIndex = 1;
        Long ifSpeed = 10000000L;
        String ifName = "wlan0";
        this.addHighThresholdEvent(1, 90.0, 50.0, 120.0, "Unknown", ifIndex.toString(), "ifInOctets", ifName, ifIndex.toString());
        ThresholdingVisitor visitor = this.createVisitor();
        visitor.visitCollectionSet(ThresholdingVisitorIT.createAnonymousCollectionSet(new Date().getTime()));
        this.runInterfaceResource(visitor, "127.0.0.1", ifName, ifSpeed, ifIndex, 10000L, 46000L);
        this.verifyEvents(1);
    }

    @Test
    public void testBug3428_match() throws Exception {
        this.initFactories("/threshd-configuration.xml", "/test-thresholds-bug3428.xml");
        Integer ifIndex = 1;
        Long ifSpeed = 100000000L;
        String ifName = "wlan0";
        this.addHighThresholdEvent(1, 90.0, 50.0, 120.0, ifName, ifIndex.toString(), "ifInOctets", ifName, ifIndex.toString());
        ThresholdingVisitor visitor = this.createVisitor();
        visitor.visitCollectionSet(ThresholdingVisitorIT.createAnonymousCollectionSet(new Date().getTime()));
        this.runInterfaceResource(visitor, "127.0.0.1", ifName, ifSpeed, ifIndex, 10000L, 46000L);
        this.verifyEvents(0);
    }

    @Test
    public void testBug3664() throws Exception {
        this.initFactories("/threshd-configuration.xml", "/test-thresholds-bug3664.xml");
        Integer ifIndex = 1;
        Long ifSpeed = 10000000L;
        String ifName = "wlan0";
        String domain = "myDomain";
        String ifAlias = ifName;
        String ifAliasComment = "#";
        String label = domain + "/" + ifAlias;
        this.addHighThresholdEvent(1, 90.0, 50.0, 120.0, label, "Unknown", "ifOutOctets", label, ifIndex.toString());
        this.addHighThresholdEvent(1, 90.0, 50.0, 120.0, label, "Unknown", "ifInOctets", label, ifIndex.toString());
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("thresholding-enabled", "true");
        params.put("storeByIfAlias", "true");
        ThresholdingVisitor visitor = this.createVisitor(params);
        SnmpIfData ifData = ThresholdingVisitorIT.createSnmpIfData("127.0.0.1", ifName, ifSpeed, ifIndex, true);
        SnmpCollectionAgent agent = ThresholdingVisitorIT.createCollectionAgent();
        IfResourceType resourceType = this.createInterfaceResourceType(agent);
        long timestamp = new Date().getTime();
        visitor.visitCollectionSet(ThresholdingVisitorIT.createAnonymousCollectionSet(timestamp));
        IfInfo ifInfo = new IfInfo((ResourceType)resourceType, (CollectionAgent)agent, ifData);
        ThresholdingVisitorIT.addAttributeToCollectionResource((SnmpCollectionResource)ifInfo, (ResourceType)resourceType, "ifInOctets", "counter", "ifIndex", 10000L);
        ThresholdingVisitorIT.addAttributeToCollectionResource((SnmpCollectionResource)ifInfo, (ResourceType)resourceType, "ifOutOctets", "counter", "ifIndex", 10000L);
        AliasedResource resource = new AliasedResource((ResourceType)resourceType, domain, ifInfo, ifAliasComment, ifAlias);
        resource.visit((CollectionSetVisitor)visitor);
        visitor.visitCollectionSet(ThresholdingVisitorIT.createAnonymousCollectionSet(timestamp + 300000L));
        ifInfo = new IfInfo((ResourceType)resourceType, (CollectionAgent)agent, ifData);
        ThresholdingVisitorIT.addAttributeToCollectionResource((SnmpCollectionResource)ifInfo, (ResourceType)resourceType, "ifInOctets", "counter", "ifIndex", 46000L);
        ThresholdingVisitorIT.addAttributeToCollectionResource((SnmpCollectionResource)ifInfo, (ResourceType)resourceType, "ifOutOctets", "counter", "ifIndex", 46000L);
        resource = new AliasedResource((ResourceType)resourceType, domain, ifInfo, ifAliasComment, ifAlias);
        resource.visit((CollectionSetVisitor)visitor);
        EasyMock.verify((Object[])new Object[]{agent});
        this.verifyEvents(0);
    }

    @Test
    public void testBug4261_scheduledOutages() throws Exception {
        this.initFactories("/threshd-configuration-outages.xml", "/test-thresholds.xml");
        ThresholdingVisitor visitor = this.createVisitor();
        Assert.assertEquals((long)1L, (long)visitor.getScheduledOutages().size());
        Assert.assertTrue((String)"is node on outage", (boolean)visitor.isNodeInOutage());
    }

    @Test
    public void testBug5258() throws Exception {
        this.initFactories("/threshd-configuration.xml", "/test-thresholds-bug5258-a.xml");
        ThresholdingVisitor visitor = this.createVisitor();
        ThresholdingVisitorIT.addEvent("uei.opennms.org/threshold/highThresholdExceeded", "127.0.0.1", "SNMP", 1, 50.0, 45.0, 65.0, "/opt", "1", "hrStorageUsed", null, null, this.m_anticipator, this.m_anticipatedEvents);
        ThresholdingVisitorIT.addEvent("uei.opennms.org/threshold/highThresholdExceeded", "127.0.0.1", "SNMP", 1, 50.0, 45.0, 70.0, "/var", "1", "hrStorageUsed", null, null, this.m_anticipator, this.m_anticipatedEvents);
        ThresholdingVisitorIT.addEvent("uei.opennms.org/threshold/highThresholdRearmed", "127.0.0.1", "SNMP", 1, 50.0, 45.0, Double.NaN, "/opt", "1", "hrStorageUsed", null, null, this.m_anticipator, this.m_anticipatedEvents);
        this.runFileSystemDataTest(visitor, 1, "/opt", 65L, 100L);
        this.initFactories("/threshd-configuration.xml", "/test-thresholds-bug5258-b.xml");
        visitor.reload();
        this.runFileSystemDataTest(visitor, 1, "/var", 70L, 100L);
        this.verifyEvents(0);
    }

    @Test
    public void testBug5764() throws Exception {
        ThresholdingVisitor visitor = this.createVisitor();
        this.initFactories("/threshd-configuration.xml", "/test-thresholds-bug5764.xml");
        visitor.reload();
    }

    @Test
    public void testIgnoreAliasedResources() throws Exception {
        this.initFactories("/threshd-configuration.xml", "/test-thresholds-bug3664.xml");
        Integer ifIndex = 1;
        Long ifSpeed = 10000000L;
        String ifName = "wlan0";
        String domain = "myDomain";
        String ifAlias = ifName;
        String ifAliasComment = "#";
        ThresholdingVisitor visitor = this.createVisitor();
        SnmpIfData ifData = ThresholdingVisitorIT.createSnmpIfData("127.0.0.1", ifName, ifSpeed, ifIndex, true);
        SnmpCollectionAgent agent = ThresholdingVisitorIT.createCollectionAgent();
        IfResourceType resourceType = this.createInterfaceResourceType(agent);
        IfInfo ifInfo = new IfInfo((ResourceType)resourceType, (CollectionAgent)agent, ifData);
        ThresholdingVisitorIT.addAttributeToCollectionResource((SnmpCollectionResource)ifInfo, (ResourceType)resourceType, "ifInOctets", "counter", "ifIndex", 10000L);
        ThresholdingVisitorIT.addAttributeToCollectionResource((SnmpCollectionResource)ifInfo, (ResourceType)resourceType, "ifOutOctets", "counter", "ifIndex", 10000L);
        AliasedResource resource = new AliasedResource((ResourceType)resourceType, domain, ifInfo, ifAliasComment, ifAlias);
        resource.visit((CollectionSetVisitor)visitor);
        ifInfo = new IfInfo((ResourceType)resourceType, (CollectionAgent)agent, ifData);
        ThresholdingVisitorIT.addAttributeToCollectionResource((SnmpCollectionResource)ifInfo, (ResourceType)resourceType, "ifInOctets", "counter", "ifIndex", 46000L);
        ThresholdingVisitorIT.addAttributeToCollectionResource((SnmpCollectionResource)ifInfo, (ResourceType)resourceType, "ifOutOctets", "counter", "ifIndex", 46000L);
        resource = new AliasedResource((ResourceType)resourceType, domain, ifInfo, ifAliasComment, ifAlias);
        resource.visit((CollectionSetVisitor)visitor);
        EasyMock.verify((Object[])new Object[]{agent});
        this.verifyEvents(0);
    }

    @Test
    public void testDisabledCollection() throws Exception {
        this.initFactories("/threshd-configuration.xml", "/test-thresholds-bug3428.xml");
        Integer ifIndex = 1;
        Long ifSpeed = 100000000L;
        String ifName = "wlan0";
        this.addHighThresholdEvent(1, 90.0, 50.0, 120.0, ifName, ifIndex.toString(), "ifInOctets", ifName, ifIndex.toString());
        SnmpIfData ifData = ThresholdingVisitorIT.createSnmpIfData("127.0.0.1", ifName, ifSpeed, ifIndex, false);
        SnmpCollectionAgent agent = ThresholdingVisitorIT.createCollectionAgent();
        IfResourceType resourceType = this.createInterfaceResourceType(agent);
        ThresholdingVisitor visitor = this.createVisitor();
        IfInfo resource = new IfInfo((ResourceType)resourceType, (CollectionAgent)agent, ifData);
        ThresholdingVisitorIT.addAttributeToCollectionResource((SnmpCollectionResource)resource, (ResourceType)resourceType, "ifInOctets", "counter", "ifIndex", 10000L);
        ThresholdingVisitorIT.addAttributeToCollectionResource((SnmpCollectionResource)resource, (ResourceType)resourceType, "ifOutOctets", "counter", "ifIndex", 10000L);
        resource.visit((CollectionSetVisitor)visitor);
        resource = new IfInfo((ResourceType)resourceType, (CollectionAgent)agent, ifData);
        ThresholdingVisitorIT.addAttributeToCollectionResource((SnmpCollectionResource)resource, (ResourceType)resourceType, "ifInOctets", "counter", "ifIndex", 46000L);
        ThresholdingVisitorIT.addAttributeToCollectionResource((SnmpCollectionResource)resource, (ResourceType)resourceType, "ifOutOctets", "counter", "ifIndex", 46000L);
        resource.visit((CollectionSetVisitor)visitor);
        EasyMock.verify((Object[])new Object[]{agent});
        this.verifyEvents(1);
    }

    @Test
    public void testThresholdFiltersOnGenericResource() throws Exception {
        ThresholdingVisitor visitor = this.createVisitor();
        String highExpression = "(((hrStorageAllocUnits*hrStorageUsed)/(hrStorageAllocUnits*hrStorageSize))*100)";
        this.addHighThresholdEvent(1, 30.0, 25.0, 50.0, "/opt", "1", highExpression, null, null);
        this.addHighThresholdEvent(1, 30.0, 25.0, 60.0, "/opt01", "2", highExpression, null, null);
        this.runFileSystemDataTest(visitor, 1, "/opt", 50L, 100L);
        this.runFileSystemDataTest(visitor, 2, "/opt01", 60L, 100L);
        this.runFileSystemDataTest(visitor, 3, "/home", 70L, 100L);
        this.verifyEvents(0);
    }

    @Test
    public void testNumericThresholdFiltersOnGenericResource() throws Exception {
        this.initFactories("/threshd-configuration.xml", "/test-thresholds-numeric-filter.xml");
        ThresholdingVisitor visitor = this.createVisitor();
        this.addHighThresholdEvent(1, 30.0, 25.0, 50.0, "/opt", "1", "hrStorageUsed", null, null);
        this.runFileSystemDataTest(visitor, 1, "/opt", 50L, 100L);
        this.verifyEvents(0);
    }

    @Test
    public void testThresholdsFiltersOnNodeResource() throws Exception {
        this.initFactories("/threshd-configuration.xml", "/test-thresholds-5.xml");
        ThresholdingVisitor visitor = this.createVisitor();
        this.addHighThresholdEvent(1, 30.0, 25.0, 50.0, "/home", "node", "(hda1_hrStorageUsed/hda1_hrStorageSize)*100", null, null);
        this.addHighThresholdEvent(1, 50.0, 45.0, 60.0, "/opt", "node", "(hda2_hrStorageUsed/hda2_hrStorageSize)*100", null, null);
        SnmpCollectionAgent agent = ThresholdingVisitorIT.createCollectionAgent();
        MockDataCollectionConfig dataCollectionConfig = new MockDataCollectionConfig();
        OnmsSnmpCollection collection = new OnmsSnmpCollection(agent, new ServiceParameters(new HashMap()), (DataCollectionConfigDao)dataCollectionConfig, this.m_locationAwareSnmpClient);
        NodeResourceType resourceType = new NodeResourceType(agent, collection);
        ResourcePath path = ResourcePath.get((String[])new String[]{"snmp", "1"});
        this.m_resourceStorageDao.setStringAttribute(path, "hda1_hrStorageDescr", "/home");
        this.m_resourceStorageDao.setStringAttribute(path, "hda2_hrStorageDescr", "/opt");
        this.m_resourceStorageDao.setStringAttribute(path, "hda3_hrStorageDescr", "/usr");
        NodeInfo resource = new NodeInfo(resourceType, (CollectionAgent)agent);
        ThresholdingVisitorIT.addAttributeToCollectionResource((SnmpCollectionResource)resource, (ResourceType)resourceType, "hda1_hrStorageUsed", "gauge", "node", 50L);
        ThresholdingVisitorIT.addAttributeToCollectionResource((SnmpCollectionResource)resource, (ResourceType)resourceType, "hda1_hrStorageSize", "gauge", "node", 100L);
        ThresholdingVisitorIT.addAttributeToCollectionResource((SnmpCollectionResource)resource, (ResourceType)resourceType, "hda2_hrStorageUsed", "gauge", "node", 60L);
        ThresholdingVisitorIT.addAttributeToCollectionResource((SnmpCollectionResource)resource, (ResourceType)resourceType, "hda2_hrStorageSize", "gauge", "node", 100L);
        ThresholdingVisitorIT.addAttributeToCollectionResource((SnmpCollectionResource)resource, (ResourceType)resourceType, "hda3_hrStorageUsed", "gauge", "node", 70L);
        ThresholdingVisitorIT.addAttributeToCollectionResource((SnmpCollectionResource)resource, (ResourceType)resourceType, "hda3_hrStorageSize", "gauge", "node", 100L);
        resource.visit((CollectionSetVisitor)visitor);
        EasyMock.verify((Object[])new Object[]{agent});
        this.verifyEvents(0);
    }

    @Test
    public void testThresholdsFiltersOnNodeResourceWithCollectionSetBuilder() throws Exception {
        this.initFactories("/threshd-configuration.xml", "/test-thresholds-5.xml");
        ThresholdingVisitor visitor = this.createVisitor();
        this.addHighThresholdEvent(1, 30.0, 25.0, 50.0, "/home", "node", "(hda1_hrStorageUsed/hda1_hrStorageSize)*100", null, null);
        this.addHighThresholdEvent(1, 50.0, 45.0, 60.0, "/opt", "node", "(hda2_hrStorageUsed/hda2_hrStorageSize)*100", null, null);
        SnmpCollectionAgent agent = ThresholdingVisitorIT.createCollectionAgent();
        NodeLevelResource nodeResource = new NodeLevelResource(agent.getNodeId());
        CollectionSetDTO collectionSet = new CollectionSetBuilder((CollectionAgent)agent).withNumericAttribute((Resource)nodeResource, "hd-usage", "hda1_hrStorageUsed", (Number)50, AttributeType.GAUGE).withNumericAttribute((Resource)nodeResource, "hd-usage", "hda1_hrStorageSize", (Number)100, AttributeType.GAUGE).withNumericAttribute((Resource)nodeResource, "hd-usage", "hda2_hrStorageUsed", (Number)60, AttributeType.GAUGE).withNumericAttribute((Resource)nodeResource, "hd-usage", "hda2_hrStorageSize", (Number)100, AttributeType.GAUGE).withNumericAttribute((Resource)nodeResource, "hd-usage", "hda3_hrStorageUsed", (Number)70, AttributeType.GAUGE).withNumericAttribute((Resource)nodeResource, "hd-usage", "hda3_hrStorageSize", (Number)100, AttributeType.GAUGE).build();
        ResourcePath path = ResourcePath.get((String[])new String[]{"snmp", "1"});
        this.m_resourceStorageDao.setStringAttribute(path, "hda1_hrStorageDescr", "/home");
        this.m_resourceStorageDao.setStringAttribute(path, "hda2_hrStorageDescr", "/opt");
        this.m_resourceStorageDao.setStringAttribute(path, "hda3_hrStorageDescr", "/usr");
        collectionSet.visit((CollectionSetVisitor)visitor);
        EasyMock.verify((Object[])new Object[]{agent});
        this.verifyEvents(0);
    }

    @Test
    public void testThresholdFiltersOnGenericResourceWithCollectionSetBuilder() throws Exception {
        ThresholdingVisitor visitor = this.createVisitor();
        String highExpression = "(((hrStorageAllocUnits*hrStorageUsed)/(hrStorageAllocUnits*hrStorageSize))*100)";
        this.addHighThresholdEvent(1, 30.0, 25.0, 50.0, "/opt", "1", highExpression, null, null);
        this.addHighThresholdEvent(1, 30.0, 25.0, 60.0, "/opt01", "2", highExpression, null, null);
        this.runFileSystemDataTestWithCollectionSetBuilder(visitor, 1, "/opt", 50L, 100L);
        this.runFileSystemDataTestWithCollectionSetBuilder(visitor, 2, "/opt01", 60L, 100L);
        this.runFileSystemDataTestWithCollectionSetBuilder(visitor, 3, "/home", 70L, 100L);
        this.verifyEvents(0);
    }

    @Test
    public void testThresholdFiltersOnGenericResourceWithSiblingColumnStorageStrategy() throws Exception {
        this.initFactories("/threshd-configuration.xml", "/test-thresholds-wsman.xml");
        ThresholdingVisitor visitor = this.createVisitor();
        SnmpCollectionAgent agent = ThresholdingVisitorIT.createCollectionAgent();
        NodeLevelResource nodeResource = new NodeLevelResource(agent.getNodeId());
        org.opennms.netmgt.config.datacollection.ResourceType wmiLogicalDisk = ThresholdingVisitorIT.createWmiLogicalDiskResourceType();
        ThresholdingVisitorIT.addEvent("uei.opennms.org/threshold/lowThresholdExceededWSManLogStorage", "127.0.0.1", "SNMP", 2, 10240.0, 12288.0, 1.0, "HarddiskVolume16", "volume16-1", "wmiLDPctFreeMBytes", null, null, this.m_anticipator, this.m_anticipatedEvents);
        for (int i = 0; i < 2; ++i) {
            GenericTypeResource volume16 = new GenericTypeResource(nodeResource, (org.opennms.netmgt.collection.api.ResourceType)wmiLogicalDisk, "volume16-" + i);
            GenericTypeResource iDrive = new GenericTypeResource(nodeResource, (org.opennms.netmgt.collection.api.ResourceType)wmiLogicalDisk, "iDrive" + i);
            ResourcePath path = ResourcePath.get((String[])new String[]{"snmp", "1", "wmiLogicalDisk", "HarddiskVolume16"});
            this.m_resourceStorageDao.setStringAttribute(path, "wmiLDName", "HarddiskVolume16");
            path = ResourcePath.get((String[])new String[]{"snmp", "1", "wmiLogicalDisk", "I"});
            this.m_resourceStorageDao.setStringAttribute(path, "wmiLDName", "I");
            CollectionSetDTO collectionSet = new CollectionSetBuilder((CollectionAgent)agent).withStringAttribute((Resource)volume16, "windows-os-wmi-LogicalDisk", "wmiLDName", "HarddiskVolume16").withNumericAttribute((Resource)volume16, "windows-os-wmi-LogicalDisk", "wmiLDPctFreeMBytes", (Number)1.0, AttributeType.GAUGE).withNumericAttribute((Resource)volume16, "windows-os-wmi-LogicalDisk", "wmiLDPctFreeSpace", (Number)10, AttributeType.GAUGE).withStringAttribute((Resource)iDrive, "windows-os-wmi-LogicalDisk", "wmiLDName", "I").withNumericAttribute((Resource)iDrive, "windows-os-wmi-LogicalDisk", "wmiLDPctFreeMBytes", (Number)2668498.0, AttributeType.GAUGE).withNumericAttribute((Resource)iDrive, "windows-os-wmi-LogicalDisk", "wmiLDPctFreeSpace", (Number)10, AttributeType.GAUGE).build();
            collectionSet.visit((CollectionSetVisitor)visitor);
        }
        this.verifyEvents(0);
    }

    private ThresholdingVisitor createVisitor() throws ThresholdInitializationException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("thresholding-enabled", "true");
        return this.createVisitor(params);
    }

    private ThresholdingVisitor createVisitor(Map<String, Object> params) throws ThresholdInitializationException {
        ServiceParameters svcParams = new ServiceParameters(params);
        ThresholdingVisitor visitor = ThresholdingVisitor.create((int)1, (String)"127.0.0.1", (String)"SNMP", (RrdRepository)this.getRepository(), (ServiceParameters)svcParams, (ResourceStorageDao)this.m_resourceStorageDao);
        Assert.assertNotNull((Object)visitor);
        return visitor;
    }

    private void runGaugeDataTest(ThresholdingVisitor visitor, long value) {
        SnmpCollectionAgent agent = ThresholdingVisitorIT.createCollectionAgent();
        NodeResourceType resourceType = this.createNodeResourceType(agent);
        NodeInfo resource = new NodeInfo(resourceType, (CollectionAgent)agent);
        ThresholdingVisitorIT.addAttributeToCollectionResource((SnmpCollectionResource)resource, (ResourceType)resourceType, "freeMem", "gauge", "0", value);
        resource.visit((CollectionSetVisitor)visitor);
        EasyMock.verify((Object[])new Object[]{agent});
    }

    private void runInterfaceResource(ThresholdingVisitor visitor, String ipAddress, String ifName, Long ifSpeed, Integer ifIndex, long v1, long v2) {
        SnmpIfData ifData = ThresholdingVisitorIT.createSnmpIfData(ipAddress, ifName, ifSpeed, ifIndex, true);
        SnmpCollectionAgent agent = ThresholdingVisitorIT.createCollectionAgent();
        IfResourceType resourceType = this.createInterfaceResourceType(agent);
        visitor.visitCollectionSet(ThresholdingVisitorIT.createAnonymousCollectionSet(visitor.getCollectionTimestamp().getTime()));
        IfInfo resource = new IfInfo((ResourceType)resourceType, (CollectionAgent)agent, ifData);
        ThresholdingVisitorIT.addAttributeToCollectionResource((SnmpCollectionResource)resource, (ResourceType)resourceType, "ifInOctets", "counter", "ifIndex", v1);
        ThresholdingVisitorIT.addAttributeToCollectionResource((SnmpCollectionResource)resource, (ResourceType)resourceType, "ifOutOctets", "counter", "ifIndex", v1);
        resource.visit((CollectionSetVisitor)visitor);
        visitor.visitCollectionSet(ThresholdingVisitorIT.createAnonymousCollectionSet(visitor.getCollectionTimestamp().getTime() + 300000L));
        resource = new IfInfo((ResourceType)resourceType, (CollectionAgent)agent, ifData);
        ThresholdingVisitorIT.addAttributeToCollectionResource((SnmpCollectionResource)resource, (ResourceType)resourceType, "ifInOctets", "counter", "ifIndex", v2);
        ThresholdingVisitorIT.addAttributeToCollectionResource((SnmpCollectionResource)resource, (ResourceType)resourceType, "ifOutOctets", "counter", "ifIndex", v2);
        resource.visit((CollectionSetVisitor)visitor);
        EasyMock.verify((Object[])new Object[]{agent});
    }

    private void runFileSystemDataTest(ThresholdingVisitor visitor, int resourceId, String fs, long value, long max) throws Exception {
        SnmpCollectionAgent agent = ThresholdingVisitorIT.createCollectionAgent();
        GenericIndexResourceType resourceType = this.createGenericIndexResourceType(agent, "hrStorageIndex");
        ResourcePath path = ResourcePath.get((String[])new String[]{"snmp", "1", "hrStorageIndex", Integer.toString(resourceId)});
        this.m_resourceStorageDao.setStringAttribute(path, "hrStorageType", ".1.3.6.1.2.1.25.2.1.4");
        this.m_resourceStorageDao.setStringAttribute(path, "hrStorageDescr", fs);
        SnmpInstId inst = new SnmpInstId(resourceId);
        GenericIndexResource resource = new GenericIndexResource((ResourceType)resourceType, "hrStorageIndex", inst);
        ThresholdingVisitorIT.addAttributeToCollectionResource((SnmpCollectionResource)resource, (ResourceType)resourceType, "hrStorageUsed", "gauge", "hrStorageIndex", value);
        ThresholdingVisitorIT.addAttributeToCollectionResource((SnmpCollectionResource)resource, (ResourceType)resourceType, "hrStorageSize", "gauge", "hrStorageIndex", max);
        ThresholdingVisitorIT.addAttributeToCollectionResource((SnmpCollectionResource)resource, (ResourceType)resourceType, "hrStorageAllocUnits", "gauge", "hrStorageIndex", 1L);
        resource.visit((CollectionSetVisitor)visitor);
        EasyMock.verify((Object[])new Object[]{agent});
    }

    private void runFileSystemDataTestWithCollectionSetBuilder(ThresholdingVisitor visitor, int resourceId, String fs, long value, long max) throws Exception {
        SnmpCollectionAgent agent = ThresholdingVisitorIT.createCollectionAgent();
        NodeLevelResource nodeResource = new NodeLevelResource(agent.getNodeId());
        org.opennms.netmgt.config.datacollection.ResourceType indexResourceType = ThresholdingVisitorIT.createIndexResourceType(agent, "hrStorageIndex");
        GenericTypeResource genericResource = new GenericTypeResource(nodeResource, (org.opennms.netmgt.collection.api.ResourceType)indexResourceType, Integer.toString(resourceId));
        ResourcePath path = ResourcePath.get((String[])new String[]{"snmp", "1", "hrStorageIndex", Integer.toString(resourceId)});
        this.m_resourceStorageDao.setStringAttribute(path, "hrStorageType", ".1.3.6.1.2.1.25.2.1.4");
        this.m_resourceStorageDao.setStringAttribute(path, "hrStorageDescr", fs);
        CollectionSetDTO collectionSet = new CollectionSetBuilder((CollectionAgent)agent).withNumericAttribute((Resource)genericResource, "hd-usage", "hrStorageUsed", (Number)value, AttributeType.GAUGE).withNumericAttribute((Resource)genericResource, "hd-usage", "hrStorageSize", (Number)max, AttributeType.GAUGE).withNumericAttribute((Resource)genericResource, "hd-usage", "hrStorageAllocUnits", (Number)1, AttributeType.GAUGE).build();
        collectionSet.visit((CollectionSetVisitor)visitor);
        EasyMock.verify((Object[])new Object[]{agent});
    }

    private void runCounterWrapTest(double bits, double expectedValue) throws Exception {
        Integer ifIndex = 1;
        Long ifSpeed = 10000000L;
        String ifName = "wlan0";
        this.initFactories("/threshd-configuration.xml", "/test-thresholds-bug3194.xml");
        this.addHighThresholdEvent(1, 100.0, 90.0, expectedValue, ifName, "1", "ifOutOctets", ifName, ifIndex.toString());
        ThresholdingVisitor visitor = this.createVisitor();
        SnmpIfData ifData = ThresholdingVisitorIT.createSnmpIfData("127.0.0.1", ifName, ifSpeed, ifIndex, true);
        SnmpCollectionAgent agent = ThresholdingVisitorIT.createCollectionAgent();
        IfResourceType resourceType = this.createInterfaceResourceType(agent);
        MibObject object = ThresholdingVisitorIT.createMibObject("counter", "ifOutOctets", "ifIndex");
        NumericAttributeType objectType = new NumericAttributeType((ResourceType)resourceType, "default", object, new AttributeGroupType("mibGroup", "ignore"));
        long timestamp = new Date().getTime();
        visitor.visitCollectionSet(ThresholdingVisitorIT.createAnonymousCollectionSet(timestamp));
        BigDecimal n = new BigDecimal(Math.pow(2.0, bits) - 20000.0);
        SnmpValue snmpValue1 = SnmpUtils.getValueFactory().getCounter64(n.toBigInteger());
        IfInfo resource1 = new IfInfo((ResourceType)resourceType, (CollectionAgent)agent, ifData);
        resource1.setAttributeValue((SnmpAttributeType)objectType, snmpValue1);
        resource1.visit((CollectionSetVisitor)visitor);
        visitor.visitCollectionSet(ThresholdingVisitorIT.createAnonymousCollectionSet(timestamp + 300000L));
        SnmpValue snmpValue2 = SnmpUtils.getValueFactory().getCounter64(new BigInteger("40000"));
        IfInfo resource2 = new IfInfo((ResourceType)resourceType, (CollectionAgent)agent, ifData);
        resource2.setAttributeValue((SnmpAttributeType)objectType, snmpValue2);
        resource2.visit((CollectionSetVisitor)visitor);
        EasyMock.verify((Object[])new Object[]{agent});
        this.verifyEvents(0);
    }

    private static SnmpCollectionAgent createCollectionAgent() {
        SnmpCollectionAgent agent = (SnmpCollectionAgent)EasyMock.createMock(SnmpCollectionAgent.class);
        EasyMock.expect((Object)agent.getNodeId()).andReturn((Object)1).anyTimes();
        EasyMock.expect((Object)agent.getStorageResourcePath()).andReturn((Object)ResourcePath.get((String[])new String[]{String.valueOf(1)})).anyTimes();
        EasyMock.expect((Object)agent.getHostAddress()).andReturn((Object)"127.0.0.1").anyTimes();
        EasyMock.expect((Object)agent.getSnmpInterfaceInfo((IfResourceType)EasyMock.anyObject())).andReturn(new HashSet()).anyTimes();
        EasyMock.expect((Object)agent.getAttributeNames()).andReturn(Collections.emptySet()).anyTimes();
        EasyMock.expect((Object)agent.getAddress()).andReturn((Object)InetAddrUtils.getLocalHostAddress()).anyTimes();
        EasyMock.expect((Object)agent.isStoreByForeignSource()).andReturn((Object)false).anyTimes();
        EasyMock.expect((Object)agent.getNodeLabel()).andReturn((Object)"test").anyTimes();
        EasyMock.expect((Object)agent.getForeignSource()).andReturn(null).anyTimes();
        EasyMock.expect((Object)agent.getForeignId()).andReturn(null).anyTimes();
        EasyMock.expect((Object)agent.getLocationName()).andReturn(null).anyTimes();
        EasyMock.expect((Object)agent.getSysObjectId()).andReturn(null).anyTimes();
        EasyMock.expect((Object)agent.getSavedSysUpTime()).andReturn((Object)0L).anyTimes();
        EasyMock.replay((Object[])new Object[]{agent});
        return agent;
    }

    private NodeResourceType createNodeResourceType(SnmpCollectionAgent agent) {
        MockDataCollectionConfig dataCollectionConfig = new MockDataCollectionConfig();
        OnmsSnmpCollection collection = new OnmsSnmpCollection(agent, new ServiceParameters(new HashMap()), (DataCollectionConfigDao)dataCollectionConfig, this.m_locationAwareSnmpClient);
        return new NodeResourceType(agent, collection);
    }

    private IfResourceType createInterfaceResourceType(SnmpCollectionAgent agent) {
        MockDataCollectionConfig dataCollectionConfig = new MockDataCollectionConfig();
        OnmsSnmpCollection collection = new OnmsSnmpCollection(agent, new ServiceParameters(new HashMap()), (DataCollectionConfigDao)dataCollectionConfig, this.m_locationAwareSnmpClient);
        return new IfResourceType(agent, collection);
    }

    private static org.opennms.netmgt.config.datacollection.ResourceType createIndexResourceType(SnmpCollectionAgent agent, String resourceTypeName) {
        org.opennms.netmgt.config.datacollection.ResourceType type = new org.opennms.netmgt.config.datacollection.ResourceType();
        type.setName(resourceTypeName);
        type.setLabel(resourceTypeName);
        StorageStrategy strategy = new StorageStrategy();
        strategy.setClazz(IndexStorageStrategy.class.getCanonicalName());
        type.setStorageStrategy(strategy);
        PersistenceSelectorStrategy pstrategy = new PersistenceSelectorStrategy();
        pstrategy.setClazz(PersistAllSelectorStrategy.class.getCanonicalName());
        type.setPersistenceSelectorStrategy(pstrategy);
        return type;
    }

    private GenericIndexResourceType createGenericIndexResourceType(SnmpCollectionAgent agent, String resourceTypeName) {
        org.opennms.netmgt.config.datacollection.ResourceType type = ThresholdingVisitorIT.createIndexResourceType(agent, resourceTypeName);
        MockDataCollectionConfig dataCollectionConfig = new MockDataCollectionConfig();
        OnmsSnmpCollection collection = new OnmsSnmpCollection(agent, new ServiceParameters(new HashMap()), (DataCollectionConfigDao)dataCollectionConfig, this.m_locationAwareSnmpClient);
        return new GenericIndexResourceType(agent, collection, type);
    }

    private static org.opennms.netmgt.config.datacollection.ResourceType createWmiLogicalDiskResourceType() {
        org.opennms.netmgt.config.datacollection.ResourceType wmiLogicalDisk = new org.opennms.netmgt.config.datacollection.ResourceType();
        wmiLogicalDisk.setName("wmiLogicalDisk");
        wmiLogicalDisk.setLabel("(wsman) Logical Storage");
        wmiLogicalDisk.setResourceLabel("Logical Disk (${wmiLDName})");
        PersistenceSelectorStrategy pss = new PersistenceSelectorStrategy();
        pss.setClazz(PersistAllSelectorStrategy.class.getCanonicalName());
        wmiLogicalDisk.setPersistenceSelectorStrategy(pss);
        StorageStrategy ss = new StorageStrategy();
        ss.setClazz(SiblingColumnStorageStrategy.class.getCanonicalName());
        org.opennms.netmgt.config.datacollection.Parameter siblingColumnName = new org.opennms.netmgt.config.datacollection.Parameter();
        siblingColumnName.setKey("sibling-column-name");
        siblingColumnName.setValue("wmiLDName");
        ss.addParameter((org.opennms.netmgt.collection.api.Parameter)siblingColumnName);
        wmiLogicalDisk.setStorageStrategy(ss);
        return wmiLogicalDisk;
    }

    private static void addAttributeToCollectionResource(SnmpCollectionResource resource, ResourceType type, String attributeName, String attributeType, String attributeInstance, long value) {
        MibObject object = ThresholdingVisitorIT.createMibObject(attributeType, attributeName, attributeInstance);
        NumericAttributeType objectType = new NumericAttributeType(type, "default", object, new AttributeGroupType("mibGroup", "ignore"));
        SnmpValue snmpValue = attributeType.equals("counter") ? SnmpUtils.getValueFactory().getCounter32(value) : SnmpUtils.getValueFactory().getGauge32(value);
        resource.setAttributeValue((SnmpAttributeType)objectType, snmpValue);
    }

    private static MibObject createMibObject(String type, String alias, String instance) {
        MibObject mibObject = new MibObject();
        mibObject.setOid(".1.1.1.1");
        mibObject.setAlias(alias);
        mibObject.setType(type);
        mibObject.setInstance(instance);
        mibObject.setMaxval(null);
        mibObject.setMinval(null);
        return mibObject;
    }

    private RrdRepository getRepository() {
        RrdRepository repo = new RrdRepository();
        repo.setRrdBaseDir(new File(this.m_fileAnticipator.getTempDir(), "snmp"));
        return repo;
    }

    private void addHighThresholdEvent(int trigger, double threshold, double rearm, double value, String label, String instance, String ds, String ifLabel, String ifIndex) {
        ThresholdingVisitorIT.addEvent("uei.opennms.org/threshold/highThresholdExceeded", "127.0.0.1", "SNMP", trigger, threshold, rearm, value, label, instance, ds, ifLabel, ifIndex, this.m_anticipator, this.m_anticipatedEvents);
    }

    private void addHighRearmEvent(int trigger, double threshold, double rearm, double value, String label, String instance, String ds, String ifLabel, String ifIndex) {
        ThresholdingVisitorIT.addEvent("uei.opennms.org/threshold/highThresholdRearmed", "127.0.0.1", "SNMP", trigger, threshold, rearm, value, label, instance, ds, ifLabel, ifIndex, this.m_anticipator, this.m_anticipatedEvents);
    }

    private static void addEvent(String uei, String ipaddr, String service, Integer trigger, Double threshold, Double rearm, Double value, String label, String instance, String ds, String ifLabel, String ifIndex, EventAnticipator anticipator, List<Event> anticipatedEvents) {
        EventBuilder bldr = new EventBuilder(uei, "ThresholdingVisitorTest");
        bldr.setNodeid(1L);
        bldr.setInterface(InetAddressUtils.addr((String)ipaddr));
        bldr.setService(service);
        bldr.addParam("label", label);
        if (ifLabel != null) {
            bldr.addParam("ifLabel", ifLabel);
        }
        if (ifIndex != null) {
            bldr.addParam("ifIndex", ifIndex);
        }
        bldr.addParam("ds", ds);
        if (value != null) {
            String pattern = System.getProperty("org.opennms.threshd.value.decimalformat", "###.##");
            DecimalFormat valueFormatter = new DecimalFormat(pattern);
            bldr.addParam("value", value.isNaN() ? "NaN (the threshold definition has been changed)" : valueFormatter.format(value));
        }
        bldr.addParam("instance", instance);
        bldr.addParam("trigger", trigger.intValue());
        if (threshold != null) {
            bldr.addParam("threshold", threshold.doubleValue());
        }
        if (rearm != null) {
            bldr.addParam("rearm", rearm.doubleValue());
        }
        anticipator.anticipateEvent(bldr.getEvent(), true);
        anticipatedEvents.add(bldr.getEvent());
    }

    private void verifyEvents(int remainEvents) {
        if (remainEvents == 0) {
            ArrayList receivedList = new ArrayList(this.m_anticipator.getAnticipatedEventsReceived());
            Collections.sort(receivedList, EVENT_COMPARATOR);
            Collections.sort(this.m_anticipatedEvents, EVENT_COMPARATOR);
            LOG.info("verifyEvents: Anticipated={}, Received= {}", (Object)receivedList.size(), (Object)this.m_anticipatedEvents.size());
            if (this.m_anticipatedEvents.size() != receivedList.size()) {
                for (Event e : this.m_anticipatedEvents) {
                    System.err.println("expected event " + e.getUei() + ": " + e.getDescr());
                }
                System.err.println("anticipated = " + this.m_anticipatedEvents + "\nreceived = " + receivedList);
                Assert.fail((String)("Anticipated event count (" + this.m_anticipatedEvents.size() + ") is different from received event count (" + receivedList.size() + ")."));
            }
            for (int i = 0; i < this.m_anticipatedEvents.size(); ++i) {
                LOG.info("verifyEvents: processing event {}", (Object)(i + 1));
                ThresholdingVisitorIT.compareEvents(this.m_anticipatedEvents.get(i), (Event)receivedList.get(i));
            }
        }
        this.m_anticipator.verifyAnticipated(0L, 0L, 0L, remainEvents, 0);
    }

    private static void compareEvents(Event anticipated, Event received) {
        Assert.assertEquals((String)"UEIs must match", (Object)anticipated.getUei(), (Object)received.getUei());
        Assert.assertEquals((String)"NodeIDs must match", (Object)anticipated.getNodeid(), (Object)received.getNodeid());
        Assert.assertEquals((String)"interfaces must match", (Object)anticipated.getInterface(), (Object)received.getInterface());
        Assert.assertEquals((String)"services must match", (Object)anticipated.getService(), (Object)received.getService());
        ThresholdingVisitorIT.compareParms(anticipated.getParmCollection(), received.getParmCollection());
    }

    private static void compareParms(List<Parm> anticipatedParms, List<Parm> receivedParms) {
        Collections.sort(anticipatedParms, PARM_COMPARATOR);
        Collections.sort(receivedParms, PARM_COMPARATOR);
        for (Parm source : anticipatedParms) {
            Parm found = null;
            for (Parm p : receivedParms) {
                if (!p.getParmName().equals(source.getParmName())) continue;
                found = p;
            }
            Assert.assertNotNull((String)("parameter " + source.getParmName() + " must be found on the received event"), (Object)found);
            if (source.getValue().getContent() == null) {
                source.getValue().setContent("null");
            }
            Assert.assertEquals((String)("content must match for parameter " + source.getParmName()), (Object)source.getValue().getContent(), (Object)found.getValue().getContent());
        }
    }

    private void resetAnticipator() {
        this.m_anticipator.reset();
        this.m_anticipatedEvents.clear();
    }

    private static SnmpIfData createSnmpIfData(String ipAddress, String ifName, Long ifSpeed, Integer ifIndex, boolean collectionEnabled) {
        OnmsNode node = new OnmsNode();
        node.setId(Integer.valueOf(1));
        node.setLabel("testNode");
        OnmsSnmpInterface snmpIface = new OnmsSnmpInterface(node, ifIndex);
        snmpIface.setIfDescr(ifName);
        snmpIface.setIfName(ifName);
        snmpIface.setIfAlias(ifName);
        snmpIface.setIfSpeed(ifSpeed);
        snmpIface.setCollectionEnabled(collectionEnabled);
        return new SnmpIfData(snmpIface);
    }

    private static CollectionSet createAnonymousCollectionSet(long timestamp) {
        MockCollectionAgent agent = new MockCollectionAgent(1, "node", "fs", "fid", InetAddressUtils.ONE_TWENTY_SEVEN);
        return new CollectionSetBuilder((CollectionAgent)agent).withTimestamp(new Date(timestamp)).build();
    }
}

