/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.pollables;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.opennms.core.rpc.api.RequestTimedOutException;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.collection.api.PersisterFactory;
import org.opennms.netmgt.config.PollOutagesConfig;
import org.opennms.netmgt.config.PollerConfig;
import org.opennms.netmgt.config.PollerConfigFactory;
import org.opennms.netmgt.config.poller.Package;
import org.opennms.netmgt.config.poller.Service;
import org.opennms.netmgt.dao.api.ResourceStorageDao;
import org.opennms.netmgt.dao.support.FilesystemResourceStorageDao;
import org.opennms.netmgt.filter.FilterDaoFactory;
import org.opennms.netmgt.filter.api.FilterDao;
import org.opennms.netmgt.mock.MockPersisterFactory;
import org.opennms.netmgt.poller.LocationAwarePollerClient;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.ServiceMonitor;
import org.opennms.netmgt.poller.ServiceMonitorAdaptor;
import org.opennms.netmgt.poller.pollables.PollContext;
import org.opennms.netmgt.poller.pollables.PollableInterface;
import org.opennms.netmgt.poller.pollables.PollableNetwork;
import org.opennms.netmgt.poller.pollables.PollableNode;
import org.opennms.netmgt.poller.pollables.PollableService;
import org.opennms.netmgt.poller.pollables.PollableServiceConfig;
import org.opennms.netmgt.scheduler.Timer;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-pinger.xml", "classpath:/META-INF/opennms/applicationContext-rpc-client-mock.xml", "classpath:/META-INF/opennms/applicationContext-serviceMonitorRegistry.xml", "classpath:/META-INF/opennms/applicationContext-rpc-poller.xml"})
@JUnitConfigurationEnvironment(systemProperties={"org.opennms.netmgt.icmp.pingerClass=org.opennms.netmgt.icmp.jna.JnaPinger"})
public class PollableServiceConfigIT {
    @Autowired
    private LocationAwarePollerClient m_locationAwarePollerClient;

    @Test
    public void testPollableServiceConfig() throws Exception {
        FilterDao fd = (FilterDao)Mockito.mock(FilterDao.class);
        FilterDaoFactory.setInstance((FilterDao)fd);
        FileInputStream is = new FileInputStream(new File("src/test/resources/etc/psm-poller-configuration.xml"));
        PollerConfigFactory factory = new PollerConfigFactory(0L, (InputStream)is, "localhost", false);
        PollerConfigFactory.setInstance((PollerConfig)factory);
        IOUtils.closeQuietly((InputStream)is);
        MockPersisterFactory persisterFactory = new MockPersisterFactory();
        FilesystemResourceStorageDao resourceStorageDao = new FilesystemResourceStorageDao();
        PollContext context = (PollContext)Mockito.mock(PollContext.class);
        PollableNetwork network = new PollableNetwork(context);
        PollableNode node = network.createNodeIfNecessary(1, "foo", null);
        PollableInterface iface = new PollableInterface(node, InetAddressUtils.addr((String)"127.0.0.1"));
        PollableService svc = new PollableService(iface, "MQ_API_DirectRte_v2");
        PollOutagesConfig pollOutagesConfig = (PollOutagesConfig)Mockito.mock(PollOutagesConfig.class);
        Package pkg = factory.getPackage("MapQuest");
        Timer timer = (Timer)Mockito.mock(Timer.class);
        PollableServiceConfig psc = new PollableServiceConfig(svc, (PollerConfig)factory, pollOutagesConfig, pkg, timer, (PersisterFactory)persisterFactory, (ResourceStorageDao)resourceStorageDao, this.m_locationAwarePollerClient);
        PollStatus pollStatus = psc.poll();
        MatcherAssert.assertThat((Object)pollStatus.getReason(), (Matcher)org.hamcrest.Matchers.not((Matcher)org.hamcrest.Matchers.containsString((String)"Unexpected exception")));
    }

    @Test
    public void returnsUnknownOnRequestTimedOutException() throws Exception {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally((Throwable)new RequestTimedOutException((Throwable)new Exception("Test")));
        LocationAwarePollerClient client = (LocationAwarePollerClient)Mockito.mock(LocationAwarePollerClient.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)client.poll().withService((MonitoredService)Matchers.any()).withMonitor((ServiceMonitor)Matchers.any()).withTimeToLive((Long)Matchers.any()).withAttributes((Map)Matchers.any()).withAdaptor((ServiceMonitorAdaptor)Matchers.any()).withAdaptor((ServiceMonitorAdaptor)Matchers.any()).execute()).thenReturn(future);
        PollableService pollableSvc = (PollableService)Mockito.mock(PollableService.class);
        Mockito.when((Object)pollableSvc.getSvcName()).thenReturn((Object)"SVC");
        Service configuredSvc = new Service();
        configuredSvc.setName("SVC");
        Package pkg = (Package)Mockito.mock(Package.class);
        Mockito.when((Object)pkg.getServices()).thenReturn((Object)Lists.newArrayList((Object[])new Service[]{configuredSvc}));
        PollerConfig pollerConfig = (PollerConfig)Mockito.mock(PollerConfig.class);
        PollOutagesConfig pollOutagesConfig = (PollOutagesConfig)Mockito.mock(PollOutagesConfig.class);
        Timer timer = (Timer)Mockito.mock(Timer.class);
        PersisterFactory persisterFactory = (PersisterFactory)Mockito.mock(PersisterFactory.class);
        ResourceStorageDao resourceStorageDao = (ResourceStorageDao)Mockito.mock(ResourceStorageDao.class);
        PollableServiceConfig psc = new PollableServiceConfig(pollableSvc, pollerConfig, pollOutagesConfig, pkg, timer, persisterFactory, resourceStorageDao, client);
        PollStatus pollStatus = psc.poll();
        MatcherAssert.assertThat((Object)pollStatus.isUnknown(), (Matcher)org.hamcrest.Matchers.is((Object)true));
    }
}

