/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgent;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgents;
import org.opennms.netmgt.enlinkd.EnLinkdBuilderITCase;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.nb.Nms0002NetworkBuilder;

public class Nms0002EnIT
extends EnLinkdBuilderITCase {
    Nms0002NetworkBuilder builder = new Nms0002NetworkBuilder();

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.4.79.250", port=161, resource="classpath:/linkd/nms0002ciscojuniper/r-de-juet-luck-001.txt"), @JUnitSnmpAgent(host="10.4.68.215", port=161, resource="classpath:/linkd/nms0002ciscojuniper/s-de-juet-luck-001.txt")})
    public void testNetworkLinksCiscoJuniperLldp() throws Exception {
        this.m_nodeDao.save((Object)this.builder.getRluck001());
        this.m_nodeDao.save((Object)this.builder.getSluck001());
        this.m_nodeDao.flush();
        this.m_linkdConfig.getConfiguration().setUseBridgeDiscovery(Boolean.valueOf(false));
        this.m_linkdConfig.getConfiguration().setUseCdpDiscovery(Boolean.valueOf(false));
        this.m_linkdConfig.getConfiguration().setUseOspfDiscovery(Boolean.valueOf(false));
        this.m_linkdConfig.getConfiguration().setUseLldpDiscovery(Boolean.valueOf(true));
        this.m_linkdConfig.getConfiguration().setUseIsisDiscovery(Boolean.valueOf(false));
        Assert.assertTrue((boolean)this.m_linkdConfig.useLldpDiscovery());
        Assert.assertTrue((!this.m_linkdConfig.useCdpDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((!this.m_linkdConfig.useOspfDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((!this.m_linkdConfig.useBridgeDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((!this.m_linkdConfig.useIsisDiscovery() ? 1 : 0) != 0);
        OnmsNode routerJuniper = this.m_nodeDao.findByForeignId("linkd", "r-de-juet-luck-001");
        OnmsNode switchCisco = this.m_nodeDao.findByForeignId("linkd", "s-de-juet-luck-001");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(routerJuniper.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(switchCisco.getId().intValue()));
        Assert.assertEquals((long)0L, (long)this.m_lldpLinkDao.countAll());
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(routerJuniper.getId().intValue()));
        List topologyA = this.m_lldpLinkDao.findAll();
        Nms0002EnIT.printLldpTopology(topologyA);
        Assert.assertEquals((long)1L, (long)this.m_lldpLinkDao.countAll());
        for (OnmsNode node : this.m_nodeDao.findAll()) {
            if (node.getLldpElement() == null) continue;
            Nms0002EnIT.printLldpElement(node.getLldpElement());
        }
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(switchCisco.getId().intValue()));
        Thread.sleep(1000L);
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(switchCisco.getId().intValue()));
        List topologyB = this.m_lldpLinkDao.findAll();
        Nms0002EnIT.printLldpTopology(topologyB);
        Assert.assertEquals((long)2L, (long)topologyB.size());
        for (OnmsNode node : this.m_nodeDao.findAll()) {
            if (node.getLldpElement() == null) continue;
            Nms0002EnIT.printLldpElement(node.getLldpElement());
        }
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.167.254.40", port=161, resource="classpath:/linkd/nms0002ciscoalcatel2/r-de-essn-brue-001.txt"), @JUnitSnmpAgent(host="10.165.62.91", port=161, resource="classpath:/linkd/nms0002ciscoalcatel2/s-de-essn-brue-081.txt"), @JUnitSnmpAgent(host="10.165.62.131", port=161, resource="classpath:/linkd/nms0002ciscoalcatel2/s-de-essn-brue-121.txt"), @JUnitSnmpAgent(host="10.165.62.152", port=161, resource="classpath:/linkd/nms0002ciscoalcatel2/s-de-essn-brue-142.txt"), @JUnitSnmpAgent(host="10.165.62.175", port=161, resource="classpath:/linkd/nms0002ciscoalcatel2/s-de-essn-brue-165.txt")})
    public void testCiscoAlcatelEssnBrueLldp() {
        this.m_nodeDao.save((Object)this.builder.getRDeEssnBrue());
        this.m_nodeDao.save((Object)this.builder.getSDeEssnBrue081());
        this.m_nodeDao.save((Object)this.builder.getSDeEssnBrue121());
        this.m_nodeDao.save((Object)this.builder.getSDeEssnBrue142());
        this.m_nodeDao.save((Object)this.builder.getSDeEssnBrue165());
        this.m_nodeDao.flush();
        this.m_linkdConfig.getConfiguration().setUseBridgeDiscovery(Boolean.valueOf(false));
        this.m_linkdConfig.getConfiguration().setUseCdpDiscovery(Boolean.valueOf(false));
        this.m_linkdConfig.getConfiguration().setUseOspfDiscovery(Boolean.valueOf(false));
        this.m_linkdConfig.getConfiguration().setUseLldpDiscovery(Boolean.valueOf(true));
        this.m_linkdConfig.getConfiguration().setUseIsisDiscovery(Boolean.valueOf(false));
        Assert.assertTrue((boolean)this.m_linkdConfig.useLldpDiscovery());
        Assert.assertTrue((!this.m_linkdConfig.useCdpDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((!this.m_linkdConfig.useOspfDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((!this.m_linkdConfig.useBridgeDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((!this.m_linkdConfig.useIsisDiscovery() ? 1 : 0) != 0);
        OnmsNode routerCisco = this.m_nodeDao.findByForeignId("linkd", "r-de-essn-brue-001");
        OnmsNode swicthAlu081 = this.m_nodeDao.findByForeignId("linkd", "s-de-essn-brue-081");
        OnmsNode swicthAlu121 = this.m_nodeDao.findByForeignId("linkd", "s-de-essn-brue-121");
        OnmsNode swicthAlu142 = this.m_nodeDao.findByForeignId("linkd", "s-de-essn-brue-142");
        OnmsNode swicthAlu165 = this.m_nodeDao.findByForeignId("linkd", "s-de-essn-brue-165");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(routerCisco.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(swicthAlu081.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(swicthAlu121.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(swicthAlu142.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(swicthAlu165.getId().intValue()));
        Assert.assertEquals((long)0L, (long)this.m_lldpLinkDao.countAll());
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(routerCisco.getId().intValue()));
        Assert.assertEquals((long)0L, (long)this.m_lldpLinkDao.countAll());
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(swicthAlu081.getId().intValue()));
        Assert.assertEquals((long)1L, (long)this.m_lldpLinkDao.countAll());
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(swicthAlu121.getId().intValue()));
        Assert.assertEquals((long)2L, (long)this.m_lldpLinkDao.countAll());
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(swicthAlu142.getId().intValue()));
        Assert.assertEquals((long)4L, (long)this.m_lldpLinkDao.countAll());
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(swicthAlu165.getId().intValue()));
        List topologyB = this.m_lldpLinkDao.findAll();
        Nms0002EnIT.printLldpTopology(topologyB);
        Assert.assertEquals((long)6L, (long)topologyB.size());
        for (OnmsNode node : this.m_nodeDao.findAll()) {
            if (node.getLldpElement() == null) continue;
            Nms0002EnIT.printLldpElement(node.getLldpElement());
        }
    }
}

