/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd;

import java.net.InetAddress;
import java.util.Date;
import java.util.concurrent.ExecutionException;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.enlinkd.EnhancedLinkd;
import org.opennms.netmgt.enlinkd.Node;
import org.opennms.netmgt.enlinkd.NodeDiscovery;
import org.opennms.netmgt.enlinkd.snmp.IpNetToMediaTableTracker;
import org.opennms.netmgt.model.IpNetToMedia;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NodeDiscoveryIpNetToMedia
extends NodeDiscovery {
    private static final Logger LOG = LoggerFactory.getLogger(NodeDiscoveryIpNetToMedia.class);

    public NodeDiscoveryIpNetToMedia(EnhancedLinkd linkd, Node node) {
        super(linkd, node);
    }

    @Override
    protected void runCollection() {
        Date now = new Date();
        IpNetToMediaTableTracker ipNetToMediaTableTracker = new IpNetToMediaTableTracker(){

            @Override
            public void processIpNetToMediaRow(IpNetToMediaTableTracker.IpNetToMediaRow row) {
                IpNetToMedia macep = row.getIpNetToMedia();
                if (macep.getPhysAddress() == null && macep.getNetAddress() == null) {
                    LOG.debug("processIpNetToMediaRow: node [{}], null:null:{}. ip and mac addresses null. skipping", (Object)NodeDiscoveryIpNetToMedia.this.getNodeId(), (Object)macep.getIpNetToMediaType());
                } else if (macep.getPhysAddress() == null) {
                    LOG.debug("processIpNetToMediaRow: node [{}], null:{}:{}. mac address null. skipping", new Object[]{NodeDiscoveryIpNetToMedia.this.getNodeId(), InetAddressUtils.str((InetAddress)macep.getNetAddress()), macep.getIpNetToMediaType()});
                } else if (macep.getNetAddress() == null) {
                    LOG.warn("processIpNetToMediaRow: node [{}], {}:null:{}. ip address null. skipping", new Object[]{NodeDiscoveryIpNetToMedia.this.getNodeId(), macep.getPhysAddress(), macep.getIpNetToMediaType()});
                } else if (macep.getIpNetToMediaType() == IpNetToMedia.IpNetToMediaType.IPNETTOMEDIA_TYPE_DYNAMIC || macep.getIpNetToMediaType() == IpNetToMedia.IpNetToMediaType.IPNETTOMEDIA_TYPE_STATIC) {
                    LOG.debug("processIpNetToMediaRow: node [{}], mac address {} and ip {} mediatype {}. saving", new Object[]{NodeDiscoveryIpNetToMedia.this.getNodeId(), macep.getPhysAddress(), InetAddressUtils.str((InetAddress)macep.getNetAddress()), macep.getIpNetToMediaType()});
                    NodeDiscoveryIpNetToMedia.this.m_linkd.getQueryManager().store(NodeDiscoveryIpNetToMedia.this.getNodeId(), macep);
                } else {
                    LOG.warn("processIpNetToMediaRow: node [{}],  {}:{}:{}. mediatype not valid. skipping", new Object[]{NodeDiscoveryIpNetToMedia.this.getNodeId(), macep.getPhysAddress(), InetAddressUtils.str((InetAddress)macep.getNetAddress()), macep.getIpNetToMediaType()});
                }
            }
        };
        SnmpAgentConfig peer = this.m_linkd.getSnmpAgentConfig(this.getPrimaryIpAddress(), this.getLocation());
        try {
            this.m_linkd.getLocationAwareSnmpClient().walk(peer, (CollectionTracker)ipNetToMediaTableTracker).withDescription("ipNetToMedia").withLocation(this.getLocation()).execute().get();
        }
        catch (ExecutionException e) {
            LOG.info("run: node [{}]: ExecutionException: ipNetToMedia table: {}", (Object)this.getNodeId(), (Object)e.getMessage());
            return;
        }
        catch (InterruptedException e) {
            LOG.info("run: node [{}]: InterruptedException: ipNetToMedia table: {}", (Object)this.getNodeId(), (Object)e.getMessage());
            return;
        }
        this.m_linkd.getQueryManager().reconcileIpNetToMedia(this.getNodeId(), now);
    }

    @Override
    public String getName() {
        return "IpNetToMediaLinkDiscovery";
    }
}

