/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.spring.xml;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.netmgt.dao.mock.MockEventIpcManager;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.spring.xml.AspectJTestEventHandler;
import org.opennms.spring.xml.AspectJTestEventHandlerInteceptor;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/org/opennms/spring/xml/applicationContext-testAOP.xml"})
@JUnitConfigurationEnvironment
@DirtiesContext
public class AspectJTest
implements InitializingBean {
    @Autowired
    private MockEventIpcManager m_eventIpcManager;
    @Autowired
    private AspectJTestEventHandler m_handler;
    @Autowired
    private AspectJTestEventHandlerInteceptor m_interceptor;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    @Before
    public void onSetUp() throws Exception {
        this.m_handler.reset();
        this.m_interceptor.reset();
    }

    @Test
    public void testAOPProxying() throws Throwable {
        Assert.assertEquals((long)0L, (long)this.m_handler.getHandlerCallCount());
        Assert.assertEquals((long)0L, (long)this.m_interceptor.getPreEventCount());
        Assert.assertEquals((long)0L, (long)this.m_interceptor.getPostEventCount());
        this.m_handler.handleAnEvent(this.createEvent("uei.opennms.org/nodes/nodeLostService"));
        Assert.assertEquals((long)1L, (long)this.m_handler.getHandlerCallCount());
        Assert.assertEquals((long)1L, (long)this.m_interceptor.getPreEventCount());
        Assert.assertEquals((long)1L, (long)this.m_interceptor.getPostEventCount());
    }

    @Test
    public void testEventAdapterOnProxy() {
        Assert.assertEquals((long)0L, (long)this.m_handler.getHandlerCallCount());
        Assert.assertEquals((long)0L, (long)this.m_interceptor.getPreEventCount());
        Assert.assertEquals((long)0L, (long)this.m_interceptor.getPostEventCount());
        this.sendEvent("uei.opennms.org/nodes/nodeLostService");
        Assert.assertEquals((long)1L, (long)this.m_handler.getHandlerCallCount());
        Assert.assertEquals((long)1L, (long)this.m_interceptor.getPreEventCount());
        Assert.assertEquals((long)1L, (long)this.m_interceptor.getPostEventCount());
    }

    @Test
    public void testHandledException() {
        Assert.assertEquals((long)0L, (long)this.m_handler.getHandlerCallCount());
        Assert.assertEquals((long)0L, (long)this.m_interceptor.getPreEventCount());
        Assert.assertEquals((long)0L, (long)this.m_interceptor.getPostEventCount());
        Assert.assertEquals((long)0L, (long)this.m_interceptor.getHandledExceptionCount());
        this.m_handler.setThrownException(new RuntimeException("test exception"));
        this.sendEvent("uei.opennms.org/nodes/nodeLostService");
        Assert.assertEquals((long)1L, (long)this.m_handler.getHandlerCallCount());
        Assert.assertEquals((long)1L, (long)this.m_interceptor.getPreEventCount());
        Assert.assertEquals((long)0L, (long)this.m_interceptor.getPostEventCount());
        Assert.assertEquals((long)1L, (long)this.m_interceptor.getHandledExceptionCount());
    }

    @Test
    public void testUnhandledException() {
        Assert.assertEquals((long)0L, (long)this.m_handler.getHandlerCallCount());
        Assert.assertEquals((long)0L, (long)this.m_interceptor.getPreEventCount());
        Assert.assertEquals((long)0L, (long)this.m_interceptor.getPostEventCount());
        Assert.assertEquals((long)0L, (long)this.m_interceptor.getHandledExceptionCount());
        this.m_handler.setThrownException(new Exception("test exception"));
        this.sendEvent("uei.opennms.org/nodes/nodeLostService");
        Assert.assertEquals((long)1L, (long)this.m_handler.getHandlerCallCount());
        Assert.assertEquals((long)1L, (long)this.m_interceptor.getPreEventCount());
        Assert.assertEquals((long)0L, (long)this.m_interceptor.getPostEventCount());
        Assert.assertEquals((long)0L, (long)this.m_interceptor.getHandledExceptionCount());
    }

    private void sendEvent(String uei) {
        this.m_eventIpcManager.sendNow(this.createEvent(uei));
    }

    private Event createEvent(String uei) {
        return new EventBuilder(uei, "Test").getEvent();
    }
}

