/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.utils;

import org.junit.Assert;
import org.junit.Test;
import org.opennms.core.utils.IPLike;

public class IPLikeTest {
    @Test
    public void testCountChar() {
        Assert.assertEquals((long)2L, (long)IPLike.countChar((char)'-', (String)"test-this-please"));
        Assert.assertEquals((long)3L, (long)IPLike.countChar((char)'-', (String)"test-this-please-"));
        Assert.assertEquals((long)4L, (long)IPLike.countChar((char)'-', (String)"-test-this-please-"));
    }

    @Test
    public void testMatchRange() {
        Assert.assertTrue((boolean)IPLike.matchRange((String)"192", (String)"191-193"));
        Assert.assertTrue((boolean)IPLike.matchRange((String)"192", (String)"192"));
        Assert.assertTrue((boolean)IPLike.matchRange((String)"192", (String)"192-200"));
        Assert.assertTrue((boolean)IPLike.matchRange((String)"192", (String)"1-255"));
        Assert.assertTrue((boolean)IPLike.matchRange((String)"192", (String)"*"));
        Assert.assertFalse((boolean)IPLike.matchRange((String)"192", (String)"1-9"));
    }

    @Test
    public void testMatchRangeHex() {
        Assert.assertTrue((boolean)IPLike.matchRangeHex((String)"C0", (String)"BF-C1"));
        Assert.assertTrue((boolean)IPLike.matchRangeHex((String)"c0", (String)"BF-C1"));
        Assert.assertTrue((boolean)IPLike.matchRangeHex((String)"C0", (String)"bf-C1"));
        Assert.assertTrue((boolean)IPLike.matchRangeHex((String)"C0", (String)"BF-c1"));
        Assert.assertTrue((boolean)IPLike.matchRangeHex((String)"C0", (String)"bF-c1"));
        Assert.assertTrue((boolean)IPLike.matchRangeHex((String)"C0", (String)"Bf-c1"));
        Assert.assertTrue((boolean)IPLike.matchRangeHex((String)"C0", (String)"bf-c1"));
        Assert.assertTrue((boolean)IPLike.matchRangeHex((String)"c0", (String)"bf-c1"));
        Assert.assertTrue((boolean)IPLike.matchRangeHex((String)"C0", (String)"C0"));
        Assert.assertTrue((boolean)IPLike.matchRangeHex((String)"c0", (String)"C0"));
        Assert.assertTrue((boolean)IPLike.matchRangeHex((String)"C0", (String)"c0"));
        Assert.assertTrue((boolean)IPLike.matchRangeHex((String)"c0", (String)"c0"));
        Assert.assertTrue((boolean)IPLike.matchRangeHex((String)"C0", (String)"C0-C8"));
        Assert.assertTrue((boolean)IPLike.matchRangeHex((String)"C0", (String)"B4-C0"));
        Assert.assertTrue((boolean)IPLike.matchRangeHex((String)"c0", (String)"01-FF"));
        Assert.assertTrue((boolean)IPLike.matchRangeHex((String)"c0", (String)"*"));
        Assert.assertFalse((boolean)IPLike.matchRangeHex((String)"c0", (String)"01-09"));
        Assert.assertFalse((boolean)IPLike.matchRangeHex((String)"c0", (String)"1-9"));
        Assert.assertTrue((boolean)IPLike.matchRangeHex((String)"5", (String)"1-9"));
    }

    @Test
    public void testMatchOctet() {
        Assert.assertTrue((boolean)IPLike.matchNumericListOrRange((String)"192", (String)"191,192,193"));
        Assert.assertFalse((boolean)IPLike.matchNumericListOrRange((String)"192", (String)"190,191,194"));
        Assert.assertTrue((boolean)IPLike.matchNumericListOrRange((String)"192", (String)"10,172,190-193"));
        Assert.assertFalse((boolean)IPLike.matchNumericListOrRange((String)"192", (String)"10,172,193-199"));
        Assert.assertTrue((boolean)IPLike.matchNumericListOrRange((String)"205", (String)"200-300,400-500"));
        Assert.assertTrue((boolean)IPLike.matchNumericListOrRange((String)"405", (String)"200-300,400-500"));
        Assert.assertFalse((boolean)IPLike.matchNumericListOrRange((String)"505", (String)"200-300,400-500"));
    }

    @Test
    public void testVerifyIpMatch() {
        Assert.assertTrue((boolean)IPLike.matches((String)"192.168.0.1", (String)"*.*.*.*"));
        Assert.assertTrue((boolean)IPLike.matches((String)"192.168.0.1", (String)"192.*.*.*"));
        Assert.assertTrue((boolean)IPLike.matches((String)"192.168.0.1", (String)"*.168.*.*"));
        Assert.assertTrue((boolean)IPLike.matches((String)"192.168.0.1", (String)"*.*.0.*"));
        Assert.assertTrue((boolean)IPLike.matches((String)"192.168.0.1", (String)"*.*.*.1"));
        Assert.assertTrue((boolean)IPLike.matches((String)"192.168.0.1", (String)"*.*.*.0-7"));
        Assert.assertTrue((boolean)IPLike.matches((String)"192.168.0.1", (String)"192.168.0.0-7"));
        Assert.assertTrue((boolean)IPLike.matches((String)"192.168.0.1", (String)"192.166,167,168.*.0,1,5-10"));
        Assert.assertFalse((boolean)IPLike.matches((String)"192.168.0.1", (String)"10.0.0.1"));
        Assert.assertFalse((boolean)IPLike.matches((String)"192.168.0.1", (String)"*.168.*.2"));
        Assert.assertFalse((boolean)IPLike.matches((String)"192.168.0.1", (String)"10.168.0.1"));
        Assert.assertTrue((boolean)IPLike.matches((String)"10.1.1.1", (String)"10.1.1.1"));
        Assert.assertTrue((boolean)IPLike.matches((String)"fe80:0000:0000:0000:aaaa:bbbb:cccc:dddd", (String)"*:*:*:*:*:*:*:*"));
        Assert.assertTrue((boolean)IPLike.matches((String)"fe80:0000:0000:0000:aaaa:bbbb:cccc:dddd%4", (String)"*:*:*:*:*:*:*:*"));
        Assert.assertTrue((boolean)IPLike.matches((String)"fe80:0000:0000:0000:aaaa:bbbb:cccc:dddd%4", (String)"*:*:*:*:*:*:*:*%4"));
        Assert.assertFalse((boolean)IPLike.matches((String)"fe80:0000:0000:0000:aaaa:bbbb:cccc:dddd", (String)"*:*:*:*:*:*:*:*%4"));
        Assert.assertTrue((boolean)IPLike.matches((String)"fe80:0000:0000:0000:aaaa:bbbb:cccc:dddd", (String)"fe80:*:*:*:*:*:*:*"));
        Assert.assertTrue((boolean)IPLike.matches((String)"fe80:0000:0000:0000:aaaa:bbbb:cccc:dddd%4", (String)"fe80:*:*:*:*:*:*:*"));
        Assert.assertTrue((boolean)IPLike.matches((String)"fe80:0000:0000:0000:aaaa:bbbb:cccc:dddd%4", (String)"fe80:*:*:*:*:*:*:*%4"));
        Assert.assertFalse((boolean)IPLike.matches((String)"fe80:0000:0000:0000:aaaa:bbbb:cccc:dddd", (String)"fe80:*:*:*:*:*:*:*%4"));
        Assert.assertTrue((boolean)IPLike.matches((String)"fe80:0000:0000:0000:aaaa:bbbb:cccc:dddd", (String)"*:*:*:0:*:*:*:*"));
        Assert.assertTrue((boolean)IPLike.matches((String)"fe80:0000:0000:0000:aaaa:bbbb:cccc:dddd%4", (String)"*:*:*:0:*:*:*:*"));
        Assert.assertTrue((boolean)IPLike.matches((String)"fe80:0000:0000:0000:aaaa:bbbb:cccc:dddd%4", (String)"*:*:*:0:*:*:*:*%4"));
        Assert.assertFalse((boolean)IPLike.matches((String)"fe80:0000:0000:0000:aaaa:bbbb:cccc:dddd", (String)"*:*:*:0:*:*:*:*%4"));
        Assert.assertTrue((boolean)IPLike.matches((String)"fe80:0000:0000:0000:aaaa:bbbb:cccc:dddd", (String)"*:*:*:*:*:bbbb:*:*"));
        Assert.assertTrue((boolean)IPLike.matches((String)"fe80:0000:0000:0000:aaaa:bbbb:cccc:dddd%4", (String)"*:*:*:*:*:bbbb:*:*"));
        Assert.assertTrue((boolean)IPLike.matches((String)"fe80:0000:0000:0000:aaaa:bbbb:cccc:dddd%4", (String)"*:*:*:*:*:bbbb:*:*%4"));
        Assert.assertFalse((boolean)IPLike.matches((String)"fe80:0000:0000:0000:aaaa:bbbb:cccc:dddd", (String)"*:*:*:*:*:bbbb:*:*%4"));
        Assert.assertTrue((boolean)IPLike.matches((String)"fe80:0000:0000:0000:aaaa:bbbb:cccc:dddd", (String)"*:*:*:*:*:bbb0-bbbf:*:*"));
        Assert.assertTrue((boolean)IPLike.matches((String)"fe80:0000:0000:0000:aaaa:bbbb:cccc:dddd%4", (String)"*:*:*:*:*:bbb0-bbbf:*:*"));
        Assert.assertTrue((boolean)IPLike.matches((String)"fe80:0000:0000:0000:aaaa:bbbb:cccc:dddd%4", (String)"*:*:*:*:*:bbb0-bbbf:*:*%4"));
        Assert.assertFalse((boolean)IPLike.matches((String)"fe80:0000:0000:0000:aaaa:bbbb:cccc:dddd", (String)"*:*:*:*:*:bbb0-bbbf:*:*%4"));
        Assert.assertTrue((boolean)IPLike.matches((String)"fe80:0000:0000:0000:aaaa:bbbb:cccc:dddd", (String)"fe80:0000:0000:0000:aaaa:bbb0-bbbf:cccc:dddd"));
        Assert.assertTrue((boolean)IPLike.matches((String)"fe80:0000:0000:0000:aaaa:bbbb:cccc:dddd%4", (String)"fe80:0000:0000:0000:aaaa:bbb0-bbbf:cccc:dddd"));
        Assert.assertTrue((boolean)IPLike.matches((String)"fe80:0000:0000:0000:aaaa:bbbb:cccc:dddd%4", (String)"fe80:0000:0000:0000:aaaa:bbb0-bbbf:cccc:dddd%4"));
        Assert.assertFalse((boolean)IPLike.matches((String)"fe80:0000:0000:0000:aaaa:bbbb:cccc:dddd", (String)"fe80:0000:0000:0000:aaaa:bbb0-bbbf:cccc:dddd%4"));
        Assert.assertTrue((boolean)IPLike.matches((String)"fe80:0000:0000:0000:aaaa:bbbb:cccc:dddd", (String)"fe20,fe70-fe90:0000:0000:0000:*:bbb0,bbb1,bbb2,bbb3,bbb4,bbbb,bbbc:cccc:dddd"));
        Assert.assertTrue((boolean)IPLike.matches((String)"fe80:0000:0000:0000:aaaa:bbbb:cccc:dddd%4", (String)"fe20,fe70-fe90:0000:0000:0000:*:bbb0,bbb1,bbb2,bbb3,bbb4,bbbb,bbbc:cccc:dddd"));
        Assert.assertTrue((boolean)IPLike.matches((String)"fe80:0000:0000:0000:aaaa:bbbb:cccc:dddd%4", (String)"fe20,fe70-fe90:0000:0000:0000:*:bbb0,bbb1,bbb2,bbb3,bbb4,bbbb,bbbc:cccc:dddd%4"));
        Assert.assertFalse((boolean)IPLike.matches((String)"fe80:0000:0000:0000:aaaa:bbbb:cccc:dddd", (String)"fe20,fe70-fe90:0000:0000:0000:*:bbb0,bbb1,bbb2,bbb3,bbb4,bbbb,bbbc:cccc:dddd%4"));
        Assert.assertTrue((boolean)IPLike.matches((String)"fe80:0000:0000:0000:aaaa:bbbb:cccc:dddd", (String)"fe80:0000:0000:0000:aaaa:bbbb:cccc:dddd"));
        Assert.assertTrue((boolean)IPLike.matches((String)"fe80:0000:0000:0000:aaaa:bbbb:cccc:dddd%4", (String)"fe80:0000:0000:0000:aaaa:bbbb:cccc:dddd"));
        Assert.assertTrue((boolean)IPLike.matches((String)"fe80:0000:0000:0000:aaaa:bbbb:cccc:dddd%4", (String)"fe80:0000:0000:0000:aaaa:bbbb:cccc:dddd%4"));
        Assert.assertFalse((boolean)IPLike.matches((String)"fe80:0000:0000:0000:aaaa:bbbb:cccc:dddd", (String)"fe80:0000:0000:0000:aaaa:bbbb:cccc:dddd%4"));
    }
}

