/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.opennms.core.rpc.api.RpcClientFactory;
import org.opennms.core.rpc.mock.MockRpcClientFactory;
import org.opennms.core.test.MockLogAppender;
import org.opennms.core.test.MockPlatformTransactionManager;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.collectd.DefaultSnmpCollectionAgent;
import org.opennms.netmgt.collectd.NodeInfo;
import org.opennms.netmgt.collectd.NodeResourceType;
import org.opennms.netmgt.collectd.NumericAttributeType;
import org.opennms.netmgt.collectd.OnmsSnmpCollection;
import org.opennms.netmgt.collectd.ResourceType;
import org.opennms.netmgt.collectd.SnmpCollectionAgent;
import org.opennms.netmgt.collectd.SnmpCollectionSet;
import org.opennms.netmgt.collectd.StringAttributeType;
import org.opennms.netmgt.collection.api.AttributeGroupType;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionAttributeType;
import org.opennms.netmgt.collection.api.ResourceIdentifier;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.collection.persistence.rrd.RrdPersistOperationBuilder;
import org.opennms.netmgt.config.api.DataCollectionConfigDao;
import org.opennms.netmgt.config.datacollection.MibObject;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.mock.MockDataCollectionConfig;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.rrd.RrdRepository;
import org.opennms.netmgt.rrd.RrdStrategy;
import org.opennms.netmgt.rrd.jrobin.JRobinRrdStrategy;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpResult;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.proxy.LocationAwareSnmpClient;
import org.opennms.netmgt.snmp.proxy.common.LocationAwareSnmpClientRpcImpl;
import org.opennms.test.FileAnticipator;
import org.springframework.transaction.PlatformTransactionManager;

public class RrdPersistOperationBuilderTest {
    private FileAnticipator m_fileAnticipator;
    private File m_snmpDirectory;
    private OnmsIpInterface m_intf;
    private OnmsNode m_node;
    private PlatformTransactionManager m_transMgr = new MockPlatformTransactionManager();
    private IpInterfaceDao m_ifDao;
    private RrdStrategy<?, ?> m_rrdStrategy;
    private LocationAwareSnmpClient m_locationAwareSnmpClient = new LocationAwareSnmpClientRpcImpl((RpcClientFactory)new MockRpcClientFactory());

    @Before
    public void setUp() throws Exception {
        MockLogAppender.setupLogging();
        this.m_rrdStrategy = new JRobinRrdStrategy();
        this.m_fileAnticipator = new FileAnticipator();
        this.m_intf = new OnmsIpInterface();
        this.m_node = new OnmsNode();
        this.m_node.setId(Integer.valueOf(1));
        this.m_intf.setNode(this.m_node);
        this.m_intf.setIpAddress(InetAddressUtils.addr((String)"1.1.1.1"));
        this.m_intf.setId(Integer.valueOf(27));
        this.m_ifDao = (IpInterfaceDao)EasyMock.createMock(IpInterfaceDao.class);
        EasyMock.expect((Object)this.m_ifDao.load((Serializable)this.m_intf.getId())).andReturn((Object)this.m_intf).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.m_ifDao});
    }

    @After
    public void tearDown() throws Exception {
        MockLogAppender.assertNoWarningsOrGreater();
        this.m_fileAnticipator.deleteExpected();
        this.m_fileAnticipator.tearDown();
    }

    private SnmpCollectionAgent getCollectionAgent() {
        return DefaultSnmpCollectionAgent.create((Integer)this.m_intf.getId(), (IpInterfaceDao)this.m_ifDao, (PlatformTransactionManager)this.m_transMgr);
    }

    @Test
    public void testCommitWithNoDeclaredAttributes() throws Exception {
        RrdRepository repository = this.createRrdRepository();
        SnmpCollectionAgent agent = this.getCollectionAgent();
        MockDataCollectionConfig dataCollectionConfig = new MockDataCollectionConfig();
        OnmsSnmpCollection collection = new OnmsSnmpCollection(agent, new ServiceParameters(new HashMap()), (DataCollectionConfigDao)dataCollectionConfig, this.m_locationAwareSnmpClient);
        NodeResourceType resourceType = new NodeResourceType(agent, collection);
        NodeInfo resource = new NodeInfo(resourceType, (CollectionAgent)agent);
        RrdPersistOperationBuilder builder = new RrdPersistOperationBuilder(this.m_rrdStrategy, repository, (ResourceIdentifier)resource, "rrdName", false);
        builder.commit();
    }

    @Test
    public void testCommitWithDeclaredAttribute() throws Exception {
        File nodeDir = this.m_fileAnticipator.expecting(this.getSnmpRrdDirectory(), this.m_node.getId().toString());
        this.m_fileAnticipator.expecting(nodeDir, "rrdName" + this.m_rrdStrategy.getDefaultFileExtension());
        this.m_fileAnticipator.expecting(nodeDir, "rrdName.meta");
        RrdRepository repository = this.createRrdRepository();
        SnmpCollectionAgent agent = this.getCollectionAgent();
        MockDataCollectionConfig dataCollectionConfig = new MockDataCollectionConfig();
        OnmsSnmpCollection collection = new OnmsSnmpCollection(agent, new ServiceParameters(new HashMap()), (DataCollectionConfigDao)dataCollectionConfig, this.m_locationAwareSnmpClient);
        NodeResourceType resourceType = new NodeResourceType(agent, collection);
        NodeInfo resource = new NodeInfo(resourceType, (CollectionAgent)agent);
        MibObject mibObject = new MibObject();
        mibObject.setOid(".1.1.1.1");
        mibObject.setAlias("mibObjectAlias");
        mibObject.setType("counter");
        mibObject.setInstance("0");
        mibObject.setMaxval(null);
        mibObject.setMinval(null);
        SnmpCollectionSet collectionSet = new SnmpCollectionSet(agent, collection, this.m_locationAwareSnmpClient);
        NumericAttributeType attributeType = new NumericAttributeType((ResourceType)resourceType, "some-collection", mibObject, new AttributeGroupType("mibGroup", "ignore"));
        attributeType.storeResult(collectionSet, null, new SnmpResult(mibObject.getSnmpObjId(), new SnmpInstId(mibObject.getInstance()), SnmpUtils.getValueFactory().getOctetString("hello".getBytes())));
        RrdPersistOperationBuilder builder = new RrdPersistOperationBuilder(this.m_rrdStrategy, repository, (ResourceIdentifier)resource, "rrdName", false);
        builder.declareAttribute((CollectionAttributeType)attributeType);
        builder.commit();
    }

    @Test
    public void testCommitWithDeclaredAttributeAndValue() throws Exception {
        File nodeDir = this.m_fileAnticipator.expecting(this.getSnmpRrdDirectory(), this.m_node.getId().toString());
        this.m_fileAnticipator.expecting(nodeDir, "rrdName" + this.m_rrdStrategy.getDefaultFileExtension());
        this.m_fileAnticipator.expecting(nodeDir, "rrdName.meta");
        RrdRepository repository = this.createRrdRepository();
        SnmpCollectionAgent agent = this.getCollectionAgent();
        MockDataCollectionConfig dataCollectionConfig = new MockDataCollectionConfig();
        OnmsSnmpCollection collection = new OnmsSnmpCollection(agent, new ServiceParameters(new HashMap()), (DataCollectionConfigDao)dataCollectionConfig, this.m_locationAwareSnmpClient);
        NodeResourceType resourceType = new NodeResourceType(agent, collection);
        NodeInfo resource = new NodeInfo(resourceType, (CollectionAgent)agent);
        MibObject mibObject = new MibObject();
        mibObject.setOid(".1.1.1.1");
        mibObject.setAlias("mibObjectAlias");
        mibObject.setType("counter");
        mibObject.setInstance("0");
        mibObject.setMaxval(null);
        mibObject.setMinval(null);
        SnmpCollectionSet collectionSet = new SnmpCollectionSet(agent, collection, this.m_locationAwareSnmpClient);
        NumericAttributeType attributeType = new NumericAttributeType((ResourceType)resourceType, "some-collection", mibObject, new AttributeGroupType("mibGroup", "ignore"));
        attributeType.storeResult(collectionSet, null, new SnmpResult(mibObject.getSnmpObjId(), new SnmpInstId(mibObject.getInstance()), SnmpUtils.getValueFactory().getOctetString("hello".getBytes())));
        RrdPersistOperationBuilder builder = new RrdPersistOperationBuilder(this.m_rrdStrategy, repository, (ResourceIdentifier)resource, "rrdName", false);
        builder.declareAttribute((CollectionAttributeType)attributeType);
        builder.setAttributeValue((CollectionAttributeType)attributeType, (Number)6.022E23);
        builder.commit();
    }

    @Test
    public void testCommitWithDeclaredAttributeAndNullValue() throws Exception {
        RrdRepository repository = this.createRrdRepository();
        SnmpCollectionAgent agent = this.getCollectionAgent();
        MockDataCollectionConfig dataCollectionConfig = new MockDataCollectionConfig();
        OnmsSnmpCollection collection = new OnmsSnmpCollection(agent, new ServiceParameters(new HashMap()), (DataCollectionConfigDao)dataCollectionConfig, this.m_locationAwareSnmpClient);
        NodeResourceType resourceType = new NodeResourceType(agent, collection);
        NodeInfo resource = new NodeInfo(resourceType, (CollectionAgent)agent);
        MibObject mibObject = new MibObject();
        mibObject.setOid(".1.1.1.1");
        mibObject.setAlias("mibObjectAlias");
        mibObject.setType("string");
        mibObject.setInstance("0");
        mibObject.setMaxval(null);
        mibObject.setMinval(null);
        SnmpCollectionSet collectionSet = new SnmpCollectionSet(agent, collection, this.m_locationAwareSnmpClient);
        StringAttributeType attributeType = new StringAttributeType((ResourceType)resourceType, "some-collection", mibObject, new AttributeGroupType("mibGroup", "ignore"));
        attributeType.storeResult(collectionSet, null, new SnmpResult(mibObject.getSnmpObjId(), new SnmpInstId(mibObject.getInstance()), SnmpUtils.getValueFactory().getOctetString("hello".getBytes())));
        RrdPersistOperationBuilder builder = new RrdPersistOperationBuilder(this.m_rrdStrategy, repository, (ResourceIdentifier)resource, "rrdName", false);
        builder.declareAttribute((CollectionAttributeType)attributeType);
        builder.setAttributeValue((CollectionAttributeType)attributeType, null);
        builder.commit();
    }

    private RrdRepository createRrdRepository() throws IOException {
        RrdRepository repository = new RrdRepository();
        repository.setRrdBaseDir(this.getSnmpRrdDirectory());
        repository.setHeartBeat(600);
        repository.setStep(300);
        repository.setRraList(Collections.singletonList("RRA:AVERAGE:0.5:1:100"));
        return repository;
    }

    private File getSnmpRrdDirectory() throws IOException {
        if (this.m_snmpDirectory == null) {
            this.m_snmpDirectory = this.m_fileAnticipator.tempDir("snmp");
        }
        return this.m_snmpDirectory;
    }
}

