/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.io.Serializable;
import java.net.InetAddress;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.opennms.core.test.MockPlatformTransactionManager;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.collectd.DefaultSnmpCollectionAgent;
import org.opennms.netmgt.collectd.SnmpCollectionAgent;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.core.DefaultCollectionAgent;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.springframework.transaction.PlatformTransactionManager;

public class DefaultCollectionAgentTest {
    @After
    public void tearDown() {
        SnmpPeerFactory.setInstance(null);
    }

    @Test
    public void canGetLocationAwareAgentConfig() {
        SnmpPeerFactory snmpPeerFactory = (SnmpPeerFactory)Mockito.mock(SnmpPeerFactory.class);
        SnmpPeerFactory.setInstance((SnmpPeerFactory)snmpPeerFactory);
        Integer ifaceId = 1;
        IpInterfaceDao ifaceDao = (IpInterfaceDao)Mockito.mock(IpInterfaceDao.class);
        PlatformTransactionManager transMgr = (PlatformTransactionManager)Mockito.mock(PlatformTransactionManager.class);
        OnmsIpInterface ipIface = (OnmsIpInterface)Mockito.mock(OnmsIpInterface.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)ifaceDao.load((Serializable)ifaceId)).thenReturn((Object)ipIface);
        Mockito.when((Object)ipIface.getNode().getLocation().getLocationName()).thenReturn((Object)"Ocracoke");
        SnmpCollectionAgent agent = DefaultSnmpCollectionAgent.create((Integer)ifaceId, (IpInterfaceDao)ifaceDao, (PlatformTransactionManager)transMgr);
        agent.getAgentConfig();
        ((SnmpPeerFactory)Mockito.verify((Object)snmpPeerFactory, (VerificationMode)Mockito.times((int)1))).getAgentConfig((InetAddress)Matchers.any(), (String)Matchers.eq((Object)"Ocracoke"));
    }

    @Test
    public void verifyThatTheIpAndNodeIdAreCached() {
        OnmsNode node = new OnmsNode();
        node.setId(Integer.valueOf(11));
        OnmsIpInterface iface = new OnmsIpInterface();
        iface.setId(Integer.valueOf(42));
        iface.setNode(node);
        iface.setIpAddress(InetAddressUtils.ONE_TWENTY_SEVEN);
        IpInterfaceDao ifaceDao = (IpInterfaceDao)EasyMock.createMock(IpInterfaceDao.class);
        EasyMock.expect((Object)ifaceDao.load((Serializable)iface.getId())).andReturn((Object)iface).times(5);
        EasyMock.replay((Object[])new Object[]{ifaceDao});
        MockPlatformTransactionManager transMgr = new MockPlatformTransactionManager();
        CollectionAgent agent = DefaultCollectionAgent.create((Integer)iface.getId(), (IpInterfaceDao)ifaceDao, (PlatformTransactionManager)transMgr);
        EasyMock.verify((Object[])new Object[]{ifaceDao});
        Assert.assertEquals((Object)iface.getIpAddress(), (Object)agent.getAddress());
        Assert.assertEquals((long)node.getId().intValue(), (long)agent.getNodeId());
    }
}

