/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.util.Date;
import org.junit.Assert;
import org.junit.Test;
import org.opennms.netmgt.config.threshd.Threshold;
import org.opennms.netmgt.config.threshd.ThresholdType;
import org.opennms.netmgt.threshd.AbstractThresholdEvaluatorTestCase;
import org.opennms.netmgt.threshd.BaseThresholdDefConfigWrapper;
import org.opennms.netmgt.threshd.CollectionResourceWrapper;
import org.opennms.netmgt.threshd.MockCollectionResourceWrapper;
import org.opennms.netmgt.threshd.ThresholdConfigWrapper;
import org.opennms.netmgt.threshd.ThresholdEvaluatorRelativeChange;
import org.opennms.netmgt.threshd.ThresholdEvaluatorState;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.test.ThrowableAnticipator;

public class ThresholdEvaluatorRelativeChangeTest
extends AbstractThresholdEvaluatorTestCase {
    @Test
    public void testConstructor() {
        Threshold threshold = new Threshold();
        threshold.setType(ThresholdType.RELATIVE_CHANGE);
        threshold.setDsName("ds-name");
        threshold.setDsType("node");
        threshold.setValue(Double.valueOf(0.9));
        threshold.setRearm(Double.valueOf(0.5));
        threshold.setTrigger(Integer.valueOf(3));
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        new ThresholdEvaluatorRelativeChange.ThresholdEvaluatorStateRelativeChange((BaseThresholdDefConfigWrapper)wrapper);
    }

    @Test
    public void testConstructorThresholdNull() {
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalArgumentException("threshold argument cannot be null"));
        try {
            new ThresholdEvaluatorRelativeChange.ThresholdEvaluatorStateRelativeChange(null);
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    @Test
    public void testEvaluateOnce() {
        Threshold threshold = new Threshold();
        threshold.setType(ThresholdType.RELATIVE_CHANGE);
        threshold.setDsName("ds-name");
        threshold.setDsType("node");
        threshold.setValue(Double.valueOf(0.9));
        threshold.setRearm(Double.valueOf(0.5));
        threshold.setTrigger(Integer.valueOf(3));
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        ThresholdEvaluatorRelativeChange.ThresholdEvaluatorStateRelativeChange evaluator = new ThresholdEvaluatorRelativeChange.ThresholdEvaluatorStateRelativeChange((BaseThresholdDefConfigWrapper)wrapper);
        Assert.assertEquals((String)"should not trigger", (Object)ThresholdEvaluatorState.Status.NO_CHANGE, (Object)evaluator.evaluate(10.0));
    }

    @Test
    public void testEvaluateTwiceNoTrigger() {
        Threshold threshold = new Threshold();
        threshold.setType(ThresholdType.RELATIVE_CHANGE);
        threshold.setDsName("ds-name");
        threshold.setDsType("node");
        threshold.setValue(Double.valueOf(0.9));
        threshold.setRearm(Double.valueOf(0.5));
        threshold.setTrigger(Integer.valueOf(3));
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        ThresholdEvaluatorRelativeChange.ThresholdEvaluatorStateRelativeChange evaluator = new ThresholdEvaluatorRelativeChange.ThresholdEvaluatorStateRelativeChange((BaseThresholdDefConfigWrapper)wrapper);
        Assert.assertEquals((String)"should not trigger", (Object)ThresholdEvaluatorState.Status.NO_CHANGE, (Object)evaluator.evaluate(10.0));
        Assert.assertEquals((String)"should not trigger", (Object)ThresholdEvaluatorState.Status.NO_CHANGE, (Object)evaluator.evaluate(10.0));
    }

    @Test
    public void testEvaluateTwiceTriggerLowBelow() {
        Threshold threshold = new Threshold();
        threshold.setType(ThresholdType.RELATIVE_CHANGE);
        threshold.setDsName("ds-name");
        threshold.setDsType("node");
        threshold.setValue(Double.valueOf(0.9));
        threshold.setRearm(Double.valueOf(0.5));
        threshold.setTrigger(Integer.valueOf(3));
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        ThresholdEvaluatorRelativeChange.ThresholdEvaluatorStateRelativeChange evaluator = new ThresholdEvaluatorRelativeChange.ThresholdEvaluatorStateRelativeChange((BaseThresholdDefConfigWrapper)wrapper);
        Assert.assertEquals((String)"should not trigger", (Object)ThresholdEvaluatorState.Status.NO_CHANGE, (Object)evaluator.evaluate(10.0));
        Assert.assertEquals((String)"should trigger", (Object)ThresholdEvaluatorState.Status.TRIGGERED, (Object)evaluator.evaluate(8.0));
    }

    @Test
    public void testEvaluateTwiceTriggerLowEqual() {
        Threshold threshold = new Threshold();
        threshold.setType(ThresholdType.RELATIVE_CHANGE);
        threshold.setDsName("ds-name");
        threshold.setDsType("node");
        threshold.setValue(Double.valueOf(0.9));
        threshold.setRearm(Double.valueOf(0.5));
        threshold.setTrigger(Integer.valueOf(3));
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        ThresholdEvaluatorRelativeChange.ThresholdEvaluatorStateRelativeChange evaluator = new ThresholdEvaluatorRelativeChange.ThresholdEvaluatorStateRelativeChange((BaseThresholdDefConfigWrapper)wrapper);
        Assert.assertEquals((String)"should not trigger", (Object)ThresholdEvaluatorState.Status.NO_CHANGE, (Object)evaluator.evaluate(10.0));
        Assert.assertEquals((String)"should trigger", (Object)ThresholdEvaluatorState.Status.TRIGGERED, (Object)evaluator.evaluate(9.0));
    }

    @Test
    public void testEvaluateTwiceNoTriggerLowAbove() {
        Threshold threshold = new Threshold();
        threshold.setType(ThresholdType.RELATIVE_CHANGE);
        threshold.setDsName("ds-name");
        threshold.setDsType("node");
        threshold.setValue(Double.valueOf(0.9));
        threshold.setRearm(Double.valueOf(0.5));
        threshold.setTrigger(Integer.valueOf(3));
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        ThresholdEvaluatorRelativeChange.ThresholdEvaluatorStateRelativeChange evaluator = new ThresholdEvaluatorRelativeChange.ThresholdEvaluatorStateRelativeChange((BaseThresholdDefConfigWrapper)wrapper);
        Assert.assertEquals((String)"should not trigger", (Object)ThresholdEvaluatorState.Status.NO_CHANGE, (Object)evaluator.evaluate(10.0));
        Assert.assertEquals((String)"should not trigger", (Object)ThresholdEvaluatorState.Status.NO_CHANGE, (Object)evaluator.evaluate(9.5));
    }

    @Test
    public void testEvaluateTwiceTriggerHighAbove() {
        Threshold threshold = new Threshold();
        threshold.setType(ThresholdType.RELATIVE_CHANGE);
        threshold.setDsName("ds-name");
        threshold.setDsType("node");
        threshold.setValue(Double.valueOf(1.1));
        threshold.setRearm(Double.valueOf(0.5));
        threshold.setTrigger(Integer.valueOf(3));
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        ThresholdEvaluatorRelativeChange.ThresholdEvaluatorStateRelativeChange evaluator = new ThresholdEvaluatorRelativeChange.ThresholdEvaluatorStateRelativeChange((BaseThresholdDefConfigWrapper)wrapper);
        Assert.assertEquals((String)"should not trigger", (Object)ThresholdEvaluatorState.Status.NO_CHANGE, (Object)evaluator.evaluate(10.0));
        Assert.assertEquals((String)"should trigger", (Object)ThresholdEvaluatorState.Status.TRIGGERED, (Object)evaluator.evaluate(12.0));
    }

    @Test
    public void testEvaluateTwiceTriggerHighEqual() {
        Threshold threshold = new Threshold();
        threshold.setType(ThresholdType.RELATIVE_CHANGE);
        threshold.setDsName("ds-name");
        threshold.setDsType("node");
        threshold.setValue(Double.valueOf(1.1));
        threshold.setRearm(Double.valueOf(0.5));
        threshold.setTrigger(Integer.valueOf(3));
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        ThresholdEvaluatorRelativeChange.ThresholdEvaluatorStateRelativeChange evaluator = new ThresholdEvaluatorRelativeChange.ThresholdEvaluatorStateRelativeChange((BaseThresholdDefConfigWrapper)wrapper);
        Assert.assertEquals((String)"should not trigger", (Object)ThresholdEvaluatorState.Status.NO_CHANGE, (Object)evaluator.evaluate(10.0));
        Assert.assertEquals((String)"should trigger", (Object)ThresholdEvaluatorState.Status.TRIGGERED, (Object)evaluator.evaluate(11.0));
    }

    @Test
    public void testEvaluateTwiceNoTriggerHighBelow() {
        Threshold threshold = new Threshold();
        threshold.setType(ThresholdType.RELATIVE_CHANGE);
        threshold.setDsName("ds-name");
        threshold.setDsType("node");
        threshold.setValue(Double.valueOf(1.1));
        threshold.setRearm(Double.valueOf(0.5));
        threshold.setTrigger(Integer.valueOf(3));
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        ThresholdEvaluatorRelativeChange.ThresholdEvaluatorStateRelativeChange evaluator = new ThresholdEvaluatorRelativeChange.ThresholdEvaluatorStateRelativeChange((BaseThresholdDefConfigWrapper)wrapper);
        Assert.assertEquals((String)"should not trigger", (Object)ThresholdEvaluatorState.Status.NO_CHANGE, (Object)evaluator.evaluate(10.0));
        Assert.assertEquals((String)"should not trigger", (Object)ThresholdEvaluatorState.Status.NO_CHANGE, (Object)evaluator.evaluate(10.5));
    }

    @Test
    public void testEvaluateTwiceNoTriggerHighFirstZero() {
        Threshold threshold = new Threshold();
        threshold.setType(ThresholdType.RELATIVE_CHANGE);
        threshold.setDsName("ds-name");
        threshold.setDsType("node");
        threshold.setValue(Double.valueOf(1.1));
        threshold.setRearm(Double.valueOf(0.5));
        threshold.setTrigger(Integer.valueOf(3));
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        ThresholdEvaluatorRelativeChange.ThresholdEvaluatorStateRelativeChange evaluator = new ThresholdEvaluatorRelativeChange.ThresholdEvaluatorStateRelativeChange((BaseThresholdDefConfigWrapper)wrapper);
        Assert.assertEquals((String)"should not trigger on first evaluate", (Object)ThresholdEvaluatorState.Status.NO_CHANGE, (Object)evaluator.evaluate(0.0));
        Assert.assertEquals((String)"should not trigger on second evaluate", (Object)ThresholdEvaluatorState.Status.NO_CHANGE, (Object)evaluator.evaluate(1000.0));
    }

    @Test
    public void testEvaluateThriceTriggerHighFirstZero() {
        Threshold threshold = new Threshold();
        threshold.setType(ThresholdType.RELATIVE_CHANGE);
        threshold.setDsName("ds-name");
        threshold.setDsType("node");
        threshold.setValue(Double.valueOf(1.1));
        threshold.setRearm(Double.valueOf(0.5));
        threshold.setTrigger(Integer.valueOf(3));
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        ThresholdEvaluatorRelativeChange.ThresholdEvaluatorStateRelativeChange evaluator = new ThresholdEvaluatorRelativeChange.ThresholdEvaluatorStateRelativeChange((BaseThresholdDefConfigWrapper)wrapper);
        Assert.assertEquals((String)"should not trigger on first evaluate", (Object)ThresholdEvaluatorState.Status.NO_CHANGE, (Object)evaluator.evaluate(0.0));
        Assert.assertEquals((String)"should not trigger on second evaluate", (Object)ThresholdEvaluatorState.Status.NO_CHANGE, (Object)evaluator.evaluate(1000.0));
        Assert.assertEquals((String)"should trigger on third evaluate", (Object)ThresholdEvaluatorState.Status.TRIGGERED, (Object)evaluator.evaluate(1200.0));
    }

    @Test
    public void testGetEventForStateNoChange() {
        Threshold threshold = new Threshold();
        threshold.setType(ThresholdType.RELATIVE_CHANGE);
        threshold.setDsName("ds-name");
        threshold.setDsType("node");
        threshold.setValue(Double.valueOf(1.1));
        threshold.setRearm(Double.valueOf(0.5));
        threshold.setTrigger(Integer.valueOf(3));
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        ThresholdEvaluatorRelativeChange.ThresholdEvaluatorStateRelativeChange evaluator = new ThresholdEvaluatorRelativeChange.ThresholdEvaluatorStateRelativeChange((BaseThresholdDefConfigWrapper)wrapper);
        Assert.assertNull((String)"should not have created an event", (Object)evaluator.getEventForState(ThresholdEvaluatorState.Status.NO_CHANGE, new Date(), 10.0, null));
    }

    @Test
    public void testGetEventForStateTriggered() {
        Threshold threshold = new Threshold();
        threshold.setType(ThresholdType.RELATIVE_CHANGE);
        threshold.setDsName("ds-name");
        threshold.setDsType("node");
        threshold.setValue(Double.valueOf(1.1));
        threshold.setRearm(Double.valueOf(0.5));
        threshold.setTrigger(Integer.valueOf(3));
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        ThresholdEvaluatorRelativeChange.ThresholdEvaluatorStateRelativeChange evaluator = new ThresholdEvaluatorRelativeChange.ThresholdEvaluatorStateRelativeChange((BaseThresholdDefConfigWrapper)wrapper);
        Assert.assertEquals((String)"should not trigger", (Object)ThresholdEvaluatorState.Status.NO_CHANGE, (Object)evaluator.evaluate(8.0));
        Assert.assertEquals((String)"should trigger", (Object)ThresholdEvaluatorState.Status.TRIGGERED, (Object)evaluator.evaluate(10.0));
        Event event = evaluator.getEventForState(ThresholdEvaluatorState.Status.TRIGGERED, new Date(), 10.0, null);
        Assert.assertNotNull((String)"should have created an event", (Object)event);
        Assert.assertEquals((String)"UEIs should be the same", (Object)"uei.opennms.org/threshold/relativeChangeExceeded", (Object)event.getUei());
        Assert.assertNotNull((String)"event should have parms", (Object)event.getParmCollection());
        ThresholdEvaluatorRelativeChangeTest.parmPresentAndValueNonNull(event, "instance");
        ThresholdEvaluatorRelativeChangeTest.parmPresentWithValue(event, "value", "10.0");
        ThresholdEvaluatorRelativeChangeTest.parmPresentWithValue(event, "previousValue", "8.0");
        ThresholdEvaluatorRelativeChangeTest.parmPresentWithValue(event, "multiplier", "1.1");
        event = evaluator.getEventForState(ThresholdEvaluatorState.Status.TRIGGERED, new Date(), 10.0, (CollectionResourceWrapper)new MockCollectionResourceWrapper("testInstance"));
        Assert.assertNotNull((String)"should have created an event", (Object)event);
        Assert.assertEquals((String)"UEIs should be the same", (Object)"uei.opennms.org/threshold/relativeChangeExceeded", (Object)event.getUei());
        Assert.assertNotNull((String)"event should have parms", (Object)event.getParmCollection());
        ThresholdEvaluatorRelativeChangeTest.parmPresentWithValue(event, "instance", "testInstance");
        ThresholdEvaluatorRelativeChangeTest.parmPresentWithValue(event, "value", "10.0");
        ThresholdEvaluatorRelativeChangeTest.parmPresentWithValue(event, "previousValue", "8.0");
        ThresholdEvaluatorRelativeChangeTest.parmPresentWithValue(event, "multiplier", "1.1");
    }

    @Test
    public void testGetEventForStateDefaultUEIS() {
        Threshold threshold = new Threshold();
        threshold.setType(ThresholdType.RELATIVE_CHANGE);
        threshold.setDsName("ds-name");
        threshold.setDsType("node");
        threshold.setValue(Double.valueOf(99.0));
        threshold.setRearm(Double.valueOf(95.0));
        threshold.setTrigger(Integer.valueOf(1));
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        ThresholdEvaluatorRelativeChange.ThresholdEvaluatorStateRelativeChange item = new ThresholdEvaluatorRelativeChange.ThresholdEvaluatorStateRelativeChange((BaseThresholdDefConfigWrapper)wrapper);
        Event event = item.getEventForState(ThresholdEvaluatorState.Status.TRIGGERED, new Date(), 100.0, null);
        Assert.assertEquals((String)"UEI should be the relativeChangeThresholdTriggerd", (Object)"uei.opennms.org/threshold/relativeChangeExceeded", (Object)event.getUei());
    }

    @Test
    public void testGetEventForStateCustomUEIS() {
        String triggeredUEI = "uei.opennms.org/custom/relativeChangeThresholdTriggered";
        Threshold threshold = new Threshold();
        threshold.setType(ThresholdType.RELATIVE_CHANGE);
        threshold.setDsName("ds-name");
        threshold.setDsType("node");
        threshold.setValue(Double.valueOf(99.0));
        threshold.setRearm(Double.valueOf(95.0));
        threshold.setTrigger(Integer.valueOf(1));
        threshold.setTriggeredUEI(triggeredUEI);
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        ThresholdEvaluatorRelativeChange.ThresholdEvaluatorStateRelativeChange item = new ThresholdEvaluatorRelativeChange.ThresholdEvaluatorStateRelativeChange((BaseThresholdDefConfigWrapper)wrapper);
        Event event = item.getEventForState(ThresholdEvaluatorState.Status.TRIGGERED, new Date(), 100.0, null);
        Assert.assertEquals((String)"UEI should be the uei.opennms.org/custom/relativeChangeThresholdTriggered", (Object)triggeredUEI, (Object)event.getUei());
    }

    @Test
    public void testNegativeNumberTriggers() {
        Threshold threshold = new Threshold();
        threshold.setType(ThresholdType.RELATIVE_CHANGE);
        threshold.setDsName("ds-name");
        threshold.setDsType("node");
        threshold.setValue(Double.valueOf(1.1));
        threshold.setRearm(Double.valueOf(0.5));
        threshold.setTrigger(Integer.valueOf(3));
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        ThresholdEvaluatorRelativeChange.ThresholdEvaluatorStateRelativeChange evaluator = new ThresholdEvaluatorRelativeChange.ThresholdEvaluatorStateRelativeChange((BaseThresholdDefConfigWrapper)wrapper);
        Assert.assertEquals((String)"should not trigger", (Object)ThresholdEvaluatorState.Status.NO_CHANGE, (Object)evaluator.evaluate(-10.0));
        Assert.assertEquals((String)"should trigger", (Object)ThresholdEvaluatorState.Status.TRIGGERED, (Object)evaluator.evaluate(-12.0));
    }

    @Test
    public void testNegativeNumberNotTriggers() {
        Threshold threshold = new Threshold();
        threshold.setType(ThresholdType.RELATIVE_CHANGE);
        threshold.setDsName("ds-name");
        threshold.setDsType("node");
        threshold.setValue(Double.valueOf(1.1));
        threshold.setRearm(Double.valueOf(0.5));
        threshold.setTrigger(Integer.valueOf(3));
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        ThresholdEvaluatorRelativeChange.ThresholdEvaluatorStateRelativeChange evaluator = new ThresholdEvaluatorRelativeChange.ThresholdEvaluatorStateRelativeChange((BaseThresholdDefConfigWrapper)wrapper);
        Assert.assertEquals((String)"should not trigger", (Object)ThresholdEvaluatorState.Status.NO_CHANGE, (Object)evaluator.evaluate(-10.0));
        Assert.assertEquals((String)"should not trigger", (Object)ThresholdEvaluatorState.Status.NO_CHANGE, (Object)evaluator.evaluate(-10.5));
    }

    @Test
    public void testNegativeValueNoChange() {
        Threshold threshold = new Threshold();
        threshold.setType(ThresholdType.RELATIVE_CHANGE);
        threshold.setDsName("ds-name");
        threshold.setDsType("node");
        threshold.setValue(Double.valueOf(0.9));
        threshold.setRearm(Double.valueOf(0.5));
        threshold.setTrigger(Integer.valueOf(1));
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        ThresholdEvaluatorRelativeChange.ThresholdEvaluatorStateRelativeChange evaluator = new ThresholdEvaluatorRelativeChange.ThresholdEvaluatorStateRelativeChange((BaseThresholdDefConfigWrapper)wrapper);
        Assert.assertEquals((String)"should not trigger", (Object)ThresholdEvaluatorState.Status.NO_CHANGE, (Object)evaluator.evaluate(-10.0));
        Assert.assertEquals((String)"should not trigger", (Object)ThresholdEvaluatorState.Status.NO_CHANGE, (Object)evaluator.evaluate(-10.0));
    }
}

