/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd;

import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.core.test.MockLogAppender;
import org.opennms.netmgt.config.EnhancedLinkdConfig;
import org.opennms.netmgt.config.EnhancedLinkdConfigManager;
import org.opennms.netmgt.config.enlinkd.EnlinkdConfiguration;
import org.opennms.netmgt.enlinkd.EnLinkdTestHelper;
import org.opennms.netmgt.enlinkd.EnhancedLinkd;
import org.opennms.netmgt.enlinkd.Node;
import org.opennms.netmgt.enlinkd.NodeDiscoveryBridgeTopology;
import org.opennms.netmgt.model.BridgeMacLink;
import org.opennms.netmgt.model.topology.Bridge;
import org.opennms.netmgt.model.topology.BroadcastDomain;
import org.opennms.netmgt.model.topology.SharedSegment;

public class BroadcastDomainTest
extends EnLinkdTestHelper {
    EnhancedLinkd linkd;
    private static String location = "default";

    @Before
    public void setUp() throws Exception {
        Properties p = new Properties();
        p.setProperty("log4j.logger.org.opennms.netmgt.model.topology", "DEBUG");
        MockLogAppender.setupLogging((Properties)p);
        this.linkd = new EnhancedLinkd();
        EnhancedLinkdConfigManager config = new EnhancedLinkdConfigManager(){

            public void save() throws IOException {
            }

            public void reload() throws IOException {
                m_config = new EnlinkdConfiguration();
                m_config.setInitialSleepTime(Long.valueOf(1000L));
                m_config.setRescanInterval(Long.valueOf(10000L));
            }

            protected void saveXml(String xml) throws IOException {
            }
        };
        config.reload();
        this.linkd.setLinkdConfig((EnhancedLinkdConfig)config);
    }

    @Test
    public void testOneBridgeOnePortOneMac() throws Exception {
        EnLinkdTestHelper.OneBridgeOnePortOneMacTopology topology = new EnLinkdTestHelper.OneBridgeOnePortOneMacTopology();
        BroadcastDomain domain = new BroadcastDomain();
        domain.addBridge(new Bridge(topology.nodeAId));
        domain.setBridgeElements(topology.elemlist);
        NodeDiscoveryBridgeTopology ndbt = new NodeDiscoveryBridgeTopology(this.linkd, new Node(topology.nodeAId.intValue(), null, null, null, location));
        ndbt.setDomain(domain);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeAId.intValue()), topology.bftA);
        ndbt.calculate();
        Assert.assertEquals((long)topology.nodeAId.intValue(), (long)domain.getRootBridge().getId().intValue());
        topology.check(ndbt.getDomain());
    }

    @Test
    public void testOneBridgeMoreMacOnePort() throws Exception {
        EnLinkdTestHelper.OneBridgeMoreMacOnePortTopology topology = new EnLinkdTestHelper.OneBridgeMoreMacOnePortTopology();
        BroadcastDomain domain = new BroadcastDomain();
        domain.addBridge(new Bridge(topology.nodeAId));
        domain.setBridgeElements(topology.elemlist);
        NodeDiscoveryBridgeTopology ndbt = new NodeDiscoveryBridgeTopology(this.linkd, new Node(topology.nodeAId.intValue(), null, null, null, location));
        ndbt.setDomain(domain);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeAId.intValue()), topology.bftA);
        ndbt.calculate();
        Assert.assertEquals((long)topology.nodeAId.intValue(), (long)domain.getRootBridge().getId().intValue());
        topology.check(ndbt.getDomain());
    }

    @Test
    public void testOneBridgeComplete() throws Exception {
        EnLinkdTestHelper.OneBridgeCompleteTopology topology = new EnLinkdTestHelper.OneBridgeCompleteTopology();
        BroadcastDomain domain = new BroadcastDomain();
        domain.addBridge(new Bridge(topology.nodeAId));
        domain.setBridgeElements(topology.elemlist);
        NodeDiscoveryBridgeTopology ndbt = new NodeDiscoveryBridgeTopology(this.linkd, new Node(topology.nodeAId.intValue(), null, null, null, location));
        ndbt.setDomain(domain);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeAId.intValue()), topology.bftA);
        ndbt.calculate();
        Assert.assertEquals((long)topology.nodeAId.intValue(), (long)domain.getRootBridge().getId().intValue());
        topology.check(ndbt.getDomain());
    }

    @Test
    public void testTwoConnectedBridge() throws Exception {
        EnLinkdTestHelper.TwoConnectedBridgeTopology topology = new EnLinkdTestHelper.TwoConnectedBridgeTopology();
        BroadcastDomain domain = new BroadcastDomain();
        domain.addBridge(new Bridge(topology.nodeAId));
        domain.addBridge(new Bridge(topology.nodeBId));
        domain.setBridgeElements(topology.elemlist);
        NodeDiscoveryBridgeTopology ndbt = new NodeDiscoveryBridgeTopology(this.linkd, new Node(topology.nodeAId.intValue(), null, null, null, location));
        ndbt.setDomain(domain);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeAId.intValue()), topology.bftA);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeBId.intValue()), topology.bftB);
        ndbt.calculate();
        Assert.assertEquals((long)topology.nodeAId.intValue(), (long)domain.getRootBridge().getId().intValue());
        topology.check(ndbt.getDomain(), false);
        domain.hierarchySetUp(domain.getBridge(topology.nodeBId.intValue()));
        Assert.assertEquals((long)topology.nodeBId.intValue(), (long)domain.getRootBridge().getId().intValue());
        topology.check(ndbt.getDomain(), true);
    }

    @Test
    public void testTwoMergeBridge() throws Exception {
        EnLinkdTestHelper.TwoMergeBridgeTopology topology = new EnLinkdTestHelper.TwoMergeBridgeTopology();
        BroadcastDomain domain = new BroadcastDomain();
        domain.addBridge(new Bridge(topology.nodeAId));
        domain.addBridge(new Bridge(topology.nodeBId));
        domain.setBridgeElements(topology.elemlist);
        NodeDiscoveryBridgeTopology ndbt = new NodeDiscoveryBridgeTopology(this.linkd, new Node(topology.nodeAId.intValue(), null, null, null, location));
        ndbt.setDomain(domain);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeAId.intValue()), topology.bftA);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeBId.intValue()), topology.bftB);
        ndbt.calculate();
        Assert.assertEquals((long)topology.nodeAId.intValue(), (long)domain.getRootBridge().getId().intValue());
        topology.check(ndbt.getDomain());
    }

    @Test
    public void testTwoBridgeWithBackbonePorts() {
        EnLinkdTestHelper.TwoBridgeWithBackbonePortsTopology topology = new EnLinkdTestHelper.TwoBridgeWithBackbonePortsTopology();
        BroadcastDomain domain = new BroadcastDomain();
        domain.addBridge(new Bridge(topology.nodeAId));
        domain.addBridge(new Bridge(topology.nodeBId));
        domain.setBridgeElements(topology.elemlist);
        NodeDiscoveryBridgeTopology ndbt = new NodeDiscoveryBridgeTopology(this.linkd, new Node(topology.nodeAId.intValue(), null, null, null, location));
        ndbt.setDomain(domain);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeAId.intValue()), topology.bftA);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeBId.intValue()), topology.bftB);
        ndbt.calculate();
        Assert.assertEquals((long)topology.nodeAId.intValue(), (long)domain.getRootBridge().getId().intValue());
        topology.check(ndbt.getDomain());
    }

    @Test
    public void testCleanTopology() {
        EnLinkdTestHelper.TwoBridgeWithBackbonePortsTopology topology = new EnLinkdTestHelper.TwoBridgeWithBackbonePortsTopology();
        BroadcastDomain domain = new BroadcastDomain();
        domain.addBridge(new Bridge(topology.nodeAId));
        domain.addBridge(new Bridge(topology.nodeBId));
        domain.setBridgeElements(topology.elemlist);
        NodeDiscoveryBridgeTopology ndbt = new NodeDiscoveryBridgeTopology(this.linkd, new Node(topology.nodeAId.intValue(), null, null, null, location));
        ndbt.setDomain(domain);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeAId.intValue()), topology.bftA);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeBId.intValue()), topology.bftB);
        ndbt.calculate();
        domain.clearTopologyForBridge(topology.nodeBId);
        Assert.assertEquals((long)topology.nodeAId.intValue(), (long)domain.getRootBridge().getId().intValue());
        Assert.assertEquals((long)2L, (long)domain.getTopology().size());
        Assert.assertEquals((long)5L, (long)domain.getMacsOnDomain().size());
        for (SharedSegment segment : domain.getTopology()) {
            Assert.assertEquals((long)0L, (long)segment.getBridgeBridgeLinks().size());
            Assert.assertEquals((long)1L, (long)segment.getBridgeIdsOnSegment().size());
            Assert.assertEquals((long)topology.nodeAId.intValue(), (long)((Integer)segment.getBridgeIdsOnSegment().iterator().next()).intValue());
            if (segment.containsMac(topology.macA11) && segment.containsMac(topology.macA12)) {
                Assert.assertEquals((long)2L, (long)segment.getMacsOnSegment().size());
                Assert.assertEquals((long)2L, (long)segment.getBridgeMacLinks().size());
                for (BridgeMacLink link : segment.getBridgeMacLinks()) {
                    Assert.assertEquals((long)topology.portA1.intValue(), (long)link.getBridgePort().intValue());
                }
                continue;
            }
            if (segment.containsMac(topology.macB21) && segment.containsMac(topology.macB22) && segment.containsMac(topology.macAB)) {
                Assert.assertEquals((long)3L, (long)segment.getMacsOnSegment().size());
                Assert.assertEquals((long)3L, (long)segment.getBridgeMacLinks().size());
                for (BridgeMacLink link : segment.getBridgeMacLinks()) {
                    Assert.assertEquals((long)topology.portAB.intValue(), (long)link.getBridgePort().intValue());
                }
                continue;
            }
            Assert.assertEquals((Object)true, (Object)false);
        }
    }

    @Test
    public void testCleanTopologyRoot() {
        EnLinkdTestHelper.TwoBridgeWithBackbonePortsTopology topology = new EnLinkdTestHelper.TwoBridgeWithBackbonePortsTopology();
        BroadcastDomain domain = new BroadcastDomain();
        domain.addBridge(new Bridge(topology.nodeAId));
        domain.addBridge(new Bridge(topology.nodeBId));
        domain.setBridgeElements(topology.elemlist);
        NodeDiscoveryBridgeTopology ndbt = new NodeDiscoveryBridgeTopology(this.linkd, new Node(topology.nodeAId.intValue(), null, null, null, location));
        ndbt.setDomain(domain);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeAId.intValue()), topology.bftA);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeBId.intValue()), topology.bftB);
        ndbt.calculate();
        domain.clearTopologyForBridge(topology.nodeAId);
        Assert.assertEquals((long)5L, (long)domain.getMacsOnDomain().size());
        Assert.assertEquals((long)topology.nodeBId.intValue(), (long)domain.getRootBridge().getId().intValue());
        Assert.assertEquals((long)2L, (long)domain.getTopology().size());
        for (SharedSegment segment : domain.getTopology()) {
            Assert.assertEquals((long)0L, (long)segment.getBridgeBridgeLinks().size());
            Assert.assertEquals((long)1L, (long)segment.getBridgeIdsOnSegment().size());
            Assert.assertEquals((long)topology.nodeBId.intValue(), (long)((Integer)segment.getBridgeIdsOnSegment().iterator().next()).intValue());
            if (segment.containsMac(topology.macA11) && segment.containsMac(topology.macA12) && segment.containsMac(topology.macAB)) {
                Assert.assertEquals((long)3L, (long)segment.getMacsOnSegment().size());
                Assert.assertEquals((long)3L, (long)segment.getBridgeMacLinks().size());
                for (BridgeMacLink link : segment.getBridgeMacLinks()) {
                    Assert.assertEquals((long)topology.portBA.intValue(), (long)link.getBridgePort().intValue());
                }
                continue;
            }
            if (segment.containsMac(topology.macB21) && segment.containsMac(topology.macB22)) {
                Assert.assertEquals((long)2L, (long)segment.getMacsOnSegment().size());
                Assert.assertEquals((long)2L, (long)segment.getBridgeMacLinks().size());
                for (BridgeMacLink link : segment.getBridgeMacLinks()) {
                    Assert.assertEquals((long)topology.portB2.intValue(), (long)link.getBridgePort().intValue());
                }
                continue;
            }
            Assert.assertEquals((Object)true, (Object)false);
        }
    }

    @Test
    public void testTwoBridgeWithBackbonePortsUsingBridgeAddressInBft() {
        EnLinkdTestHelper.TwoBridgeWithBackbonePortsTopologyWithBridgeinBft topology = new EnLinkdTestHelper.TwoBridgeWithBackbonePortsTopologyWithBridgeinBft();
        BroadcastDomain domain = new BroadcastDomain();
        domain.addBridge(new Bridge(topology.nodeAId));
        domain.addBridge(new Bridge(topology.nodeBId));
        domain.setBridgeElements(topology.elemlist);
        NodeDiscoveryBridgeTopology ndbt = new NodeDiscoveryBridgeTopology(this.linkd, new Node(topology.nodeBId.intValue(), null, null, null, location));
        ndbt.setDomain(domain);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeAId.intValue()), topology.bftA);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeBId.intValue()), topology.bftB);
        ndbt.calculate();
        Assert.assertEquals((long)topology.nodeBId.intValue(), (long)domain.getRootBridge().getId().intValue());
        topology.check(ndbt.getDomain());
    }

    @Test
    public void testTwoBridgeOneCalculation() {
        EnLinkdTestHelper.TwoNodeTopology topology = new EnLinkdTestHelper.TwoNodeTopology();
        BroadcastDomain domain = new BroadcastDomain();
        domain.addBridge(new Bridge(topology.nodeAId));
        domain.addBridge(new Bridge(topology.nodeBId));
        domain.setBridgeElements(topology.elemlist);
        NodeDiscoveryBridgeTopology ndbt = new NodeDiscoveryBridgeTopology(this.linkd, new Node(topology.nodeAId.intValue(), null, null, null, location));
        ndbt.setDomain(domain);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeAId.intValue()), topology.bftA);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeBId.intValue()), topology.bftB);
        ndbt.calculate();
        Assert.assertEquals((Object)topology.nodeBId, (Object)ndbt.getDomain().getRootBridgeId());
        topology.check2nodeTopology(ndbt.getDomain(), true);
    }

    @Test
    public void testTwoBridgeTwoCalculation() {
        EnLinkdTestHelper.TwoNodeTopology topology = new EnLinkdTestHelper.TwoNodeTopology();
        BroadcastDomain domain = new BroadcastDomain();
        domain.addBridge(new Bridge(topology.nodeBId));
        domain.setBridgeElements(topology.elemlist);
        NodeDiscoveryBridgeTopology ndbt = new NodeDiscoveryBridgeTopology(this.linkd, new Node(topology.nodeAId.intValue(), null, null, null, location));
        ndbt.setDomain(domain);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeBId.intValue()), topology.bftB);
        ndbt.calculate();
        List shsegs = ndbt.getDomain().getTopology();
        Assert.assertEquals((long)3L, (long)shsegs.size());
        domain.addBridge(new Bridge(topology.nodeAId));
        domain.setBridgeElements(topology.elemlist);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeAId.intValue()), topology.bftA);
        ndbt.calculate();
        topology.check2nodeTopology(ndbt.getDomain(), true);
        Assert.assertEquals((Object)topology.nodeBId, (Object)domain.getRootBridgeId());
    }

    @Test
    public void testTwoBridgeTwoCalculationReverse() {
        EnLinkdTestHelper.TwoNodeTopology topology = new EnLinkdTestHelper.TwoNodeTopology();
        BroadcastDomain domain = new BroadcastDomain();
        domain.addBridge(new Bridge(topology.nodeAId));
        domain.setBridgeElements(topology.elemlist);
        NodeDiscoveryBridgeTopology ndbt = new NodeDiscoveryBridgeTopology(this.linkd, new Node(topology.nodeAId.intValue(), null, null, null, location));
        ndbt.setDomain(domain);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeAId.intValue()), topology.bftA);
        ndbt.calculate();
        List shsegs = ndbt.getDomain().getTopology();
        Assert.assertEquals((long)3L, (long)shsegs.size());
        domain.addBridge(new Bridge(topology.nodeBId));
        domain.setBridgeElements(topology.elemlist);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeBId.intValue()), topology.bftB);
        ndbt.calculate();
        topology.check2nodeTopology(ndbt.getDomain(), false);
        Assert.assertEquals((Object)topology.nodeAId, (Object)domain.getRootBridgeId());
    }

    @Test
    public void testAB() {
        EnLinkdTestHelper.ABCTopology topology = new EnLinkdTestHelper.ABCTopology();
        BroadcastDomain domain = new BroadcastDomain();
        domain.addBridge(new Bridge(topology.nodeAId));
        domain.addBridge(new Bridge(topology.nodeBId));
        domain.setBridgeElements(topology.elemlist);
        NodeDiscoveryBridgeTopology ndbt = new NodeDiscoveryBridgeTopology(this.linkd, new Node(topology.nodeAId.intValue(), null, null, null, location));
        ndbt.setDomain(domain);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeAId.intValue()), topology.bftA);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeBId.intValue()), topology.bftB);
        ndbt.calculate();
        topology.checkAB(ndbt.getDomain());
    }

    @Test
    public void testBA() {
        EnLinkdTestHelper.ABCTopology topology = new EnLinkdTestHelper.ABCTopology();
        BroadcastDomain domain = new BroadcastDomain();
        domain.addBridge(new Bridge(topology.nodeBId));
        domain.addBridge(new Bridge(topology.nodeAId));
        domain.setBridgeElements(topology.elemlist);
        NodeDiscoveryBridgeTopology ndbt = new NodeDiscoveryBridgeTopology(this.linkd, new Node(topology.nodeAId.intValue(), null, null, null, location));
        ndbt.setDomain(domain);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeBId.intValue()), topology.bftB);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeAId.intValue()), topology.bftA);
        ndbt.calculate();
        topology.checkAB(ndbt.getDomain());
    }

    @Test
    public void testAC() {
        EnLinkdTestHelper.ABCTopology topology = new EnLinkdTestHelper.ABCTopology();
        BroadcastDomain domain = new BroadcastDomain();
        domain.addBridge(new Bridge(topology.nodeAId));
        domain.addBridge(new Bridge(topology.nodeCId));
        domain.setBridgeElements(topology.elemlist);
        NodeDiscoveryBridgeTopology ndbt = new NodeDiscoveryBridgeTopology(this.linkd, new Node(topology.nodeAId.intValue(), null, null, null, location));
        ndbt.setDomain(domain);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeAId.intValue()), topology.bftA);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeCId.intValue()), topology.bftC);
        ndbt.calculate();
        topology.checkAC(ndbt.getDomain());
    }

    @Test
    public void testCA() {
        EnLinkdTestHelper.ABCTopology topology = new EnLinkdTestHelper.ABCTopology();
        BroadcastDomain domain = new BroadcastDomain();
        domain.addBridge(new Bridge(topology.nodeCId));
        domain.addBridge(new Bridge(topology.nodeAId));
        domain.setBridgeElements(topology.elemlist);
        NodeDiscoveryBridgeTopology ndbt = new NodeDiscoveryBridgeTopology(this.linkd, new Node(topology.nodeAId.intValue(), null, null, null, location));
        ndbt.setDomain(domain);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeCId.intValue()), topology.bftC);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeAId.intValue()), topology.bftA);
        ndbt.calculate();
        topology.checkAC(ndbt.getDomain());
    }

    @Test
    public void testBC() {
        EnLinkdTestHelper.ABCTopology topology = new EnLinkdTestHelper.ABCTopology();
        BroadcastDomain domain = new BroadcastDomain();
        domain.addBridge(new Bridge(topology.nodeBId));
        domain.addBridge(new Bridge(topology.nodeCId));
        domain.setBridgeElements(topology.elemlist);
        NodeDiscoveryBridgeTopology ndbt = new NodeDiscoveryBridgeTopology(this.linkd, new Node(topology.nodeAId.intValue(), null, null, null, location));
        ndbt.setDomain(domain);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeBId.intValue()), topology.bftB);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeCId.intValue()), topology.bftC);
        ndbt.calculate();
        topology.checkBC(ndbt.getDomain());
    }

    @Test
    public void testCB() {
        EnLinkdTestHelper.ABCTopology topology = new EnLinkdTestHelper.ABCTopology();
        BroadcastDomain domain = new BroadcastDomain();
        domain.addBridge(new Bridge(topology.nodeCId));
        domain.addBridge(new Bridge(topology.nodeBId));
        domain.setBridgeElements(topology.elemlist);
        NodeDiscoveryBridgeTopology ndbt = new NodeDiscoveryBridgeTopology(this.linkd, new Node(topology.nodeAId.intValue(), null, null, null, location));
        ndbt.setDomain(domain);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeCId.intValue()), topology.bftC);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeBId.intValue()), topology.bftB);
        ndbt.calculate();
        topology.checkBC(ndbt.getDomain());
    }

    @Test
    public void testABC() {
        EnLinkdTestHelper.ABCTopology topology = new EnLinkdTestHelper.ABCTopology();
        BroadcastDomain domain = new BroadcastDomain();
        domain.addBridge(new Bridge(topology.nodeAId));
        domain.addBridge(new Bridge(topology.nodeBId));
        domain.addBridge(new Bridge(topology.nodeCId));
        domain.setBridgeElements(topology.elemlist);
        NodeDiscoveryBridgeTopology ndbt = new NodeDiscoveryBridgeTopology(this.linkd, new Node(topology.nodeAId.intValue(), null, null, null, location));
        ndbt.setDomain(domain);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeAId.intValue()), topology.bftA);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeBId.intValue()), topology.bftB);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeCId.intValue()), topology.bftC);
        ndbt.calculate();
        topology.check(ndbt.getDomain());
    }

    @Test
    public void testAThenBC() {
        EnLinkdTestHelper.ABCTopology topology = new EnLinkdTestHelper.ABCTopology();
        BroadcastDomain domain = new BroadcastDomain();
        domain.addBridge(new Bridge(topology.nodeAId));
        domain.setBridgeElements(topology.elemlist);
        NodeDiscoveryBridgeTopology ndbt = new NodeDiscoveryBridgeTopology(this.linkd, new Node(topology.nodeAId.intValue(), null, null, null, location));
        ndbt.setDomain(domain);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeAId.intValue()), topology.bftA);
        ndbt.calculate();
        domain.addBridge(new Bridge(topology.nodeBId));
        domain.addBridge(new Bridge(topology.nodeCId));
        domain.setBridgeElements(topology.elemlist);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeBId.intValue()), topology.bftB);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeCId.intValue()), topology.bftC);
        ndbt.calculate();
        topology.check(ndbt.getDomain());
    }

    @Test
    public void testACThenB() {
        EnLinkdTestHelper.ABCTopology topology = new EnLinkdTestHelper.ABCTopology();
        BroadcastDomain domain = new BroadcastDomain();
        domain.addBridge(new Bridge(topology.nodeAId));
        domain.addBridge(new Bridge(topology.nodeCId));
        domain.setBridgeElements(topology.elemlist);
        NodeDiscoveryBridgeTopology ndbt = new NodeDiscoveryBridgeTopology(this.linkd, new Node(topology.nodeAId.intValue(), null, null, null, location));
        ndbt.setDomain(domain);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeAId.intValue()), topology.bftA);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeCId.intValue()), topology.bftC);
        ndbt.calculate();
        topology.checkAC(ndbt.getDomain());
        domain.addBridge(new Bridge(topology.nodeBId));
        domain.setBridgeElements(topology.elemlist);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeBId.intValue()), topology.bftB);
        ndbt.calculate();
        topology.check(ndbt.getDomain());
    }

    @Test
    public void testBAThenC() {
        EnLinkdTestHelper.ABCTopology topology = new EnLinkdTestHelper.ABCTopology();
        BroadcastDomain domain = new BroadcastDomain();
        domain.addBridge(new Bridge(topology.nodeBId));
        domain.addBridge(new Bridge(topology.nodeAId));
        domain.setBridgeElements(topology.elemlist);
        NodeDiscoveryBridgeTopology ndbt = new NodeDiscoveryBridgeTopology(this.linkd, new Node(topology.nodeAId.intValue(), null, null, null, location));
        ndbt.setDomain(domain);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeBId.intValue()), topology.bftB);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeAId.intValue()), topology.bftA);
        ndbt.calculate();
        topology.checkAB(ndbt.getDomain());
        domain.addBridge(new Bridge(topology.nodeCId));
        domain.setBridgeElements(topology.elemlist);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeCId.intValue()), topology.bftC);
        ndbt.calculate();
        topology.check(ndbt.getDomain());
    }

    @Test
    public void testBThenCA() {
        EnLinkdTestHelper.ABCTopology topology = new EnLinkdTestHelper.ABCTopology();
        BroadcastDomain domain = new BroadcastDomain();
        domain.addBridge(new Bridge(topology.nodeBId));
        domain.setBridgeElements(topology.elemlist);
        NodeDiscoveryBridgeTopology ndbt = new NodeDiscoveryBridgeTopology(this.linkd, new Node(topology.nodeAId.intValue(), null, null, null, location));
        ndbt.setDomain(domain);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeBId.intValue()), topology.bftB);
        ndbt.calculate();
        domain.addBridge(new Bridge(topology.nodeCId));
        domain.addBridge(new Bridge(topology.nodeAId));
        domain.setBridgeElements(topology.elemlist);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeCId.intValue()), topology.bftC);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeAId.intValue()), topology.bftA);
        ndbt.calculate();
        domain.hierarchySetUp(domain.getBridge(topology.nodeAId.intValue()));
        topology.check(ndbt.getDomain());
    }

    @Test
    public void testCThenAB() {
        EnLinkdTestHelper.ABCTopology topology = new EnLinkdTestHelper.ABCTopology();
        BroadcastDomain domain = new BroadcastDomain();
        domain.addBridge(new Bridge(topology.nodeCId));
        domain.setBridgeElements(topology.elemlist);
        NodeDiscoveryBridgeTopology ndbt = new NodeDiscoveryBridgeTopology(this.linkd, new Node(topology.nodeAId.intValue(), null, null, null, location));
        ndbt.setDomain(domain);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeCId.intValue()), topology.bftC);
        ndbt.calculate();
        domain.addBridge(new Bridge(topology.nodeAId));
        domain.addBridge(new Bridge(topology.nodeBId));
        domain.setBridgeElements(topology.elemlist);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeAId.intValue()), topology.bftA);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeBId.intValue()), topology.bftB);
        ndbt.calculate();
        domain.hierarchySetUp(domain.getBridge(topology.nodeAId.intValue()));
        topology.check(ndbt.getDomain());
    }

    @Test
    public void testCBThenA() {
        EnLinkdTestHelper.ABCTopology topology = new EnLinkdTestHelper.ABCTopology();
        BroadcastDomain domain = new BroadcastDomain();
        domain.addBridge(new Bridge(topology.nodeCId));
        domain.addBridge(new Bridge(topology.nodeBId));
        domain.setBridgeElements(topology.elemlist);
        NodeDiscoveryBridgeTopology ndbt = new NodeDiscoveryBridgeTopology(this.linkd, new Node(topology.nodeAId.intValue(), null, null, null, location));
        ndbt.setDomain(domain);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeCId.intValue()), topology.bftC);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeBId.intValue()), topology.bftB);
        ndbt.calculate();
        topology.checkBC(ndbt.getDomain());
        domain.addBridge(new Bridge(topology.nodeAId));
        domain.setBridgeElements(topology.elemlist);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeAId.intValue()), topology.bftA);
        ndbt.calculate();
        domain.hierarchySetUp(domain.getBridge(topology.nodeAId.intValue()));
        topology.check(ndbt.getDomain());
    }

    @Test
    public void testDE() {
        EnLinkdTestHelper.DEFGHILTopology topology = new EnLinkdTestHelper.DEFGHILTopology();
        BroadcastDomain domain = new BroadcastDomain();
        domain.addBridge(new Bridge(topology.nodeDId));
        domain.addBridge(new Bridge(topology.nodeEId));
        domain.setBridgeElements(topology.elemlist);
        NodeDiscoveryBridgeTopology ndbt = new NodeDiscoveryBridgeTopology(this.linkd, new Node(topology.nodeDId.intValue(), null, null, null, location));
        ndbt.setDomain(domain);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeDId.intValue()), topology.bftD);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeEId.intValue()), topology.bftE);
        ndbt.calculate();
        topology.checkDE(ndbt.getDomain());
    }

    @Test
    public void testDF() {
        EnLinkdTestHelper.DEFGHILTopology topology = new EnLinkdTestHelper.DEFGHILTopology();
        BroadcastDomain domain = new BroadcastDomain();
        domain.addBridge(new Bridge(topology.nodeDId));
        domain.addBridge(new Bridge(topology.nodeFId));
        domain.setBridgeElements(topology.elemlist);
        NodeDiscoveryBridgeTopology ndbt = new NodeDiscoveryBridgeTopology(this.linkd, new Node(topology.nodeDId.intValue(), null, null, null, location));
        ndbt.setDomain(domain);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeDId.intValue()), topology.bftD);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeFId.intValue()), topology.bftF);
        ndbt.calculate();
        topology.checkDF(ndbt.getDomain());
    }

    @Test
    public void testEF() {
        EnLinkdTestHelper.DEFGHILTopology topology = new EnLinkdTestHelper.DEFGHILTopology();
        BroadcastDomain domain = new BroadcastDomain();
        domain.addBridge(new Bridge(topology.nodeEId));
        domain.addBridge(new Bridge(topology.nodeFId));
        domain.setBridgeElements(topology.elemlist);
        NodeDiscoveryBridgeTopology ndbt = new NodeDiscoveryBridgeTopology(this.linkd, new Node(topology.nodeDId.intValue(), null, null, null, location));
        ndbt.setDomain(domain);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeEId.intValue()), topology.bftE);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeFId.intValue()), topology.bftF);
        ndbt.calculate();
        topology.checkEF(ndbt.getDomain());
    }

    @Test
    public void testDG() {
        EnLinkdTestHelper.DEFGHILTopology topology = new EnLinkdTestHelper.DEFGHILTopology();
        BroadcastDomain domain = new BroadcastDomain();
        domain.addBridge(new Bridge(topology.nodeDId));
        domain.addBridge(new Bridge(topology.nodeGId));
        domain.setBridgeElements(topology.elemlist);
        NodeDiscoveryBridgeTopology ndbt = new NodeDiscoveryBridgeTopology(this.linkd, new Node(topology.nodeDId.intValue(), null, null, null, location));
        ndbt.setDomain(domain);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeDId.intValue()), topology.bftD);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeGId.intValue()), topology.bftG);
        ndbt.calculate();
        topology.checkDG(ndbt.getDomain());
    }

    @Test
    public void testDEF() {
        EnLinkdTestHelper.DEFGHILTopology topology = new EnLinkdTestHelper.DEFGHILTopology();
        BroadcastDomain domain = new BroadcastDomain();
        domain.addBridge(new Bridge(topology.nodeDId));
        domain.addBridge(new Bridge(topology.nodeEId));
        domain.addBridge(new Bridge(topology.nodeFId));
        domain.setBridgeElements(topology.elemlist);
        NodeDiscoveryBridgeTopology ndbt = new NodeDiscoveryBridgeTopology(this.linkd, new Node(topology.nodeDId.intValue(), null, null, null, location));
        ndbt.setDomain(domain);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeDId.intValue()), topology.bftD);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeEId.intValue()), topology.bftE);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeFId.intValue()), topology.bftF);
        ndbt.calculate();
        topology.checkDEF(ndbt.getDomain());
    }

    @Test
    public void testDFThenE() {
        EnLinkdTestHelper.DEFGHILTopology topology = new EnLinkdTestHelper.DEFGHILTopology();
        BroadcastDomain domain = new BroadcastDomain();
        domain.addBridge(new Bridge(topology.nodeDId));
        domain.addBridge(new Bridge(topology.nodeFId));
        domain.setBridgeElements(topology.elemlist);
        NodeDiscoveryBridgeTopology ndbt = new NodeDiscoveryBridgeTopology(this.linkd, new Node(topology.nodeDId.intValue(), null, null, null, location));
        ndbt.setDomain(domain);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeDId.intValue()), topology.bftD);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeFId.intValue()), topology.bftF);
        ndbt.calculate();
        topology.checkDF(ndbt.getDomain());
        domain.addBridge(new Bridge(topology.nodeEId));
        domain.setBridgeElements(topology.elemlist);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeEId.intValue()), topology.bftE);
        ndbt.calculate();
        topology.checkDEF(ndbt.getDomain());
    }

    @Test
    public void testDEFG() {
        EnLinkdTestHelper.DEFGHILTopology topology = new EnLinkdTestHelper.DEFGHILTopology();
        BroadcastDomain domain = new BroadcastDomain();
        domain.addBridge(new Bridge(topology.nodeDId));
        domain.addBridge(new Bridge(topology.nodeEId));
        domain.addBridge(new Bridge(topology.nodeFId));
        domain.addBridge(new Bridge(topology.nodeGId));
        domain.setBridgeElements(topology.elemlist);
        NodeDiscoveryBridgeTopology ndbt = new NodeDiscoveryBridgeTopology(this.linkd, new Node(topology.nodeDId.intValue(), null, null, null, location));
        ndbt.setDomain(domain);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeDId.intValue()), topology.bftD);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeEId.intValue()), topology.bftE);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeFId.intValue()), topology.bftF);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeGId.intValue()), topology.bftG);
        ndbt.calculate();
        topology.checkDEFG(ndbt.getDomain());
    }

    @Test
    public void testDEFGHIL() {
        EnLinkdTestHelper.DEFGHILTopology topology = new EnLinkdTestHelper.DEFGHILTopology();
        BroadcastDomain domain = new BroadcastDomain();
        domain.addBridge(new Bridge(topology.nodeDId));
        domain.addBridge(new Bridge(topology.nodeEId));
        domain.addBridge(new Bridge(topology.nodeFId));
        domain.addBridge(new Bridge(topology.nodeGId));
        domain.addBridge(new Bridge(topology.nodeHId));
        domain.addBridge(new Bridge(topology.nodeIId));
        domain.addBridge(new Bridge(topology.nodeLId));
        domain.setBridgeElements(topology.elemlist);
        NodeDiscoveryBridgeTopology ndbt = new NodeDiscoveryBridgeTopology(this.linkd, new Node(topology.nodeDId.intValue(), null, null, null, location));
        ndbt.setDomain(domain);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeDId.intValue()), topology.bftD);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeEId.intValue()), topology.bftE);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeFId.intValue()), topology.bftF);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeGId.intValue()), topology.bftG);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeHId.intValue()), topology.bftH);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeIId.intValue()), topology.bftI);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeLId.intValue()), topology.bftL);
        ndbt.calculate();
        topology.check(ndbt.getDomain().getTopology());
    }

    @Test
    public void testHierarchySetUp() {
        EnLinkdTestHelper.DEFGHILTopology topology = new EnLinkdTestHelper.DEFGHILTopology();
        BroadcastDomain domain = new BroadcastDomain();
        domain.addBridge(new Bridge(topology.nodeDId));
        domain.addBridge(new Bridge(topology.nodeEId));
        domain.addBridge(new Bridge(topology.nodeFId));
        domain.addBridge(new Bridge(topology.nodeGId));
        domain.addBridge(new Bridge(topology.nodeHId));
        domain.addBridge(new Bridge(topology.nodeIId));
        domain.addBridge(new Bridge(topology.nodeLId));
        domain.setBridgeElements(topology.elemlist);
        NodeDiscoveryBridgeTopology ndbt = new NodeDiscoveryBridgeTopology(this.linkd, new Node(topology.nodeDId.intValue(), null, null, null, location));
        ndbt.setDomain(domain);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeDId.intValue()), topology.bftD);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeEId.intValue()), topology.bftE);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeFId.intValue()), topology.bftF);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeGId.intValue()), topology.bftG);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeHId.intValue()), topology.bftH);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeIId.intValue()), topology.bftI);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeLId.intValue()), topology.bftL);
        ndbt.calculate();
        topology.check(ndbt.getDomain().getTopology());
        domain.hierarchySetUp(domain.getBridge(topology.nodeGId.intValue()));
        Assert.assertEquals((Object)topology.nodeGId, (Object)ndbt.getDomain().getRootBridgeId());
        Assert.assertEquals((Object)true, (Object)ndbt.getDomain().getBridge(topology.nodeGId.intValue()).isRootBridge());
        Assert.assertEquals(null, (Object)ndbt.getDomain().getBridge(topology.nodeGId.intValue()).getRootPort());
        Assert.assertEquals((Object)false, (Object)ndbt.getDomain().getBridge(topology.nodeDId.intValue()).isRootBridge());
        Assert.assertEquals((Object)topology.portDD, (Object)ndbt.getDomain().getBridge(topology.nodeDId.intValue()).getRootPort());
        Assert.assertEquals((Object)false, (Object)ndbt.getDomain().getBridge(topology.nodeEId.intValue()).isRootBridge());
        Assert.assertEquals((Object)topology.portEE, (Object)ndbt.getDomain().getBridge(topology.nodeEId.intValue()).getRootPort());
        Assert.assertEquals((Object)false, (Object)ndbt.getDomain().getBridge(topology.nodeFId.intValue()).isRootBridge());
        Assert.assertEquals((Object)topology.portFF, (Object)ndbt.getDomain().getBridge(topology.nodeFId.intValue()).getRootPort());
        Assert.assertEquals((Object)false, (Object)ndbt.getDomain().getBridge(topology.nodeHId.intValue()).isRootBridge());
        Assert.assertEquals((Object)topology.portHH, (Object)ndbt.getDomain().getBridge(topology.nodeHId.intValue()).getRootPort());
        Assert.assertEquals((Object)false, (Object)ndbt.getDomain().getBridge(topology.nodeIId.intValue()).isRootBridge());
        Assert.assertEquals((Object)topology.portII, (Object)ndbt.getDomain().getBridge(topology.nodeIId.intValue()).getRootPort());
        Assert.assertEquals((Object)false, (Object)ndbt.getDomain().getBridge(topology.nodeLId.intValue()).isRootBridge());
        Assert.assertEquals((Object)topology.portLL, (Object)ndbt.getDomain().getBridge(topology.nodeLId.intValue()).getRootPort());
    }

    @Test
    public void testFiveSwitchTopologyBCADE() {
        EnLinkdTestHelper.FiveSwitchTopology topology = new EnLinkdTestHelper.FiveSwitchTopology();
        BroadcastDomain domain = new BroadcastDomain();
        domain.addBridge(new Bridge(Integer.valueOf(topology.nodeAId)));
        domain.addBridge(new Bridge(Integer.valueOf(topology.nodeBId)));
        domain.addBridge(new Bridge(Integer.valueOf(topology.nodeCId)));
        domain.addBridge(new Bridge(Integer.valueOf(topology.nodeDId)));
        domain.addBridge(new Bridge(Integer.valueOf(topology.nodeEId)));
        domain.setBridgeElements(topology.elemlist);
        NodeDiscoveryBridgeTopology ndbtB = new NodeDiscoveryBridgeTopology(this.linkd, new Node(topology.nodeBId, null, null, null, location));
        ndbtB.setDomain(domain);
        ndbtB.addUpdatedBFT(domain.getBridge(topology.nodeBId), topology.bftB);
        ndbtB.calculate();
        NodeDiscoveryBridgeTopology ndbtC = new NodeDiscoveryBridgeTopology(this.linkd, new Node(topology.nodeCId, null, null, null, location));
        ndbtC.setDomain(domain);
        ndbtC.addUpdatedBFT(domain.getBridge(topology.nodeCId), topology.bftC);
        ndbtC.calculate();
        NodeDiscoveryBridgeTopology ndbtA = new NodeDiscoveryBridgeTopology(this.linkd, new Node(topology.nodeAId, null, null, null, location));
        ndbtA.setDomain(domain);
        ndbtA.addUpdatedBFT(domain.getBridge(topology.nodeAId), topology.bftA);
        ndbtA.calculate();
        NodeDiscoveryBridgeTopology ndbtD = new NodeDiscoveryBridgeTopology(this.linkd, new Node(topology.nodeDId, null, null, null, location));
        ndbtD.setDomain(domain);
        ndbtD.addUpdatedBFT(domain.getBridge(topology.nodeDId), topology.bftD);
        ndbtD.calculate();
        NodeDiscoveryBridgeTopology ndbtE = new NodeDiscoveryBridgeTopology(this.linkd, new Node(topology.nodeEId, null, null, null, location));
        ndbtE.setDomain(domain);
        ndbtE.addUpdatedBFT(domain.getBridge(topology.nodeEId), topology.bftE);
        ndbtE.calculate();
        topology.check(domain);
    }

    @Test
    public void testFiveSwitchTopologyBCAED() {
        EnLinkdTestHelper.FiveSwitchTopology topology = new EnLinkdTestHelper.FiveSwitchTopology();
        BroadcastDomain domain = new BroadcastDomain();
        domain.addBridge(new Bridge(Integer.valueOf(topology.nodeAId)));
        domain.addBridge(new Bridge(Integer.valueOf(topology.nodeBId)));
        domain.addBridge(new Bridge(Integer.valueOf(topology.nodeCId)));
        domain.addBridge(new Bridge(Integer.valueOf(topology.nodeDId)));
        domain.addBridge(new Bridge(Integer.valueOf(topology.nodeEId)));
        domain.setBridgeElements(topology.elemlist);
        NodeDiscoveryBridgeTopology ndbtB = new NodeDiscoveryBridgeTopology(this.linkd, new Node(topology.nodeBId, null, null, null, location));
        ndbtB.setDomain(domain);
        ndbtB.addUpdatedBFT(domain.getBridge(topology.nodeBId), topology.bftB);
        ndbtB.calculate();
        NodeDiscoveryBridgeTopology ndbtC = new NodeDiscoveryBridgeTopology(this.linkd, new Node(topology.nodeCId, null, null, null, location));
        ndbtC.setDomain(domain);
        ndbtC.addUpdatedBFT(domain.getBridge(topology.nodeCId), topology.bftC);
        ndbtC.calculate();
        NodeDiscoveryBridgeTopology ndbtA = new NodeDiscoveryBridgeTopology(this.linkd, new Node(topology.nodeAId, null, null, null, location));
        ndbtA.setDomain(domain);
        ndbtA.addUpdatedBFT(domain.getBridge(topology.nodeAId), topology.bftA);
        ndbtA.calculate();
        NodeDiscoveryBridgeTopology ndbtE = new NodeDiscoveryBridgeTopology(this.linkd, new Node(topology.nodeEId, null, null, null, location));
        ndbtE.setDomain(domain);
        ndbtE.addUpdatedBFT(domain.getBridge(topology.nodeEId), topology.bftE);
        ndbtE.calculate();
        NodeDiscoveryBridgeTopology ndbtD = new NodeDiscoveryBridgeTopology(this.linkd, new Node(topology.nodeDId, null, null, null, location));
        ndbtD.setDomain(domain);
        ndbtD.addUpdatedBFT(domain.getBridge(topology.nodeDId), topology.bftD);
        ndbtD.calculate();
        topology.check(domain);
    }

    @Test
    public void testFiveSwitchTopologyEDCBA() {
        EnLinkdTestHelper.FiveSwitchTopology topology = new EnLinkdTestHelper.FiveSwitchTopology();
        BroadcastDomain domain = new BroadcastDomain();
        domain.addBridge(new Bridge(Integer.valueOf(topology.nodeAId)));
        domain.addBridge(new Bridge(Integer.valueOf(topology.nodeBId)));
        domain.addBridge(new Bridge(Integer.valueOf(topology.nodeCId)));
        domain.addBridge(new Bridge(Integer.valueOf(topology.nodeDId)));
        domain.addBridge(new Bridge(Integer.valueOf(topology.nodeEId)));
        domain.setBridgeElements(topology.elemlist);
        NodeDiscoveryBridgeTopology ndbtE = new NodeDiscoveryBridgeTopology(this.linkd, new Node(topology.nodeEId, null, null, null, location));
        ndbtE.setDomain(domain);
        ndbtE.addUpdatedBFT(domain.getBridge(topology.nodeEId), topology.bftE);
        ndbtE.calculate();
        NodeDiscoveryBridgeTopology ndbtD = new NodeDiscoveryBridgeTopology(this.linkd, new Node(topology.nodeDId, null, null, null, location));
        ndbtD.setDomain(domain);
        ndbtD.addUpdatedBFT(domain.getBridge(topology.nodeDId), topology.bftD);
        ndbtD.calculate();
        NodeDiscoveryBridgeTopology ndbtC = new NodeDiscoveryBridgeTopology(this.linkd, new Node(topology.nodeCId, null, null, null, location));
        ndbtC.setDomain(domain);
        ndbtC.addUpdatedBFT(domain.getBridge(topology.nodeCId), topology.bftC);
        ndbtC.calculate();
        NodeDiscoveryBridgeTopology ndbtB = new NodeDiscoveryBridgeTopology(this.linkd, new Node(topology.nodeBId, null, null, null, location));
        ndbtB.setDomain(domain);
        ndbtB.addUpdatedBFT(domain.getBridge(topology.nodeBId), topology.bftB);
        ndbtB.calculate();
        NodeDiscoveryBridgeTopology ndbtA = new NodeDiscoveryBridgeTopology(this.linkd, new Node(topology.nodeAId, null, null, null, location));
        ndbtA.setDomain(domain);
        ndbtA.addUpdatedBFT(domain.getBridge(topology.nodeAId), topology.bftA);
        ndbtA.calculate();
        Bridge bridgeB = domain.getBridge(topology.nodeBId);
        domain.hierarchySetUp(bridgeB);
        topology.check(domain);
    }

    @Test
    public void testFiveSwitchTopologyBEDCA() {
        EnLinkdTestHelper.FiveSwitchTopology topology = new EnLinkdTestHelper.FiveSwitchTopology();
        BroadcastDomain domain = new BroadcastDomain();
        domain.addBridge(new Bridge(Integer.valueOf(topology.nodeAId)));
        domain.addBridge(new Bridge(Integer.valueOf(topology.nodeBId)));
        domain.addBridge(new Bridge(Integer.valueOf(topology.nodeCId)));
        domain.addBridge(new Bridge(Integer.valueOf(topology.nodeDId)));
        domain.addBridge(new Bridge(Integer.valueOf(topology.nodeEId)));
        domain.setBridgeElements(topology.elemlist);
        NodeDiscoveryBridgeTopology ndbtB = new NodeDiscoveryBridgeTopology(this.linkd, new Node(topology.nodeBId, null, null, null, location));
        ndbtB.setDomain(domain);
        ndbtB.addUpdatedBFT(domain.getBridge(topology.nodeBId), topology.bftB);
        ndbtB.calculate();
        NodeDiscoveryBridgeTopology ndbtE = new NodeDiscoveryBridgeTopology(this.linkd, new Node(topology.nodeEId, null, null, null, location));
        ndbtE.setDomain(domain);
        ndbtE.addUpdatedBFT(domain.getBridge(topology.nodeEId), topology.bftE);
        ndbtE.calculate();
        NodeDiscoveryBridgeTopology ndbtD = new NodeDiscoveryBridgeTopology(this.linkd, new Node(topology.nodeDId, null, null, null, location));
        ndbtD.setDomain(domain);
        ndbtD.addUpdatedBFT(domain.getBridge(topology.nodeDId), topology.bftD);
        ndbtD.calculate();
        NodeDiscoveryBridgeTopology ndbtC = new NodeDiscoveryBridgeTopology(this.linkd, new Node(topology.nodeCId, null, null, null, location));
        ndbtC.setDomain(domain);
        ndbtC.addUpdatedBFT(domain.getBridge(topology.nodeCId), topology.bftC);
        ndbtC.calculate();
        NodeDiscoveryBridgeTopology ndbtA = new NodeDiscoveryBridgeTopology(this.linkd, new Node(topology.nodeAId, null, null, null, location));
        ndbtA.setDomain(domain);
        ndbtA.addUpdatedBFT(domain.getBridge(topology.nodeAId), topology.bftA);
        ndbtA.calculate();
        topology.check(domain);
    }

    @Test
    public void testFiveSwitchTopologyEDCAB() {
        EnLinkdTestHelper.FiveSwitchTopology topology = new EnLinkdTestHelper.FiveSwitchTopology();
        BroadcastDomain domain = new BroadcastDomain();
        domain.addBridge(new Bridge(Integer.valueOf(topology.nodeAId)));
        domain.addBridge(new Bridge(Integer.valueOf(topology.nodeBId)));
        domain.addBridge(new Bridge(Integer.valueOf(topology.nodeCId)));
        domain.addBridge(new Bridge(Integer.valueOf(topology.nodeDId)));
        domain.addBridge(new Bridge(Integer.valueOf(topology.nodeEId)));
        domain.setBridgeElements(topology.elemlist);
        NodeDiscoveryBridgeTopology ndbtE = new NodeDiscoveryBridgeTopology(this.linkd, new Node(topology.nodeEId, null, null, null, location));
        ndbtE.setDomain(domain);
        ndbtE.addUpdatedBFT(domain.getBridge(topology.nodeEId), topology.bftE);
        ndbtE.calculate();
        NodeDiscoveryBridgeTopology ndbtD = new NodeDiscoveryBridgeTopology(this.linkd, new Node(topology.nodeDId, null, null, null, location));
        ndbtD.setDomain(domain);
        ndbtD.addUpdatedBFT(domain.getBridge(topology.nodeDId), topology.bftD);
        ndbtD.calculate();
        NodeDiscoveryBridgeTopology ndbtC = new NodeDiscoveryBridgeTopology(this.linkd, new Node(topology.nodeCId, null, null, null, location));
        ndbtC.setDomain(domain);
        ndbtC.addUpdatedBFT(domain.getBridge(topology.nodeCId), topology.bftC);
        ndbtC.calculate();
        NodeDiscoveryBridgeTopology ndbtA = new NodeDiscoveryBridgeTopology(this.linkd, new Node(topology.nodeAId, null, null, null, location));
        ndbtA.setDomain(domain);
        ndbtA.addUpdatedBFT(domain.getBridge(topology.nodeAId), topology.bftA);
        ndbtA.calculate();
        NodeDiscoveryBridgeTopology ndbtB = new NodeDiscoveryBridgeTopology(this.linkd, new Node(topology.nodeBId, null, null, null, location));
        ndbtB.setDomain(domain);
        ndbtB.addUpdatedBFT(domain.getBridge(topology.nodeBId), topology.bftB);
        ndbtB.calculate();
        Bridge bridgeB = domain.getBridge(topology.nodeBId);
        domain.hierarchySetUp(bridgeB);
        topology.check(domain);
    }

    @Test
    public void testFiveSwitchTopologyBCADEBD() {
        EnLinkdTestHelper.FiveSwitchTopology topology = new EnLinkdTestHelper.FiveSwitchTopology();
        BroadcastDomain domain = new BroadcastDomain();
        domain.addBridge(new Bridge(Integer.valueOf(topology.nodeAId)));
        domain.addBridge(new Bridge(Integer.valueOf(topology.nodeBId)));
        domain.addBridge(new Bridge(Integer.valueOf(topology.nodeCId)));
        domain.addBridge(new Bridge(Integer.valueOf(topology.nodeDId)));
        domain.addBridge(new Bridge(Integer.valueOf(topology.nodeEId)));
        domain.setBridgeElements(topology.elemlist);
        NodeDiscoveryBridgeTopology ndbtB = new NodeDiscoveryBridgeTopology(this.linkd, new Node(topology.nodeBId, null, null, null, location));
        ndbtB.setDomain(domain);
        ndbtB.addUpdatedBFT(domain.getBridge(topology.nodeBId), topology.bftB);
        ndbtB.calculate();
        NodeDiscoveryBridgeTopology ndbtC = new NodeDiscoveryBridgeTopology(this.linkd, new Node(topology.nodeCId, null, null, null, location));
        ndbtC.setDomain(domain);
        ndbtC.addUpdatedBFT(domain.getBridge(topology.nodeCId), topology.bftC);
        ndbtC.calculate();
        NodeDiscoveryBridgeTopology ndbtA = new NodeDiscoveryBridgeTopology(this.linkd, new Node(topology.nodeAId, null, null, null, location));
        ndbtA.setDomain(domain);
        ndbtA.addUpdatedBFT(domain.getBridge(topology.nodeAId), topology.bftA);
        ndbtA.calculate();
        NodeDiscoveryBridgeTopology ndbtD = new NodeDiscoveryBridgeTopology(this.linkd, new Node(topology.nodeDId, null, null, null, location));
        ndbtD.setDomain(domain);
        ndbtD.addUpdatedBFT(domain.getBridge(topology.nodeDId), topology.bftD);
        ndbtD.calculate();
        NodeDiscoveryBridgeTopology ndbtE = new NodeDiscoveryBridgeTopology(this.linkd, new Node(topology.nodeEId, null, null, null, location));
        ndbtE.setDomain(domain);
        ndbtE.addUpdatedBFT(domain.getBridge(topology.nodeEId), topology.bftE);
        ndbtE.calculate();
        topology.check(domain);
        ndbtB.addUpdatedBFT(domain.getBridge(topology.nodeBId), topology.bftB);
        ndbtB.calculate();
        topology.check(domain);
        ndbtD.addUpdatedBFT(domain.getBridge(topology.nodeDId), topology.bftD);
        ndbtD.calculate();
        topology.check(domain);
    }

    @Test
    public void testFiveSwitchTopologyBEDCADBAEC() {
        EnLinkdTestHelper.FiveSwitchTopology topology = new EnLinkdTestHelper.FiveSwitchTopology();
        BroadcastDomain domain = new BroadcastDomain();
        domain.addBridge(new Bridge(Integer.valueOf(topology.nodeAId)));
        domain.addBridge(new Bridge(Integer.valueOf(topology.nodeBId)));
        domain.addBridge(new Bridge(Integer.valueOf(topology.nodeCId)));
        domain.addBridge(new Bridge(Integer.valueOf(topology.nodeDId)));
        domain.addBridge(new Bridge(Integer.valueOf(topology.nodeEId)));
        domain.setBridgeElements(topology.elemlist);
        NodeDiscoveryBridgeTopology ndbtB = new NodeDiscoveryBridgeTopology(this.linkd, new Node(topology.nodeBId, null, null, null, location));
        ndbtB.setDomain(domain);
        ndbtB.addUpdatedBFT(domain.getBridge(topology.nodeBId), topology.bftB);
        ndbtB.calculate();
        NodeDiscoveryBridgeTopology ndbtE = new NodeDiscoveryBridgeTopology(this.linkd, new Node(topology.nodeEId, null, null, null, location));
        ndbtE.setDomain(domain);
        ndbtE.addUpdatedBFT(domain.getBridge(topology.nodeEId), topology.bftE);
        ndbtE.calculate();
        NodeDiscoveryBridgeTopology ndbtD = new NodeDiscoveryBridgeTopology(this.linkd, new Node(topology.nodeDId, null, null, null, location));
        ndbtD.setDomain(domain);
        ndbtD.addUpdatedBFT(domain.getBridge(topology.nodeDId), topology.bftD);
        ndbtD.calculate();
        NodeDiscoveryBridgeTopology ndbtC = new NodeDiscoveryBridgeTopology(this.linkd, new Node(topology.nodeCId, null, null, null, location));
        ndbtC.setDomain(domain);
        ndbtC.addUpdatedBFT(domain.getBridge(topology.nodeCId), topology.bftC);
        ndbtC.calculate();
        NodeDiscoveryBridgeTopology ndbtA = new NodeDiscoveryBridgeTopology(this.linkd, new Node(topology.nodeAId, null, null, null, location));
        ndbtA.setDomain(domain);
        ndbtA.addUpdatedBFT(domain.getBridge(topology.nodeAId), topology.bftA);
        ndbtA.calculate();
        topology.check(domain);
        ndbtD.addUpdatedBFT(domain.getBridge(topology.nodeDId), topology.bftD);
        ndbtD.calculate();
        topology.check(domain);
        ndbtB.addUpdatedBFT(domain.getBridge(topology.nodeBId), topology.bftB);
        ndbtB.calculate();
        topology.check(domain);
        ndbtA.addUpdatedBFT(domain.getBridge(topology.nodeAId), topology.bftA);
        ndbtA.calculate();
        topology.check(domain);
        ndbtE.addUpdatedBFT(domain.getBridge(topology.nodeEId), topology.bftE);
        ndbtE.calculate();
        topology.check(domain);
        ndbtC.addUpdatedBFT(domain.getBridge(topology.nodeCId), topology.bftC);
        ndbtC.calculate();
        topology.check(domain);
    }

    @Test
    public void testFiveSwitchTopologyBEDCABEDAC() {
        EnLinkdTestHelper.FiveSwitchTopology topology = new EnLinkdTestHelper.FiveSwitchTopology();
        BroadcastDomain domain = new BroadcastDomain();
        domain.addBridge(new Bridge(Integer.valueOf(topology.nodeAId)));
        domain.addBridge(new Bridge(Integer.valueOf(topology.nodeBId)));
        domain.addBridge(new Bridge(Integer.valueOf(topology.nodeCId)));
        domain.addBridge(new Bridge(Integer.valueOf(topology.nodeDId)));
        domain.addBridge(new Bridge(Integer.valueOf(topology.nodeEId)));
        domain.setBridgeElements(topology.elemlist);
        NodeDiscoveryBridgeTopology ndbtB = new NodeDiscoveryBridgeTopology(this.linkd, new Node(topology.nodeBId, null, null, null, location));
        ndbtB.setDomain(domain);
        ndbtB.addUpdatedBFT(domain.getBridge(topology.nodeBId), topology.bftB);
        ndbtB.calculate();
        NodeDiscoveryBridgeTopology ndbtE = new NodeDiscoveryBridgeTopology(this.linkd, new Node(topology.nodeEId, null, null, null, location));
        ndbtE.setDomain(domain);
        ndbtE.addUpdatedBFT(domain.getBridge(topology.nodeEId), topology.bftE);
        ndbtE.calculate();
        NodeDiscoveryBridgeTopology ndbtD = new NodeDiscoveryBridgeTopology(this.linkd, new Node(topology.nodeDId, null, null, null, location));
        ndbtD.setDomain(domain);
        ndbtD.addUpdatedBFT(domain.getBridge(topology.nodeDId), topology.bftD);
        ndbtD.calculate();
        NodeDiscoveryBridgeTopology ndbtC = new NodeDiscoveryBridgeTopology(this.linkd, new Node(topology.nodeCId, null, null, null, location));
        ndbtC.setDomain(domain);
        ndbtC.addUpdatedBFT(domain.getBridge(topology.nodeCId), topology.bftC);
        ndbtC.calculate();
        NodeDiscoveryBridgeTopology ndbtA = new NodeDiscoveryBridgeTopology(this.linkd, new Node(topology.nodeAId, null, null, null, location));
        ndbtA.setDomain(domain);
        ndbtA.addUpdatedBFT(domain.getBridge(topology.nodeAId), topology.bftA);
        ndbtA.calculate();
        topology.check(domain);
        ndbtB.addUpdatedBFT(domain.getBridge(topology.nodeBId), topology.bftB);
        ndbtB.calculate();
        topology.check(domain);
        ndbtE.addUpdatedBFT(domain.getBridge(topology.nodeEId), topology.bftE);
        ndbtE.calculate();
        topology.check(domain);
        ndbtD.addUpdatedBFT(domain.getBridge(topology.nodeDId), topology.bftD);
        ndbtD.calculate();
        topology.check(domain);
        ndbtA.addUpdatedBFT(domain.getBridge(topology.nodeAId), topology.bftA);
        ndbtA.calculate();
        topology.check(domain);
        ndbtC.addUpdatedBFT(domain.getBridge(topology.nodeCId), topology.bftC);
        ndbtC.calculate();
        topology.check(domain);
    }
}

