/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmpinterfacepoller;

import java.util.Date;
import java.util.List;
import org.opennms.core.criteria.Alias;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.api.SnmpInterfaceDao;
import org.opennms.netmgt.events.api.EventIpcManager;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.model.PrimaryType;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.snmpinterfacepoller.pollable.PollContext;
import org.opennms.netmgt.xml.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultPollContext
implements PollContext {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultPollContext.class);
    private volatile EventIpcManager m_eventManager;
    private volatile String m_name;
    private volatile String m_localHostName;
    @Autowired
    private SnmpInterfaceDao m_snmpInterfaceDao;
    @Autowired
    private IpInterfaceDao m_ipInterfaceDao;
    private String m_serviceName = "SNMP";

    public IpInterfaceDao getIpInterfaceDao() {
        return this.m_ipInterfaceDao;
    }

    public SnmpInterfaceDao getSnmpInterfaceDao() {
        return this.m_snmpInterfaceDao;
    }

    public EventIpcManager getEventManager() {
        return this.m_eventManager;
    }

    public void setEventManager(EventIpcManager eventManager) {
        this.m_eventManager = eventManager;
    }

    public void setLocalHostName(String localHostName) {
        this.m_localHostName = localHostName;
    }

    public String getLocalHostName() {
        return this.m_localHostName;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    @Override
    public String getServiceName() {
        return this.m_serviceName;
    }

    @Override
    public void setServiceName(String serviceName) {
        this.m_serviceName = serviceName;
    }

    @Override
    public void sendEvent(Event event) {
        this.getEventManager().sendNow(event);
    }

    private Logger log() {
        return LOG;
    }

    @Override
    public Event createEvent(String uei, int nodeId, String addr, String netMask, Date date, OnmsSnmpInterface snmpinterface) {
        this.log().debug("createEvent: uei = " + uei + " nodeid = " + nodeId + " date = " + date);
        EventBuilder bldr = new EventBuilder(uei, this.getName(), date);
        bldr.setNodeid((long)nodeId);
        if (addr != null) {
            bldr.setInterface(InetAddressUtils.addr((String)addr));
        }
        if (netMask != null) {
            bldr.addParam("mask", InetAddressUtils.normalize((String)netMask));
        }
        bldr.setService(this.getServiceName());
        bldr.setHost(this.getLocalHostName());
        bldr.setField("ifIndex", snmpinterface.getIfIndex().toString());
        bldr.addParam("snmpifindex", snmpinterface.getIfIndex().toString());
        if (snmpinterface.getIfName() != null) {
            bldr.addParam("snmpifname", snmpinterface.getIfName());
        }
        if (snmpinterface.getIfDescr() != null) {
            bldr.addParam("snmpifdescr", snmpinterface.getIfDescr());
        }
        if (snmpinterface.getIfAlias() != null) {
            bldr.addParam("snmpifalias", snmpinterface.getIfAlias());
        }
        return bldr.getEvent();
    }

    @Override
    public List<OnmsSnmpInterface> get(int nodeId, String criteria) {
        CriteriaBuilder builder = new CriteriaBuilder(OnmsSnmpInterface.class);
        builder.sql(criteria).eq("node.id", (Object)nodeId).eq("poll", (Object)"P");
        builder.alias("ipInterfaces", "ipInterface", Alias.JoinType.LEFT_JOIN);
        return this.getSnmpInterfaceDao().findMatching(builder.toCriteria());
    }

    @Override
    public void update(OnmsSnmpInterface snmpinterface) {
        OnmsSnmpInterface dbSnmpInterface = this.getSnmpInterfaceDao().findByNodeIdAndIfIndex(snmpinterface.getNode().getId(), snmpinterface.getIfIndex());
        if (dbSnmpInterface == null) {
            this.log().debug("updating SnmpInterface: no interface found on db for: " + snmpinterface.toString());
        } else {
            dbSnmpInterface.setIfOperStatus(snmpinterface.getIfOperStatus());
            dbSnmpInterface.setIfAdminStatus(snmpinterface.getIfAdminStatus());
            dbSnmpInterface.setLastSnmpPoll(snmpinterface.getLastSnmpPoll());
            this.log().debug("updating SnmpInterface: " + dbSnmpInterface.toString());
            this.getSnmpInterfaceDao().update((Object)dbSnmpInterface);
        }
    }

    @Override
    public List<OnmsIpInterface> getPollableNodesByIp(String ipaddr) {
        CriteriaBuilder builder = new CriteriaBuilder(OnmsIpInterface.class);
        builder.eq("ipAddress", (Object)InetAddressUtils.addr((String)ipaddr)).eq("isSnmpPrimary", (Object)PrimaryType.PRIMARY).eq("isManaged", (Object)"M");
        return this.getIpInterfaceDao().findMatching(builder.toCriteria());
    }

    @Override
    public List<OnmsIpInterface> getPollableNodes() {
        CriteriaBuilder builder = new CriteriaBuilder(OnmsIpInterface.class);
        builder.eq("isSnmpPrimary", (Object)PrimaryType.PRIMARY).eq("isManaged", (Object)"M");
        return this.getIpInterfaceDao().findMatching(builder.toCriteria());
    }
}

