/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.enlinkd.EnhancedLinkd;
import org.opennms.netmgt.enlinkd.Node;
import org.opennms.netmgt.enlinkd.NodeDiscovery;
import org.opennms.netmgt.enlinkd.snmp.CiscoVtpTracker;
import org.opennms.netmgt.enlinkd.snmp.CiscoVtpVlanTableTracker;
import org.opennms.netmgt.enlinkd.snmp.Dot1dBasePortTableTracker;
import org.opennms.netmgt.enlinkd.snmp.Dot1dBaseTracker;
import org.opennms.netmgt.enlinkd.snmp.Dot1dStpPortTableTracker;
import org.opennms.netmgt.enlinkd.snmp.Dot1dTpFdbTableTracker;
import org.opennms.netmgt.enlinkd.snmp.Dot1qTpFdbTableTracker;
import org.opennms.netmgt.model.BridgeElement;
import org.opennms.netmgt.model.BridgeMacLink;
import org.opennms.netmgt.model.BridgeStpLink;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NodeDiscoveryBridge
extends NodeDiscovery {
    private static final Logger LOG = LoggerFactory.getLogger(NodeDiscoveryBridge.class);

    public NodeDiscoveryBridge(EnhancedLinkd linkd, Node node) {
        super(linkd, node);
    }

    @Override
    protected void runCollection() {
        Date now = new Date();
        SnmpAgentConfig peer = this.m_linkd.getSnmpAgentConfig(this.getPrimaryIpAddress(), this.getLocation());
        String community = peer.getReadCommunity();
        Map<Integer, String> vlanmap = this.getVtpVlanMap(peer);
        HashMap<Integer, SnmpAgentConfig> vlanSnmpAgentConfigMap = new HashMap<Integer, SnmpAgentConfig>();
        for (Integer vlanId : vlanmap.keySet()) {
            LOG.debug("run: node [{}], support cisco vtp: setting peer community for vlan: {}, vlanname: {}", new Object[]{this.getNodeId(), vlanId, vlanmap.get(vlanId)});
            SnmpAgentConfig vlanpeer = this.m_linkd.getSnmpAgentConfig(this.getPrimaryIpAddress(), this.getLocation());
            if (vlanpeer.isVersion3()) {
                vlanpeer.setContextName("vlan-" + vlanId);
            } else {
                vlanpeer.setReadCommunity(community + "@" + vlanId);
            }
            vlanSnmpAgentConfigMap.put(vlanId, vlanpeer);
        }
        if (vlanmap.isEmpty()) {
            vlanSnmpAgentConfigMap.put(null, peer);
            vlanmap.put(null, null);
        }
        List<BridgeMacLink> bft = new ArrayList<BridgeMacLink>();
        HashMap<Integer, Integer> bridgeifindex = new HashMap<Integer, Integer>();
        for (Map.Entry entry : vlanSnmpAgentConfigMap.entrySet()) {
            Map<Integer, Integer> vlanbridgetoifindex = this.walkDot1dBasePortTable((SnmpAgentConfig)entry.getValue());
            LOG.debug("run: node: [{}], vlan: {}, bridge ifindex map {}", new Object[]{this.getNodeId(), vlanmap.get(entry.getKey()), vlanbridgetoifindex});
            bridgeifindex.putAll(vlanbridgetoifindex);
        }
        for (Map.Entry<Object, Object> entry : vlanmap.entrySet()) {
            BridgeElement bridge = this.getDot1dBridgeBase((SnmpAgentConfig)vlanSnmpAgentConfigMap.get(entry.getKey()));
            if (bridge == null) {
                LOG.info("run: node: [{}], vlan {}. no dot1d bridge data found. skipping other operations", (Object)this.getNodeId(), entry.getValue());
                continue;
            }
            bridge.setVlan((Integer)entry.getKey());
            bridge.setVlanname(vlanmap.get(entry.getKey()));
            this.m_linkd.getQueryManager().store(this.getNodeId(), bridge);
            if (!InetAddressUtils.isValidStpBridgeId((String)bridge.getStpDesignatedRoot())) {
                LOG.info("run: node: [{}], vlan {}. invalid designated root: spanning tree not supported.", (Object)this.getNodeId(), entry.getValue());
            } else if (bridge.getBaseBridgeAddress().equals(InetAddressUtils.getBridgeAddressFromStpBridgeId((String)bridge.getStpDesignatedRoot()))) {
                LOG.info("run: node [{}]: vlan {}. designated root {} is itself. Skipping store.", new Object[]{this.getNodeId(), entry.getValue(), bridge.getStpDesignatedRoot()});
            } else {
                for (BridgeStpLink stplink : this.walkSpanningTree((SnmpAgentConfig)vlanSnmpAgentConfigMap.get(entry.getKey()), bridge.getBaseBridgeAddress())) {
                    stplink.setVlan((Integer)entry.getKey());
                    stplink.setStpPortIfIndex((Integer)bridgeifindex.get(stplink.getStpPort()));
                    this.m_linkd.getQueryManager().store(this.getNodeId(), stplink);
                }
            }
            bft = this.walkDot1dTpFdp((String)entry.getValue(), (Integer)entry.getKey(), bridgeifindex, bft, (SnmpAgentConfig)vlanSnmpAgentConfigMap.get(entry.getKey()));
        }
        LOG.debug("run: node [{}]: bridge ifindex map {}", (Object)this.getNodeId(), bridgeifindex);
        bft = this.walkDot1qTpFdb(peer, bridgeifindex, bft);
        LOG.debug("run: node [{}]: bft size:{}", (Object)this.getNodeId(), (Object)bft.size());
        if (bft.size() > 0) {
            LOG.debug("run: node [{}]: updating topology", (Object)this.getNodeId());
            this.m_linkd.getQueryManager().updateBft(this.getNodeId(), bft);
            this.m_linkd.scheduleBridgeTopologyDiscovery(this.getNodeId());
        }
        LOG.debug("run: node [{}]: deleting older the time {}", (Object)this.getNodeId(), (Object)now);
        this.m_linkd.collectedBft(this.getNodeId());
        this.m_linkd.getQueryManager().reconcileBridge(this.getNodeId(), now);
    }

    private BridgeElement getDot1dBridgeBase(SnmpAgentConfig peer) {
        Dot1dBaseTracker dot1dbase = new Dot1dBaseTracker();
        try {
            this.m_linkd.getLocationAwareSnmpClient().walk(peer, (CollectionTracker)dot1dbase).withDescription("dot1dbase").withLocation(this.getLocation()).execute().get();
        }
        catch (ExecutionException e) {
            LOG.info("run: node [{}]: ExecutionException: dot1dbase: {}", (Object)this.getNodeId(), (Object)e.getMessage());
            return null;
        }
        catch (InterruptedException e) {
            LOG.info("run: node [{}]: InterruptedException: dot1dbase: {}", (Object)this.getNodeId(), (Object)e.getMessage());
            return null;
        }
        BridgeElement bridge = dot1dbase.getBridgeElement();
        if (bridge.getBaseBridgeAddress() == null) {
            LOG.info("run: node [{}]: base bridge address is null. BRIDGE_MIB not supported.", (Object)this.getNodeId());
            return null;
        }
        if (!InetAddressUtils.isValidBridgeAddress((String)bridge.getBaseBridgeAddress())) {
            LOG.info("run: node [{}]: base bridge address {} is not valid on. BRIDGE_MIB not supported", (Object)this.getNodeId(), (Object)dot1dbase.getBridgeAddress());
            return null;
        }
        if (bridge.getBaseNumPorts() == null) {
            LOG.info("run: node [{}]: base bridge address {}: has null number port active. Setting to -1.", (Object)this.getNodeId(), (Object)dot1dbase.getBridgeAddress());
            bridge.setBaseNumPorts(Integer.valueOf(-1));
        }
        LOG.info("run: bridge {} has is if type {}, on: {}", new Object[]{dot1dbase.getBridgeAddress(), BridgeElement.BridgeDot1dBaseType.getTypeString((Integer)dot1dbase.getBridgeType()), this.getNodeId()});
        if (bridge.getBaseType() == null) {
            LOG.info("run: node [{}]: base bridge address {}: has null base type. Setting to unknown.", (Object)this.getNodeId(), (Object)dot1dbase.getBridgeAddress());
            bridge.setBaseType(BridgeElement.BridgeDot1dBaseType.DOT1DBASETYPE_UNKNOWN);
        }
        if (bridge.getBaseType() == BridgeElement.BridgeDot1dBaseType.DOT1DBASETYPE_SOURCEROUTE_ONLY) {
            LOG.info("run: node [{}]: base bridge address {}: is source route bridge only. BRIDGE_MIB not supported", (Object)this.getNodeId(), (Object)dot1dbase.getBridgeAddress());
            return null;
        }
        return bridge;
    }

    private Map<Integer, String> getVtpVlanMap(SnmpAgentConfig peer) {
        final HashMap<Integer, String> vlanmap = new HashMap<Integer, String>();
        CiscoVtpTracker vtpStatus = new CiscoVtpTracker();
        try {
            this.m_linkd.getLocationAwareSnmpClient().walk(peer, (CollectionTracker)vtpStatus).withDescription("vtpVersion").withLocation(this.getLocation()).execute().get();
        }
        catch (ExecutionException e) {
            LOG.info("run: node [{}]: ExecutionException: vtpVersion: {}", (Object)this.getNodeId(), (Object)e.getMessage());
            return vlanmap;
        }
        catch (InterruptedException e) {
            LOG.info("run: node [{}]: InterruptedException: vtpVersion: {}", (Object)this.getNodeId(), (Object)e.getMessage());
            return vlanmap;
        }
        if (vtpStatus.getVtpVersion() == null) {
            LOG.info("run: node [{}]: cisco vtp mib not supported.", (Object)this.getNodeId());
            return vlanmap;
        }
        LOG.info("run: node [{}]: cisco vtp mib supported.", (Object)this.getNodeId());
        LOG.debug("run: node [{}]: walking cisco vtp.", (Object)this.getNodeId());
        CiscoVtpVlanTableTracker ciscoVtpVlanTableTracker = new CiscoVtpVlanTableTracker(){

            @Override
            public void processCiscoVtpVlanRow(CiscoVtpVlanTableTracker.CiscoVtpVlanRow row) {
                if (row.isTypeEthernet() && row.isStatusOperational()) {
                    vlanmap.put(row.getVlanIndex(), row.getVlanName());
                }
            }
        };
        try {
            this.m_linkd.getLocationAwareSnmpClient().walk(peer, (CollectionTracker)ciscoVtpVlanTableTracker).withDescription("ciscoVtpVlan").withLocation(this.getLocation()).execute().get();
        }
        catch (ExecutionException e) {
            LOG.info("run: node [{}]: ExecutionException: ciscoVtpVlan table: {}", (Object)this.getNodeId(), (Object)e.getMessage());
        }
        catch (InterruptedException e) {
            LOG.info("run: node [{}]: InterruptedException: ciscoVtpVlan table: {}", (Object)this.getNodeId(), (Object)e.getMessage());
        }
        return vlanmap;
    }

    private Map<Integer, Integer> walkDot1dBasePortTable(SnmpAgentConfig peer) {
        final HashMap<Integer, Integer> bridgetoifindex = new HashMap<Integer, Integer>();
        Dot1dBasePortTableTracker dot1dBasePortTableTracker = new Dot1dBasePortTableTracker(){

            @Override
            public void processDot1dBasePortRow(Dot1dBasePortTableTracker.Dot1dBasePortRow row) {
                bridgetoifindex.put(row.getBaseBridgePort(), row.getBaseBridgePortIfindex());
            }
        };
        try {
            this.m_linkd.getLocationAwareSnmpClient().walk(peer, (CollectionTracker)dot1dBasePortTableTracker).withDescription("dot1dBasePortTable").withLocation(this.getLocation()).execute().get();
        }
        catch (ExecutionException e) {
            LOG.info("run: node [{}]: ExecutionException: dot1dBasePortTable table: {}", (Object)this.getNodeId(), (Object)e.getMessage());
        }
        catch (InterruptedException e) {
            LOG.info("run: node [{}]: InterruptedException: dot1dBasePortTable table: {}", (Object)this.getNodeId(), (Object)e.getMessage());
        }
        return bridgetoifindex;
    }

    private List<BridgeMacLink> walkDot1dTpFdp(final String vlan, final Integer vlanId, final Map<Integer, Integer> bridgeifindex, final List<BridgeMacLink> bft, SnmpAgentConfig peer) {
        Dot1dTpFdbTableTracker dot1dTpFdbTableTracker = new Dot1dTpFdbTableTracker(){

            @Override
            public void processDot1dTpFdbRow(Dot1dTpFdbTableTracker.Dot1dTpFdbRow row) {
                BridgeMacLink link = row.getLink();
                if (link.getBridgeDot1qTpFdbStatus() == null) {
                    LOG.info("processDot1dTpFdbRow: node [{}]: mac {}: vlan {}: on port {}. row has null status. ", new Object[]{NodeDiscoveryBridge.this.getNodeId(), row.getDot1dTpFdbAddress(), vlan, row.getDot1dTpFdbPort()});
                    return;
                }
                if (link.getBridgePort() == null) {
                    LOG.info("processDot1dTpFdbRow: node [{}]: mac {}: vlan {}: on port {} status {}. row has null bridge port.  ", new Object[]{NodeDiscoveryBridge.this.getNodeId(), row.getDot1dTpFdbAddress(), vlan, row.getDot1dTpFdbPort(), link.getBridgeDot1qTpFdbStatus()});
                    return;
                }
                if (link.getMacAddress() == null || !InetAddressUtils.isValidBridgeAddress((String)link.getMacAddress())) {
                    LOG.info("processDot1dTpFdbRow: node [{}]: mac {}: vlan {}: on port {} ifindex {} status {}. row has invalid mac.", new Object[]{NodeDiscoveryBridge.this.getNodeId(), row.getDot1dTpFdbAddress(), vlan, row.getDot1dTpFdbPort(), link.getBridgePortIfIndex(), link.getBridgeDot1qTpFdbStatus()});
                    return;
                }
                link.setVlan(vlanId);
                if (!bridgeifindex.containsKey(link.getBridgePort()) && link.getBridgeDot1qTpFdbStatus() != BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_SELF) {
                    LOG.info("processDot1dTpFdbRow: node [{}]: mac {}: vlan {}: on port {} status {}. no ifindex found. ", new Object[]{NodeDiscoveryBridge.this.getNodeId(), row.getDot1dTpFdbAddress(), vlan, row.getDot1dTpFdbPort(), link.getBridgeDot1qTpFdbStatus()});
                    NodeDiscoveryBridge.this.fixCiscoBridgeMibPort(link.getBridgePort(), bridgeifindex);
                }
                link.setBridgePortIfIndex((Integer)bridgeifindex.get(link.getBridgePort()));
                LOG.debug("processDot1dTpFdbRow: node [{}]: mac {}: vlan {}: on port {} ifindex {} status {}. row processed.", new Object[]{NodeDiscoveryBridge.this.getNodeId(), link.getMacAddress(), link.getVlan(), link.getBridgePort(), link.getBridgePortIfIndex(), link.getBridgeDot1qTpFdbStatus()});
                bft.add(link);
            }
        };
        try {
            this.m_linkd.getLocationAwareSnmpClient().walk(peer, (CollectionTracker)dot1dTpFdbTableTracker).withDescription("dot1dTbFdbPortTable").withLocation(this.getLocation()).execute().get();
        }
        catch (ExecutionException e) {
            LOG.info("run: node [{}]: ExecutionException: dot1dTbFdbPortTable: {}", (Object)this.getNodeId(), (Object)e.getMessage());
        }
        catch (InterruptedException e) {
            LOG.info("run: node [{}]: InterruptedException: dot1dTbFdbPortTable: {}", (Object)this.getNodeId(), (Object)e.getMessage());
        }
        return bft;
    }

    private void fixCiscoBridgeMibPort(Integer bridgeport, Map<Integer, Integer> bridgeifindex) {
        ArrayList<Integer> sortedPort = new ArrayList<Integer>(bridgeifindex.keySet());
        Collections.sort(sortedPort);
        Integer beforePort = null;
        Integer afterPort = null;
        for (Integer port : sortedPort) {
            if (port < bridgeport) {
                beforePort = port;
            }
            if (port <= bridgeport) continue;
            afterPort = port;
            break;
        }
        if (afterPort == null && beforePort == null) {
            bridgeifindex.put(bridgeport, bridgeport);
        } else if (afterPort == null && bridgeifindex.get(beforePort) == 0) {
            bridgeifindex.put(bridgeport, bridgeport);
        } else if (afterPort == null && bridgeifindex.get(beforePort) == 0) {
            bridgeifindex.put(bridgeport, bridgeport + bridgeifindex.get(beforePort) - beforePort);
        } else if (beforePort == null) {
            bridgeifindex.put(bridgeport, bridgeport + bridgeifindex.get(afterPort) - afterPort);
        } else {
            int diffbefore = bridgeifindex.get(beforePort) - beforePort;
            int diffafter = bridgeifindex.get(afterPort) - afterPort;
            if (diffafter == diffbefore) {
                bridgeifindex.put(bridgeport, bridgeport + diffafter);
            } else if (bridgeport - beforePort > afterPort - bridgeport) {
                bridgeifindex.put(bridgeport, diffafter + bridgeport);
            } else {
                bridgeifindex.put(bridgeport, diffbefore + bridgeport);
            }
        }
        LOG.info("fixCiscoBridgeMibPort: node [{}]: port {} ifindex {}.", (Object)bridgeport, (Object)bridgeifindex.get(bridgeport));
    }

    private List<BridgeMacLink> walkDot1qTpFdb(SnmpAgentConfig peer, final Map<Integer, Integer> bridgeifindex, final List<BridgeMacLink> bft) {
        Dot1qTpFdbTableTracker dot1qTpFdbTableTracker = new Dot1qTpFdbTableTracker(){

            @Override
            public void processDot1qTpFdbRow(Dot1qTpFdbTableTracker.Dot1qTpFdbRow row) {
                BridgeMacLink link = row.getLink();
                if (link.getBridgeDot1qTpFdbStatus() == null) {
                    LOG.info("processDot1qTpFdbRow: node [{}]: mac {}: on port {}. row has null status.", new Object[]{NodeDiscoveryBridge.this.getNodeId(), row.getDot1qTpFdbAddress(), row.getDot1qTpFdbPort()});
                    return;
                }
                if (link.getBridgePort() == null) {
                    LOG.info("processDot1qTpFdbRow: node [{}]: mac {}: on port {} status {}. row has null bridge port.", new Object[]{NodeDiscoveryBridge.this.getNodeId(), row.getDot1qTpFdbAddress(), row.getDot1qTpFdbPort(), link.getBridgeDot1qTpFdbStatus()});
                    return;
                }
                if (link.getMacAddress() == null || !InetAddressUtils.isValidBridgeAddress((String)link.getMacAddress())) {
                    LOG.info("processDot1qTpFdbRow: node [{}]: mac {}: on port {} ifindex {} status {}. row has invalid mac.", new Object[]{NodeDiscoveryBridge.this.getNodeId(), row.getDot1qTpFdbAddress(), row.getDot1qTpFdbPort(), link.getBridgePortIfIndex(), link.getBridgeDot1qTpFdbStatus()});
                    return;
                }
                if (bridgeifindex.isEmpty() && link.getBridgeDot1qTpFdbStatus() != BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_SELF) {
                    link.setBridgePortIfIndex(link.getBridgePort());
                    LOG.debug("processDot1qTpFdbRow: node [{}]: mac {}: on port {} ifindex {} status {}. Empty map from bridgeport to ifindex. Assuming ifindex=bridgeport", new Object[]{NodeDiscoveryBridge.this.getNodeId(), row.getDot1qTpFdbAddress(), row.getDot1qTpFdbPort(), link.getBridgePortIfIndex(), link.getBridgeDot1qTpFdbStatus()});
                } else if (!bridgeifindex.containsKey(link.getBridgePort()) && bridgeifindex.containsValue(link.getBridgePort()) && link.getBridgeDot1qTpFdbStatus() != BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_SELF) {
                    for (Integer bridgeport : bridgeifindex.keySet()) {
                        if (link.getBridgePort().intValue() != ((Integer)bridgeifindex.get(bridgeport)).intValue()) continue;
                        link.setBridgePort(bridgeport);
                        link.setBridgePortIfIndex((Integer)bridgeifindex.get(bridgeport));
                    }
                    LOG.debug("processDot1qTpFdbRow: node [{}]: mac {}: on port {} ifindex {} status {}. Assument bridgeport index is ifindex. Reverting bridgeport/ifindex", new Object[]{NodeDiscoveryBridge.this.getNodeId(), row.getDot1qTpFdbAddress(), row.getDot1qTpFdbPort(), link.getBridgePortIfIndex(), link.getBridgeDot1qTpFdbStatus()});
                } else {
                    if (!bridgeifindex.containsKey(link.getBridgePort()) && link.getBridgeDot1qTpFdbStatus() != BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_SELF) {
                        LOG.debug("processDot1qTpFdbRow: node [{}]: mac {}: on port {} ifindex {} status {}. Cnnot find suitable skipping entry", new Object[]{NodeDiscoveryBridge.this.getNodeId(), row.getDot1qTpFdbAddress(), row.getDot1qTpFdbPort(), link.getBridgePortIfIndex(), link.getBridgeDot1qTpFdbStatus()});
                        return;
                    }
                    link.setBridgePortIfIndex((Integer)bridgeifindex.get(link.getBridgePort()));
                }
                LOG.debug("processDot1qTpFdbRow: node [{}]: mac {}: vlan {}: on port {} ifindex {} status {}. row processed.", new Object[]{NodeDiscoveryBridge.this.getNodeId(), link.getMacAddress(), link.getVlan(), link.getBridgePort(), link.getBridgePortIfIndex(), link.getBridgeDot1qTpFdbStatus()});
                bft.add(link);
            }
        };
        try {
            this.m_linkd.getLocationAwareSnmpClient().walk(peer, (CollectionTracker)dot1qTpFdbTableTracker).withDescription("dot1qTbFdbPortTable").withLocation(this.getLocation()).execute().get();
        }
        catch (ExecutionException e) {
            LOG.info("run: node [{}]: ExecutionException: dot1qTbFdbPortTable: {}", (Object)this.getNodeId(), (Object)e.getMessage());
        }
        catch (InterruptedException e) {
            LOG.info("run: node [{}]: InterruptedException: dot1qTbFdbPortTable: {}", (Object)this.getNodeId(), (Object)e.getMessage());
        }
        return bft;
    }

    private List<BridgeStpLink> walkSpanningTree(SnmpAgentConfig peer, final String baseBridgeAddress) {
        final ArrayList<BridgeStpLink> stplinks = new ArrayList<BridgeStpLink>();
        Dot1dStpPortTableTracker stpPortTableTracker = new Dot1dStpPortTableTracker(){

            @Override
            public void processDot1dStpPortRow(Dot1dStpPortTableTracker.Dot1dStpPortRow row) {
                BridgeStpLink link = row.getLink();
                LOG.debug("processDot1dStpPortRow: node [{}]: stp: port:{}/{}, vlan:{}, designated root/bridge/port:{}/{}/{}.", new Object[]{NodeDiscoveryBridge.this.getNodeId(), link.getStpPort(), link.getStpPortState(), link.getVlan(), link.getDesignatedRoot(), link.getDesignatedBridge(), link.getDesignatedPort()});
                if (InetAddressUtils.isValidStpBridgeId((String)link.getDesignatedRoot()) && InetAddressUtils.isValidStpBridgeId((String)link.getDesignatedBridge()) && !baseBridgeAddress.equals(link.getDesignatedBridgeAddress())) {
                    LOG.debug("processDot1dStpPortRow: node [{}]: stp: port:{}/{}, vlan:{}, designated root/bridge/port:{}/{}/{}. row added", new Object[]{NodeDiscoveryBridge.this.getNodeId(), link.getStpPort(), link.getStpPortState(), link.getVlan(), link.getDesignatedRoot(), link.getDesignatedBridge(), link.getDesignatedPort()});
                    stplinks.add(link);
                }
            }
        };
        try {
            this.m_linkd.getLocationAwareSnmpClient().walk(peer, (CollectionTracker)stpPortTableTracker).withDescription("dot1dStpPortTable").withLocation(this.getLocation()).execute().get();
        }
        catch (ExecutionException e) {
            LOG.info("run: node [{}]: ExecutionException: dot1dStpPortTable: {}", (Object)this.getNodeId(), (Object)e.getMessage());
        }
        catch (InterruptedException e) {
            LOG.info("run: node [{}]: InterruptedException: dot1dStpPortTable: {}", (Object)this.getNodeId(), (Object)e.getMessage());
        }
        return stplinks;
    }

    @Override
    public String getName() {
        return "BridgeLinkDiscovery";
    }

    @Override
    public boolean isReady() {
        return this.m_linkd.collectBft(this.getNodeId());
    }
}

