/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opennms.core.criteria.Alias;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.restrictions.EqRestriction;
import org.opennms.core.criteria.restrictions.Restriction;
import org.opennms.netmgt.dao.api.BridgeElementDao;
import org.opennms.netmgt.dao.api.BridgeStpLinkDao;
import org.opennms.netmgt.dao.api.BridgeTopologyDao;
import org.opennms.netmgt.dao.api.CdpElementDao;
import org.opennms.netmgt.dao.api.CdpLinkDao;
import org.opennms.netmgt.dao.api.IpNetToMediaDao;
import org.opennms.netmgt.dao.api.IsIsElementDao;
import org.opennms.netmgt.dao.api.IsIsLinkDao;
import org.opennms.netmgt.dao.api.LldpElementDao;
import org.opennms.netmgt.dao.api.LldpLinkDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.OspfElementDao;
import org.opennms.netmgt.dao.api.OspfLinkDao;
import org.opennms.netmgt.dao.support.UpsertTemplate;
import org.opennms.netmgt.enlinkd.EnhancedLinkdService;
import org.opennms.netmgt.enlinkd.Node;
import org.opennms.netmgt.model.BridgeElement;
import org.opennms.netmgt.model.BridgeMacLink;
import org.opennms.netmgt.model.BridgeStpLink;
import org.opennms.netmgt.model.CdpElement;
import org.opennms.netmgt.model.CdpLink;
import org.opennms.netmgt.model.IpNetToMedia;
import org.opennms.netmgt.model.IsIsElement;
import org.opennms.netmgt.model.IsIsLink;
import org.opennms.netmgt.model.LldpElement;
import org.opennms.netmgt.model.LldpLink;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OspfElement;
import org.opennms.netmgt.model.OspfLink;
import org.opennms.netmgt.model.PrimaryType;
import org.opennms.netmgt.model.topology.BridgeMacLinkHash;
import org.opennms.netmgt.model.topology.BroadcastDomain;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Transactional;

public class EnhancedLinkdServiceImpl
implements EnhancedLinkdService {
    @Autowired
    private PlatformTransactionManager m_transactionManager;
    private NodeDao m_nodeDao;
    private CdpLinkDao m_cdpLinkDao;
    private CdpElementDao m_cdpElementDao;
    private LldpLinkDao m_lldpLinkDao;
    private LldpElementDao m_lldpElementDao;
    private OspfLinkDao m_ospfLinkDao;
    private OspfElementDao m_ospfElementDao;
    private IsIsLinkDao m_isisLinkDao;
    private IsIsElementDao m_isisElementDao;
    private IpNetToMediaDao m_ipNetToMediaDao;
    private BridgeElementDao m_bridgeElementDao;
    private BridgeStpLinkDao m_bridgeStpLinkDao;
    private BridgeTopologyDao m_bridgeTopologyDao;
    volatile Set<BroadcastDomain> m_domains;
    volatile Map<Integer, List<BridgeMacLink>> m_nodetoBroadcastDomainMap = new HashMap<Integer, List<BridgeMacLink>>();

    public synchronized Set<BroadcastDomain> getAll() {
        return this.m_domains;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(BroadcastDomain domain) {
        Set<BroadcastDomain> set = this.m_domains;
        synchronized (set) {
            this.m_domains.remove(domain);
        }
    }

    @Override
    public List<Node> getSnmpNodeList() {
        ArrayList<Node> nodes = new ArrayList<Node>();
        Criteria criteria = new Criteria(OnmsNode.class);
        criteria.setAliases(Arrays.asList(new Alias("ipInterfaces", "iface", Alias.JoinType.LEFT_JOIN)));
        criteria.addRestriction((Restriction)new EqRestriction("type", (Object)OnmsNode.NodeType.ACTIVE));
        criteria.addRestriction((Restriction)new EqRestriction("iface.isSnmpPrimary", (Object)PrimaryType.PRIMARY));
        for (OnmsNode node : this.m_nodeDao.findMatching(criteria)) {
            nodes.add(new Node(node.getId(), node.getPrimaryInterface().getIpAddress(), node.getSysObjectId(), node.getSysName(), node.getLocation() == null ? null : node.getLocation().getLocationName()));
        }
        return nodes;
    }

    @Override
    public Node getSnmpNode(int nodeid) {
        Criteria criteria = new Criteria(OnmsNode.class);
        criteria.setAliases(Arrays.asList(new Alias("ipInterfaces", "iface", Alias.JoinType.LEFT_JOIN)));
        criteria.addRestriction((Restriction)new EqRestriction("type", (Object)OnmsNode.NodeType.ACTIVE));
        criteria.addRestriction((Restriction)new EqRestriction("iface.isSnmpPrimary", (Object)PrimaryType.PRIMARY));
        criteria.addRestriction((Restriction)new EqRestriction("id", (Object)nodeid));
        List nodes = this.m_nodeDao.findMatching(criteria);
        if (nodes.size() > 0) {
            OnmsNode node = (OnmsNode)nodes.get(0);
            return new Node(node.getId(), node.getPrimaryInterface().getIpAddress(), node.getSysObjectId(), node.getSysName(), node.getLocation() == null ? null : node.getLocation().getLocationName());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(int nodeId) {
        this.m_lldpElementDao.deleteByNodeId(Integer.valueOf(nodeId));
        this.m_lldpLinkDao.deleteByNodeId(Integer.valueOf(nodeId));
        this.m_lldpElementDao.flush();
        this.m_lldpLinkDao.flush();
        this.m_cdpElementDao.deleteByNodeId(Integer.valueOf(nodeId));
        this.m_cdpLinkDao.deleteByNodeId(Integer.valueOf(nodeId));
        this.m_cdpElementDao.flush();
        this.m_cdpLinkDao.flush();
        this.m_ospfElementDao.deleteByNodeId(Integer.valueOf(nodeId));
        this.m_ospfLinkDao.deleteByNodeId(Integer.valueOf(nodeId));
        this.m_ospfElementDao.flush();
        this.m_ospfLinkDao.flush();
        this.m_isisElementDao.deleteByNodeId(Integer.valueOf(nodeId));
        this.m_isisLinkDao.deleteByNodeId(Integer.valueOf(nodeId));
        this.m_isisElementDao.flush();
        this.m_isisLinkDao.flush();
        this.m_ipNetToMediaDao.deleteBySourceNodeId(Integer.valueOf(nodeId));
        this.m_ipNetToMediaDao.flush();
        this.m_bridgeElementDao.deleteByNodeId(Integer.valueOf(nodeId));
        this.m_bridgeElementDao.flush();
        this.m_bridgeTopologyDao.delete(nodeId);
        this.m_bridgeStpLinkDao.deleteByNodeId(Integer.valueOf(nodeId));
        this.m_bridgeStpLinkDao.flush();
        Set<BroadcastDomain> set = this.m_domains;
        synchronized (set) {
            Iterator<BroadcastDomain> iterator = this.m_domains.iterator();
            while (iterator.hasNext()) {
                BroadcastDomain domain;
                BroadcastDomain broadcastDomain = domain = iterator.next();
                synchronized (broadcastDomain) {
                    if (domain.containBridgeId(nodeId)) {
                        domain.removeBridge(nodeId);
                        break;
                    }
                }
            }
        }
    }

    @Override
    public void reconcileLldp(int nodeId, Date now) {
        LldpElement element = this.m_lldpElementDao.findByNodeId(Integer.valueOf(nodeId));
        if (element != null && element.getLldpNodeLastPollTime().getTime() < now.getTime()) {
            this.m_lldpElementDao.delete((Object)element);
            this.m_lldpElementDao.flush();
        }
        this.m_lldpLinkDao.deleteByNodeIdOlderThen(Integer.valueOf(nodeId), now);
        this.m_lldpLinkDao.flush();
    }

    @Override
    public void reconcileOspf(int nodeId, Date now) {
        OspfElement element = this.m_ospfElementDao.findByNodeId(Integer.valueOf(nodeId));
        if (element != null && element.getOspfNodeLastPollTime().getTime() < now.getTime()) {
            this.m_ospfElementDao.delete((Object)element);
            this.m_ospfElementDao.flush();
        }
        this.m_ospfLinkDao.deleteByNodeIdOlderThen(Integer.valueOf(nodeId), now);
        this.m_ospfLinkDao.flush();
    }

    @Override
    public void reconcileIsis(int nodeId, Date now) {
        IsIsElement element = this.m_isisElementDao.findByNodeId(Integer.valueOf(nodeId));
        if (element != null && element.getIsisNodeLastPollTime().getTime() < now.getTime()) {
            this.m_isisElementDao.delete((Object)element);
            this.m_isisElementDao.flush();
        }
        this.m_isisLinkDao.deleteByNodeIdOlderThen(Integer.valueOf(nodeId), now);
        this.m_isisLinkDao.flush();
    }

    @Override
    public void reconcileCdp(int nodeId, Date now) {
        CdpElement element = this.m_cdpElementDao.findByNodeId(Integer.valueOf(nodeId));
        if (element != null && element.getCdpNodeLastPollTime().getTime() < now.getTime()) {
            this.m_cdpElementDao.delete((Object)element);
            this.m_cdpElementDao.flush();
        }
        this.m_cdpLinkDao.deleteByNodeIdOlderThen(Integer.valueOf(nodeId), now);
        this.m_cdpLinkDao.flush();
    }

    @Override
    public void reconcileIpNetToMedia(int nodeId, Date now) {
        this.m_ipNetToMediaDao.deleteBySourceNodeIdOlderThen(Integer.valueOf(nodeId), now);
        this.m_ipNetToMediaDao.flush();
    }

    @Override
    public void store(int nodeId, CdpLink link) {
        if (link == null) {
            return;
        }
        this.saveCdpLink(nodeId, link);
    }

    @Transactional
    protected void saveCdpLink(final int nodeId, final CdpLink saveMe) {
        new UpsertTemplate<CdpLink, CdpLinkDao>(this.m_transactionManager, this.m_cdpLinkDao){

            protected CdpLink query() {
                return ((CdpLinkDao)this.m_dao).get(Integer.valueOf(nodeId), saveMe.getCdpCacheIfIndex(), saveMe.getCdpCacheDeviceIndex());
            }

            protected CdpLink doUpdate(CdpLink dbCdpLink) {
                dbCdpLink.merge(saveMe);
                ((CdpLinkDao)this.m_dao).update((Object)dbCdpLink);
                ((CdpLinkDao)this.m_dao).flush();
                return dbCdpLink;
            }

            protected CdpLink doInsert() {
                OnmsNode node = (OnmsNode)EnhancedLinkdServiceImpl.this.m_nodeDao.get((Serializable)Integer.valueOf(nodeId));
                if (node == null) {
                    return null;
                }
                saveMe.setNode(node);
                saveMe.setCdpLinkLastPollTime(saveMe.getCdpLinkCreateTime());
                ((CdpLinkDao)this.m_dao).saveOrUpdate((Object)saveMe);
                ((CdpLinkDao)this.m_dao).flush();
                return saveMe;
            }
        }.execute();
    }

    @Override
    public void store(int nodeId, LldpLink link) {
        if (link == null) {
            return;
        }
        this.saveLldpLink(nodeId, link);
    }

    @Transactional
    protected void saveLldpLink(final int nodeId, final LldpLink saveMe) {
        new UpsertTemplate<LldpLink, LldpLinkDao>(this.m_transactionManager, this.m_lldpLinkDao){

            protected LldpLink query() {
                return ((LldpLinkDao)this.m_dao).get(Integer.valueOf(nodeId), saveMe.getLldpLocalPortNum());
            }

            protected LldpLink doUpdate(LldpLink dbLldpLink) {
                dbLldpLink.merge(saveMe);
                ((LldpLinkDao)this.m_dao).update((Object)dbLldpLink);
                ((LldpLinkDao)this.m_dao).flush();
                return dbLldpLink;
            }

            protected LldpLink doInsert() {
                OnmsNode node = (OnmsNode)EnhancedLinkdServiceImpl.this.m_nodeDao.get((Serializable)Integer.valueOf(nodeId));
                if (node == null) {
                    return null;
                }
                saveMe.setNode(node);
                saveMe.setLldpLinkLastPollTime(saveMe.getLldpLinkCreateTime());
                ((LldpLinkDao)this.m_dao).saveOrUpdate((Object)saveMe);
                ((LldpLinkDao)this.m_dao).flush();
                return saveMe;
            }
        }.execute();
    }

    @Override
    @Transactional
    public void store(int nodeId, CdpElement element) {
        if (element == null) {
            return;
        }
        OnmsNode node = (OnmsNode)this.m_nodeDao.get((Serializable)Integer.valueOf(nodeId));
        if (node == null) {
            return;
        }
        CdpElement dbelement = node.getCdpElement();
        if (dbelement != null) {
            dbelement.merge(element);
            node.setCdpElement(dbelement);
        } else {
            element.setNode(node);
            element.setCdpNodeLastPollTime(element.getCdpNodeCreateTime());
            node.setCdpElement(element);
        }
        this.m_nodeDao.saveOrUpdate((Object)node);
        this.m_nodeDao.flush();
    }

    @Override
    @Transactional
    public void store(int nodeId, LldpElement element) {
        if (element == null) {
            return;
        }
        OnmsNode node = (OnmsNode)this.m_nodeDao.get((Serializable)Integer.valueOf(nodeId));
        if (node == null) {
            return;
        }
        LldpElement dbelement = node.getLldpElement();
        if (dbelement != null) {
            dbelement.merge(element);
            node.setLldpElement(dbelement);
        } else {
            element.setNode(node);
            element.setLldpNodeLastPollTime(element.getLldpNodeCreateTime());
            node.setLldpElement(element);
        }
        this.m_nodeDao.saveOrUpdate((Object)node);
        this.m_nodeDao.flush();
    }

    @Override
    public void store(int nodeId, OspfLink link) {
        if (link == null) {
            return;
        }
        this.saveOspfLink(nodeId, link);
    }

    private void saveOspfLink(final int nodeId, final OspfLink saveMe) {
        new UpsertTemplate<OspfLink, OspfLinkDao>(this.m_transactionManager, this.m_ospfLinkDao){

            protected OspfLink query() {
                return ((OspfLinkDao)this.m_dao).get(Integer.valueOf(nodeId), saveMe.getOspfRemRouterId(), saveMe.getOspfRemIpAddr(), saveMe.getOspfRemAddressLessIndex());
            }

            protected OspfLink doUpdate(OspfLink dbOspfLink) {
                dbOspfLink.merge(saveMe);
                ((OspfLinkDao)this.m_dao).update((Object)dbOspfLink);
                ((OspfLinkDao)this.m_dao).flush();
                return dbOspfLink;
            }

            protected OspfLink doInsert() {
                OnmsNode node = (OnmsNode)EnhancedLinkdServiceImpl.this.m_nodeDao.get((Serializable)Integer.valueOf(nodeId));
                if (node == null) {
                    return null;
                }
                saveMe.setNode(node);
                saveMe.setOspfLinkLastPollTime(saveMe.getOspfLinkCreateTime());
                ((OspfLinkDao)this.m_dao).saveOrUpdate((Object)saveMe);
                ((OspfLinkDao)this.m_dao).flush();
                return saveMe;
            }
        }.execute();
    }

    @Override
    public void store(int nodeId, IsIsLink link) {
        if (link == null) {
            return;
        }
        this.saveIsisLink(nodeId, link);
    }

    @Transactional
    protected void saveIsisLink(final int nodeId, final IsIsLink saveMe) {
        new UpsertTemplate<IsIsLink, IsIsLinkDao>(this.m_transactionManager, this.m_isisLinkDao){

            protected IsIsLink query() {
                return ((IsIsLinkDao)this.m_dao).get(Integer.valueOf(nodeId), saveMe.getIsisCircIndex(), saveMe.getIsisISAdjIndex());
            }

            protected IsIsLink doUpdate(IsIsLink dbIsIsLink) {
                dbIsIsLink.merge(saveMe);
                ((IsIsLinkDao)this.m_dao).update((Object)dbIsIsLink);
                ((IsIsLinkDao)this.m_dao).flush();
                return dbIsIsLink;
            }

            protected IsIsLink doInsert() {
                OnmsNode node = (OnmsNode)EnhancedLinkdServiceImpl.this.m_nodeDao.get((Serializable)Integer.valueOf(nodeId));
                if (node == null) {
                    return null;
                }
                saveMe.setNode(node);
                saveMe.setIsisLinkLastPollTime(saveMe.getIsisLinkCreateTime());
                ((IsIsLinkDao)this.m_dao).saveOrUpdate((Object)saveMe);
                ((IsIsLinkDao)this.m_dao).flush();
                return saveMe;
            }
        }.execute();
    }

    @Override
    @Transactional
    public void store(int nodeId, OspfElement element) {
        if (element == null) {
            return;
        }
        OnmsNode node = (OnmsNode)this.m_nodeDao.get((Serializable)Integer.valueOf(nodeId));
        if (node == null) {
            return;
        }
        OspfElement dbelement = node.getOspfElement();
        if (dbelement != null) {
            dbelement.merge(element);
            node.setOspfElement(dbelement);
        } else {
            element.setNode(node);
            element.setOspfNodeLastPollTime(element.getOspfNodeCreateTime());
            node.setOspfElement(element);
        }
        this.m_nodeDao.saveOrUpdate((Object)node);
        this.m_nodeDao.flush();
    }

    @Override
    @Transactional
    public void store(int nodeId, IsIsElement element) {
        if (element == null) {
            return;
        }
        OnmsNode node = (OnmsNode)this.m_nodeDao.get((Serializable)Integer.valueOf(nodeId));
        if (node == null) {
            return;
        }
        IsIsElement dbelement = node.getIsisElement();
        if (dbelement != null) {
            dbelement.merge(element);
            node.setIsisElement(dbelement);
        } else {
            element.setNode(node);
            element.setIsisNodeLastPollTime(element.getIsisNodeCreateTime());
            node.setIsisElement(element);
        }
        this.m_nodeDao.saveOrUpdate((Object)node);
        this.m_nodeDao.flush();
    }

    @Override
    public void store(int nodeId, BridgeElement bridge) {
        if (bridge == null) {
            return;
        }
        this.saveBridgeElement(nodeId, bridge);
    }

    @Transactional
    protected void saveBridgeElement(final int nodeId, final BridgeElement saveMe) {
        new UpsertTemplate<BridgeElement, BridgeElementDao>(this.m_transactionManager, this.m_bridgeElementDao){

            protected BridgeElement query() {
                return ((BridgeElementDao)this.m_dao).getByNodeIdVlan(Integer.valueOf(nodeId), saveMe.getVlan());
            }

            protected BridgeElement doUpdate(BridgeElement bridge) {
                bridge.merge(saveMe);
                ((BridgeElementDao)this.m_dao).update((Object)bridge);
                ((BridgeElementDao)this.m_dao).flush();
                return bridge;
            }

            protected BridgeElement doInsert() {
                OnmsNode node = (OnmsNode)EnhancedLinkdServiceImpl.this.m_nodeDao.get((Serializable)Integer.valueOf(nodeId));
                if (node == null) {
                    return null;
                }
                saveMe.setNode(node);
                saveMe.setBridgeNodeLastPollTime(saveMe.getBridgeNodeCreateTime());
                ((BridgeElementDao)this.m_dao).saveOrUpdate((Object)saveMe);
                ((BridgeElementDao)this.m_dao).flush();
                return saveMe;
            }
        }.execute();
    }

    @Override
    public void store(int nodeId, BridgeStpLink link) {
        if (link == null) {
            return;
        }
        this.saveBridgeStpLink(nodeId, link);
    }

    @Transactional
    protected void saveBridgeStpLink(final int nodeId, final BridgeStpLink saveMe) {
        new UpsertTemplate<BridgeStpLink, BridgeStpLinkDao>(this.m_transactionManager, this.m_bridgeStpLinkDao){

            protected BridgeStpLink query() {
                return ((BridgeStpLinkDao)this.m_dao).getByNodeIdBridgePort(Integer.valueOf(nodeId), saveMe.getStpPort());
            }

            protected BridgeStpLink doUpdate(BridgeStpLink link) {
                link.merge(saveMe);
                ((BridgeStpLinkDao)this.m_dao).update((Object)link);
                ((BridgeStpLinkDao)this.m_dao).flush();
                return link;
            }

            protected BridgeStpLink doInsert() {
                OnmsNode node = (OnmsNode)EnhancedLinkdServiceImpl.this.m_nodeDao.get((Serializable)Integer.valueOf(nodeId));
                if (node == null) {
                    return null;
                }
                saveMe.setNode(node);
                saveMe.setBridgeStpLinkLastPollTime(saveMe.getBridgeStpLinkCreateTime());
                ((BridgeStpLinkDao)this.m_dao).saveOrUpdate((Object)saveMe);
                ((BridgeStpLinkDao)this.m_dao).flush();
                return saveMe;
            }
        }.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBft(int nodeId, List<BridgeMacLink> bft) {
        HashMap<BridgeMacLinkHash, BridgeMacLink> effectiveBFT = new HashMap<BridgeMacLinkHash, BridgeMacLink>();
        for (BridgeMacLink link : bft) {
            OnmsNode node = new OnmsNode();
            node.setId(Integer.valueOf(nodeId));
            link.setNode(node);
            effectiveBFT.put(new BridgeMacLinkHash(link), link);
        }
        Map<Integer, List<BridgeMacLink>> map = this.m_nodetoBroadcastDomainMap;
        synchronized (map) {
            this.m_nodetoBroadcastDomainMap.put(nodeId, new ArrayList(effectiveBFT.values()));
        }
    }

    @Override
    public synchronized Map<Integer, List<BridgeMacLink>> getUpdateBftMap() {
        return this.m_nodetoBroadcastDomainMap;
    }

    @Override
    public void reconcileBridge(int nodeId, Date now) {
        this.m_bridgeElementDao.deleteByNodeIdOlderThen(Integer.valueOf(nodeId), now);
        this.m_bridgeElementDao.flush();
        this.m_bridgeStpLinkDao.deleteByNodeIdOlderThen(Integer.valueOf(nodeId), now);
        this.m_bridgeStpLinkDao.flush();
    }

    @Override
    public synchronized Set<BroadcastDomain> getAllBroadcastDomains() {
        return this.m_domains;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(BroadcastDomain domain) {
        Set<BroadcastDomain> set = this.m_domains;
        synchronized (set) {
            this.m_domains.add(domain);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanBroadcastDomains() {
        Set<BroadcastDomain> set = this.m_domains;
        synchronized (set) {
            this.m_domains.removeIf(BroadcastDomain::isEmpty);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BroadcastDomain getBroadcastDomain(int nodeId) {
        Set<BroadcastDomain> set = this.m_domains;
        synchronized (set) {
            for (BroadcastDomain domain : this.m_domains) {
                if (!domain.containBridgeId(nodeId)) continue;
                return domain;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasUpdatedBft(int nodeid) {
        Map<Integer, List<BridgeMacLink>> map = this.m_nodetoBroadcastDomainMap;
        synchronized (map) {
            return this.m_nodetoBroadcastDomainMap.containsKey(nodeid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<BridgeMacLink> useBridgeTopologyUpdateBFT(int nodeid) {
        Map<Integer, List<BridgeMacLink>> map = this.m_nodetoBroadcastDomainMap;
        synchronized (map) {
            return this.m_nodetoBroadcastDomainMap.remove(nodeid);
        }
    }

    @Override
    public synchronized List<BridgeMacLink> getBridgeTopologyUpdateBFT(int nodeid) {
        return this.m_nodetoBroadcastDomainMap.get(nodeid);
    }

    @Override
    public void store(BroadcastDomain domain) {
        this.m_bridgeTopologyDao.save(domain);
    }

    @Override
    public void reconcileBridgeTopology(BroadcastDomain domain, Date now) {
        for (Integer nodeid : domain.getBridgeNodesOnDomain()) {
            this.m_bridgeTopologyDao.deleteOlder(nodeid.intValue(), now);
        }
    }

    @Override
    public void store(int nodeId, IpNetToMedia ipnettomedia) {
        if (ipnettomedia == null) {
            return;
        }
        this.saveIpNetToMedia(nodeId, ipnettomedia);
    }

    @Transactional
    protected void saveIpNetToMedia(final int nodeId, final IpNetToMedia saveMe) {
        new UpsertTemplate<IpNetToMedia, IpNetToMediaDao>(this.m_transactionManager, this.m_ipNetToMediaDao){

            protected IpNetToMedia query() {
                return ((IpNetToMediaDao)this.m_dao).getByNetAndPhysAddress(saveMe.getNetAddress(), saveMe.getPhysAddress());
            }

            protected IpNetToMedia doUpdate(IpNetToMedia dbIpNetToMedia) {
                OnmsNode node = (OnmsNode)EnhancedLinkdServiceImpl.this.m_nodeDao.get((Serializable)Integer.valueOf(nodeId));
                if (node == null) {
                    return null;
                }
                saveMe.setSourceNode(node);
                dbIpNetToMedia.merge(saveMe);
                ((IpNetToMediaDao)this.m_dao).update((Object)dbIpNetToMedia);
                ((IpNetToMediaDao)this.m_dao).flush();
                return dbIpNetToMedia;
            }

            protected IpNetToMedia doInsert() {
                OnmsNode node = (OnmsNode)EnhancedLinkdServiceImpl.this.m_nodeDao.get((Serializable)Integer.valueOf(nodeId));
                if (node == null) {
                    return null;
                }
                saveMe.setSourceNode(node);
                saveMe.setLastPollTime(saveMe.getCreateTime());
                ((IpNetToMediaDao)this.m_dao).saveOrUpdate((Object)saveMe);
                ((IpNetToMediaDao)this.m_dao).flush();
                return saveMe;
            }
        }.execute();
    }

    @Override
    public void loadBridgeTopology() {
        this.m_domains = this.m_bridgeTopologyDao.load();
    }

    public CdpLinkDao getCdpLinkDao() {
        return this.m_cdpLinkDao;
    }

    public void setCdpLinkDao(CdpLinkDao cdpLinkDao) {
        this.m_cdpLinkDao = cdpLinkDao;
    }

    public LldpLinkDao getLldpLinkDao() {
        return this.m_lldpLinkDao;
    }

    public void setLldpLinkDao(LldpLinkDao lldpLinkDao) {
        this.m_lldpLinkDao = lldpLinkDao;
    }

    public NodeDao getNodeDao() {
        return this.m_nodeDao;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }

    public OspfLinkDao getOspfLinkDao() {
        return this.m_ospfLinkDao;
    }

    public void setOspfLinkDao(OspfLinkDao ospfLinkDao) {
        this.m_ospfLinkDao = ospfLinkDao;
    }

    public IsIsLinkDao getIsisLinkDao() {
        return this.m_isisLinkDao;
    }

    public void setIsisLinkDao(IsIsLinkDao isisLinkDao) {
        this.m_isisLinkDao = isisLinkDao;
    }

    public CdpElementDao getCdpElementDao() {
        return this.m_cdpElementDao;
    }

    public void setCdpElementDao(CdpElementDao cdpElementDao) {
        this.m_cdpElementDao = cdpElementDao;
    }

    public LldpElementDao getLldpElementDao() {
        return this.m_lldpElementDao;
    }

    public void setLldpElementDao(LldpElementDao lldpElementDao) {
        this.m_lldpElementDao = lldpElementDao;
    }

    public OspfElementDao getOspfElementDao() {
        return this.m_ospfElementDao;
    }

    public void setOspfElementDao(OspfElementDao ospfElementDao) {
        this.m_ospfElementDao = ospfElementDao;
    }

    public IsIsElementDao getIsisElementDao() {
        return this.m_isisElementDao;
    }

    public void setIsisElementDao(IsIsElementDao isisElementDao) {
        this.m_isisElementDao = isisElementDao;
    }

    public BridgeElementDao getBridgeElementDao() {
        return this.m_bridgeElementDao;
    }

    public void setBridgeElementDao(BridgeElementDao bridgeElementDao) {
        this.m_bridgeElementDao = bridgeElementDao;
    }

    public BridgeStpLinkDao getBridgeStpLinkDao() {
        return this.m_bridgeStpLinkDao;
    }

    public void setBridgeStpLinkDao(BridgeStpLinkDao bridgeStpLinkDao) {
        this.m_bridgeStpLinkDao = bridgeStpLinkDao;
    }

    public IpNetToMediaDao getIpNetToMediaDao() {
        return this.m_ipNetToMediaDao;
    }

    public void setIpNetToMediaDao(IpNetToMediaDao ipNetToMediaDao) {
        this.m_ipNetToMediaDao = ipNetToMediaDao;
    }

    public BridgeTopologyDao getBridgeTopologyDao() {
        return this.m_bridgeTopologyDao;
    }

    public void setBridgeTopologyDao(BridgeTopologyDao bridgeTopologyDao) {
        this.m_bridgeTopologyDao = bridgeTopologyDao;
    }

    @Override
    public List<BridgeElement> getBridgeElements(Set<Integer> nodes) {
        ArrayList<BridgeElement> elems = new ArrayList<BridgeElement>();
        for (Integer nodeid : nodes) {
            elems.addAll(this.m_bridgeElementDao.findByNodeId(nodeid));
        }
        return elems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void persistForwarders() {
        Set<BroadcastDomain> set = this.m_domains;
        synchronized (set) {
            for (BroadcastDomain domain : this.m_domains) {
                this.m_bridgeTopologyDao.saveForwarders(domain);
            }
        }
    }
}

