/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller;

import java.net.InetAddress;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import org.opennms.core.rpc.api.RequestRejectedException;
import org.opennms.core.rpc.api.RequestTimedOutException;
import org.opennms.netmgt.config.OpennmsServerConfigFactory;
import org.opennms.netmgt.config.PollerConfig;
import org.opennms.netmgt.dao.api.CriticalPath;
import org.opennms.netmgt.dao.hibernate.PathOutageManagerDaoImpl;
import org.opennms.netmgt.events.api.EventIpcManager;
import org.opennms.netmgt.events.api.EventListener;
import org.opennms.netmgt.icmp.proxy.LocationAwarePingClient;
import org.opennms.netmgt.icmp.proxy.PingSummary;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.poller.QueryManager;
import org.opennms.netmgt.poller.pollables.PendingPollEvent;
import org.opennms.netmgt.poller.pollables.PollContext;
import org.opennms.netmgt.poller.pollables.PollEvent;
import org.opennms.netmgt.poller.pollables.PollableService;
import org.opennms.netmgt.snmp.InetAddrUtils;
import org.opennms.netmgt.xml.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPollContext
implements PollContext,
EventListener {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultPollContext.class);
    private static final String[] UEIS = new String[]{"uei.opennms.org/nodes/serviceUnresponsive", "uei.opennms.org/nodes/serviceResponsive", "uei.opennms.org/nodes/nodeRegainedService", "uei.opennms.org/nodes/nodeLostService", "uei.opennms.org/nodes/interfaceDown", "uei.opennms.org/nodes/interfaceUp", "uei.opennms.org/nodes/nodeDown", "uei.opennms.org/nodes/nodeUp"};
    private volatile PollerConfig m_pollerConfig;
    private volatile QueryManager m_queryManager;
    private volatile EventIpcManager m_eventManager;
    private volatile LocationAwarePingClient m_locationAwarePingClient;
    private volatile String m_name;
    private volatile String m_localHostName;
    private volatile boolean m_listenerAdded = false;
    private final Queue<PendingPollEvent> m_pendingPollEvents = new ConcurrentLinkedQueue<PendingPollEvent>();

    public EventIpcManager getEventManager() {
        return this.m_eventManager;
    }

    public void setEventManager(EventIpcManager eventManager) {
        this.m_eventManager = eventManager;
    }

    public void setLocalHostName(String localHostName) {
        this.m_localHostName = localHostName;
    }

    public String getLocalHostName() {
        return this.m_localHostName;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public PollerConfig getPollerConfig() {
        return this.m_pollerConfig;
    }

    public void setPollerConfig(PollerConfig pollerConfig) {
        this.m_pollerConfig = pollerConfig;
    }

    public QueryManager getQueryManager() {
        return this.m_queryManager;
    }

    public void setQueryManager(QueryManager queryManager) {
        this.m_queryManager = queryManager;
    }

    public LocationAwarePingClient getLocationAwarePingClient() {
        return this.m_locationAwarePingClient;
    }

    public void setLocationAwarePingClient(LocationAwarePingClient locationAwarePingClient) {
        this.m_locationAwarePingClient = locationAwarePingClient;
    }

    @Override
    public String getCriticalServiceName() {
        return this.getPollerConfig().getCriticalService();
    }

    @Override
    public boolean isNodeProcessingEnabled() {
        return this.getPollerConfig().isNodeOutageProcessingEnabled();
    }

    @Override
    public boolean isPollingAllIfCritServiceUndefined() {
        return this.getPollerConfig().shouldPollAllIfNoCriticalServiceDefined();
    }

    @Override
    public PollEvent sendEvent(Event event) {
        if (!this.m_listenerAdded) {
            this.getEventManager().addEventListener((EventListener)this, Arrays.asList(UEIS));
            this.m_listenerAdded = true;
        }
        PendingPollEvent pollEvent = new PendingPollEvent(event);
        this.m_pendingPollEvents.add(pollEvent);
        this.getEventManager().sendNow(event);
        return pollEvent;
    }

    @Override
    public Event createEvent(String uei, int nodeId, InetAddress address, String svcName, Date date, String reason) {
        LOG.debug("createEvent: uei = {} nodeid = {}", (Object)uei, (Object)nodeId);
        EventBuilder bldr = new EventBuilder(uei, this.getName(), date);
        bldr.setNodeid((long)nodeId);
        if (address != null) {
            bldr.setInterface(address);
        }
        if (svcName != null) {
            bldr.setService(svcName);
        }
        bldr.setHost(this.getLocalHostName());
        if (uei.equals("uei.opennms.org/nodes/nodeDown") && this.getPollerConfig().isPathOutageEnabled()) {
            CriticalPath criticalPath = PathOutageManagerDaoImpl.getInstance().getCriticalPath(nodeId);
            if (criticalPath != null && criticalPath.getIpAddress() != null) {
                if (!this.testCriticalPath(criticalPath)) {
                    LOG.debug("Critical path test failed for node {}", (Object)nodeId);
                    bldr.addParam("eventReason", "pathOutage");
                    bldr.addParam("criticalPathIp", InetAddrUtils.str((InetAddress)criticalPath.getIpAddress()));
                    bldr.addParam("criticalPathServiceName", criticalPath.getServiceName());
                } else {
                    LOG.debug("Critical path test passed for node {}", (Object)nodeId);
                }
            } else {
                LOG.debug("No Critical path to test for node {}", (Object)nodeId);
            }
        } else if (uei.equals("uei.opennms.org/nodes/nodeLostService")) {
            bldr.addParam("eventReason", reason == null ? "Unknown" : reason);
        }
        if (uei.equals("uei.opennms.org/nodes/nodeUp") || uei.equals("uei.opennms.org/nodes/nodeDown")) {
            String nodeLabel = this.getNodeLabel(nodeId);
            bldr.addParam("nodelabel", nodeLabel);
        }
        return bldr.getEvent();
    }

    @Override
    public void openOutage(final PollableService svc, final PollEvent svcLostEvent) {
        final Integer outageId = this.getQueryManager().openOutagePendingLostEventId(svc.getNodeId(), svc.getIpAddr(), svc.getSvcName(), svcLostEvent.getDate());
        Runnable r = new Runnable(){

            @Override
            public void run() {
                int eventId = svcLostEvent.getEventId();
                if (eventId > 0) {
                    DefaultPollContext.this.getQueryManager().updateOpenOutageWithEventId(outageId, eventId);
                } else {
                    LOG.warn("run: Failed to determine an eventId for service lost for: {} with event: {}", (Object)svc, (Object)svcLostEvent);
                }
            }
        };
        if (svcLostEvent instanceof PendingPollEvent) {
            ((PendingPollEvent)svcLostEvent).addPending(r);
        } else {
            r.run();
        }
        LOG.debug("openOutage: sending outageCreated event for: {} on {}", (Object)svc.getSvcName(), (Object)svc.getIpAddr());
        this.sendEvent(this.createEvent("uei.opennms.org/internal/poller/outageCreated", svc.getNodeId(), svc.getAddress(), svc.getSvcName(), svcLostEvent.getDate(), null));
    }

    @Override
    public void resolveOutage(final PollableService svc, final PollEvent svcRegainEvent) {
        final Integer outageId = this.getQueryManager().resolveOutagePendingRegainEventId(svc.getNodeId(), svc.getIpAddr(), svc.getSvcName(), svcRegainEvent.getDate());
        if (outageId == null) {
            LOG.info("resolveOutage: no outstanding outage for {} on {} with node id {}", new Object[]{svc.getSvcName(), svc.getIpAddr(), svc.getNodeId()});
            return;
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                int eventId = svcRegainEvent.getEventId();
                if (eventId > 0) {
                    DefaultPollContext.this.getQueryManager().updateResolvedOutageWithEventId(outageId, eventId);
                } else {
                    LOG.warn("run: Failed to determine an eventId for service regained for: {} with event: {}", (Object)svc, (Object)svcRegainEvent);
                }
            }
        };
        if (svcRegainEvent instanceof PendingPollEvent) {
            ((PendingPollEvent)svcRegainEvent).addPending(r);
        } else {
            r.run();
        }
        LOG.debug("resolveOutage: sending outageResolved event for: {} on {}", (Object)svc.getSvcName(), (Object)svc.getIpAddr());
        this.sendEvent(this.createEvent("uei.opennms.org/internal/poller/outageResolved", svc.getNodeId(), svc.getAddress(), svc.getSvcName(), svcRegainEvent.getDate(), null));
    }

    @Override
    public boolean isServiceUnresponsiveEnabled() {
        return this.getPollerConfig().isServiceUnresponsiveEnabled();
    }

    public void onEvent(Event event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onEvent: Received event: {} uei: {}, dbid: {}, pendingEventCount: {}", new Object[]{event, event.getUei(), event.getDbid(), this.m_pendingPollEvents.size()});
        }
        for (PendingPollEvent pollEvent : this.m_pendingPollEvents) {
            LOG.trace("onEvent: comparing event to pollEvent: {}", (Object)pollEvent);
            if (!event.equals(pollEvent.getEvent())) continue;
            LOG.trace("onEvent: found matching pollEvent, completing pollEvent: {}", (Object)pollEvent);
            pollEvent.complete(event);
        }
        Iterator it = this.m_pendingPollEvents.iterator();
        while (it.hasNext()) {
            PendingPollEvent pollEvent;
            pollEvent = (PendingPollEvent)it.next();
            LOG.trace("onEvent: determining if pollEvent is pending: {}", (Object)pollEvent);
            if (pollEvent.isPending()) continue;
            try {
                DefaultPollContext.processPending(pollEvent);
            }
            catch (Throwable e) {
                LOG.error("Unexpected exception while processing pollEvent: " + pollEvent, e);
            }
            it.remove();
        }
        LOG.debug("onEvent: Finished processing event: {} uei: {}, dbid: {}", new Object[]{event, event.getUei(), event.getDbid()});
    }

    private static void processPending(PendingPollEvent pollEvent) {
        LOG.trace("onEvent: pollEvent is no longer pending, processing pollEvent: {}", (Object)pollEvent);
        pollEvent.processPending();
        LOG.trace("onEvent: processing of pollEvent completed: {}", (Object)pollEvent);
    }

    private boolean testCriticalPath(CriticalPath criticalPath) {
        if (!"ICMP".equalsIgnoreCase(criticalPath.getServiceName())) {
            LOG.warn("Critical paths using services other than ICMP are not currently supported. ICMP will be used for testing {}.", (Object)criticalPath);
        }
        InetAddress ipAddress = criticalPath.getIpAddress();
        int retries = OpennmsServerConfigFactory.getInstance().getDefaultCriticalPathRetries();
        int timeout = OpennmsServerConfigFactory.getInstance().getDefaultCriticalPathTimeout();
        boolean available = false;
        try {
            PingSummary pingSummary = (PingSummary)this.m_locationAwarePingClient.ping(ipAddress).withLocation(criticalPath.getLocationName()).withTimeout((long)timeout, TimeUnit.MILLISECONDS).withRetries(retries).execute().get();
            available = pingSummary.getSequences().stream().filter(s -> s.isSuccess()).count() > 0L;
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted while testing {}. Marking the path as available.", (Object)criticalPath);
            available = true;
        }
        catch (Throwable e) {
            Throwable cause = e.getCause();
            if (cause != null && cause instanceof RequestTimedOutException) {
                LOG.warn("No response was received when remotely testing {}. Marking the path as available.", (Object)criticalPath);
                available = true;
            } else if (cause != null && cause instanceof RequestRejectedException) {
                LOG.warn("Request was rejected when attemtping to test the remote path {}. Marking the path as available.", (Object)criticalPath);
                available = true;
            }
            LOG.warn("An unknown error occured while testing the critical path: {}. Marking the path as unavailable.", (Object)criticalPath, (Object)e);
            available = false;
        }
        LOG.debug("testCriticalPath: checking {}@{}, available ? {}", new Object[]{criticalPath.getServiceName(), ipAddress, available});
        return available;
    }

    private String getNodeLabel(int nodeId) {
        String nodeLabel = null;
        try {
            nodeLabel = this.getQueryManager().getNodeLabel(nodeId);
        }
        catch (SQLException sqlE) {
            LOG.warn("Failed to retrieve node label for nodeid {}", (Object)nodeId, (Object)sqlE);
        }
        if (nodeLabel == null) {
            nodeLabel = String.valueOf(nodeId);
        }
        return nodeLabel;
    }
}

