/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmpinterfacepoller.pollable;

import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.MockLogAppender;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.NetworkBuilder;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.snmpinterfacepoller.pollable.PollContext;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath:/META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml", "classpath:/META-INF/opennms/applicationContext-daemon.xml", "classpath:/META-INF/opennms/applicationContext-proxy-snmp.xml", "classpath:/META-INF/opennms/mockEventIpcManager.xml", "classpath:/META-INF/opennms/applicationContext-databasePopulator.xml", "classpath:/META-INF/opennms/applicationContext-snmpinterfacepollerd.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
public class PollContextIT {
    @Autowired
    private PollContext m_pollContext;
    @Autowired
    private NodeDao m_nodeDao;

    @Before
    public void setUp() throws Exception {
        MockLogAppender.setupLogging();
        NetworkBuilder nb = new NetworkBuilder();
        nb.addNode("cisco2691").setForeignSource("linkd").setForeignId("cisco2691").setSysObjectId(".1.3.6.1.4.1.9.1.122").setType(OnmsNode.NodeType.ACTIVE);
        OnmsSnmpInterface null0 = new OnmsSnmpInterface(nb.getCurrentNode(), 4);
        null0.setIfSpeed(Long.valueOf(10000000L));
        null0.setPoll("P");
        null0.setIfType(Integer.valueOf(6));
        null0.setCollectionEnabled(false);
        null0.setIfOperStatus(Integer.valueOf(2));
        null0.setIfDescr("Null0");
        nb.addInterface("10.1.4.2", null0).setIsSnmpPrimary("P").setIsManaged("M");
        OnmsSnmpInterface fa0 = new OnmsSnmpInterface(nb.getCurrentNode(), 2);
        fa0.setIfSpeed(Long.valueOf(100000000L));
        fa0.setPoll("P");
        fa0.setIfType(Integer.valueOf(6));
        fa0.setCollectionEnabled(false);
        fa0.setIfOperStatus(Integer.valueOf(1));
        fa0.setIfDescr("FastEthernet0");
        nb.addInterface("10.1.5.1", fa0).setIsSnmpPrimary("S").setIsManaged("M");
        OnmsSnmpInterface eth0 = new OnmsSnmpInterface(nb.getCurrentNode(), 1);
        eth0.setIfSpeed(Long.valueOf(100000000L));
        eth0.setPoll("P");
        eth0.setIfType(Integer.valueOf(6));
        eth0.setCollectionEnabled(false);
        eth0.setIfOperStatus(Integer.valueOf(1));
        eth0.setIfDescr("Ethernet0");
        nb.addInterface("10.1.7.1", eth0).setIsSnmpPrimary("S").setIsManaged("M");
        this.m_nodeDao.save((Object)nb.getCurrentNode());
        nb.addNode("cisco1700").setForeignSource("linkd").setForeignId("cisco1700").setSysObjectId(".1.3.6.1.4.1.9.1.200").setType(OnmsNode.NodeType.ACTIVE);
        OnmsSnmpInterface eth1 = new OnmsSnmpInterface(nb.getCurrentNode(), 2);
        eth1.setIfSpeed(Long.valueOf(100000000L));
        eth1.setPoll("P");
        eth1.setIfType(Integer.valueOf(6));
        eth1.setCollectionEnabled(false);
        eth1.setIfOperStatus(Integer.valueOf(1));
        eth1.setIfDescr("Ethernet1");
        nb.addInterface("10.1.5.2", eth1).setIsSnmpPrimary("P").setIsManaged("M");
        this.m_nodeDao.save((Object)nb.getCurrentNode());
        this.m_nodeDao.flush();
    }

    @After
    public void tearDown() throws Exception {
        for (OnmsNode node : this.m_nodeDao.findAll()) {
            this.m_nodeDao.delete((Object)node);
        }
        this.m_nodeDao.flush();
        MockLogAppender.assertNoWarningsOrGreater();
    }

    @Test
    public void testCriterias() throws Exception {
        Assert.assertNotNull((Object)this.m_pollContext);
        OnmsNode node = this.m_nodeDao.findByForeignId("linkd", "cisco2691");
        Assert.assertNotNull((Object)node);
        List ipInterfaces = this.m_pollContext.getPollableNodes();
        Assert.assertNotNull((Object)ipInterfaces);
        Assert.assertEquals((long)2L, (long)ipInterfaces.size());
        ipInterfaces = this.m_pollContext.getPollableNodesByIp("10.1.4.2");
        Assert.assertNotNull((Object)ipInterfaces);
        Assert.assertEquals((long)1L, (long)ipInterfaces.size());
        ipInterfaces = this.m_pollContext.getPollableNodesByIp("10.1.5.1");
        Assert.assertNotNull((Object)ipInterfaces);
        Assert.assertEquals((long)0L, (long)ipInterfaces.size());
        String criteria = "snmpifdescr like '%Ethernet%' and ipinterfac1_.ipaddr like '10.1.5.%'";
        List snmpInterfaces = this.m_pollContext.get(node.getId().intValue(), criteria);
        Assert.assertNotNull((Object)snmpInterfaces);
        Assert.assertEquals((long)1L, (long)snmpInterfaces.size());
    }
}

