/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.mock;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.opennms.netmgt.poller.mock.MockTimer;
import org.opennms.netmgt.scheduler.ReadyRunnable;
import org.opennms.netmgt.scheduler.Scheduler;

public class MockScheduler
implements Scheduler {
    private MockTimer m_timer;
    private SortedMap<Long, List<ReadyRunnable>> m_scheduleEntries = new TreeMap<Long, List<ReadyRunnable>>();
    private long m_numTasksExecuted = 0L;

    public MockScheduler() {
        this(new MockTimer());
    }

    public MockScheduler(MockTimer timer) {
        this.m_timer = timer;
    }

    public void schedule(long interval, ReadyRunnable schedule) {
        Long nextTime = this.getCurrentTime() + interval;
        LinkedList<ReadyRunnable> entries = (LinkedList<ReadyRunnable>)this.m_scheduleEntries.get(nextTime);
        if (entries == null) {
            entries = new LinkedList<ReadyRunnable>();
            this.m_scheduleEntries.put(nextTime, entries);
        }
        entries.add(schedule);
    }

    public int getEntryCount() {
        return this.m_scheduleEntries.size();
    }

    public Map<Long, List<ReadyRunnable>> getEntries() {
        return this.m_scheduleEntries;
    }

    public long getNextTime() {
        if (this.m_scheduleEntries.isEmpty()) {
            throw new IllegalStateException("Nothing scheduled");
        }
        Long nextTime = this.m_scheduleEntries.firstKey();
        return nextTime;
    }

    public long next() {
        if (this.m_scheduleEntries.isEmpty()) {
            throw new IllegalStateException("Nothing scheduled");
        }
        Long nextTime = this.m_scheduleEntries.firstKey();
        List entries = (List)this.m_scheduleEntries.get(nextTime);
        Runnable runnable = (Runnable)entries.get(0);
        this.m_timer.setCurrentTime(nextTime);
        entries.remove(0);
        if (entries.isEmpty()) {
            this.m_scheduleEntries.remove(nextTime);
        }
        runnable.run();
        ++this.m_numTasksExecuted;
        return this.getCurrentTime();
    }

    public long tick(int step) {
        if (this.m_scheduleEntries.isEmpty()) {
            throw new IllegalStateException("Nothing scheduled");
        }
        long endTime = this.getCurrentTime() + (long)step;
        while (this.getNextTime() <= endTime) {
            this.next();
        }
        this.m_timer.setCurrentTime(endTime);
        return this.getCurrentTime();
    }

    public long getCurrentTime() {
        return this.m_timer.getCurrentTime();
    }

    public void start() {
    }

    public void stop() {
    }

    public void pause() {
    }

    public void resume() {
    }

    public int getStatus() {
        return 0;
    }

    public long getNumTasksExecuted() {
        return this.m_numTasksExecuted;
    }
}

