/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.mock;

import java.util.LinkedList;
import java.util.List;
import org.opennms.netmgt.scheduler.ScheduleInterval;
import org.opennms.netmgt.scheduler.Timer;

public class MockInterval
implements ScheduleInterval {
    private Timer m_timer;
    private long m_interval;
    private List<Suspension> m_suspensions = new LinkedList<Suspension>();

    public MockInterval(Timer timer, long interval) {
        this.m_timer = timer;
        this.m_interval = interval;
    }

    public long getInterval() {
        return this.m_interval;
    }

    public void setInterval(long interval) {
        this.m_interval = interval;
    }

    public void addSuspension(long start, long end) {
        this.m_suspensions.add(new Suspension(start, end));
    }

    public boolean scheduledSuspension() {
        for (Suspension suspension : this.m_suspensions) {
            if (!suspension.contains(this.m_timer.getCurrentTime())) continue;
            return suspension.m_end - this.m_timer.getCurrentTime() > 0L;
        }
        return false;
    }

    class Suspension {
        private long m_start;
        private long m_end;

        Suspension(long start, long end) {
            this.m_start = start;
            this.m_end = end;
        }

        public boolean contains(long time) {
            return this.m_start <= time && time <= this.m_end;
        }
    }
}

