/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.opennms.core.test.MockLogAppender;
import org.opennms.netmgt.collectd.CollectableService;
import org.opennms.netmgt.collectd.Collectd;
import org.opennms.netmgt.collectd.CollectionSpecification;
import org.opennms.netmgt.collection.api.AttributeType;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionException;
import org.opennms.netmgt.collection.api.CollectionInitializationException;
import org.opennms.netmgt.collection.api.CollectionSet;
import org.opennms.netmgt.collection.api.PersisterFactory;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.collection.persistence.rrd.RrdPersisterFactory;
import org.opennms.netmgt.collection.support.builder.CollectionSetBuilder;
import org.opennms.netmgt.collection.support.builder.NodeLevelResource;
import org.opennms.netmgt.collection.support.builder.Resource;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.api.ResourceStorageDao;
import org.opennms.netmgt.dao.mock.MockEventIpcManager;
import org.opennms.netmgt.events.api.EventIpcManager;
import org.opennms.netmgt.events.api.EventIpcManagerFactory;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.rrd.RrdRepository;
import org.opennms.netmgt.rrd.RrdStrategy;
import org.opennms.netmgt.rrd.jrobin.JRobinRrdStrategy;
import org.opennms.netmgt.scheduler.ReadyRunnable;
import org.opennms.netmgt.scheduler.Scheduler;
import org.opennms.netmgt.snmp.InetAddrUtils;
import org.opennms.test.FileAnticipator;
import org.springframework.transaction.PlatformTransactionManager;

public class CollectableServiceTest {
    private CollectionSpecification spec;
    private Scheduler scheduler;
    private CollectableService service;
    private File snmpDirectory;
    private FileAnticipator fileAnticipator;
    private RrdStrategy<?, ?> rrdStrategy;

    @Before
    public void setUp() throws Exception {
        MockLogAppender.setupLogging();
        this.rrdStrategy = new JRobinRrdStrategy();
        this.fileAnticipator = new FileAnticipator();
        MockEventIpcManager mockEventIpcManager = new MockEventIpcManager();
        EventIpcManagerFactory.setIpcManager((EventIpcManager)mockEventIpcManager);
    }

    @After
    public void tearDown() {
        System.clearProperty("org.opennms.netmgt.collectd.strictInterval");
        System.clearProperty("org.opennms.netmgt.collectd.useCollectionStartTime");
        MockLogAppender.assertNoErrorOrGreater();
        this.fileAnticipator.deleteExpected();
        this.fileAnticipator.tearDown();
    }

    @Test
    public void collectUsingSpecifiedInterval() throws CollectionInitializationException, CollectionException, IOException {
        this.createCollectableService();
        Long serviceIntervalInMs = 300000L;
        final Long collectionDelayInMs = 1000L;
        Mockito.when((Object)this.spec.getInterval()).thenReturn((Object)serviceIntervalInMs);
        Mockito.when((Object)this.spec.collect((CollectionAgent)Matchers.any())).then((Answer)new Answer<CollectionSet>(){

            public CollectionSet answer(InvocationOnMock invocation) throws InterruptedException {
                Thread.sleep(collectionDelayInMs);
                return null;
            }
        });
        ArgumentCaptor intervalCaptor = ArgumentCaptor.forClass(Long.class);
        this.service.run();
        ((Scheduler)Mockito.verify((Object)this.scheduler, (VerificationMode)Mockito.times((int)1))).schedule(((Long)intervalCaptor.capture()).longValue(), (ReadyRunnable)Matchers.any());
        Assert.assertEquals((Object)serviceIntervalInMs, (Object)intervalCaptor.getValue());
    }

    @Test
    public void collectUsingStrictInterval() throws CollectionInitializationException, CollectionException, IOException {
        System.setProperty("org.opennms.netmgt.collectd.strictInterval", Boolean.TRUE.toString());
        this.createCollectableService();
        final Long serviceIntervalInMs = 2000L;
        final Long collectionDelayInMs = 500L;
        Mockito.when((Object)this.spec.getInterval()).thenReturn((Object)serviceIntervalInMs);
        Mockito.when((Object)this.spec.collect((CollectionAgent)Matchers.any())).then((Answer)new Answer<CollectionSet>(){

            public CollectionSet answer(InvocationOnMock invocation) throws InterruptedException {
                Thread.sleep(collectionDelayInMs);
                return null;
            }
        });
        ArgumentCaptor intervalCaptor = ArgumentCaptor.forClass(Long.class);
        this.service.run();
        ((Scheduler)Mockito.verify((Object)this.scheduler, (VerificationMode)Mockito.times((int)1))).schedule(((Long)intervalCaptor.capture()).longValue(), (ReadyRunnable)Matchers.any());
        Long upperBound = serviceIntervalInMs - collectionDelayInMs;
        Assert.assertTrue((String)String.format("Expected the interval to be less than %d, but was %d", upperBound, intervalCaptor.getValue()), ((Long)intervalCaptor.getValue() <= upperBound ? 1 : 0) != 0);
        Mockito.when((Object)this.spec.collect((CollectionAgent)Matchers.any())).then((Answer)new Answer<CollectionSet>(){

            public CollectionSet answer(InvocationOnMock invocation) throws InterruptedException {
                Thread.sleep(2L * serviceIntervalInMs);
                return null;
            }
        });
        this.service.run();
        ((Scheduler)Mockito.verify((Object)this.scheduler, (VerificationMode)Mockito.times((int)2))).schedule(((Long)intervalCaptor.capture()).longValue(), (ReadyRunnable)Matchers.any());
        Assert.assertEquals((Object)0L, (Object)intervalCaptor.getValue());
    }

    @Test
    public void canWrapResourcesWithTimekeeper() throws CollectionInitializationException, CollectionException, IOException, RrdException {
        System.setProperty("org.opennms.netmgt.collectd.useCollectionStartTime", Boolean.TRUE.toString());
        this.createCollectableService();
        final long collectionDelayInSecs = 2L;
        Mockito.when((Object)this.spec.collect((CollectionAgent)Matchers.any())).then((Answer)new Answer<CollectionSet>(){

            public CollectionSet answer(InvocationOnMock invocation) throws InterruptedException {
                Thread.sleep(collectionDelayInSecs * 1000L);
                CollectionAgent agent = (CollectionAgent)invocation.getArguments()[0];
                NodeLevelResource nodeResource = new NodeLevelResource(agent.getNodeId());
                return new CollectionSetBuilder(agent).withNumericAttribute((Resource)nodeResource, "mibGroup", "myCounter", (Number)1000, AttributeType.COUNTER).build();
            }
        });
        File nodeDir = this.fileAnticipator.expecting(this.getSnmpRrdDirectory(), "1");
        File jrbFile = this.fileAnticipator.expecting(nodeDir, "myCounter" + this.rrdStrategy.getDefaultFileExtension());
        this.fileAnticipator.expecting(nodeDir, "myCounter.meta");
        long beforeInMs = System.currentTimeMillis();
        this.service.run();
        long afterInMs = System.currentTimeMillis();
        Assert.assertTrue((String)String.format("Delay was not succesfully applied (delay was %d).", beforeInMs - afterInMs), (afterInMs - beforeInMs >= collectionDelayInSecs * 1000L ? 1 : 0) != 0);
        RrdDb rrdDb = new RrdDb(jrbFile);
        long lastUpdateTimeInSecs = rrdDb.getLastUpdateTime();
        long beforeInSecs = Math.floorDiv(beforeInMs, 1000L);
        long afterInSecs = Math.floorDiv(afterInMs, 1000L) + 1L;
        Assert.assertTrue((String)"Last update was before the collector was invoked!", (lastUpdateTimeInSecs >= beforeInSecs ? 1 : 0) != 0);
        Assert.assertTrue((String)"Last update was too long after the collector was invoked!", ((double)lastUpdateTimeInSecs < (double)afterInSecs - (double)collectionDelayInSecs / 2.0 ? 1 : 0) != 0);
    }

    private void createCollectableService() throws CollectionInitializationException, IOException {
        OnmsIpInterface iface = (OnmsIpInterface)Mockito.mock(OnmsIpInterface.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        IpInterfaceDao ifaceDao = (IpInterfaceDao)Mockito.mock(IpInterfaceDao.class);
        this.spec = (CollectionSpecification)Mockito.mock(CollectionSpecification.class);
        this.scheduler = (Scheduler)Mockito.mock(Scheduler.class);
        Collectd.SchedulingCompletedFlag schedulingCompletedFlag = (Collectd.SchedulingCompletedFlag)Mockito.mock(Collectd.SchedulingCompletedFlag.class);
        PlatformTransactionManager transMgr = (PlatformTransactionManager)Mockito.mock(PlatformTransactionManager.class);
        RrdPersisterFactory persisterFactory = new RrdPersisterFactory();
        persisterFactory.setRrdStrategy(this.rrdStrategy);
        ResourceStorageDao resourceStorageDao = (ResourceStorageDao)Mockito.mock(ResourceStorageDao.class);
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        paramsMap.put("thresholding-enabled", Boolean.FALSE.toString());
        ServiceParameters params = new ServiceParameters(paramsMap);
        Mockito.when((Object)iface.getNode().getId()).thenReturn((Object)1);
        Mockito.when((Object)this.spec.getServiceParameters()).thenReturn((Object)params);
        Mockito.when((Object)this.spec.getRrdRepository((String)Matchers.any())).thenReturn((Object)this.createRrdRepository());
        Mockito.when((Object)ifaceDao.load((Serializable)Matchers.any())).thenReturn((Object)iface);
        Mockito.when((Object)iface.getIpAddress()).thenReturn((Object)InetAddrUtils.getLocalHostAddress());
        this.service = new CollectableService(iface, ifaceDao, this.spec, this.scheduler, schedulingCompletedFlag, transMgr, (PersisterFactory)persisterFactory, resourceStorageDao);
    }

    private RrdRepository createRrdRepository() throws IOException {
        RrdRepository repository = new RrdRepository();
        repository.setRrdBaseDir(this.getSnmpRrdDirectory());
        repository.setHeartBeat(600);
        repository.setStep(300);
        repository.setRraList(Collections.singletonList("RRA:AVERAGE:0.5:1:100"));
        return repository;
    }

    private File getSnmpRrdDirectory() throws IOException {
        if (this.snmpDirectory == null) {
            this.snmpDirectory = this.fileAnticipator.tempDir("snmp");
        }
        return this.snmpDirectory;
    }
}

