/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.statsd;

import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.opennms.netmgt.collection.api.TimeKeeper;
import org.opennms.netmgt.statsd.RelativeTime;

@RunWith(value=Parameterized.class)
public class RelativeTimeTest {
    private TimeZone m_timeZone;
    private int m_offset;
    private int m_startYear;
    private int m_startMonth;
    private int m_startDay;
    private int m_endYear;
    private int m_endMonth;
    private int m_endDay;

    public RelativeTimeTest(String timeZone, int offset, int startYear, int startMonth, int startDay, int endYear, int endMonth, int endDay) {
        this.m_timeZone = TimeZone.getTimeZone(timeZone);
        this.m_offset = offset * 60 * 60 * 1000;
        this.m_startYear = startYear;
        this.m_startMonth = startMonth;
        this.m_startDay = startDay;
        this.m_endYear = endYear;
        this.m_endMonth = endMonth;
        this.m_endDay = endDay;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() throws ParseException {
        return Arrays.asList({"America/Chicago", -6, 2006, 3, 3, 2006, 9, 30}, {"America/New_York", -5, 2006, 3, 3, 2006, 9, 30}, {"Europe/Berlin", 1, 2006, 2, 27, 2006, 9, 30}, {"Europe/Rome", 1, 2006, 2, 27, 2006, 9, 30}, {"Antarctica/South_Pole", 12, 2006, 9, 2, 2006, 2, 20}, {"Pacific/Auckland", 12, 2006, 9, 2, 2006, 2, 20});
    }

    @Test
    public void testYesterdayBeginningDST() {
        RelativeTime yesterday = RelativeTime.YESTERDAY;
        yesterday.setTimeKeeper(new TimeKeeper(){

            public Date getCurrentDate() {
                GregorianCalendar cal = new GregorianCalendar(RelativeTimeTest.this.m_timeZone, Locale.ENGLISH);
                cal.set(RelativeTimeTest.this.m_startYear, RelativeTimeTest.this.m_startMonth, RelativeTimeTest.this.m_startDay, 10, 0, 0);
                return cal.getTime();
            }

            public long getCurrentTime() {
                return this.getCurrentDate().getTime();
            }

            public TimeZone getTimeZone() {
                return RelativeTimeTest.this.m_timeZone;
            }
        });
        Date start = yesterday.getStart();
        Date end = yesterday.getEnd();
        System.err.println("start = " + start);
        System.err.println("end = " + end);
        GregorianCalendar c = new GregorianCalendar(this.m_timeZone, Locale.ENGLISH);
        c.setTime(start);
        Assert.assertEquals((long)this.m_offset, (long)c.get(15));
        Assert.assertEquals((long)this.m_startYear, (long)c.get(1));
        Assert.assertEquals((long)0L, (long)c.get(11));
        Assert.assertEquals((long)1L, (long)c.get(7));
        Assert.assertEquals((long)(this.m_startDay - 1), (long)c.get(5));
        c.setTime(end);
        Assert.assertEquals((long)this.m_offset, (long)c.get(15));
        Assert.assertEquals((long)this.m_startYear, (long)c.get(1));
        Assert.assertEquals((long)0L, (long)c.get(11));
        Assert.assertEquals((long)2L, (long)c.get(7));
        Assert.assertEquals((long)this.m_startDay, (long)c.get(5));
        Assert.assertEquals((String)"end date - start date", (long)82800000L, (long)(end.getTime() - start.getTime()));
    }

    @Test
    public void testYesterdayEndingDST() {
        RelativeTime yesterday = RelativeTime.YESTERDAY;
        yesterday.setTimeKeeper(new TimeKeeper(){

            public Date getCurrentDate() {
                GregorianCalendar cal = new GregorianCalendar(RelativeTimeTest.this.m_timeZone, Locale.ENGLISH);
                cal.set(RelativeTimeTest.this.m_endYear, RelativeTimeTest.this.m_endMonth, RelativeTimeTest.this.m_endDay, 10, 0, 0);
                return cal.getTime();
            }

            public long getCurrentTime() {
                return this.getCurrentDate().getTime();
            }

            public TimeZone getTimeZone() {
                return RelativeTimeTest.this.m_timeZone;
            }
        });
        Date start = yesterday.getStart();
        Date end = yesterday.getEnd();
        GregorianCalendar c = new GregorianCalendar(this.m_timeZone, Locale.ENGLISH);
        c.setTime(start);
        Assert.assertEquals((long)this.m_offset, (long)c.get(15));
        Assert.assertEquals((long)this.m_endYear, (long)c.get(1));
        Assert.assertEquals((long)0L, (long)c.get(11));
        Assert.assertEquals((long)1L, (long)c.get(7));
        Assert.assertEquals((long)(this.m_endDay - 1), (long)c.get(5));
        c.setTime(end);
        Assert.assertEquals((long)this.m_offset, (long)c.get(15));
        Assert.assertEquals((long)this.m_endYear, (long)c.get(1));
        Assert.assertEquals((long)0L, (long)c.get(11));
        Assert.assertEquals((long)2L, (long)c.get(7));
        Assert.assertEquals((long)this.m_endDay, (long)c.get(5));
        Assert.assertEquals((String)"end date - start date", (long)90000000L, (long)(end.getTime() - start.getTime()));
    }
}

