/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmpinterfacepoller;

import org.apache.commons.lang.StringUtils;
import org.opennms.core.network.IPAddress;
import org.opennms.core.network.IPAddressRange;
import org.opennms.netmgt.config.SnmpEventInfo;
import org.opennms.netmgt.config.SnmpInterfacePollerConfig;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.events.api.annotations.EventHandler;
import org.opennms.netmgt.events.api.annotations.EventListener;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.scheduler.LegacyScheduler;
import org.opennms.netmgt.scheduler.Scheduler;
import org.opennms.netmgt.snmpinterfacepoller.pollable.PollableInterface;
import org.opennms.netmgt.snmpinterfacepoller.pollable.PollableNetwork;
import org.opennms.netmgt.snmpinterfacepoller.pollable.PollableSnmpInterface;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventListener(name="snmpPoller", logPrefix="snmp-poller")
public class SnmpPoller
extends AbstractServiceDaemon {
    private static final Logger LOG = LoggerFactory.getLogger(SnmpPoller.class);
    private static final SnmpPoller m_singleton = new SnmpPoller();
    private boolean m_initialized = false;
    private LegacyScheduler m_scheduler = null;
    private SnmpInterfacePollerConfig m_pollerConfig;
    private PollableNetwork m_network;

    public PollableNetwork getNetwork() {
        return this.m_network;
    }

    public void setNetwork(PollableNetwork pollableNetwork) {
        this.m_network = pollableNetwork;
    }

    public boolean isInitialized() {
        return this.m_initialized;
    }

    public Scheduler getScheduler() {
        return this.m_scheduler;
    }

    public void setScheduler(LegacyScheduler scheduler) {
        this.m_scheduler = scheduler;
    }

    public SnmpInterfacePollerConfig getPollerConfig() {
        return this.m_pollerConfig;
    }

    public void setPollerConfig(SnmpInterfacePollerConfig snmpinterfacepollerConfig) {
        this.m_pollerConfig = snmpinterfacepollerConfig;
    }

    protected void onStart() {
        try {
            LOG.debug("onStart: Starting SNMP Interface Poller scheduler");
            this.getScheduler().start();
        }
        catch (RuntimeException e) {
            LOG.error("onStart: Failed to start scheduler", (Throwable)e);
            throw e;
        }
    }

    protected void onStop() {
        if (this.getScheduler() != null) {
            LOG.debug("onStop: stopping scheduler");
            this.getScheduler().stop();
        }
        this.setScheduler(null);
    }

    protected void onPause() {
        this.getScheduler().pause();
    }

    protected void onResume() {
        this.getScheduler().resume();
    }

    public static SnmpPoller getInstance() {
        return m_singleton;
    }

    public SnmpPoller() {
        super("snmp-poller");
    }

    protected void onInit() {
        this.createScheduler();
        try {
            LOG.debug("onInit: Scheduling existing SNMP interfaces polling");
            this.scheduleExistingSnmpInterface();
        }
        catch (Throwable sqlE) {
            LOG.error("onInit: Failed to schedule existing interfaces", sqlE);
        }
        this.m_initialized = true;
    }

    protected void scheduleNewSnmpInterface(String ipaddr) {
        for (OnmsIpInterface iface : this.getNetwork().getContext().getPollableNodesByIp(ipaddr)) {
            this.schedulePollableInterface(iface);
        }
    }

    protected void scheduleExistingSnmpInterface() {
        for (OnmsIpInterface iface : this.getNetwork().getContext().getPollableNodes()) {
            this.schedulePollableInterface(iface);
        }
    }

    protected void schedulePollableInterface(OnmsIpInterface iface) {
        String ipaddress = iface.getIpAddress().getHostAddress();
        String netmask = null;
        if (iface.getNetMask() != null) {
            netmask = iface.getNetMask().getHostAddress();
        }
        Integer nodeid = iface.getNode().getId();
        if (ipaddress != null && !ipaddress.equals("0.0.0.0")) {
            String pkgName = this.getPollerConfig().getPackageName(ipaddress);
            if (pkgName != null) {
                LOG.debug("Scheduling snmppolling for node: {} ip address: {} - Found package interface with name: {}", new Object[]{nodeid, ipaddress, pkgName});
                this.scheduleSnmpCollection(this.getNetwork().create(nodeid, ipaddress, netmask, pkgName), pkgName);
            } else if (!this.getPollerConfig().useCriteriaFilters()) {
                LOG.debug("No SNMP Poll Package found for node: {} ip address: {}. - Scheduling according with default interval", (Object)nodeid, (Object)ipaddress);
                this.scheduleSnmpCollection(this.getNetwork().create(nodeid, ipaddress, netmask, "null"), "null");
            }
        }
    }

    private void scheduleSnmpCollection(PollableInterface nodeGroup, String pkgName) {
        String excludingCriteria = new String(" snmpifindex > 0 ");
        for (String pkgInterfaceName : this.getPollerConfig().getInterfaceOnPackage(pkgName)) {
            LOG.debug("found package interface with name: {}", (Object)pkgInterfaceName);
            if (this.getPollerConfig().getStatus(pkgName, pkgInterfaceName)) {
                String criteria = this.getPollerConfig().getCriteria(pkgName, pkgInterfaceName).orElse(null);
                if (this.getPollerConfig().getCriteria(pkgName, pkgInterfaceName).isPresent()) {
                    LOG.debug("package interface: criteria: {}", (Object)criteria);
                    excludingCriteria = excludingCriteria + " and not " + criteria;
                }
                long interval = this.getPollerConfig().getInterval(pkgName, pkgInterfaceName);
                LOG.debug("package interface: interval: {}", (Object)interval);
                int port = this.getPollerConfig().getPort(pkgName, pkgInterfaceName).orElse(-1);
                int timeout = this.getPollerConfig().getTimeout(pkgName, pkgInterfaceName).orElse(-1);
                int retries = this.getPollerConfig().getRetries(pkgName, pkgInterfaceName).orElse(-1);
                boolean hasMaxVarsPerPdu = this.getPollerConfig().hasMaxVarsPerPdu(pkgName, pkgInterfaceName);
                int maxVarsPerPdu = -1;
                if (hasMaxVarsPerPdu) {
                    maxVarsPerPdu = this.getPollerConfig().getMaxVarsPerPdu(pkgName, pkgInterfaceName);
                }
                PollableSnmpInterface node = nodeGroup.createPollableSnmpInterface(pkgInterfaceName, criteria, port != -1, port, timeout != -1, timeout, retries != -1, retries, hasMaxVarsPerPdu, maxVarsPerPdu);
                node.setSnmpinterfaces(this.getNetwork().getContext().get(node.getParent().getNodeid(), criteria));
                this.getNetwork().schedule(node, interval, this.getScheduler());
                continue;
            }
            LOG.debug("package interface status: Off");
        }
        if (!this.getPollerConfig().useCriteriaFilters()) {
            LOG.debug("excluding criteria used for default polling: {}", (Object)excludingCriteria);
            PollableSnmpInterface node = nodeGroup.createPollableSnmpInterface("null", excludingCriteria, false, -1, false, -1, false, -1, false, -1);
            node.setSnmpinterfaces(this.getNetwork().getContext().get(node.getParent().getNodeid(), excludingCriteria));
            this.getNetwork().schedule(node, this.getPollerConfig().getInterval(), this.getScheduler());
        }
    }

    private void createScheduler() {
        try {
            LOG.debug("init: Creating SNMP Interface Poller scheduler");
            this.setScheduler(new LegacyScheduler("Snmpinterfacepoller", this.getPollerConfig().getThreads()));
        }
        catch (RuntimeException e) {
            LOG.error("init: Failed to create SNMP interface poller scheduler", (Throwable)e);
            throw e;
        }
    }

    @EventHandler(uei="uei.opennms.org/internal/configureSNMP")
    public void reloadSnmpConfig(Event event) {
        LOG.debug("reloadSnmpConfig: managing event: {}", (Object)event.getUei());
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            LOG.debug("interrupted while waiting for reload", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        SnmpEventInfo info = null;
        try {
            info = new SnmpEventInfo(event);
            if (StringUtils.isBlank((String)info.getFirstIPAddress())) {
                LOG.error("configureSNMPHandler: event contained invalid firstIpAddress. {}", (Object)event);
                return;
            }
        }
        catch (Throwable e) {
            LOG.error("reloadSnmpConfig: ", e);
            return;
        }
        IPAddressRange range = new IPAddressRange(info.getFirstIPAddress(), info.getLastIPAddress());
        for (IPAddress ipaddr : range) {
            LOG.debug("reloadSnmpConfig: found ipaddr: {}", (Object)ipaddr);
            if (this.getNetwork().hasPollableInterface(ipaddr.toDbString())) {
                LOG.debug("reloadSnmpConfig: recreating the Interface to poll: {}", (Object)ipaddr);
                this.getNetwork().delete(ipaddr.toDbString());
                this.scheduleNewSnmpInterface(ipaddr.toDbString());
                continue;
            }
            LOG.debug("reloadSnmpConfig: no Interface found for ipaddr: {}", (Object)ipaddr);
        }
    }

    @EventHandler(uei="uei.opennms.org/internal/reloadSnmpPollerConfig")
    public void reloadConfig(Event event) {
        LOG.debug("reloadConfig: managing event: {}", (Object)event.getUei());
        try {
            this.getPollerConfig().update();
            this.getNetwork().deleteAll();
            this.scheduleExistingSnmpInterface();
        }
        catch (Throwable e) {
            LOG.error("Update SnmpPoller configuration file failed", e);
        }
    }

    @EventHandler(uei="uei.opennms.org/nodes/primarySnmpInterfaceChanged")
    public void primarychangeHandler(Event event) {
        LOG.debug("primarychangeHandler: managing event: {}", (Object)event.getUei());
        this.getNetwork().delete(Long.valueOf(event.getNodeid()).intValue());
        for (Parm parm : event.getParmCollection()) {
            if (!parm.isValid() || !parm.getParmName().equals("newPrimarySnmpAddress")) continue;
            this.scheduleNewSnmpInterface(parm.getValue().getContent());
            return;
        }
    }

    @EventHandler(uei="uei.opennms.org/internal/capsd/deleteInterface")
    public void deleteInterfaceHaldler(Event event) {
        this.getNetwork().delete(event.getInterface());
    }

    @EventHandler(uei="uei.opennms.org/internal/provisiond/nodeScanCompleted")
    public void scanCompletedHaldler(Event event) {
        this.getNetwork().refresh(Long.valueOf(event.getNodeid()).intValue());
    }

    @EventHandler(uei="uei.opennms.org/internal/capsd/rescanCompleted")
    public void rescanCompletedHaldler(Event event) {
        this.getNetwork().refresh(Long.valueOf(event.getNodeid()).intValue());
    }

    @EventHandler(uei="uei.opennms.org/nodes/nodeDeleted")
    public void nodeDeletedHandler(Event event) {
        this.getNetwork().delete(Long.valueOf(event.getNodeid()).intValue());
    }

    @EventHandler(uei="uei.opennms.org/nodes/nodeGainedService")
    public void serviceGainedHandler(Event event) {
        if (event.getService().equals(this.getPollerConfig().getService())) {
            this.getPollerConfig().rebuildPackageIpListMap();
            this.scheduleNewSnmpInterface(event.getInterface());
        }
    }

    @EventHandler(uei="uei.opennms.org/nodes/nodeLostService")
    public void serviceDownHandler(Event event) {
        String service = event.getService();
        String[] criticalServices = this.getPollerConfig().getCriticalServiceIds();
        for (int i = 0; i < criticalServices.length; ++i) {
            if (!criticalServices[i].equals(service)) continue;
            LOG.info("Critical Service Lost: suspending SNMP polling for primary interface: {}", (Object)event.getInterface());
            this.getNetwork().suspend(event.getInterface());
        }
    }

    @EventHandler(uei="uei.opennms.org/nodes/nodeRegainedService")
    public void serviceUpHandler(Event event) {
        String service = event.getService();
        String[] criticalServices = this.getPollerConfig().getCriticalServiceIds();
        for (int i = 0; i < criticalServices.length; ++i) {
            if (!criticalServices[i].equals(service)) continue;
            LOG.info("Critical Service Regained: activate SNMP polling for primary interface: {}", (Object)event.getInterface());
            this.getNetwork().activate(event.getInterface());
        }
    }

    @EventHandler(uei="uei.opennms.org/nodes/interfaceUp")
    public void interfaceUpHandler(Event event) {
        this.getNetwork().activate(event.getInterface());
    }

    @EventHandler(uei="uei.opennms.org/nodes/interfaceDown")
    public void interfaceDownHandler(Event event) {
        this.getNetwork().suspend(event.getInterface());
    }

    @EventHandler(uei="uei.opennms.org/nodes/nodeUp")
    public void nodeUpHandler(Event event) {
        this.getNetwork().activate(Long.valueOf(event.getNodeid()).intValue());
    }

    @EventHandler(uei="uei.opennms.org/nodes/nodeDown")
    public void nodeDownHandler(Event event) {
        this.getNetwork().suspend(Long.valueOf(event.getNodeid()).intValue());
    }
}

