/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.sql.DataSource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.core.db.DataSourceFactory;
import org.opennms.core.test.Level;
import org.opennms.core.test.LoggingEvent;
import org.opennms.core.test.MockLogAppender;
import org.opennms.core.test.db.MockDatabase;
import org.opennms.netmgt.config.PollOutagesConfigFactory;
import org.opennms.netmgt.mock.MockNetwork;
import org.opennms.netmgt.rrd.RrdRepository;
import org.opennms.netmgt.threshd.ThresholdInitializationException;
import org.opennms.netmgt.threshd.ThresholdingSet;

public class ThresholdingSetTest {
    @Before
    public void setUp() throws Exception {
        MockLogAppender.setupLogging();
        MockDatabase m_db = new MockDatabase();
        MockNetwork network = new MockNetwork();
        network.addNode(1, "localhost").addInterface("127.0.0.1").addService("SNMP", 1);
        m_db.populate(network);
        DataSourceFactory.setInstance((DataSource)m_db);
    }

    @Test(expected=ThresholdInitializationException.class)
    public void testBadThresholdingConfigInitialize() throws Exception {
        System.setProperty("opennms.home", this.getClass().getResource("testBadThresholdingConfig").getFile());
        PollOutagesConfigFactory.init();
        new ThresholdingSet(1, "127.0.0.1", "SNMP", new RrdRepository());
    }

    @Test
    public void testBadThresholdingConfigReinitialize() throws Exception {
        String opennmsHome = this.getClass().getResource("testBadThresholdingConfigReinitialize").getFile();
        Path goodXml = Paths.get(opennmsHome, "etc", "good-thresholds.xml");
        Path badXml = Paths.get(opennmsHome, "etc", "bad-thresholds.xml");
        Path targetXml = Paths.get(opennmsHome, "etc", "thresholds.xml");
        if (targetXml.toFile().exists()) {
            Files.delete(targetXml);
        }
        Files.copy(goodXml, targetXml, new CopyOption[0]);
        System.setProperty("opennms.home", opennmsHome);
        PollOutagesConfigFactory.init();
        ThresholdingSet set = new ThresholdingSet(1, "127.0.0.1", "SNMP", new RrdRepository());
        LoggingEvent[] events = MockLogAppender.getEventsGreaterOrEqual((Level)Level.WARN);
        Assert.assertEquals((String)"There should be no warnings or higher after initializing with a good config.", (long)0L, (long)events.length);
        Assert.assertFalse((boolean)set.isNodeInOutage());
        Assert.assertTrue((boolean)set.hasThresholds());
        Files.delete(targetXml);
        Files.copy(badXml, targetXml, new CopyOption[0]);
        set.reinitialize(true);
        Assert.assertFalse((boolean)set.isNodeInOutage());
        Assert.assertTrue((boolean)set.hasThresholds());
        events = MockLogAppender.getEventsGreaterOrEqual((Level)Level.WARN);
        Assert.assertEquals((String)"There should be one error after reinitializing with a bad config.", (long)1L, (long)events.length);
        Assert.assertEquals((String)"It should have an error-level log message.", (Object)Level.ERROR, (Object)events[0].getLevel());
        Assert.assertTrue((String)"It should say it is reverting to previous configuration.", (boolean)events[0].getMessage().contains("Reverting to previous"));
    }
}

