/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.model.BridgeBridgeLink;
import org.opennms.netmgt.model.BridgeElement;
import org.opennms.netmgt.model.BridgeMacLink;
import org.opennms.netmgt.model.CdpElement;
import org.opennms.netmgt.model.CdpLink;
import org.opennms.netmgt.model.LldpElement;
import org.opennms.netmgt.model.LldpLink;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OspfElement;
import org.opennms.netmgt.model.OspfLink;
import org.opennms.netmgt.model.monitoringLocations.OnmsMonitoringLocation;
import org.opennms.netmgt.model.topology.Bridge;
import org.opennms.netmgt.model.topology.BridgeForwardingTableEntry;
import org.opennms.netmgt.model.topology.BridgePortWithMacs;
import org.opennms.netmgt.model.topology.BridgeTopologyException;
import org.opennms.netmgt.model.topology.BroadcastDomain;
import org.opennms.netmgt.model.topology.SharedSegment;

public abstract class EnLinkdTestHelper {
    protected static void printLldpTopology(List<LldpLink> lldplinks) {
        for (LldpLink link : lldplinks) {
            EnLinkdTestHelper.printLldpLink(link);
        }
    }

    protected static void printLldpElements(List<LldpElement> lldpelements) {
        for (LldpElement element : lldpelements) {
            EnLinkdTestHelper.printLldpElement(element);
        }
    }

    protected static void printCdpElement(CdpElement cdpElement) {
        System.err.println(cdpElement.printTopology());
    }

    protected static void printCdpLink(CdpLink link) {
        System.err.println(link.printTopology());
    }

    protected static void printLldpElement(LldpElement lldpElement) {
        System.err.println(lldpElement.printTopology());
    }

    protected static void printLldpLink(LldpLink link) {
        System.err.println(link.printTopology());
    }

    protected static void printOspfTopology(List<OspfLink> ospflinks) {
        for (OspfLink link : ospflinks) {
            EnLinkdTestHelper.printOspfLink(link);
        }
    }

    protected static void printOspfElements(List<OspfElement> ospfelements) {
        for (OspfElement element : ospfelements) {
            EnLinkdTestHelper.printOspfElement(element);
        }
    }

    protected static void printOspfElement(OspfElement element) {
        System.err.println(element.printTopology());
    }

    protected static void printOspfLink(OspfLink link) {
        System.err.println(link.printTopology());
    }

    public void setBridgeElements(BroadcastDomain domain, List<BridgeElement> elements) {
        for (BridgeElement element : elements) {
            Bridge bridge = domain.getBridge(element.getNode().getId().intValue());
            if (bridge == null) continue;
            if (InetAddressUtils.isValidBridgeAddress((String)element.getBaseBridgeAddress())) {
                bridge.getIdentifiers().add(element.getBaseBridgeAddress());
            }
            if (!InetAddressUtils.isValidStpBridgeId((String)element.getStpDesignatedRoot()) || element.getBaseBridgeAddress().equals(InetAddressUtils.getBridgeAddressFromStpBridgeId((String)element.getStpDesignatedRoot()))) continue;
            bridge.setDesignated(InetAddressUtils.getBridgeAddressFromStpBridgeId((String)element.getStpDesignatedRoot()));
        }
    }

    public BridgeForwardingTableEntry addBridgeForwardingTableEntry(OnmsNode node, Integer bridgeport, String mac, Integer vlan) {
        BridgeForwardingTableEntry link = new BridgeForwardingTableEntry();
        link.setNodeId(node.getId());
        link.setBridgePort(bridgeport);
        link.setMacAddress(mac);
        link.setVlan(vlan);
        link.setBridgeDot1qTpFdbStatus(BridgeForwardingTableEntry.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED);
        return link;
    }

    public BridgeForwardingTableEntry addBridgeForwardingTableEntry(OnmsNode node, Integer bridgeport, String mac) {
        BridgeForwardingTableEntry link = new BridgeForwardingTableEntry();
        link.setNodeId(node.getId());
        link.setBridgePort(bridgeport);
        link.setMacAddress(mac);
        link.setBridgeDot1qTpFdbStatus(BridgeForwardingTableEntry.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED);
        return link;
    }

    public BridgeForwardingTableEntry addBridgeForwardingTableEntry(OnmsNode node, Integer bridgeport, Integer ifindex, String mac, Integer vlan) {
        BridgeForwardingTableEntry link = new BridgeForwardingTableEntry();
        link.setNodeId(node.getId());
        link.setBridgePort(bridgeport);
        link.setBridgePortIfIndex(ifindex);
        link.setMacAddress(mac);
        link.setVlan(vlan);
        link.setBridgeDot1qTpFdbStatus(BridgeForwardingTableEntry.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED);
        return link;
    }

    public BridgeForwardingTableEntry addBridgeForwardingTableEntry(OnmsNode node, Integer bridgeport, Integer ifindex, String mac) {
        BridgeForwardingTableEntry link = new BridgeForwardingTableEntry();
        link.setNodeId(node.getId());
        link.setBridgePort(bridgeport);
        link.setBridgePortIfIndex(ifindex);
        link.setMacAddress(mac);
        link.setBridgeDot1qTpFdbStatus(BridgeForwardingTableEntry.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED);
        return link;
    }

    @SafeVarargs
    public static <T> boolean checkLinks(Iterable<T> iterable, Predicate<T> ... matchers) {
        for (Predicate<T> matcher : matchers) {
            if (Iterables.any(iterable, matcher)) continue;
            return false;
        }
        return true;
    }

    public static Predicate<OspfLink> ospfLinkMatcher(OnmsNode node, OnmsNode parentNode, int ifIndex, int parentIfIndex) {
        return link -> node.equals(link.getNode()) && parentNode.getOspfElement().getOspfRouterId().equals(link.getOspfRemRouterId()) && ifIndex == link.getOspfIfIndex() && parentIfIndex == link.getOspfAddressLessIndex();
    }

    class TwoBridgeWithBackbonePortsTopologyWithBridgeinBft {
        Integer nodeAId = 1101;
        Integer nodeBId = 1102;
        Integer portA1 = 1;
        Integer portAB = 12;
        Integer portBA = 21;
        Integer portB2 = 2;
        String macA11 = "000daa000a11";
        String macA12 = "000daa000a12";
        String macAB = "000daa0000ab";
        String macB21 = "000daa000b21";
        String macB22 = "000daa000b22";
        String macB = "bbbbbbbbbbbb";
        OnmsNode nodeA = new OnmsNode();
        BridgeElement elementA = new BridgeElement();
        List<BridgeElement> elemlist = new ArrayList<BridgeElement>();
        Set<BridgeForwardingTableEntry> bftA = new HashSet<BridgeForwardingTableEntry>();
        OnmsNode nodeB = new OnmsNode();
        BridgeElement elementB = new BridgeElement();
        Set<BridgeForwardingTableEntry> bftB = new HashSet<BridgeForwardingTableEntry>();

        public TwoBridgeWithBackbonePortsTopologyWithBridgeinBft() {
            this.nodeA.setId(this.nodeAId);
            this.elementA.setNode(this.nodeA);
            this.elementA.setBaseBridgeAddress("aaaaaaaaaaaa");
            this.elemlist.add(this.elementA);
            this.nodeB.setId(this.nodeBId);
            this.elementB.setNode(this.nodeB);
            this.elementB.setBaseBridgeAddress(this.macB);
            this.elemlist.add(this.elementB);
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA1, this.macA11));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA1, this.macA12));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portAB, this.macB));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portBA, this.macA11));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portBA, this.macA12));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portBA, this.macAB));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portB2, this.macB21));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portB2, this.macB22));
        }

        public void check(BroadcastDomain domain) throws BridgeTopologyException {
            List shsegs = domain.getSharedSegments();
            Assert.assertEquals((long)3L, (long)shsegs.size());
            for (SharedSegment shared : shsegs) {
                boolean pass2;
                boolean pass1;
                List links;
                if (shared.getMacsOnSegment().size() == 0) {
                    Assert.assertEquals((long)1L, (long)SharedSegment.getBridgeBridgeLinks((SharedSegment)shared).size());
                    Assert.assertEquals((long)0L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((long)2L, (long)shared.getBridgeIdsOnSegment().size());
                    links = SharedSegment.getBridgeMacLinks((SharedSegment)shared);
                    Assert.assertEquals((long)0L, (long)links.size());
                    BridgeBridgeLink dlink = (BridgeBridgeLink)SharedSegment.getBridgeBridgeLinks((SharedSegment)shared).iterator().next();
                    Assert.assertEquals((Object)this.nodeBId, (Object)dlink.getDesignatedNode().getId());
                    Assert.assertEquals((Object)this.portBA, (Object)dlink.getDesignatedPort());
                    Assert.assertEquals((Object)this.nodeAId, (Object)dlink.getNode().getId());
                    Assert.assertEquals((Object)this.portAB, (Object)dlink.getBridgePort());
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.macA11)) {
                    Assert.assertEquals((long)0L, (long)SharedSegment.getBridgeBridgeLinks((SharedSegment)shared).size());
                    Assert.assertEquals((long)2L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getMacsOnSegment().contains(this.macA12));
                    Assert.assertEquals((Object)this.nodeAId, (Object)shared.getDesignatedBridge());
                    Assert.assertEquals((Object)this.portA1, (Object)shared.getDesignatedPort().getBridgePort());
                    links = SharedSegment.getBridgeMacLinks((SharedSegment)shared);
                    Assert.assertEquals((long)2L, (long)links.size());
                    for (BridgeMacLink link : links) {
                        Assert.assertEquals((Object)this.nodeAId, (Object)link.getNode().getId());
                        Assert.assertEquals((Object)this.portA1, (Object)link.getBridgePort());
                        pass1 = true;
                        pass2 = true;
                        if (pass1 && link.getMacAddress().equals(this.macA11)) {
                            Assert.assertTrue((boolean)true);
                            pass1 = false;
                            continue;
                        }
                        if (pass2 && link.getMacAddress().equals(this.macA12)) {
                            Assert.assertTrue((boolean)true);
                            pass2 = false;
                            continue;
                        }
                        Assert.assertTrue((boolean)false);
                    }
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.macB21)) {
                    Assert.assertEquals((long)0L, (long)SharedSegment.getBridgeBridgeLinks((SharedSegment)shared).size());
                    Assert.assertEquals((long)2L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getMacsOnSegment().contains(this.macB22));
                    Assert.assertEquals((Object)this.nodeBId, (Object)shared.getDesignatedBridge());
                    Assert.assertEquals((Object)this.portB2, (Object)shared.getDesignatedPort().getBridgePort());
                    links = SharedSegment.getBridgeMacLinks((SharedSegment)shared);
                    Assert.assertEquals((long)2L, (long)links.size());
                    for (BridgeMacLink link : links) {
                        Assert.assertEquals((Object)this.nodeBId, (Object)link.getNode().getId());
                        Assert.assertEquals((Object)this.portB2, (Object)link.getBridgePort());
                        pass1 = true;
                        pass2 = true;
                        if (pass1 && link.getMacAddress().equals(this.macB21)) {
                            Assert.assertTrue((boolean)true);
                            pass1 = false;
                            continue;
                        }
                        if (pass2 && link.getMacAddress().equals(this.macB22)) {
                            Assert.assertTrue((boolean)true);
                            pass2 = false;
                            continue;
                        }
                        Assert.assertTrue((boolean)false);
                    }
                    continue;
                }
                Assert.assertEquals((Object)false, (Object)true);
            }
        }
    }

    class TwoBridgeWithBackbonePortsTopology {
        Integer nodeAId = 1101;
        Integer nodeBId = 1102;
        Integer portA1 = 1;
        Integer portAB = 12;
        Integer portBA = 21;
        Integer portB2 = 2;
        String macA11 = "000daa000a11";
        String macA12 = "000daa000a12";
        String macAB = "000daa0000ab";
        String macB21 = "000daa000b21";
        String macB22 = "000daa000b22";
        OnmsNode nodeA = new OnmsNode();
        BridgeElement elementA = new BridgeElement();
        List<BridgeElement> elemlist = new ArrayList<BridgeElement>();
        Set<BridgeForwardingTableEntry> bftA = new HashSet<BridgeForwardingTableEntry>();
        OnmsNode nodeB = new OnmsNode();
        BridgeElement elementB = new BridgeElement();
        Set<BridgeForwardingTableEntry> bftB = new HashSet<BridgeForwardingTableEntry>();

        public TwoBridgeWithBackbonePortsTopology() {
            this.nodeA.setId(this.nodeAId);
            this.elementA.setNode(this.nodeA);
            this.elementA.setBaseBridgeAddress("aaaaaaaaaaaa");
            this.elemlist.add(this.elementA);
            this.nodeB.setId(this.nodeBId);
            this.elementB.setNode(this.nodeB);
            this.elementB.setBaseBridgeAddress("bbbbbbbbbbbb");
            this.elemlist.add(this.elementB);
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA1, this.macA11));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA1, this.macA12));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portAB, this.macAB));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portAB, this.macB21));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portAB, this.macB22));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portBA, this.macA11));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portBA, this.macA12));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portBA, this.macAB));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portB2, this.macB21));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portB2, this.macB22));
        }

        public void check(BroadcastDomain domain) throws BridgeTopologyException {
            List shsegs = domain.getSharedSegments();
            Assert.assertEquals((long)3L, (long)shsegs.size());
            for (Integer nodeid : domain.getBridgeNodesOnDomain()) {
                Assert.assertEquals((long)0L, (long)domain.getForwarders(nodeid).size());
            }
            for (SharedSegment shared : shsegs) {
                boolean pass2;
                boolean pass1;
                List links;
                Assert.assertEquals((Object)false, (Object)shared.noMacsOnSegment());
                if (shared.getMacsOnSegment().contains(this.macAB)) {
                    Assert.assertEquals((long)1L, (long)SharedSegment.getBridgeBridgeLinks((SharedSegment)shared).size());
                    Assert.assertEquals((long)1L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((long)2L, (long)shared.getBridgeIdsOnSegment().size());
                    links = SharedSegment.getBridgeMacLinks((SharedSegment)shared);
                    Assert.assertEquals((long)1L, (long)links.size());
                    for (BridgeMacLink link : links) {
                        Assert.assertEquals((Object)this.macAB, (Object)link.getMacAddress());
                        Assert.assertEquals((long)this.nodeA.getId().intValue(), (long)link.getNode().getId().intValue());
                        Assert.assertEquals((Object)this.portAB, (Object)link.getBridgePort());
                        Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link.getLinkType());
                    }
                    BridgeBridgeLink dlink = (BridgeBridgeLink)SharedSegment.getBridgeBridgeLinks((SharedSegment)shared).iterator().next();
                    Assert.assertEquals((Object)this.nodeAId, (Object)dlink.getDesignatedNode().getId());
                    Assert.assertEquals((Object)this.portAB, (Object)dlink.getDesignatedPort());
                    Assert.assertEquals((Object)this.nodeBId, (Object)dlink.getNode().getId());
                    Assert.assertEquals((Object)this.portBA, (Object)dlink.getBridgePort());
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.macA11)) {
                    Assert.assertEquals((long)0L, (long)SharedSegment.getBridgeBridgeLinks((SharedSegment)shared).size());
                    Assert.assertEquals((long)2L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getMacsOnSegment().contains(this.macA12));
                    Assert.assertEquals((Object)this.nodeAId, (Object)shared.getDesignatedBridge());
                    Assert.assertEquals((Object)this.portA1, (Object)shared.getDesignatedPort().getBridgePort());
                    links = SharedSegment.getBridgeMacLinks((SharedSegment)shared);
                    Assert.assertEquals((long)2L, (long)links.size());
                    for (BridgeMacLink link : links) {
                        Assert.assertEquals((Object)this.nodeAId, (Object)link.getNode().getId());
                        Assert.assertEquals((Object)this.portA1, (Object)link.getBridgePort());
                        Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link.getLinkType());
                        pass1 = true;
                        pass2 = true;
                        if (pass1 && link.getMacAddress().equals(this.macA11)) {
                            Assert.assertTrue((boolean)true);
                            pass1 = false;
                            continue;
                        }
                        if (pass2 && link.getMacAddress().equals(this.macA12)) {
                            Assert.assertTrue((boolean)true);
                            pass2 = false;
                            continue;
                        }
                        Assert.assertTrue((boolean)false);
                    }
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.macB21)) {
                    Assert.assertEquals((long)0L, (long)SharedSegment.getBridgeBridgeLinks((SharedSegment)shared).size());
                    Assert.assertEquals((long)2L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getMacsOnSegment().contains(this.macB22));
                    Assert.assertEquals((Object)this.nodeBId, (Object)shared.getDesignatedBridge());
                    Assert.assertEquals((Object)this.portB2, (Object)shared.getDesignatedPort().getBridgePort());
                    links = SharedSegment.getBridgeMacLinks((SharedSegment)shared);
                    Assert.assertEquals((long)2L, (long)links.size());
                    for (BridgeMacLink link : links) {
                        Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link.getLinkType());
                        Assert.assertEquals((Object)this.nodeBId, (Object)link.getNode().getId());
                        Assert.assertEquals((Object)this.portB2, (Object)link.getBridgePort());
                        pass1 = true;
                        pass2 = true;
                        if (pass1 && link.getMacAddress().equals(this.macB21)) {
                            Assert.assertTrue((boolean)true);
                            pass1 = false;
                            continue;
                        }
                        if (pass2 && link.getMacAddress().equals(this.macB22)) {
                            Assert.assertTrue((boolean)true);
                            pass2 = false;
                            continue;
                        }
                        Assert.assertTrue((boolean)false);
                    }
                    continue;
                }
                Assert.assertEquals((Object)false, (Object)true);
            }
        }
    }

    class TwoMergeBridgeTopology {
        Integer portA8 = 8;
        Integer portAB = 16;
        Integer portBA = 24;
        Integer portB6 = 6;
        String mac1 = "000daaaa0001";
        String mac2 = "000daaaa0002";
        String mac3 = "000daaaa0003";
        String mac4 = "000daaaa0004";
        String mac5 = "000daaaa0005";
        String mac6 = "000daaaa0006";
        String mac7 = "000daaaa0007";
        String mac8 = "000daaaa0008";
        String mac9 = "000daaaa0009";
        Integer nodeAId = 1111;
        Integer nodeBId = 2222;
        OnmsNode nodeA = new OnmsNode();
        BridgeElement elementA = new BridgeElement();
        Set<BridgeForwardingTableEntry> bftA = new HashSet<BridgeForwardingTableEntry>();
        Set<BridgeForwardingTableEntry> bftB = new HashSet<BridgeForwardingTableEntry>();
        List<BridgeElement> elemlist = new ArrayList<BridgeElement>();
        OnmsNode nodeB = new OnmsNode();
        BridgeElement elementB = new BridgeElement();

        public TwoMergeBridgeTopology() {
            this.nodeA.setId(this.nodeAId);
            this.elementA.setNode(this.nodeA);
            this.elementA.setBaseBridgeAddress("aaaaaaaaaaaa");
            this.elemlist.add(this.elementA);
            this.nodeB.setId(this.nodeBId);
            this.elementB.setNode(this.nodeB);
            this.elementB.setBaseBridgeAddress("bbbbbbbbbbbb");
            this.elemlist.add(this.elementB);
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portAB, this.mac1));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portAB, this.mac2));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portAB, this.mac3));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portAB, this.mac4));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portAB, this.mac5));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portAB, this.mac6));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portAB, this.mac7));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA8, this.mac8));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portAB, this.mac9));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portBA, this.mac1));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portBA, this.mac2));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portBA, this.mac3));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portBA, this.mac4));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portBA, this.mac5));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portB6, this.mac6));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portBA, this.mac7));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portBA, this.mac8));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portBA, this.mac9));
        }

        public void check(BroadcastDomain domain) throws BridgeTopologyException {
            List shsegs = domain.getSharedSegments();
            Assert.assertEquals((long)3L, (long)shsegs.size());
            for (SharedSegment shared : shsegs) {
                BridgeMacLink link;
                Assert.assertEquals((Object)false, (Object)shared.noMacsOnSegment());
                if (shared.getMacsOnSegment().contains(this.mac1)) {
                    Assert.assertEquals((Object)this.nodeAId, (Object)shared.getDesignatedBridge());
                    Assert.assertEquals((Object)this.portAB, (Object)shared.getDesignatedPort().getBridgePort());
                    Assert.assertEquals((long)7L, (long)SharedSegment.getBridgeMacLinks((SharedSegment)shared).size());
                    Assert.assertEquals((long)1L, (long)SharedSegment.getBridgeBridgeLinks((SharedSegment)shared).size());
                    Assert.assertEquals((long)2L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((long)7L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getMacsOnSegment().contains(this.mac2));
                    Assert.assertEquals((Object)true, (Object)shared.getMacsOnSegment().contains(this.mac3));
                    Assert.assertEquals((Object)true, (Object)shared.getMacsOnSegment().contains(this.mac4));
                    Assert.assertEquals((Object)true, (Object)shared.getMacsOnSegment().contains(this.mac5));
                    Assert.assertEquals((Object)false, (Object)shared.getMacsOnSegment().contains(this.mac6));
                    Assert.assertEquals((Object)true, (Object)shared.getMacsOnSegment().contains(this.mac7));
                    Assert.assertEquals((Object)false, (Object)shared.getMacsOnSegment().contains(this.mac8));
                    Assert.assertEquals((Object)true, (Object)shared.getMacsOnSegment().contains(this.mac9));
                    for (BridgeMacLink link2 : SharedSegment.getBridgeMacLinks((SharedSegment)shared)) {
                        Assert.assertTrue((boolean)shared.getMacsOnSegment().contains(link2.getMacAddress()));
                        Assert.assertEquals((long)link2.getNode().getId().intValue(), (long)this.nodeAId.intValue());
                        Assert.assertEquals((Object)this.portAB, (Object)link2.getBridgePort());
                    }
                    BridgeBridgeLink dlink = (BridgeBridgeLink)SharedSegment.getBridgeBridgeLinks((SharedSegment)shared).iterator().next();
                    Assert.assertEquals((Object)this.nodeAId, (Object)dlink.getDesignatedNode().getId());
                    Assert.assertEquals((Object)this.portAB, (Object)dlink.getDesignatedPort());
                    Assert.assertEquals((Object)this.nodeBId, (Object)dlink.getNode().getId());
                    Assert.assertEquals((Object)this.portBA, (Object)dlink.getBridgePort());
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac6)) {
                    Assert.assertEquals((long)0L, (long)SharedSegment.getBridgeBridgeLinks((SharedSegment)shared).size());
                    Assert.assertEquals((long)1L, (long)SharedSegment.getBridgeMacLinks((SharedSegment)shared).size());
                    Assert.assertEquals((long)1L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((Object)this.nodeBId, (Object)shared.getDesignatedBridge());
                    Assert.assertEquals((Object)this.portB6, (Object)shared.getDesignatedPort().getBridgePort());
                    link = (BridgeMacLink)SharedSegment.getBridgeMacLinks((SharedSegment)shared).iterator().next();
                    Assert.assertEquals((Object)this.mac6, (Object)link.getMacAddress());
                    Assert.assertEquals((Object)this.nodeBId, (Object)link.getNode().getId());
                    Assert.assertEquals((Object)this.portB6, (Object)link.getBridgePort());
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac8)) {
                    Assert.assertEquals((long)0L, (long)SharedSegment.getBridgeBridgeLinks((SharedSegment)shared).size());
                    Assert.assertEquals((long)1L, (long)SharedSegment.getBridgeMacLinks((SharedSegment)shared).size());
                    Assert.assertEquals((long)1L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((Object)this.nodeAId, (Object)shared.getDesignatedBridge());
                    Assert.assertEquals((Object)this.portA8, (Object)shared.getDesignatedPort().getBridgePort());
                    link = (BridgeMacLink)SharedSegment.getBridgeMacLinks((SharedSegment)shared).iterator().next();
                    Assert.assertEquals((Object)this.mac8, (Object)link.getMacAddress());
                    Assert.assertEquals((Object)this.nodeAId, (Object)link.getNode().getId());
                    Assert.assertEquals((Object)this.portA8, (Object)link.getBridgePort());
                    continue;
                }
                Assert.assertEquals((Object)false, (Object)true);
            }
        }
    }

    class TwoConnectedBridgeTopology {
        Integer portA1 = 1;
        Integer portA2 = 2;
        Integer portA3 = 3;
        Integer portA4 = 4;
        Integer portA5 = 5;
        Integer portAB = 16;
        Integer portBA = 24;
        Integer portB6 = 6;
        Integer portB7 = 7;
        Integer portB8 = 8;
        Integer portB9 = 9;
        String mac1 = "000daaaa0001";
        String mac2 = "000daaaa0002";
        String mac3 = "000daaaa0003";
        String mac4 = "000daaaa0004";
        String mac5 = "000daaaa0005";
        String mac6 = "000daaaa0006";
        String mac7 = "000daaaa0007";
        String mac8 = "000daaaa0008";
        String mac9 = "000daaaa0009";
        Integer nodeAId = 1111;
        Integer nodeBId = 2222;
        OnmsNode nodeA = new OnmsNode();
        BridgeElement elementA = new BridgeElement();
        List<BridgeElement> elemlist = new ArrayList<BridgeElement>();
        Set<BridgeForwardingTableEntry> bftA = new HashSet<BridgeForwardingTableEntry>();
        OnmsNode nodeB = new OnmsNode();
        BridgeElement elementB = new BridgeElement();
        Set<BridgeForwardingTableEntry> bftB = new HashSet<BridgeForwardingTableEntry>();

        public TwoConnectedBridgeTopology() {
            this.nodeA.setId(this.nodeAId);
            this.elementA.setNode(this.nodeA);
            this.elementA.setBaseBridgeAddress("aaaaaaaaaaaa");
            this.elemlist.add(this.elementA);
            this.nodeB.setId(this.nodeBId);
            this.elementB.setNode(this.nodeB);
            this.elementB.setBaseBridgeAddress("bbbbbbbbbbbb");
            this.elemlist.add(this.elementB);
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA1, this.mac1));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA2, this.mac2));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA3, this.mac3));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA4, this.mac4));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA5, this.mac5));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portAB, this.mac6));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portAB, this.mac7));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portAB, this.mac8));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portAB, this.mac9));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portBA, this.mac1));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portBA, this.mac2));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portBA, this.mac3));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portBA, this.mac4));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portBA, this.mac5));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portB6, this.mac6));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portB7, this.mac7));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portB8, this.mac8));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portB9, this.mac9));
        }

        public void check(BroadcastDomain domain, boolean reverse) throws BridgeTopologyException {
            List shsegs = domain.getSharedSegments();
            Assert.assertEquals((long)10L, (long)shsegs.size());
            for (SharedSegment shared : shsegs) {
                BridgeMacLink link;
                if (shared.noMacsOnSegment()) {
                    Assert.assertEquals((long)0L, (long)SharedSegment.getBridgeMacLinks((SharedSegment)shared).size());
                    Assert.assertEquals((long)1L, (long)SharedSegment.getBridgeBridgeLinks((SharedSegment)shared).size());
                    link = (BridgeBridgeLink)SharedSegment.getBridgeBridgeLinks((SharedSegment)shared).iterator().next();
                    if (reverse) {
                        Assert.assertEquals((Object)this.nodeBId, (Object)link.getDesignatedNode().getId());
                        Assert.assertEquals((Object)this.portBA, (Object)link.getDesignatedPort());
                        Assert.assertEquals((Object)this.nodeAId, (Object)link.getNode().getId());
                        Assert.assertEquals((Object)this.portAB, (Object)link.getBridgePort());
                        continue;
                    }
                    Assert.assertEquals((Object)this.nodeAId, (Object)link.getDesignatedNode().getId());
                    Assert.assertEquals((Object)this.portAB, (Object)link.getDesignatedPort());
                    Assert.assertEquals((Object)this.nodeBId, (Object)link.getNode().getId());
                    Assert.assertEquals((Object)this.portBA, (Object)link.getBridgePort());
                    continue;
                }
                Assert.assertEquals((long)1L, (long)shared.getMacsOnSegment().size());
                link = (BridgeMacLink)SharedSegment.getBridgeMacLinks((SharedSegment)shared).iterator().next();
                if (link.getMacAddress().equals(this.mac1)) {
                    Assert.assertEquals((Object)this.nodeAId, (Object)link.getNode().getId());
                    Assert.assertEquals((Object)this.portA1, (Object)link.getBridgePort());
                    continue;
                }
                if (link.getMacAddress().equals(this.mac2)) {
                    Assert.assertEquals((Object)this.nodeAId, (Object)link.getNode().getId());
                    Assert.assertEquals((Object)this.portA2, (Object)link.getBridgePort());
                    continue;
                }
                if (link.getMacAddress().equals(this.mac3)) {
                    Assert.assertEquals((Object)this.nodeAId, (Object)link.getNode().getId());
                    Assert.assertEquals((Object)this.portA3, (Object)link.getBridgePort());
                    continue;
                }
                if (link.getMacAddress().equals(this.mac4)) {
                    Assert.assertEquals((Object)this.nodeAId, (Object)link.getNode().getId());
                    Assert.assertEquals((Object)this.portA4, (Object)link.getBridgePort());
                    continue;
                }
                if (link.getMacAddress().equals(this.mac5)) {
                    Assert.assertEquals((Object)this.nodeAId, (Object)link.getNode().getId());
                    Assert.assertEquals((Object)this.portA5, (Object)link.getBridgePort());
                    continue;
                }
                if (link.getMacAddress().equals(this.mac6)) {
                    Assert.assertEquals((Object)this.nodeBId, (Object)link.getNode().getId());
                    Assert.assertEquals((Object)this.portB6, (Object)link.getBridgePort());
                    continue;
                }
                if (link.getMacAddress().equals(this.mac7)) {
                    Assert.assertEquals((Object)this.nodeBId, (Object)link.getNode().getId());
                    Assert.assertEquals((Object)this.portB7, (Object)link.getBridgePort());
                    continue;
                }
                if (link.getMacAddress().equals(this.mac8)) {
                    Assert.assertEquals((Object)this.nodeBId, (Object)link.getNode().getId());
                    Assert.assertEquals((Object)this.portB8, (Object)link.getBridgePort());
                    continue;
                }
                if (link.getMacAddress().equals(this.mac9)) {
                    Assert.assertEquals((Object)this.nodeBId, (Object)link.getNode().getId());
                    Assert.assertEquals((Object)this.portB9, (Object)link.getBridgePort());
                    continue;
                }
                Assert.assertEquals((Object)false, (Object)true);
            }
        }
    }

    class OneBridgeCompleteTopology {
        Integer portA1 = 1;
        Integer portA2 = 2;
        Integer portA3 = 3;
        Integer portA4 = 4;
        Integer portA23 = 23;
        Integer portA24 = 24;
        Integer portA25 = 25;
        String mac1 = "000daaaa0001";
        String mac2 = "000daaaa0002";
        String mac3 = "000daaaa0003";
        String mac4 = "000daaaa0004";
        String mac231 = "000daaaa0231";
        String mac232 = "000daaaa0232";
        String mac233 = "000daaaa0233";
        String mac234 = "000daaaa0234";
        String mac241 = "000daaaa0241";
        String mac242 = "000daaaa0242";
        String mac243 = "000daaaa0243";
        String mac244 = "000daaaa0244";
        String mac245 = "000daaaa0245";
        String mac251 = "000daaaa0251";
        String mac252 = "000daaaa0252";
        String mac253 = "000daaaa0253";
        Integer nodeAId = 30;
        OnmsNode nodeA = new OnmsNode();
        BridgeElement element = new BridgeElement();
        List<BridgeElement> elemlist = new ArrayList<BridgeElement>();
        Set<BridgeForwardingTableEntry> bftA = new HashSet<BridgeForwardingTableEntry>();

        public OneBridgeCompleteTopology() {
            this.nodeA.setId(this.nodeAId);
            this.nodeA.setLocation(new OnmsMonitoringLocation("Default", "Default"));
            this.element.setNode(this.nodeA);
            this.element.setBaseBridgeAddress("aaaaaaaaaaaa");
            this.elemlist.add(this.element);
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA1, this.mac1));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA2, this.mac2));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA3, this.mac3));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA4, this.mac4));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA23, this.mac231));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA23, this.mac232));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA23, this.mac233));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA23, this.mac234));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA24, this.mac241));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA24, this.mac242));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA24, this.mac243));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA24, this.mac244));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA24, this.mac245));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA25, this.mac251));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA25, this.mac252));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA25, this.mac253));
        }

        public void check(BroadcastDomain domain) throws BridgeTopologyException {
            List links = domain.getSharedSegments();
            Assert.assertEquals((long)7L, (long)links.size());
            for (SharedSegment shared : links) {
                Assert.assertTrue((!shared.noMacsOnSegment() ? 1 : 0) != 0);
                Assert.assertEquals((Object)this.nodeAId, (Object)shared.getDesignatedBridge());
                Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                Assert.assertEquals((long)0L, (long)SharedSegment.getBridgeBridgeLinks((SharedSegment)shared).size());
                for (BridgeMacLink link : SharedSegment.getBridgeMacLinks((SharedSegment)shared)) {
                    Set macs;
                    Assert.assertEquals((Object)link.getBridgePort(), (Object)shared.getDesignatedPort().getBridgePort());
                    if (link.getBridgePort() == this.portA1) {
                        Assert.assertEquals((long)1L, (long)shared.getMacsOnSegment().size());
                        Assert.assertEquals((Object)this.mac1, (Object)link.getMacAddress());
                        continue;
                    }
                    if (link.getBridgePort() == this.portA2) {
                        Assert.assertEquals((long)1L, (long)shared.getMacsOnSegment().size());
                        Assert.assertEquals((Object)this.mac2, (Object)link.getMacAddress());
                        continue;
                    }
                    if (link.getBridgePort() == this.portA3) {
                        Assert.assertEquals((long)1L, (long)shared.getMacsOnSegment().size());
                        Assert.assertEquals((Object)this.mac3, (Object)link.getMacAddress());
                        continue;
                    }
                    if (link.getBridgePort() == this.portA4) {
                        Assert.assertEquals((long)1L, (long)shared.getMacsOnSegment().size());
                        Assert.assertEquals((Object)this.mac4, (Object)link.getMacAddress());
                        continue;
                    }
                    if (link.getBridgePort() == this.portA23) {
                        macs = shared.getMacsOnSegment();
                        Assert.assertEquals((long)4L, (long)macs.size());
                        Assert.assertTrue((boolean)macs.contains(this.mac231));
                        Assert.assertTrue((boolean)macs.contains(this.mac232));
                        Assert.assertTrue((boolean)macs.contains(this.mac233));
                        Assert.assertTrue((boolean)macs.contains(this.mac234));
                        continue;
                    }
                    if (link.getBridgePort() == this.portA24) {
                        macs = shared.getMacsOnSegment();
                        Assert.assertEquals((long)5L, (long)macs.size());
                        Assert.assertTrue((boolean)macs.contains(this.mac241));
                        Assert.assertTrue((boolean)macs.contains(this.mac242));
                        Assert.assertTrue((boolean)macs.contains(this.mac243));
                        Assert.assertTrue((boolean)macs.contains(this.mac244));
                        Assert.assertTrue((boolean)macs.contains(this.mac245));
                        continue;
                    }
                    if (link.getBridgePort() == this.portA25) {
                        macs = shared.getMacsOnSegment();
                        Assert.assertEquals((long)3L, (long)macs.size());
                        Assert.assertTrue((boolean)macs.contains(this.mac251));
                        Assert.assertTrue((boolean)macs.contains(this.mac252));
                        Assert.assertTrue((boolean)macs.contains(this.mac253));
                        continue;
                    }
                    Assert.assertEquals((long)-1L, (long)1L);
                }
            }
        }
    }

    class OneBridgeMoreMacOnePortTopology {
        Integer nodeAId = 20;
        OnmsNode nodeA = new OnmsNode();
        BridgeElement element = new BridgeElement();
        List<BridgeElement> elemlist = new ArrayList<BridgeElement>();
        Set<BridgeForwardingTableEntry> bftA = new HashSet<BridgeForwardingTableEntry>();
        Integer portA1 = 1;
        String mac1 = "000daaaa0001";
        String mac2 = "000daaaa0002";
        String mac3 = "000daaaa0003";
        String mac4 = "000daaaa0004";

        public OneBridgeMoreMacOnePortTopology() {
            this.nodeA.setId(this.nodeAId);
            this.element.setNode(this.nodeA);
            this.element.setBaseBridgeAddress("aaaaaaaaaaaa");
            this.elemlist.add(this.element);
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA1, this.mac1));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA1, this.mac2));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA1, this.mac3));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA1, this.mac4));
        }

        public void check(BroadcastDomain domain) throws BridgeTopologyException {
            List links = domain.getSharedSegments();
            Assert.assertEquals((long)1L, (long)links.size());
            for (SharedSegment shared : links) {
                Assert.assertTrue((!shared.noMacsOnSegment() ? 1 : 0) != 0);
                Assert.assertEquals((long)0L, (long)SharedSegment.getBridgeBridgeLinks((SharedSegment)shared).size());
                Assert.assertEquals((Object)this.nodeAId, (Object)shared.getDesignatedBridge());
                Assert.assertEquals((Object)this.portA1, (Object)shared.getDesignatedPort().getBridgePort());
                Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                Assert.assertEquals((long)4L, (long)shared.getMacsOnSegment().size());
                Set macs = shared.getMacsOnSegment();
                Assert.assertTrue((boolean)macs.contains(this.mac1));
                Assert.assertTrue((boolean)macs.contains(this.mac2));
                Assert.assertTrue((boolean)macs.contains(this.mac3));
                Assert.assertTrue((boolean)macs.contains(this.mac4));
                for (BridgeMacLink link : SharedSegment.getBridgeMacLinks((SharedSegment)shared)) {
                    Assert.assertEquals((Object)this.portA1, (Object)link.getBridgePort());
                }
            }
        }
    }

    class OneBridgeOnePortOneMacTopology {
        Integer nodeAId = 10;
        Integer portA1 = 1;
        Integer portA2 = 2;
        Integer portA3 = 3;
        Integer portA4 = 4;
        Integer portA5 = 5;
        String mac1 = "000daaaa0001";
        String mac2 = "000daaaa0002";
        String mac3 = "000daaaa0003";
        String mac4 = "000daaaa0004";
        String mac5 = "000daaaa0005";
        OnmsNode nodeA = new OnmsNode();
        BridgeElement element = new BridgeElement();
        List<BridgeElement> elemlist = new ArrayList<BridgeElement>();
        Set<BridgeForwardingTableEntry> bftA = new HashSet<BridgeForwardingTableEntry>();

        public OneBridgeOnePortOneMacTopology() {
            this.nodeA.setId(this.nodeAId);
            this.element.setNode(this.nodeA);
            this.element.setBaseBridgeAddress("aaaaaaaaaaaa");
            this.elemlist.add(this.element);
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA1, this.mac1));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA2, this.mac2));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA3, this.mac3));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA4, this.mac4));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA5, this.mac5));
        }

        public void check(BroadcastDomain domain) throws BridgeTopologyException {
            List links = domain.getSharedSegments();
            Assert.assertEquals((long)5L, (long)links.size());
            for (SharedSegment shared : links) {
                Assert.assertTrue((!shared.noMacsOnSegment() ? 1 : 0) != 0);
                Assert.assertEquals((Object)this.nodeAId, (Object)shared.getDesignatedBridge());
                Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                Assert.assertEquals((long)1L, (long)shared.getMacsOnSegment().size());
                Assert.assertEquals((long)0L, (long)SharedSegment.getBridgeBridgeLinks((SharedSegment)shared).size());
                for (BridgeMacLink link : SharedSegment.getBridgeMacLinks((SharedSegment)shared)) {
                    Assert.assertEquals((Object)link.getBridgePort(), (Object)shared.getDesignatedPort().getBridgePort());
                    if (link.getBridgePort() == this.portA1) {
                        Assert.assertEquals((Object)this.mac1, (Object)link.getMacAddress());
                        continue;
                    }
                    if (link.getBridgePort() == this.portA2) {
                        Assert.assertEquals((Object)this.mac2, (Object)link.getMacAddress());
                        continue;
                    }
                    if (link.getBridgePort() == this.portA3) {
                        Assert.assertEquals((Object)this.mac3, (Object)link.getMacAddress());
                        continue;
                    }
                    if (link.getBridgePort() == this.portA4) {
                        Assert.assertEquals((Object)this.mac4, (Object)link.getMacAddress());
                        continue;
                    }
                    if (link.getBridgePort() == this.portA5) {
                        Assert.assertEquals((Object)this.mac5, (Object)link.getMacAddress());
                        continue;
                    }
                    Assert.assertEquals((long)-1L, (long)1L);
                }
            }
        }
    }

    class TwoNodeTopology {
        Integer nodeAId = 22101;
        Integer nodeBId = 22102;
        Integer portA1 = 1;
        Integer portA6 = 6;
        Integer portAB = 12;
        Integer portBA = 21;
        Integer portB2 = 2;
        Integer portB7 = 7;
        String macA11 = "000daa000a11";
        String macA12 = "000daa000a12";
        String macA13 = "000daa000a13";
        String macA14 = "000daa000a14";
        String macA61 = "000daa000a61";
        String macA62 = "000daa000a62";
        String macA63 = "000daa000a63";
        String macA64 = "000daa000a64";
        String macshared1 = "000daa000ab1";
        String macshared2 = "000daa000ab2";
        String macshared3 = "000daa000ab3";
        String macAforwd4 = "000daa000ab4";
        String macAforwd5 = "000daa000ab5";
        String macAforwd6 = "000daa000ab6";
        String macBforwd1 = "000daa000ba1";
        String macBforwd2 = "000daa000ba2";
        String macBforwd3 = "000daa000ba3";
        String macB21 = "000daa000b21";
        String macB22 = "000daa000b22";
        String macB23 = "000daa000b23";
        String macB71 = "000daa000b71";
        String macB72 = "000daa000b72";
        String macB73 = "000daa000b73";
        BridgeElement elementA = new BridgeElement();
        BridgeElement elementB = new BridgeElement();
        OnmsNode nodeA = new OnmsNode();
        OnmsNode nodeB = new OnmsNode();
        Set<BridgeForwardingTableEntry> bftA = new HashSet<BridgeForwardingTableEntry>();
        Set<BridgeForwardingTableEntry> bftB = new HashSet<BridgeForwardingTableEntry>();
        List<BridgeElement> elemlist = new ArrayList<BridgeElement>();

        public TwoNodeTopology() {
            this.nodeA.setId(this.nodeAId);
            this.elementA.setNode(this.nodeA);
            this.elementA.setBaseBridgeAddress("aaaaaaaaaaaa");
            this.elemlist.add(this.elementA);
            this.nodeB.setId(this.nodeBId);
            this.elementB.setNode(this.nodeB);
            this.elementB.setBaseBridgeAddress("bbbbbbbbbbbb");
            this.elemlist.add(this.elementB);
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA1, this.macA11));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA1, this.macA12));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA1, this.macA13));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA1, this.macA14));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA6, this.macA61));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA6, this.macA62));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA6, this.macA63));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA6, this.macA64));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portAB, this.macshared1));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portAB, this.macshared2));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portAB, this.macshared3));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portAB, this.macAforwd4));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portAB, this.macAforwd5));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portAB, this.macAforwd6));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portAB, this.macB21));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portAB, this.macB22));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portBA, this.macA11));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portBA, this.macA12));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portBA, this.macA61));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portBA, this.macA62));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portBA, this.macA63));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portBA, this.macshared1));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portBA, this.macshared2));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portBA, this.macshared3));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portBA, this.macBforwd1));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portBA, this.macBforwd2));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portBA, this.macBforwd3));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portB2, this.macB21));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portB2, this.macB22));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portB2, this.macB23));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portB7, this.macB71));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portB7, this.macB72));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portB7, this.macB73));
        }

        public void check2nodeTopology(BroadcastDomain domain, boolean revertedbblink) throws BridgeTopologyException {
            Set forwardersA = domain.getForwarders(this.nodeAId);
            Set forwardersB = domain.getForwarders(this.nodeBId);
            Assert.assertEquals((long)1L, (long)forwardersA.size());
            Assert.assertEquals((long)1L, (long)forwardersB.size());
            HashSet formacsA = new HashSet();
            BridgePortWithMacs forwardA = (BridgePortWithMacs)forwardersA.iterator().next();
            Assert.assertEquals((long)this.nodeAId.intValue(), (long)forwardA.getPort().getNodeId().intValue());
            Assert.assertEquals((Object)this.portAB, (Object)forwardA.getPort().getBridgePort());
            formacsA.addAll(forwardA.getMacs());
            HashSet formacsB = new HashSet();
            BridgePortWithMacs forwardB = (BridgePortWithMacs)forwardersB.iterator().next();
            Assert.assertEquals((long)this.nodeBId.intValue(), (long)forwardB.getPort().getNodeId().intValue());
            Assert.assertEquals((Object)this.portBA, (Object)forwardB.getPort().getBridgePort());
            formacsB.addAll(forwardB.getMacs());
            Assert.assertTrue((boolean)formacsA.contains(this.macAforwd4));
            Assert.assertTrue((boolean)formacsA.contains(this.macAforwd5));
            Assert.assertTrue((boolean)formacsA.contains(this.macAforwd6));
            Assert.assertTrue((boolean)formacsB.contains(this.macBforwd1));
            Assert.assertTrue((boolean)formacsB.contains(this.macBforwd2));
            Assert.assertTrue((boolean)formacsB.contains(this.macBforwd3));
            List shsegs = domain.getSharedSegments();
            Assert.assertEquals((long)5L, (long)shsegs.size());
            for (SharedSegment shared : shsegs) {
                HashSet<String> macs;
                Assert.assertTrue((!shared.noMacsOnSegment() ? 1 : 0) != 0);
                Set nodeidsOnSegment = shared.getBridgeIdsOnSegment();
                List links = SharedSegment.getBridgeMacLinks((SharedSegment)shared);
                List bblinks = SharedSegment.getBridgeBridgeLinks((SharedSegment)shared);
                if (shared.getMacsOnSegment().contains(this.macshared1)) {
                    Assert.assertEquals((long)2L, (long)nodeidsOnSegment.size());
                    Assert.assertEquals((long)3L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((long)3L, (long)links.size());
                    Assert.assertEquals((long)1L, (long)bblinks.size());
                    Assert.assertTrue((boolean)nodeidsOnSegment.contains(this.nodeAId));
                    Assert.assertTrue((boolean)nodeidsOnSegment.contains(this.nodeBId));
                    Assert.assertTrue((boolean)shared.getMacsOnSegment().contains(this.macshared2));
                    Assert.assertTrue((boolean)shared.getMacsOnSegment().contains(this.macshared3));
                    Assert.assertEquals((long)1L, (long)SharedSegment.getBridgeBridgeLinks((SharedSegment)shared).size());
                    BridgeBridgeLink dlink = (BridgeBridgeLink)SharedSegment.getBridgeBridgeLinks((SharedSegment)shared).iterator().next();
                    HashSet<String> macs2 = new HashSet<String>();
                    if (revertedbblink) {
                        Assert.assertEquals((Object)this.nodeBId, (Object)dlink.getDesignatedNode().getId());
                        Assert.assertEquals((Object)this.portBA, (Object)dlink.getDesignatedPort());
                        Assert.assertEquals((Object)this.nodeAId, (Object)dlink.getNode().getId());
                        Assert.assertEquals((Object)this.portAB, (Object)dlink.getBridgePort());
                        for (BridgeMacLink link : links) {
                            Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link.getLinkType());
                            Assert.assertTrue((boolean)shared.getMacsOnSegment().contains(link.getMacAddress()));
                            Assert.assertEquals((long)link.getNode().getId().intValue(), (long)this.nodeBId.intValue());
                            Assert.assertEquals((Object)this.portBA, (Object)link.getBridgePort());
                            Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link.getLinkType());
                            Assert.assertTrue((!macs2.contains(link.getMacAddress()) ? 1 : 0) != 0);
                            macs2.add(link.getMacAddress());
                        }
                    } else {
                        Assert.assertEquals((Object)this.nodeAId, (Object)dlink.getDesignatedNode().getId());
                        Assert.assertEquals((Object)this.portAB, (Object)dlink.getDesignatedPort());
                        Assert.assertEquals((Object)this.nodeBId, (Object)dlink.getNode().getId());
                        Assert.assertEquals((Object)this.portBA, (Object)dlink.getBridgePort());
                        for (BridgeMacLink link : links) {
                            Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link.getLinkType());
                            Assert.assertTrue((boolean)shared.getMacsOnSegment().contains(link.getMacAddress()));
                            Assert.assertEquals((long)link.getNode().getId().intValue(), (long)this.nodeAId.intValue());
                            Assert.assertEquals((Object)this.portAB, (Object)link.getBridgePort());
                            Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link.getLinkType());
                            Assert.assertTrue((!macs2.contains(link.getMacAddress()) ? 1 : 0) != 0);
                            macs2.add(link.getMacAddress());
                        }
                    }
                    Assert.assertTrue((boolean)macs2.contains(this.macshared1));
                    Assert.assertTrue((boolean)macs2.contains(this.macshared2));
                    Assert.assertTrue((boolean)macs2.contains(this.macshared3));
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.macB21)) {
                    Assert.assertEquals((long)0L, (long)SharedSegment.getBridgeBridgeLinks((SharedSegment)shared).size());
                    Assert.assertEquals((long)1L, (long)nodeidsOnSegment.size());
                    Assert.assertTrue((boolean)nodeidsOnSegment.contains(this.nodeBId));
                    Assert.assertEquals((long)3L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((long)3L, (long)links.size());
                    Assert.assertTrue((boolean)shared.getMacsOnSegment().contains(this.macB22));
                    Assert.assertTrue((boolean)shared.getMacsOnSegment().contains(this.macB23));
                    macs = new HashSet<String>();
                    for (BridgeMacLink link : links) {
                        Assert.assertEquals((Object)this.nodeBId, (Object)link.getNode().getId());
                        Assert.assertEquals((Object)this.portB2, (Object)link.getBridgePort());
                        Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link.getLinkType());
                        Assert.assertTrue((!macs.contains(link.getMacAddress()) ? 1 : 0) != 0);
                        macs.add(link.getMacAddress());
                    }
                    Assert.assertTrue((boolean)macs.contains(this.macB21));
                    Assert.assertTrue((boolean)macs.contains(this.macB22));
                    Assert.assertTrue((boolean)macs.contains(this.macB23));
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.macB71)) {
                    Assert.assertEquals((long)0L, (long)SharedSegment.getBridgeBridgeLinks((SharedSegment)shared).size());
                    Assert.assertEquals((long)1L, (long)nodeidsOnSegment.size());
                    Assert.assertTrue((boolean)nodeidsOnSegment.contains(this.nodeBId));
                    Assert.assertEquals((long)3L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((long)3L, (long)links.size());
                    Assert.assertTrue((boolean)shared.getMacsOnSegment().contains(this.macB72));
                    Assert.assertTrue((boolean)shared.getMacsOnSegment().contains(this.macB73));
                    macs = new HashSet();
                    for (BridgeMacLink link : links) {
                        Assert.assertEquals((Object)this.nodeBId, (Object)link.getNode().getId());
                        Assert.assertEquals((Object)this.portB7, (Object)link.getBridgePort());
                        Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link.getLinkType());
                        Assert.assertTrue((!macs.contains(link.getMacAddress()) ? 1 : 0) != 0);
                        macs.add(link.getMacAddress());
                    }
                    Assert.assertTrue((boolean)macs.contains(this.macB71));
                    Assert.assertTrue((boolean)macs.contains(this.macB72));
                    Assert.assertTrue((boolean)macs.contains(this.macB73));
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.macA11)) {
                    Assert.assertEquals((long)0L, (long)SharedSegment.getBridgeBridgeLinks((SharedSegment)shared).size());
                    Assert.assertEquals((long)1L, (long)nodeidsOnSegment.size());
                    Assert.assertTrue((boolean)nodeidsOnSegment.contains(this.nodeAId));
                    Assert.assertEquals((long)4L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((long)4L, (long)links.size());
                    Assert.assertTrue((boolean)shared.getMacsOnSegment().contains(this.macA12));
                    Assert.assertTrue((boolean)shared.getMacsOnSegment().contains(this.macA13));
                    Assert.assertTrue((boolean)shared.getMacsOnSegment().contains(this.macA14));
                    macs = new HashSet();
                    for (BridgeMacLink link : links) {
                        Assert.assertEquals((Object)this.nodeAId, (Object)link.getNode().getId());
                        Assert.assertEquals((Object)this.portA1, (Object)link.getBridgePort());
                        Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link.getLinkType());
                        Assert.assertTrue((!macs.contains(link.getMacAddress()) ? 1 : 0) != 0);
                        macs.add(link.getMacAddress());
                    }
                    Assert.assertTrue((boolean)macs.contains(this.macA11));
                    Assert.assertTrue((boolean)macs.contains(this.macA12));
                    Assert.assertTrue((boolean)macs.contains(this.macA13));
                    Assert.assertTrue((boolean)macs.contains(this.macA14));
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.macA61)) {
                    Assert.assertEquals((long)0L, (long)SharedSegment.getBridgeBridgeLinks((SharedSegment)shared).size());
                    Assert.assertEquals((long)1L, (long)nodeidsOnSegment.size());
                    Assert.assertTrue((boolean)nodeidsOnSegment.contains(this.nodeAId));
                    Assert.assertEquals((long)4L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((long)4L, (long)links.size());
                    Assert.assertTrue((boolean)shared.getMacsOnSegment().contains(this.macA62));
                    Assert.assertTrue((boolean)shared.getMacsOnSegment().contains(this.macA63));
                    Assert.assertTrue((boolean)shared.getMacsOnSegment().contains(this.macA64));
                    macs = new HashSet();
                    for (BridgeMacLink link : links) {
                        Assert.assertEquals((Object)this.nodeAId, (Object)link.getNode().getId());
                        Assert.assertEquals((Object)this.portA6, (Object)link.getBridgePort());
                        Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link.getLinkType());
                        Assert.assertTrue((!macs.contains(link.getMacAddress()) ? 1 : 0) != 0);
                        macs.add(link.getMacAddress());
                    }
                    Assert.assertTrue((boolean)macs.contains(this.macA61));
                    Assert.assertTrue((boolean)macs.contains(this.macA62));
                    Assert.assertTrue((boolean)macs.contains(this.macA63));
                    Assert.assertTrue((boolean)macs.contains(this.macA64));
                    continue;
                }
                Assert.assertTrue((boolean)false);
            }
        }
    }

    class DEFGHILTopology {
        Integer nodeDId = 104;
        Integer nodeEId = 105;
        Integer nodeFId = 106;
        Integer nodeGId = 107;
        Integer nodeHId = 108;
        Integer nodeIId = 109;
        Integer nodeLId = 110;
        Integer portD = 44;
        Integer portDD = 40;
        Integer portE = 55;
        Integer portEE = 50;
        Integer portF = 66;
        Integer portFF = 60;
        Integer portG7 = 7;
        Integer portG8 = 8;
        Integer portGD = 74;
        Integer portGE = 75;
        Integer portGF = 76;
        Integer portH1 = 1;
        Integer portH2 = 2;
        Integer portHH = 80;
        Integer portI3 = 3;
        Integer portI4 = 4;
        Integer portII = 90;
        Integer portL5 = 3;
        Integer portL6 = 4;
        Integer portLL = 20;
        String mac1 = "000daaaa0441";
        String mac2 = "000daaaa0442";
        String mac3 = "000daaaa0663";
        String mac4 = "000daaaa0664";
        String mac5 = "000daaaa0555";
        String mac6 = "000daaaa0556";
        String mac7 = "000daaaa0707";
        String mac8 = "000daaaa0808";
        OnmsNode nodeD = new OnmsNode();
        OnmsNode nodeE = new OnmsNode();
        OnmsNode nodeF = new OnmsNode();
        OnmsNode nodeG = new OnmsNode();
        OnmsNode nodeH = new OnmsNode();
        OnmsNode nodeI = new OnmsNode();
        OnmsNode nodeL = new OnmsNode();
        BridgeElement elementD = new BridgeElement();
        BridgeElement elementE = new BridgeElement();
        BridgeElement elementF = new BridgeElement();
        BridgeElement elementG = new BridgeElement();
        BridgeElement elementH = new BridgeElement();
        BridgeElement elementI = new BridgeElement();
        BridgeElement elementL = new BridgeElement();
        List<BridgeElement> elemlist = new ArrayList<BridgeElement>();
        Set<BridgeForwardingTableEntry> bftD = new HashSet<BridgeForwardingTableEntry>();
        Set<BridgeForwardingTableEntry> bftE = new HashSet<BridgeForwardingTableEntry>();
        Set<BridgeForwardingTableEntry> bftF = new HashSet<BridgeForwardingTableEntry>();
        Set<BridgeForwardingTableEntry> bftG = new HashSet<BridgeForwardingTableEntry>();
        Set<BridgeForwardingTableEntry> bftH = new HashSet<BridgeForwardingTableEntry>();
        Set<BridgeForwardingTableEntry> bftI = new HashSet<BridgeForwardingTableEntry>();
        Set<BridgeForwardingTableEntry> bftL = new HashSet<BridgeForwardingTableEntry>();

        public DEFGHILTopology() {
            this.nodeD.setId(this.nodeDId);
            this.elementD.setNode(this.nodeD);
            this.elementD.setBaseBridgeAddress("dddddddddddd");
            this.elemlist.add(this.elementD);
            this.nodeE.setId(this.nodeEId);
            this.elementE.setNode(this.nodeE);
            this.elementE.setBaseBridgeAddress("ddddddddeddd");
            this.elemlist.add(this.elementE);
            this.nodeF.setId(this.nodeFId);
            this.elementF.setNode(this.nodeF);
            this.elementF.setBaseBridgeAddress("ddddddddfddd");
            this.elemlist.add(this.elementF);
            this.nodeG.setId(this.nodeGId);
            this.elementG.setNode(this.nodeG);
            this.elementG.setBaseBridgeAddress("ddddddd1dddd");
            this.elemlist.add(this.elementG);
            this.nodeI.setId(this.nodeIId);
            this.elementI.setNode(this.nodeI);
            this.elementI.setBaseBridgeAddress("ddddddd2dddd");
            this.elemlist.add(this.elementI);
            this.nodeH.setId(this.nodeHId);
            this.elementH.setNode(this.nodeH);
            this.elementH.setBaseBridgeAddress("ddddddd3dddd");
            this.elemlist.add(this.elementH);
            this.nodeL.setId(this.nodeLId);
            this.elementL.setNode(this.nodeL);
            this.elementL.setBaseBridgeAddress("ddddddd4dddd");
            this.elemlist.add(this.elementL);
            this.bftD.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeD, this.portD, this.mac1));
            this.bftD.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeD, this.portD, this.mac2));
            this.bftD.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeD, this.portDD, this.mac3));
            this.bftD.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeD, this.portDD, this.mac4));
            this.bftD.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeD, this.portDD, this.mac5));
            this.bftD.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeD, this.portDD, this.mac6));
            this.bftD.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeD, this.portDD, this.mac7));
            this.bftD.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeD, this.portDD, this.mac8));
            this.bftE.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeE, this.portEE, this.mac1));
            this.bftE.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeE, this.portEE, this.mac2));
            this.bftE.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeE, this.portEE, this.mac3));
            this.bftE.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeE, this.portEE, this.mac4));
            this.bftE.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeE, this.portE, this.mac5));
            this.bftE.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeE, this.portE, this.mac6));
            this.bftE.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeE, this.portEE, this.mac7));
            this.bftE.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeE, this.portEE, this.mac8));
            this.bftF.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeF, this.portFF, this.mac1));
            this.bftF.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeF, this.portFF, this.mac2));
            this.bftF.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeF, this.portF, this.mac3));
            this.bftF.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeF, this.portF, this.mac4));
            this.bftF.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeF, this.portFF, this.mac5));
            this.bftF.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeF, this.portFF, this.mac6));
            this.bftF.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeF, this.portFF, this.mac7));
            this.bftF.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeF, this.portFF, this.mac8));
            this.bftG.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeG, this.portGD, this.mac1));
            this.bftG.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeG, this.portGD, this.mac2));
            this.bftG.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeG, this.portGF, this.mac3));
            this.bftG.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeG, this.portGF, this.mac4));
            this.bftG.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeG, this.portGE, this.mac5));
            this.bftG.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeG, this.portGE, this.mac6));
            this.bftG.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeG, this.portG7, this.mac7));
            this.bftG.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeG, this.portG8, this.mac8));
            this.bftH.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeH, this.portH1, this.mac1));
            this.bftH.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeH, this.portH2, this.mac2));
            this.bftH.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeH, this.portHH, this.mac3));
            this.bftH.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeH, this.portHH, this.mac4));
            this.bftH.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeH, this.portHH, this.mac5));
            this.bftH.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeH, this.portHH, this.mac6));
            this.bftH.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeH, this.portHH, this.mac7));
            this.bftH.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeH, this.portHH, this.mac8));
            this.bftI.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeI, this.portII, this.mac1));
            this.bftI.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeI, this.portII, this.mac2));
            this.bftI.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeI, this.portI3, this.mac3));
            this.bftI.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeI, this.portI4, this.mac4));
            this.bftI.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeI, this.portII, this.mac5));
            this.bftI.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeI, this.portII, this.mac6));
            this.bftI.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeI, this.portII, this.mac7));
            this.bftI.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeI, this.portII, this.mac8));
            this.bftL.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeL, this.portLL, this.mac1));
            this.bftL.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeL, this.portLL, this.mac2));
            this.bftL.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeL, this.portLL, this.mac3));
            this.bftL.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeL, this.portLL, this.mac4));
            this.bftL.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeL, this.portL5, this.mac5));
            this.bftL.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeL, this.portL6, this.mac6));
            this.bftL.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeL, this.portLL, this.mac7));
            this.bftL.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeL, this.portLL, this.mac8));
        }

        public void checkDE(BroadcastDomain domain) throws BridgeTopologyException {
            Assert.assertEquals((long)0L, (long)domain.getForwarders(this.nodeDId).size());
            Assert.assertEquals((long)0L, (long)domain.getForwarders(this.nodeEId).size());
            List shsegs = domain.getSharedSegments();
            Assert.assertEquals((long)3L, (long)shsegs.size());
            for (SharedSegment shared : shsegs) {
                if (shared.getMacsOnSegment().contains(this.mac1)) {
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((long)2L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getMacsOnSegment().contains(this.mac2));
                    Assert.assertEquals((long)2L, (long)SharedSegment.getBridgeMacLinks((SharedSegment)shared).size());
                    Assert.assertEquals((long)0L, (long)SharedSegment.getBridgeBridgeLinks((SharedSegment)shared).size());
                    Assert.assertEquals((long)this.nodeDId.intValue(), (long)shared.getDesignatedBridge().intValue());
                    Assert.assertEquals((long)this.portD.intValue(), (long)shared.getDesignatedPort().getBridgePort().intValue());
                    for (BridgeMacLink link : SharedSegment.getBridgeMacLinks((SharedSegment)shared)) {
                        Assert.assertEquals((long)this.nodeDId.intValue(), (long)link.getNode().getId().intValue());
                        Assert.assertEquals((Object)this.portD, (Object)link.getBridgePort());
                        Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link.getLinkType());
                    }
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac5)) {
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((long)2L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getMacsOnSegment().contains(this.mac6));
                    Assert.assertEquals((long)2L, (long)SharedSegment.getBridgeMacLinks((SharedSegment)shared).size());
                    Assert.assertEquals((long)0L, (long)SharedSegment.getBridgeBridgeLinks((SharedSegment)shared).size());
                    Assert.assertEquals((long)this.nodeEId.intValue(), (long)shared.getDesignatedBridge().intValue());
                    Assert.assertEquals((long)this.portE.intValue(), (long)shared.getDesignatedPort().getBridgePort().intValue());
                    for (BridgeMacLink link : SharedSegment.getBridgeMacLinks((SharedSegment)shared)) {
                        Assert.assertEquals((long)this.nodeEId.intValue(), (long)link.getNode().getId().intValue());
                        Assert.assertEquals((Object)this.portE, (Object)link.getBridgePort());
                        Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link.getLinkType());
                    }
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac7)) {
                    Assert.assertEquals((long)2L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getBridgeIdsOnSegment().contains(this.nodeDId));
                    Assert.assertEquals((Object)true, (Object)shared.getBridgeIdsOnSegment().contains(this.nodeEId));
                    Assert.assertEquals((long)4L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getMacsOnSegment().contains(this.mac3));
                    Assert.assertEquals((Object)true, (Object)shared.getMacsOnSegment().contains(this.mac4));
                    Assert.assertEquals((Object)true, (Object)shared.getMacsOnSegment().contains(this.mac8));
                    Assert.assertEquals((long)4L, (long)SharedSegment.getBridgeMacLinks((SharedSegment)shared).size());
                    Assert.assertEquals((long)1L, (long)SharedSegment.getBridgeBridgeLinks((SharedSegment)shared).size());
                    BridgeBridgeLink bblink = (BridgeBridgeLink)SharedSegment.getBridgeBridgeLinks((SharedSegment)shared).iterator().next();
                    Assert.assertEquals((long)this.nodeDId.intValue(), (long)bblink.getDesignatedNode().getId().intValue());
                    Assert.assertEquals((long)this.portDD.intValue(), (long)bblink.getDesignatedPort().intValue());
                    Assert.assertEquals((long)this.nodeEId.intValue(), (long)bblink.getNode().getId().intValue());
                    Assert.assertEquals((long)this.portEE.intValue(), (long)bblink.getBridgePort().intValue());
                    HashSet<String> macs = new HashSet<String>();
                    for (BridgeMacLink link : SharedSegment.getBridgeMacLinks((SharedSegment)shared)) {
                        Assert.assertEquals((long)this.nodeDId.intValue(), (long)link.getNode().getId().intValue());
                        Assert.assertEquals((Object)this.portDD, (Object)link.getBridgePort());
                        Assert.assertTrue((!macs.contains(link.getMacAddress()) ? 1 : 0) != 0);
                        Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link.getLinkType());
                        macs.add(link.getMacAddress());
                    }
                    Assert.assertTrue((boolean)macs.contains(this.mac3));
                    Assert.assertTrue((boolean)macs.contains(this.mac4));
                    Assert.assertTrue((boolean)macs.contains(this.mac7));
                    Assert.assertTrue((boolean)macs.contains(this.mac8));
                    continue;
                }
                Assert.assertEquals((Object)false, (Object)true);
            }
        }

        public void checkDF(BroadcastDomain domain) throws BridgeTopologyException {
            Assert.assertEquals((long)0L, (long)domain.getForwarders(this.nodeDId).size());
            Assert.assertEquals((long)0L, (long)domain.getForwarders(this.nodeFId).size());
            List shsegs = domain.getSharedSegments();
            Assert.assertEquals((long)3L, (long)shsegs.size());
            for (SharedSegment shared : shsegs) {
                if (shared.getMacsOnSegment().contains(this.mac1)) {
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((long)2L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getMacsOnSegment().contains(this.mac2));
                    Assert.assertEquals((long)2L, (long)SharedSegment.getBridgeMacLinks((SharedSegment)shared).size());
                    Assert.assertEquals((long)0L, (long)SharedSegment.getBridgeBridgeLinks((SharedSegment)shared).size());
                    Assert.assertEquals((long)this.nodeDId.intValue(), (long)shared.getDesignatedBridge().intValue());
                    Assert.assertEquals((long)this.portD.intValue(), (long)shared.getDesignatedPort().getBridgePort().intValue());
                    for (BridgeMacLink link : SharedSegment.getBridgeMacLinks((SharedSegment)shared)) {
                        Assert.assertEquals((long)this.nodeDId.intValue(), (long)link.getNode().getId().intValue());
                        Assert.assertEquals((Object)this.portD, (Object)link.getBridgePort());
                        Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link.getLinkType());
                    }
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac3)) {
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((long)2L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getMacsOnSegment().contains(this.mac4));
                    Assert.assertEquals((long)2L, (long)SharedSegment.getBridgeMacLinks((SharedSegment)shared).size());
                    Assert.assertEquals((long)0L, (long)SharedSegment.getBridgeBridgeLinks((SharedSegment)shared).size());
                    Assert.assertEquals((long)this.nodeFId.intValue(), (long)shared.getDesignatedBridge().intValue());
                    Assert.assertEquals((long)this.portF.intValue(), (long)shared.getDesignatedPort().getBridgePort().intValue());
                    for (BridgeMacLink link : SharedSegment.getBridgeMacLinks((SharedSegment)shared)) {
                        Assert.assertEquals((long)this.nodeFId.intValue(), (long)link.getNode().getId().intValue());
                        Assert.assertEquals((Object)this.portF, (Object)link.getBridgePort());
                        Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link.getLinkType());
                    }
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac7)) {
                    Assert.assertEquals((long)2L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getBridgeIdsOnSegment().contains(this.nodeDId));
                    Assert.assertEquals((Object)true, (Object)shared.getBridgeIdsOnSegment().contains(this.nodeFId));
                    Assert.assertEquals((long)4L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getMacsOnSegment().contains(this.mac5));
                    Assert.assertEquals((Object)true, (Object)shared.getMacsOnSegment().contains(this.mac6));
                    Assert.assertEquals((Object)true, (Object)shared.getMacsOnSegment().contains(this.mac8));
                    Assert.assertEquals((long)4L, (long)SharedSegment.getBridgeMacLinks((SharedSegment)shared).size());
                    BridgeBridgeLink bblink = (BridgeBridgeLink)SharedSegment.getBridgeBridgeLinks((SharedSegment)shared).iterator().next();
                    Assert.assertEquals((long)this.nodeDId.intValue(), (long)bblink.getDesignatedNode().getId().intValue());
                    Assert.assertEquals((long)this.portDD.intValue(), (long)bblink.getDesignatedPort().intValue());
                    Assert.assertEquals((long)this.nodeFId.intValue(), (long)bblink.getNode().getId().intValue());
                    Assert.assertEquals((long)this.portFF.intValue(), (long)bblink.getBridgePort().intValue());
                    Assert.assertEquals((long)1L, (long)SharedSegment.getBridgeBridgeLinks((SharedSegment)shared).size());
                    HashSet<String> macs = new HashSet<String>();
                    for (BridgeMacLink link : SharedSegment.getBridgeMacLinks((SharedSegment)shared)) {
                        Assert.assertEquals((long)this.nodeDId.intValue(), (long)link.getNode().getId().intValue());
                        Assert.assertEquals((Object)this.portDD, (Object)link.getBridgePort());
                        Assert.assertTrue((!macs.contains(link.getMacAddress()) ? 1 : 0) != 0);
                        Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link.getLinkType());
                        macs.add(link.getMacAddress());
                    }
                    Assert.assertTrue((boolean)macs.contains(this.mac5));
                    Assert.assertTrue((boolean)macs.contains(this.mac6));
                    Assert.assertTrue((boolean)macs.contains(this.mac7));
                    Assert.assertTrue((boolean)macs.contains(this.mac8));
                    continue;
                }
                Assert.assertEquals((Object)false, (Object)true);
            }
        }

        public void checkDG(BroadcastDomain domain) throws BridgeTopologyException {
            Assert.assertEquals((long)0L, (long)domain.getForwarders(this.nodeDId).size());
            Assert.assertEquals((long)0L, (long)domain.getForwarders(this.nodeGId).size());
            List shsegs = domain.getSharedSegments();
            Assert.assertEquals((long)6L, (long)shsegs.size());
            for (SharedSegment shared : shsegs) {
                if (shared.noMacsOnSegment()) {
                    Assert.assertEquals((long)2L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getBridgeIdsOnSegment().contains(this.nodeGId));
                    Assert.assertEquals((Object)true, (Object)shared.getBridgeIdsOnSegment().contains(this.nodeDId));
                    Assert.assertEquals((long)1L, (long)SharedSegment.getBridgeBridgeLinks((SharedSegment)shared).size());
                    Assert.assertEquals((long)0L, (long)SharedSegment.getBridgeMacLinks((SharedSegment)shared).size());
                    BridgeBridgeLink link = (BridgeBridgeLink)SharedSegment.getBridgeBridgeLinks((SharedSegment)shared).iterator().next();
                    Assert.assertEquals((Object)this.nodeDId, (Object)link.getDesignatedNode().getId());
                    Assert.assertEquals((Object)this.nodeGId, (Object)link.getNode().getId());
                    Assert.assertEquals((Object)this.portDD, (Object)link.getDesignatedPort());
                    Assert.assertEquals((Object)this.portGD, (Object)link.getBridgePort());
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac1)) {
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((long)2L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getMacsOnSegment().contains(this.mac2));
                    Assert.assertEquals((long)2L, (long)SharedSegment.getBridgeMacLinks((SharedSegment)shared).size());
                    Assert.assertEquals((long)0L, (long)SharedSegment.getBridgeBridgeLinks((SharedSegment)shared).size());
                    Assert.assertEquals((long)this.nodeDId.intValue(), (long)shared.getDesignatedBridge().intValue());
                    Assert.assertEquals((long)this.portD.intValue(), (long)shared.getDesignatedPort().getBridgePort().intValue());
                    for (BridgeMacLink link : SharedSegment.getBridgeMacLinks((SharedSegment)shared)) {
                        Assert.assertEquals((long)this.nodeDId.intValue(), (long)link.getNode().getId().intValue());
                        Assert.assertEquals((Object)this.portD, (Object)link.getBridgePort());
                        Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link.getLinkType());
                    }
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac3)) {
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((long)2L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getMacsOnSegment().contains(this.mac4));
                    Assert.assertEquals((long)2L, (long)SharedSegment.getBridgeMacLinks((SharedSegment)shared).size());
                    Assert.assertEquals((long)0L, (long)SharedSegment.getBridgeBridgeLinks((SharedSegment)shared).size());
                    Assert.assertEquals((long)this.nodeGId.intValue(), (long)shared.getDesignatedBridge().intValue());
                    Assert.assertEquals((long)this.portGF.intValue(), (long)shared.getDesignatedPort().getBridgePort().intValue());
                    for (BridgeMacLink link : SharedSegment.getBridgeMacLinks((SharedSegment)shared)) {
                        Assert.assertEquals((long)this.nodeGId.intValue(), (long)link.getNode().getId().intValue());
                        Assert.assertEquals((Object)this.portGF, (Object)link.getBridgePort());
                        Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link.getLinkType());
                    }
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac5)) {
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((long)2L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getMacsOnSegment().contains(this.mac6));
                    Assert.assertEquals((long)2L, (long)SharedSegment.getBridgeMacLinks((SharedSegment)shared).size());
                    Assert.assertEquals((long)0L, (long)SharedSegment.getBridgeBridgeLinks((SharedSegment)shared).size());
                    Assert.assertEquals((long)this.nodeGId.intValue(), (long)shared.getDesignatedBridge().intValue());
                    Assert.assertEquals((long)this.portGE.intValue(), (long)shared.getDesignatedPort().getBridgePort().intValue());
                    for (BridgeMacLink link : SharedSegment.getBridgeMacLinks((SharedSegment)shared)) {
                        Assert.assertEquals((long)this.nodeGId.intValue(), (long)link.getNode().getId().intValue());
                        Assert.assertEquals((Object)this.portGE, (Object)link.getBridgePort());
                        Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link.getLinkType());
                    }
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac7)) {
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getBridgeIdsOnSegment().contains(this.nodeGId));
                    Assert.assertEquals((long)1L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((long)this.nodeGId.intValue(), (long)shared.getDesignatedBridge().intValue());
                    Assert.assertEquals((long)this.portG7.intValue(), (long)shared.getDesignatedPort().getBridgePort().intValue());
                    for (BridgeMacLink link : SharedSegment.getBridgeMacLinks((SharedSegment)shared)) {
                        Assert.assertEquals((Object)this.portG7, (Object)link.getBridgePort());
                        Assert.assertEquals((Object)this.nodeGId, (Object)link.getNode().getId());
                        Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link.getLinkType());
                    }
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac8)) {
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getBridgeIdsOnSegment().contains(this.nodeGId));
                    Assert.assertEquals((long)1L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((long)this.nodeGId.intValue(), (long)shared.getDesignatedBridge().intValue());
                    Assert.assertEquals((long)this.portG8.intValue(), (long)shared.getDesignatedPort().getBridgePort().intValue());
                    for (BridgeMacLink link : SharedSegment.getBridgeMacLinks((SharedSegment)shared)) {
                        Assert.assertEquals((Object)this.portG8, (Object)link.getBridgePort());
                        Assert.assertEquals((Object)this.nodeGId, (Object)link.getNode().getId());
                        Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link.getLinkType());
                    }
                    continue;
                }
                Assert.assertEquals((Object)false, (Object)true);
            }
        }

        public void checkEF(BroadcastDomain domain) throws BridgeTopologyException {
            Assert.assertEquals((long)0L, (long)domain.getForwarders(this.nodeEId).size());
            Assert.assertEquals((long)0L, (long)domain.getForwarders(this.nodeFId).size());
            List shsegs = domain.getSharedSegments();
            Assert.assertEquals((long)3L, (long)shsegs.size());
            for (SharedSegment shared : shsegs) {
                HashSet<String> macs;
                if (shared.getMacsOnSegment().contains(this.mac3)) {
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((long)2L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getMacsOnSegment().contains(this.mac4));
                    Assert.assertEquals((long)2L, (long)SharedSegment.getBridgeMacLinks((SharedSegment)shared).size());
                    Assert.assertEquals((long)0L, (long)SharedSegment.getBridgeBridgeLinks((SharedSegment)shared).size());
                    Assert.assertEquals((long)this.nodeFId.intValue(), (long)shared.getDesignatedBridge().intValue());
                    Assert.assertEquals((long)this.portF.intValue(), (long)shared.getDesignatedPort().getBridgePort().intValue());
                    macs = new HashSet<String>();
                    for (BridgeMacLink link : SharedSegment.getBridgeMacLinks((SharedSegment)shared)) {
                        Assert.assertEquals((long)this.nodeFId.intValue(), (long)link.getNode().getId().intValue());
                        Assert.assertEquals((Object)this.portF, (Object)link.getBridgePort());
                        Assert.assertTrue((!macs.contains(link.getMacAddress()) ? 1 : 0) != 0);
                        Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link.getLinkType());
                        macs.add(link.getMacAddress());
                    }
                    Assert.assertTrue((boolean)macs.contains(this.mac3));
                    Assert.assertTrue((boolean)macs.contains(this.mac4));
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac5)) {
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((long)2L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getMacsOnSegment().contains(this.mac6));
                    Assert.assertEquals((long)2L, (long)SharedSegment.getBridgeMacLinks((SharedSegment)shared).size());
                    Assert.assertEquals((long)0L, (long)SharedSegment.getBridgeBridgeLinks((SharedSegment)shared).size());
                    Assert.assertEquals((long)this.nodeEId.intValue(), (long)shared.getDesignatedBridge().intValue());
                    Assert.assertEquals((long)this.portE.intValue(), (long)shared.getDesignatedPort().getBridgePort().intValue());
                    macs = new HashSet();
                    for (BridgeMacLink link : SharedSegment.getBridgeMacLinks((SharedSegment)shared)) {
                        Assert.assertEquals((long)this.nodeEId.intValue(), (long)link.getNode().getId().intValue());
                        Assert.assertEquals((Object)this.portE, (Object)link.getBridgePort());
                        Assert.assertTrue((!macs.contains(link.getMacAddress()) ? 1 : 0) != 0);
                        Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link.getLinkType());
                        macs.add(link.getMacAddress());
                    }
                    Assert.assertTrue((boolean)macs.contains(this.mac5));
                    Assert.assertTrue((boolean)macs.contains(this.mac6));
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac1)) {
                    Assert.assertEquals((long)2L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getBridgeIdsOnSegment().contains(this.nodeFId));
                    Assert.assertEquals((Object)true, (Object)shared.getBridgeIdsOnSegment().contains(this.nodeEId));
                    Assert.assertEquals((long)4L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getMacsOnSegment().contains(this.mac2));
                    Assert.assertEquals((Object)true, (Object)shared.getMacsOnSegment().contains(this.mac7));
                    Assert.assertEquals((Object)true, (Object)shared.getMacsOnSegment().contains(this.mac8));
                    Assert.assertEquals((long)1L, (long)SharedSegment.getBridgeBridgeLinks((SharedSegment)shared).size());
                    BridgeBridgeLink bblink = (BridgeBridgeLink)SharedSegment.getBridgeBridgeLinks((SharedSegment)shared).iterator().next();
                    Assert.assertEquals((long)this.nodeEId.intValue(), (long)bblink.getDesignatedNode().getId().intValue());
                    Assert.assertEquals((Object)this.portEE, (Object)bblink.getDesignatedPort());
                    Assert.assertEquals((long)this.nodeFId.intValue(), (long)bblink.getNode().getId().intValue());
                    Assert.assertEquals((Object)this.portFF, (Object)bblink.getBridgePort());
                    Assert.assertEquals((long)4L, (long)SharedSegment.getBridgeMacLinks((SharedSegment)shared).size());
                    HashSet<String> macs2 = new HashSet<String>();
                    for (BridgeMacLink link : SharedSegment.getBridgeMacLinks((SharedSegment)shared)) {
                        Assert.assertEquals((long)this.nodeEId.intValue(), (long)link.getNode().getId().intValue());
                        Assert.assertEquals((Object)this.portEE, (Object)link.getBridgePort());
                        Assert.assertTrue((!macs2.contains(link.getMacAddress()) ? 1 : 0) != 0);
                        Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link.getLinkType());
                        macs2.add(link.getMacAddress());
                    }
                    Assert.assertTrue((boolean)macs2.contains(this.mac1));
                    Assert.assertTrue((boolean)macs2.contains(this.mac2));
                    Assert.assertTrue((boolean)macs2.contains(this.mac7));
                    Assert.assertTrue((boolean)macs2.contains(this.mac8));
                    continue;
                }
                Assert.assertEquals((Object)false, (Object)true);
            }
        }

        public void checkDEF(BroadcastDomain domain) throws BridgeTopologyException {
            Assert.assertEquals((long)0L, (long)domain.getForwarders(this.nodeDId).size());
            Assert.assertEquals((long)0L, (long)domain.getForwarders(this.nodeEId).size());
            Assert.assertEquals((long)0L, (long)domain.getForwarders(this.nodeFId).size());
            List shsegs = domain.getSharedSegments();
            Assert.assertEquals((long)4L, (long)shsegs.size());
            for (SharedSegment shared : shsegs) {
                HashSet<String> macs;
                if (shared.getMacsOnSegment().contains(this.mac1)) {
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((long)2L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getMacsOnSegment().contains(this.mac2));
                    Assert.assertEquals((long)2L, (long)SharedSegment.getBridgeMacLinks((SharedSegment)shared).size());
                    Assert.assertEquals((long)0L, (long)SharedSegment.getBridgeBridgeLinks((SharedSegment)shared).size());
                    Assert.assertEquals((long)this.nodeDId.intValue(), (long)shared.getDesignatedBridge().intValue());
                    Assert.assertEquals((long)this.portD.intValue(), (long)shared.getDesignatedPort().getBridgePort().intValue());
                    macs = new HashSet<String>();
                    for (BridgeMacLink link : SharedSegment.getBridgeMacLinks((SharedSegment)shared)) {
                        Assert.assertEquals((long)this.nodeDId.intValue(), (long)link.getNode().getId().intValue());
                        Assert.assertEquals((Object)this.portD, (Object)link.getBridgePort());
                        Assert.assertTrue((!macs.contains(link.getMacAddress()) ? 1 : 0) != 0);
                        Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link.getLinkType());
                        macs.add(link.getMacAddress());
                    }
                    Assert.assertTrue((boolean)macs.contains(this.mac1));
                    Assert.assertTrue((boolean)macs.contains(this.mac2));
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac5)) {
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((long)2L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getMacsOnSegment().contains(this.mac6));
                    Assert.assertEquals((long)2L, (long)SharedSegment.getBridgeMacLinks((SharedSegment)shared).size());
                    Assert.assertEquals((long)0L, (long)SharedSegment.getBridgeBridgeLinks((SharedSegment)shared).size());
                    Assert.assertEquals((long)this.nodeEId.intValue(), (long)shared.getDesignatedBridge().intValue());
                    Assert.assertEquals((long)this.portE.intValue(), (long)shared.getDesignatedPort().getBridgePort().intValue());
                    macs = new HashSet();
                    for (BridgeMacLink link : SharedSegment.getBridgeMacLinks((SharedSegment)shared)) {
                        Assert.assertEquals((long)this.nodeEId.intValue(), (long)link.getNode().getId().intValue());
                        Assert.assertEquals((Object)this.portE, (Object)link.getBridgePort());
                        Assert.assertTrue((!macs.contains(link.getMacAddress()) ? 1 : 0) != 0);
                        Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link.getLinkType());
                        macs.add(link.getMacAddress());
                    }
                    Assert.assertTrue((boolean)macs.contains(this.mac5));
                    Assert.assertTrue((boolean)macs.contains(this.mac6));
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac3)) {
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((long)2L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getMacsOnSegment().contains(this.mac4));
                    Assert.assertEquals((long)2L, (long)SharedSegment.getBridgeMacLinks((SharedSegment)shared).size());
                    Assert.assertEquals((long)0L, (long)SharedSegment.getBridgeBridgeLinks((SharedSegment)shared).size());
                    Assert.assertEquals((long)this.nodeFId.intValue(), (long)shared.getDesignatedBridge().intValue());
                    Assert.assertEquals((long)this.portF.intValue(), (long)shared.getDesignatedPort().getBridgePort().intValue());
                    macs = new HashSet();
                    for (BridgeMacLink link : SharedSegment.getBridgeMacLinks((SharedSegment)shared)) {
                        Assert.assertEquals((long)this.nodeFId.intValue(), (long)link.getNode().getId().intValue());
                        Assert.assertEquals((Object)this.portF, (Object)link.getBridgePort());
                        Assert.assertTrue((!macs.contains(link.getMacAddress()) ? 1 : 0) != 0);
                        Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link.getLinkType());
                        macs.add(link.getMacAddress());
                    }
                    Assert.assertTrue((boolean)macs.contains(this.mac3));
                    Assert.assertTrue((boolean)macs.contains(this.mac4));
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac7)) {
                    Assert.assertEquals((long)3L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getBridgeIdsOnSegment().contains(this.nodeDId));
                    Assert.assertEquals((Object)true, (Object)shared.getBridgeIdsOnSegment().contains(this.nodeEId));
                    Assert.assertEquals((Object)true, (Object)shared.getBridgeIdsOnSegment().contains(this.nodeFId));
                    Assert.assertEquals((long)2L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getMacsOnSegment().contains(this.mac8));
                    Assert.assertEquals((long)2L, (long)SharedSegment.getBridgeMacLinks((SharedSegment)shared).size());
                    Assert.assertEquals((long)2L, (long)SharedSegment.getBridgeBridgeLinks((SharedSegment)shared).size());
                    macs = new HashSet();
                    for (BridgeMacLink link : SharedSegment.getBridgeMacLinks((SharedSegment)shared)) {
                        Assert.assertEquals((long)this.nodeDId.intValue(), (long)link.getNode().getId().intValue());
                        Assert.assertEquals((Object)this.portDD, (Object)link.getBridgePort());
                        Assert.assertTrue((!macs.contains(link.getMacAddress()) ? 1 : 0) != 0);
                        Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link.getLinkType());
                        macs.add(link.getMacAddress());
                    }
                    Assert.assertTrue((boolean)macs.contains(this.mac7));
                    Assert.assertTrue((boolean)macs.contains(this.mac8));
                    continue;
                }
                Assert.assertEquals((Object)false, (Object)true);
            }
        }

        public void checkDEFG(BroadcastDomain domain) throws BridgeTopologyException {
            Assert.assertEquals((long)0L, (long)domain.getForwarders(this.nodeDId).size());
            Assert.assertEquals((long)0L, (long)domain.getForwarders(this.nodeEId).size());
            Assert.assertEquals((long)0L, (long)domain.getForwarders(this.nodeFId).size());
            Assert.assertEquals((long)0L, (long)domain.getForwarders(this.nodeGId).size());
            List shsegs = domain.getSharedSegments();
            Assert.assertEquals((long)8L, (long)shsegs.size());
            for (SharedSegment shared : shsegs) {
                HashSet<String> macs;
                BridgeBridgeLink link;
                if (shared.noMacsOnSegment()) {
                    Assert.assertEquals((long)2L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getBridgeIdsOnSegment().contains(this.nodeGId));
                    Assert.assertEquals((long)1L, (long)SharedSegment.getBridgeBridgeLinks((SharedSegment)shared).size());
                    Assert.assertEquals((long)0L, (long)SharedSegment.getBridgeMacLinks((SharedSegment)shared).size());
                    link = (BridgeBridgeLink)SharedSegment.getBridgeBridgeLinks((SharedSegment)shared).iterator().next();
                    if (shared.getBridgeIdsOnSegment().contains(this.nodeDId)) {
                        Assert.assertEquals((long)this.nodeDId.intValue(), (long)link.getDesignatedNode().getId().intValue());
                        Assert.assertEquals((Object)this.portDD, (Object)link.getDesignatedPort());
                        Assert.assertEquals((long)this.nodeGId.intValue(), (long)link.getNode().getId().intValue());
                        Assert.assertEquals((Object)this.portGD, (Object)link.getBridgePort());
                        continue;
                    }
                    if (shared.getBridgeIdsOnSegment().contains(this.nodeEId)) {
                        Assert.assertEquals((long)this.nodeEId.intValue(), (long)link.getNode().getId().intValue());
                        Assert.assertEquals((Object)this.portEE, (Object)link.getBridgePort());
                        Assert.assertEquals((long)this.nodeGId.intValue(), (long)link.getDesignatedNode().getId().intValue());
                        Assert.assertEquals((Object)this.portGE, (Object)link.getDesignatedPort());
                        continue;
                    }
                    if (shared.getBridgeIdsOnSegment().contains(this.nodeFId)) {
                        Assert.assertEquals((long)this.nodeFId.intValue(), (long)link.getNode().getId().intValue());
                        Assert.assertEquals((Object)this.portFF, (Object)link.getBridgePort());
                        Assert.assertEquals((long)this.nodeGId.intValue(), (long)link.getDesignatedNode().getId().intValue());
                        Assert.assertEquals((Object)this.portGF, (Object)link.getDesignatedPort());
                        continue;
                    }
                    Assert.assertEquals((Object)false, (Object)true);
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac1)) {
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((long)2L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getMacsOnSegment().contains(this.mac2));
                    Assert.assertEquals((long)2L, (long)SharedSegment.getBridgeMacLinks((SharedSegment)shared).size());
                    Assert.assertEquals((long)0L, (long)SharedSegment.getBridgeBridgeLinks((SharedSegment)shared).size());
                    Assert.assertEquals((long)this.nodeDId.intValue(), (long)shared.getDesignatedBridge().intValue());
                    Assert.assertEquals((long)this.portD.intValue(), (long)shared.getDesignatedPort().getBridgePort().intValue());
                    macs = new HashSet<String>();
                    for (BridgeMacLink link2 : SharedSegment.getBridgeMacLinks((SharedSegment)shared)) {
                        Assert.assertEquals((long)this.nodeDId.intValue(), (long)link2.getNode().getId().intValue());
                        Assert.assertEquals((Object)this.portD, (Object)link2.getBridgePort());
                        Assert.assertTrue((!macs.contains(link2.getMacAddress()) ? 1 : 0) != 0);
                        Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link2.getLinkType());
                        macs.add(link2.getMacAddress());
                    }
                    Assert.assertTrue((boolean)macs.contains(this.mac1));
                    Assert.assertTrue((boolean)macs.contains(this.mac2));
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac5)) {
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((long)2L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getMacsOnSegment().contains(this.mac6));
                    Assert.assertEquals((long)2L, (long)SharedSegment.getBridgeMacLinks((SharedSegment)shared).size());
                    Assert.assertEquals((long)0L, (long)SharedSegment.getBridgeBridgeLinks((SharedSegment)shared).size());
                    Assert.assertEquals((long)this.nodeEId.intValue(), (long)shared.getDesignatedBridge().intValue());
                    Assert.assertEquals((long)this.portE.intValue(), (long)shared.getDesignatedPort().getBridgePort().intValue());
                    macs = new HashSet();
                    for (BridgeMacLink link2 : SharedSegment.getBridgeMacLinks((SharedSegment)shared)) {
                        Assert.assertEquals((long)this.nodeEId.intValue(), (long)link2.getNode().getId().intValue());
                        Assert.assertEquals((Object)this.portE, (Object)link2.getBridgePort());
                        Assert.assertTrue((!macs.contains(link2.getMacAddress()) ? 1 : 0) != 0);
                        Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link2.getLinkType());
                        macs.add(link2.getMacAddress());
                    }
                    Assert.assertTrue((boolean)macs.contains(this.mac5));
                    Assert.assertTrue((boolean)macs.contains(this.mac6));
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac3)) {
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((long)2L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getMacsOnSegment().contains(this.mac4));
                    Assert.assertEquals((long)2L, (long)SharedSegment.getBridgeMacLinks((SharedSegment)shared).size());
                    Assert.assertEquals((long)0L, (long)SharedSegment.getBridgeBridgeLinks((SharedSegment)shared).size());
                    Assert.assertEquals((long)this.nodeFId.intValue(), (long)shared.getDesignatedBridge().intValue());
                    Assert.assertEquals((long)this.portF.intValue(), (long)shared.getDesignatedPort().getBridgePort().intValue());
                    macs = new HashSet();
                    for (BridgeMacLink link2 : SharedSegment.getBridgeMacLinks((SharedSegment)shared)) {
                        Assert.assertEquals((long)this.nodeFId.intValue(), (long)link2.getNode().getId().intValue());
                        Assert.assertEquals((Object)this.portF, (Object)link2.getBridgePort());
                        Assert.assertTrue((!macs.contains(link2.getMacAddress()) ? 1 : 0) != 0);
                        Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link2.getLinkType());
                        macs.add(link2.getMacAddress());
                    }
                    Assert.assertTrue((boolean)macs.contains(this.mac3));
                    Assert.assertTrue((boolean)macs.contains(this.mac4));
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac7)) {
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getBridgeIdsOnSegment().contains(this.nodeGId));
                    Assert.assertEquals((long)1L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((long)1L, (long)SharedSegment.getBridgeMacLinks((SharedSegment)shared).size());
                    Assert.assertEquals((long)0L, (long)SharedSegment.getBridgeBridgeLinks((SharedSegment)shared).size());
                    link = (BridgeMacLink)SharedSegment.getBridgeMacLinks((SharedSegment)shared).iterator().next();
                    Assert.assertEquals((long)this.nodeGId.intValue(), (long)link.getNode().getId().intValue());
                    Assert.assertEquals((long)this.portG7.intValue(), (long)link.getBridgePort().intValue());
                    Assert.assertEquals((Object)this.mac7, (Object)link.getMacAddress());
                    Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link.getLinkType());
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac8)) {
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getBridgeIdsOnSegment().contains(this.nodeGId));
                    Assert.assertEquals((long)1L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((long)1L, (long)SharedSegment.getBridgeMacLinks((SharedSegment)shared).size());
                    Assert.assertEquals((long)0L, (long)SharedSegment.getBridgeBridgeLinks((SharedSegment)shared).size());
                    link = (BridgeMacLink)SharedSegment.getBridgeMacLinks((SharedSegment)shared).iterator().next();
                    Assert.assertEquals((long)this.nodeGId.intValue(), (long)link.getNode().getId().intValue());
                    Assert.assertEquals((long)this.portG8.intValue(), (long)link.getBridgePort().intValue());
                    Assert.assertEquals((Object)this.mac8, (Object)link.getMacAddress());
                    Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link.getLinkType());
                    continue;
                }
                Assert.assertEquals((Object)false, (Object)true);
            }
        }

        public void check(BroadcastDomain domain) throws BridgeTopologyException {
            List shsegs = domain.getSharedSegments();
            Assert.assertEquals((long)14L, (long)shsegs.size());
            for (SharedSegment shared : shsegs) {
                BridgeBridgeLink link;
                if (shared.noMacsOnSegment()) {
                    Assert.assertEquals((long)2L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((long)1L, (long)SharedSegment.getBridgeBridgeLinks((SharedSegment)shared).size());
                    Assert.assertEquals((long)0L, (long)SharedSegment.getBridgeMacLinks((SharedSegment)shared).size());
                    link = (BridgeBridgeLink)SharedSegment.getBridgeBridgeLinks((SharedSegment)shared).iterator().next();
                    if (shared.getBridgeIdsOnSegment().contains(this.nodeDId) && shared.getDesignatedPort().getBridgePort().intValue() == this.portDD.intValue()) {
                        Assert.assertEquals((long)this.nodeDId.intValue(), (long)link.getDesignatedNode().getId().intValue());
                        Assert.assertEquals((Object)this.portDD, (Object)link.getDesignatedPort());
                        Assert.assertEquals((long)this.nodeGId.intValue(), (long)link.getNode().getId().intValue());
                        Assert.assertEquals((Object)this.portGD, (Object)link.getBridgePort());
                        continue;
                    }
                    if (shared.getBridgeIdsOnSegment().contains(this.nodeDId) && shared.getDesignatedPort().getBridgePort().intValue() == this.portD.intValue()) {
                        Assert.assertEquals((long)this.nodeDId.intValue(), (long)link.getDesignatedNode().getId().intValue());
                        Assert.assertEquals((Object)this.portD, (Object)link.getDesignatedPort());
                        Assert.assertEquals((long)this.nodeHId.intValue(), (long)link.getNode().getId().intValue());
                        Assert.assertEquals((Object)this.portHH, (Object)link.getBridgePort());
                        continue;
                    }
                    if (shared.getBridgeIdsOnSegment().contains(this.nodeGId) && shared.getDesignatedPort().getBridgePort().intValue() == this.portGE.intValue()) {
                        Assert.assertEquals((long)this.nodeEId.intValue(), (long)link.getNode().getId().intValue());
                        Assert.assertEquals((Object)this.portEE, (Object)link.getBridgePort());
                        Assert.assertEquals((long)this.nodeGId.intValue(), (long)link.getDesignatedNode().getId().intValue());
                        Assert.assertEquals((Object)this.portGE, (Object)link.getDesignatedPort());
                        continue;
                    }
                    if (shared.getBridgeIdsOnSegment().contains(this.nodeEId) && shared.getDesignatedPort().getBridgePort().intValue() == this.portE.intValue()) {
                        Assert.assertEquals((long)this.nodeEId.intValue(), (long)link.getDesignatedNode().getId().intValue());
                        Assert.assertEquals((Object)this.portE, (Object)link.getDesignatedPort());
                        Assert.assertEquals((long)this.nodeLId.intValue(), (long)link.getNode().getId().intValue());
                        Assert.assertEquals((Object)this.portLL, (Object)link.getBridgePort());
                        continue;
                    }
                    if (shared.getBridgeIdsOnSegment().contains(this.nodeGId) && shared.getDesignatedPort().getBridgePort().intValue() == this.portGF.intValue()) {
                        Assert.assertEquals((long)this.nodeFId.intValue(), (long)link.getNode().getId().intValue());
                        Assert.assertEquals((Object)this.portFF, (Object)link.getBridgePort());
                        Assert.assertEquals((long)this.nodeGId.intValue(), (long)link.getDesignatedNode().getId().intValue());
                        Assert.assertEquals((Object)this.portGF, (Object)link.getDesignatedPort());
                        continue;
                    }
                    if (shared.getBridgeIdsOnSegment().contains(this.nodeFId) && shared.getDesignatedPort().getBridgePort().intValue() == this.portF.intValue()) {
                        Assert.assertEquals((long)this.nodeFId.intValue(), (long)link.getDesignatedNode().getId().intValue());
                        Assert.assertEquals((Object)this.portF, (Object)link.getDesignatedPort());
                        Assert.assertEquals((long)this.nodeIId.intValue(), (long)link.getNode().getId().intValue());
                        Assert.assertEquals((Object)this.portII, (Object)link.getBridgePort());
                        continue;
                    }
                    Assert.assertEquals((Object)false, (Object)true);
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac1)) {
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getBridgeIdsOnSegment().contains(this.nodeHId));
                    Assert.assertEquals((long)1L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((long)1L, (long)SharedSegment.getBridgeMacLinks((SharedSegment)shared).size());
                    Assert.assertEquals((long)0L, (long)SharedSegment.getBridgeBridgeLinks((SharedSegment)shared).size());
                    Assert.assertEquals((long)this.nodeHId.intValue(), (long)shared.getDesignatedBridge().intValue());
                    Assert.assertEquals((long)this.portH1.intValue(), (long)shared.getDesignatedPort().getBridgePort().intValue());
                    link = (BridgeMacLink)SharedSegment.getBridgeMacLinks((SharedSegment)shared).iterator().next();
                    Assert.assertEquals((long)this.nodeHId.intValue(), (long)link.getNode().getId().intValue());
                    Assert.assertEquals((Object)this.portH1, (Object)link.getBridgePort());
                    Assert.assertEquals((Object)this.mac1, (Object)link.getMacAddress());
                    Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link.getLinkType());
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac2)) {
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getBridgeIdsOnSegment().contains(this.nodeHId));
                    Assert.assertEquals((long)1L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((long)1L, (long)SharedSegment.getBridgeMacLinks((SharedSegment)shared).size());
                    Assert.assertEquals((long)0L, (long)SharedSegment.getBridgeBridgeLinks((SharedSegment)shared).size());
                    Assert.assertEquals((long)this.nodeHId.intValue(), (long)shared.getDesignatedBridge().intValue());
                    Assert.assertEquals((long)this.portH2.intValue(), (long)shared.getDesignatedPort().getBridgePort().intValue());
                    link = (BridgeMacLink)SharedSegment.getBridgeMacLinks((SharedSegment)shared).iterator().next();
                    Assert.assertEquals((long)this.nodeHId.intValue(), (long)link.getNode().getId().intValue());
                    Assert.assertEquals((Object)this.portH2, (Object)link.getBridgePort());
                    Assert.assertEquals((Object)this.mac2, (Object)link.getMacAddress());
                    Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link.getLinkType());
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac3)) {
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getBridgeIdsOnSegment().contains(this.nodeIId));
                    Assert.assertEquals((long)1L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((long)1L, (long)SharedSegment.getBridgeMacLinks((SharedSegment)shared).size());
                    Assert.assertEquals((long)0L, (long)SharedSegment.getBridgeBridgeLinks((SharedSegment)shared).size());
                    Assert.assertEquals((long)this.nodeIId.intValue(), (long)shared.getDesignatedBridge().intValue());
                    Assert.assertEquals((long)this.portI3.intValue(), (long)shared.getDesignatedPort().getBridgePort().intValue());
                    link = (BridgeMacLink)SharedSegment.getBridgeMacLinks((SharedSegment)shared).iterator().next();
                    Assert.assertEquals((long)this.nodeIId.intValue(), (long)link.getNode().getId().intValue());
                    Assert.assertEquals((Object)this.portI3, (Object)link.getBridgePort());
                    Assert.assertEquals((Object)this.mac3, (Object)link.getMacAddress());
                    Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link.getLinkType());
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac4)) {
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getBridgeIdsOnSegment().contains(this.nodeIId));
                    Assert.assertEquals((long)1L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((long)1L, (long)SharedSegment.getBridgeMacLinks((SharedSegment)shared).size());
                    Assert.assertEquals((long)0L, (long)SharedSegment.getBridgeBridgeLinks((SharedSegment)shared).size());
                    Assert.assertEquals((long)this.nodeIId.intValue(), (long)shared.getDesignatedBridge().intValue());
                    Assert.assertEquals((long)this.portI4.intValue(), (long)shared.getDesignatedPort().getBridgePort().intValue());
                    link = (BridgeMacLink)SharedSegment.getBridgeMacLinks((SharedSegment)shared).iterator().next();
                    Assert.assertEquals((long)this.nodeIId.intValue(), (long)link.getNode().getId().intValue());
                    Assert.assertEquals((Object)this.portI4, (Object)link.getBridgePort());
                    Assert.assertEquals((Object)this.mac4, (Object)link.getMacAddress());
                    Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link.getLinkType());
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac5)) {
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getBridgeIdsOnSegment().contains(this.nodeLId));
                    Assert.assertEquals((long)1L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((long)1L, (long)SharedSegment.getBridgeMacLinks((SharedSegment)shared).size());
                    Assert.assertEquals((long)0L, (long)SharedSegment.getBridgeBridgeLinks((SharedSegment)shared).size());
                    Assert.assertEquals((long)this.nodeLId.intValue(), (long)shared.getDesignatedBridge().intValue());
                    Assert.assertEquals((long)this.portL5.intValue(), (long)shared.getDesignatedPort().getBridgePort().intValue());
                    link = (BridgeMacLink)SharedSegment.getBridgeMacLinks((SharedSegment)shared).iterator().next();
                    Assert.assertEquals((long)this.nodeLId.intValue(), (long)link.getNode().getId().intValue());
                    Assert.assertEquals((Object)this.portL5, (Object)link.getBridgePort());
                    Assert.assertEquals((Object)this.mac5, (Object)link.getMacAddress());
                    Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link.getLinkType());
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac6)) {
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getBridgeIdsOnSegment().contains(this.nodeLId));
                    Assert.assertEquals((long)1L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((long)1L, (long)SharedSegment.getBridgeMacLinks((SharedSegment)shared).size());
                    Assert.assertEquals((long)0L, (long)SharedSegment.getBridgeBridgeLinks((SharedSegment)shared).size());
                    Assert.assertEquals((long)this.nodeLId.intValue(), (long)shared.getDesignatedBridge().intValue());
                    Assert.assertEquals((long)this.portL6.intValue(), (long)shared.getDesignatedPort().getBridgePort().intValue());
                    link = (BridgeMacLink)SharedSegment.getBridgeMacLinks((SharedSegment)shared).iterator().next();
                    Assert.assertEquals((long)this.nodeLId.intValue(), (long)link.getNode().getId().intValue());
                    Assert.assertEquals((Object)this.portL6, (Object)link.getBridgePort());
                    Assert.assertEquals((Object)this.mac6, (Object)link.getMacAddress());
                    Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link.getLinkType());
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac7)) {
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getBridgeIdsOnSegment().contains(this.nodeGId));
                    Assert.assertEquals((long)1L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((long)1L, (long)SharedSegment.getBridgeMacLinks((SharedSegment)shared).size());
                    Assert.assertEquals((long)0L, (long)SharedSegment.getBridgeBridgeLinks((SharedSegment)shared).size());
                    link = (BridgeMacLink)SharedSegment.getBridgeMacLinks((SharedSegment)shared).iterator().next();
                    Assert.assertEquals((long)this.nodeGId.intValue(), (long)link.getNode().getId().intValue());
                    Assert.assertEquals((long)this.portG7.intValue(), (long)link.getBridgePort().intValue());
                    Assert.assertEquals((Object)this.mac7, (Object)link.getMacAddress());
                    Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link.getLinkType());
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac8)) {
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getBridgeIdsOnSegment().contains(this.nodeGId));
                    Assert.assertEquals((long)1L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((long)1L, (long)SharedSegment.getBridgeMacLinks((SharedSegment)shared).size());
                    Assert.assertEquals((long)0L, (long)SharedSegment.getBridgeBridgeLinks((SharedSegment)shared).size());
                    link = (BridgeMacLink)SharedSegment.getBridgeMacLinks((SharedSegment)shared).iterator().next();
                    Assert.assertEquals((long)this.nodeGId.intValue(), (long)link.getNode().getId().intValue());
                    Assert.assertEquals((long)this.portG8.intValue(), (long)link.getBridgePort().intValue());
                    Assert.assertEquals((Object)this.mac8, (Object)link.getMacAddress());
                    Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link.getLinkType());
                    continue;
                }
                Assert.assertEquals((Object)false, (Object)true);
            }
        }
    }

    class ABCTopology {
        Integer nodeAId = 101;
        Integer nodeBId = 102;
        Integer nodeCId = 103;
        OnmsNode nodeA = new OnmsNode();
        OnmsNode nodeB = new OnmsNode();
        OnmsNode nodeC = new OnmsNode();
        BridgeElement elementA = new BridgeElement();
        BridgeElement elementB = new BridgeElement();
        BridgeElement elementC = new BridgeElement();
        List<BridgeElement> elemlist = new ArrayList<BridgeElement>();
        Set<BridgeForwardingTableEntry> bftA = new HashSet<BridgeForwardingTableEntry>();
        Set<BridgeForwardingTableEntry> bftB = new HashSet<BridgeForwardingTableEntry>();
        Set<BridgeForwardingTableEntry> bftC = new HashSet<BridgeForwardingTableEntry>();
        Integer portA = 1;
        Integer portAB = 12;
        Integer portBA = 21;
        Integer portB = 2;
        Integer portBC = 23;
        Integer portCB = 32;
        Integer portC = 3;
        String mac1 = "000daaaa0101";
        String mac2 = "000daaaa0202";
        String mac3 = "000daaaa0303";
        String shar = "000daaaa1111";
        String macA = "aaaaaaaaaaaa";
        String macB = "bbbbbbbbbbbb";
        String macC = "cccccccccccc";

        public ABCTopology() {
            this.nodeA.setId(this.nodeAId);
            this.elementA.setNode(this.nodeA);
            this.elementA.setBaseBridgeAddress(this.macA);
            this.elemlist.add(this.elementA);
            this.nodeB.setId(this.nodeBId);
            this.elementB.setNode(this.nodeB);
            this.elementB.setBaseBridgeAddress(this.macB);
            this.elemlist.add(this.elementB);
            this.nodeC.setId(this.nodeCId);
            this.elementC.setNode(this.nodeC);
            this.elementC.setBaseBridgeAddress(this.macC);
            this.elemlist.add(this.elementC);
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA, this.mac1));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portAB, this.mac2));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portAB, this.mac3));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portBA, this.mac1));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portB, this.mac2));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portBC, this.mac3));
            this.bftC.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeC, this.portCB, this.mac1));
            this.bftC.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeC, this.portCB, this.mac2));
            this.bftC.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeC, this.portC, this.mac3));
        }

        public void checkAC(BroadcastDomain domain) throws BridgeTopologyException {
            Assert.assertEquals((long)0L, (long)domain.getForwarders(this.nodeAId).size());
            Assert.assertEquals((long)0L, (long)domain.getForwarders(this.nodeCId).size());
            List shsegms = domain.getSharedSegments();
            Assert.assertEquals((long)3L, (long)shsegms.size());
            for (SharedSegment shared : shsegms) {
                BridgeMacLink link;
                List links = SharedSegment.getBridgeMacLinks((SharedSegment)shared);
                List bblinks = SharedSegment.getBridgeBridgeLinks((SharedSegment)shared);
                if (shared.getMacsOnSegment().contains(this.mac1)) {
                    Assert.assertEquals((long)0L, (long)bblinks.size());
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((long)1L, (long)links.size());
                    Assert.assertEquals((Object)this.nodeAId, (Object)shared.getDesignatedBridge());
                    Assert.assertEquals((Object)this.portA, (Object)shared.getDesignatedPort().getBridgePort());
                    Assert.assertTrue((!shared.noMacsOnSegment() ? 1 : 0) != 0);
                    link = (BridgeMacLink)links.iterator().next();
                    Assert.assertEquals((Object)this.nodeAId, (Object)link.getNode().getId());
                    Assert.assertEquals((Object)this.portA, (Object)link.getBridgePort());
                    Assert.assertEquals((Object)this.mac1, (Object)link.getMacAddress());
                    Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link.getLinkType());
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac2)) {
                    Assert.assertEquals((long)1L, (long)bblinks.size());
                    Assert.assertEquals((long)2L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((long)1L, (long)links.size());
                    Assert.assertTrue((!shared.noMacsOnSegment() ? 1 : 0) != 0);
                    link = (BridgeMacLink)links.iterator().next();
                    Assert.assertEquals((Object)this.mac2, (Object)link.getMacAddress());
                    Assert.assertEquals((Object)this.nodeAId, (Object)link.getNode().getId());
                    Assert.assertEquals((Object)this.portAB, (Object)link.getBridgePort());
                    Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link.getLinkType());
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac3)) {
                    Assert.assertEquals((long)0L, (long)bblinks.size());
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((long)1L, (long)links.size());
                    Assert.assertEquals((Object)this.nodeCId, (Object)shared.getDesignatedBridge());
                    Assert.assertEquals((Object)this.portC, (Object)shared.getDesignatedPort().getBridgePort());
                    Assert.assertTrue((!shared.noMacsOnSegment() ? 1 : 0) != 0);
                    link = (BridgeMacLink)links.iterator().next();
                    Assert.assertEquals((Object)this.nodeCId, (Object)link.getNode().getId());
                    Assert.assertEquals((Object)this.portC, (Object)link.getBridgePort());
                    Assert.assertEquals((Object)this.mac3, (Object)link.getMacAddress());
                    Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link.getLinkType());
                    continue;
                }
                Assert.assertEquals((Object)false, (Object)true);
            }
        }

        public void checkAB(BroadcastDomain domain) throws BridgeTopologyException {
            Assert.assertEquals((long)0L, (long)domain.getForwarders(this.nodeAId).size());
            Assert.assertEquals((long)0L, (long)domain.getForwarders(this.nodeBId).size());
            List shsegms = domain.getSharedSegments();
            Assert.assertEquals((long)4L, (long)shsegms.size());
            for (SharedSegment shared : shsegms) {
                BridgeMacLink link;
                List links = SharedSegment.getBridgeMacLinks((SharedSegment)shared);
                List bblinks = SharedSegment.getBridgeBridgeLinks((SharedSegment)shared);
                if (shared.noMacsOnSegment()) {
                    Assert.assertEquals((long)2L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((long)0L, (long)links.size());
                    Assert.assertEquals((long)1L, (long)bblinks.size());
                    BridgeBridgeLink bblink = (BridgeBridgeLink)bblinks.iterator().next();
                    Assert.assertEquals((Object)this.nodeAId, (Object)bblink.getDesignatedNode().getId());
                    Assert.assertEquals((Object)this.nodeBId, (Object)bblink.getNode().getId());
                    Assert.assertEquals((Object)this.portAB, (Object)bblink.getDesignatedPort());
                    Assert.assertEquals((Object)this.portBA, (Object)bblink.getBridgePort());
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac1)) {
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((long)1L, (long)links.size());
                    Assert.assertEquals((Object)this.nodeAId, (Object)shared.getDesignatedBridge());
                    Assert.assertEquals((Object)this.portA, (Object)shared.getDesignatedPort().getBridgePort());
                    Assert.assertTrue((!shared.noMacsOnSegment() ? 1 : 0) != 0);
                    link = (BridgeMacLink)links.iterator().next();
                    Assert.assertEquals((Object)this.nodeAId, (Object)link.getNode().getId());
                    Assert.assertEquals((Object)this.portA, (Object)link.getBridgePort());
                    Assert.assertEquals((Object)this.mac1, (Object)link.getMacAddress());
                    Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link.getLinkType());
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac2)) {
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((long)1L, (long)links.size());
                    Assert.assertEquals((Object)this.nodeBId, (Object)shared.getDesignatedBridge());
                    Assert.assertEquals((Object)this.portB, (Object)shared.getDesignatedPort().getBridgePort());
                    Assert.assertTrue((!shared.noMacsOnSegment() ? 1 : 0) != 0);
                    link = (BridgeMacLink)links.iterator().next();
                    Assert.assertEquals((Object)this.nodeBId, (Object)link.getNode().getId());
                    Assert.assertEquals((Object)this.portB, (Object)link.getBridgePort());
                    Assert.assertEquals((Object)this.mac2, (Object)link.getMacAddress());
                    Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link.getLinkType());
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac3)) {
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((long)1L, (long)links.size());
                    Assert.assertEquals((Object)this.nodeBId, (Object)shared.getDesignatedBridge());
                    Assert.assertEquals((Object)this.portBC, (Object)shared.getDesignatedPort().getBridgePort());
                    Assert.assertTrue((!shared.noMacsOnSegment() ? 1 : 0) != 0);
                    link = (BridgeMacLink)links.iterator().next();
                    Assert.assertEquals((Object)this.nodeBId, (Object)link.getNode().getId());
                    Assert.assertEquals((Object)this.portBC, (Object)link.getBridgePort());
                    Assert.assertEquals((Object)this.mac3, (Object)link.getMacAddress());
                    Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link.getLinkType());
                    continue;
                }
                Assert.assertEquals((Object)false, (Object)true);
            }
        }

        public void checkBC(BroadcastDomain domain) throws BridgeTopologyException {
            Assert.assertEquals((long)0L, (long)domain.getForwarders(this.nodeCId).size());
            Assert.assertEquals((long)0L, (long)domain.getForwarders(this.nodeBId).size());
            List shsegms = domain.getSharedSegments();
            Assert.assertEquals((long)4L, (long)shsegms.size());
            for (SharedSegment shared : shsegms) {
                BridgeMacLink link;
                List links = SharedSegment.getBridgeMacLinks((SharedSegment)shared);
                List bblinks = SharedSegment.getBridgeBridgeLinks((SharedSegment)shared);
                if (shared.noMacsOnSegment()) {
                    Assert.assertEquals((long)2L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((long)0L, (long)links.size());
                    Assert.assertEquals((long)1L, (long)bblinks.size());
                    BridgeBridgeLink bblink = (BridgeBridgeLink)bblinks.iterator().next();
                    Assert.assertEquals((Object)this.nodeBId, (Object)bblink.getDesignatedNode().getId());
                    Assert.assertEquals((Object)this.nodeCId, (Object)bblink.getNode().getId());
                    Assert.assertEquals((Object)this.portBC, (Object)bblink.getDesignatedPort());
                    Assert.assertEquals((Object)this.portCB, (Object)bblink.getBridgePort());
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac1)) {
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((long)1L, (long)links.size());
                    Assert.assertEquals((Object)this.nodeBId, (Object)shared.getDesignatedBridge());
                    Assert.assertEquals((Object)this.portBA, (Object)shared.getDesignatedPort().getBridgePort());
                    Assert.assertTrue((!shared.noMacsOnSegment() ? 1 : 0) != 0);
                    link = (BridgeMacLink)links.iterator().next();
                    Assert.assertEquals((Object)this.nodeBId, (Object)link.getNode().getId());
                    Assert.assertEquals((Object)this.portBA, (Object)link.getBridgePort());
                    Assert.assertEquals((Object)this.mac1, (Object)link.getMacAddress());
                    Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link.getLinkType());
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac2)) {
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((long)1L, (long)links.size());
                    Assert.assertEquals((Object)this.nodeBId, (Object)shared.getDesignatedBridge());
                    Assert.assertEquals((Object)this.portB, (Object)shared.getDesignatedPort().getBridgePort());
                    Assert.assertTrue((!shared.noMacsOnSegment() ? 1 : 0) != 0);
                    link = (BridgeMacLink)links.iterator().next();
                    Assert.assertEquals((Object)this.nodeBId, (Object)link.getNode().getId());
                    Assert.assertEquals((Object)this.portB, (Object)link.getBridgePort());
                    Assert.assertEquals((Object)this.mac2, (Object)link.getMacAddress());
                    Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link.getLinkType());
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac3)) {
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((long)1L, (long)links.size());
                    Assert.assertEquals((Object)this.nodeCId, (Object)shared.getDesignatedBridge());
                    Assert.assertEquals((Object)this.portC, (Object)shared.getDesignatedPort().getBridgePort());
                    Assert.assertTrue((!shared.noMacsOnSegment() ? 1 : 0) != 0);
                    link = (BridgeMacLink)links.iterator().next();
                    Assert.assertEquals((Object)this.nodeCId, (Object)link.getNode().getId());
                    Assert.assertEquals((Object)this.portC, (Object)link.getBridgePort());
                    Assert.assertEquals((Object)this.mac3, (Object)link.getMacAddress());
                    Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link.getLinkType());
                    continue;
                }
                Assert.assertEquals((Object)false, (Object)true);
            }
        }

        public void check(BroadcastDomain domain) throws BridgeTopologyException {
            Assert.assertEquals((long)0L, (long)domain.getForwarders(this.nodeCId).size());
            Assert.assertEquals((long)0L, (long)domain.getForwarders(this.nodeBId).size());
            Assert.assertEquals((long)0L, (long)domain.getForwarders(this.nodeAId).size());
            List shsegms = domain.getSharedSegments();
            Assert.assertEquals((long)5L, (long)shsegms.size());
            for (SharedSegment shared : shsegms) {
                BridgeMacLink link;
                List links = SharedSegment.getBridgeMacLinks((SharedSegment)shared);
                List bblinks = SharedSegment.getBridgeBridgeLinks((SharedSegment)shared);
                if (shared.noMacsOnSegment()) {
                    Assert.assertEquals((long)2L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((long)0L, (long)links.size());
                    Assert.assertEquals((long)1L, (long)bblinks.size());
                    BridgeBridgeLink bblink = (BridgeBridgeLink)bblinks.iterator().next();
                    if (bblink.getDesignatedNode().getId() == this.nodeAId) {
                        Assert.assertEquals((Object)this.nodeBId, (Object)bblink.getNode().getId());
                        Assert.assertEquals((Object)this.nodeAId, (Object)bblink.getDesignatedNode().getId());
                        Assert.assertEquals((Object)this.portBA, (Object)bblink.getBridgePort());
                        Assert.assertEquals((Object)this.portAB, (Object)bblink.getDesignatedPort());
                        continue;
                    }
                    if (bblink.getDesignatedNode().getId() == this.nodeBId) {
                        Assert.assertEquals((Object)this.nodeCId, (Object)bblink.getNode().getId());
                        Assert.assertEquals((Object)this.nodeBId, (Object)bblink.getDesignatedNode().getId());
                        Assert.assertEquals((Object)this.portCB, (Object)bblink.getBridgePort());
                        Assert.assertEquals((Object)this.portBC, (Object)bblink.getDesignatedPort());
                        continue;
                    }
                    Assert.assertEquals((Object)false, (Object)true);
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac1)) {
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((long)1L, (long)links.size());
                    Assert.assertEquals((Object)this.nodeAId, (Object)shared.getDesignatedBridge());
                    Assert.assertEquals((Object)this.portA, (Object)shared.getDesignatedPort().getBridgePort());
                    Assert.assertTrue((!shared.noMacsOnSegment() ? 1 : 0) != 0);
                    link = (BridgeMacLink)links.iterator().next();
                    Assert.assertEquals((Object)this.nodeAId, (Object)link.getNode().getId());
                    Assert.assertEquals((Object)this.portA, (Object)link.getBridgePort());
                    Assert.assertEquals((Object)this.mac1, (Object)link.getMacAddress());
                    Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link.getLinkType());
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac2)) {
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((long)1L, (long)links.size());
                    Assert.assertEquals((Object)this.nodeBId, (Object)shared.getDesignatedBridge());
                    Assert.assertEquals((Object)this.portB, (Object)shared.getDesignatedPort().getBridgePort());
                    Assert.assertTrue((!shared.noMacsOnSegment() ? 1 : 0) != 0);
                    link = (BridgeMacLink)links.iterator().next();
                    Assert.assertEquals((Object)this.nodeBId, (Object)link.getNode().getId());
                    Assert.assertEquals((Object)this.portB, (Object)link.getBridgePort());
                    Assert.assertEquals((Object)this.mac2, (Object)link.getMacAddress());
                    Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link.getLinkType());
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac3)) {
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((long)1L, (long)links.size());
                    Assert.assertEquals((Object)this.nodeCId, (Object)shared.getDesignatedBridge());
                    Assert.assertEquals((Object)this.portC, (Object)shared.getDesignatedPort().getBridgePort());
                    Assert.assertTrue((!shared.noMacsOnSegment() ? 1 : 0) != 0);
                    link = (BridgeMacLink)links.iterator().next();
                    Assert.assertEquals((Object)this.nodeCId, (Object)link.getNode().getId());
                    Assert.assertEquals((Object)this.portC, (Object)link.getBridgePort());
                    Assert.assertEquals((Object)this.mac3, (Object)link.getMacAddress());
                    Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link.getLinkType());
                    continue;
                }
                Assert.assertEquals((Object)false, (Object)true);
            }
        }

        public void checkwithshared(BroadcastDomain domain) throws BridgeTopologyException {
            Assert.assertEquals((long)0L, (long)domain.getForwarders(this.nodeAId).size());
            Assert.assertEquals((long)0L, (long)domain.getForwarders(this.nodeCId).size());
            Assert.assertEquals((long)1L, (long)domain.getForwarders(this.nodeBId).size());
            BridgePortWithMacs forwentry = (BridgePortWithMacs)domain.getForwarders(this.nodeBId).iterator().next();
            Assert.assertEquals((long)this.nodeBId.intValue(), (long)forwentry.getPort().getNodeId().intValue());
            Assert.assertEquals((long)this.portBA.intValue(), (long)forwentry.getPort().getBridgePort().intValue());
            Assert.assertEquals((long)1L, (long)forwentry.getMacs().size());
            Assert.assertEquals((Object)this.macA, forwentry.getMacs().iterator().next());
            List shsegms = domain.getSharedSegments();
            Assert.assertEquals((long)5L, (long)shsegms.size());
            for (SharedSegment shared : shsegms) {
                BridgeMacLink link;
                BridgeBridgeLink bblink;
                List links = SharedSegment.getBridgeMacLinks((SharedSegment)shared);
                List bblinks = SharedSegment.getBridgeBridgeLinks((SharedSegment)shared);
                if (shared.noMacsOnSegment()) {
                    Assert.assertEquals((long)2L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((long)0L, (long)links.size());
                    Assert.assertEquals((long)1L, (long)bblinks.size());
                    bblink = (BridgeBridgeLink)bblinks.iterator().next();
                    if (bblink.getDesignatedNode().getId() == this.nodeAId) {
                        Assert.assertEquals((Object)this.nodeAId, (Object)bblink.getDesignatedNode().getId());
                        Assert.assertEquals((Object)this.nodeBId, (Object)bblink.getNode().getId());
                        Assert.assertEquals((Object)this.portBA, (Object)bblink.getBridgePort());
                        Assert.assertEquals((Object)this.portAB, (Object)bblink.getDesignatedPort());
                        continue;
                    }
                    Assert.assertEquals((Object)false, (Object)true);
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.shar)) {
                    Assert.assertEquals((long)2L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((long)1L, (long)links.size());
                    Assert.assertEquals((long)1L, (long)bblinks.size());
                    Assert.assertEquals((long)1L, (long)shared.getMacsOnSegment().size());
                    bblink = (BridgeBridgeLink)bblinks.iterator().next();
                    Assert.assertEquals((Object)this.nodeCId, (Object)bblink.getNode().getId());
                    Assert.assertEquals((Object)this.nodeBId, (Object)bblink.getDesignatedNode().getId());
                    Assert.assertEquals((Object)this.portCB, (Object)bblink.getBridgePort());
                    Assert.assertEquals((Object)this.portBC, (Object)bblink.getDesignatedPort());
                    BridgeMacLink link2 = (BridgeMacLink)links.iterator().next();
                    Assert.assertEquals((Object)this.nodeBId, (Object)link2.getNode().getId());
                    Assert.assertEquals((Object)this.portBC, (Object)link2.getBridgePort());
                    Assert.assertEquals((Object)this.shar, (Object)link2.getMacAddress());
                    Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link2.getLinkType());
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac1)) {
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((long)1L, (long)links.size());
                    Assert.assertEquals((long)0L, (long)bblinks.size());
                    Assert.assertEquals((Object)this.nodeAId, (Object)shared.getDesignatedBridge());
                    Assert.assertEquals((Object)this.portA, (Object)shared.getDesignatedPort().getBridgePort());
                    Assert.assertTrue((!shared.noMacsOnSegment() ? 1 : 0) != 0);
                    link = (BridgeMacLink)links.iterator().next();
                    Assert.assertEquals((Object)this.nodeAId, (Object)link.getNode().getId());
                    Assert.assertEquals((Object)this.portA, (Object)link.getBridgePort());
                    Assert.assertEquals((Object)this.mac1, (Object)link.getMacAddress());
                    Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link.getLinkType());
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac2)) {
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((long)1L, (long)links.size());
                    Assert.assertEquals((long)0L, (long)bblinks.size());
                    Assert.assertEquals((Object)this.nodeBId, (Object)shared.getDesignatedBridge());
                    Assert.assertEquals((Object)this.portB, (Object)shared.getDesignatedPort().getBridgePort());
                    Assert.assertTrue((!shared.noMacsOnSegment() ? 1 : 0) != 0);
                    link = (BridgeMacLink)links.iterator().next();
                    Assert.assertEquals((Object)this.nodeBId, (Object)link.getNode().getId());
                    Assert.assertEquals((Object)this.portB, (Object)link.getBridgePort());
                    Assert.assertEquals((Object)this.mac2, (Object)link.getMacAddress());
                    Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link.getLinkType());
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac3)) {
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((long)1L, (long)links.size());
                    Assert.assertEquals((long)0L, (long)bblinks.size());
                    Assert.assertEquals((Object)this.nodeCId, (Object)shared.getDesignatedBridge());
                    Assert.assertEquals((Object)this.portC, (Object)shared.getDesignatedPort().getBridgePort());
                    Assert.assertTrue((!shared.noMacsOnSegment() ? 1 : 0) != 0);
                    link = (BridgeMacLink)links.iterator().next();
                    Assert.assertEquals((Object)this.nodeCId, (Object)link.getNode().getId());
                    Assert.assertEquals((Object)this.portC, (Object)link.getBridgePort());
                    Assert.assertEquals((Object)this.mac3, (Object)link.getMacAddress());
                    Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)link.getLinkType());
                    continue;
                }
                Assert.assertEquals((Object)false, (Object)true);
            }
        }
    }

    class FiveSwitchTopology {
        final int nodeAId = 1;
        final int nodeBId = 2;
        final int nodeCId = 3;
        final int nodeDId = 6;
        final int nodeEId = 8;
        OnmsNode nodeA = new OnmsNode();
        OnmsNode nodeB = new OnmsNode();
        OnmsNode nodeC = new OnmsNode();
        OnmsNode nodeD = new OnmsNode();
        OnmsNode nodeE = new OnmsNode();
        BridgeElement elementA = new BridgeElement();
        BridgeElement elementB = new BridgeElement();
        BridgeElement elementC = new BridgeElement();
        BridgeElement elementD = new BridgeElement();
        BridgeElement elementE = new BridgeElement();
        List<BridgeElement> elemlist = new ArrayList<BridgeElement>();
        Set<BridgeForwardingTableEntry> bftA = new HashSet<BridgeForwardingTableEntry>();
        Set<BridgeForwardingTableEntry> bftB = new HashSet<BridgeForwardingTableEntry>();
        Set<BridgeForwardingTableEntry> bftC = new HashSet<BridgeForwardingTableEntry>();
        Set<BridgeForwardingTableEntry> bftD = new HashSet<BridgeForwardingTableEntry>();
        Set<BridgeForwardingTableEntry> bftE = new HashSet<BridgeForwardingTableEntry>();
        String[] macsonAport4 = new String[]{"a04aee425191"};
        String[] macsonAport5 = new String[]{"a05a99b52703", "a05a99b52749"};
        String[] macsonAport52 = new String[]{"a52a01030104", "a52a84f84401", "a52a29f49b80", "a52aed30816a", "a52a6d0e9976"};
        String[] macsonBport3 = new String[]{"b03b63010d4f"};
        String[] macsonBport4 = new String[]{"b04b427bfee3", "b04b42f213af", "b04b6301050f"};
        String[] macsonCport19 = new String[]{"c19c822458d2"};
        String[] macsonCport24 = new String[]{"c24c83f6120a"};
        String[] macsonEport23 = new String[]{"e23e454ac907"};
        String[] macsOnWirelessSegment = new String[]{"000c429e3f3d", "000c42ef1df6", "000c42ef1e02", "000c42f5d30a", "0012cf68f80f", "001d454777dc", "001d71d5e4e7", "0021a4357254", "00641393f352", "00ca6d147c96", "00ca6d69c484", "00ca6d82ab08", "00ca6d88234f", "00ca6d954b3b", "00ca6da2d626", "00ca6ded84c8", "00ca6ded84d6", "00ca6dedd059", "00ca6df7f801", "008d8cf63372"};
        String[] forwardersABCD = new String[]{"fabcd57fd894"};
        String[] forwardersABD = new String[]{"fabd0f68f800", "fabd03010792"};
        String[] forwardersBE = new String[]{"fbe0b1bd265e"};
        String[] forwardersD = new String[]{"fd00b1bd2f5e"};
        String[] forwardersE = new String[]{"fe00b1bd2f5f", "fe0042db4e11"};
        String macA = "aaaa005b2980";
        String macB = "bbbb00bd2f5c";
        String macC = "cccc00bd2652";
        String macD = "dddd005d2120";
        String macE = "eeee03f4ee00";

        public FiveSwitchTopology() {
            this.nodeA.setId(Integer.valueOf(1));
            this.elementA.setNode(this.nodeA);
            this.elementA.setBaseBridgeAddress(this.macA);
            this.elemlist.add(this.elementA);
            this.nodeB.setId(Integer.valueOf(2));
            this.elementB.setNode(this.nodeB);
            this.elementB.setBaseBridgeAddress(this.macB);
            this.elemlist.add(this.elementB);
            this.nodeC.setId(Integer.valueOf(3));
            this.elementC.setNode(this.nodeC);
            this.elementC.setBaseBridgeAddress(this.macC);
            this.elemlist.add(this.elementC);
            this.nodeD.setId(Integer.valueOf(6));
            this.elementD.setNode(this.nodeD);
            this.elementD.setBaseBridgeAddress(this.macD);
            this.elemlist.add(this.elementD);
            this.nodeE.setId(Integer.valueOf(8));
            this.elementE.setNode(this.nodeE);
            this.elementE.setBaseBridgeAddress(this.macE);
            this.elemlist.add(this.elementE);
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, (Integer)1, 1001, this.macsonAport52[0]));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, (Integer)1, 1001, this.macsonAport52[2]));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, (Integer)1, 1001, this.macsonAport52[4]));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, (Integer)2, 1002, this.macE));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, (Integer)2, 1002, this.macC));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, (Integer)2, 1002, this.forwardersABD[0]));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, (Integer)2, 1002, this.forwardersABD[1]));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, (Integer)2, 1002, this.forwardersABCD[0]));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, (Integer)2, 1002, this.forwardersBE[0]));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, (Integer)2, 1002, this.macsOnWirelessSegment[0]));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, (Integer)2, 1002, this.macsOnWirelessSegment[1]));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, (Integer)2, 1002, this.macsOnWirelessSegment[2]));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, (Integer)2, 1002, this.macsOnWirelessSegment[3]));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, (Integer)2, 1002, this.macsOnWirelessSegment[4]));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, (Integer)2, 1002, this.macsOnWirelessSegment[5]));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, (Integer)2, 1002, this.macsOnWirelessSegment[6]));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, (Integer)2, 1002, this.macsOnWirelessSegment[7]));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, (Integer)2, 1002, this.macsOnWirelessSegment[8]));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, (Integer)2, 1002, this.macsOnWirelessSegment[9]));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, (Integer)2, 1002, this.macsOnWirelessSegment[10]));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, (Integer)2, 1002, this.macsOnWirelessSegment[11]));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, (Integer)2, 1002, this.macsOnWirelessSegment[12]));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, (Integer)2, 1002, this.macsOnWirelessSegment[13]));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, (Integer)2, 1002, this.macsOnWirelessSegment[14]));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, (Integer)2, 1002, this.macsOnWirelessSegment[15]));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, (Integer)2, 1002, this.macsOnWirelessSegment[16]));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, (Integer)2, 1002, this.macsOnWirelessSegment[17]));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, (Integer)2, 1002, this.macsOnWirelessSegment[18]));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, (Integer)2, 1002, this.macsOnWirelessSegment[19]));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, (Integer)2, 1002, this.macsonCport19[0]));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, (Integer)2, 1002, this.macsonCport24[0]));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, (Integer)2, 1002, this.macsonEport23[0]));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, (Integer)3, 1003, this.macsonBport3[0]));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, (Integer)4, 1004, this.macsonBport4[0]));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, (Integer)4, 1004, this.macsonBport4[1]));
            this.bftB.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, (Integer)4, 1004, this.macsonBport4[2]));
            this.bftC.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeC, (Integer)11, 1011, this.macB));
            this.bftC.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeC, (Integer)11, 1011, this.forwardersABCD[0]));
            this.bftC.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeC, (Integer)11, 1011, this.macsonEport23[0]));
            this.bftC.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeC, (Integer)11, 1011, this.macsonAport52[0]));
            this.bftC.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeC, (Integer)11, 1011, this.macsonAport52[2]));
            this.bftC.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeC, (Integer)11, 1011, this.macsonAport52[4]));
            this.bftC.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeC, (Integer)11, 1011, this.macsOnWirelessSegment[0]));
            this.bftC.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeC, (Integer)11, 1011, this.macsOnWirelessSegment[1]));
            this.bftC.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeC, (Integer)11, 1011, this.macsOnWirelessSegment[2]));
            this.bftC.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeC, (Integer)11, 1011, this.macsOnWirelessSegment[3]));
            this.bftC.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeC, (Integer)11, 1011, this.macsOnWirelessSegment[4]));
            this.bftC.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeC, (Integer)11, 1011, this.macsOnWirelessSegment[5]));
            this.bftC.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeC, (Integer)11, 1011, this.macsOnWirelessSegment[6]));
            this.bftC.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeC, (Integer)11, 1011, this.macsOnWirelessSegment[7]));
            this.bftC.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeC, (Integer)11, 1011, this.macsOnWirelessSegment[8]));
            this.bftC.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeC, (Integer)11, 1011, this.macsOnWirelessSegment[9]));
            this.bftC.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeC, (Integer)11, 1011, this.macsOnWirelessSegment[10]));
            this.bftC.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeC, (Integer)11, 1011, this.macsOnWirelessSegment[11]));
            this.bftC.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeC, (Integer)11, 1011, this.macsOnWirelessSegment[12]));
            this.bftC.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeC, (Integer)11, 1011, this.macsOnWirelessSegment[13]));
            this.bftC.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeC, (Integer)11, 1011, this.macsOnWirelessSegment[14]));
            this.bftC.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeC, (Integer)11, 1011, this.macsOnWirelessSegment[15]));
            this.bftC.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeC, (Integer)11, 1011, this.macsOnWirelessSegment[16]));
            this.bftC.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeC, (Integer)11, 1011, this.macsOnWirelessSegment[17]));
            this.bftC.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeC, (Integer)11, 1011, this.macsOnWirelessSegment[18]));
            this.bftC.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeC, (Integer)11, 1011, this.macsOnWirelessSegment[19]));
            this.bftC.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeC, (Integer)19, 1019, this.macsonCport19[0]));
            this.bftC.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeC, (Integer)24, 1024, this.macsonCport24[0]));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, (Integer)4, 10104, this.macsonAport4[0]));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, (Integer)5, 10105, this.macsonAport5[0]));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, (Integer)5, 10105, this.macsonAport5[1]));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, (Integer)24, 10124, this.macB));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, (Integer)24, 10124, this.macC));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, (Integer)24, 10124, this.macD));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, (Integer)24, 10124, this.macE));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, (Integer)24, 10124, this.forwardersABD[0]));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, (Integer)24, 10124, this.forwardersABD[1]));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, (Integer)24, 10124, this.forwardersABCD[0]));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, (Integer)24, 10124, this.macsonBport4[0]));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, (Integer)24, 10124, this.macsonBport4[1]));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, (Integer)24, 10124, this.macsonBport4[2]));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, (Integer)24, 10124, this.macsonBport3[0]));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, (Integer)24, 10124, this.macsonCport19[0]));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, (Integer)24, 10124, this.macsonCport24[0]));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, (Integer)24, 10124, this.macsonEport23[0]));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, (Integer)24, 10124, this.macsOnWirelessSegment[0]));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, (Integer)24, 10124, this.macsOnWirelessSegment[1]));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, (Integer)24, 10124, this.macsOnWirelessSegment[2]));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, (Integer)24, 10124, this.macsOnWirelessSegment[3]));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, (Integer)24, 10124, this.macsOnWirelessSegment[5]));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, (Integer)24, 10124, this.macsOnWirelessSegment[6]));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, (Integer)24, 10124, this.macsOnWirelessSegment[7]));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, (Integer)24, 10124, this.macsOnWirelessSegment[8]));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, (Integer)24, 10124, this.macsOnWirelessSegment[9]));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, (Integer)24, 10124, this.macsOnWirelessSegment[10]));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, (Integer)24, 10124, this.macsOnWirelessSegment[11]));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, (Integer)24, 10124, this.macsOnWirelessSegment[12]));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, (Integer)24, 10124, this.macsOnWirelessSegment[13]));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, (Integer)24, 10124, this.macsOnWirelessSegment[14]));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, (Integer)24, 10124, this.macsOnWirelessSegment[15]));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, (Integer)24, 10124, this.macsOnWirelessSegment[16]));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, (Integer)24, 10124, this.macsOnWirelessSegment[17]));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, (Integer)24, 10124, this.macsOnWirelessSegment[18]));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, (Integer)24, 10124, this.macsOnWirelessSegment[19]));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, (Integer)52, 5025, this.macsonAport52[0]));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, (Integer)52, 5025, this.macsonAport52[1]));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, (Integer)52, 5025, this.macsonAport52[2]));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, (Integer)52, 5025, this.macsonAport52[3]));
            this.bftA.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, (Integer)52, 5025, this.macsonAport52[4]));
            this.bftD.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeD, (Integer)49, 49, this.macsonAport52[0]));
            this.bftD.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeD, (Integer)49, 49, this.macsonAport52[2]));
            this.bftD.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeD, (Integer)49, 49, this.macsonAport52[4]));
            this.bftD.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeD, (Integer)50, 50, this.macB));
            this.bftD.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeD, (Integer)50, 50, this.macC));
            this.bftD.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeD, (Integer)50, 50, this.macE));
            this.bftD.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeD, (Integer)50, 50, this.forwardersABD[0]));
            this.bftD.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeD, (Integer)50, 50, this.forwardersABD[1]));
            this.bftD.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeD, (Integer)50, 50, this.forwardersABCD[0]));
            this.bftD.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeD, (Integer)50, 50, this.forwardersD[0]));
            this.bftD.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeD, (Integer)50, 50, this.macsonBport3[0]));
            this.bftD.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeD, (Integer)50, 50, this.macsonBport4[0]));
            this.bftD.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeD, (Integer)50, 50, this.macsonBport4[1]));
            this.bftD.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeD, (Integer)50, 50, this.macsonBport4[2]));
            this.bftD.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeD, (Integer)50, 50, this.macsonCport19[0]));
            this.bftD.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeD, (Integer)50, 50, this.macsonCport24[0]));
            this.bftD.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeD, (Integer)50, 50, this.macsonEport23[0]));
            this.bftD.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeD, (Integer)50, 50, this.macsOnWirelessSegment[0]));
            this.bftD.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeD, (Integer)50, 50, this.macsOnWirelessSegment[1]));
            this.bftD.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeD, (Integer)50, 50, this.macsOnWirelessSegment[2]));
            this.bftD.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeD, (Integer)50, 50, this.macsOnWirelessSegment[3]));
            this.bftD.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeD, (Integer)50, 50, this.macsOnWirelessSegment[5]));
            this.bftD.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeD, (Integer)50, 50, this.macsOnWirelessSegment[6]));
            this.bftD.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeD, (Integer)50, 50, this.macsOnWirelessSegment[7]));
            this.bftD.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeD, (Integer)50, 50, this.macsOnWirelessSegment[8]));
            this.bftD.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeD, (Integer)50, 50, this.macsOnWirelessSegment[9]));
            this.bftD.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeD, (Integer)50, 50, this.macsOnWirelessSegment[10]));
            this.bftD.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeD, (Integer)50, 50, this.macsOnWirelessSegment[11]));
            this.bftD.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeD, (Integer)50, 50, this.macsOnWirelessSegment[12]));
            this.bftD.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeD, (Integer)50, 50, this.macsOnWirelessSegment[13]));
            this.bftD.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeD, (Integer)50, 50, this.macsOnWirelessSegment[14]));
            this.bftE.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeE, (Integer)3, 3, this.macB));
            this.bftE.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeE, (Integer)3, 3, this.macC));
            this.bftE.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeE, (Integer)3, 3, this.forwardersE[0]));
            this.bftE.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeE, (Integer)3, 3, this.forwardersE[1]));
            this.bftE.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeE, (Integer)3, 3, this.forwardersBE[0]));
            this.bftE.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeE, (Integer)3, 3, this.macsonAport52[4]));
            this.bftE.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeE, (Integer)3, 3, this.macsonAport52[0]));
            this.bftE.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeE, (Integer)3, 3, this.macsonCport19[0]));
            this.bftE.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeE, (Integer)3, 3, this.macsOnWirelessSegment[0]));
            this.bftE.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeE, (Integer)3, 3, this.macsOnWirelessSegment[1]));
            this.bftE.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeE, (Integer)3, 3, this.macsOnWirelessSegment[2]));
            this.bftE.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeE, (Integer)3, 3, this.macsOnWirelessSegment[3]));
            this.bftE.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeE, (Integer)3, 3, this.macsOnWirelessSegment[4]));
            this.bftE.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeE, (Integer)3, 3, this.macsOnWirelessSegment[5]));
            this.bftE.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeE, (Integer)3, 3, this.macsOnWirelessSegment[6]));
            this.bftE.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeE, (Integer)3, 3, this.macsOnWirelessSegment[7]));
            this.bftE.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeE, (Integer)3, 3, this.macsOnWirelessSegment[8]));
            this.bftE.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeE, (Integer)3, 3, this.macsOnWirelessSegment[9]));
            this.bftE.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeE, (Integer)3, 3, this.macsOnWirelessSegment[10]));
            this.bftE.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeE, (Integer)3, 3, this.macsOnWirelessSegment[11]));
            this.bftE.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeE, (Integer)3, 3, this.macsOnWirelessSegment[12]));
            this.bftE.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeE, (Integer)3, 3, this.macsOnWirelessSegment[13]));
            this.bftE.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeE, (Integer)3, 3, this.macsOnWirelessSegment[14]));
            this.bftE.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeE, (Integer)3, 3, this.macsOnWirelessSegment[15]));
            this.bftE.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeE, (Integer)3, 3, this.macsOnWirelessSegment[16]));
            this.bftE.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeE, (Integer)3, 3, this.macsOnWirelessSegment[17]));
            this.bftE.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeE, (Integer)3, 3, this.macsOnWirelessSegment[18]));
            this.bftE.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeE, (Integer)3, 3, this.macsOnWirelessSegment[19]));
            this.bftE.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeE, (Integer)23, 23, this.macsonEport23[0]));
        }

        public void checkBC(BroadcastDomain domain) throws BridgeTopologyException {
            Assert.assertEquals((long)5L, (long)domain.getBridgeNodesOnDomain().size());
            Assert.assertEquals((long)2L, (long)domain.getRootBridge().getNodeId().intValue());
            Assert.assertEquals((long)6L, (long)domain.getSharedSegments().size());
            Assert.assertEquals((long)4L, (long)domain.getSharedSegments(Integer.valueOf(2)).size());
            Assert.assertEquals((long)3L, (long)domain.getSharedSegments(Integer.valueOf(3)).size());
            block10: for (Bridge bridge : domain.getBridges()) {
                if (bridge.isRootBridge()) {
                    Assert.assertEquals((long)2L, (long)bridge.getNodeId().intValue());
                    Assert.assertNull((Object)bridge.getRootPort());
                    continue;
                }
                switch (bridge.getNodeId()) {
                    case 3: {
                        Assert.assertNotNull((Object)bridge.getRootPort());
                        continue block10;
                    }
                    case 1: {
                        Assert.assertNull((Object)bridge.getRootPort());
                        continue block10;
                    }
                    case 6: {
                        Assert.assertNull((Object)bridge.getRootPort());
                        continue block10;
                    }
                    case 8: {
                        Assert.assertNull((Object)bridge.getRootPort());
                        continue block10;
                    }
                }
                Assert.assertTrue((boolean)false);
            }
            for (SharedSegment segment : domain.getSharedSegments()) {
                Assert.assertNotNull((Object)segment.getDesignatedBridge());
                Assert.assertNotNull((Object)segment.getDesignatedPort());
                switch (segment.getDesignatedBridge()) {
                    case 2: {
                        this.checkBcalcBC(segment);
                        break;
                    }
                    case 3: {
                        this.checkCcalcBC(segment);
                        break;
                    }
                    default: {
                        Assert.assertTrue((boolean)false);
                    }
                }
                for (BridgeMacLink bridgeMacLink : SharedSegment.getBridgeMacLinks((SharedSegment)segment)) {
                    Assert.assertNotNull((Object)bridgeMacLink.getBridgePort());
                    Assert.assertNotNull((Object)bridgeMacLink.getBridgePortIfIndex());
                    Assert.assertNotNull((Object)bridgeMacLink.getMacAddress());
                    Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)bridgeMacLink.getLinkType());
                }
            }
        }

        public void checkCcalcBC(SharedSegment segment) throws BridgeTopologyException {
            Assert.assertEquals((long)3L, (long)segment.getDesignatedBridge().intValue());
            Assert.assertEquals((long)1L, (long)segment.getBridgePortsOnSegment().size());
            switch (segment.getDesignatedPort().getBridgePort()) {
                case 19: {
                    Assert.assertEquals((long)this.macsonCport19.length, (long)segment.getMacsOnSegment().size());
                    for (String mac : this.macsonCport19) {
                        Assert.assertTrue((boolean)segment.containsMac(mac));
                    }
                    break;
                }
                case 24: {
                    Assert.assertEquals((long)this.macsonCport24.length, (long)segment.getMacsOnSegment().size());
                    for (String mac : this.macsonCport24) {
                        Assert.assertTrue((boolean)segment.containsMac(mac));
                    }
                    break;
                }
                default: {
                    Assert.assertTrue((boolean)false);
                }
            }
        }

        public void checkBcalcBC(SharedSegment segment) throws BridgeTopologyException {
            Assert.assertEquals((long)2L, (long)segment.getDesignatedBridge().intValue());
            switch (segment.getDesignatedPort().getBridgePort()) {
                case 1: {
                    Assert.assertEquals((long)1L, (long)segment.getBridgePortsOnSegment().size());
                    Assert.assertEquals((long)0L, (long)SharedSegment.getBridgeBridgeLinks((SharedSegment)segment).size());
                    Assert.assertEquals((long)3L, (long)segment.getMacsOnSegment().size());
                    Assert.assertEquals((long)3L, (long)SharedSegment.getBridgeMacLinks((SharedSegment)segment).size());
                    break;
                }
                case 2: {
                    Assert.assertEquals((long)2L, (long)segment.getBridgePortsOnSegment().size());
                    Assert.assertEquals((long)2L, (long)segment.getBridgePort(Integer.valueOf(2)).getBridgePort().intValue());
                    Assert.assertEquals((long)11L, (long)segment.getBridgePort(Integer.valueOf(3)).getBridgePort().intValue());
                    Assert.assertEquals((long)(this.macsOnWirelessSegment.length + this.forwardersABCD.length + this.macsonEport23.length), (long)segment.getMacsOnSegment().size());
                    for (String mac : this.macsOnWirelessSegment) {
                        Assert.assertTrue((boolean)segment.containsMac(mac));
                    }
                    for (String mac : this.forwardersABCD) {
                        Assert.assertTrue((boolean)segment.containsMac(mac));
                    }
                    for (String mac : this.macsonEport23) {
                        Assert.assertTrue((boolean)segment.containsMac(mac));
                    }
                    Assert.assertEquals((long)(this.macsOnWirelessSegment.length + this.forwardersABCD.length + this.macsonEport23.length), (long)SharedSegment.getBridgeMacLinks((SharedSegment)segment).size());
                    Assert.assertEquals((long)1L, (long)SharedSegment.getBridgeBridgeLinks((SharedSegment)segment).size());
                    BridgeBridgeLink blink = (BridgeBridgeLink)SharedSegment.getBridgeBridgeLinks((SharedSegment)segment).iterator().next();
                    Assert.assertEquals((long)2L, (long)blink.getDesignatedNode().getId().intValue());
                    Assert.assertEquals((long)2L, (long)blink.getDesignatedPort().intValue());
                    Assert.assertEquals((long)11L, (long)blink.getBridgePort().intValue());
                    break;
                }
                case 3: {
                    Assert.assertEquals((long)1L, (long)segment.getBridgePortsOnSegment().size());
                    Assert.assertEquals((long)this.macsonBport3.length, (long)segment.getMacsOnSegment().size());
                    for (String mac : this.macsonBport3) {
                        Assert.assertTrue((boolean)segment.containsMac(mac));
                    }
                    break;
                }
                case 4: {
                    Assert.assertEquals((long)1L, (long)segment.getBridgePortsOnSegment().size());
                    Assert.assertEquals((long)this.macsonBport4.length, (long)segment.getMacsOnSegment().size());
                    for (String mac : this.macsonBport4) {
                        Assert.assertTrue((boolean)segment.containsMac(mac));
                    }
                    break;
                }
                default: {
                    Assert.assertTrue((boolean)false);
                }
            }
        }

        public void check(BroadcastDomain domain) throws BridgeTopologyException {
            Assert.assertEquals((long)5L, (long)domain.getBridgeNodesOnDomain().size());
            Assert.assertEquals((long)2L, (long)domain.getRootBridge().getNodeId().intValue());
            Assert.assertEquals((long)11L, (long)domain.getSharedSegments().size());
            Assert.assertEquals((long)4L, (long)domain.getSharedSegments(Integer.valueOf(1)).size());
            Assert.assertEquals((long)4L, (long)domain.getSharedSegments(Integer.valueOf(2)).size());
            Assert.assertEquals((long)3L, (long)domain.getSharedSegments(Integer.valueOf(3)).size());
            Assert.assertEquals((long)2L, (long)domain.getSharedSegments(Integer.valueOf(6)).size());
            Assert.assertEquals((long)2L, (long)domain.getSharedSegments(Integer.valueOf(8)).size());
            for (Bridge bridge : domain.getBridges()) {
                if (bridge.isRootBridge()) {
                    Assert.assertNull((Object)bridge.getRootPort());
                    continue;
                }
                Assert.assertNotNull((Object)bridge.getRootPort());
            }
            for (SharedSegment segment : domain.getSharedSegments()) {
                Assert.assertNotNull((Object)segment.getDesignatedBridge());
                Assert.assertNotNull((Object)segment.getDesignatedPort());
                switch (segment.getDesignatedBridge()) {
                    case 1: {
                        this.checkA(segment);
                        break;
                    }
                    case 2: {
                        this.checkB(segment);
                        break;
                    }
                    case 3: {
                        this.checkC(segment);
                        break;
                    }
                    case 6: {
                        this.checkD(segment);
                        break;
                    }
                    case 8: {
                        this.checkE(segment);
                        break;
                    }
                    default: {
                        Assert.assertTrue((boolean)false);
                    }
                }
                for (BridgeMacLink bridgeMacLink : SharedSegment.getBridgeMacLinks((SharedSegment)segment)) {
                    Assert.assertNotNull((Object)bridgeMacLink.getBridgePort());
                    Assert.assertNotNull((Object)bridgeMacLink.getBridgePortIfIndex());
                    Assert.assertNotNull((Object)bridgeMacLink.getMacAddress());
                    Assert.assertEquals((Object)BridgeMacLink.BridgeMacLinkType.BRIDGE_LINK, (Object)bridgeMacLink.getLinkType());
                }
            }
            this.checkA(domain.getForwarders(Integer.valueOf(1)));
            this.checkB(domain.getForwarders(Integer.valueOf(2)));
            this.checkC(domain.getForwarders(Integer.valueOf(3)));
            this.checkD(domain.getForwarders(Integer.valueOf(6)));
            this.checkE(domain.getForwarders(Integer.valueOf(8)));
        }

        public void checkEcalcBCAE(Set<BridgePortWithMacs> forwarders) {
            this.checkE(forwarders);
        }

        public void checkE(Set<BridgePortWithMacs> forwarders) {
            Assert.assertEquals((long)1L, (long)forwarders.size());
            BridgePortWithMacs forward = forwarders.iterator().next();
            Assert.assertEquals((long)8L, (long)forward.getPort().getNodeId().intValue());
            Assert.assertEquals((long)3L, (long)forward.getPort().getBridgePort().intValue());
            Assert.assertEquals((long)3L, (long)forward.getPort().getBridgePortIfIndex().intValue());
            Assert.assertEquals((long)5L, (long)forward.getMacs().size());
            Assert.assertTrue((boolean)forward.getMacs().contains(this.macB));
            Assert.assertTrue((boolean)forward.getMacs().contains(this.macC));
            for (String mac : this.forwardersBE) {
                Assert.assertTrue((boolean)forward.getMacs().contains(mac));
            }
            for (String mac : this.forwardersE) {
                Assert.assertTrue((boolean)forward.getMacs().contains(mac));
            }
        }

        public void checkDcalcBCAD(Set<BridgePortWithMacs> forwarders) {
            Assert.assertEquals((long)1L, (long)forwarders.size());
            BridgePortWithMacs forward = forwarders.iterator().next();
            Assert.assertEquals((long)6L, (long)forward.getPort().getNodeId().intValue());
            Assert.assertEquals((long)50L, (long)forward.getPort().getBridgePort().intValue());
            Assert.assertEquals((long)50L, (long)forward.getPort().getBridgePortIfIndex().intValue());
            Assert.assertEquals((long)6L, (long)forward.getMacs().size());
            Assert.assertTrue((boolean)forward.getMacs().contains(this.macB));
            Assert.assertTrue((boolean)forward.getMacs().contains(this.macC));
            Assert.assertTrue((boolean)forward.getMacs().contains(this.macE));
            for (String mac : this.forwardersABD) {
                Assert.assertTrue((boolean)forward.getMacs().contains(mac));
            }
            for (String mac : this.forwardersD) {
                Assert.assertTrue((boolean)forward.getMacs().contains(mac));
            }
        }

        public void checkD(Set<BridgePortWithMacs> forwarders) {
            Assert.assertEquals((long)1L, (long)forwarders.size());
            BridgePortWithMacs forward = forwarders.iterator().next();
            Assert.assertEquals((long)6L, (long)forward.getPort().getNodeId().intValue());
            Assert.assertEquals((long)50L, (long)forward.getPort().getBridgePort().intValue());
            Assert.assertEquals((long)50L, (long)forward.getPort().getBridgePortIfIndex().intValue());
            switch (forward.getMacs().size()) {
                case 7: {
                    Assert.assertTrue((boolean)true);
                    break;
                }
                case 8: {
                    for (String fbe : this.forwardersBE) {
                        Assert.assertTrue((boolean)forward.getMacs().contains(fbe));
                    }
                    break;
                }
                default: {
                    Assert.assertTrue((boolean)false);
                }
            }
            Assert.assertTrue((boolean)forward.getMacs().contains(this.macB));
            Assert.assertTrue((boolean)forward.getMacs().contains(this.macC));
            Assert.assertTrue((boolean)forward.getMacs().contains(this.macE));
            for (String mac : this.forwardersABD) {
                Assert.assertTrue((boolean)forward.getMacs().contains(mac));
            }
            for (String mac : this.forwardersABCD) {
                Assert.assertTrue((boolean)forward.getMacs().contains(mac));
            }
            for (String mac : this.forwardersD) {
                Assert.assertTrue((boolean)forward.getMacs().contains(mac));
            }
        }

        public void checkCcalcBC(Set<BridgePortWithMacs> forwarders) {
            this.checkCcalcBCAD(forwarders);
        }

        public void checkCcalcBCA(Set<BridgePortWithMacs> forwarders) {
            this.checkCcalcBCAD(forwarders);
        }

        public void checkCcalcBCAD(Set<BridgePortWithMacs> forwarders) {
            Assert.assertEquals((long)1L, (long)forwarders.size());
            BridgePortWithMacs forward = forwarders.iterator().next();
            Assert.assertEquals((long)3L, (long)forward.getPort().getNodeId().intValue());
            Assert.assertEquals((long)11L, (long)forward.getPort().getBridgePort().intValue());
            Assert.assertEquals((long)1011L, (long)forward.getPort().getBridgePortIfIndex().intValue());
            Assert.assertEquals((long)1L, (long)forward.getMacs().size());
            Assert.assertTrue((boolean)this.macB.equals(forward.getMacs().iterator().next()));
        }

        public void checkCcalcBCAE(Set<BridgePortWithMacs> forwarders) {
            this.checkC(forwarders);
        }

        public void checkC(Set<BridgePortWithMacs> forwarders) {
            Assert.assertEquals((long)1L, (long)forwarders.size());
            BridgePortWithMacs forward = forwarders.iterator().next();
            Assert.assertEquals((long)3L, (long)forward.getPort().getNodeId().intValue());
            Assert.assertEquals((long)11L, (long)forward.getPort().getBridgePort().intValue());
            Assert.assertEquals((long)1011L, (long)forward.getPort().getBridgePortIfIndex().intValue());
            Assert.assertEquals((long)2L, (long)forward.getMacs().size());
            Assert.assertTrue((boolean)forward.getMacs().contains(this.macB));
            for (String mac : this.forwardersABCD) {
                Assert.assertTrue((boolean)forward.getMacs().contains(mac));
            }
        }

        public void checkBcalcBC(Set<BridgePortWithMacs> forwarders) {
            this.checkBcalcBCAD(forwarders);
        }

        public void checkBcalcBCA(Set<BridgePortWithMacs> forwarders) {
            this.checkBcalcBCAD(forwarders);
        }

        public void checkBcalcBCAD(Set<BridgePortWithMacs> forwarders) {
            Assert.assertEquals((long)1L, (long)forwarders.size());
            BridgePortWithMacs forward = forwarders.iterator().next();
            Assert.assertEquals((long)2L, (long)forward.getPort().getNodeId().intValue());
            Assert.assertEquals((long)2L, (long)forward.getPort().getBridgePort().intValue());
            Assert.assertEquals((long)1002L, (long)forward.getPort().getBridgePortIfIndex().intValue());
            Assert.assertEquals((long)5L, (long)forward.getMacs().size());
            Assert.assertTrue((boolean)forward.getMacs().contains(this.macC));
            Assert.assertTrue((boolean)forward.getMacs().contains(this.macE));
            for (String mac : this.forwardersABD) {
                Assert.assertTrue((boolean)forward.getMacs().contains(mac));
            }
            for (String mac : this.forwardersBE) {
                Assert.assertTrue((boolean)forward.getMacs().contains(mac));
            }
        }

        public void checkBcalcBCAE(Set<BridgePortWithMacs> forwarders) {
            this.checkB(forwarders);
        }

        public void checkB(Set<BridgePortWithMacs> forwarders) {
            Assert.assertEquals((long)1L, (long)forwarders.size());
            BridgePortWithMacs forward = forwarders.iterator().next();
            Assert.assertEquals((long)2L, (long)forward.getPort().getNodeId().intValue());
            Assert.assertEquals((long)2L, (long)forward.getPort().getBridgePort().intValue());
            Assert.assertEquals((long)1002L, (long)forward.getPort().getBridgePortIfIndex().intValue());
            Assert.assertEquals((long)6L, (long)forward.getMacs().size());
            Assert.assertTrue((boolean)forward.getMacs().contains(this.macC));
            Assert.assertTrue((boolean)forward.getMacs().contains(this.macE));
            for (String mac : this.forwardersABD) {
                Assert.assertTrue((boolean)forward.getMacs().contains(mac));
            }
            for (String mac : this.forwardersBE) {
                Assert.assertTrue((boolean)forward.getMacs().contains(mac));
            }
            for (String mac : this.forwardersABCD) {
                Assert.assertTrue((boolean)forward.getMacs().contains(mac));
            }
        }

        public void checkAcalcBCA(Set<BridgePortWithMacs> forwarders) {
            this.checkAcalcBCAD(forwarders);
        }

        public void checkAcalcBCAD(Set<BridgePortWithMacs> forwarders) {
            Assert.assertEquals((long)1L, (long)forwarders.size());
            BridgePortWithMacs forward = forwarders.iterator().next();
            Assert.assertEquals((long)1L, (long)forward.getPort().getNodeId().intValue());
            Assert.assertEquals((long)24L, (long)forward.getPort().getBridgePort().intValue());
            Assert.assertEquals((long)10124L, (long)forward.getPort().getBridgePortIfIndex().intValue());
            Assert.assertEquals((long)6L, (long)forward.getMacs().size());
            Assert.assertTrue((boolean)forward.getMacs().contains(this.macB));
            Assert.assertTrue((boolean)forward.getMacs().contains(this.macC));
            Assert.assertTrue((boolean)forward.getMacs().contains(this.macD));
            Assert.assertTrue((boolean)forward.getMacs().contains(this.macE));
            for (String mac : this.forwardersABD) {
                Assert.assertTrue((boolean)forward.getMacs().contains(mac));
            }
        }

        public void checkAcalcBCAE(Set<BridgePortWithMacs> forwarders) {
            this.checkA(forwarders);
        }

        public void checkA(Set<BridgePortWithMacs> forwarders) {
            BridgePortWithMacs forward = forwarders.iterator().next();
            Assert.assertEquals((long)1L, (long)forward.getPort().getNodeId().intValue());
            Assert.assertEquals((long)24L, (long)forward.getPort().getBridgePort().intValue());
            Assert.assertEquals((long)10124L, (long)forward.getPort().getBridgePortIfIndex().intValue());
            switch (forward.getMacs().size()) {
                case 7: {
                    Assert.assertTrue((boolean)true);
                    break;
                }
                case 8: {
                    for (String fbe : this.forwardersBE) {
                        Assert.assertTrue((boolean)forward.getMacs().contains(fbe));
                    }
                    break;
                }
                default: {
                    Assert.assertTrue((boolean)false);
                }
            }
            Assert.assertTrue((boolean)forward.getMacs().contains(this.macB));
            Assert.assertTrue((boolean)forward.getMacs().contains(this.macC));
            Assert.assertTrue((boolean)forward.getMacs().contains(this.macD));
            Assert.assertTrue((boolean)forward.getMacs().contains(this.macE));
            for (String mac : this.forwardersABD) {
                Assert.assertTrue((boolean)forward.getMacs().contains(mac));
            }
            for (String mac : this.forwardersABCD) {
                Assert.assertTrue((boolean)forward.getMacs().contains(mac));
            }
        }

        public void checkA(SharedSegment segment) throws BridgeTopologyException {
            Assert.assertEquals((long)1L, (long)segment.getDesignatedBridge().intValue());
            Assert.assertEquals((long)1L, (long)segment.getBridgePortsOnSegment().size());
            switch (segment.getDesignatedPort().getBridgePort()) {
                case 4: {
                    Assert.assertEquals((long)this.macsonAport4.length, (long)segment.getMacsOnSegment().size());
                    for (String mac : this.macsonAport4) {
                        Assert.assertTrue((boolean)segment.containsMac(mac));
                    }
                    break;
                }
                case 5: {
                    Assert.assertEquals((long)this.macsonAport5.length, (long)segment.getMacsOnSegment().size());
                    for (String mac : this.macsonAport5) {
                        Assert.assertTrue((boolean)segment.containsMac(mac));
                    }
                    break;
                }
                case 52: {
                    Assert.assertEquals((long)this.macsonAport52.length, (long)segment.getMacsOnSegment().size());
                    for (String mac : this.macsonAport52) {
                        Assert.assertTrue((boolean)segment.containsMac(mac));
                    }
                    break;
                }
                default: {
                    Assert.assertTrue((boolean)false);
                }
            }
        }

        public void checkE(SharedSegment segment) throws BridgeTopologyException {
            Assert.assertEquals((long)8L, (long)segment.getDesignatedBridge().intValue());
            Assert.assertEquals((long)1L, (long)segment.getBridgePortsOnSegment().size());
            switch (segment.getDesignatedPort().getBridgePort()) {
                case 23: {
                    Assert.assertEquals((long)this.macsonEport23.length, (long)segment.getMacsOnSegment().size());
                    for (String mac : this.macsonEport23) {
                        Assert.assertTrue((boolean)segment.containsMac(mac));
                    }
                    break;
                }
                default: {
                    Assert.assertTrue((boolean)false);
                }
            }
        }

        public void checkC(SharedSegment segment) throws BridgeTopologyException {
            Assert.assertEquals((long)3L, (long)segment.getDesignatedBridge().intValue());
            Assert.assertEquals((long)1L, (long)segment.getBridgePortsOnSegment().size());
            switch (segment.getDesignatedPort().getBridgePort()) {
                case 19: {
                    Assert.assertEquals((long)this.macsonCport19.length, (long)segment.getMacsOnSegment().size());
                    for (String mac : this.macsonCport19) {
                        Assert.assertTrue((boolean)segment.containsMac(mac));
                    }
                    break;
                }
                case 24: {
                    Assert.assertEquals((long)this.macsonCport24.length, (long)segment.getMacsOnSegment().size());
                    for (String mac : this.macsonCport24) {
                        Assert.assertTrue((boolean)segment.containsMac(mac));
                    }
                    break;
                }
                default: {
                    Assert.assertTrue((boolean)false);
                }
            }
        }

        public void checkB(SharedSegment segment) throws BridgeTopologyException {
            Assert.assertEquals((long)2L, (long)segment.getDesignatedBridge().intValue());
            switch (segment.getDesignatedPort().getBridgePort()) {
                case 1: {
                    Assert.assertEquals((long)2L, (long)segment.getBridgePortsOnSegment().size());
                    Assert.assertEquals((long)1L, (long)SharedSegment.getBridgeBridgeLinks((SharedSegment)segment).size());
                    Assert.assertEquals((long)0L, (long)segment.getMacsOnSegment().size());
                    Assert.assertEquals((long)0L, (long)SharedSegment.getBridgeMacLinks((SharedSegment)segment).size());
                    BridgeBridgeLink link = (BridgeBridgeLink)SharedSegment.getBridgeBridgeLinks((SharedSegment)segment).iterator().next();
                    Assert.assertEquals((long)6L, (long)link.getNode().getId().intValue());
                    Assert.assertEquals((long)50L, (long)link.getBridgePort().intValue());
                    Assert.assertEquals((long)2L, (long)link.getDesignatedNode().getId().intValue());
                    Assert.assertEquals((long)1L, (long)link.getDesignatedPort().intValue());
                    break;
                }
                case 2: {
                    Assert.assertEquals((long)3L, (long)segment.getBridgePortsOnSegment().size());
                    Assert.assertEquals((long)2L, (long)segment.getBridgePort(Integer.valueOf(2)).getBridgePort().intValue());
                    Assert.assertEquals((long)3L, (long)segment.getBridgePort(Integer.valueOf(8)).getBridgePort().intValue());
                    Assert.assertEquals((long)11L, (long)segment.getBridgePort(Integer.valueOf(3)).getBridgePort().intValue());
                    Assert.assertEquals((long)this.macsOnWirelessSegment.length, (long)segment.getMacsOnSegment().size());
                    for (String mac : this.macsOnWirelessSegment) {
                        Assert.assertTrue((boolean)segment.containsMac(mac));
                    }
                    Assert.assertEquals((long)this.macsOnWirelessSegment.length, (long)SharedSegment.getBridgeMacLinks((SharedSegment)segment).size());
                    Assert.assertEquals((long)2L, (long)SharedSegment.getBridgeBridgeLinks((SharedSegment)segment).size());
                    block11: for (BridgeBridgeLink blink : SharedSegment.getBridgeBridgeLinks((SharedSegment)segment)) {
                        Assert.assertEquals((long)2L, (long)blink.getDesignatedNode().getId().intValue());
                        Assert.assertEquals((long)2L, (long)blink.getDesignatedPort().intValue());
                        switch (blink.getNode().getId()) {
                            case 8: {
                                Assert.assertEquals((long)3L, (long)blink.getBridgePort().intValue());
                                continue block11;
                            }
                            case 3: {
                                Assert.assertEquals((long)11L, (long)blink.getBridgePort().intValue());
                                continue block11;
                            }
                        }
                        Assert.assertTrue((boolean)false);
                    }
                    break;
                }
                case 3: {
                    Assert.assertEquals((long)1L, (long)segment.getBridgePortsOnSegment().size());
                    Assert.assertEquals((long)this.macsonBport3.length, (long)segment.getMacsOnSegment().size());
                    for (String mac : this.macsonBport3) {
                        Assert.assertTrue((boolean)segment.containsMac(mac));
                    }
                    break;
                }
                case 4: {
                    Assert.assertEquals((long)1L, (long)segment.getBridgePortsOnSegment().size());
                    Assert.assertEquals((long)this.macsonBport4.length, (long)segment.getMacsOnSegment().size());
                    for (String mac : this.macsonBport4) {
                        Assert.assertTrue((boolean)segment.containsMac(mac));
                    }
                    break;
                }
                default: {
                    Assert.assertTrue((boolean)false);
                }
            }
        }

        public void checkD(SharedSegment segment) throws BridgeTopologyException {
            Assert.assertEquals((long)6L, (long)segment.getDesignatedBridge().intValue());
            Assert.assertEquals((long)2L, (long)segment.getBridgePortsOnSegment().size());
            Assert.assertEquals((long)1L, (long)SharedSegment.getBridgeBridgeLinks((SharedSegment)segment).size());
            Assert.assertEquals((long)0L, (long)segment.getMacsOnSegment().size());
            Assert.assertEquals((long)0L, (long)SharedSegment.getBridgeMacLinks((SharedSegment)segment).size());
            Assert.assertEquals((long)49L, (long)segment.getDesignatedPort().getBridgePort().intValue());
            BridgeBridgeLink link = (BridgeBridgeLink)SharedSegment.getBridgeBridgeLinks((SharedSegment)segment).iterator().next();
            Assert.assertEquals((long)1L, (long)link.getNode().getId().intValue());
            Assert.assertEquals((long)24L, (long)link.getBridgePort().intValue());
            Assert.assertEquals((long)6L, (long)link.getDesignatedNode().getId().intValue());
            Assert.assertEquals((long)49L, (long)link.getDesignatedPort().intValue());
        }
    }

    class TwentyNodeTopology {
        final int spiazzomepe01Id = 6740;
        final int spiazzofasw01Id = 1571;
        final int spiasvigasw01Id = 1572;
        final int villpizzasw01Id = 5099;
        final int vigrenmuasw01Id = 1619;
        final int daremunasw01Id = 1396;
        final int vrendmunasw01Id = 1622;
        final int daremunalv01Id = 2473;
        final int vigrenmualv01Id = 2673;
        final int vigrenmualv02Id = 2674;
        final int vrendmunalv02Id = 2676;
        final int rsaspiazzowl1Id = 6796;
        final int comunespiazzowl1Id = 6772;
        final int comunevillarendenawl1Id = 6777;
        String macspiazzomepe01 = "0c8525e8f380";
        String macspiazzofasw01 = "00e0b1bb39b4";
        String macspiasvigasw01 = "00e0b1bba38e";
        String macvillpizzasw01 = "0012cf5d3180";
        String macdaremunasw01 = "00e0b1bbac4a";
        String macvrendmunasw01 = "00e0b1bba8f0";
        String macvigrenmuasw01 = "00e0b1bb3ec8";
        String macdaremunalv01 = "0010e724168b";
        String macvigrenmualv01 = "0010e7448f7f";
        String macvigrenmualv02 = "0010e744f3de";
        String macvrendmunalv02 = "0010e7241894";
        String macrsaspiazzowl1 = "d4ca6deafe24";
        String macomunespiazzowl1 = "000c42c54e75";
        String maccomunevillarendenawl1 = "000c42679d1d";
        OnmsNode spiazzomepe01 = new OnmsNode();
        OnmsNode spiazzofasw01 = new OnmsNode();
        OnmsNode spiasvigasw01 = new OnmsNode();
        OnmsNode villpizzasw01 = new OnmsNode();
        OnmsNode daremunasw01 = new OnmsNode();
        OnmsNode vrendmunasw01 = new OnmsNode();
        OnmsNode vigrenmuasw01 = new OnmsNode();
        OnmsNode daremunalv01 = new OnmsNode();
        OnmsNode vigrenmualv01 = new OnmsNode();
        OnmsNode vigrenmualv02 = new OnmsNode();
        OnmsNode vrendmunalv02 = new OnmsNode();
        OnmsNode rsaspiazzowl1 = new OnmsNode();
        OnmsNode comunespiazzowl1 = new OnmsNode();
        OnmsNode comunevillarendenawl1 = new OnmsNode();
        BridgeElement elemspiazzomepe01 = new BridgeElement();
        BridgeElement elemspiazzofasw01 = new BridgeElement();
        BridgeElement elemspiasvigasw01 = new BridgeElement();
        BridgeElement elemvillpizzasw01 = new BridgeElement();
        BridgeElement elemvigrenmuasw01 = new BridgeElement();
        BridgeElement elemdaremunasw01 = new BridgeElement();
        BridgeElement elemvrendmunasw01 = new BridgeElement();
        BridgeElement elemdaremunalv01 = new BridgeElement();
        BridgeElement elemvigrenmualv01 = new BridgeElement();
        BridgeElement elemvigrenmualv02 = new BridgeElement();
        BridgeElement elemvrendmunalv02 = new BridgeElement();
        BridgeElement elemrsaspiazzowl1 = new BridgeElement();
        BridgeElement elemcomunespiazzowl1 = new BridgeElement();
        BridgeElement elemcomunevillarendenawl1 = new BridgeElement();
        List<BridgeElement> elemlist = new ArrayList<BridgeElement>();
        Set<BridgeForwardingTableEntry> bftspiazzomepe01 = new HashSet<BridgeForwardingTableEntry>();
        Set<BridgeForwardingTableEntry> bftspiazzofasw01 = new HashSet<BridgeForwardingTableEntry>();
        Set<BridgeForwardingTableEntry> bftvrendmunasw01 = new HashSet<BridgeForwardingTableEntry>();
        Set<BridgeForwardingTableEntry> bftspiasvigasw01 = new HashSet<BridgeForwardingTableEntry>();
        Set<BridgeForwardingTableEntry> bftvillpizzasw01 = new HashSet<BridgeForwardingTableEntry>();
        Set<BridgeForwardingTableEntry> bftvigrenmuasw01 = new HashSet<BridgeForwardingTableEntry>();
        Set<BridgeForwardingTableEntry> bftdaremunasw01 = new HashSet<BridgeForwardingTableEntry>();
        Set<BridgeForwardingTableEntry> bftdaremunalv01 = new HashSet<BridgeForwardingTableEntry>();
        Set<BridgeForwardingTableEntry> bftvigrenmualv01 = new HashSet<BridgeForwardingTableEntry>();
        Set<BridgeForwardingTableEntry> bftvigrenmualv02 = new HashSet<BridgeForwardingTableEntry>();
        Set<BridgeForwardingTableEntry> bftvrendmunalv02 = new HashSet<BridgeForwardingTableEntry>();
        Set<BridgeForwardingTableEntry> bftrsaspiazzowl1 = new HashSet<BridgeForwardingTableEntry>();
        Set<BridgeForwardingTableEntry> bftcomunespiazzowl1 = new HashSet<BridgeForwardingTableEntry>();
        Set<BridgeForwardingTableEntry> bftcomunevillarendenawl1 = new HashSet<BridgeForwardingTableEntry>();
        String mac00e0b1bba8f2 = "00e0b1bba8f2";
        String mac4c5e0c104aac = "4c5e0c104aac";
        String mac4c5e0c104bfa = "4c5e0c104bfa";
        String mac0003ea02a9b5 = "0003ea02a9b5";
        String mac00e0b1bb3ed4 = "00e0b1bb3ed4";
        String mac00e0b1bba8fc = "00e0b1bba8fc";
        String mac00e0b1bba390 = "00e0b1bba390";
        String mac0003ea0176ca = "0003ea0176ca";
        String mac00e0b1bb39b6 = "00e0b1bb39b6";
        String mac0003ea0175d6 = "0003ea0175d6";
        String mac00e0b1bba8f4 = "00e0b1bba8f4";
        String mac0c8525e8f3c0 = "0c8525e8f3c0";
        String mac00e0b1bb3ed5 = "00e0b1bb3ed5";
        String mac00e0b1bbac56 = "00e0b1bbac56";
        String mac00156d56ae1b = "00156d56ae1b";
        String mac000c42736e85 = "000c42736e85";
        String mace48d8c3b04b7 = "e48d8c3b04b7";
        String mac000c29f49b8a = "000c29f49b8a";
        String mac0017c8288325 = "0017c8288325";
        String mac9cb65475cca4 = "9cb65475cca4";
        String mac000424ab02d9 = "000424ab02d9";
        String mac0011323f881d = "0011323f881d";
        String mac000074f204a6 = "000074f204a6";
        String mac3ca82a7efb8f = "3ca82a7efb8f";
        String mac001ebe70cec0 = "001ebe70cec0";
        String mac0022557fd68f = "0022557fd68f";
        String mace48d8c2e100c = "e48d8c2e100c";
        String mac001906d5cf50 = "001906d5cf50";
        String mac002255362620 = "002255362620";
        String mace48d8cf17bcb = "e48d8cf17bcb";
        String macc067af3ce614 = "c067af3ce614";
        String mac4c0082245938 = "4c0082245938";
        String mac00804867f17e = "00804867f17e";
        String mac008048676c89 = "008048676c89";
        String mac4c5e0c8076b0 = "4c5e0c8076b0";
        String macc067af3ce59d = "c067af3ce59d";
        String macd4ca6d4f1ab2 = "d4ca6d4f1ab2";
        String mac4c5e0c8007a1 = "4c5e0c8007a1";
        String mac001763010eb7 = "001763010eb7";
        String mac00804867f4e7 = "00804867f4e7";
        String mac00e0b1bb39cd = "00e0b1bb39cd";
        String mac0012cf68d780 = "0012cf68d780";
        String mac001763010f41 = "001763010f41";
        String mac00176301092d = "00176301092d";
        String macd4ca6dff4217 = "d4ca6dff4217";
        String mac000d48160cd3 = "000d48160cd3";
        String mac00804864187d = "00804864187d";
        String macc067af3ce623 = "c067af3ce623";
        String macd4ca6d7953fe = "d4ca6d7953fe";
        String mac0001a9019875 = "0001a9019875";
        String mac002255362ba7 = "002255362ba7";
        String macc067af3ce581 = "c067af3ce581";
        String mac00176301057d = "00176301057d";

        public TwentyNodeTopology() {
            this.spiazzomepe01.setId(Integer.valueOf(6740));
            this.spiazzofasw01.setId(Integer.valueOf(1571));
            this.spiasvigasw01.setId(Integer.valueOf(1572));
            this.villpizzasw01.setId(Integer.valueOf(5099));
            this.vigrenmuasw01.setId(Integer.valueOf(1619));
            this.daremunasw01.setId(Integer.valueOf(1396));
            this.vrendmunasw01.setId(Integer.valueOf(1622));
            this.daremunalv01.setId(Integer.valueOf(2473));
            this.vigrenmualv01.setId(Integer.valueOf(2673));
            this.vigrenmualv02.setId(Integer.valueOf(2674));
            this.vrendmunalv02.setId(Integer.valueOf(2676));
            this.rsaspiazzowl1.setId(Integer.valueOf(6796));
            this.comunespiazzowl1.setId(Integer.valueOf(6772));
            this.comunevillarendenawl1.setId(Integer.valueOf(6777));
            this.elemspiazzomepe01.setNode(this.spiazzomepe01);
            this.elemspiazzofasw01.setNode(this.spiazzofasw01);
            this.elemspiasvigasw01.setNode(this.spiasvigasw01);
            this.elemvillpizzasw01.setNode(this.villpizzasw01);
            this.elemvigrenmuasw01.setNode(this.vigrenmuasw01);
            this.elemvrendmunasw01.setNode(this.vrendmunasw01);
            this.elemdaremunasw01.setNode(this.daremunasw01);
            this.elemdaremunalv01.setNode(this.daremunalv01);
            this.elemvigrenmualv01.setNode(this.vigrenmualv01);
            this.elemvigrenmualv02.setNode(this.vigrenmualv02);
            this.elemvrendmunalv02.setNode(this.vrendmunalv02);
            this.elemrsaspiazzowl1.setNode(this.rsaspiazzowl1);
            this.elemcomunespiazzowl1.setNode(this.comunespiazzowl1);
            this.elemcomunevillarendenawl1.setNode(this.comunevillarendenawl1);
            this.elemspiazzomepe01.setBaseBridgeAddress(this.macspiazzomepe01);
            this.elemspiazzofasw01.setBaseBridgeAddress(this.macspiazzofasw01);
            this.elemspiasvigasw01.setBaseBridgeAddress(this.macspiasvigasw01);
            this.elemvillpizzasw01.setBaseBridgeAddress(this.macvillpizzasw01);
            this.elemvigrenmuasw01.setBaseBridgeAddress(this.macvigrenmuasw01);
            this.elemvrendmunasw01.setBaseBridgeAddress(this.macvrendmunasw01);
            this.elemdaremunasw01.setBaseBridgeAddress(this.macdaremunasw01);
            this.elemdaremunalv01.setBaseBridgeAddress(this.macdaremunalv01);
            this.elemvigrenmualv01.setBaseBridgeAddress(this.macvigrenmualv01);
            this.elemvigrenmualv02.setBaseBridgeAddress(this.macvigrenmualv02);
            this.elemvrendmunalv02.setBaseBridgeAddress(this.macvrendmunalv02);
            this.elemrsaspiazzowl1.setBaseBridgeAddress(this.macrsaspiazzowl1);
            this.elemcomunespiazzowl1.setBaseBridgeAddress(this.macomunespiazzowl1);
            this.elemcomunevillarendenawl1.setBaseBridgeAddress(this.maccomunevillarendenawl1);
            this.elemlist.add(this.elemspiazzomepe01);
            this.elemlist.add(this.elemdaremunasw01);
            this.elemlist.add(this.elemspiazzofasw01);
            this.elemlist.add(this.elemspiasvigasw01);
            this.elemlist.add(this.elemvillpizzasw01);
            this.elemlist.add(this.elemvigrenmuasw01);
            this.elemlist.add(this.elemvrendmunasw01);
            this.elemlist.add(this.elemdaremunalv01);
            this.elemlist.add(this.elemvigrenmualv01);
            this.elemlist.add(this.elemvigrenmualv02);
            this.elemlist.add(this.elemvrendmunalv02);
            this.elemlist.add(this.elemrsaspiazzowl1);
            this.elemlist.add(this.elemcomunespiazzowl1);
            this.elemlist.add(this.elemcomunevillarendenawl1);
            this.bftspiazzomepe01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzomepe01, 0, 10100, this.mac000c29f49b8a, 2204));
            this.bftspiazzomepe01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzomepe01, 0, 10100, this.mace48d8c3b04b7, 2204));
            this.bftspiazzomepe01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzomepe01, 3, 10103, this.mac0017c8288325, 3001));
            this.bftspiazzomepe01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzomepe01, 3, 10103, this.mac9cb65475cca4, 3001));
            this.bftspiazzomepe01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzomepe01, 3, 10103, this.mac000424ab02d9, 3001));
            this.bftspiazzomepe01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzomepe01, 3, 10103, this.mac0011323f881d, 3001));
            this.bftspiazzomepe01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzomepe01, 3, 10103, this.mac000074f204a6, 3001));
            this.bftspiazzomepe01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzomepe01, 3, 10103, this.mac3ca82a7efb8f, 3001));
            this.bftspiazzomepe01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzomepe01, 5, 10105, this.macdaremunasw01, 3050));
            this.bftspiazzomepe01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzomepe01, 5, 10105, this.mac001ebe70cec0, 3050));
            this.bftspiazzomepe01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzomepe01, 24, 10124, this.macdaremunasw01, 25));
            this.bftspiazzomepe01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzomepe01, 24, 10124, this.mac001ebe70cec0, 25));
            this.bftspiazzomepe01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzomepe01, 6, 10106, this.mac0022557fd68f, 3060));
            this.bftspiazzomepe01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzomepe01, 24, 10124, this.mac0022557fd68f, 803));
            this.bftspiazzomepe01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzomepe01, 7, 10107, this.mace48d8c2e100c, 3072));
            this.bftspiazzomepe01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzomepe01, 8, 10108, this.macvrendmunasw01, 3080));
            this.bftspiazzomepe01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzomepe01, 8, 10108, this.mac001906d5cf50, 3080));
            this.bftspiazzomepe01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzomepe01, 24, 10124, this.macvrendmunasw01, 25));
            this.bftspiazzomepe01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzomepe01, 24, 10124, this.mac001906d5cf50, 25));
            this.bftspiazzomepe01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzomepe01, 24, 10124, this.macspiazzofasw01, 25));
            this.bftspiazzomepe01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzomepe01, 24, 10124, this.macdaremunalv01, 25));
            this.bftspiazzomepe01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzomepe01, 24, 10124, this.macvigrenmuasw01, 25));
            this.bftspiazzomepe01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzomepe01, 24, 10124, this.macspiasvigasw01, 25));
            this.bftspiazzomepe01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzomepe01, 24, 10124, this.macvigrenmualv01, 25));
            this.bftspiazzomepe01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzomepe01, 24, 10124, this.maccomunevillarendenawl1, 25));
            this.bftspiazzomepe01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzomepe01, 24, 10124, this.macvigrenmualv02, 25));
            this.bftspiazzomepe01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzomepe01, 24, 10124, this.macomunespiazzowl1, 25));
            this.bftspiazzomepe01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzomepe01, 24, 10124, this.macvillpizzasw01, 25));
            this.bftspiazzomepe01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzomepe01, 24, 10124, this.macrsaspiazzowl1, 25));
            this.bftspiazzomepe01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzomepe01, 24, 10124, this.macvrendmunalv02, 25));
            this.bftspiazzomepe01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzomepe01, 24, 10124, this.mac0003ea0175d6, 25));
            this.bftspiazzomepe01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzomepe01, 24, 10124, this.mac00804867f4e7, 2204));
            this.bftspiazzomepe01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzomepe01, 24, 10124, this.macd4ca6dff4217, 2204));
            this.bftspiazzomepe01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzomepe01, 24, 10124, this.mac00804867f17e, 2204));
            this.bftspiazzomepe01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzomepe01, 24, 10124, this.mac001763010f41, 25));
            this.bftspiazzomepe01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzomepe01, 24, 10124, this.mac001763010eb7, 25));
            this.bftspiazzomepe01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzomepe01, 24, 10124, this.mac00176301092d, 25));
            this.bftspiazzomepe01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzomepe01, 24, 10124, this.mac4c5e0c8007a1, 2204));
            this.bftspiazzomepe01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzomepe01, 24, 10124, this.macc067af3ce581, 25));
            this.bftspiazzomepe01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzomepe01, 24, 10124, this.mac008048676c89, 25));
            this.bftspiazzomepe01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzomepe01, 24, 10124, this.mac4c5e0c8076b0, 25));
            this.bftspiazzomepe01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzomepe01, 24, 10124, this.macc067af3ce614, 25));
            this.bftspiazzomepe01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzomepe01, 24, 10124, this.mac000d48160cd3, 2204));
            this.bftspiazzomepe01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzomepe01, 24, 10124, this.mac00176301057d, 25));
            this.bftspiazzomepe01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzomepe01, 24, 10124, this.mace48d8cf17bcb, 25));
            this.bftspiazzomepe01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzomepe01, 24, 10124, this.mac002255362620, 25));
            this.bftspiazzomepe01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzomepe01, 24, 10124, this.macc067af3ce59d, 25));
            this.bftspiazzomepe01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzomepe01, 24, 10124, this.mac00804864187d, 2204));
            this.bftspiazzomepe01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzomepe01, 24, 10124, this.mac0012cf68d780, 25));
            this.bftspiazzomepe01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzomepe01, 24, 10124, this.mac4c0082245938, 811));
            this.bftspiazzomepe01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzomepe01, 24, 10124, this.macc067af3ce623, 811));
            this.bftspiazzomepe01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzomepe01, 24, 10124, this.mac0003ea0176ca, 25));
            this.bftspiazzomepe01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzomepe01, 24, 10124, this.mac002255362ba7, 800));
            this.bftspiazzomepe01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzomepe01, 24, 10124, this.mac00e0b1bb39cd, 25));
            this.bftspiazzomepe01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzomepe01, 24, 10124, this.macd4ca6d4f1ab2, 25));
            this.bftspiazzomepe01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzomepe01, 24, 10124, this.macd4ca6d7953fe, 25));
            this.bftspiazzofasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzofasw01, (Integer)1, 1001, this.macspiasvigasw01));
            this.bftspiazzofasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzofasw01, (Integer)1, 1001, this.maccomunevillarendenawl1));
            this.bftspiazzofasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzofasw01, (Integer)1, 1001, this.macvrendmunasw01));
            this.bftspiazzofasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzofasw01, (Integer)1, 1001, this.macdaremunasw01));
            this.bftspiazzofasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzofasw01, (Integer)1, 1001, this.macvillpizzasw01));
            this.bftspiazzofasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzofasw01, (Integer)1, 1001, this.macvrendmunalv02));
            this.bftspiazzofasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzofasw01, (Integer)1, 1001, this.macvigrenmualv02));
            this.bftspiazzofasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzofasw01, (Integer)1, 1001, this.macomunespiazzowl1));
            this.bftspiazzofasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzofasw01, (Integer)1, 1001, this.macvigrenmualv01));
            this.bftspiazzofasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzofasw01, (Integer)1, 1001, this.macvigrenmuasw01));
            this.bftspiazzofasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzofasw01, (Integer)1, 1001, this.macdaremunalv01));
            this.bftspiazzofasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzofasw01, (Integer)1, 1001, this.macrsaspiazzowl1));
            this.bftspiazzofasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzofasw01, (Integer)1, 1001, this.mac001763010eb7));
            this.bftspiazzofasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzofasw01, (Integer)1, 1001, this.mac00176301092d));
            this.bftspiazzofasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzofasw01, (Integer)1, 1001, this.mac001ebe70cec0));
            this.bftspiazzofasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzofasw01, (Integer)1, 1001, this.mac00804867f4e7));
            this.bftspiazzofasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzofasw01, (Integer)1, 1001, this.macc067af3ce623));
            this.bftspiazzofasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzofasw01, (Integer)1, 1001, this.mac4c5e0c8007a1));
            this.bftspiazzofasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzofasw01, (Integer)1, 1001, this.mac00e0b1bba8f4));
            this.bftspiazzofasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzofasw01, (Integer)1, 1001, this.mac0003ea0176ca));
            this.bftspiazzofasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzofasw01, (Integer)1, 1001, this.mac001763010f41));
            this.bftspiazzofasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzofasw01, (Integer)1, 1001, this.mac00804867f17e));
            this.bftspiazzofasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzofasw01, (Integer)1, 1001, this.mac00e0b1bba390));
            this.bftspiazzofasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzofasw01, (Integer)1, 1001, this.mac008048676c89));
            this.bftspiazzofasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzofasw01, (Integer)1, 1001, this.mac000d48160cd3));
            this.bftspiazzofasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzofasw01, (Integer)1, 1001, this.mac002255362ba7));
            this.bftspiazzofasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzofasw01, (Integer)1, 1001, this.macd4ca6d7953fe));
            this.bftspiazzofasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzofasw01, (Integer)1, 1001, this.macc067af3ce581));
            this.bftspiazzofasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzofasw01, (Integer)1, 1001, this.mac0003ea0175d6));
            this.bftspiazzofasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzofasw01, (Integer)1, 1001, this.macd4ca6dff4217));
            this.bftspiazzofasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzofasw01, (Integer)1, 1001, this.macc067af3ce614));
            this.bftspiazzofasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzofasw01, (Integer)1, 1001, this.mac001906d5cf50));
            this.bftspiazzofasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzofasw01, (Integer)1, 1001, this.mace48d8cf17bcb));
            this.bftspiazzofasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzofasw01, (Integer)1, 1001, this.mac00176301057d));
            this.bftspiazzofasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzofasw01, (Integer)1, 1001, this.macd4ca6d4f1ab2));
            this.bftspiazzofasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzofasw01, (Integer)1, 1001, this.mac0022557fd68f));
            this.bftspiazzofasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzofasw01, (Integer)1, 1001, this.mac0012cf68d780));
            this.bftspiazzofasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzofasw01, (Integer)1, 1001, this.mac00804864187d));
            this.bftspiazzofasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzofasw01, (Integer)1, 1001, this.macc067af3ce59d));
            this.bftspiazzofasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzofasw01, (Integer)1, 1001, this.mac4c5e0c8076b0));
            this.bftspiazzofasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzofasw01, (Integer)19, 1019, this.mac4c0082245938));
            this.bftspiazzofasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzofasw01, (Integer)23, 1023, this.mac002255362620));
            this.bftspiazzofasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzofasw01, (Integer)24, 1024, this.mace48d8c3b04b7));
            this.bftspiazzofasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiazzofasw01, (Integer)24, 1024, this.mac0c8525e8f3c0));
            this.bftspiasvigasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiasvigasw01, (Integer)1, 1001, this.macvrendmunalv02));
            this.bftspiasvigasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiasvigasw01, (Integer)1, 1001, this.macvigrenmualv02));
            this.bftspiasvigasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiasvigasw01, (Integer)1, 1001, this.macvrendmunasw01));
            this.bftspiasvigasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiasvigasw01, (Integer)1, 1001, this.macdaremunasw01));
            this.bftspiasvigasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiasvigasw01, (Integer)1, 1001, this.macomunespiazzowl1));
            this.bftspiasvigasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiasvigasw01, (Integer)1, 1001, this.maccomunevillarendenawl1));
            this.bftspiasvigasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiasvigasw01, (Integer)1, 1001, this.macspiazzofasw01));
            this.bftspiasvigasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiasvigasw01, (Integer)1, 1001, this.macvigrenmuasw01));
            this.bftspiasvigasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiasvigasw01, (Integer)1, 1001, this.macdaremunalv01));
            this.bftspiasvigasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiasvigasw01, (Integer)1, 1001, this.macrsaspiazzowl1));
            this.bftspiasvigasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiasvigasw01, (Integer)1, 1001, this.mac001ebe70cec0));
            this.bftspiasvigasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiasvigasw01, (Integer)1, 1001, this.mac00804867f4e7));
            this.bftspiasvigasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiasvigasw01, (Integer)1, 1001, this.mac4c5e0c8007a1));
            this.bftspiasvigasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiasvigasw01, (Integer)1, 1001, this.macc067af3ce623));
            this.bftspiasvigasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiasvigasw01, (Integer)1, 1001, this.mac00e0b1bba8f4));
            this.bftspiasvigasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiasvigasw01, (Integer)1, 1001, this.mac00804867f17e));
            this.bftspiasvigasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiasvigasw01, (Integer)1, 1001, this.macc067af3ce581));
            this.bftspiasvigasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiasvigasw01, (Integer)1, 1001, this.mac00e0b1bb39b6));
            this.bftspiasvigasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiasvigasw01, (Integer)1, 1001, this.macd4ca6d7953fe));
            this.bftspiasvigasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiasvigasw01, (Integer)1, 1001, this.macd4ca6dff4217));
            this.bftspiasvigasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiasvigasw01, (Integer)1, 1001, this.mac0003ea0175d6));
            this.bftspiasvigasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiasvigasw01, (Integer)1, 1001, this.mac001906d5cf50));
            this.bftspiasvigasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiasvigasw01, (Integer)1, 1001, this.mace48d8cf17bcb));
            this.bftspiasvigasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiasvigasw01, (Integer)1, 1001, this.macc067af3ce614));
            this.bftspiasvigasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiasvigasw01, (Integer)1, 1001, this.mac0c8525e8f3c0));
            this.bftspiasvigasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiasvigasw01, (Integer)1, 1001, this.mac4c0082245938));
            this.bftspiasvigasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiasvigasw01, (Integer)1, 1001, this.macd4ca6d4f1ab2));
            this.bftspiasvigasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiasvigasw01, (Integer)1, 1001, this.mace48d8c3b04b7));
            this.bftspiasvigasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiasvigasw01, (Integer)1, 1001, this.mac00804864187d));
            this.bftspiasvigasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiasvigasw01, (Integer)1, 1001, this.mac0022557fd68f));
            this.bftspiasvigasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiasvigasw01, (Integer)1, 1001, this.macc067af3ce59d));
            this.bftspiasvigasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiasvigasw01, (Integer)1, 1001, this.mac4c5e0c8076b0));
            this.bftspiasvigasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiasvigasw01, (Integer)15, 1015, this.mac0003ea0176ca));
            this.bftspiasvigasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.spiasvigasw01, (Integer)24, 1024, this.mac002255362ba7));
            this.bftdaremunalv01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.daremunalv01, (Integer)2, 2, this.mac001ebe70cec0));
            this.bftdaremunalv01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.daremunalv01, (Integer)1, 1, this.mac00e0b1bb3ed5));
            this.bftdaremunalv01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.daremunalv01, (Integer)1, 1, this.mac00804867f17e));
            this.bftdaremunalv01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.daremunalv01, (Integer)1, 1, this.macc067af3ce623));
            this.bftdaremunalv01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.daremunalv01, (Integer)2, 2, this.mac001763010eb7));
            this.bftdaremunalv01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.daremunalv01, (Integer)1, 1, this.macvrendmunasw01));
            this.bftdaremunalv01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.daremunalv01, (Integer)1, 1, this.mac0003ea0176ca));
            this.bftdaremunalv01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.daremunalv01, (Integer)1, 1, this.macomunespiazzowl1));
            this.bftdaremunalv01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.daremunalv01, (Integer)2, 2, this.mac4c5e0c8007a1));
            this.bftdaremunalv01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.daremunalv01, (Integer)1, 1, this.mac00804867f4e7));
            this.bftdaremunalv01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.daremunalv01, (Integer)1, 1, this.macvigrenmuasw01));
            this.bftdaremunalv01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.daremunalv01, (Integer)1, 1, this.mac4c5e0c8076b0));
            this.bftdaremunalv01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.daremunalv01, (Integer)1, 1, this.macspiazzofasw01));
            this.bftdaremunalv01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.daremunalv01, (Integer)2, 2, this.mac00e0b1bbac56));
            this.bftdaremunalv01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.daremunalv01, (Integer)1, 1, this.macd4ca6d7953fe));
            this.bftdaremunalv01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.daremunalv01, (Integer)2, 2, this.macc067af3ce581));
            this.bftdaremunalv01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.daremunalv01, (Integer)1, 1, this.macd4ca6dff4217));
            this.bftdaremunalv01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.daremunalv01, (Integer)1, 1, this.macrsaspiazzowl1));
            this.bftdaremunalv01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.daremunalv01, (Integer)1, 1, this.mac0003ea0175d6));
            this.bftdaremunalv01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.daremunalv01, (Integer)1, 1, this.macspiasvigasw01));
            this.bftdaremunalv01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.daremunalv01, (Integer)1, 1, this.macc067af3ce614));
            this.bftdaremunalv01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.daremunalv01, (Integer)2, 2, this.macdaremunasw01));
            this.bftdaremunalv01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.daremunalv01, (Integer)1, 1, this.macc067af3ce59d));
            this.bftdaremunalv01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.daremunalv01, (Integer)1, 1, this.mac00804864187d));
            this.bftdaremunalv01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.daremunalv01, (Integer)1, 1, this.mac0022557fd68f));
            this.bftdaremunalv01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.daremunalv01, (Integer)1, 1, this.mac4c0082245938));
            this.bftdaremunalv01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.daremunalv01, (Integer)1, 1, this.mace48d8cf17bcb));
            this.bftdaremunalv01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.daremunalv01, (Integer)1, 1, this.mace48d8c3b04b7));
            this.bftdaremunalv01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.daremunalv01, (Integer)1, 1, this.mac001906d5cf50));
            this.bftdaremunalv01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.daremunalv01, (Integer)1, 1, this.macd4ca6d4f1ab2));
            this.bftdaremunalv01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.daremunalv01, (Integer)1, 1, this.maccomunevillarendenawl1));
            this.bftdaremunalv01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.daremunalv01, (Integer)1, 1, this.mac0c8525e8f3c0));
            this.bftvillpizzasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.villpizzasw01, (Integer)1, 1, this.mac00804867f17e));
            this.bftvillpizzasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.villpizzasw01, (Integer)1, 1, this.macc067af3ce623));
            this.bftvillpizzasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.villpizzasw01, (Integer)1, 1, this.macvrendmunasw01));
            this.bftvillpizzasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.villpizzasw01, (Integer)1, 1, this.macvigrenmualv02));
            this.bftvillpizzasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.villpizzasw01, (Integer)1, 1, this.mac0003ea0176ca));
            this.bftvillpizzasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.villpizzasw01, (Integer)1, 1, this.mac00e0b1bba8f2));
            this.bftvillpizzasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.villpizzasw01, (Integer)1, 1, this.macomunespiazzowl1));
            this.bftvillpizzasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.villpizzasw01, (Integer)1, 1, this.mac00804867f4e7));
            this.bftvillpizzasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.villpizzasw01, (Integer)1, 1, this.mac4c5e0c8007a1));
            this.bftvillpizzasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.villpizzasw01, (Integer)1, 1, this.macvigrenmuasw01));
            this.bftvillpizzasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.villpizzasw01, (Integer)1, 1, this.macrsaspiazzowl1));
            this.bftvillpizzasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.villpizzasw01, (Integer)1, 1, this.macc067af3ce581));
            this.bftvillpizzasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.villpizzasw01, (Integer)1, 1, this.mac4c5e0c8076b0));
            this.bftvillpizzasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.villpizzasw01, (Integer)1, 1, this.macd4ca6dff4217));
            this.bftvillpizzasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.villpizzasw01, (Integer)1, 1, this.macc067af3ce614));
            this.bftvillpizzasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.villpizzasw01, (Integer)1, 1, this.mace48d8cf17bcb));
            this.bftvillpizzasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.villpizzasw01, (Integer)1, 1, this.macspiasvigasw01));
            this.bftvillpizzasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.villpizzasw01, (Integer)1, 1, this.macvigrenmualv01));
            this.bftvillpizzasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.villpizzasw01, (Integer)1, 1, this.macdaremunasw01));
            this.bftvillpizzasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.villpizzasw01, (Integer)1, 1, this.macspiazzofasw01));
            this.bftvillpizzasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.villpizzasw01, (Integer)1, 1, this.mac0022557fd68f));
            this.bftvillpizzasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.villpizzasw01, (Integer)1, 1, this.mac00804864187d));
            this.bftvillpizzasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.villpizzasw01, (Integer)1, 1, this.mac4c0082245938));
            this.bftvillpizzasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.villpizzasw01, (Integer)1, 1, this.macc067af3ce59d));
            this.bftvillpizzasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.villpizzasw01, (Integer)1, 1, this.mac001906d5cf50));
            this.bftvillpizzasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.villpizzasw01, (Integer)1, 1, this.macd4ca6d4f1ab2));
            this.bftvillpizzasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.villpizzasw01, (Integer)1, 1, this.mace48d8c3b04b7));
            this.bftvillpizzasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.villpizzasw01, (Integer)1, 1, this.maccomunevillarendenawl1));
            this.bftvillpizzasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.villpizzasw01, (Integer)1, 1, this.mac0c8525e8f3c0));
            this.bftvillpizzasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.villpizzasw01, (Integer)1, 1, this.macd4ca6d7953fe));
            this.bftrsaspiazzowl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.rsaspiazzowl1, (Integer)5, 5, this.macdaremunalv01));
            this.bftrsaspiazzowl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.rsaspiazzowl1, (Integer)5, 5, this.mac008048676c89));
            this.bftrsaspiazzowl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.rsaspiazzowl1, (Integer)4, 4, this.macd4ca6dff4217));
            this.bftrsaspiazzowl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.rsaspiazzowl1, (Integer)5, 5, this.mac001906d5cf50));
            this.bftrsaspiazzowl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.rsaspiazzowl1, (Integer)5, 5, this.macvillpizzasw01));
            this.bftrsaspiazzowl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.rsaspiazzowl1, (Integer)5, 5, this.mac00176301057d));
            this.bftrsaspiazzowl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.rsaspiazzowl1, (Integer)5, 5, this.macc067af3ce614));
            this.bftrsaspiazzowl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.rsaspiazzowl1, (Integer)1, 1, this.macrsaspiazzowl1));
            this.bftrsaspiazzowl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.rsaspiazzowl1, (Integer)4, 4, this.mac000c29f49b8a));
            this.bftrsaspiazzowl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.rsaspiazzowl1, (Integer)5, 5, this.macvigrenmuasw01));
            this.bftrsaspiazzowl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.rsaspiazzowl1, (Integer)5, 5, this.macdaremunasw01));
            this.bftrsaspiazzowl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.rsaspiazzowl1, (Integer)4, 4, this.macspiazzofasw01));
            this.bftrsaspiazzowl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.rsaspiazzowl1, (Integer)5, 5, this.macc067af3ce59d));
            this.bftrsaspiazzowl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.rsaspiazzowl1, (Integer)1, 1, this.macspiasvigasw01));
            this.bftrsaspiazzowl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.rsaspiazzowl1, (Integer)5, 5, this.mac4c5e0c8076b0));
            this.bftrsaspiazzowl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.rsaspiazzowl1, (Integer)5, 5, this.mace48d8cf17bcb));
            this.bftrsaspiazzowl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.rsaspiazzowl1, (Integer)4, 4, this.mac00e0b1bb39b6));
            this.bftrsaspiazzowl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.rsaspiazzowl1, (Integer)5, 5, this.mac001763010eb7));
            this.bftrsaspiazzowl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.rsaspiazzowl1, (Integer)5, 5, this.mac0012cf68d780));
            this.bftrsaspiazzowl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.rsaspiazzowl1, (Integer)4, 4, this.mac0c8525e8f3c0));
            this.bftrsaspiazzowl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.rsaspiazzowl1, (Integer)4, 4, this.mac4c0082245938));
            this.bftrsaspiazzowl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.rsaspiazzowl1, (Integer)4, 4, this.macd4ca6d7953fe));
            this.bftrsaspiazzowl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.rsaspiazzowl1, (Integer)4, 4, this.mac4c5e0c104aac));
            this.bftrsaspiazzowl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.rsaspiazzowl1, (Integer)4, 4, this.macd4ca6d4f1ab2));
            this.bftrsaspiazzowl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.rsaspiazzowl1, (Integer)4, 4, this.mace48d8c3b04b7));
            this.bftrsaspiazzowl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.rsaspiazzowl1, (Integer)5, 5, this.mac00804867f4e7));
            this.bftrsaspiazzowl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.rsaspiazzowl1, (Integer)5, 5, this.maccomunevillarendenawl1));
            this.bftrsaspiazzowl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.rsaspiazzowl1, (Integer)5, 5, this.mac4c5e0c104bfa));
            this.bftrsaspiazzowl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.rsaspiazzowl1, (Integer)5, 5, this.macc067af3ce623));
            this.bftrsaspiazzowl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.rsaspiazzowl1, (Integer)5, 5, this.macvrendmunasw01));
            this.bftrsaspiazzowl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.rsaspiazzowl1, (Integer)5, 5, this.mac001763010f41));
            this.bftrsaspiazzowl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.rsaspiazzowl1, (Integer)5, 5, this.mac00804864187d));
            this.bftrsaspiazzowl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.rsaspiazzowl1, (Integer)5, 5, this.mac0022557fd68f));
            this.bftrsaspiazzowl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.rsaspiazzowl1, (Integer)5, 5, this.mac00e0b1bba8f4));
            this.bftrsaspiazzowl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.rsaspiazzowl1, (Integer)5, 5, this.mac00804867f17e));
            this.bftrsaspiazzowl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.rsaspiazzowl1, (Integer)1, 1, this.mac0003ea0176ca));
            this.bftrsaspiazzowl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.rsaspiazzowl1, (Integer)5, 5, this.mac00176301092d));
            this.bftrsaspiazzowl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.rsaspiazzowl1, (Integer)1, 1, this.mac00e0b1bba390));
            this.bftrsaspiazzowl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.rsaspiazzowl1, (Integer)4, 4, this.macomunespiazzowl1));
            this.bftrsaspiazzowl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.rsaspiazzowl1, (Integer)5, 5, this.macvigrenmualv01));
            this.bftrsaspiazzowl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.rsaspiazzowl1, (Integer)5, 5, this.macvigrenmualv02));
            this.bftrsaspiazzowl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.rsaspiazzowl1, (Integer)5, 5, this.macvrendmunalv02));
            this.bftrsaspiazzowl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.rsaspiazzowl1, (Integer)5, 5, this.mac001ebe70cec0));
            this.bftrsaspiazzowl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.rsaspiazzowl1, (Integer)1, 1, this.mac002255362ba7));
            this.bftrsaspiazzowl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.rsaspiazzowl1, (Integer)5, 5, this.mac0003ea0175d6));
            this.bftrsaspiazzowl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.rsaspiazzowl1, (Integer)5, 5, this.mac4c5e0c8007a1));
            this.bftrsaspiazzowl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.rsaspiazzowl1, (Integer)5, 5, this.macc067af3ce581));
            this.bftvigrenmualv01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmualv01, (Integer)2, 2, this.mac4c5e0c8007a1));
            this.bftvigrenmualv01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmualv01, (Integer)1, 1, this.macc067af3ce623));
            this.bftvigrenmualv01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmualv01, (Integer)1, 1, this.mac00804867f4e7));
            this.bftvigrenmualv01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmualv01, (Integer)1, 1, this.mace48d8c3b04b7));
            this.bftvigrenmualv01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmualv01, (Integer)1, 1, this.macd4ca6d4f1ab2));
            this.bftvigrenmualv01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmualv01, (Integer)1, 1, this.maccomunevillarendenawl1));
            this.bftvigrenmualv01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmualv01, (Integer)1, 1, this.macvrendmunasw01));
            this.bftvigrenmualv01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmualv01, (Integer)1, 1, this.mac0003ea0176ca));
            this.bftvigrenmualv01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmualv01, (Integer)1, 1, this.mac00804864187d));
            this.bftvigrenmualv01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmualv01, (Integer)1, 1, this.mac0022557fd68f));
            this.bftvigrenmualv01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmualv01, (Integer)1, 1, this.mac00804867f17e));
            this.bftvigrenmualv01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmualv01, (Integer)1, 1, this.macomunespiazzowl1));
            this.bftvigrenmualv01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmualv01, (Integer)2, 2, this.macvigrenmualv02));
            this.bftvigrenmualv01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmualv01, (Integer)2, 2, this.mac001ebe70cec0));
            this.bftvigrenmualv01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmualv01, (Integer)2, 2, this.macc067af3ce581));
            this.bftvigrenmualv01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmualv01, (Integer)1, 1, this.mac0003ea0175d6));
            this.bftvigrenmualv01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmualv01, (Integer)1, 1, this.mac00e0b1bba8fc));
            this.bftvigrenmualv01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmualv01, (Integer)1, 1, this.macspiasvigasw01));
            this.bftvigrenmualv01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmualv01, (Integer)1, 1, this.mac001906d5cf50));
            this.bftvigrenmualv01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmualv01, (Integer)2, 2, this.macdaremunasw01));
            this.bftvigrenmualv01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmualv01, (Integer)1, 1, this.mac0c8525e8f3c0));
            this.bftvigrenmualv01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmualv01, (Integer)2, 2, this.macc067af3ce614));
            this.bftvigrenmualv01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmualv01, (Integer)1, 1, this.macc067af3ce59d));
            this.bftvigrenmualv01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmualv01, (Integer)1, 1, this.mac4c5e0c8076b0));
            this.bftvigrenmualv01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmualv01, (Integer)1, 1, this.macspiazzofasw01));
            this.bftvigrenmualv01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmualv01, (Integer)1, 1, this.macrsaspiazzowl1));
            this.bftvigrenmualv01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmualv01, (Integer)1, 1, this.mace48d8cf17bcb));
            this.bftvigrenmualv01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmualv01, (Integer)2, 2, this.mac001763010eb7));
            this.bftvigrenmualv01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmualv01, (Integer)2, 2, this.macvigrenmuasw01));
            this.bftvigrenmualv01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmualv01, (Integer)1, 1, this.macd4ca6d7953fe));
            this.bftvigrenmualv01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmualv01, (Integer)2, 2, this.macdaremunalv01));
            this.bftvigrenmualv01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmualv01, (Integer)1, 1, this.macd4ca6dff4217));
            this.bftvigrenmualv01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmualv01, (Integer)2, 2, this.mac00e0b1bb3ed4));
            this.bftvigrenmualv01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmualv01, (Integer)1, 1, this.mac4c0082245938));
            this.bftvigrenmualv02.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmualv02, (Integer)2, 2, this.mac00804867f4e7));
            this.bftvigrenmualv02.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmualv02, (Integer)2, 2, this.macc067af3ce623));
            this.bftvigrenmualv02.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmualv02, (Integer)2, 2, this.macvrendmunasw01));
            this.bftvigrenmualv02.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmualv02, (Integer)2, 2, this.mace48d8c3b04b7));
            this.bftvigrenmualv02.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmualv02, (Integer)2, 2, this.maccomunevillarendenawl1));
            this.bftvigrenmualv02.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmualv02, (Integer)2, 2, this.macd4ca6d4f1ab2));
            this.bftvigrenmualv02.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmualv02, (Integer)32769, 32769, this.macdaremunasw01));
            this.bftvigrenmualv02.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmualv02, (Integer)2, 2, this.mac0022557fd68f));
            this.bftvigrenmualv02.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmualv02, (Integer)2, 2, this.mac0003ea0176ca));
            this.bftvigrenmualv02.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmualv02, (Integer)2, 2, this.mac00804867f17e));
            this.bftvigrenmualv02.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmualv02, (Integer)2, 2, this.mac00804864187d));
            this.bftvigrenmualv02.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmualv02, (Integer)32769, 32769, this.mac001763010eb7));
            this.bftvigrenmualv02.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmualv02, (Integer)2, 2, this.macvigrenmualv01));
            this.bftvigrenmualv02.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmualv02, (Integer)2, 2, this.macspiazzofasw01));
            this.bftvigrenmualv02.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmualv02, (Integer)32769, 32769, this.mac00e0b1bbac56));
            this.bftvigrenmualv02.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmualv02, (Integer)2, 2, this.mac0003ea0175d6));
            this.bftvigrenmualv02.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmualv02, (Integer)2, 2, this.mac00e0b1bb3ed5));
            this.bftvigrenmualv02.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmualv02, (Integer)32769, 32769, this.mac4c5e0c8007a1));
            this.bftvigrenmualv02.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmualv02, (Integer)2, 2, this.macc067af3ce614));
            this.bftvigrenmualv02.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmualv02, (Integer)2, 2, this.mac001906d5cf50));
            this.bftvigrenmualv02.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmualv02, (Integer)2, 2, this.mace48d8cf17bcb));
            this.bftvigrenmualv02.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmualv02, (Integer)2, 2, this.macspiasvigasw01));
            this.bftvigrenmualv02.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmualv02, (Integer)2, 2, this.mac0c8525e8f3c0));
            this.bftvigrenmualv02.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmualv02, (Integer)2, 2, this.macrsaspiazzowl1));
            this.bftvigrenmualv02.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmualv02, (Integer)2, 2, this.macomunespiazzowl1));
            this.bftvigrenmualv02.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmualv02, (Integer)2, 2, this.macc067af3ce59d));
            this.bftvigrenmualv02.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmualv02, (Integer)2, 2, this.mac4c5e0c8076b0));
            this.bftvigrenmualv02.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmualv02, (Integer)2, 2, this.macd4ca6d7953fe));
            this.bftvigrenmualv02.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmualv02, (Integer)2, 2, this.macvigrenmuasw01));
            this.bftvigrenmualv02.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmualv02, (Integer)32769, 32769, this.macc067af3ce581));
            this.bftvigrenmualv02.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmualv02, (Integer)2, 2, this.mac4c0082245938));
            this.bftvigrenmualv02.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmualv02, (Integer)32769, 32769, this.mac001ebe70cec0));
            this.bftvigrenmualv02.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmualv02, (Integer)2, 2, this.macd4ca6dff4217));
            this.bftvigrenmuasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmuasw01, (Integer)11, 1011, this.maccomunevillarendenawl1));
            this.bftvigrenmuasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmuasw01, (Integer)11, 1011, this.macomunespiazzowl1));
            this.bftvigrenmuasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmuasw01, (Integer)11, 1011, this.macvrendmunasw01));
            this.bftvigrenmuasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmuasw01, (Integer)11, 1011, this.macrsaspiazzowl1));
            this.bftvigrenmuasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmuasw01, (Integer)11, 1011, this.macspiasvigasw01));
            this.bftvigrenmuasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmuasw01, (Integer)11, 1011, this.macspiazzofasw01));
            this.bftvigrenmuasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmuasw01, (Integer)11, 1011, this.mac0003ea0175d6));
            this.bftvigrenmuasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmuasw01, (Integer)11, 1011, this.mac00e0b1bba8fc));
            this.bftvigrenmuasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmuasw01, (Integer)11, 1011, this.mac4c5e0c8076b0));
            this.bftvigrenmuasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmuasw01, (Integer)11, 1011, this.mac001906d5cf50));
            this.bftvigrenmuasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmuasw01, (Integer)11, 1011, this.mace48d8cf17bcb));
            this.bftvigrenmuasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmuasw01, (Integer)11, 1011, this.mac4c0082245938));
            this.bftvigrenmuasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmuasw01, (Integer)11, 1011, this.macd4ca6d4f1ab2));
            this.bftvigrenmuasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmuasw01, (Integer)11, 1011, this.mace48d8c3b04b7));
            this.bftvigrenmuasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmuasw01, (Integer)11, 1011, this.macd4ca6d7953fe));
            this.bftvigrenmuasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmuasw01, (Integer)11, 1011, this.macc067af3ce59d));
            this.bftvigrenmuasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmuasw01, (Integer)11, 1011, this.mac0c8525e8f3c0));
            this.bftvigrenmuasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmuasw01, (Integer)11, 1011, this.macd4ca6dff4217));
            this.bftvigrenmuasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmuasw01, (Integer)11, 1011, this.mac00804867f17e));
            this.bftvigrenmuasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmuasw01, (Integer)11, 1011, this.macc067af3ce623));
            this.bftvigrenmuasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmuasw01, (Integer)11, 1011, this.mac00804867f4e7));
            this.bftvigrenmuasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmuasw01, (Integer)11, 1011, this.mac0003ea0176ca));
            this.bftvigrenmuasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmuasw01, (Integer)11, 1011, this.mac00804864187d));
            this.bftvigrenmuasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmuasw01, (Integer)11, 1011, this.mac0022557fd68f));
            this.bftvigrenmuasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmuasw01, (Integer)12, 1012, this.macdaremunalv01));
            this.bftvigrenmuasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmuasw01, (Integer)12, 1012, this.macvigrenmualv02));
            this.bftvigrenmuasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmuasw01, (Integer)12, 1012, this.macdaremunasw01));
            this.bftvigrenmuasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmuasw01, (Integer)12, 1012, this.mac4c5e0c8007a1));
            this.bftvigrenmuasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmuasw01, (Integer)12, 1012, this.mac00e0b1bbac56));
            this.bftvigrenmuasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmuasw01, (Integer)12, 1012, this.macc067af3ce581));
            this.bftvigrenmuasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmuasw01, (Integer)12, 1012, this.mac001763010eb7));
            this.bftvigrenmuasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vigrenmuasw01, (Integer)19, 1019, this.macc067af3ce614));
            this.bftvrendmunalv02.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vrendmunalv02, (Integer)32769, 32769, this.macc067af3ce614));
            this.bftvrendmunalv02.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vrendmunalv02, (Integer)2, 2, this.mac4c0082245938));
            this.bftvrendmunalv02.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vrendmunalv02, (Integer)2, 2, this.maccomunevillarendenawl1));
            this.bftvrendmunalv02.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vrendmunalv02, (Integer)32769, 32769, this.macdaremunasw01));
            this.bftvrendmunalv02.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vrendmunalv02, (Integer)2, 2, this.macvrendmunasw01));
            this.bftvrendmunalv02.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vrendmunalv02, (Integer)2, 2, this.mace48d8c3b04b7));
            this.bftvrendmunalv02.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vrendmunalv02, (Integer)2, 2, this.mac0003ea0176ca));
            this.bftvrendmunalv02.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vrendmunalv02, (Integer)2, 2, this.macd4ca6d4f1ab2));
            this.bftvrendmunalv02.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vrendmunalv02, (Integer)2, 2, this.mac00804864187d));
            this.bftvrendmunalv02.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vrendmunalv02, (Integer)2, 2, this.mac0022557fd68f));
            this.bftvrendmunalv02.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vrendmunalv02, (Integer)2, 2, this.mac00804867f17e));
            this.bftvrendmunalv02.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vrendmunalv02, (Integer)2, 2, this.mac00804867f4e7));
            this.bftvrendmunalv02.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vrendmunalv02, (Integer)32769, 32769, this.mac001763010eb7));
            this.bftvrendmunalv02.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vrendmunalv02, (Integer)32769, 32769, this.mac00e0b1bb3ed4));
            this.bftvrendmunalv02.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vrendmunalv02, (Integer)2, 2, this.macspiazzofasw01));
            this.bftvrendmunalv02.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vrendmunalv02, (Integer)2, 2, this.mac0003ea0175d6));
            this.bftvrendmunalv02.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vrendmunalv02, (Integer)32769, 32769, this.macvigrenmuasw01));
            this.bftvrendmunalv02.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vrendmunalv02, (Integer)2, 2, this.mac00e0b1bba8fc));
            this.bftvrendmunalv02.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vrendmunalv02, (Integer)32769, 32769, this.macdaremunalv01));
            this.bftvrendmunalv02.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vrendmunalv02, (Integer)32769, 32769, this.mac4c5e0c8007a1));
            this.bftvrendmunalv02.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vrendmunalv02, (Integer)2, 2, this.mac0c8525e8f3c0));
            this.bftvrendmunalv02.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vrendmunalv02, (Integer)2, 2, this.mace48d8cf17bcb));
            this.bftvrendmunalv02.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vrendmunalv02, (Integer)2, 2, this.macspiasvigasw01));
            this.bftvrendmunalv02.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vrendmunalv02, (Integer)2, 2, this.macrsaspiazzowl1));
            this.bftvrendmunalv02.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vrendmunalv02, (Integer)2, 2, this.macomunespiazzowl1));
            this.bftvrendmunalv02.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vrendmunalv02, (Integer)2, 2, this.macc067af3ce59d));
            this.bftvrendmunalv02.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vrendmunalv02, (Integer)2, 2, this.mac4c5e0c8076b0));
            this.bftvrendmunalv02.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vrendmunalv02, (Integer)2, 2, this.mac001906d5cf50));
            this.bftvrendmunalv02.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vrendmunalv02, (Integer)32769, 32769, this.macc067af3ce581));
            this.bftvrendmunalv02.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vrendmunalv02, (Integer)32769, 32769, this.macvigrenmualv02));
            this.bftvrendmunalv02.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vrendmunalv02, (Integer)2, 2, this.macd4ca6d7953fe));
            this.bftvrendmunalv02.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vrendmunalv02, (Integer)32769, 32769, this.mac001ebe70cec0));
            this.bftvrendmunalv02.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vrendmunalv02, (Integer)2, 2, this.macd4ca6dff4217));
            this.bftvrendmunalv02.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vrendmunalv02, (Integer)2, 2, this.macc067af3ce623));
            this.bftdaremunasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.daremunasw01, (Integer)1, 1001, this.mac4c5e0c8007a1));
            this.bftdaremunasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.daremunasw01, (Integer)1, 1001, this.mac001763010eb7));
            this.bftdaremunasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.daremunasw01, (Integer)4, 1004, this.mac0c8525e8f3c0));
            this.bftdaremunasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.daremunasw01, (Integer)11, 1011, this.macspiazzofasw01));
            this.bftdaremunasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.daremunasw01, (Integer)11, 1011, this.macomunespiazzowl1));
            this.bftdaremunasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.daremunasw01, (Integer)11, 1011, this.macspiasvigasw01));
            this.bftdaremunasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.daremunasw01, (Integer)11, 1011, this.macvigrenmualv02));
            this.bftdaremunasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.daremunasw01, (Integer)11, 1011, this.macrsaspiazzowl1));
            this.bftdaremunasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.daremunasw01, (Integer)11, 1011, this.maccomunevillarendenawl1));
            this.bftdaremunasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.daremunasw01, (Integer)11, 1011, this.macvigrenmuasw01));
            this.bftdaremunasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.daremunasw01, (Integer)11, 1011, this.macvrendmunasw01));
            this.bftdaremunasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.daremunasw01, (Integer)11, 1011, this.mac0022557fd68f));
            this.bftdaremunasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.daremunasw01, (Integer)11, 1011, this.mac4c0082245938));
            this.bftdaremunasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.daremunasw01, (Integer)11, 1011, this.macd4ca6d7953fe));
            this.bftdaremunasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.daremunasw01, (Integer)11, 1011, this.mac0003ea0175d6));
            this.bftdaremunasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.daremunasw01, (Integer)11, 1011, this.macd4ca6d4f1ab2));
            this.bftdaremunasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.daremunasw01, (Integer)11, 1011, this.mace48d8c3b04b7));
            this.bftdaremunasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.daremunasw01, (Integer)11, 1011, this.mac4c5e0c8076b0));
            this.bftdaremunasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.daremunasw01, (Integer)11, 1011, this.mac001906d5cf50));
            this.bftdaremunasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.daremunasw01, (Integer)11, 1011, this.mace48d8cf17bcb));
            this.bftdaremunasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.daremunasw01, (Integer)11, 1011, this.macc067af3ce59d));
            this.bftdaremunasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.daremunasw01, (Integer)11, 1011, this.macc067af3ce614));
            this.bftdaremunasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.daremunasw01, (Integer)11, 1011, this.mac00804864187d));
            this.bftdaremunasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.daremunasw01, (Integer)11, 1011, this.mac00e0b1bb3ed5));
            this.bftdaremunasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.daremunasw01, (Integer)11, 1011, this.macd4ca6dff4217));
            this.bftdaremunasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.daremunasw01, (Integer)11, 1011, this.macc067af3ce623));
            this.bftdaremunasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.daremunasw01, (Integer)11, 1011, this.mac00804867f4e7));
            this.bftdaremunasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.daremunasw01, (Integer)11, 1011, this.mac00804867f17e));
            this.bftdaremunasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.daremunasw01, (Integer)11, 1011, this.mac0003ea0176ca));
            this.bftdaremunasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.daremunasw01, (Integer)18, 1018, this.mac001ebe70cec0));
            this.bftdaremunasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.daremunasw01, (Integer)19, 1019, this.macc067af3ce581));
            this.bftcomunespiazzowl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.comunespiazzowl1, (Integer)6, 6, this.mac0003ea0176ca));
            this.bftcomunespiazzowl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.comunespiazzowl1, (Integer)6, 6, this.mac0003ea0175d6));
            this.bftcomunespiazzowl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.comunespiazzowl1, (Integer)1, 1, this.mac000c29f49b8a));
            this.bftcomunespiazzowl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.comunespiazzowl1, (Integer)1, 1, this.macomunespiazzowl1));
            this.bftcomunespiazzowl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.comunespiazzowl1, (Integer)6, 6, this.maccomunevillarendenawl1));
            this.bftvrendmunasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vrendmunasw01, (Integer)1, 1001, this.macvillpizzasw01));
            this.bftvrendmunasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vrendmunasw01, (Integer)1, 1001, this.mace48d8cf17bcb));
            this.bftvrendmunasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vrendmunasw01, (Integer)1, 1001, this.macc067af3ce59d));
            this.bftvrendmunasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vrendmunasw01, (Integer)1, 1001, this.mac4c5e0c8076b0));
            this.bftvrendmunasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vrendmunasw01, (Integer)1, 1001, this.mac00804867f17e));
            this.bftvrendmunasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vrendmunasw01, (Integer)1, 1001, this.mac00804864187d));
            this.bftvrendmunasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vrendmunasw01, (Integer)1, 1001, this.mac001763010f41));
            this.bftvrendmunasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vrendmunasw01, (Integer)1, 1001, this.mac0022557fd68f));
            this.bftvrendmunasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vrendmunasw01, (Integer)1, 1001, this.mac00176301092d));
            this.bftvrendmunasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vrendmunasw01, (Integer)1, 1001, this.mac0003ea0175d6));
            this.bftvrendmunasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vrendmunasw01, (Integer)1, 1001, this.mac00176301057d));
            this.bftvrendmunasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vrendmunasw01, (Integer)1, 1001, this.mac0012cf68d780));
            this.bftvrendmunasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vrendmunasw01, (Integer)1, 1001, this.mac00804867f4e7));
            this.bftvrendmunasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vrendmunasw01, (Integer)3, 1003, this.macspiazzofasw01));
            this.bftvrendmunasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vrendmunasw01, (Integer)3, 1003, this.maccomunevillarendenawl1));
            this.bftvrendmunasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vrendmunasw01, (Integer)3, 1003, this.macspiasvigasw01));
            this.bftvrendmunasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vrendmunasw01, (Integer)3, 1003, this.macomunespiazzowl1));
            this.bftvrendmunasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vrendmunasw01, (Integer)3, 1003, this.macrsaspiazzowl1));
            this.bftvrendmunasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vrendmunasw01, (Integer)3, 1003, this.mac0c8525e8f3c0));
            this.bftvrendmunasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vrendmunasw01, (Integer)3, 1003, this.macd4ca6d7953fe));
            this.bftvrendmunasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vrendmunasw01, (Integer)3, 1003, this.macd4ca6dff4217));
            this.bftvrendmunasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vrendmunasw01, (Integer)3, 1003, this.mac0003ea0176ca));
            this.bftvrendmunasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vrendmunasw01, (Integer)3, 1003, this.mac4c0082245938));
            this.bftvrendmunasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vrendmunasw01, (Integer)3, 1003, this.macd4ca6d4f1ab2));
            this.bftvrendmunasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vrendmunasw01, (Integer)3, 1003, this.mace48d8c3b04b7));
            this.bftvrendmunasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vrendmunasw01, (Integer)3, 1003, this.mac00e0b1bba390));
            this.bftvrendmunasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vrendmunasw01, (Integer)3, 1003, this.mac00e0b1bb39b6));
            this.bftvrendmunasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vrendmunasw01, (Integer)11, 1011, this.macdaremunasw01));
            this.bftvrendmunasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vrendmunasw01, (Integer)11, 1011, this.macdaremunalv01));
            this.bftvrendmunasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vrendmunasw01, (Integer)11, 1011, this.macvigrenmualv02));
            this.bftvrendmunasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vrendmunasw01, (Integer)11, 1011, this.macvrendmunalv02));
            this.bftvrendmunasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vrendmunasw01, (Integer)11, 1011, this.macvigrenmuasw01));
            this.bftvrendmunasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vrendmunasw01, (Integer)11, 1011, this.macvigrenmualv01));
            this.bftvrendmunasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vrendmunasw01, (Integer)11, 1011, this.macc067af3ce581));
            this.bftvrendmunasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vrendmunasw01, (Integer)11, 1011, this.macc067af3ce614));
            this.bftvrendmunasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vrendmunasw01, (Integer)11, 1011, this.mac4c5e0c8007a1));
            this.bftvrendmunasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vrendmunasw01, (Integer)11, 1011, this.mac00e0b1bb3ed4));
            this.bftvrendmunasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vrendmunasw01, (Integer)11, 1011, this.mac001763010eb7));
            this.bftvrendmunasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vrendmunasw01, (Integer)19, 1019, this.macc067af3ce623));
            this.bftvrendmunasw01.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.vrendmunasw01, (Integer)24, 1024, this.mac001906d5cf50));
            this.bftcomunevillarendenawl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.comunevillarendenawl1, (Integer)3, 3, this.mac0022557fd68f));
            this.bftcomunevillarendenawl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.comunevillarendenawl1, (Integer)3, 3, this.mac00e0b1bba8f4));
            this.bftcomunevillarendenawl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.comunevillarendenawl1, (Integer)3, 3, this.mac0012cf68d780));
            this.bftcomunevillarendenawl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.comunevillarendenawl1, (Integer)3, 3, this.mac00804864187d));
            this.bftcomunevillarendenawl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.comunevillarendenawl1, (Integer)5, 5, this.mac00e0b1bba390));
            this.bftcomunevillarendenawl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.comunevillarendenawl1, (Integer)3, 3, this.mac00804867f4e7));
            this.bftcomunevillarendenawl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.comunevillarendenawl1, (Integer)5, 5, this.mac4c0082245938));
            this.bftcomunevillarendenawl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.comunevillarendenawl1, (Integer)5, 5, this.maccomunevillarendenawl1));
            this.bftcomunevillarendenawl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.comunevillarendenawl1, (Integer)3, 3, this.mac4c5e0c8007a1));
            this.bftcomunevillarendenawl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.comunevillarendenawl1, (Integer)5, 5, this.macd4ca6d4f1ab2));
            this.bftcomunevillarendenawl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.comunevillarendenawl1, (Integer)5, 5, this.mace48d8c3b04b7));
            this.bftcomunevillarendenawl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.comunevillarendenawl1, (Integer)5, 5, this.macd4ca6d7953fe));
            this.bftcomunevillarendenawl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.comunevillarendenawl1, (Integer)5, 5, this.macrsaspiazzowl1));
            this.bftcomunevillarendenawl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.comunevillarendenawl1, (Integer)3, 3, this.macc067af3ce581));
            this.bftcomunevillarendenawl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.comunevillarendenawl1, (Integer)3, 3, this.mac0003ea0175d6));
            this.bftcomunevillarendenawl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.comunevillarendenawl1, (Integer)3, 3, this.mac4c5e0c8076b0));
            this.bftcomunevillarendenawl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.comunevillarendenawl1, (Integer)3, 3, this.macc067af3ce614));
            this.bftcomunevillarendenawl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.comunevillarendenawl1, (Integer)3, 3, this.mace48d8cf17bcb));
            this.bftcomunevillarendenawl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.comunevillarendenawl1, (Integer)3, 3, this.mac00176301057d));
            this.bftcomunevillarendenawl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.comunevillarendenawl1, (Integer)3, 3, this.macvigrenmualv01));
            this.bftcomunevillarendenawl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.comunevillarendenawl1, (Integer)3, 3, this.mac00176301092d));
            this.bftcomunevillarendenawl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.comunevillarendenawl1, (Integer)5, 5, this.mac00e0b1bb39b6));
            this.bftcomunevillarendenawl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.comunevillarendenawl1, (Integer)5, 5, this.macspiasvigasw01));
            this.bftcomunevillarendenawl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.comunevillarendenawl1, (Integer)3, 3, this.macvigrenmualv02));
            this.bftcomunevillarendenawl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.comunevillarendenawl1, (Integer)5, 5, this.macspiazzofasw01));
            this.bftcomunevillarendenawl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.comunevillarendenawl1, (Integer)5, 5, this.macomunespiazzowl1));
            this.bftcomunevillarendenawl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.comunevillarendenawl1, (Integer)3, 3, this.macc067af3ce59d));
            this.bftcomunevillarendenawl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.comunevillarendenawl1, (Integer)2, 2, this.mac00156d56ae1b));
            this.bftcomunevillarendenawl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.comunevillarendenawl1, (Integer)2, 2, this.mac008048676c89));
            this.bftcomunevillarendenawl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.comunevillarendenawl1, (Integer)3, 3, this.mac001906d5cf50));
            this.bftcomunevillarendenawl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.comunevillarendenawl1, (Integer)5, 5, this.mac0c8525e8f3c0));
            this.bftcomunevillarendenawl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.comunevillarendenawl1, (Integer)3, 3, this.macvrendmunalv02));
            this.bftcomunevillarendenawl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.comunevillarendenawl1, (Integer)3, 3, this.macvillpizzasw01));
            this.bftcomunevillarendenawl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.comunevillarendenawl1, (Integer)3, 3, this.mac00804867f17e));
            this.bftcomunevillarendenawl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.comunevillarendenawl1, (Integer)3, 3, this.mac001763010f41));
            this.bftcomunevillarendenawl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.comunevillarendenawl1, (Integer)5, 5, this.macd4ca6dff4217));
            this.bftcomunevillarendenawl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.comunevillarendenawl1, (Integer)3, 3, this.mac000c42736e85));
            this.bftcomunevillarendenawl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.comunevillarendenawl1, (Integer)3, 3, this.macvigrenmuasw01));
            this.bftcomunevillarendenawl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.comunevillarendenawl1, (Integer)3, 3, this.macdaremunalv01));
            this.bftcomunevillarendenawl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.comunevillarendenawl1, (Integer)3, 3, this.macc067af3ce623));
            this.bftcomunevillarendenawl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.comunevillarendenawl1, (Integer)3, 3, this.mac001763010eb7));
            this.bftcomunevillarendenawl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.comunevillarendenawl1, (Integer)3, 3, this.macvrendmunasw01));
            this.bftcomunevillarendenawl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.comunevillarendenawl1, (Integer)3, 3, this.macdaremunasw01));
            this.bftcomunevillarendenawl1.add(EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.comunevillarendenawl1, (Integer)5, 5, this.mac0003ea0176ca));
        }
    }
}

