/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.utils;

import java.util.Properties;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.test.MockLogAppender;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.netmgt.dao.DatabasePopulator;
import org.opennms.netmgt.dao.api.NodeLabel;
import org.opennms.netmgt.utils.NodeLabelJDBCImpl;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/applicationContext-pinger.xml", "classpath:/META-INF/opennms/applicationContext-daemon.xml", "classpath:/META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml", "classpath:/META-INF/opennms/applicationContext-databasePopulator.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
public class NodeLabelIT
implements InitializingBean {
    private final NodeLabel nodeLabelJdbcImpl = new NodeLabelJDBCImpl();
    @Autowired
    private NodeLabel nodeLabelDaoImpl;
    @Autowired
    private DatabasePopulator m_populator;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    @Before
    public void createDb() {
        Properties props = new Properties();
        props.setProperty("log4j.logger.org.hibernate", "INFO");
        props.setProperty("log4j.logger.org.springframework", "INFO");
        props.setProperty("log4j.logger.org.hibernate.SQL", "DEBUG");
        MockLogAppender.setupLogging((Properties)props);
        this.m_populator.populateDatabase();
    }

    @Test
    public final void test() throws Exception {
        NodeLabel jdbcLabelComputed = this.nodeLabelJdbcImpl.computeLabel(1);
        String jdbcLabel = this.nodeLabelJdbcImpl.retrieveLabel(1).toString();
        this.nodeLabelJdbcImpl.assignLabel(1, jdbcLabelComputed);
        NodeLabel daoLabelComputed = this.nodeLabelDaoImpl.computeLabel(1);
        String daoLabel = this.nodeLabelDaoImpl.retrieveLabel(1).toString();
        this.nodeLabelDaoImpl.assignLabel(1, jdbcLabelComputed);
        Assert.assertEquals((Object)jdbcLabelComputed.toString(), (Object)daoLabelComputed.toString());
    }
}

