/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.statsd;

import com.google.common.collect.Iterables;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.test.MockLogAppender;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.netmgt.dao.api.MonitoringLocationDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.ResourceDao;
import org.opennms.netmgt.dao.api.RrdDao;
import org.opennms.netmgt.dao.support.RrdStatisticAttributeVisitor;
import org.opennms.netmgt.dao.support.TopNAttributeStatisticVisitor;
import org.opennms.netmgt.measurements.api.MeasurementFetchStrategy;
import org.opennms.netmgt.model.AttributeStatistic;
import org.opennms.netmgt.model.AttributeStatisticVisitor;
import org.opennms.netmgt.model.OnmsAttribute;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath*:/META-INF/opennms/component-service.xml", "classpath:/META-INF/opennms/applicationContext-pinger.xml", "classpath:/META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml"})
@JUnitConfigurationEnvironment(systemProperties={"org.opennms.rrd.strategyClass=org.opennms.netmgt.rrd.jrobin.JRobinRrdStrategy", "org.opennms.timeseries.strategy=rrd", "rrd.base.dir=src/test/resources/share/jrb", "rrd.binary=rrdtool"})
@JUnitTemporaryDatabase
public class StatsdValuesIT
implements InitializingBean {
    @Autowired
    protected MonitoringLocationDao m_locationDao;
    @Autowired
    protected NodeDao m_nodeDao;
    @Autowired
    protected ResourceDao m_resourceDao;
    @Autowired
    protected RrdDao m_rrdDao;
    @Autowired
    protected MeasurementFetchStrategy m_fetchStrategy;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    @Before
    public void setUp() {
        MockLogAppender.setupLogging();
    }

    @Test
    @Transactional
    public void testValue() throws Exception {
        OnmsNode node = new OnmsNode(this.m_locationDao.getDefaultLocation(), "node1");
        node.setId(Integer.valueOf(1));
        this.m_nodeDao.save((Object)node);
        this.m_nodeDao.flush();
        OnmsResource resource = (OnmsResource)Iterables.getOnlyElement((Iterable)this.m_resourceDao.getResourceForNode(node).getChildResources());
        OnmsAttribute attribute = (OnmsAttribute)resource.getRrdGraphAttributes().get("ifInOctets");
        double statistic = this.m_rrdDao.getPrintValue(attribute, "AVERAGE", 1414602000000L, 1417046400000L);
        TopNAttributeStatisticVisitor result = new TopNAttributeStatisticVisitor();
        result.setCount(Integer.valueOf(1));
        RrdStatisticAttributeVisitor visitor = new RrdStatisticAttributeVisitor();
        visitor.setFetchStrategy(this.m_fetchStrategy);
        visitor.setConsolidationFunction("AVERAGE");
        visitor.setStartTime(Long.valueOf(1414602000000L));
        visitor.setEndTime(Long.valueOf(1417046400000L));
        visitor.setStatisticVisitor((AttributeStatisticVisitor)result);
        visitor.afterPropertiesSet();
        visitor.visit(attribute);
        Assert.assertNotNull((Object)result.getResults());
        Assert.assertEquals((long)1L, (long)result.getResults().size());
        Assert.assertNotNull(result.getResults().first());
        Assert.assertEquals((Object)attribute, (Object)((AttributeStatistic)result.getResults().first()).getAttribute());
        Assert.assertEquals((double)statistic, (double)((AttributeStatistic)result.getResults().first()).getStatistic(), (double)0.5);
    }
}

