/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.notifd;

import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.NotificationManager;
import org.opennms.netmgt.config.notifications.Notification;
import org.opennms.netmgt.mock.MockEventUtil;
import org.opennms.netmgt.mock.MockService;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.notifd.NotificationsITCase;
import org.opennms.netmgt.xml.event.Event;

public class BroadcastEventProcessorIT
extends NotificationsITCase {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.m_anticipator.setExpectedDifference(3000L);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown(true);
    }

    @Test
    public void testExpandNotifParms() throws Exception {
        String expandResult = NotificationManager.expandNotifParms((String)"%foo%", new TreeMap());
        Assert.assertEquals((Object)"%foo%", (Object)expandResult);
        expandResult = NotificationManager.expandNotifParms((String)"%foo%", Collections.singletonMap("foo", "bar"));
        Assert.assertEquals((Object)"%foo%", (Object)expandResult);
        expandResult = NotificationManager.expandNotifParms((String)"Notice #%noticeid% RESOLVED: ", Collections.singletonMap("noticeid", "999"));
        Assert.assertEquals((Object)"Notice #999 RESOLVED: ", (Object)expandResult);
        expandResult = NotificationManager.expandNotifParms((String)"RESOLVED: ", Collections.singletonMap("noticeid", "999"));
        Assert.assertEquals((Object)"RESOLVED: ", (Object)expandResult);
        expandResult = NotificationManager.expandNotifParms((String)"Notice %noticeid%: Disk threshold exceeded on %nodelabel%: %parm[all]%.", new TreeMap());
        Assert.assertEquals((Object)"Notice %noticeid%: Disk threshold exceeded on %nodelabel%: %parm[all]%.", (Object)expandResult);
        EventBuilder bldr = new EventBuilder("uei.opennms.org/threshold/highThresholdExceeded", "testExpandNotifParms");
        bldr.setDescription("High threshold exceeded for %service% datasource %parm[ds]% on interface %interface%, parms: %parm[all]%");
        bldr.setLogMessage("High threshold exceeded for %service% datasource %parm[ds]% on interface %interface%, parms: %parm[all]%");
        bldr.setNodeid(0L);
        bldr.setInterface(InetAddressUtils.addr((String)"0.0.0.0"));
        bldr.addParam("ds", "dsk-usr-pcent");
        bldr.addParam("value", "Crap! RUN AWAY! We need 20% on the SAN and there's only 15");
        bldr.addParam("threshold", "");
        bldr.addParam("trigger", "");
        bldr.addParam("rearm", "");
        bldr.addParam("label", "");
        bldr.addParam("ifIndex", "");
        Notification[] notifications = null;
        notifications = this.m_notificationManager.getNotifForEvent(null);
        Assert.assertNull((Object)notifications);
        notifications = this.m_notificationManager.getNotifForEvent(bldr.getEvent());
        Assert.assertNotNull((Object)notifications);
        Assert.assertEquals((long)1L, (long)notifications.length);
        Map paramMap = this.m_eventProcessor.buildParameterMap(notifications[0], bldr.getEvent(), 9999);
        Assert.assertEquals((Object)"High disk Threshold exceeded on 0.0.0.0, dsk-usr-pcent with Crap! RUN AWAY! We need 20% on the SAN and there's only 15%", paramMap.get("-tm"));
        expandResult = NotificationManager.expandNotifParms((String)"Notice #%noticeid%: Disk threshold exceeded on %nodelabel%: %parm[all]%.", (Map)paramMap);
        Assert.assertEquals((Object)"Notice #9999: Disk threshold exceeded on %nodelabel%: %parm[all]%.", (Object)expandResult);
    }

    @Test
    public void testExpandNoticeId_Bug1745() throws Exception {
        MockService svc = this.m_network.getService(1, "192.168.1.1", "ICMP");
        Event event = MockEventUtil.createServiceEvent((String)"Test", (String)"uei.opennms.org/test/noticeIdExpansion", (MockService)svc, null);
        String antNID = Integer.toString(this.m_notificationManager.getNoticeId() + 1);
        Date testDate = new Date();
        long finishedNotifs = this.anticipateNotificationsForGroup("notification '" + antNID + "'", "Notification '" + antNID + "'", "InitialGroup", testDate, 0L);
        MockEventUtil.setEventTime((Event)event, (Date)testDate);
        this.m_eventMgr.sendEventToListeners(event);
        this.verifyAnticipated(finishedNotifs, 1000L);
    }

    @Test
    public void testVarbindsdecodeNMS7598() throws Exception {
        EventBuilder bldr = new EventBuilder("uei.opennms.org/vendor/Cisco/traps/cHsrpStateChange", "testVarbindsdecodeNMS7598");
        bldr.setNodeid(0L);
        bldr.setInterface(InetAddressUtils.addr((String)"0.0.0.0"));
        bldr.addParam("cHsrpGrpStandbyState", "3");
        String templateText = "Notice #%noticeid%: new state is %parm[#1]%";
        String expectedText = "Notice #1001: new state is listen(3)";
        Notification n = new Notification();
        n.setName("cHsrpGrpStandbyState");
        n.setSubject(templateText);
        n.setNumericMessage(templateText);
        n.setTextMessage(templateText);
        Map params = this.m_eventProcessor.buildParameterMap(n, bldr.getEvent(), 1001);
        Assert.assertEquals((Object)expectedText, params.get("-nm"));
        Assert.assertEquals((Object)expectedText, params.get("-tm"));
        Assert.assertEquals((Object)expectedText, params.get("-subject"));
    }
}

