/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.mock;

import java.util.SortedMap;
import java.util.TreeMap;
import org.opennms.netmgt.mock.SubAgent;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;

public class MapSubAgent
implements SubAgent {
    private SortedMap<OID, Variable> m_values = new TreeMap<OID, Variable>();
    private OID m_base;

    public MapSubAgent(String baseOID) {
        this.m_base = new OID(baseOID);
    }

    @Override
    public OID getBaseOID() {
        return new OID(this.m_base);
    }

    public void put(String oid, Variable value) {
        OID oidKey = new OID(this.m_base);
        oidKey.append(oid);
        this.m_values.put(oidKey, value);
    }

    private OID nextOID(OID requested) {
        OID next = new OID(requested);
        next.append(0);
        return next;
    }

    @Override
    public VariableBinding getNext(OID requested) {
        OID successor = this.nextOID(requested);
        SortedMap<OID, Variable> tailMap = this.m_values.tailMap(successor);
        if (tailMap.isEmpty()) {
            return null;
        }
        OID next = tailMap.firstKey();
        Variable value = (Variable)tailMap.get(next);
        return new VariableBinding(next, value);
    }

    @Override
    public VariableBinding get(OID requested) {
        if (!this.m_values.containsKey(requested)) {
            return null;
        }
        OID response = new OID(requested);
        Variable value = (Variable)this.m_values.get(response);
        return new VariableBinding(response, value);
    }
}

