/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.mock;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.opennms.core.db.DataSourceFactory;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.eventd.AbstractEventUtil;
import org.opennms.netmgt.mock.DbIpInterfaceEntry;
import org.opennms.netmgt.mock.DbSnmpInterfaceEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;

public final class EventUtilJdbcImpl
extends AbstractEventUtil {
    private static final Logger LOG = LoggerFactory.getLogger(EventUtilJdbcImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNodeLabel(long nodeId) throws SQLException {
        String nodeLabel = null;
        Connection dbConn = null;
        try {
            Statement stmt = null;
            try {
                dbConn = DataSourceFactory.getInstance().getConnection();
                stmt = dbConn.createStatement();
                ResultSet rs = stmt.executeQuery("SELECT nodelabel FROM node WHERE nodeid=" + String.valueOf(nodeId));
                if (rs.next()) {
                    nodeLabel = rs.getString("nodelabel");
                }
            }
            finally {
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        finally {
            if (dbConn != null) {
                try {
                    dbConn.close();
                }
                catch (Throwable throwable) {}
            }
        }
        return nodeLabel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNodeLocation(long nodeId) throws SQLException {
        String nodeLocation = null;
        Connection dbConn = null;
        try {
            Statement stmt = null;
            try {
                dbConn = DataSourceFactory.getInstance().getConnection();
                stmt = dbConn.createStatement();
                ResultSet rs = stmt.executeQuery("SELECT location FROM node WHERE nodeid=" + String.valueOf(nodeId));
                if (rs.next()) {
                    nodeLocation = rs.getString("location");
                }
            }
            finally {
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        finally {
            if (dbConn != null) {
                try {
                    dbConn.close();
                }
                catch (Throwable throwable) {}
            }
        }
        return nodeLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getIfAlias(long nodeId, String ipaddr) throws SQLException {
        String ifAlias = null;
        Connection dbConn = null;
        try {
            Statement stmt = null;
            try {
                DbSnmpInterfaceEntry snmpif;
                dbConn = DataSourceFactory.getInstance().getConnection();
                DbIpInterfaceEntry ipif = DbIpInterfaceEntry.get(dbConn, nodeId, InetAddressUtils.getInetAddress((String)ipaddr));
                if (ipif != null && (snmpif = DbSnmpInterfaceEntry.get(dbConn, nodeId, ipif.getIfIndex())) != null) {
                    ifAlias = snmpif.getAlias();
                }
            }
            finally {
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        finally {
            if (dbConn != null) {
                try {
                    dbConn.close();
                }
                catch (Throwable throwable) {}
            }
        }
        return ifAlias;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getAssetFieldValue(String parm, long nodeId) {
        String retParmVal = null;
        int end = parm.lastIndexOf("]");
        String assetField = parm.substring(6, end);
        Connection dbConn = null;
        try {
            Statement stmt = null;
            dbConn = DataSourceFactory.getInstance().getConnection();
            stmt = dbConn.createStatement();
            ResultSet rs = stmt.executeQuery("SELECT " + assetField + " FROM assets WHERE nodeid=" + String.valueOf(nodeId));
            if (rs.next()) {
                retParmVal = rs.getString(assetField);
            }
            if (stmt == null) return retParmVal;
            try {
                stmt.close();
                return retParmVal;
            }
            catch (Throwable throwable) {}
            return retParmVal;
            catch (SQLException sQLException) {
                if (stmt == null) return retParmVal;
                try {
                    stmt.close();
                    return retParmVal;
                }
                catch (Throwable throwable) {}
                return retParmVal;
                catch (Throwable throwable) {
                    if (stmt == null) throw throwable;
                    try {
                        stmt.close();
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        finally {
            if (dbConn != null) {
                try {
                    dbConn.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getHardwareFieldValue(String parm, long nodeId) {
        String retParmVal = null;
        int end = parm.lastIndexOf("]");
        String[] parts = parm.substring("hardware[".length(), end).split(":");
        if (parts.length != 2) {
            return null;
        }
        String sql = null;
        boolean isCustomAttr = !parts[1].startsWith("entPhysical");
        sql = isCustomAttr ? "SELECT a.attribValue FROM hwEntityAttribute a, hwEntity h, hwEntityAttributeType t WHERE h.nodeId = " + String.valueOf(nodeId) + " AND a.hwEntityId = h.id AND a.hwAttribTypeId = t.id AND t.attribName = '" + parts[1] + "'" : "SELECT " + parts[1] + " FROM hwEntity WHERE nodeId = " + String.valueOf(nodeId);
        sql = parts[0].matches("^\\d+$") ? (isCustomAttr ? sql + " AND h.entPhysicalIndex = " + parts[0] : sql + " AND entPhysicalIndex = " + parts[0]) : (parts[0].startsWith("~") ? (isCustomAttr ? sql + " AND h.entPhysicalName ~ '" + parts[0].substring(1) + "'" : sql + " AND entPhysicalName ~ '" + parts[0].substring(1) + "'") : (isCustomAttr ? sql + " AND h.entPhysicalName = '" + parts[0] + "'" : sql + " AND entPhysicalName = '" + parts[0] + "'"));
        Connection dbConn = null;
        try {
            Statement stmt = null;
            dbConn = DataSourceFactory.getInstance().getConnection();
            stmt = dbConn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            if (rs.next()) {
                retParmVal = rs.getString(1);
            }
            if (stmt == null) return retParmVal;
            try {
                stmt.close();
                return retParmVal;
            }
            catch (Throwable throwable) {}
            return retParmVal;
            catch (SQLException sQLException) {
                if (stmt == null) return retParmVal;
                try {
                    stmt.close();
                    return retParmVal;
                }
                catch (Throwable throwable) {}
                return retParmVal;
                catch (Throwable throwable) {
                    if (stmt == null) throw throwable;
                    try {
                        stmt.close();
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        finally {
            if (dbConn != null) {
                try {
                    dbConn.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public String getHostName(int nodeId, String hostip) throws SQLException {
        try {
            String hostname = (String)new JdbcTemplate(DataSourceFactory.getInstance()).queryForObject("SELECT ipHostname FROM ipinterface WHERE nodeId = ? AND ipAddr = ?", String.class, new Object[]{nodeId, hostip});
            return hostname != null ? hostname : hostip;
        }
        catch (EmptyResultDataAccessException e) {
            return hostip;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getForeignSource(long nodeId) throws SQLException {
        String foreignSource = null;
        Connection dbConn = null;
        try {
            Statement stmt = null;
            try {
                dbConn = DataSourceFactory.getInstance().getConnection();
                stmt = dbConn.createStatement();
                ResultSet rs = stmt.executeQuery("SELECT foreignsource FROM node WHERE nodeid=" + String.valueOf(nodeId));
                if (rs.next()) {
                    foreignSource = rs.getString("foreignsource");
                }
            }
            finally {
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        finally {
            if (dbConn != null) {
                try {
                    dbConn.close();
                }
                catch (Throwable throwable) {}
            }
        }
        return foreignSource;
    }

    public String getForeignId(long nodeId) throws SQLException {
        try (Connection dbConn = DataSourceFactory.getInstance().getConnection();
             PreparedStatement stmt = dbConn.prepareStatement("SELECT foreignId FROM node WHERE nodeid=?");){
            stmt.setString(1, String.valueOf(nodeId));
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                String string = rs.getString("foreignId");
                return string;
            }
        }
        return null;
    }
}

