/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.opennms.core.rpc.api.RpcClient;
import org.opennms.core.rpc.api.RpcClientFactory;
import org.opennms.core.rpc.api.RpcExceptionHandler;
import org.opennms.core.rpc.api.RpcExceptionUtils;
import org.opennms.core.rpc.api.RpcModule;
import org.opennms.core.rpc.api.RpcRequest;
import org.opennms.core.rpc.echo.EchoRequest;
import org.opennms.core.rpc.echo.EchoResponse;
import org.opennms.core.rpc.echo.EchoRpcModule;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.DistributionContext;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.support.AbstractServiceMonitor;

@Distributable(value={DistributionContext.DAEMON})
public class MinionRpcMonitor
extends AbstractServiceMonitor
implements RpcExceptionHandler<PollStatus> {
    private final Supplier<NodeDao> nodeDao = Suppliers.memoize(() -> (NodeDao)BeanUtils.getBean((String)"daoContext", (String)"nodeDao", NodeDao.class));
    private final Supplier<RpcClientFactory> rpcClientFactory = Suppliers.memoize(() -> (RpcClientFactory)BeanUtils.getBean((String)"daoContext", (String)"camelRpcClientFactory", RpcClientFactory.class));
    private static final int DEFAULT_TTL_IN_MS = -1;
    private static final int DEFAULT_MESSAGE_SIZE = 1024;

    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        int messageSize;
        Long ttlInMs = ParameterMap.getKeyedLong(parameters, (String)"ttl", (long)-1L);
        if (ttlInMs < 1L) {
            ttlInMs = null;
        }
        if ((messageSize = ParameterMap.getKeyedInteger(parameters, (String)"message-size", (int)1024)) < 0) {
            messageSize = 0;
        }
        RpcClient client = ((RpcClientFactory)this.rpcClientFactory.get()).getClient((RpcModule)EchoRpcModule.INSTANCE);
        OnmsNode node = (OnmsNode)((NodeDao)this.nodeDao.get()).get((Serializable)Integer.valueOf(svc.getNodeId()));
        EchoRequest request = new EchoRequest();
        request.setId(Long.valueOf(System.currentTimeMillis()));
        request.setMessage(Strings.repeat((String)"*", (int)messageSize));
        request.setLocation(node.getLocation().getLocationName());
        request.setSystemId(node.getForeignId());
        request.setTimeToLiveMs(ttlInMs);
        try {
            EchoResponse response = (EchoResponse)client.execute((RpcRequest)request).get();
            Long responseTime = System.currentTimeMillis() - response.getId();
            return PollStatus.available(responseTime.doubleValue());
        }
        catch (InterruptedException | ExecutionException t) {
            return (PollStatus)RpcExceptionUtils.handleException((Throwable)t, (RpcExceptionHandler)this);
        }
    }

    public String getEffectiveLocation(String location) {
        return "Default";
    }

    public PollStatus onInterrupted(Throwable t) {
        return PollStatus.unknown("Interrupted.");
    }

    public PollStatus onTimedOut(Throwable t) {
        return PollStatus.unresponsive("Request timed out.");
    }

    public PollStatus onRejected(Throwable t) {
        return PollStatus.unknown("Rejected.");
    }

    public PollStatus onUnknown(Throwable t) {
        return PollStatus.unresponsive("Failed with unknown exception: " + t.getMessage());
    }
}

