/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opennms.netmgt.enlinkd.EnhancedLinkd;
import org.opennms.netmgt.enlinkd.Node;
import org.opennms.netmgt.enlinkd.NodeDiscovery;
import org.opennms.netmgt.model.BridgeMacLink;
import org.opennms.netmgt.model.topology.Bridge;
import org.opennms.netmgt.model.topology.BridgePort;
import org.opennms.netmgt.model.topology.BroadcastDomain;
import org.opennms.netmgt.model.topology.SharedSegment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeDiscoveryBridgeTopology
extends NodeDiscovery {
    private static final Logger LOG = LoggerFactory.getLogger(NodeDiscoveryBridgeTopology.class);
    private static final int DOMAIN_MATCH_MIN_SIZE = 5;
    private static final float DOMAIN_MATCH_MIN_RATIO = 0.1f;
    Map<Bridge, List<BridgeMacLink>> m_notYetParsedBFTMap;
    BroadcastDomain m_domain;

    public BroadcastDomain getDomain() {
        return this.m_domain;
    }

    public void setDomain(BroadcastDomain domain) {
        this.m_domain = domain;
    }

    public Map<Bridge, List<BridgeMacLink>> getNotYetParsedBFTMap() {
        return this.m_notYetParsedBFTMap;
    }

    public void addUpdatedBFT(Bridge bridge, List<BridgeMacLink> notYetParsedBFTMap) {
        if (this.m_notYetParsedBFTMap == null) {
            this.m_notYetParsedBFTMap = new HashMap<Bridge, List<BridgeMacLink>>();
        }
        this.m_notYetParsedBFTMap.put(bridge, notYetParsedBFTMap);
    }

    public NodeDiscoveryBridgeTopology(EnhancedLinkd linkd, Node node) {
        super(linkd, node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Integer> getAllNodesWithUpdatedBFTOnDomain(Set<String> incomingSet, Map<Integer, List<BridgeMacLink>> nodeBftMap) {
        HashSet<Integer> nodeswithupdatedbftonbroadcastdomain = new HashSet<Integer>();
        nodeswithupdatedbftonbroadcastdomain.add(this.getNodeId());
        LOG.info("run: node: [{}], getting nodes with updated bft on broadcast domain. Start", (Object)this.getNodeId());
        Map<Integer, List<BridgeMacLink>> map = nodeBftMap;
        synchronized (map) {
            for (Integer curNodeId : nodeBftMap.keySet()) {
                if (curNodeId.intValue() == this.getNodeId()) continue;
                HashSet<String> retainedSet = new HashSet<String>();
                for (BridgeMacLink link : nodeBftMap.get(curNodeId)) {
                    retainedSet.add(link.getMacAddress());
                }
                LOG.debug("run: node: [{}], parsing updated bft node: [{}], macs {}", new Object[]{this.getNodeId(), curNodeId, retainedSet});
                retainedSet.retainAll(incomingSet);
                LOG.debug("run: node: [{}], node: [{}] - common mac address set: {}", new Object[]{this.getNodeId(), curNodeId, retainedSet});
                if (retainedSet.size() <= 5 && !((float)retainedSet.size() >= (float)incomingSet.size() * 0.1f)) continue;
                nodeswithupdatedbftonbroadcastdomain.add(curNodeId);
                LOG.debug("run: node: [{}], node: [{}] - put on same broadcast domain, common macs: {} ", new Object[]{this.getNodeId(), curNodeId, retainedSet});
            }
        }
        LOG.info("run: node: [{}], getting nodes with updated bft on broadcast domain. End", (Object)this.getNodeId());
        return nodeswithupdatedbftonbroadcastdomain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (!this.m_linkd.getQueryManager().hasUpdatedBft(this.getNodeId())) {
            LOG.info("run: node: [{}], no bft.Exiting Bridge Topology Discovery", (Object)this.getNodeId());
            return;
        }
        List<BridgeMacLink> links = this.m_linkd.getQueryManager().getBridgeTopologyUpdateBFT(this.getNodeId());
        if (links == null || links.size() == 0) {
            LOG.info("run: node: [{}]. no updates macs found.", (Object)this.getNodeId());
            return;
        }
        Date now = new Date();
        HashSet<String> incomingSet = new HashSet<String>();
        List<BridgeMacLink> list = links;
        synchronized (list) {
            for (BridgeMacLink link : links) {
                incomingSet.add(link.getMacAddress());
            }
        }
        LOG.debug("run: node: [{}]. macs found: {}", (Object)this.getNodeId(), incomingSet);
        LOG.info("run: node: [{}], getting broadcast domain. Start", (Object)this.getNodeId());
        for (BroadcastDomain domain : this.m_linkd.getQueryManager().getAllBroadcastDomains()) {
            LOG.debug("run: node: [{}], parsing domain with nodes: {}, macs: {}", new Object[]{this.getNodeId(), domain.getBridgeNodesOnDomain(), domain.getMacsOnDomain()});
            HashSet retainedSet = new HashSet(domain.getMacsOnDomain());
            retainedSet.retainAll(incomingSet);
            LOG.debug("run: node: [{}], retained: {}", (Object)this.getNodeId(), retainedSet);
            if (retainedSet.size() <= 5 && !((float)retainedSet.size() >= (float)incomingSet.size() * 0.1f)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("run: node: [{}], domain {} found!", (Object)this.getNodeId(), (Object)domain.getBridgeNodesOnDomain());
            }
            this.m_domain = domain;
        }
        if (this.m_domain == null) {
            LOG.debug("run: node: [{}] Creating a new Domain", (Object)this.getNodeId());
            this.m_domain = new BroadcastDomain();
            this.m_linkd.getQueryManager().save(this.m_domain);
        } else if (!this.m_domain.hasRootBridge()) {
            LOG.debug("run: node: [{}] Domain without root, clearing topology", (Object)this.getNodeId());
            this.m_domain.clearTopology();
        }
        LOG.info("run: node: [{}], getting broadcast domain. End", (Object)this.getNodeId());
        Map<Integer, List<BridgeMacLink>> nodeBftMap = this.m_linkd.getQueryManager().getUpdateBftMap();
        Set<Integer> nodeswithupdatedbftonbroadcastdomain = this.getAllNodesWithUpdatedBFTOnDomain(incomingSet, nodeBftMap);
        LOG.info("run: node: [{}], clean broadcast domains. Start", (Object)this.getNodeId());
        boolean clean = false;
        for (BroadcastDomain broadcastDomain : this.m_linkd.getQueryManager().getAllBroadcastDomains()) {
            if (this.m_domain == broadcastDomain) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("run: node [{}]: cleaning broadcast domain {}.", (Object)this.getNodeId(), (Object)broadcastDomain.getBridgeNodesOnDomain());
            }
            for (Integer curNodeId : nodeswithupdatedbftonbroadcastdomain) {
                if (!broadcastDomain.containBridgeId(curNodeId.intValue())) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("run: node [{}]: node [{}]: removing from broadcast domain {}!", new Object[]{this.getNodeId(), curNodeId, broadcastDomain.getBridgeNodesOnDomain()});
                }
                BroadcastDomain broadcastDomain2 = broadcastDomain;
                synchronized (broadcastDomain2) {
                    broadcastDomain.clearTopologyForBridge(curNodeId);
                    broadcastDomain.removeBridge(curNodeId.intValue());
                    this.m_linkd.getQueryManager().store(broadcastDomain, now);
                }
                clean = true;
            }
        }
        if (clean) {
            this.m_linkd.getQueryManager().cleanBroadcastDomains();
        }
        LOG.info("run: node: [{}], clean broadcast domains. End", (Object)this.getNodeId());
        BroadcastDomain broadcastDomain = this.m_domain;
        synchronized (broadcastDomain) {
            this.m_notYetParsedBFTMap = new HashMap<Bridge, List<BridgeMacLink>>();
            for (Integer nodeid : nodeswithupdatedbftonbroadcastdomain) {
                this.sendStartEvent(nodeid);
                this.m_domain.addBridge(new Bridge(nodeid));
                LOG.debug("run: node: [{}], getting update bft for node [{}] on domain", (Object)this.getNodeId(), (Object)nodeid);
                List<BridgeMacLink> bft = this.m_linkd.getQueryManager().useBridgeTopologyUpdateBFT(nodeid);
                if (bft == null || bft.isEmpty()) {
                    LOG.debug("run: node: [{}], no update bft for node [{}] on domain", (Object)this.getNodeId(), (Object)nodeid);
                    continue;
                }
                this.m_notYetParsedBFTMap.put(this.m_domain.getBridge(nodeid.intValue()), bft);
            }
            HashSet<Integer> hashSet = new HashSet<Integer>();
            Iterator<Object> iterator = nodeBftMap;
            synchronized (iterator) {
                for (Integer nodeid : nodeBftMap.keySet()) {
                    if (nodeswithupdatedbftonbroadcastdomain.contains(nodeid)) continue;
                    LOG.info("run: node [{}]: bridge [{}] with updated bft. Not even more on broadcast domain {}: clear topology.", new Object[]{this.getNodeId(), nodeid, this.m_domain.getBridgeNodesOnDomain()});
                    hashSet.add(nodeid);
                }
            }
            for (Integer nodeid : hashSet) {
                this.m_domain.clearTopologyForBridge(nodeid);
                this.m_domain.removeBridge(nodeid.intValue());
            }
            this.m_linkd.getQueryManager().cleanBroadcastDomains();
            this.m_domain.setBridgeElements(this.m_linkd.getQueryManager().getBridgeElements(this.m_domain.getBridgeNodesOnDomain()));
            if (this.m_notYetParsedBFTMap.isEmpty()) {
                LOG.info("run: node: [{}], broadcast domain has no topology updates. No more action is needed.", (Object)this.getNodeId());
            } else {
                this.calculate();
            }
            LOG.info("run: node: [{}], saving Topology.", (Object)this.getNodeId());
            this.m_linkd.getQueryManager().store(this.m_domain, now);
            LOG.info("run: node: [{}], saved Topology.", (Object)this.getNodeId());
            for (Integer curNode : nodeswithupdatedbftonbroadcastdomain) {
                this.sendCompletedEvent(curNode);
            }
        }
    }

    @Override
    protected void runCollection() {
    }

    @Override
    public String getName() {
        return "DiscoveryBridgeTopology";
    }

    protected void calculate() {
        Bridge electedRoot;
        LOG.info("calculate: node: [{}], start: broadcast domain {} topology calculation.", (Object)this.getNodeId(), (Object)this.m_domain.getBridgeNodesOnDomain());
        if (LOG.isDebugEnabled()) {
            LOG.debug("calculate: node: [{}], Print Topology {}", (Object)this.getNodeId(), (Object)this.m_domain.printTopology());
        }
        if ((electedRoot = this.m_domain.electRootBridge()) == null && this.m_domain.hasRootBridge()) {
            LOG.debug("calculate: node: [{}], electRootBridge: mantaining old root bridge: {}", (Object)this.getNodeId(), (Object)this.m_domain.getRootBridgeId());
            electedRoot = this.m_domain.getRootBridge();
        } else if (electedRoot == null) {
            int size = 0;
            Bridge rootBridge = null;
            for (Bridge bridge : this.m_notYetParsedBFTMap.keySet()) {
                LOG.debug("calculate: node: [{}], bridge [{}]: max bft size \"{}\" in topology", new Object[]{this.getNodeId(), bridge.getId(), this.m_notYetParsedBFTMap.get(bridge).size()});
                if (size >= this.m_notYetParsedBFTMap.get(bridge).size()) continue;
                rootBridge = bridge;
                size = this.m_notYetParsedBFTMap.get(bridge).size();
            }
            if (rootBridge != null) {
                LOG.debug("calculate: node: [{}], bridge [{}]: elected root with max bft size \"{}\" in topology", new Object[]{this.getNodeId(), rootBridge.getId(), size});
                electedRoot = rootBridge;
            }
        }
        if (electedRoot == null) {
            electedRoot = (Bridge)this.m_domain.getBridges().iterator().next();
            LOG.debug("calculate: node: [{}], electRootBridge: first root bridge: {}", (Object)this.getNodeId(), (Object)electedRoot.getId());
        }
        if (electedRoot.getId() == null) {
            LOG.error("calculate: node: [{}], electedRootBridge must have an id!", (Object)this.getNodeId());
            return;
        }
        List rootBft = this.m_notYetParsedBFTMap.remove(electedRoot);
        if (this.m_domain.hasRootBridge() && this.m_domain.getRootBridge().getId() == electedRoot.getId() && rootBft == null) {
            LOG.debug("calculate: node: [{}], elected root bridge: [{}], old root bridge. no updated bft", (Object)this.getNodeId(), (Object)electedRoot.getId());
            rootBft = this.m_domain.calculateRootBFT();
        } else if (rootBft != null) {
            LOG.debug("calculate: node: [{}], elected root bridge: [{}], has updated bft", (Object)this.getNodeId(), (Object)electedRoot.getId());
            this.m_domain.clearTopologyForBridge(electedRoot.getId());
            LOG.debug("calculate: node: [{}], cleared topology: domain root bridge: [{}]", (Object)this.getNodeId(), (Object)this.m_domain.getRootBridgeId());
            if (this.m_domain.getTopology().isEmpty()) {
                LOG.debug("calculate: node: [{}], new elected root bridge: [{}], is the first bridge in topology. Adding root shared segments", (Object)this.getNodeId(), (Object)electedRoot.getId());
                this.loadFirstLevelSharedSegment(rootBft);
                electedRoot.setRootBridge(true);
                electedRoot.setRootPort(null);
            } else {
                this.calculate(this.m_domain.getRootBridge(), this.m_domain.calculateRootBFT(), electedRoot, rootBft);
                this.addForwarding(this.m_domain, rootBft);
                this.m_domain.hierarchySetUp(electedRoot);
            }
        } else {
            LOG.debug("calculate: node: [{}], elected root bridge: [{}], is new, without updated bft", (Object)this.getNodeId(), (Object)electedRoot.getId());
            this.m_domain.hierarchySetUp(electedRoot);
            rootBft = this.m_domain.calculateRootBFT();
        }
        if (!this.m_notYetParsedBFTMap.isEmpty()) {
            for (Bridge xBridge : this.m_notYetParsedBFTMap.keySet()) {
                this.m_domain.clearTopologyForBridge(xBridge.getId());
                LOG.debug("calculate: node: [{}], Removed bridge: [{}].", (Object)this.getNodeId(), (Object)xBridge.getId());
            }
        }
        HashSet<Bridge> nodetobeparsed = new HashSet<Bridge>(this.m_notYetParsedBFTMap.keySet());
        for (Bridge xBridge : nodetobeparsed) {
            ArrayList<BridgeMacLink> xBft = new ArrayList<BridgeMacLink>((Collection)this.m_notYetParsedBFTMap.remove(xBridge));
            this.calculate(electedRoot, rootBft, xBridge, xBft);
        }
        this.m_domain.cleanForwarders(this.m_domain.getMacsOnDomain());
        if (LOG.isDebugEnabled()) {
            LOG.debug("calculate: node: [{}], Print Topology {}", (Object)this.getNodeId(), (Object)this.m_domain.printTopology());
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("calculate: node: [{}], stop: broadcast domain {} topology calculated.", (Object)this.getNodeId(), (Object)this.m_domain.getBridgeNodesOnDomain());
        }
    }

    private void addForwarding(BroadcastDomain domain, List<BridgeMacLink> bft) {
        for (BridgeMacLink maclink : bft) {
            if (domain.getMacsOnDomain().contains(maclink.getMacAddress())) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("calculate: node: [{}]. Skipping forwarding: {}", (Object)this.getNodeId(), (Object)BroadcastDomain.printTopologyLink((BridgeMacLink)maclink));
                continue;
            }
            domain.addForwarding(maclink);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("calculate: node: [{}]. Adding forwarding: {}", (Object)this.getNodeId(), (Object)BroadcastDomain.printTopologyLink((BridgeMacLink)maclink));
        }
    }

    private void loadFirstLevelSharedSegment(List<BridgeMacLink> electedRootBFT) {
        HashMap<Integer, SharedSegment> rootleafs = new HashMap<Integer, SharedSegment>();
        for (BridgeMacLink link : electedRootBFT) {
            if (link.getBridgeDot1qTpFdbStatus() != BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED) continue;
            if (rootleafs.containsKey(link.getBridgePort())) {
                ((SharedSegment)rootleafs.get(link.getBridgePort())).add(link);
                continue;
            }
            rootleafs.put(link.getBridgePort(), new SharedSegment(this.m_domain, link));
        }
        for (SharedSegment rootleaf : rootleafs.values()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("calculate: node: [{}], add shared segment[designated bridge:[{}],designated port:{}, macs: {}]", new Object[]{this.getNodeId(), rootleaf.getDesignatedBridge(), rootleaf.getDesignatedPort(), rootleaf.getMacsOnSegment()});
            }
            this.m_domain.add(rootleaf);
        }
    }

    private void calculate(Bridge root, List<BridgeMacLink> rootbft, Bridge xBridge, List<BridgeMacLink> xbft) {
        BridgeTopologyHelper rx = new BridgeTopologyHelper(root, rootbft, xBridge, xbft);
        Integer rxDesignatedPort = rx.getFirstBridgeConnectionPort();
        if (rxDesignatedPort == null) {
            LOG.warn("calculate: node: [{}], cannot found simple connection for bridges: [{},{}]", new Object[]{this.getNodeId(), root.getId(), xBridge.getId()});
            this.m_domain.clearTopology();
            return;
        }
        Integer xrDesignatedPort = rx.getSecondBridgeConnectionPort();
        if (xrDesignatedPort == null) {
            LOG.warn("calculate: node: [{}], cannot found simple connectionfor bridges: [{},{}]", new Object[]{this.getNodeId(), xBridge.getId(), root.getId()});
            this.m_domain.clearTopology();
            return;
        }
        LOG.debug("calculate: node: [{}], level: 1, bridge: [{}]. setting root port {} ", new Object[]{this.getNodeId(), xBridge.getId(), xrDesignatedPort});
        xBridge.setRootPort(xrDesignatedPort);
        xBridge.setRootBridge(false);
        SharedSegment topSegment = this.m_domain.getSharedSegment(root.getId(), rxDesignatedPort);
        if (topSegment == null) {
            LOG.warn("calculate: node: [{}], level: 1, nodeid: [{}], port {}. top segment not found.", new Object[]{this.getNodeId(), this.m_domain.getRootBridgeId(), rxDesignatedPort});
            this.m_domain.clearTopology();
            return;
        }
        if (!this.findBridgesTopo(rx, topSegment, xBridge, xbft, 0)) {
            this.m_domain.clearTopology();
        }
    }

    private boolean findBridgesTopo(BridgeTopologyHelper rx, SharedSegment topSegment, Bridge xBridge, List<BridgeMacLink> xBFT, int level) {
        if (topSegment == null) {
            LOG.warn("calculate: node: [{}]: level: {}, bridge: [{}], top segment is null exiting.....", new Object[]{this.getNodeId(), level, xBridge.getId()});
            return false;
        }
        if (++level == 30) {
            LOG.warn("calculate: node: [{}]: level: {}, bridge: [{}], too many iteration on topology exiting.....", new Object[]{this.getNodeId(), level, xBridge.getId()});
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("calculate: node: [{}], level: {}, bridge: [{}], checking if is child of segment: [ids {}, designated bridge {}, port {}, macs {}]", new Object[]{this.getNodeId(), level, xBridge.getId(), topSegment.getBridgeIdsOnSegment(), topSegment.getDesignatedBridge(), topSegment.getDesignatedPort(), topSegment.getMacsOnSegment()});
        }
        HashSet<Integer> portsAdded = new HashSet<Integer>();
        Set<String> macsOnSegment = rx.getSimpleConnectionMacs();
        HashMap<Integer, List> bftSets = new HashMap<Integer, List>();
        ArrayList<BridgeMacLink> forwarders = new ArrayList<BridgeMacLink>();
        forwarders.addAll(rx.getFirstBridgeForwarders());
        forwarders.addAll(rx.getSecondBridgeForwarders());
        for (Bridge yBridge : this.m_domain.getBridgeOnSharedSegment(topSegment)) {
            bftSets.put(yBridge.getId(), this.m_domain.calculateBFT(yBridge));
        }
        for (Bridge yBridge : this.m_domain.getBridgeOnSharedSegment(topSegment)) {
            Integer yBridgeId = yBridge.getId();
            if (yBridgeId.intValue() == topSegment.getDesignatedBridge().intValue()) continue;
            Integer yrDesignatedPort = yBridge.getRootPort();
            LOG.debug("calculate: node: [{}], level: {}, bridge: [{}], bridge: [{}, designated port: {}]", new Object[]{this.getNodeId(), level, xBridge.getId(), yBridgeId, yrDesignatedPort});
            BridgeTopologyHelper yx = new BridgeTopologyHelper(yBridge, (List)bftSets.get(yBridgeId), xBridge, xBFT);
            Integer xyDesignatedPort = yx.getSecondBridgeConnectionPort();
            Integer yxDesignatedPort = yx.getFirstBridgeConnectionPort();
            if (xyDesignatedPort == rx.getSecondBridgeConnectionPort() && yxDesignatedPort != yrDesignatedPort) {
                LOG.debug("calculate: node: [{}]: level: {}, bridge: [{}] is a leaf of bridge: [{}], going one level down", new Object[]{this.getNodeId(), level, xBridge.getId(), yBridge.getId()});
                return this.findBridgesTopo(yx, this.m_domain.getSharedSegment(yBridgeId, yxDesignatedPort), xBridge, xBFT, level);
            }
            if (yxDesignatedPort == yrDesignatedPort && xyDesignatedPort != rx.getSecondBridgeConnectionPort()) {
                LOG.info("calculate: node: [{}], level: {}, bridge: [{},designated port [{}]]: found level.", new Object[]{this.getNodeId(), level, xBridge.getId(), xyDesignatedPort});
                LOG.debug("calculate: node: [{}], level: {}, bridge: [{},designated port [{}]]: is 'up' for bridge: [{}].", new Object[]{this.getNodeId(), level, xBridge.getId(), xyDesignatedPort, yBridge.getId()});
                SharedSegment leafSegment = this.m_domain.getSharedSegment(xBridge.getId(), xyDesignatedPort);
                if (leafSegment == null) {
                    leafSegment = new SharedSegment(this.m_domain, yx.getSimpleConnection(), yx.getSimpleConnectionMacs());
                    leafSegment.setDesignatedBridge(xBridge.getId());
                    this.m_domain.add(leafSegment);
                } else {
                    leafSegment.retain(yx.getSimpleConnectionMacs(), yx.getFirstBridgePort());
                }
                portsAdded.add(xyDesignatedPort);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("calculate: node: [{}], level: {}, bridge [{}]. Remove bridge [{}] and macs {} from top segment.", new Object[]{this.getNodeId(), level, xBridge.getId(), yBridge.getId(), topSegment.getMacsOnSegment()});
                }
                topSegment.getMacsOnSegment().clear();
                topSegment.removeBridge(yBridgeId.intValue());
            } else {
                if (xyDesignatedPort != rx.getSecondBridgeConnectionPort() && yxDesignatedPort != yrDesignatedPort) {
                    LOG.warn("calculate: node: [{}]: level {}: bridge [{}]. Topology mismatch. Clearing...topology", new Object[]{this.getNodeId(), level, xBridge.getId()});
                    return false;
                }
                macsOnSegment.retainAll(yx.getSimpleConnectionMacs());
            }
            forwarders.addAll(yx.getFirstBridgeForwarders());
            forwarders.addAll(yx.getSecondBridgeForwarders());
        }
        LOG.debug("calculate: node: [{}]: level: {}, bridge: [{}]. assign macs {} to top segment", new Object[]{this.getNodeId(), level, xBridge.getId(), macsOnSegment});
        topSegment.assign(macsOnSegment, rx.getSecondBridgePort());
        if (LOG.isDebugEnabled()) {
            LOG.debug("calculate: node: [{}]: level: {}, bridge: [{}]. resulting top segment: [ids {}, designated bridge [{}, port: {}], mac : {}]", new Object[]{this.getNodeId(), level, xBridge.getId(), topSegment.getBridgeIdsOnSegment(), topSegment.getDesignatedBridge(), topSegment.getDesignatedPort(), topSegment.getMacsOnSegment()});
        }
        for (Integer xbridgePort : rx.getSecondBridgeTroughSetBft().keySet()) {
            if (portsAdded.contains(xbridgePort)) continue;
            SharedSegment xleafSegment = new SharedSegment(this.m_domain, rx.getSecondBridgeTroughSetBft().get(xbridgePort));
            xleafSegment.setDesignatedBridge(xBridge.getId());
            this.m_domain.add(xleafSegment);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("calculate: node: [{}]: level: {}, bridge: [{}]. Add shared segment. [ designated bridge:[{}], port:{}, mac: {}]", new Object[]{this.getNodeId(), level, xBridge.getId(), xleafSegment.getDesignatedBridge(), xleafSegment.getDesignatedPort(), xleafSegment.getMacsOnSegment()});
        }
        this.addForwarding(this.m_domain, forwarders);
        return true;
    }

    public class BridgeTopologyHelper {
        Integer m_xy;
        Integer m_yx;
        Map<Integer, List<BridgeMacLink>> m_throughSetX = new HashMap<Integer, List<BridgeMacLink>>();
        Map<Integer, List<BridgeMacLink>> m_throughSetY = new HashMap<Integer, List<BridgeMacLink>>();
        List<BridgeMacLink> m_forwardersX = new ArrayList<BridgeMacLink>();
        List<BridgeMacLink> m_forwardersY = new ArrayList<BridgeMacLink>();
        Set<String> m_macsOnSegment = new HashSet<String>();
        BridgePort m_xyPort;
        BridgePort m_yxPort;

        public BridgeTopologyHelper(Bridge xBridge, List<BridgeMacLink> xBFT, Bridge yBridge, List<BridgeMacLink> yBFT) {
            Integer yx;
            Integer xy;
            HashMap<String, BridgeMacLink> xmactoport = new HashMap<String, BridgeMacLink>();
            HashMap<String, BridgeMacLink> ymactoport = new HashMap<String, BridgeMacLink>();
            HashSet<String> xmacs = new HashSet<String>();
            HashSet<String> ymacs = new HashSet<String>();
            if (LOG.isDebugEnabled()) {
                LOG.debug("simple connection [{} <--> {}]: searching.\n xbft\n{}\n ybft\n{}", new Object[]{xBridge.getId(), yBridge.getId(), BroadcastDomain.printTopologyBFT(xBFT), BroadcastDomain.printTopologyBFT(yBFT)});
            }
            for (BridgeMacLink xlink : xBFT) {
                if (xBridge.getId().intValue() == xlink.getNode().getId().intValue() && xlink.getBridgeDot1qTpFdbStatus() == BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED) {
                    xmactoport.put(xlink.getMacAddress(), xlink);
                }
                if (xBridge.getId().intValue() != xlink.getNode().getId().intValue() || xlink.getBridgeDot1qTpFdbStatus() != BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_SELF) continue;
                xmacs.add(xlink.getMacAddress());
            }
            for (BridgeMacLink ylink : yBFT) {
                if (yBridge.getId().intValue() == ylink.getNode().getId().intValue() && ylink.getBridgeDot1qTpFdbStatus() == BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED) {
                    ymactoport.put(ylink.getMacAddress(), ylink);
                }
                if (yBridge.getId().intValue() != ylink.getNode().getId().intValue() || ylink.getBridgeDot1qTpFdbStatus() != BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_SELF) continue;
                ymacs.add(ylink.getMacAddress());
            }
            if (NodeDiscoveryBridgeTopology.this.m_domain.getBridgeMacAddresses(xBridge.getId()) != null) {
                xmacs.addAll(NodeDiscoveryBridgeTopology.this.m_domain.getBridgeMacAddresses(xBridge.getId()));
            }
            if (NodeDiscoveryBridgeTopology.this.m_domain.getBridgeMacAddresses(yBridge.getId()) != null) {
                ymacs.addAll(NodeDiscoveryBridgeTopology.this.m_domain.getBridgeMacAddresses(yBridge.getId()));
            }
            if ((xy = this.condition1(ymacs, xmactoport)) != null) {
                this.m_xy = xy;
                LOG.debug("simple connection: [{} port: {} --> {}].", new Object[]{xBridge.getId(), this.m_xy, yBridge.getId()});
            }
            if ((yx = this.condition1(xmacs, ymactoport)) != null) {
                this.m_yx = yx;
                LOG.debug("simple connection: [{} <-- {} port: {}].", new Object[]{xBridge.getId(), yBridge.getId(), this.m_yx});
            }
            if (this.m_xy == null || this.m_yx == null) {
                HashSet<String> commonlearnedmacs = new HashSet<String>(xmactoport.keySet());
                commonlearnedmacs.retainAll(new HashSet(ymactoport.keySet()));
                LOG.debug("simple connection: [{} <--> {}] common (learned mac): {}", new Object[]{xBridge.getId(), yBridge.getId(), commonlearnedmacs});
                if (this.m_yx != null && this.m_xy == null) {
                    this.m_xy = this.condition2(commonlearnedmacs, this.m_yx, ymactoport, xmactoport);
                } else if (this.m_yx == null && this.m_xy != null) {
                    this.m_yx = this.condition2(commonlearnedmacs, this.m_xy, xmactoport, ymactoport);
                } else {
                    List<Integer> ports = this.condition3(commonlearnedmacs, xmactoport, ymactoport);
                    if (ports.size() == 2) {
                        this.m_xy = ports.get(0);
                        this.m_yx = ports.get(1);
                    }
                }
            }
            if (this.m_xy == null || this.m_xy == null) {
                LOG.warn("simple connection: [{}, port {}] <--> [{}, port {}]. Not found. exiting", new Object[]{xBridge.getId(), this.m_xy, yBridge.getId(), this.m_yx});
                return;
            }
            BridgeMacLink xylink = null;
            BridgeMacLink yxlink = null;
            for (BridgeMacLink xlink : xBFT) {
                if (xlink.getBridgePort() == this.m_xy && xlink.getBridgeDot1qTpFdbStatus() == BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED) {
                    if (ymactoport.get(xlink.getMacAddress()) != null && this.m_yx == ((BridgeMacLink)ymactoport.get(xlink.getMacAddress())).getBridgePort()) {
                        this.m_macsOnSegment.add(xlink.getMacAddress());
                        LOG.debug("simple connection: [{}, port {}] <--> [{}, port {}], forward set: mac added: [bridge:[{}],port:{},mac:{}].", new Object[]{xBridge.getId(), this.m_xy, yBridge.getId(), this.m_yx, xlink.getNode().getId(), xlink.getBridgePort(), xlink.getMacAddress()});
                    } else if (ymactoport.get(xlink.getMacAddress()) == null) {
                        this.m_forwardersX.add(xlink);
                        LOG.debug("simple connection: [{}, port {}] <--> [{}, port {}], through set: mac added: [bridge:[{}],port:{},mac:{}].", new Object[]{xBridge.getId(), this.m_xy, yBridge.getId(), this.m_yx, xlink.getNode().getId(), xlink.getBridgePort(), xlink.getMacAddress()});
                    }
                    if (xylink != null) continue;
                    xylink = xlink;
                    continue;
                }
                if (xlink.getBridgeDot1qTpFdbStatus() != BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED) continue;
                LOG.debug("simple connection: [{}, port {}] <--> [{}, port {}], through set: mac added: [bridge:[{}],port:{},mac:{}].", new Object[]{xBridge.getId(), this.m_xy, yBridge.getId(), this.m_yx, xlink.getNode().getId(), xlink.getBridgePort(), xlink.getMacAddress()});
                if (!this.m_throughSetX.containsKey(xlink.getBridgePort())) {
                    this.m_throughSetX.put(xlink.getBridgePort(), new ArrayList());
                }
                this.m_throughSetX.get(xlink.getBridgePort()).add(xlink);
            }
            for (BridgeMacLink ylink : yBFT) {
                if (ylink.getBridgePort() == this.m_yx && ylink.getBridgeDot1qTpFdbStatus() == BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED) {
                    if (xmactoport.get(ylink.getMacAddress()) != null && this.m_xy == ((BridgeMacLink)xmactoport.get(ylink.getMacAddress())).getBridgePort()) {
                        this.m_macsOnSegment.add(ylink.getMacAddress());
                        LOG.debug("simple connection: [{}, port {}] <--> [{}, port {}], forward set: mac added: [bridge:[{}],port:{},mac:{}].", new Object[]{xBridge.getId(), this.m_xy, yBridge.getId(), this.m_yx, ylink.getNode().getId(), ylink.getBridgePort(), ylink.getMacAddress()});
                    } else if (xmactoport.get(ylink.getMacAddress()) == null) {
                        this.m_forwardersY.add(ylink);
                        LOG.debug("simple connection: [{}, port {}] <--> [{}, port {}], through set: mac added: [bridge:[{}],port:{},mac:{}].", new Object[]{xBridge.getId(), this.m_xy, yBridge.getId(), this.m_yx, ylink.getNode().getId(), ylink.getBridgePort(), ylink.getMacAddress()});
                    }
                    if (yxlink != null) continue;
                    yxlink = ylink;
                    continue;
                }
                if (ylink.getBridgeDot1qTpFdbStatus() != BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED) continue;
                LOG.debug("simple connection: [{}, port {}] <--> [{}, port {}], through set: mac added: [bridge:[{}],port:{},mac:{}].", new Object[]{xBridge.getId(), this.m_xy, yBridge.getId(), this.m_yx, ylink.getNode().getId(), ylink.getBridgePort(), ylink.getMacAddress()});
                if (!this.m_throughSetY.containsKey(ylink.getBridgePort())) {
                    this.m_throughSetY.put(ylink.getBridgePort(), new ArrayList());
                }
                this.m_throughSetY.get(ylink.getBridgePort()).add(ylink);
            }
            LOG.debug("simple connection: [{}, port {}] <--> [{}, port {}], found macs:{}.", new Object[]{xBridge.getId(), this.m_xy, yBridge.getId(), this.m_yx, this.m_macsOnSegment.size()});
            if (yxlink != null) {
                this.m_yxPort = new BridgePort();
                this.m_yxPort.setNode(yxlink.getNode());
                this.m_yxPort.setBridgePort(yxlink.getBridgePort());
                this.m_yxPort.setBridgePortIfIndex(yxlink.getBridgePortIfIndex());
                this.m_yxPort.setBridgePortIfName(yxlink.getBridgePortIfName());
                this.m_yxPort.setVlan(yxlink.getVlan());
                this.m_yxPort.setCreateTime(yxlink.getBridgeMacLinkCreateTime());
            }
            if (xylink != null) {
                this.m_xyPort = new BridgePort();
                this.m_xyPort.setNode(xylink.getNode());
                this.m_xyPort.setBridgePort(xylink.getBridgePort());
                this.m_xyPort.setBridgePortIfIndex(xylink.getBridgePortIfIndex());
                this.m_xyPort.setBridgePortIfName(xylink.getBridgePortIfName());
                this.m_xyPort.setVlan(xylink.getVlan());
                this.m_xyPort.setCreateTime(xylink.getBridgeMacLinkCreateTime());
            }
        }

        private List<Integer> condition3(Set<String> commonlearnedmacs, Map<String, BridgeMacLink> xbft, Map<String, BridgeMacLink> ybft) {
            String mac1 = null;
            String mac2 = null;
            Integer yp1 = null;
            Integer yp2 = null;
            Integer xp1 = null;
            Integer xp2 = null;
            ArrayList<Integer> bbports = new ArrayList<Integer>(2);
            for (String mac : commonlearnedmacs) {
                LOG.debug("condition3: parsing common BFT mac: {}", (Object)mac);
                if (mac1 == null) {
                    mac1 = mac;
                    yp1 = ybft.get(mac).getBridgePort();
                    xp1 = xbft.get(mac).getBridgePort();
                    LOG.debug("condition3: mac1: {} xp1: {} yp1: {} ", new Object[]{mac1, xp1, yp1});
                    continue;
                }
                if (ybft.get(mac).getBridgePort() == yp1 && xbft.get(mac).getBridgePort() == xp1) continue;
                if (mac2 == null) {
                    mac2 = mac;
                    yp2 = ybft.get(mac).getBridgePort();
                    xp2 = xbft.get(mac).getBridgePort();
                    LOG.debug("condition3: mac2: {} xp2: {} yp2: {} ", new Object[]{mac2, xp2, yp2});
                    continue;
                }
                if (ybft.get(mac).getBridgePort() == yp2 && xbft.get(mac).getBridgePort() == xp2) continue;
                Integer yp3 = ybft.get(mac).getBridgePort();
                Integer xp3 = xbft.get(mac).getBridgePort();
                LOG.debug("condition3: mac3: {} x3: {} yp3: {} ", new Object[]{mac, xp3, yp3});
                if (xp1 == xp2 && xp1 != xp3 && (yp1 != yp3 || yp2 != yp3)) {
                    bbports.add(0, xp1);
                    bbports.add(1, yp3);
                    return bbports;
                }
                if (yp1 == yp2 && yp1 != yp3 && (xp1 != xp3 || xp2 != xp3)) {
                    bbports.add(0, xp3);
                    bbports.add(1, yp1);
                    return bbports;
                }
                if (xp1 == xp3 && xp1 != xp2 && (yp1 != yp2 || yp2 != yp3)) {
                    bbports.add(0, xp1);
                    bbports.add(1, yp2);
                    return bbports;
                }
                if (yp1 == yp3 && yp1 != yp2 && (xp1 != xp2 || xp2 != xp3)) {
                    bbports.add(0, xp2);
                    bbports.add(1, yp1);
                    return bbports;
                }
                if (xp3 == xp2 && xp1 != xp3 && (yp1 != yp3 || yp2 != yp1)) {
                    bbports.add(0, xp2);
                    bbports.add(1, yp1);
                    return bbports;
                }
                if (yp3 != yp2 || yp1 == yp3 || xp1 == xp3 && xp2 == xp1) continue;
                bbports.add(0, xp1);
                bbports.add(1, yp2);
                return bbports;
            }
            if (mac2 == null) {
                bbports.add(0, xp1);
                bbports.add(1, yp1);
                return bbports;
            }
            return bbports;
        }

        private Integer condition2(Set<String> commonlearnedmacs, Integer yx, Map<String, BridgeMacLink> ybft, Map<String, BridgeMacLink> xbft) {
            String mac1 = null;
            String mac2 = null;
            Integer p1 = null;
            Integer xy1 = null;
            Integer p2 = null;
            Integer xy2 = null;
            for (String mac : commonlearnedmacs) {
                if (ybft.get(mac) == null || ybft.get(mac).getBridgePort() == null || xbft.get(mac) == null || xbft.get(mac).getBridgePort() == null) continue;
                if (mac1 == null) {
                    mac1 = mac;
                    p1 = ybft.get(mac).getBridgePort();
                    xy1 = xbft.get(mac).getBridgePort();
                    LOG.debug("condition2: mac1: {} xy1: {} p1: {} ", new Object[]{mac1, xy1, p1});
                    if (p1.intValue() == yx.intValue()) continue;
                    LOG.debug("condition2: p1 is not yx: so is on the other side. xy bridge port {}", (Object)xy1);
                    return xy1;
                }
                if (ybft.get(mac).getBridgePort().intValue() == p1.intValue()) continue;
                mac2 = mac;
                p2 = ybft.get(mac).getBridgePort();
                xy2 = xbft.get(mac).getBridgePort();
                LOG.debug("condition2: mac2: {} xy2: {} p2: {} ", new Object[]{mac2, xy2, p2});
                if (xy2.intValue() == xy1.intValue()) {
                    LOG.debug("condition2: p1 and p2 are both different then yx: xy bridge port {}", (Object)xy1);
                    return xy1;
                }
                if (p1.intValue() == yx.intValue()) {
                    LOG.debug("condition2: p1 is yx: p2 is on the other side of the switch: xy bridge port {}", (Object)xy2);
                    return xy2;
                }
                if (p2.intValue() != yx.intValue()) continue;
                LOG.debug("condition2: p2 is yx: p1 is on the other side of the switch: xy bridge port {}", (Object)xy1);
                return xy1;
            }
            return null;
        }

        private Integer condition1(Set<String> bridgemacaddressess, Map<String, BridgeMacLink> otherbridgebft) {
            for (String mac : bridgemacaddressess) {
                if (!otherbridgebft.containsKey(mac)) continue;
                LOG.debug("condition1: base address {} --> port: {} ", (Object)mac, (Object)otherbridgebft.get(mac).getBridgePort());
                return otherbridgebft.get(mac).getBridgePort();
            }
            LOG.debug("condition1: base address: {}. Not found.", bridgemacaddressess);
            return null;
        }

        public Integer getFirstBridgeConnectionPort() {
            return this.m_xy;
        }

        public Integer getSecondBridgeConnectionPort() {
            return this.m_yx;
        }

        public BridgePort getFirstBridgePort() {
            return this.m_xyPort;
        }

        public BridgePort getSecondBridgePort() {
            return this.m_yxPort;
        }

        public Set<String> getSimpleConnectionMacs() {
            return this.m_macsOnSegment;
        }

        public Map<Integer, List<BridgeMacLink>> getFirstBridgeTroughSetBft() {
            return this.m_throughSetX;
        }

        public Map<Integer, List<BridgeMacLink>> getSecondBridgeTroughSetBft() {
            return this.m_throughSetY;
        }

        public List<BridgeMacLink> getFirstBridgeForwarders() {
            return this.m_forwardersX;
        }

        public List<BridgeMacLink> getSecondBridgeForwarders() {
            return this.m_forwardersY;
        }

        public Set<BridgePort> getSimpleConnection() {
            HashSet<BridgePort> ports = new HashSet<BridgePort>();
            ports.add(this.m_xyPort);
            ports.add(this.m_yxPort);
            return ports;
        }
    }
}

