/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.actiond;

import java.util.Enumeration;
import java.util.Queue;
import org.opennms.netmgt.events.api.EventIpcManagerFactory;
import org.opennms.netmgt.events.api.EventListener;
import org.opennms.netmgt.xml.event.Autoaction;
import org.opennms.netmgt.xml.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class BroadcastEventProcessor
implements EventListener {
    private static final Logger LOG = LoggerFactory.getLogger(BroadcastEventProcessor.class);
    private final Queue<String> m_execQ;

    BroadcastEventProcessor(Queue<String> execQ) {
        this.m_execQ = execQ;
        EventIpcManagerFactory.init();
        EventIpcManagerFactory.getIpcManager().addEventListener((EventListener)this);
    }

    public synchronized void close() {
        EventIpcManagerFactory.getIpcManager().removeEventListener((EventListener)this);
    }

    public void onEvent(Event event) {
        if (event == null) {
            return;
        }
        Enumeration walker = event.enumerateAutoaction();
        while (walker.hasMoreElements()) {
            Autoaction aact = (Autoaction)walker.nextElement();
            if ("on".equalsIgnoreCase(aact.getState())) {
                this.m_execQ.add(aact.getContent());
            }
            LOG.debug("Added event '{}' to execute autoaction '{}'", (Object)event.getUei(), (Object)aact.getContent());
        }
        if (event.getTticket() != null && event.getTticket().getState().equalsIgnoreCase("on")) {
            this.m_execQ.add(event.getTticket().getContent());
            LOG.debug("Added event '{}' to execute tticket '{}'", (Object)event.getUei(), (Object)event.getTticket().getContent());
        }
    }

    public String getName() {
        return "Actiond:BroadcastEventProcessor";
    }
}

