/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmpinterfacepoller;

import java.util.List;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.snmpinterfacepoller.pollable.PollableSnmpInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnmpPollInterfaceMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(SnmpPollInterfaceMonitor.class);
    private static final String IF_ADMIN_STATUS_OID = ".1.3.6.1.2.1.2.2.1.7.";
    private static final String IF_OPER_STATUS_OID = ".1.3.6.1.2.1.2.2.1.8.";

    public List<PollableSnmpInterface.SnmpMinimalPollInterface> poll(SnmpAgentConfig agentConfig, List<PollableSnmpInterface.SnmpMinimalPollInterface> mifaces) {
        if (mifaces == null) {
            LOG.error("Null Interfaces passed to Monitor, exiting");
            return null;
        }
        LOG.debug("Got {} interfaces to poll", (Object)mifaces.size());
        if (agentConfig == null) {
            throw new RuntimeException("SnmpAgentConfig object not available");
        }
        SnmpObjId[] adminoids = new SnmpObjId[mifaces.size()];
        SnmpObjId[] operooids = new SnmpObjId[mifaces.size()];
        for (int i = 0; i < mifaces.size(); ++i) {
            PollableSnmpInterface.SnmpMinimalPollInterface miface = mifaces.get(i);
            miface.setStatus(PollStatus.unavailable());
            adminoids[i] = SnmpObjId.get((String)(IF_ADMIN_STATUS_OID + miface.getIfindex()));
            operooids[i] = SnmpObjId.get((String)(IF_OPER_STATUS_OID + miface.getIfindex()));
            LOG.debug("Adding Admin/Oper oids: {}/{}", (Object)adminoids[i], (Object)operooids[i]);
        }
        SnmpValue[] adminresults = new SnmpValue[mifaces.size()];
        SnmpValue[] operoresults = new SnmpValue[mifaces.size()];
        LOG.debug("try to get admin statuses");
        adminresults = SnmpUtils.get((SnmpAgentConfig)agentConfig, (SnmpObjId[])adminoids);
        LOG.debug("got admin status {} SnmpValues", (Object)adminresults.length);
        if (adminresults.length != mifaces.size()) {
            LOG.warn("Snmp Interface Admin statuses collection failed");
            return mifaces;
        }
        LOG.debug("try to get operational statuses");
        operoresults = SnmpUtils.get((SnmpAgentConfig)agentConfig, (SnmpObjId[])operooids);
        LOG.debug("got operational status {} SnmpValues", (Object)operoresults.length);
        if (operoresults.length != mifaces.size()) {
            LOG.warn("Snmp Interface Operational statuses collection failed");
            return mifaces;
        }
        for (int i = 0; i < mifaces.size(); ++i) {
            PollableSnmpInterface.SnmpMinimalPollInterface miface = mifaces.get(i);
            if (adminresults[i] != null && operoresults[i] != null) {
                try {
                    miface.setAdminstatus(adminresults[i].toInt());
                    miface.setOperstatus(operoresults[i].toInt());
                    miface.setStatus(PollStatus.up());
                    LOG.debug("SNMP Value is {} for oid: {}", (Object)adminresults[i].toInt(), (Object)adminoids[i]);
                    LOG.debug("SNMP Value is {} for oid: {}", (Object)operoresults[i].toInt(), (Object)operooids[i]);
                }
                catch (Exception e) {
                    LOG.warn("SNMP Value is {} for oid: {}", (Object)adminresults[i].toDisplayString(), (Object)adminoids[i]);
                    LOG.warn("SNMP Value is {} for oid: {}", (Object)operoresults[i].toDisplayString(), (Object)operooids[i]);
                }
                continue;
            }
            LOG.info("SNMP Value is null for oid: {}/{}", (Object)adminoids[i], (Object)operooids[i]);
        }
        return mifaces;
    }
}

