/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.net.InetAddress;
import org.opennms.netmgt.collectd.DefaultCollectionAgent;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionAgentFactory;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.snmp.InetAddrUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;

public class DefaultCollectionAgentFactory
implements CollectionAgentFactory {
    @Autowired
    private NodeDao nodeDao;
    @Autowired
    private IpInterfaceDao ipInterfaceDao;
    @Autowired
    private PlatformTransactionManager transMgr;

    public CollectionAgent createCollectionAgentAndOverrideLocation(String nodeCriteria, InetAddress ipAddr, String location) {
        OnmsNode node = this.nodeDao.get(nodeCriteria);
        if (node == null) {
            throw new IllegalArgumentException(String.format("No node found with lookup criteria: %s", nodeCriteria));
        }
        OnmsIpInterface ipInterface = this.ipInterfaceDao.findByNodeIdAndIpAddress(node.getId(), InetAddrUtils.str((InetAddress)ipAddr));
        if (ipInterface == null) {
            throw new IllegalArgumentException(String.format("No interface found with IP %s on node %s", InetAddrUtils.str((InetAddress)ipAddr), nodeCriteria));
        }
        return DefaultCollectionAgent.create(ipInterface.getId(), this.ipInterfaceDao, this.transMgr, location);
    }

    public CollectionAgent createCollectionAgent(String nodeCriteria, InetAddress ipAddr) {
        return this.createCollectionAgentAndOverrideLocation(nodeCriteria, ipAddr, null);
    }

    public CollectionAgent createCollectionAgent(OnmsIpInterface ipIf) {
        return DefaultCollectionAgent.create(ipIf.getId(), this.ipInterfaceDao, this.transMgr);
    }
}

