/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.vacuumd;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import javax.sql.DataSource;
import junit.framework.TestCase;
import org.easymock.EasyMock;
import org.opennms.core.db.DataSourceFactory;
import org.opennms.netmgt.vacuumd.Transaction;
import org.opennms.test.mock.EasyMockUtils;

public class TransactionTest
extends TestCase {
    EasyMockUtils m_ezMock = new EasyMockUtils();
    Connection m_conn;
    Connection m_conn2;
    DataSource m_ds;
    DataSource m_ds2;

    protected void setUp() throws Exception {
        super.setUp();
        this.m_ds = (DataSource)this.m_ezMock.createMock(DataSource.class);
        this.m_ds2 = (DataSource)this.m_ezMock.createMock(DataSource.class);
        this.m_conn = (Connection)this.m_ezMock.createMock(Connection.class);
        this.m_conn2 = (Connection)this.m_ezMock.createMock(Connection.class);
        DataSourceFactory.setInstance((String)"ds", (DataSource)this.m_ds);
        DataSourceFactory.setInstance((String)"ds2", (DataSource)this.m_ds2);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testCommit() throws Exception {
        EasyMock.expect((Object)this.m_ds.getConnection()).andReturn((Object)this.m_conn);
        EasyMock.expect((Object)this.m_ds2.getConnection()).andReturn((Object)this.m_conn2);
        this.m_conn.setAutoCommit(false);
        this.m_conn.commit();
        this.m_conn.close();
        this.m_conn2.setAutoCommit(false);
        this.m_conn2.commit();
        this.m_conn2.close();
        this.m_ezMock.replayAll();
        Transaction.begin();
        Transaction.getConnection((String)"ds");
        Transaction.getConnection((String)"ds2");
        Transaction.end();
        this.m_ezMock.verifyAll();
    }

    public void testRollback() throws Exception {
        EasyMock.expect((Object)this.m_ds.getConnection()).andReturn((Object)this.m_conn);
        EasyMock.expect((Object)this.m_ds2.getConnection()).andReturn((Object)this.m_conn2);
        this.m_conn.setAutoCommit(false);
        this.m_conn.rollback();
        this.m_conn.close();
        this.m_conn2.setAutoCommit(false);
        this.m_conn2.rollback();
        this.m_conn2.close();
        this.m_ezMock.replayAll();
        Transaction.begin();
        Transaction.getConnection((String)"ds");
        Transaction.getConnection((String)"ds2");
        Transaction.rollbackOnly();
        Transaction.end();
        this.m_ezMock.verifyAll();
    }

    public void testReturnSameConnection() throws Exception {
        EasyMock.expect((Object)this.m_ds.getConnection()).andReturn((Object)this.m_conn);
        this.m_conn.setAutoCommit(false);
        this.m_conn.commit();
        this.m_conn.close();
        this.m_ezMock.replayAll();
        Transaction.begin();
        Connection c1 = Transaction.getConnection((String)"ds");
        Connection c2 = Transaction.getConnection((String)"ds");
        TransactionTest.assertSame((String)"Expected to get the same connection for both calls to getConnection", (Object)c1, (Object)c2);
        Transaction.end();
        this.m_ezMock.verifyAll();
    }

    public void testCloseResources() throws Exception {
        EasyMock.expect((Object)this.m_ds.getConnection()).andReturn((Object)this.m_conn);
        this.m_conn.setAutoCommit(false);
        Statement stmt = (Statement)this.m_ezMock.createMock(Statement.class);
        ResultSet rs = (ResultSet)this.m_ezMock.createMock(ResultSet.class);
        rs.close();
        stmt.close();
        this.m_conn.close();
        this.m_conn.commit();
        this.m_ezMock.replayAll();
        Transaction.begin();
        Transaction.getConnection((String)"ds");
        Transaction.register((Statement)stmt);
        Transaction.register((ResultSet)rs);
        Transaction.end();
        this.m_ezMock.verifyAll();
    }
}

