/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.util.Collection;
import java.util.HashMap;
import junit.framework.TestCase;
import org.opennms.netmgt.config.threshd.Basethresholddef;
import org.opennms.netmgt.config.threshd.Expression;
import org.opennms.netmgt.config.threshd.ThresholdType;
import org.opennms.netmgt.threshd.BaseThresholdDefConfigWrapper;
import org.opennms.netmgt.threshd.ExpressionConfigWrapper;
import org.opennms.netmgt.threshd.ThresholdEntity;

public class ThresholdExpressionTestCase
extends TestCase {
    Expression expression;

    public void setUp() {
        this.expression = new Expression();
        this.expression.setType(ThresholdType.HIGH);
        this.expression.setDsType("node");
        this.expression.setValue(Double.valueOf(99.0));
        this.expression.setRearm(Double.valueOf(0.5));
        this.expression.setTrigger(Integer.valueOf(1));
    }

    public void testEvaluateEvaluateSingleItemWithDivision() throws Exception {
        this.expression.setExpression("dsname/10");
        ExpressionConfigWrapper wrapper = new ExpressionConfigWrapper(this.expression);
        ThresholdExpressionTestCase.assertEquals((int)1, (int)wrapper.getRequiredDatasources().size());
        for (String ds : new String[]{"dsname"}) {
            ThresholdExpressionTestCase.assertTrue((boolean)wrapper.getRequiredDatasources().contains(ds));
        }
        HashMap<String, Double> values = new HashMap<String, Double>();
        values.put("dsname", 1000.0);
        double result = wrapper.evaluate(values);
        ThresholdExpressionTestCase.assertEquals((String)"Threshold Expression result", (Object)result, (Object)100.0);
    }

    public void testEvaluateEvaluateSingleItemWithMultiply() throws Exception {
        this.expression.setExpression("dsname*10");
        ExpressionConfigWrapper wrapper = new ExpressionConfigWrapper(this.expression);
        ThresholdExpressionTestCase.assertEquals((int)1, (int)wrapper.getRequiredDatasources().size());
        for (String ds : new String[]{"dsname"}) {
            ThresholdExpressionTestCase.assertTrue((boolean)wrapper.getRequiredDatasources().contains(ds));
        }
        HashMap<String, Double> values = new HashMap<String, Double>();
        values.put("dsname", 100.0);
        double result = wrapper.evaluate(values);
        ThresholdExpressionTestCase.assertEquals((String)"Threshold Expression result", (Object)result, (Object)1000.0);
    }

    public void testEvaluateEvaluateSingleItemWithSubtraction() throws Exception {
        this.expression.setExpression("dsname-10");
        ExpressionConfigWrapper wrapper = new ExpressionConfigWrapper(this.expression);
        ThresholdExpressionTestCase.assertEquals((int)1, (int)wrapper.getRequiredDatasources().size());
        for (String ds : new String[]{"dsname"}) {
            ThresholdExpressionTestCase.assertTrue((String)("Could not find expected variable: " + ds), (boolean)wrapper.getRequiredDatasources().contains(ds));
        }
        HashMap<String, Double> values = new HashMap<String, Double>();
        values.put("dsname", 100.0);
        double result = wrapper.evaluate(values);
        ThresholdExpressionTestCase.assertEquals((String)"Threshold Expression result", (Object)result, (Object)90.0);
    }

    public void testEvaluateEvaluateSingleItemWithAddition() throws Exception {
        this.expression.setExpression("dsname+10");
        ExpressionConfigWrapper wrapper = new ExpressionConfigWrapper(this.expression);
        ThresholdExpressionTestCase.assertEquals((int)1, (int)wrapper.getRequiredDatasources().size());
        for (String ds : new String[]{"dsname"}) {
            ThresholdExpressionTestCase.assertTrue((String)("Could not find expected variable: " + ds), (boolean)wrapper.getRequiredDatasources().contains(ds));
        }
        HashMap<String, Double> values = new HashMap<String, Double>();
        values.put("dsname", 100.0);
        double result = wrapper.evaluate(values);
        ThresholdExpressionTestCase.assertEquals((String)"Threshold Expression result", (Object)result, (Object)110.0);
    }

    public void testEvaluateEvaluateMultipleItemsDivided() throws Exception {
        this.expression.setExpression("dsname1/dsname2");
        ExpressionConfigWrapper wrapper = new ExpressionConfigWrapper(this.expression);
        ThresholdExpressionTestCase.assertEquals((int)2, (int)wrapper.getRequiredDatasources().size());
        for (String ds : new String[]{"dsname1", "dsname2"}) {
            ThresholdExpressionTestCase.assertTrue((String)("Could not find expected variable: " + ds), (boolean)wrapper.getRequiredDatasources().contains(ds));
        }
        HashMap<String, Double> values = new HashMap<String, Double>();
        values.put("dsname1", 100.0);
        values.put("dsname2", 5.0);
        double result = wrapper.evaluate(values);
        ThresholdExpressionTestCase.assertEquals((String)"Threshold Expression result", (Object)result, (Object)20.0);
    }

    public void testEvaluateEvaluateMultipleItemsMultiplied() throws Exception {
        this.expression.setExpression("dsname1*dsname2");
        ExpressionConfigWrapper wrapper = new ExpressionConfigWrapper(this.expression);
        ThresholdExpressionTestCase.assertEquals((int)2, (int)wrapper.getRequiredDatasources().size());
        for (String ds : new String[]{"dsname1", "dsname2"}) {
            ThresholdExpressionTestCase.assertTrue((String)("Could not find expected variable: " + ds), (boolean)wrapper.getRequiredDatasources().contains(ds));
        }
        HashMap<String, Double> values = new HashMap<String, Double>();
        values.put("dsname1", 20.0);
        values.put("dsname2", 5.0);
        double result = wrapper.evaluate(values);
        ThresholdExpressionTestCase.assertEquals((String)"Threshold Expression result", (Object)result, (Object)100.0);
    }

    public void testEvaluateEvaluateMultipleItemsAdded() throws Exception {
        this.expression.setExpression("dsname1+dsname2");
        ExpressionConfigWrapper wrapper = new ExpressionConfigWrapper(this.expression);
        ThresholdExpressionTestCase.assertEquals((int)2, (int)wrapper.getRequiredDatasources().size());
        for (String ds : new String[]{"dsname1", "dsname2"}) {
            ThresholdExpressionTestCase.assertTrue((String)("Could not find expected variable: " + ds), (boolean)wrapper.getRequiredDatasources().contains(ds));
        }
        HashMap<String, Double> values = new HashMap<String, Double>();
        values.put("dsname1", 20.0);
        values.put("dsname2", 5.0);
        double result = wrapper.evaluate(values);
        ThresholdExpressionTestCase.assertEquals((String)"Threshold Expression result", (Object)result, (Object)25.0);
    }

    public void testEvaluateEvaluateMultipleItemsSubtracted() throws Exception {
        this.expression.setExpression("dsname1-dsname2");
        ExpressionConfigWrapper wrapper = new ExpressionConfigWrapper(this.expression);
        ThresholdExpressionTestCase.assertEquals((int)2, (int)wrapper.getRequiredDatasources().size());
        for (String ds : new String[]{"dsname1", "dsname2"}) {
            ThresholdExpressionTestCase.assertTrue((String)("Could not find expected variable: " + ds), (boolean)wrapper.getRequiredDatasources().contains(ds));
        }
        HashMap<String, Double> values = new HashMap<String, Double>();
        values.put("dsname1", 20.0);
        values.put("dsname2", 5.0);
        double result = wrapper.evaluate(values);
        ThresholdExpressionTestCase.assertEquals((String)"Threshold Expression result", (Object)result, (Object)15.0);
    }

    public void testSemiComplexExpression() throws Exception {
        this.expression.setExpression("(hrStorageSize-hrStorageUsed)*hrStorageAllocationUnits");
        ExpressionConfigWrapper wrapper = new ExpressionConfigWrapper(this.expression);
        ThresholdExpressionTestCase.assertEquals((int)3, (int)wrapper.getRequiredDatasources().size());
        for (String ds : new String[]{"hrStorageSize", "hrStorageUsed", "hrStorageAllocationUnits"}) {
            ThresholdExpressionTestCase.assertTrue((String)("Could not find expected variable: " + ds), (boolean)wrapper.getRequiredDatasources().contains(ds));
        }
        HashMap<String, Double> values = new HashMap<String, Double>();
        values.put("hrStorageAllocationUnits", 1024.0);
        values.put("hrStorageSize", 2048.0);
        values.put("hrStorageUsed", 1024.0);
        double result = wrapper.evaluate(values);
        ThresholdExpressionTestCase.assertEquals((String)"Threshold Expression result", (Object)result, (Object)1048576.0);
    }

    public void testThresholdEntityRequiredDataSources() throws Exception {
        ThresholdEntity entity = new ThresholdEntity();
        this.expression.setExpression("(hrStorageSize-hrStorageUsed)*hrStorageAllocationUnits");
        BaseThresholdDefConfigWrapper wrapper = BaseThresholdDefConfigWrapper.getConfigWrapper((Basethresholddef)this.expression);
        ThresholdExpressionTestCase.assertEquals((int)3, (int)wrapper.getRequiredDatasources().size());
        for (String ds : new String[]{"hrStorageSize", "hrStorageUsed", "hrStorageAllocationUnits"}) {
            ThresholdExpressionTestCase.assertTrue((String)("Could not find expected variable: " + ds), (boolean)wrapper.getRequiredDatasources().contains(ds));
        }
        entity.addThreshold(wrapper);
        Collection dataSources = entity.getRequiredDatasources();
        StringBuilder dsStringBuffer = new StringBuilder();
        for (String dataSource : dataSources) {
            dsStringBuffer.append(dataSource).append(" ");
        }
        String dsString = dsStringBuffer.toString().trim();
        ThresholdExpressionTestCase.assertTrue((String)("Required data sources should contain hrStorageSize: " + dsString), (boolean)dataSources.contains("hrStorageSize"));
        ThresholdExpressionTestCase.assertTrue((String)("Required data sources should contain hrStorageUsed: " + dsString), (boolean)dataSources.contains("hrStorageUsed"));
        ThresholdExpressionTestCase.assertTrue((String)("Required data sources should contain hrStorageAllocationUnits: " + dsString), (boolean)dataSources.contains("hrStorageAllocationUnits"));
    }

    public void testEvaluateConditionalFalse() throws Exception {
        this.expression.setExpression("(trueval == trueval && a < b) ? trueval : falseval");
        ExpressionConfigWrapper wrapper = new ExpressionConfigWrapper(this.expression);
        ThresholdExpressionTestCase.assertEquals((int)4, (int)wrapper.getRequiredDatasources().size());
        for (String ds : new String[]{"a", "b", "trueval", "falseval"}) {
            ThresholdExpressionTestCase.assertTrue((String)("Could not find expected variable: " + ds), (boolean)wrapper.getRequiredDatasources().contains(ds));
        }
        HashMap<String, Double> values = new HashMap<String, Double>();
        values.put("a", 20.0);
        values.put("b", 5.0);
        values.put("trueval", 3.0);
        values.put("falseval", 7.0);
        double result = wrapper.evaluate(values);
        ThresholdExpressionTestCase.assertEquals((String)"Conditional Expression result", (Object)result, (Object)7.0);
    }

    public void testEvaluateConditionalTrue() throws Exception {
        this.expression.setExpression("(trueval == trueval && a < b) ? trueval : falseval");
        ExpressionConfigWrapper wrapper = new ExpressionConfigWrapper(this.expression);
        ThresholdExpressionTestCase.assertEquals((int)4, (int)wrapper.getRequiredDatasources().size());
        for (String ds : new String[]{"a", "b", "trueval", "falseval"}) {
            ThresholdExpressionTestCase.assertTrue((String)("Could not find expected variable: " + ds), (boolean)wrapper.getRequiredDatasources().contains(ds));
        }
        HashMap<String, Double> values = new HashMap<String, Double>();
        values.put("a", 2.0);
        values.put("b", 5.0);
        values.put("trueval", 3.0);
        values.put("falseval", 7.0);
        double result = wrapper.evaluate(values);
        ThresholdExpressionTestCase.assertEquals((String)"Conditional Expression result", (Object)result, (Object)3.0);
    }

    public void testAbsoluteValues() throws Exception {
        this.expression.setExpression("math.abs(variable + 5)");
        ExpressionConfigWrapper wrapper = new ExpressionConfigWrapper(this.expression);
        ThresholdExpressionTestCase.assertEquals((int)1, (int)wrapper.getRequiredDatasources().size());
        for (String ds : new String[]{"variable"}) {
            ThresholdExpressionTestCase.assertTrue((String)("Could not find expected variable: " + ds), (boolean)wrapper.getRequiredDatasources().contains(ds));
        }
        HashMap<String, Double> values = new HashMap<String, Double>();
        values.put("variable", -25.0);
        double result = wrapper.evaluate(values);
        ThresholdExpressionTestCase.assertEquals((String)"Conditional Expression result", (Object)20.0, (Object)result);
        values.clear();
        values.put("variable", 25.0);
        result = wrapper.evaluate(values);
        ThresholdExpressionTestCase.assertEquals((String)"Conditional Expression result", (Object)30.0, (Object)result);
    }
}

