/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import javax.management.InstanceNotFoundException;
import javax.management.ObjectName;
import javax.sql.DataSource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.camel.JmsQueueNameFactory;
import org.opennms.core.db.DataSourceFactory;
import org.opennms.core.test.MockLogAppender;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.MockDatabase;
import org.opennms.core.test.db.TemporaryDatabaseAware;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.PollOutagesConfig;
import org.opennms.netmgt.config.PollerConfig;
import org.opennms.netmgt.config.PollerConfigFactory;
import org.opennms.netmgt.config.poller.Package;
import org.opennms.netmgt.config.poller.Service;
import org.opennms.netmgt.dao.api.MonitoredServiceDao;
import org.opennms.netmgt.dao.api.MonitoringLocationDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.OutageDao;
import org.opennms.netmgt.dao.mock.MockEventIpcManager;
import org.opennms.netmgt.events.api.EventIpcManager;
import org.opennms.netmgt.icmp.proxy.LocationAwarePingClient;
import org.opennms.netmgt.mock.MockNetwork;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.monitoringLocations.OnmsMonitoringLocation;
import org.opennms.netmgt.poller.DefaultPollContext;
import org.opennms.netmgt.poller.LocationAwarePollerClient;
import org.opennms.netmgt.poller.Poller;
import org.opennms.netmgt.poller.QueryManager;
import org.opennms.netmgt.poller.ServiceMonitor;
import org.opennms.netmgt.poller.pollables.PollContext;
import org.opennms.netmgt.poller.pollables.PollableNetwork;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.opennms.test.mock.MockUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/applicationContext-daemon.xml", "classpath:/META-INF/opennms/applicationContext-eventUtil.xml", "classpath:/META-INF/opennms/mockEventIpcManager.xml", "classpath:/META-INF/opennms/applicationContext-pinger.xml", "classpath:/META-INF/opennms/applicationContext-rpc-client-camel.xml", "classpath:/META-INF/opennms/applicationContext-rpc-icmp.xml", "classpath:/META-INF/opennms/applicationContext-rpc-poller.xml", "classpath:/META-INF/opennms/applicationContext-pollerd.xml"})
@JUnitConfigurationEnvironment(systemProperties={"org.opennms.netmgt.icmp.pingerClass=org.opennms.netmgt.icmp.jna.JnaPinger", "org.opennms.jms.timeout=1", "activemq.data=target/activemq"})
@JUnitTemporaryDatabase(tempDbClass=MockDatabase.class, reuseDatabase=false)
@Transactional
public class PollerRpcTimeoutIT
implements TemporaryDatabaseAware<MockDatabase> {
    public static final String ACTIVEMQ_STORAGE_DIRECTORY = "target/activemq";
    public static final String NONEXISTENT_LOCATION = "DOESNT_EXIST";
    private Poller m_poller;
    private MockNetwork m_network;
    private MockDatabase m_db;
    @Autowired
    private PollOutagesConfig m_pollOutagesConfig;
    @Autowired
    private MockEventIpcManager m_eventMgr;
    @Autowired
    private QueryManager m_queryManager;
    @Autowired
    private OutageDao m_outageDao;
    @Autowired
    private NodeDao m_nodeDao;
    @Autowired
    private MonitoringLocationDao m_monitoringLocationDao;
    @Autowired
    private MonitoredServiceDao m_monitoredServiceDao;
    @Autowired
    private TransactionTemplate m_transactionTemplate;
    @Autowired
    private LocationAwarePollerClient m_locationAwarePollerClient;
    @Autowired
    private LocationAwarePingClient m_locationAwarePingClient;

    public void setTemporaryDatabase(MockDatabase database) {
        this.m_db = database;
    }

    private void startDaemons() {
        this.m_poller.init();
        this.m_poller.start();
    }

    private void stopDaemons() {
        if (this.m_poller != null) {
            this.m_poller.stop();
        }
    }

    @BeforeClass
    @AfterClass
    public static void deleteActiveMqStorage() throws Exception {
        FileUtils.deleteDirectory((File)new File(ACTIVEMQ_STORAGE_DIRECTORY));
    }

    @Before
    public void setUp() throws Exception {
        MockUtil.println((String)"------------ Begin Test  --------------------------");
        MockLogAppender.setupLogging();
        this.m_network = new MockNetwork();
        this.m_network.setCriticalService("ICMP");
        this.m_network.addNode(1, "Router");
        this.m_network.addInterface(InetAddressUtils.str((InetAddress)InetAddressUtils.UNPINGABLE_ADDRESS));
        this.m_network.addService("ICMP");
        this.m_network.addService("HTTP");
        this.m_db.populate(this.m_network);
        DataSourceFactory.setInstance((DataSource)this.m_db);
        OnmsMonitoringLocation location = new OnmsMonitoringLocation(NONEXISTENT_LOCATION, "Nullsville");
        this.m_monitoringLocationDao.save((Object)location);
        for (OnmsNode node : this.m_nodeDao.findAll()) {
            node.setLocation(location);
            this.m_nodeDao.save((Object)node);
        }
        FileInputStream is = new FileInputStream(new File("src/test/resources/etc/rpctimeout-poller-configuration.xml"));
        PollerConfigFactory factory = new PollerConfigFactory(0L, (InputStream)is, "localhost", false);
        PollerConfigFactory.setInstance((PollerConfig)factory);
        IOUtils.closeQuietly((InputStream)is);
        ServiceMonitor monitor = PollerConfigFactory.getInstance().getServiceMonitor("HTTP");
        Assert.assertNotNull((Object)monitor);
        Package pkg = PollerConfigFactory.getInstance().getPackage("PollerRpcTimeoutIT");
        Assert.assertNotNull((Object)pkg);
        Service svc = (Service)pkg.getServices().iterator().next();
        Assert.assertEquals((Object)"HTTP", (Object)svc.getName());
        DefaultPollContext pollContext = new DefaultPollContext();
        pollContext.setEventManager((EventIpcManager)this.m_eventMgr);
        pollContext.setLocalHostName("localhost");
        pollContext.setName("Test.DefaultPollContext");
        pollContext.setPollerConfig((PollerConfig)factory);
        pollContext.setQueryManager(this.m_queryManager);
        pollContext.setLocationAwarePingClient(this.m_locationAwarePingClient);
        PollableNetwork network = new PollableNetwork((PollContext)pollContext);
        this.m_poller = new Poller();
        this.m_poller.setMonitoredServiceDao(this.m_monitoredServiceDao);
        this.m_poller.setOutageDao(this.m_outageDao);
        this.m_poller.setTransactionTemplate(this.m_transactionTemplate);
        this.m_poller.setEventIpcManager((EventIpcManager)this.m_eventMgr);
        this.m_poller.setNetwork(network);
        this.m_poller.setQueryManager(this.m_queryManager);
        this.m_poller.setPollerConfig((PollerConfig)factory);
        this.m_poller.setPollOutagesConfig(this.m_pollOutagesConfig);
        this.m_poller.setLocationAwarePollerClient(this.m_locationAwarePollerClient);
    }

    @After
    public void tearDown() throws Exception {
        this.m_eventMgr.finishProcessingEvents();
        MockUtil.println((String)"------------ End Test  --------------------------");
    }

    @Test
    public void testPolling() throws Exception {
        String queueName = new JmsQueueNameFactory("RPC", "Poller", NONEXISTENT_LOCATION).getName();
        try {
            ManagementFactory.getPlatformMBeanServer().getObjectInstance(ObjectName.getInstance("org.apache.activemq:type=Broker,brokerName=localhost,destinationType=Queue,destinationName=ActiveMQ.DLQ"));
            Assert.fail((String)"DLQ was unexpected found in the PlatformMBeanServer");
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            // empty catch block
        }
        try {
            ManagementFactory.getPlatformMBeanServer().getObjectInstance(ObjectName.getInstance("org.apache.activemq:type=Broker,brokerName=localhost,destinationType=Queue,destinationName=" + queueName));
            Assert.fail((String)(queueName + " queue was unexpected found in the PlatformMBeanServer"));
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            // empty catch block
        }
        this.startDaemons();
        Thread.sleep(60000L);
        this.stopDaemons();
        try {
            ManagementFactory.getPlatformMBeanServer().getObjectInstance(ObjectName.getInstance("org.apache.activemq:type=Broker,brokerName=localhost,destinationType=Queue,destinationName=ActiveMQ.DLQ"));
            Assert.fail((String)"DLQ was unexpected found in the PlatformMBeanServer");
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            // empty catch block
        }
        Long dequeueCount = (Long)ManagementFactory.getPlatformMBeanServer().getAttribute(ObjectName.getInstance("org.apache.activemq:type=Broker,brokerName=localhost,destinationType=Queue,destinationName=" + queueName), "DequeueCount");
        Long expiredCount = (Long)ManagementFactory.getPlatformMBeanServer().getAttribute(ObjectName.getInstance("org.apache.activemq:type=Broker,brokerName=localhost,destinationType=Queue,destinationName=" + queueName), "ExpiredCount");
        Long dispatchCount = (Long)ManagementFactory.getPlatformMBeanServer().getAttribute(ObjectName.getInstance("org.apache.activemq:type=Broker,brokerName=localhost,destinationType=Queue,destinationName=" + queueName), "DispatchCount");
        Assert.assertTrue((String)"No expired messages were present", (expiredCount > 0L ? 1 : 0) != 0);
        Assert.assertEquals((String)"Dequeued messages do not equal expired messages", (Object)expiredCount, (Object)dequeueCount);
        Assert.assertEquals((String)"Dispatched message count was not zero", (long)0L, (long)dispatchCount.intValue());
    }
}

