/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.mock;

import java.net.InetAddress;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.opennms.core.utils.DBUtils;
import org.opennms.core.utils.InetAddressUtils;

public final class DbIpInterfaceEntry {
    private static final char SNMP_UNKNOWN = ' ';
    private static final char STATE_UNKNOWN = ' ';
    private static final String SQL_LOAD_REC = "SELECT ifIndex, ipHostname, isManaged, ipStatus, ipLastCapsdPoll, isSnmpPrimary FROM ipInterface WHERE nodeID = ? AND ipAddr = ? AND isManaged != 'D'";
    private static final String SQL_LOAD_REC_IFINDEX = "SELECT ifIndex, ipHostname, isManaged, ipStatus, ipLastCapsdPoll, isSnmpPrimary FROM ipInterface WHERE nodeID = ? AND ipAddr = ? AND ifIndex = ? AND isManaged != 'D'";
    private boolean m_fromDb;
    private long m_nodeId;
    private InetAddress m_ipAddr;
    private int m_ifIndex;
    private String m_hostname;
    private int m_status;
    private char m_managedState;
    private Timestamp m_lastPoll;
    private char m_primaryState;
    private int m_changed;
    private boolean m_useIfIndexAsKey;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean load(Connection c) throws SQLException {
        if (!this.m_fromDb) {
            throw new IllegalStateException("The record does not exists in the database");
        }
        PreparedStatement stmt = null;
        ResultSet rset = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            String str;
            if (this.m_useIfIndexAsKey) {
                stmt = c.prepareStatement(SQL_LOAD_REC_IFINDEX);
                d.watch((Object)stmt);
                stmt.setLong(1, this.m_nodeId);
                stmt.setString(2, InetAddressUtils.str((InetAddress)this.m_ipAddr));
                stmt.setInt(3, this.m_ifIndex);
            } else {
                stmt = c.prepareStatement(SQL_LOAD_REC);
                d.watch((Object)stmt);
                stmt.setLong(1, this.m_nodeId);
                stmt.setString(2, InetAddressUtils.str((InetAddress)this.m_ipAddr));
            }
            rset = stmt.executeQuery();
            d.watch((Object)rset);
            if (!rset.next()) {
                boolean bl = false;
                return bl;
            }
            int ndx = 1;
            this.m_ifIndex = rset.getInt(ndx++);
            if (rset.wasNull()) {
                this.m_ifIndex = -1;
            }
            this.m_hostname = rset.getString(ndx++);
            if (rset.wasNull()) {
                this.m_hostname = null;
            }
            this.m_managedState = (str = rset.getString(ndx++)) != null && !rset.wasNull() ? str.charAt(0) : (char)32;
            this.m_status = rset.getInt(ndx++);
            if (rset.wasNull()) {
                this.m_status = -1;
            }
            this.m_lastPoll = rset.getTimestamp(ndx++);
            this.m_primaryState = (str = rset.getString(ndx++)) != null && !rset.wasNull() ? str.charAt(0) : (char)32;
        }
        finally {
            d.cleanUp();
        }
        this.m_changed = 0;
        return true;
    }

    private DbIpInterfaceEntry(long nid, InetAddress address, boolean exists) {
        this.m_fromDb = exists;
        this.m_nodeId = nid;
        this.m_ipAddr = address;
        this.m_ifIndex = -1;
        this.m_managedState = (char)32;
        this.m_status = -1;
        this.m_lastPoll = null;
        this.m_primaryState = (char)32;
        this.m_changed = 0;
        this.m_useIfIndexAsKey = false;
    }

    private DbIpInterfaceEntry(long nid, InetAddress address, int ifIndex, boolean exists) {
        this.m_fromDb = exists;
        this.m_nodeId = nid;
        this.m_ipAddr = address;
        this.m_ifIndex = ifIndex;
        this.m_status = -1;
        this.m_lastPoll = null;
        this.m_managedState = (char)32;
        this.m_primaryState = (char)32;
        this.m_changed = 0;
        this.m_useIfIndexAsKey = true;
    }

    public int getIfIndex() {
        return this.m_ifIndex;
    }

    public static DbIpInterfaceEntry get(Connection db, long nid, InetAddress addr) throws SQLException {
        DbIpInterfaceEntry entry = new DbIpInterfaceEntry(nid, addr, true);
        if (!entry.load(db)) {
            entry = null;
        }
        return entry;
    }

    public static DbIpInterfaceEntry get(Connection db, long nid, InetAddress addr, int ifIndex) throws SQLException {
        DbIpInterfaceEntry entry = new DbIpInterfaceEntry(nid, addr, ifIndex, true);
        if (!entry.load(db)) {
            entry = null;
        }
        return entry;
    }

    public String toString() {
        String sep = System.getProperty("line.separator");
        StringBuilder buf = new StringBuilder();
        buf.append("from database      = ").append(this.m_fromDb).append(sep);
        buf.append("node identifier    = ").append(this.m_nodeId).append(sep);
        buf.append("IP Address         = ").append(InetAddressUtils.str((InetAddress)this.m_ipAddr)).append(sep);
        buf.append("interface index    = ").append(this.m_ifIndex).append(sep);
        buf.append("last poll time     = ").append(this.m_lastPoll).append(sep);
        buf.append("hostname           = ").append(this.m_hostname).append(sep);
        buf.append("status             = ").append(this.m_status).append(sep);
        buf.append("isManaged          = ").append(this.m_managedState).append(sep);
        buf.append("isSnmpPrimary      = ").append(this.m_primaryState).append(sep);
        buf.append("field change map   = 0x").append(Integer.toHexString(this.m_changed)).append(sep);
        return buf.toString();
    }
}

