/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.enlinkd.EnLinkdBuilderITCase;
import org.opennms.netmgt.enlinkd.EnLinkdTestHelper;
import org.opennms.netmgt.enlinkd.Node;
import org.opennms.netmgt.model.BridgeBridgeLink;
import org.opennms.netmgt.model.BridgeElement;
import org.opennms.netmgt.model.BridgeMacLink;
import org.opennms.netmgt.model.NetworkBuilder;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.monitoringLocations.OnmsMonitoringLocation;
import org.opennms.netmgt.model.topology.BroadcastDomain;
import org.opennms.netmgt.model.topology.SharedSegment;
import org.opennms.netmgt.nb.Nms10205bNetworkBuilder;
import org.opennms.netmgt.nb.Nms17216NetworkBuilder;

public class EnLinkdIT
extends EnLinkdBuilderITCase {
    Nms10205bNetworkBuilder builder10205a = new Nms10205bNetworkBuilder();
    Nms17216NetworkBuilder builder = new Nms17216NetworkBuilder();

    @Test
    public void testGetSnmpNodeList() throws Exception {
        this.m_nodeDao.save((Object)this.builder10205a.getMumbai());
        this.m_nodeDao.save((Object)this.builder10205a.getDelhi());
        this.m_nodeDao.save((Object)this.builder.getSwitch1());
        this.m_nodeDao.flush();
        int mumbai = this.m_nodeDao.findByForeignId("linkd", "Mumbai").getId();
        int delhi = this.m_nodeDao.findByForeignId("linkd", "Delhi").getId();
        int switch1 = this.m_nodeDao.findByForeignId("linkd", "Switch1").getId();
        List linkablenodes = this.m_linkd.getQueryManager().getSnmpNodeList();
        Assert.assertNotNull((Object)linkablenodes);
        Assert.assertEquals((long)3L, (long)linkablenodes.size());
        for (Node linkablenode : linkablenodes) {
            if (linkablenode.getNodeId() == mumbai) {
                Assert.assertEquals((Object)InetAddressUtils.addr((String)"10.205.56.5"), (Object)linkablenode.getSnmpPrimaryIpAddr());
                Assert.assertEquals((Object)".1.3.6.1.4.1.2636.1.1.1.2.9", (Object)linkablenode.getSysoid());
                continue;
            }
            if (linkablenode.getNodeId() == delhi) {
                Assert.assertEquals((Object)InetAddressUtils.addr((String)"10.205.56.7"), (Object)linkablenode.getSnmpPrimaryIpAddr());
                Assert.assertEquals((Object)".1.3.6.1.4.1.2636.1.1.1.2.29", (Object)linkablenode.getSysoid());
                continue;
            }
            if (linkablenode.getNodeId() == switch1) {
                Assert.assertEquals((Object)InetAddressUtils.addr((String)"172.16.10.1"), (Object)linkablenode.getSnmpPrimaryIpAddr());
                Assert.assertEquals((Object)".1.3.6.1.4.1.9.1.614", (Object)linkablenode.getSysoid());
                continue;
            }
            Assert.assertTrue((boolean)false);
        }
        Node delhilinkablenode = this.m_linkd.getQueryManager().getSnmpNode(delhi);
        Assert.assertNotNull((Object)delhilinkablenode);
        Assert.assertEquals((long)delhi, (long)delhilinkablenode.getNodeId());
        Assert.assertEquals((Object)InetAddressUtils.addr((String)"10.205.56.7"), (Object)delhilinkablenode.getSnmpPrimaryIpAddr());
        Assert.assertEquals((Object)".1.3.6.1.4.1.2636.1.1.1.2.29", (Object)delhilinkablenode.getSysoid());
    }

    @Test
    public void testStoreBft() {
        EnLinkdTestHelper.OneBridgeCompleteTopology topology = new EnLinkdTestHelper.OneBridgeCompleteTopology(this);
        this.m_nodeDao.save((Object)topology.nodeA);
        this.m_linkd.getQueryManager().store(topology.nodeAId.intValue(), topology.bftA);
        List links = this.m_linkd.getQueryManager().useBridgeTopologyUpdateBFT(topology.nodeAId.intValue());
        Assert.assertEquals((long)topology.bftA.size(), (long)links.size());
        for (BridgeMacLink link : links) {
            Assert.assertEquals((Object)BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED, (Object)link.getBridgeDot1qTpFdbStatus());
            System.err.println(link.printTopology());
        }
    }

    @Test
    public void testLoadFourLevelTopology() {
        OnmsMonitoringLocation location = new OnmsMonitoringLocation("Default", "Default");
        OnmsNode lnode1400 = new OnmsNode();
        lnode1400.setId(Integer.valueOf(1400));
        lnode1400.setForeignSource("linkd");
        lnode1400.setForeignId("lnode1400");
        lnode1400.setLabel("lnode1400");
        lnode1400.setLocation(location);
        OnmsNode lnode1544 = new OnmsNode();
        lnode1544.setId(Integer.valueOf(1544));
        lnode1544.setForeignSource("linkd");
        lnode1544.setForeignId("lnode1544");
        lnode1544.setLabel("lnode1544");
        lnode1544.setLocation(location);
        OnmsNode lnode1534 = new OnmsNode();
        lnode1534.setId(Integer.valueOf(1534));
        lnode1534.setForeignSource("linkd");
        lnode1534.setForeignId("lnode1534");
        lnode1534.setLabel("lnode1534");
        lnode1534.setLocation(location);
        OnmsNode lnode1364 = new OnmsNode();
        lnode1364.setId(Integer.valueOf(1364));
        lnode1364.setForeignSource("linkd");
        lnode1364.setForeignId("lnode1364");
        lnode1364.setLabel("lnode1364");
        lnode1364.setLocation(location);
        OnmsNode lnode1310 = new OnmsNode();
        lnode1310.setId(Integer.valueOf(1310));
        lnode1310.setForeignSource("linkd");
        lnode1310.setForeignId("lnode1310");
        lnode1310.setLabel("lnode1310");
        lnode1310.setLocation(location);
        OnmsNode lnode405 = new OnmsNode();
        lnode405.setId(Integer.valueOf(405));
        lnode405.setForeignSource("linkd");
        lnode405.setForeignId("lnode405");
        lnode405.setLabel("lnode405");
        lnode405.setLocation(location);
        OnmsNode lnode2965 = new OnmsNode();
        lnode2965.setId(Integer.valueOf(2965));
        lnode2965.setForeignSource("linkd");
        lnode2965.setForeignId("lnode2965");
        lnode2965.setLabel("lnode2965");
        lnode2965.setLocation(location);
        OnmsNode lnode5022 = new OnmsNode();
        lnode5022.setId(Integer.valueOf(5022));
        lnode5022.setForeignSource("linkd");
        lnode5022.setForeignId("lnode5022");
        lnode5022.setLabel("lnode5022");
        lnode5022.setLocation(location);
        this.m_nodeDao.save((Object)lnode1400);
        this.m_nodeDao.save((Object)lnode1544);
        this.m_nodeDao.save((Object)lnode1534);
        this.m_nodeDao.save((Object)lnode1364);
        this.m_nodeDao.save((Object)lnode1310);
        this.m_nodeDao.save((Object)lnode405);
        this.m_nodeDao.save((Object)lnode2965);
        this.m_nodeDao.save((Object)lnode5022);
        OnmsNode node1400 = this.m_nodeDao.findByForeignId("linkd", "lnode1400");
        OnmsNode node1544 = this.m_nodeDao.findByForeignId("linkd", "lnode1544");
        OnmsNode node1534 = this.m_nodeDao.findByForeignId("linkd", "lnode1534");
        OnmsNode node1364 = this.m_nodeDao.findByForeignId("linkd", "lnode1364");
        OnmsNode node1310 = this.m_nodeDao.findByForeignId("linkd", "lnode1310");
        OnmsNode node405 = this.m_nodeDao.findByForeignId("linkd", "lnode405");
        OnmsNode node2965 = this.m_nodeDao.findByForeignId("linkd", "lnode2965");
        OnmsNode node5022 = this.m_nodeDao.findByForeignId("linkd", "lnode5022");
        BridgeBridgeLink link7 = new BridgeBridgeLink();
        link7.setNode(node5022);
        link7.setBridgePort(Integer.valueOf(4));
        link7.setDesignatedNode(node2965);
        link7.setDesignatedPort(Integer.valueOf(5));
        link7.setBridgeBridgeLinkLastPollTime(link7.getBridgeBridgeLinkCreateTime());
        this.m_bridgeBridgeLinkDao.save((Object)link7);
        this.m_bridgeBridgeLinkDao.flush();
        BridgeBridgeLink link1 = new BridgeBridgeLink();
        link1.setNode(node1544);
        link1.setBridgePort(Integer.valueOf(15));
        link1.setDesignatedNode(node1400);
        link1.setDesignatedPort(Integer.valueOf(1));
        link1.setBridgeBridgeLinkLastPollTime(link1.getBridgeBridgeLinkCreateTime());
        this.m_bridgeBridgeLinkDao.save((Object)link1);
        this.m_bridgeBridgeLinkDao.flush();
        BridgeBridgeLink link3 = new BridgeBridgeLink();
        link3.setNode(node1310);
        link3.setBridgePort(Integer.valueOf(1));
        link3.setDesignatedNode(node1534);
        link3.setDesignatedPort(Integer.valueOf(1));
        link3.setBridgeBridgeLinkLastPollTime(link3.getBridgeBridgeLinkCreateTime());
        this.m_bridgeBridgeLinkDao.save((Object)link3);
        this.m_bridgeBridgeLinkDao.flush();
        BridgeBridgeLink link4 = new BridgeBridgeLink();
        link4.setNode(node1364);
        link4.setBridgePort(Integer.valueOf(24));
        link4.setDesignatedNode(node1534);
        link4.setDesignatedPort(Integer.valueOf(4));
        link4.setBridgeBridgeLinkLastPollTime(link4.getBridgeBridgeLinkCreateTime());
        this.m_bridgeBridgeLinkDao.save((Object)link4);
        this.m_bridgeBridgeLinkDao.flush();
        BridgeBridgeLink link2 = new BridgeBridgeLink();
        link2.setNode(node1534);
        link2.setBridgePort(Integer.valueOf(11));
        link2.setDesignatedNode(node1400);
        link2.setDesignatedPort(Integer.valueOf(11));
        link2.setBridgeBridgeLinkLastPollTime(link2.getBridgeBridgeLinkCreateTime());
        this.m_bridgeBridgeLinkDao.save((Object)link2);
        this.m_bridgeBridgeLinkDao.flush();
        BridgeBridgeLink link6 = new BridgeBridgeLink();
        link6.setNode(node2965);
        link6.setBridgePort(Integer.valueOf(2));
        link6.setDesignatedNode(node1364);
        link6.setDesignatedPort(Integer.valueOf(5));
        link6.setBridgeBridgeLinkLastPollTime(link6.getBridgeBridgeLinkCreateTime());
        this.m_bridgeBridgeLinkDao.save((Object)link6);
        this.m_bridgeBridgeLinkDao.flush();
        BridgeBridgeLink link5 = new BridgeBridgeLink();
        link5.setNode(node405);
        link5.setBridgePort(Integer.valueOf(1));
        link5.setDesignatedNode(node1534);
        link5.setDesignatedPort(Integer.valueOf(1));
        link5.setBridgeBridgeLinkLastPollTime(link5.getBridgeBridgeLinkCreateTime());
        this.m_bridgeBridgeLinkDao.save((Object)link5);
        this.m_bridgeBridgeLinkDao.flush();
        Assert.assertEquals((long)0L, (long)this.m_bridgeMacLinkDao.countAll());
        Assert.assertEquals((long)7L, (long)this.m_bridgeBridgeLinkDao.countAll());
        Assert.assertNotNull((Object)this.m_bridgeTopologyDao);
        this.m_linkd.getQueryManager().loadBridgeTopology();
        Assert.assertEquals((long)1L, (long)this.m_bridgeTopologyDao.getAll().size());
        BroadcastDomain fourlevelDomain = (BroadcastDomain)this.m_bridgeTopologyDao.getAll().iterator().next();
        Assert.assertEquals((long)8L, (long)fourlevelDomain.getBridgeNodesOnDomain().size());
        System.err.println(fourlevelDomain.printTopology());
    }

    @Test
    public void testLoadTopology() {
        OnmsMonitoringLocation location = new OnmsMonitoringLocation("Default", "Default");
        EnLinkdTestHelper.ABCTopology topology = new EnLinkdTestHelper.ABCTopology(this);
        OnmsNode lnodeA = topology.nodeA;
        lnodeA.setForeignSource("linkd");
        lnodeA.setForeignId("nodeA");
        lnodeA.setLabel("nodeA");
        lnodeA.setLocation(location);
        OnmsNode lnodeB = topology.nodeB;
        lnodeB.setForeignSource("linkd");
        lnodeB.setForeignId("nodeB");
        lnodeB.setLabel("nodeB");
        lnodeB.setLocation(location);
        OnmsNode lnodeC = topology.nodeC;
        lnodeC.setForeignSource("linkd");
        lnodeC.setForeignId("nodeC");
        lnodeC.setLabel("nodeC");
        lnodeC.setLocation(location);
        BridgeElement elementD = new BridgeElement();
        BridgeElement elementE = new BridgeElement();
        BridgeElement elementK = new BridgeElement();
        OnmsNode lnodeD = new OnmsNode();
        lnodeD.setId(Integer.valueOf(topology.nodeAId + 1234));
        lnodeD.setForeignSource("linkd");
        lnodeD.setForeignId("nodeD");
        lnodeD.setLabel("nodeD");
        lnodeD.setLocation(location);
        elementD.setNode(lnodeD);
        elementD.setBaseBridgeAddress("dddddddddddd");
        OnmsNode lnodeE = new OnmsNode();
        lnodeE.setId(Integer.valueOf(topology.nodeBId + 1234));
        lnodeE.setForeignSource("linkd");
        lnodeE.setForeignId("nodeE");
        lnodeE.setLabel("nodeE");
        lnodeE.setLocation(location);
        elementE.setNode(lnodeE);
        elementE.setBaseBridgeAddress("eeeeeeeeeeee");
        OnmsNode lnodeK = new OnmsNode();
        lnodeK.setId(Integer.valueOf(topology.nodeCId + 12345));
        lnodeK.setForeignSource("linkd");
        lnodeK.setForeignId("nodeK");
        lnodeK.setLabel("nodeK");
        lnodeK.setLocation(location);
        elementK.setNode(lnodeK);
        elementK.setBaseBridgeAddress("aaaabbbbcccc");
        this.m_nodeDao.save((Object)lnodeA);
        this.m_nodeDao.save((Object)lnodeB);
        this.m_nodeDao.save((Object)lnodeC);
        this.m_nodeDao.save((Object)lnodeD);
        this.m_nodeDao.save((Object)lnodeE);
        this.m_nodeDao.save((Object)lnodeK);
        OnmsNode nodeA = this.m_nodeDao.findByForeignId("linkd", "nodeA");
        OnmsNode nodeB = this.m_nodeDao.findByForeignId("linkd", "nodeB");
        OnmsNode nodeC = this.m_nodeDao.findByForeignId("linkd", "nodeC");
        OnmsNode nodeD = this.m_nodeDao.findByForeignId("linkd", "nodeD");
        OnmsNode nodeE = this.m_nodeDao.findByForeignId("linkd", "nodeE");
        OnmsNode nodeK = this.m_nodeDao.findByForeignId("linkd", "nodeK");
        topology.nodeAId = nodeA.getId();
        topology.nodeBId = nodeB.getId();
        topology.nodeCId = nodeC.getId();
        topology.nodeA = nodeA;
        topology.nodeB = nodeB;
        topology.nodeC = nodeC;
        BridgeBridgeLink delink = new BridgeBridgeLink();
        delink.setNode(nodeD);
        delink.setBridgePort(Integer.valueOf(45));
        delink.setDesignatedNode(nodeE);
        delink.setDesignatedPort(Integer.valueOf(54));
        delink.setBridgeBridgeLinkLastPollTime(delink.getBridgeBridgeLinkCreateTime());
        this.m_bridgeBridgeLinkDao.save((Object)delink);
        BridgeBridgeLink ablink = new BridgeBridgeLink();
        ablink.setNode(nodeA);
        ablink.setBridgePort(topology.portAB);
        ablink.setDesignatedNode(nodeB);
        ablink.setDesignatedPort(topology.portBA);
        ablink.setBridgeBridgeLinkLastPollTime(ablink.getBridgeBridgeLinkCreateTime());
        this.m_bridgeBridgeLinkDao.save((Object)ablink);
        BridgeBridgeLink bclink = new BridgeBridgeLink();
        bclink.setNode(nodeC);
        bclink.setBridgePort(topology.portCB);
        bclink.setDesignatedNode(nodeB);
        bclink.setDesignatedPort(topology.portBC);
        bclink.setBridgeBridgeLinkLastPollTime(ablink.getBridgeBridgeLinkCreateTime());
        this.m_bridgeBridgeLinkDao.save((Object)bclink);
        BridgeMacLink forward = new BridgeMacLink();
        forward.setNode(nodeB);
        forward.setBridgePort(topology.portBA);
        forward.setMacAddress(topology.macA);
        forward.setBridgeMacLinkLastPollTime(forward.getBridgeMacLinkCreateTime());
        this.m_bridgeMacLinkDao.save((Object)forward);
        BridgeMacLink sharedB = new BridgeMacLink();
        sharedB.setNode(nodeB);
        sharedB.setBridgePort(topology.portBC);
        sharedB.setMacAddress(topology.shar);
        sharedB.setBridgeMacLinkLastPollTime(sharedB.getBridgeMacLinkCreateTime());
        this.m_bridgeMacLinkDao.save((Object)sharedB);
        BridgeMacLink sharedC = new BridgeMacLink();
        sharedC.setNode(nodeC);
        sharedC.setBridgePort(topology.portCB);
        sharedC.setMacAddress(topology.shar);
        sharedC.setBridgeMacLinkLastPollTime(sharedC.getBridgeMacLinkCreateTime());
        this.m_bridgeMacLinkDao.save((Object)sharedC);
        BridgeMacLink mac1 = new BridgeMacLink();
        mac1.setNode(nodeA);
        mac1.setBridgePort(topology.portA);
        mac1.setMacAddress(topology.mac1);
        mac1.setBridgeMacLinkLastPollTime(mac1.getBridgeMacLinkCreateTime());
        this.m_bridgeMacLinkDao.save((Object)mac1);
        BridgeMacLink mac2 = new BridgeMacLink();
        mac2.setNode(nodeB);
        mac2.setBridgePort(topology.portB);
        mac2.setMacAddress(topology.mac2);
        mac2.setBridgeMacLinkLastPollTime(mac2.getBridgeMacLinkCreateTime());
        this.m_bridgeMacLinkDao.save((Object)mac2);
        BridgeMacLink mac3 = new BridgeMacLink();
        mac3.setNode(nodeC);
        mac3.setBridgePort(topology.portC);
        mac3.setMacAddress(topology.mac3);
        mac3.setBridgeMacLinkLastPollTime(mac3.getBridgeMacLinkCreateTime());
        this.m_bridgeMacLinkDao.save((Object)mac3);
        BridgeMacLink sharedD = new BridgeMacLink();
        sharedD.setNode(nodeD);
        sharedD.setBridgePort(Integer.valueOf(45));
        sharedD.setMacAddress(topology.shar);
        sharedD.setBridgeMacLinkLastPollTime(sharedD.getBridgeMacLinkCreateTime());
        this.m_bridgeMacLinkDao.save((Object)sharedD);
        BridgeMacLink sharedE = new BridgeMacLink();
        sharedE.setNode(nodeE);
        sharedE.setBridgePort(Integer.valueOf(54));
        sharedE.setMacAddress(topology.shar);
        sharedE.setBridgeMacLinkLastPollTime(sharedE.getBridgeMacLinkCreateTime());
        this.m_bridgeMacLinkDao.save((Object)sharedE);
        BridgeMacLink sharedK = new BridgeMacLink();
        sharedK.setNode(nodeK);
        sharedK.setBridgePort(Integer.valueOf(1099));
        sharedK.setMacAddress(topology.shar);
        sharedK.setBridgeMacLinkLastPollTime(sharedK.getBridgeMacLinkCreateTime());
        this.m_bridgeMacLinkDao.save((Object)sharedK);
        BridgeMacLink macK = new BridgeMacLink();
        macK.setNode(nodeK);
        macK.setBridgePort(Integer.valueOf(1099));
        macK.setMacAddress("1234567800aa");
        macK.setBridgeMacLinkLastPollTime(macK.getBridgeMacLinkCreateTime());
        this.m_bridgeMacLinkDao.save((Object)macK);
        this.m_bridgeMacLinkDao.flush();
        this.m_bridgeBridgeLinkDao.flush();
        Assert.assertEquals((long)10L, (long)this.m_bridgeMacLinkDao.countAll());
        Assert.assertEquals((long)3L, (long)this.m_bridgeBridgeLinkDao.countAll());
        Assert.assertNotNull((Object)this.m_bridgeTopologyDao);
        this.m_linkd.getQueryManager().loadBridgeTopology();
        Assert.assertEquals((long)3L, (long)this.m_bridgeTopologyDao.getAll().size());
        BroadcastDomain nodeAbd = this.m_linkd.getQueryManager().getBroadcastDomain(nodeA.getId().intValue());
        Assert.assertNotNull((Object)nodeAbd);
        BroadcastDomain nodeBbd = this.m_linkd.getQueryManager().getBroadcastDomain(nodeB.getId().intValue());
        BroadcastDomain nodeCbd = this.m_linkd.getQueryManager().getBroadcastDomain(nodeC.getId().intValue());
        Assert.assertEquals((Object)nodeAbd, (Object)nodeBbd);
        Assert.assertEquals((Object)nodeAbd, (Object)nodeCbd);
        nodeAbd.hierarchySetUp(nodeAbd.getBridge(nodeA.getId().intValue()));
        topology.checkwithshared(nodeAbd);
        Assert.assertEquals((long)0L, (long)nodeAbd.getForwarders(topology.nodeAId).size());
        Assert.assertEquals((long)1L, (long)nodeAbd.getForwarders(topology.nodeBId).size());
        Assert.assertEquals((long)0L, (long)nodeAbd.getForwarders(topology.nodeCId).size());
        List nodeASegments = this.m_bridgeTopologyDao.getBridgeNodeSharedSegments(this.m_bridgeBridgeLinkDao, this.m_bridgeMacLinkDao, nodeA.getId().intValue());
        Assert.assertEquals((long)2L, (long)nodeASegments.size());
        System.err.println(nodeAbd.printTopology());
        BroadcastDomain nodeDbd = this.m_linkd.getQueryManager().getBroadcastDomain(nodeD.getId().intValue());
        Assert.assertNotNull((Object)nodeDbd);
        BroadcastDomain nodeEbd = this.m_linkd.getQueryManager().getBroadcastDomain(nodeE.getId().intValue());
        Assert.assertEquals((Object)nodeDbd, (Object)nodeEbd);
        Assert.assertEquals((long)2L, (long)nodeDbd.getBridges().size());
        Assert.assertEquals((long)1L, (long)nodeDbd.getTopology().size());
        Assert.assertTrue((boolean)nodeDbd.containBridgeId(nodeD.getId().intValue()));
        Assert.assertTrue((boolean)nodeDbd.containBridgeId(nodeE.getId().intValue()));
        SharedSegment deSegment = (SharedSegment)nodeDbd.getTopology().iterator().next();
        Assert.assertEquals((long)2L, (long)deSegment.getBridgePortsOnSegment().size());
        Assert.assertEquals((long)1L, (long)deSegment.getMacsOnSegment().size());
        Assert.assertEquals((long)45L, (long)deSegment.getPortForBridge(nodeD.getId()).intValue());
        Assert.assertEquals((long)54L, (long)deSegment.getPortForBridge(nodeE.getId()).intValue());
        Assert.assertTrue((boolean)deSegment.containsMac(topology.shar));
        System.err.println(nodeDbd.printTopology());
        BroadcastDomain nodeKbd = this.m_linkd.getQueryManager().getBroadcastDomain(nodeK.getId().intValue());
        Assert.assertNotNull((Object)nodeKbd);
        Assert.assertEquals((long)1L, (long)nodeKbd.getBridges().size());
        Assert.assertEquals((long)1L, (long)nodeKbd.getTopology().size());
        Assert.assertTrue((boolean)nodeKbd.containBridgeId(nodeK.getId().intValue()));
        SharedSegment kSegment = (SharedSegment)nodeKbd.getTopology().iterator().next();
        Assert.assertEquals((long)1L, (long)kSegment.getBridgePortsOnSegment().size());
        Assert.assertEquals((long)2L, (long)kSegment.getMacsOnSegment().size());
        Assert.assertEquals((long)1099L, (long)kSegment.getPortForBridge(nodeK.getId()).intValue());
        Assert.assertTrue((boolean)kSegment.containsMac(topology.shar));
        Assert.assertTrue((boolean)kSegment.containsMac("1234567800aa"));
        System.err.println(nodeKbd.printTopology());
    }

    @Test
    public void testDeleteBridgeC() {
        EnLinkdTestHelper.ABCTopology topology = new EnLinkdTestHelper.ABCTopology(this);
        NetworkBuilder nb = new NetworkBuilder();
        nb.addNode("nodeA").setForeignSource("linkd").setForeignId("nodeA").setSysObjectId("0.0").setSysName("nodeA").setType(OnmsNode.NodeType.ACTIVE);
        nb.addInterface("10.0.1.1").setIsSnmpPrimary("P").setIsManaged("M");
        this.m_nodeDao.save((Object)nb.getCurrentNode());
        nb.addNode("nodeB").setForeignSource("linkd").setForeignId("nodeB").setSysObjectId("0.0").setSysName("nodeB").setType(OnmsNode.NodeType.ACTIVE);
        nb.addInterface("10.0.1.2").setIsSnmpPrimary("P").setIsManaged("M");
        this.m_nodeDao.save((Object)nb.getCurrentNode());
        nb.addNode("nodeC").setForeignSource("linkd").setForeignId("nodeC").setSysObjectId("0.0").setSysName("nodeC").setType(OnmsNode.NodeType.ACTIVE);
        nb.addInterface("10.0.1.3").setIsSnmpPrimary("P").setIsManaged("M");
        this.m_nodeDao.save((Object)nb.getCurrentNode());
        OnmsNode nodeA = this.m_nodeDao.findByForeignId("linkd", "nodeA");
        OnmsNode nodeB = this.m_nodeDao.findByForeignId("linkd", "nodeB");
        OnmsNode nodeC = this.m_nodeDao.findByForeignId("linkd", "nodeC");
        topology.nodeAId = nodeA.getId();
        topology.nodeBId = nodeB.getId();
        topology.nodeCId = nodeC.getId();
        topology.nodeA = nodeA;
        topology.nodeB = nodeB;
        topology.nodeC = nodeC;
        BridgeBridgeLink ablink = new BridgeBridgeLink();
        ablink.setNode(nodeA);
        ablink.setBridgePort(topology.portAB);
        ablink.setDesignatedNode(nodeB);
        ablink.setDesignatedPort(topology.portBA);
        ablink.setBridgeBridgeLinkLastPollTime(ablink.getBridgeBridgeLinkCreateTime());
        this.m_bridgeBridgeLinkDao.save((Object)ablink);
        BridgeBridgeLink bclink = new BridgeBridgeLink();
        bclink.setNode(nodeC);
        bclink.setBridgePort(topology.portCB);
        bclink.setDesignatedNode(nodeB);
        bclink.setDesignatedPort(topology.portBC);
        bclink.setBridgeBridgeLinkLastPollTime(ablink.getBridgeBridgeLinkCreateTime());
        this.m_bridgeBridgeLinkDao.save((Object)bclink);
        BridgeMacLink mac1 = new BridgeMacLink();
        mac1.setNode(nodeA);
        mac1.setBridgePort(topology.portA);
        mac1.setMacAddress(topology.mac1);
        mac1.setBridgeMacLinkLastPollTime(mac1.getBridgeMacLinkCreateTime());
        this.m_bridgeMacLinkDao.save((Object)mac1);
        BridgeMacLink mac2 = new BridgeMacLink();
        mac2.setNode(nodeB);
        mac2.setBridgePort(topology.portB);
        mac2.setMacAddress(topology.mac2);
        mac2.setBridgeMacLinkLastPollTime(mac2.getBridgeMacLinkCreateTime());
        this.m_bridgeMacLinkDao.save((Object)mac2);
        BridgeMacLink mac3 = new BridgeMacLink();
        mac3.setNode(nodeC);
        mac3.setBridgePort(topology.portC);
        mac3.setMacAddress(topology.mac3);
        mac3.setBridgeMacLinkLastPollTime(mac3.getBridgeMacLinkCreateTime());
        this.m_bridgeMacLinkDao.save((Object)mac3);
        this.m_bridgeMacLinkDao.flush();
        this.m_bridgeBridgeLinkDao.flush();
        Assert.assertEquals((long)3L, (long)this.m_bridgeMacLinkDao.countAll());
        Assert.assertEquals((long)2L, (long)this.m_bridgeBridgeLinkDao.countAll());
        Assert.assertNotNull((Object)this.m_bridgeTopologyDao);
        this.m_linkd.getQueryManager().loadBridgeTopology();
        Assert.assertEquals((long)1L, (long)this.m_bridgeTopologyDao.getAll().size());
        BroadcastDomain nodeAbd = this.m_linkd.getQueryManager().getBroadcastDomain(nodeA.getId().intValue());
        Assert.assertNotNull((Object)nodeAbd);
        BroadcastDomain nodeBbd = this.m_linkd.getQueryManager().getBroadcastDomain(nodeB.getId().intValue());
        Assert.assertNotNull((Object)nodeBbd);
        Assert.assertEquals((Object)nodeAbd, (Object)nodeBbd);
        BroadcastDomain nodeCbd = this.m_linkd.getQueryManager().getBroadcastDomain(nodeC.getId().intValue());
        Assert.assertNotNull((Object)nodeCbd);
        Assert.assertEquals((Object)nodeAbd, (Object)nodeCbd);
        Assert.assertTrue((boolean)nodeAbd.hasRootBridge());
        Assert.assertEquals((long)nodeAbd.getRootBridgeId().intValue(), (long)nodeB.getId().intValue());
        Assert.assertTrue((boolean)nodeAbd.containBridgeId(nodeA.getId().intValue()));
        Assert.assertTrue((boolean)nodeAbd.containBridgeId(nodeB.getId().intValue()));
        Assert.assertTrue((boolean)nodeAbd.containBridgeId(nodeC.getId().intValue()));
        nodeAbd.hierarchySetUp(nodeAbd.getBridge(nodeA.getId().intValue()));
        Assert.assertNotNull((Object)nodeAbd.getRootBridgeId());
        topology.check(nodeAbd);
        this.m_linkd.deleteNode(nodeC.getId().intValue());
        Assert.assertEquals((long)1L, (long)this.m_bridgeTopologyDao.getAll().size());
        BroadcastDomain domain = (BroadcastDomain)this.m_bridgeTopologyDao.getAll().iterator().next();
        topology.checkAB(domain);
    }

    @Test
    public void testDeleteBridgeB() {
        EnLinkdTestHelper.ABCTopology topology = new EnLinkdTestHelper.ABCTopology(this);
        NetworkBuilder nb = new NetworkBuilder();
        nb.addNode("nodeA").setForeignSource("linkd").setForeignId("nodeA").setSysObjectId("0.0").setSysName("nodeA").setType(OnmsNode.NodeType.ACTIVE);
        nb.addInterface("10.0.1.1").setIsSnmpPrimary("P").setIsManaged("M");
        this.m_nodeDao.save((Object)nb.getCurrentNode());
        nb.addNode("nodeB").setForeignSource("linkd").setForeignId("nodeB").setSysObjectId("0.0").setSysName("nodeB").setType(OnmsNode.NodeType.ACTIVE);
        nb.addInterface("10.0.1.2").setIsSnmpPrimary("P").setIsManaged("M");
        this.m_nodeDao.save((Object)nb.getCurrentNode());
        nb.addNode("nodeC").setForeignSource("linkd").setForeignId("nodeC").setSysObjectId("0.0").setSysName("nodeC").setType(OnmsNode.NodeType.ACTIVE);
        nb.addInterface("10.0.1.3").setIsSnmpPrimary("P").setIsManaged("M");
        this.m_nodeDao.save((Object)nb.getCurrentNode());
        OnmsNode nodeA = this.m_nodeDao.findByForeignId("linkd", "nodeA");
        OnmsNode nodeB = this.m_nodeDao.findByForeignId("linkd", "nodeB");
        OnmsNode nodeC = this.m_nodeDao.findByForeignId("linkd", "nodeC");
        topology.nodeAId = nodeA.getId();
        topology.nodeBId = nodeB.getId();
        topology.nodeCId = nodeC.getId();
        topology.nodeA = nodeA;
        topology.nodeB = nodeB;
        topology.nodeC = nodeC;
        BridgeBridgeLink ablink = new BridgeBridgeLink();
        ablink.setNode(nodeB);
        ablink.setBridgePort(topology.portBA);
        ablink.setDesignatedNode(nodeA);
        ablink.setDesignatedPort(topology.portAB);
        ablink.setBridgeBridgeLinkLastPollTime(ablink.getBridgeBridgeLinkCreateTime());
        this.m_bridgeBridgeLinkDao.save((Object)ablink);
        BridgeBridgeLink bclink = new BridgeBridgeLink();
        bclink.setNode(nodeC);
        bclink.setBridgePort(topology.portCB);
        bclink.setDesignatedNode(nodeB);
        bclink.setDesignatedPort(topology.portBC);
        bclink.setBridgeBridgeLinkLastPollTime(ablink.getBridgeBridgeLinkCreateTime());
        this.m_bridgeBridgeLinkDao.save((Object)bclink);
        BridgeMacLink mac1 = new BridgeMacLink();
        mac1.setNode(nodeA);
        mac1.setBridgePort(topology.portA);
        mac1.setMacAddress(topology.mac1);
        mac1.setBridgeMacLinkLastPollTime(mac1.getBridgeMacLinkCreateTime());
        this.m_bridgeMacLinkDao.save((Object)mac1);
        BridgeMacLink mac2 = new BridgeMacLink();
        mac2.setNode(nodeB);
        mac2.setBridgePort(topology.portB);
        mac2.setMacAddress(topology.mac2);
        mac2.setBridgeMacLinkLastPollTime(mac2.getBridgeMacLinkCreateTime());
        this.m_bridgeMacLinkDao.save((Object)mac2);
        BridgeMacLink mac3 = new BridgeMacLink();
        mac3.setNode(nodeC);
        mac3.setBridgePort(topology.portC);
        mac3.setMacAddress(topology.mac3);
        mac3.setBridgeMacLinkLastPollTime(mac3.getBridgeMacLinkCreateTime());
        this.m_bridgeMacLinkDao.save((Object)mac3);
        this.m_bridgeMacLinkDao.flush();
        this.m_bridgeBridgeLinkDao.flush();
        Assert.assertEquals((long)3L, (long)this.m_bridgeMacLinkDao.countAll());
        Assert.assertEquals((long)2L, (long)this.m_bridgeBridgeLinkDao.countAll());
        Assert.assertNotNull((Object)this.m_bridgeTopologyDao);
        this.m_linkd.getQueryManager().loadBridgeTopology();
        Assert.assertEquals((long)1L, (long)this.m_bridgeTopologyDao.getAll().size());
        BroadcastDomain nodeAbd = this.m_linkd.getQueryManager().getBroadcastDomain(nodeA.getId().intValue());
        Assert.assertNotNull((Object)nodeAbd);
        BroadcastDomain nodeBbd = this.m_linkd.getQueryManager().getBroadcastDomain(nodeB.getId().intValue());
        BroadcastDomain nodeCbd = this.m_linkd.getQueryManager().getBroadcastDomain(nodeC.getId().intValue());
        Assert.assertEquals((Object)nodeAbd, (Object)nodeBbd);
        Assert.assertEquals((Object)nodeAbd, (Object)nodeCbd);
        Assert.assertTrue((boolean)nodeAbd.hasRootBridge());
        Assert.assertEquals((long)nodeAbd.getRootBridge().getId().intValue(), (long)nodeA.getId().intValue());
        Assert.assertTrue((boolean)nodeAbd.containBridgeId(nodeA.getId().intValue()));
        Assert.assertTrue((boolean)nodeAbd.containBridgeId(nodeB.getId().intValue()));
        Assert.assertTrue((boolean)nodeAbd.containBridgeId(nodeC.getId().intValue()));
        nodeAbd.hierarchySetUp(nodeAbd.getBridge(nodeA.getId().intValue()));
        Assert.assertNotNull((Object)nodeAbd.getRootBridgeId());
        topology.check(nodeAbd);
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(nodeB.getId().intValue()));
        this.m_linkd.deleteNode(nodeB.getId().intValue());
        Assert.assertEquals((long)1L, (long)this.m_bridgeTopologyDao.getAll().size());
        BroadcastDomain domain = (BroadcastDomain)this.m_bridgeTopologyDao.getAll().iterator().next();
        topology.checkAC(domain);
    }

    @Test
    public void testDeleteBridgeA() {
        EnLinkdTestHelper.ABCTopology topology = new EnLinkdTestHelper.ABCTopology(this);
        NetworkBuilder nb = new NetworkBuilder();
        nb.addNode("nodeA").setForeignSource("linkd").setForeignId("nodeA").setSysObjectId("0.0").setSysName("nodeA").setType(OnmsNode.NodeType.ACTIVE);
        nb.addInterface("10.0.1.1").setIsSnmpPrimary("P").setIsManaged("M");
        this.m_nodeDao.save((Object)nb.getCurrentNode());
        nb.addNode("nodeB").setForeignSource("linkd").setForeignId("nodeB").setSysObjectId("0.0").setSysName("nodeB").setType(OnmsNode.NodeType.ACTIVE);
        nb.addInterface("10.0.1.2").setIsSnmpPrimary("P").setIsManaged("M");
        this.m_nodeDao.save((Object)nb.getCurrentNode());
        nb.addNode("nodeC").setForeignSource("linkd").setForeignId("nodeC").setSysObjectId("0.0").setSysName("nodeC").setType(OnmsNode.NodeType.ACTIVE);
        nb.addInterface("10.0.1.3").setIsSnmpPrimary("P").setIsManaged("M");
        this.m_nodeDao.save((Object)nb.getCurrentNode());
        OnmsNode nodeA = this.m_nodeDao.findByForeignId("linkd", "nodeA");
        OnmsNode nodeB = this.m_nodeDao.findByForeignId("linkd", "nodeB");
        OnmsNode nodeC = this.m_nodeDao.findByForeignId("linkd", "nodeC");
        topology.nodeAId = nodeA.getId();
        topology.nodeBId = nodeB.getId();
        topology.nodeCId = nodeC.getId();
        topology.nodeA = nodeA;
        topology.nodeB = nodeB;
        topology.nodeC = nodeC;
        BridgeBridgeLink ablink = new BridgeBridgeLink();
        ablink.setNode(nodeB);
        ablink.setBridgePort(topology.portBA);
        ablink.setDesignatedNode(nodeA);
        ablink.setDesignatedPort(topology.portAB);
        ablink.setBridgeBridgeLinkLastPollTime(ablink.getBridgeBridgeLinkCreateTime());
        this.m_bridgeBridgeLinkDao.save((Object)ablink);
        BridgeBridgeLink bclink = new BridgeBridgeLink();
        bclink.setNode(nodeC);
        bclink.setBridgePort(topology.portCB);
        bclink.setDesignatedNode(nodeB);
        bclink.setDesignatedPort(topology.portBC);
        bclink.setBridgeBridgeLinkLastPollTime(ablink.getBridgeBridgeLinkCreateTime());
        this.m_bridgeBridgeLinkDao.save((Object)bclink);
        BridgeMacLink mac1 = new BridgeMacLink();
        mac1.setNode(nodeA);
        mac1.setBridgePort(topology.portA);
        mac1.setMacAddress(topology.mac1);
        mac1.setBridgeMacLinkLastPollTime(mac1.getBridgeMacLinkCreateTime());
        this.m_bridgeMacLinkDao.save((Object)mac1);
        BridgeMacLink mac2 = new BridgeMacLink();
        mac2.setNode(nodeB);
        mac2.setBridgePort(topology.portB);
        mac2.setMacAddress(topology.mac2);
        mac2.setBridgeMacLinkLastPollTime(mac2.getBridgeMacLinkCreateTime());
        this.m_bridgeMacLinkDao.save((Object)mac2);
        BridgeMacLink mac3 = new BridgeMacLink();
        mac3.setNode(nodeC);
        mac3.setBridgePort(topology.portC);
        mac3.setMacAddress(topology.mac3);
        mac3.setBridgeMacLinkLastPollTime(mac3.getBridgeMacLinkCreateTime());
        this.m_bridgeMacLinkDao.save((Object)mac3);
        this.m_bridgeMacLinkDao.flush();
        this.m_bridgeBridgeLinkDao.flush();
        Assert.assertEquals((long)3L, (long)this.m_bridgeMacLinkDao.countAll());
        Assert.assertEquals((long)2L, (long)this.m_bridgeBridgeLinkDao.countAll());
        Assert.assertNotNull((Object)this.m_bridgeTopologyDao);
        this.m_linkd.getQueryManager().loadBridgeTopology();
        Assert.assertEquals((long)1L, (long)this.m_bridgeTopologyDao.getAll().size());
        BroadcastDomain nodeAbd = this.m_linkd.getQueryManager().getBroadcastDomain(nodeA.getId().intValue());
        Assert.assertNotNull((Object)nodeAbd);
        BroadcastDomain nodeBbd = this.m_linkd.getQueryManager().getBroadcastDomain(nodeB.getId().intValue());
        BroadcastDomain nodeCbd = this.m_linkd.getQueryManager().getBroadcastDomain(nodeC.getId().intValue());
        Assert.assertEquals((Object)nodeAbd, (Object)nodeBbd);
        Assert.assertEquals((Object)nodeAbd, (Object)nodeCbd);
        Assert.assertTrue((boolean)nodeAbd.hasRootBridge());
        Assert.assertEquals((long)nodeAbd.getRootBridge().getId().intValue(), (long)nodeA.getId().intValue());
        Assert.assertTrue((boolean)nodeAbd.containBridgeId(nodeA.getId().intValue()));
        Assert.assertTrue((boolean)nodeAbd.containBridgeId(nodeB.getId().intValue()));
        Assert.assertTrue((boolean)nodeAbd.containBridgeId(nodeC.getId().intValue()));
        nodeAbd.hierarchySetUp(nodeAbd.getBridge(nodeA.getId().intValue()));
        Assert.assertNotNull((Object)nodeAbd.getRootBridgeId());
        topology.check(nodeAbd);
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(nodeA.getId().intValue()));
        this.m_linkd.scheduleBridgeTopologyDiscovery(nodeA.getId().intValue());
        this.m_linkd.deleteNode(nodeA.getId().intValue());
        Assert.assertEquals((long)1L, (long)this.m_bridgeTopologyDao.getAll().size());
        BroadcastDomain domain = (BroadcastDomain)this.m_bridgeTopologyDao.getAll().iterator().next();
        topology.checkBC(domain);
    }
}

