/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.mock;

import com.codahale.metrics.MetricRegistry;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import javax.sql.DataSource;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.opennms.core.db.DataSourceFactory;
import org.opennms.core.test.ConfigurationTestUtils;
import org.opennms.core.test.MockLogAppender;
import org.opennms.core.test.db.MockDatabase;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.DefaultEventConfDao;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.config.api.EventConfDao;
import org.opennms.netmgt.dao.api.EventdServiceManager;
import org.opennms.netmgt.dao.mock.JdbcEventdServiceManager;
import org.opennms.netmgt.eventd.AbstractEventUtil;
import org.opennms.netmgt.eventd.BroadcastEventProcessor;
import org.opennms.netmgt.eventd.DefaultEventHandlerImpl;
import org.opennms.netmgt.eventd.EventExpander;
import org.opennms.netmgt.eventd.EventIpcManagerDefaultImpl;
import org.opennms.netmgt.eventd.EventUtil;
import org.opennms.netmgt.eventd.Eventd;
import org.opennms.netmgt.eventd.adaptors.EventIpcManagerEventHandlerProxy;
import org.opennms.netmgt.eventd.adaptors.tcp.TcpEventReceiver;
import org.opennms.netmgt.eventd.adaptors.udp.UdpEventReceiver;
import org.opennms.netmgt.eventd.processor.EventIpcBroadcastProcessor;
import org.opennms.netmgt.events.api.EventHandler;
import org.opennms.netmgt.events.api.EventIpcBroadcaster;
import org.opennms.netmgt.events.api.EventIpcManager;
import org.opennms.netmgt.events.api.EventIpcManagerFactory;
import org.opennms.netmgt.events.api.EventProxy;
import org.opennms.netmgt.mock.EventUtilJdbcImpl;
import org.opennms.netmgt.mock.MockNetwork;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.test.mock.MockUtil;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;

public class OpenNMSITCase {
    protected static MockDatabase m_db;
    protected static MockNetwork m_network;
    protected static Eventd m_eventd;
    protected static EventIpcManagerDefaultImpl m_eventdIpcMgr;
    protected static boolean m_allowWarnings;
    protected static boolean m_runSupers;
    public static int PROXY_PORT;
    private boolean m_startEventd = true;
    int m_version = 1;
    private EventProxy m_eventProxy;
    protected PlatformTransactionManager m_transMgr;
    private MetricRegistry m_registry = new MetricRegistry();

    public String getSnmpConfig() throws IOException {
        return ConfigurationTestUtils.getConfigForResourceWithReplacements((Object)this, (String)"/org/opennms/netmgt/mock/snmp-config.xml", (String[][])new String[][]{{"\\$\\{myVersion\\}", this.myVersion()}, {"\\$\\{myLocalHost\\}", InetAddressUtils.str((InetAddress)this.myLocalHost())}});
    }

    protected InetAddress myLocalHost() {
        return InetAddressUtils.getInetAddress((String)"127.0.0.1");
    }

    protected String myVersion() {
        switch (this.m_version) {
            case 1: {
                return "v1";
            }
            case 2: {
                return "v2c";
            }
            case 3: {
                return "v3";
            }
        }
        return "v1";
    }

    public void setVersion(int version) {
        this.m_version = version;
    }

    @Before
    public void setUp() throws Exception {
        MockUtil.println((String)("------------ Begin Test " + this + " --------------------------"));
        MockLogAppender.setupLogging();
        if (m_runSupers) {
            this.createMockNetwork();
            this.populateDatabase();
            DataSourceFactory.setInstance((DataSource)m_db);
            SnmpPeerFactory.setInstance((SnmpPeerFactory)new SnmpPeerFactory((Resource)new ByteArrayResource(this.getSnmpConfig().getBytes())));
            if (this.isStartEventd()) {
                m_eventdIpcMgr = new EventIpcManagerDefaultImpl(this.m_registry);
                EventUtilJdbcImpl eventUtil = new EventUtilJdbcImpl();
                AbstractEventUtil.setInstance((EventUtil)eventUtil);
                JdbcEventdServiceManager eventdServiceManager = new JdbcEventdServiceManager();
                eventdServiceManager.setDataSource((DataSource)m_db);
                eventdServiceManager.afterPropertiesSet();
                File configFile = ConfigurationTestUtils.getFileForResource((Object)this, (String)"/org/opennms/netmgt/mock/eventconf.xml");
                DefaultEventConfDao eventConfDao = new DefaultEventConfDao();
                eventConfDao.setConfigResource((Resource)new FileSystemResource(configFile));
                eventConfDao.afterPropertiesSet();
                EventExpander eventExpander = new EventExpander(this.m_registry);
                eventExpander.setEventConfDao((EventConfDao)eventConfDao);
                eventExpander.setEventUtil((EventUtil)eventUtil);
                eventExpander.afterPropertiesSet();
                EventIpcBroadcastProcessor eventIpcBroadcastProcessor = new EventIpcBroadcastProcessor(this.m_registry);
                eventIpcBroadcastProcessor.setEventIpcBroadcaster((EventIpcBroadcaster)m_eventdIpcMgr);
                eventIpcBroadcastProcessor.afterPropertiesSet();
                ArrayList<Object> eventProcessors = new ArrayList<Object>(3);
                eventProcessors.add(eventExpander);
                eventProcessors.add(eventIpcBroadcastProcessor);
                DefaultEventHandlerImpl eventHandler = new DefaultEventHandlerImpl(this.m_registry);
                eventHandler.setEventProcessors(eventProcessors);
                eventHandler.afterPropertiesSet();
                m_eventdIpcMgr.setHandlerPoolSize(5);
                m_eventdIpcMgr.setEventHandler((EventHandler)eventHandler);
                m_eventdIpcMgr.afterPropertiesSet();
                this.m_eventProxy = m_eventdIpcMgr;
                EventIpcManagerFactory.setIpcManager((EventIpcManager)m_eventdIpcMgr);
                EventIpcManagerEventHandlerProxy proxy = new EventIpcManagerEventHandlerProxy();
                proxy.setEventIpcManager((EventIpcManager)m_eventdIpcMgr);
                proxy.afterPropertiesSet();
                ArrayList<EventIpcManagerEventHandlerProxy> eventHandlers = new ArrayList<EventIpcManagerEventHandlerProxy>(1);
                eventHandlers.add(proxy);
                TcpEventReceiver tcpEventReceiver = new TcpEventReceiver();
                tcpEventReceiver.setPort(Integer.valueOf(5837));
                tcpEventReceiver.setEventHandlers(eventHandlers);
                UdpEventReceiver udpEventReceiver = new UdpEventReceiver();
                udpEventReceiver.setPort(Integer.valueOf(5837));
                tcpEventReceiver.setEventHandlers(eventHandlers);
                ArrayList<Object> eventReceivers = new ArrayList<Object>(2);
                eventReceivers.add(tcpEventReceiver);
                eventReceivers.add(udpEventReceiver);
                m_eventd = new Eventd();
                m_eventd.setEventdServiceManager((EventdServiceManager)eventdServiceManager);
                m_eventd.setEventReceivers(eventReceivers);
                m_eventd.setReceiver(new BroadcastEventProcessor((EventIpcManager)m_eventdIpcMgr, (EventConfDao)eventConfDao));
                m_eventd.init();
                m_eventd.start();
            }
        }
        this.m_transMgr = new DataSourceTransactionManager(DataSourceFactory.getInstance());
    }

    protected void populateDatabase() throws Exception {
        m_db = new MockDatabase();
        m_db.populate(m_network);
    }

    protected void createMockNetwork() {
        m_network = new MockNetwork();
        m_network.createStandardNetwork();
    }

    @After
    public void runTest() throws Throwable {
        try {
            if (!m_allowWarnings) {
                MockLogAppender.assertNoWarningsOrGreater();
            }
        }
        finally {
            MockUtil.println((String)("------------ End Test " + this + " --------------------------"));
        }
    }

    @After
    public void tearDown() throws Exception {
        if (m_runSupers && this.isStartEventd()) {
            m_eventd.stop();
        }
    }

    protected void setStartEventd(boolean startEventd) {
        this.m_startEventd = startEventd;
    }

    protected boolean isStartEventd() {
        return this.m_startEventd;
    }

    @Test
    public void testDoNothing() {
        this.sleep(200L);
    }

    protected void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected EventProxy getEventProxy() {
        return this.m_eventProxy;
    }

    protected void setEventProxy(EventProxy eventProxy) {
        this.m_eventProxy = eventProxy;
    }

    public JdbcTemplate getJdbcTemplate() {
        return m_db.getJdbcTemplate();
    }

    public String toString() {
        return super.toString() + " - " + OpenNMSITCase.getSnmpImplementation() + " " + this.myVersion();
    }

    private static String getSnmpImplementation() {
        return SnmpUtils.getStrategy().getClass().getSimpleName();
    }

    public EventIpcManager getEventIpcManager() {
        return m_eventdIpcMgr;
    }

    static {
        m_allowWarnings = false;
        m_runSupers = true;
        PROXY_PORT = Integer.getInteger("proxy.port", 5837);
    }
}

