/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.mock;

import java.net.InetAddress;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.opennms.core.utils.DBUtils;
import org.opennms.core.utils.InetAddressUtils;

public final class DbSnmpInterfaceEntry {
    static final int LAME_SNMP_HOST_IFINDEX = -100;
    private static final String SQL_LOAD_REC = "SELECT snmpIpAdEntNetMask, snmpPhysAddr, snmpIfDescr, snmpIfType, snmpIfName, snmpIfSpeed, snmpIfAdminStatus, snmpIfOperStatus, snmpIfAlias, snmpCollect FROM snmpInterface WHERE nodeID = ? AND snmpIfIndex = ?";
    private boolean m_fromDb;
    private long m_nodeId;
    private int m_ifIndex;
    private InetAddress m_netmask;
    private String m_physAddr;
    private String m_ifDescription;
    private int m_ifType;
    private String m_ifName;
    private String m_ifAlias;
    private long m_ifSpeed;
    private int m_ifAdminStatus;
    private int m_ifOperStatus;
    private String m_collect;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean load(Connection c) throws SQLException {
        if (!this.m_fromDb) {
            throw new IllegalStateException("The record does not exists in the database");
        }
        PreparedStatement stmt = null;
        ResultSet rset = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            String str;
            stmt = c.prepareStatement(SQL_LOAD_REC);
            d.watch((Object)stmt);
            stmt.setLong(1, this.m_nodeId);
            stmt.setInt(2, this.m_ifIndex);
            rset = stmt.executeQuery();
            d.watch((Object)rset);
            if (!rset.next()) {
                boolean bl = false;
                return bl;
            }
            int ndx = 1;
            if ((str = rset.getString(ndx++)) != null && !rset.wasNull()) {
                this.m_netmask = InetAddressUtils.addr((String)str);
            }
            this.m_physAddr = rset.getString(ndx++);
            if (rset.wasNull()) {
                this.m_physAddr = null;
            }
            this.m_ifDescription = rset.getString(ndx++);
            if (rset.wasNull()) {
                this.m_ifDescription = null;
            }
            this.m_ifType = rset.getInt(ndx++);
            if (rset.wasNull()) {
                this.m_ifIndex = -1;
            }
            this.m_ifName = rset.getString(ndx++);
            if (rset.wasNull()) {
                this.m_ifName = null;
            }
            this.m_ifSpeed = rset.getLong(ndx++);
            if (rset.wasNull()) {
                this.m_ifSpeed = -1L;
            }
            this.m_ifAdminStatus = rset.getInt(ndx++);
            if (rset.wasNull()) {
                this.m_ifAdminStatus = -1;
            }
            this.m_ifOperStatus = rset.getInt(ndx++);
            if (rset.wasNull()) {
                this.m_ifOperStatus = -1;
            }
            this.m_ifAlias = rset.getString(ndx++);
            if (rset.wasNull()) {
                this.m_ifAlias = null;
            }
            this.m_collect = rset.getString(ndx++);
            if (rset.wasNull()) {
                this.m_collect = null;
            }
        }
        finally {
            d.cleanUp();
        }
        return true;
    }

    private DbSnmpInterfaceEntry(long nodeId, int ifIndex) {
        this(nodeId, ifIndex, true);
    }

    private DbSnmpInterfaceEntry(long nodeId, int ifIndex, boolean exists) {
        this.m_fromDb = exists;
        this.m_nodeId = nodeId;
        this.m_ifIndex = ifIndex;
        this.m_netmask = null;
        this.m_physAddr = null;
        this.m_ifDescription = null;
        this.m_ifType = -1;
        this.m_ifName = null;
        this.m_ifSpeed = -1L;
        this.m_ifAdminStatus = -1;
        this.m_ifOperStatus = -1;
        this.m_ifAlias = null;
        this.m_collect = null;
    }

    public String getAlias() {
        return this.m_ifAlias;
    }

    public static DbSnmpInterfaceEntry get(Connection db, long nodeId, int ifIndex) throws SQLException {
        DbSnmpInterfaceEntry entry = new DbSnmpInterfaceEntry(nodeId, ifIndex);
        if (!entry.load(db)) {
            entry = null;
        }
        return entry;
    }

    public String toString() {
        String sep = System.getProperty("line.separator");
        StringBuffer buf = new StringBuffer();
        buf.append("from database   = ").append(this.m_fromDb).append(sep);
        buf.append("node identifier = ").append(this.m_nodeId).append(sep);
        buf.append("IP Netmask      = ").append(InetAddressUtils.str((InetAddress)this.m_netmask)).append(sep);
        buf.append("MAC             = ").append(this.m_physAddr).append(sep);
        buf.append("ifIndex         = ").append(this.m_ifIndex).append(sep);
        buf.append("ifDescr         = ").append(this.m_ifDescription).append(sep);
        buf.append("ifType          = ").append(this.m_ifType).append(sep);
        buf.append("ifName          = ").append(this.m_ifName).append(sep);
        buf.append("ifSpeed         = ").append(this.m_ifSpeed).append(sep);
        buf.append("ifAdminStatus   = ").append(this.m_ifAdminStatus).append(sep);
        buf.append("ifOperStatus    = ").append(this.m_ifOperStatus).append(sep);
        buf.append("ifAlias         = ").append(this.m_ifAlias).append(sep);
        buf.append("collect         = ").append(this.m_collect).append(sep);
        return buf.toString();
    }
}

