/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collection.persistence.rrd;

import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.opennms.core.rpc.api.RpcClientFactory;
import org.opennms.core.rpc.mock.MockRpcClientFactory;
import org.opennms.core.test.MockLogAppender;
import org.opennms.core.test.MockPlatformTransactionManager;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.collectd.DefaultCollectionAgent;
import org.opennms.netmgt.collectd.NodeInfo;
import org.opennms.netmgt.collectd.NodeResourceType;
import org.opennms.netmgt.collectd.OnmsSnmpCollection;
import org.opennms.netmgt.collectd.ResourceType;
import org.opennms.netmgt.collectd.SnmpAttribute;
import org.opennms.netmgt.collectd.SnmpAttributeType;
import org.opennms.netmgt.collectd.SnmpCollectionAgent;
import org.opennms.netmgt.collectd.StringAttributeType;
import org.opennms.netmgt.collection.api.AttributeGroupType;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionAttribute;
import org.opennms.netmgt.collection.api.CollectionAttributeType;
import org.opennms.netmgt.collection.api.CollectionResource;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.collection.persistence.rrd.BasePersister;
import org.opennms.netmgt.config.api.DataCollectionConfigDao;
import org.opennms.netmgt.config.datacollection.MibObject;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.api.ResourceStorageDao;
import org.opennms.netmgt.dao.support.FilesystemResourceStorageDao;
import org.opennms.netmgt.mock.MockDataCollectionConfig;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.rrd.RrdRepository;
import org.opennms.netmgt.rrd.RrdStrategy;
import org.opennms.netmgt.rrd.jrobin.JRobinRrdStrategy;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.proxy.LocationAwareSnmpClient;
import org.opennms.netmgt.snmp.proxy.common.LocationAwareSnmpClientRpcImpl;
import org.opennms.test.FileAnticipator;
import org.opennms.test.mock.EasyMockUtils;
import org.opennms.test.mock.MockUtil;
import org.springframework.transaction.PlatformTransactionManager;

public class BasePersisterTest {
    private FileAnticipator m_fileAnticipator;
    private File m_snmpDirectory;
    private BasePersister m_persister;
    private OnmsIpInterface m_intf;
    private OnmsNode m_node;
    private PlatformTransactionManager m_transMgr = new MockPlatformTransactionManager();
    private EasyMockUtils m_easyMockUtils = new EasyMockUtils();
    private IpInterfaceDao m_ifDao;
    private ServiceParameters m_serviceParams;
    private RrdStrategy<?, ?> m_rrdStrategy;
    private FilesystemResourceStorageDao m_resourceStorageDao;
    private LocationAwareSnmpClient m_locationAwareSnmpClient = new LocationAwareSnmpClientRpcImpl((RpcClientFactory)new MockRpcClientFactory());
    @Rule
    public TestName m_testName = new TestName();

    @Before
    public void setUp() throws Exception {
        MockUtil.println((String)("------------ Begin Test " + this.m_testName.getMethodName() + " --------------------------"));
        MockLogAppender.setupLogging();
        this.m_fileAnticipator = new FileAnticipator();
        this.m_rrdStrategy = new JRobinRrdStrategy();
        this.m_resourceStorageDao = new FilesystemResourceStorageDao();
        this.m_resourceStorageDao.setRrdDirectory(this.m_fileAnticipator.getTempDir());
        this.m_intf = new OnmsIpInterface();
        this.m_node = new OnmsNode();
        this.m_node.setId(Integer.valueOf(1));
        this.m_intf.setId(Integer.valueOf(25));
        this.m_intf.setNode(this.m_node);
        this.m_intf.setIpAddress(InetAddressUtils.addr((String)"1.1.1.1"));
        this.m_ifDao = (IpInterfaceDao)this.m_easyMockUtils.createMock(IpInterfaceDao.class);
        this.m_serviceParams = new ServiceParameters(new HashMap());
    }

    @After
    public void checkWarnings() throws Throwable {
        MockLogAppender.assertNoWarningsOrGreater();
        this.m_fileAnticipator.deleteExpected();
    }

    @After
    public void tearDown() throws Exception {
        this.m_fileAnticipator.deleteExpected(true);
        this.m_fileAnticipator.tearDown();
        MockUtil.println((String)("------------ End Test " + this.m_testName.getMethodName() + " --------------------------"));
    }

    @Test
    public void testPersistStringAttributeWithExistingPropertiesFile() throws Exception {
        this.initPersister();
        File nodeDir = this.m_fileAnticipator.tempDir(this.getSnmpRrdDirectory(), this.m_node.getId().toString());
        this.m_fileAnticipator.tempFile(nodeDir, "strings.properties", "#just a test");
        SnmpAttribute attribute = this.buildStringAttribute();
        this.m_persister.persistStringAttribute((CollectionAttribute)attribute);
    }

    @Test
    public void testPersistStringAttributeWithParentDirectory() throws Exception {
        this.initPersister();
        File nodeDir = this.m_fileAnticipator.tempDir(this.getSnmpRrdDirectory(), this.m_node.getId().toString());
        this.m_fileAnticipator.expecting(nodeDir, "strings.properties");
        SnmpAttribute attribute = this.buildStringAttribute();
        this.m_persister.persistStringAttribute((CollectionAttribute)attribute);
    }

    @Test
    public void testPersistStringAttributeWithNoParentDirectory() throws Exception {
        this.initPersister();
        File nodeDir = this.m_fileAnticipator.expecting(this.getSnmpRrdDirectory(), this.m_node.getId().toString());
        this.m_fileAnticipator.expecting(nodeDir, "strings.properties");
        SnmpAttribute attribute = this.buildStringAttribute();
        this.m_persister.persistStringAttribute((CollectionAttribute)attribute);
    }

    @Test
    public void testPersistStringAttributeUsingBuilder() throws Exception {
        this.initPersister();
        File nodeDir = this.m_fileAnticipator.expecting(this.getSnmpRrdDirectory(), this.m_node.getId().toString());
        this.m_fileAnticipator.expecting(nodeDir, "strings.properties");
        SnmpAttribute attribute = this.buildStringAttribute();
        this.m_persister.pushShouldPersist(attribute.getResource());
        this.m_persister.pushShouldPersist((CollectionAttribute)attribute);
        this.m_persister.setBuilder(this.m_persister.createBuilder(attribute.getResource(), attribute.getName(), (Set)Sets.newHashSet((Object[])new CollectionAttributeType[]{attribute.getAttributeType()})));
        this.m_persister.storeAttribute((CollectionAttribute)attribute);
        this.m_persister.commitBuilder();
        this.m_persister.popShouldPersist();
    }

    @Test
    public void testBug2733() throws Exception {
        this.m_serviceParams.getParameters().put("storing-enabled", "false");
        this.testPersistStringAttributeUsingBuilder();
    }

    private SnmpAttribute buildStringAttribute() {
        EasyMock.expect((Object)this.m_ifDao.load((Serializable)this.m_intf.getId())).andReturn((Object)this.m_intf).anyTimes();
        this.m_easyMockUtils.replayAll();
        SnmpCollectionAgent agent = DefaultCollectionAgent.create((Integer)this.m_intf.getId(), (IpInterfaceDao)this.m_ifDao, (PlatformTransactionManager)this.m_transMgr);
        MockDataCollectionConfig dataCollectionConfig = new MockDataCollectionConfig();
        OnmsSnmpCollection collection = new OnmsSnmpCollection(agent, new ServiceParameters(new HashMap()), (DataCollectionConfigDao)dataCollectionConfig, this.m_locationAwareSnmpClient);
        NodeResourceType resourceType = new NodeResourceType(agent, collection);
        NodeInfo resource = new NodeInfo(resourceType, (CollectionAgent)agent);
        MibObject mibObject = new MibObject();
        mibObject.setOid(".1.1.1.1");
        mibObject.setAlias("mibObjectAlias");
        mibObject.setType("string");
        mibObject.setInstance("0");
        mibObject.setMaxval(null);
        mibObject.setMinval(null);
        StringAttributeType attributeType = new StringAttributeType((ResourceType)resourceType, "some-collection", mibObject, new AttributeGroupType("mibGroup", "ignore"));
        return new SnmpAttribute((CollectionResource)resource, (SnmpAttributeType)attributeType, SnmpUtils.getValueFactory().getOctetString("foo".getBytes()));
    }

    private void initPersister() throws IOException {
        this.m_persister = new BasePersister(this.m_serviceParams, this.createRrdRepository(), this.m_rrdStrategy, (ResourceStorageDao)this.m_resourceStorageDao);
    }

    private RrdRepository createRrdRepository() throws IOException {
        RrdRepository repository = new RrdRepository();
        repository.setRrdBaseDir(this.getSnmpRrdDirectory());
        repository.setHeartBeat(600);
        repository.setStep(300);
        repository.setRraList(Collections.singletonList("RRA:AVERAGE:0.5:1:100"));
        return repository;
    }

    private File getSnmpRrdDirectory() throws IOException {
        if (this.m_snmpDirectory == null) {
            this.m_snmpDirectory = this.m_fileAnticipator.tempDir("snmp");
        }
        return this.m_snmpDirectory;
    }
}

