/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.pollables;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.net.InetAddress;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.opennms.core.test.MockLogAppender;
import org.opennms.netmgt.collection.api.PersisterFactory;
import org.opennms.netmgt.collection.persistence.rrd.RrdPersisterFactory;
import org.opennms.netmgt.config.PollerConfig;
import org.opennms.netmgt.config.poller.Package;
import org.opennms.netmgt.dao.api.ResourceStorageDao;
import org.opennms.netmgt.dao.support.FilesystemResourceStorageDao;
import org.opennms.netmgt.mock.MockNetwork;
import org.opennms.netmgt.mock.MockPollerConfig;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.mock.MockMonitoredService;
import org.opennms.netmgt.poller.pollables.LatencyStoringServiceMonitorAdaptor;
import org.opennms.netmgt.poller.support.AbstractServiceMonitor;
import org.opennms.netmgt.rrd.RrdStrategy;

public class LatencyStoringServiceMonitorAdaptorPersistenceTest {
    @Rule
    public TemporaryFolder m_tempFolder = new TemporaryFolder();
    private RrdPersisterFactory m_persisterFactory;
    private FilesystemResourceStorageDao m_resourceStorageDao;
    private RrdStrategy<Object, Object> m_rrdStrategy;

    @Before
    public void setUp() throws Exception {
        MockLogAppender.setupLogging();
        this.m_resourceStorageDao = new FilesystemResourceStorageDao();
        this.m_resourceStorageDao.setRrdDirectory(this.m_tempFolder.newFolder("response"));
        this.m_persisterFactory = new RrdPersisterFactory();
        this.m_persisterFactory.setResourceStorageDao((ResourceStorageDao)this.m_resourceStorageDao);
        this.m_rrdStrategy = (RrdStrategy)EasyMock.createMock(RrdStrategy.class);
        this.m_persisterFactory.setRrdStrategy(this.m_rrdStrategy);
    }

    @After
    public void tearDown() {
        MockLogAppender.assertNoWarningsOrGreater();
    }

    @Test
    public void canPersistsLatencySamples() throws Exception {
        this.persistAndVerifyLatencySamples(null, Paths.get("192.168.1.5", new String[0]));
        this.persistAndVerifyLatencySamples("Default", Paths.get("192.168.1.5", new String[0]));
        String nonDefaultLocation = "not_Default";
        this.persistAndVerifyLatencySamples("not_Default", Paths.get("not_Default", "192.168.1.5"));
        String someLocation = "TOG @ Pittsboro, NC";
        this.persistAndVerifyLatencySamples("TOG @ Pittsboro, NC", Paths.get("TOG___Pittsboro__NC", "192.168.1.5"));
    }

    private void persistAndVerifyLatencySamples(String locationName, Path pathToResourceInResponseTime) throws Exception {
        PollStatus pollStatus = PollStatus.get((int)1, (Double)42.1);
        LinkedHashMap<String, Integer> props = new LinkedHashMap<String, Integer>(pollStatus.getProperties());
        props.put("ping1", 1);
        props.put("loss", 2);
        props.put("median", 3);
        pollStatus.setProperties(props);
        FixedServiceMonitor serviceMonitor = new FixedServiceMonitor(pollStatus);
        Package pkg = new Package();
        MockNetwork mockNetwork = new MockNetwork();
        mockNetwork.createStandardNetwork();
        MockPollerConfig pollerConfig = new MockPollerConfig(mockNetwork);
        pollerConfig.setRRAList(pkg, Lists.newArrayList((Object[])new String[]{"RRA:AVERAGE:0.5:1:2016"}));
        LatencyStoringServiceMonitorAdaptor lssma = new LatencyStoringServiceMonitorAdaptor((PollerConfig)pollerConfig, pkg, (PersisterFactory)this.m_persisterFactory, (ResourceStorageDao)this.m_resourceStorageDao);
        MockMonitoredService monitoredService = new MockMonitoredService(3, "Firewall", locationName, InetAddress.getByName("192.168.1.5"), "SMTP");
        HashMap params = Maps.newHashMap();
        params.put("rrd-repository", this.getResponseTimeRoot().getAbsolutePath());
        params.put("rrd-base-name", "smtp-base");
        EasyMock.expect((Object)this.m_rrdStrategy.getDefaultFileExtension()).andReturn((Object)".jrb").atLeastOnce();
        this.m_rrdStrategy.createDefinition((String)EasyMock.eq((Object)"192.168.1.5"), (String)EasyMock.eq((Object)this.getResponseTimeRoot().toPath().resolve(pathToResourceInResponseTime).toString()), (String)EasyMock.eq((Object)"smtp-base"), EasyMock.anyInt(), (List)EasyMock.anyObject(), (List)EasyMock.anyObject());
        EasyMock.expectLastCall().andReturn(null).once();
        this.m_rrdStrategy.createFile(EasyMock.anyObject());
        EasyMock.expectLastCall().once();
        this.m_rrdStrategy.openFile((String)EasyMock.eq((Object)this.getResponseTimeRoot().toPath().resolve(pathToResourceInResponseTime.resolve("smtp-base.jrb")).toString()));
        EasyMock.expectLastCall().andReturn(null).once();
        this.m_rrdStrategy.updateFile(EasyMock.isNull(), (String)EasyMock.eq((Object)"192.168.1.5"), EasyMock.endsWith((String)":42.1:1:2:3"));
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{this.m_rrdStrategy});
        lssma.handlePollResult((MonitoredService)monitoredService, (Map)params, serviceMonitor.poll((MonitoredService)monitoredService, params));
        EasyMock.verify((Object[])new Object[]{this.m_rrdStrategy});
        EasyMock.reset((Object[])new Object[]{this.m_rrdStrategy});
    }

    public File getResponseTimeRoot() {
        return new File(this.m_tempFolder.getRoot(), "response");
    }

    private static class FixedServiceMonitor
    extends AbstractServiceMonitor {
        private final PollStatus m_pollStatus;

        public FixedServiceMonitor(PollStatus pollStatus) {
            this.m_pollStatus = pollStatus;
        }

        public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
            return this.m_pollStatus;
        }
    }
}

