/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.MockLogAppender;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgent;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgents;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.LldpUtils;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.enlinkd.snmp.CdpCacheTableTracker;
import org.opennms.netmgt.enlinkd.snmp.CdpGlobalGroupTracker;
import org.opennms.netmgt.enlinkd.snmp.CdpInterfacePortNameGetter;
import org.opennms.netmgt.enlinkd.snmp.Dot1dBasePortTableTracker;
import org.opennms.netmgt.enlinkd.snmp.Dot1dBaseTracker;
import org.opennms.netmgt.enlinkd.snmp.Dot1dStpPortTableTracker;
import org.opennms.netmgt.enlinkd.snmp.Dot1dTpFdbTableTracker;
import org.opennms.netmgt.enlinkd.snmp.Dot1qTpFdbTableTracker;
import org.opennms.netmgt.enlinkd.snmp.IpNetToMediaTableTracker;
import org.opennms.netmgt.enlinkd.snmp.IsisCircTableTracker;
import org.opennms.netmgt.enlinkd.snmp.IsisISAdjTableTracker;
import org.opennms.netmgt.enlinkd.snmp.IsisSysObjectGroupTracker;
import org.opennms.netmgt.enlinkd.snmp.LldpLocPortGetter;
import org.opennms.netmgt.enlinkd.snmp.LldpLocalGroupTracker;
import org.opennms.netmgt.enlinkd.snmp.LldpRemTableTracker;
import org.opennms.netmgt.enlinkd.snmp.OspfGeneralGroupTracker;
import org.opennms.netmgt.enlinkd.snmp.OspfIfTableTracker;
import org.opennms.netmgt.enlinkd.snmp.OspfIpAddrTableGetter;
import org.opennms.netmgt.enlinkd.snmp.OspfNbrTableTracker;
import org.opennms.netmgt.model.BridgeElement;
import org.opennms.netmgt.model.BridgeMacLink;
import org.opennms.netmgt.model.BridgeStpLink;
import org.opennms.netmgt.model.IpNetToMedia;
import org.opennms.netmgt.model.IsIsElement;
import org.opennms.netmgt.model.IsIsLink;
import org.opennms.netmgt.model.LldpElement;
import org.opennms.netmgt.model.LldpLink;
import org.opennms.netmgt.model.OspfElement;
import org.opennms.netmgt.model.OspfLink;
import org.opennms.netmgt.nb.NmsNetworkBuilder;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.proxy.LocationAwareSnmpClient;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-proxy-snmp.xml"})
@JUnitConfigurationEnvironment
public class EnLinkdSnmpIT
extends NmsNetworkBuilder
implements InitializingBean {
    @Autowired
    LocationAwareSnmpClient m_client;
    private static final Logger LOG = LoggerFactory.getLogger(EnLinkdSnmpIT.class);

    public void afterPropertiesSet() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
        Properties p = new Properties();
        p.setProperty("log4j.logger.org.opennms.mock.snmp", "WARN");
        p.setProperty("log4j.logger.org.opennms.core.test.snmp", "WARN");
        p.setProperty("log4j.logger.org.opennms.netmgt", "WARN");
        p.setProperty("log4j.logger.org.springframework", "WARN");
        p.setProperty("log4j.logger.com.mchange.v2.resourcepool", "WARN");
        MockLogAppender.setupLogging((Properties)p);
    }

    @Test
    public void testInSameNetwork() throws Exception {
        Assert.assertEquals((Object)true, (Object)InetAddressUtils.inSameNetwork((InetAddress)InetAddress.getByName("192.168.0.1"), (InetAddress)InetAddress.getByName("192.168.0.2"), (InetAddress)InetAddress.getByName("255.255.255.252")));
        Assert.assertEquals((Object)false, (Object)InetAddressUtils.inSameNetwork((InetAddress)InetAddress.getByName("192.168.0.1"), (InetAddress)InetAddress.getByName("192.168.0.5"), (InetAddress)InetAddress.getByName("255.255.255.252")));
        Assert.assertEquals((Object)true, (Object)InetAddressUtils.inSameNetwork((InetAddress)InetAddress.getByName("10.10.0.1"), (InetAddress)InetAddress.getByName("10.168.0.5"), (InetAddress)InetAddress.getByName("255.0.0.0")));
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.140.252.57", port=161, resource="classpath:/linkd/nms0002UkRoFakeLink/r-ro-suce-pict-001.txt")})
    public void testCdpInterfaceGetter() throws Exception {
        SnmpAgentConfig config = SnmpPeerFactory.getInstance().getAgentConfig(InetAddress.getByName("10.140.252.57"));
        CdpInterfacePortNameGetter get = new CdpInterfacePortNameGetter(config, this.m_client, null);
        Assert.assertEquals((Object)"FastEthernet0", (Object)get.getInterfaceNameFromCiscoCdpMib(Integer.valueOf(1)).toDisplayString());
        Assert.assertEquals((Object)"FastEthernet1", (Object)get.getInterfaceNameFromCiscoCdpMib(Integer.valueOf(2)).toDisplayString());
        Assert.assertEquals((Object)"FastEthernet2", (Object)get.getInterfaceNameFromCiscoCdpMib(Integer.valueOf(3)).toDisplayString());
        Assert.assertEquals((Object)"FastEthernet3", (Object)get.getInterfaceNameFromCiscoCdpMib(Integer.valueOf(4)).toDisplayString());
        Assert.assertEquals((Object)"FastEthernet4", (Object)get.getInterfaceNameFromCiscoCdpMib(Integer.valueOf(5)).toDisplayString());
        Assert.assertEquals((Object)"Tunnel0", (Object)get.getInterfaceNameFromCiscoCdpMib(Integer.valueOf(9)).toDisplayString());
        Assert.assertEquals((Object)"Tunnel3", (Object)get.getInterfaceNameFromCiscoCdpMib(Integer.valueOf(10)).toDisplayString());
        Assert.assertEquals((Object)"FastEthernet0", (Object)get.getInterfaceNameFromMib2(Integer.valueOf(1)).toDisplayString());
        Assert.assertEquals((Object)"FastEthernet1", (Object)get.getInterfaceNameFromMib2(Integer.valueOf(2)).toDisplayString());
        Assert.assertEquals((Object)"FastEthernet2", (Object)get.getInterfaceNameFromMib2(Integer.valueOf(3)).toDisplayString());
        Assert.assertEquals((Object)"FastEthernet3", (Object)get.getInterfaceNameFromMib2(Integer.valueOf(4)).toDisplayString());
        Assert.assertEquals((Object)"FastEthernet4", (Object)get.getInterfaceNameFromMib2(Integer.valueOf(5)).toDisplayString());
        Assert.assertEquals((Object)"Tunnel0", (Object)get.getInterfaceNameFromMib2(Integer.valueOf(9)).toDisplayString());
        Assert.assertEquals((Object)"Tunnel3", (Object)get.getInterfaceNameFromMib2(Integer.valueOf(10)).toDisplayString());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.140.252.57", port=161, resource="classpath:/linkd/nms0002UkRoFakeLink/r-ro-suce-pict-001.txt")})
    public void testCdpGlobalGroupCollection() throws Exception {
        SnmpAgentConfig config = SnmpPeerFactory.getInstance().getAgentConfig(InetAddress.getByName("10.140.252.57"));
        String trackerName = "cdpGlobalGroup";
        CdpGlobalGroupTracker cdpGlobalGroup = new CdpGlobalGroupTracker();
        try {
            this.m_client.walk(config, (CollectionTracker)cdpGlobalGroup).withDescription(trackerName).withLocation(null).execute().get();
        }
        catch (InterruptedException e) {
            LOG.error("run: Cdp Linkd collection interrupted, exiting", (Throwable)e);
            return;
        }
        Assert.assertEquals((Object)"r-ro-suce-pict-001.infra.u-ssi.net", (Object)cdpGlobalGroup.getCdpDeviceId());
        Assert.assertEquals((long)1L, (long)cdpGlobalGroup.getCdpGlobalRun().intValue());
        Assert.assertNull((Object)cdpGlobalGroup.getCdpGlobalDeviceFormat());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="192.0.2.7", port=161, resource="classpath:/linkd/nms7467/192.0.2.7-walk.txt")})
    public void testCdpGlobalGroupCollectionWithGlobalIdFormat() throws Exception {
        SnmpAgentConfig config = SnmpPeerFactory.getInstance().getAgentConfig(InetAddress.getByName("192.0.2.7"));
        String trackerName = "cdpGlobalGroup";
        CdpGlobalGroupTracker cdpGlobalGroup = new CdpGlobalGroupTracker();
        try {
            this.m_client.walk(config, (CollectionTracker)cdpGlobalGroup).withDescription(trackerName).withLocation(null).execute().get();
        }
        catch (InterruptedException e) {
            LOG.error("run: Cdp Linkd collection interrupted, exiting", (Throwable)e);
            return;
        }
        Assert.assertEquals((Object)"JAB043408B7", (Object)cdpGlobalGroup.getCdpDeviceId());
        Assert.assertEquals((long)1L, (long)cdpGlobalGroup.getCdpGlobalRun().intValue());
        Assert.assertEquals((long)3L, (long)cdpGlobalGroup.getCdpGlobalDeviceFormat().intValue());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.140.252.57", port=161, resource="classpath:/linkd/nms0002UkRoFakeLink/r-ro-suce-pict-001.txt")})
    public void testCdpCacheTableCollection() throws Exception {
        SnmpAgentConfig config = SnmpPeerFactory.getInstance().getAgentConfig(InetAddress.getByName("10.140.252.57"));
        class CdpCacheTableTrackerTester
        extends CdpCacheTableTracker {
            int count = 0;

            CdpCacheTableTrackerTester() {
            }

            public int count() {
                return this.count;
            }
        }
        CdpCacheTableTrackerTester cdpCacheTableTracker = new CdpCacheTableTrackerTester(){
            {
            }

            public void processCdpCacheRow(CdpCacheTableTracker.CdpCacheRow row) {
                ++this.count;
            }
        };
        String trackerName = "cdpCacheTable";
        try {
            this.m_client.walk(config, (CollectionTracker)cdpCacheTableTracker).withDescription(trackerName).withLocation(null).execute().get();
        }
        catch (InterruptedException e) {
            LOG.error("run: Cdp Linkd collection interrupted, exiting", (Throwable)e);
            return;
        }
        Assert.assertEquals((long)14L, (long)cdpCacheTableTracker.count());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.16.10.1", port=161, resource="classpath:/linkd/nms17216/switch1-walk.txt")})
    public void testOspfGeneralGroupWalk() throws Exception {
        SnmpAgentConfig config = SnmpPeerFactory.getInstance().getAgentConfig(InetAddress.getByName("172.16.10.1"));
        String trackerName = "ospfGeneralGroup";
        OspfGeneralGroupTracker ospfGeneralGroup = new OspfGeneralGroupTracker();
        try {
            this.m_client.walk(config, (CollectionTracker)ospfGeneralGroup).withDescription(trackerName).withLocation(null).execute().get();
        }
        catch (InterruptedException e) {
            LOG.error("run: collection interrupted, exiting", (Throwable)e);
            return;
        }
        OspfElement ospfElement = ospfGeneralGroup.getOspfElement();
        Assert.assertEquals((Object)InetAddress.getByName("192.168.100.246"), (Object)ospfElement.getOspfRouterId());
        Assert.assertEquals(null, (Object)ospfElement.getOspfRouterIdNetmask());
        Assert.assertEquals(null, (Object)ospfElement.getOspfRouterIdIfindex());
        Assert.assertEquals((Object)OspfElement.Status.enabled, (Object)ospfElement.getOspfAdminStat());
        Assert.assertEquals((long)2L, (long)ospfElement.getOspfVersionNumber().intValue());
        Assert.assertEquals((Object)OspfElement.TruthValue.FALSE, (Object)ospfElement.getOspfBdrRtrStatus());
        Assert.assertEquals((Object)OspfElement.TruthValue.FALSE, (Object)ospfElement.getOspfASBdrRtrStatus());
        OspfIpAddrTableGetter ipAddrTableGetter = new OspfIpAddrTableGetter(config, this.m_client, null);
        OspfElement ospfElementN = ipAddrTableGetter.get(ospfElement);
        Assert.assertEquals((Object)InetAddress.getByName("192.168.100.246"), (Object)ospfElementN.getOspfRouterId());
        Assert.assertEquals((Object)InetAddress.getByName("255.255.255.252"), (Object)ospfElementN.getOspfRouterIdNetmask());
        Assert.assertEquals((long)10101L, (long)ospfElementN.getOspfRouterIdIfindex().intValue());
        Assert.assertEquals((Object)OspfElement.Status.enabled, (Object)ospfElementN.getOspfAdminStat());
        Assert.assertEquals((long)2L, (long)ospfElementN.getOspfVersionNumber().intValue());
        Assert.assertEquals((Object)OspfElement.TruthValue.FALSE, (Object)ospfElementN.getOspfBdrRtrStatus());
        Assert.assertEquals((Object)OspfElement.TruthValue.FALSE, (Object)ospfElementN.getOspfASBdrRtrStatus());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.16.10.1", port=161, resource="classpath:/linkd/nms17216/switch1-walk.txt")})
    public void testOspfNbrTableWalk() throws Exception {
        SnmpAgentConfig config = SnmpPeerFactory.getInstance().getAgentConfig(InetAddress.getByName("172.16.10.1"));
        String trackerName = "ospfNbrTable";
        OspfNbrTableTracker ospfNbrTableTracker = new OspfNbrTableTracker(){

            public void processOspfNbrRow(OspfNbrTableTracker.OspfNbrRow row) {
                OspfLink link = row.getOspfLink();
                try {
                    Assert.assertEquals((Object)InetAddress.getByName("192.168.100.249"), (Object)link.getOspfRemRouterId());
                    Assert.assertEquals((Object)InetAddress.getByName("192.168.100.245"), (Object)link.getOspfRemIpAddr());
                }
                catch (UnknownHostException e) {
                    e.printStackTrace();
                }
                Assert.assertEquals((long)0L, (long)link.getOspfRemAddressLessIndex().intValue());
            }
        };
        try {
            this.m_client.walk(config, (CollectionTracker)ospfNbrTableTracker).withDescription(trackerName).withLocation(null).execute().get();
        }
        catch (InterruptedException e) {
            LOG.error("run: collection interrupted, exiting", (Throwable)e);
            return;
        }
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.16.10.1", port=161, resource="classpath:/linkd/nms17216/switch1-walk.txt")})
    public void testOspfIfTableWalk() throws Exception {
        SnmpAgentConfig config = SnmpPeerFactory.getInstance().getAgentConfig(InetAddress.getByName("172.16.10.1"));
        String trackerName = "ospfIfTable";
        final ArrayList links = new ArrayList();
        OspfIfTableTracker ospfIfTableTracker = new OspfIfTableTracker(){

            public void processOspfIfRow(OspfIfTableTracker.OspfIfRow row) {
                links.add(row.getOspfLink());
            }
        };
        try {
            this.m_client.walk(config, (CollectionTracker)ospfIfTableTracker).withDescription(trackerName).withLocation(null).execute().get();
        }
        catch (InterruptedException e) {
            LOG.error("run: collection interrupted, exiting", (Throwable)e);
            return;
        }
        OspfIpAddrTableGetter ipAddrTableGetter = new OspfIpAddrTableGetter(config, this.m_client, null);
        for (OspfLink link : links) {
            link = ipAddrTableGetter.get(link);
            Assert.assertEquals((long)0L, (long)link.getOspfAddressLessIndex().intValue());
            if (link.getOspfIpAddr().equals(InetAddress.getByName("192.168.100.246"))) {
                Assert.assertEquals((long)10101L, (long)link.getOspfIfIndex().intValue());
                Assert.assertEquals((Object)InetAddress.getByName("255.255.255.252"), (Object)link.getOspfIpMask());
                continue;
            }
            if (link.getOspfIpAddr().equals(InetAddress.getByName("172.16.10.1"))) {
                Assert.assertEquals((long)10L, (long)link.getOspfIfIndex().intValue());
                Assert.assertEquals((Object)InetAddress.getByName("255.255.255.0"), (Object)link.getOspfIpMask());
                continue;
            }
            if (link.getOspfIpAddr().equals(InetAddress.getByName("172.16.20.1"))) {
                Assert.assertEquals((long)20L, (long)link.getOspfIfIndex().intValue());
                Assert.assertEquals((Object)InetAddress.getByName("255.255.255.0"), (Object)link.getOspfIpMask());
                continue;
            }
            if (link.getOspfIpAddr().equals(InetAddress.getByName("172.16.30.1"))) {
                Assert.assertEquals((long)30L, (long)link.getOspfIfIndex().intValue());
                Assert.assertEquals((Object)InetAddress.getByName("255.255.255.0"), (Object)link.getOspfIpMask());
                continue;
            }
            if (link.getOspfIpAddr().equals(InetAddress.getByName("172.16.40.1"))) {
                Assert.assertEquals((long)40L, (long)link.getOspfIfIndex().intValue());
                Assert.assertEquals((Object)InetAddress.getByName("255.255.255.0"), (Object)link.getOspfIpMask());
                continue;
            }
            Assert.assertEquals((Object)false, (Object)true);
        }
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.103.1.1", port=161, resource="classpath:/linkd/nms7777dw/dw-walk.txt")})
    public void testLldpDragonWaveLocalGroupWalk() throws Exception {
        String trackerName = "lldpLocalGroup";
        SnmpAgentConfig config = SnmpPeerFactory.getInstance().getAgentConfig(InetAddress.getByName("10.103.1.1"));
        LldpLocalGroupTracker lldpLocalGroup = new LldpLocalGroupTracker();
        try {
            this.m_client.walk(config, (CollectionTracker)lldpLocalGroup).withDescription(trackerName).withLocation(null).execute().get();
        }
        catch (InterruptedException e) {
            LOG.error("run: collection interrupted, exiting", (Throwable)e);
            return;
        }
        LldpElement eiA = lldpLocalGroup.getLldpElement();
        System.err.println("local chassis type: " + LldpUtils.LldpChassisIdSubType.getTypeString((Integer)eiA.getLldpChassisIdSubType().getValue()));
        System.err.println("local chassis id: " + eiA.getLldpChassisId());
        System.err.println("local sysname: " + eiA.getLldpSysname());
        Assert.assertEquals((Object)"cf", (Object)eiA.getLldpChassisId());
        Assert.assertEquals((Object)LldpUtils.LldpChassisIdSubType.LLDP_CHASSISID_SUBTYPE_CHASSISCOMPONENT, (Object)eiA.getLldpChassisIdSubType());
        Assert.assertEquals((Object)"NuDesign", (Object)eiA.getLldpSysname());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.103.1.1", port=161, resource="classpath:/linkd/nms7777dw/dw-walk.txt")})
    public void testLldpDragonWaveLldpLocGetter() throws Exception {
        SnmpAgentConfig config = SnmpPeerFactory.getInstance().getAgentConfig(InetAddress.getByName("10.103.1.1"));
        LldpLocPortGetter lldpLocPort = new LldpLocPortGetter(config, this.m_client, null);
        LldpLink link = new LldpLink();
        link.setLldpLocalPortNum(Integer.valueOf(1));
        link = lldpLocPort.getLldpLink(link);
        Assert.assertEquals((long)1L, (long)link.getLldpLocalPortNum().intValue());
        Assert.assertEquals((Object)"cf", (Object)link.getLldpPortId());
        Assert.assertEquals((Object)"NuDesign", (Object)link.getLldpPortDescr());
        Assert.assertEquals((Object)LldpUtils.LldpPortIdSubType.LLDP_PORTID_SUBTYPE_INTERFACEALIAS, (Object)link.getLldpPortIdSubType());
    }

    @Test
    @JUnitSnmpAgent(host="10.103.1.1", port=161, resource="classpath:/linkd/nms7777dw/dw-walk.txt")
    public void testLldpDragonWaveRemTableWalk() throws Exception {
        SnmpAgentConfig config = SnmpPeerFactory.getInstance().getAgentConfig(InetAddress.getByName("10.103.1.1"));
        LldpRemTableTracker lldpRemTable = new LldpRemTableTracker(){

            public void processLldpRemRow(LldpRemTableTracker.LldpRemRow row) {
                System.err.println("----------lldp rem----------------");
                System.err.println("columns number in the row: " + row.getColumnCount());
                Assert.assertEquals((long)6L, (long)row.getColumnCount());
                LldpLink link = row.getLldpLink();
                Assert.assertEquals((long)1L, (long)row.getLldpRemLocalPortNum().intValue());
                System.err.println("local port number: " + row.getLldpRemLocalPortNum());
                Assert.assertEquals((Object)LldpUtils.LldpChassisIdSubType.LLDP_CHASSISID_SUBTYPE_CHASSISCOMPONENT, (Object)link.getLldpRemChassisIdSubType());
                System.err.println("remote chassis type: " + LldpUtils.LldpChassisIdSubType.getTypeString((Integer)link.getLldpRemChassisIdSubType().getValue()));
                Assert.assertEquals((Object)"cf", (Object)link.getLldpRemChassisId());
                System.err.println("remote chassis: " + link.getLldpRemChassisId());
                Assert.assertEquals((Object)LldpUtils.LldpPortIdSubType.LLDP_PORTID_SUBTYPE_INTERFACEALIAS, (Object)link.getLldpRemPortIdSubType());
                System.err.println("remote port type: " + LldpUtils.LldpPortIdSubType.getTypeString((Integer)link.getLldpRemPortIdSubType().getValue()));
                Assert.assertEquals((Object)"cf", (Object)link.getLldpRemPortId());
                System.err.println("remote port id: " + link.getLldpRemPortId());
                Assert.assertEquals((Object)"NuDesign", (Object)link.getLldpRemPortDescr());
                System.err.println("remote port descr: " + link.getLldpRemPortDescr());
                Assert.assertEquals((Object)"NuDesign", (Object)link.getLldpRemSysname());
                System.err.println("remote sysname: " + link.getLldpRemSysname());
            }
        };
        String trackerName = "lldpRemTable";
        try {
            this.m_client.walk(config, (CollectionTracker)lldpRemTable).withDescription(trackerName).withLocation(null).execute().get();
        }
        catch (InterruptedException e) {
            Assert.assertEquals((Object)false, (Object)true);
        }
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.16.10.1", port=161, resource="classpath:/linkd/nms17216/switch1-walk.txt")})
    public void testLldpLocalGroupWalk() throws Exception {
        String trackerName = "lldpLocalGroup";
        SnmpAgentConfig config = SnmpPeerFactory.getInstance().getAgentConfig(InetAddress.getByName("172.16.10.1"));
        LldpLocalGroupTracker lldpLocalGroup = new LldpLocalGroupTracker();
        try {
            this.m_client.walk(config, (CollectionTracker)lldpLocalGroup).withDescription(trackerName).withLocation(null).execute().get();
        }
        catch (InterruptedException e) {
            LOG.error("run: collection interrupted, exiting", (Throwable)e);
            return;
        }
        LldpElement eiA = lldpLocalGroup.getLldpElement();
        System.err.println("local chassis type: " + LldpUtils.LldpChassisIdSubType.getTypeString((Integer)eiA.getLldpChassisIdSubType().getValue()));
        System.err.println("local chassis id: " + eiA.getLldpChassisId());
        System.err.println("local sysname: " + eiA.getLldpSysname());
        Assert.assertEquals((Object)"0016c8bd4d80", (Object)eiA.getLldpChassisId());
        Assert.assertEquals((Object)LldpUtils.LldpChassisIdSubType.LLDP_CHASSISID_SUBTYPE_MACADDRESS, (Object)eiA.getLldpChassisIdSubType());
        Assert.assertEquals((Object)"Switch1", (Object)eiA.getLldpSysname());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.16.10.1", port=161, resource="classpath:/linkd/nms17216/switch1-walk.txt")})
    public void testLldpLocGetter() throws Exception {
        SnmpAgentConfig config = SnmpPeerFactory.getInstance().getAgentConfig(InetAddress.getByName("172.16.10.1"));
        LldpLocPortGetter lldpLocPort = new LldpLocPortGetter(config, this.m_client, null);
        LldpLink link = new LldpLink();
        link.setLldpLocalPortNum(Integer.valueOf(9));
        link = lldpLocPort.getLldpLink(link);
        Assert.assertEquals((long)9L, (long)link.getLldpLocalPortNum().intValue());
        Assert.assertEquals((Object)"Gi0/9", (Object)link.getLldpPortId());
        Assert.assertEquals((Object)"GigabitEthernet0/9", (Object)link.getLldpPortDescr());
        Assert.assertEquals((Object)LldpUtils.LldpPortIdSubType.LLDP_PORTID_SUBTYPE_INTERFACENAME, (Object)link.getLldpPortIdSubType());
        link = new LldpLink();
        link.setLldpLocalPortNum(Integer.valueOf(10));
        link = lldpLocPort.getLldpLink(link);
        Assert.assertEquals((long)10L, (long)link.getLldpLocalPortNum().intValue());
        Assert.assertEquals((Object)"Gi0/10", (Object)link.getLldpPortId());
        Assert.assertEquals((Object)"GigabitEthernet0/10", (Object)link.getLldpPortDescr());
        Assert.assertEquals((Object)LldpUtils.LldpPortIdSubType.LLDP_PORTID_SUBTYPE_INTERFACENAME, (Object)link.getLldpPortIdSubType());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.16.10.2", port=161, resource="classpath:/linkd/nms17216/switch2-walk.txt")})
    public void test2LldpLocGetter() throws Exception {
        SnmpAgentConfig config = SnmpPeerFactory.getInstance().getAgentConfig(InetAddress.getByName("172.16.10.2"));
        LldpLocPortGetter lldpLocPort = new LldpLocPortGetter(config, this.m_client, null);
        LldpLink link = new LldpLink();
        link.setLldpLocalPortNum(Integer.valueOf(1));
        link = lldpLocPort.getLldpLink(link);
        Assert.assertEquals((long)1L, (long)link.getLldpLocalPortNum().intValue());
        Assert.assertEquals((Object)"Gi0/1", (Object)link.getLldpPortId());
        Assert.assertEquals((Object)"GigabitEthernet0/1", (Object)link.getLldpPortDescr());
        Assert.assertEquals((Object)LldpUtils.LldpPortIdSubType.LLDP_PORTID_SUBTYPE_INTERFACENAME, (Object)link.getLldpPortIdSubType());
        link = new LldpLink();
        link.setLldpLocalPortNum(Integer.valueOf(2));
        link = lldpLocPort.getLldpLink(link);
        Assert.assertEquals((long)2L, (long)link.getLldpLocalPortNum().intValue());
        Assert.assertEquals((Object)"Gi0/2", (Object)link.getLldpPortId());
        Assert.assertEquals((Object)"GigabitEthernet0/2", (Object)link.getLldpPortDescr());
        Assert.assertEquals((Object)LldpUtils.LldpPortIdSubType.LLDP_PORTID_SUBTYPE_INTERFACENAME, (Object)link.getLldpPortIdSubType());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.16.10.2", port=161, resource="classpath:/linkd/nms17216/switch2-walk.txt")})
    public void test3LldpRemoteTableWalk() throws Exception {
        SnmpAgentConfig config = SnmpPeerFactory.getInstance().getAgentConfig(InetAddress.getByName("172.16.10.2"));
        final ArrayList links = new ArrayList();
        LldpRemTableTracker lldpRemTable = new LldpRemTableTracker(){

            public void processLldpRemRow(LldpRemTableTracker.LldpRemRow row) {
                links.add(row.getLldpLink());
            }
        };
        try {
            this.m_client.walk(config, (CollectionTracker)lldpRemTable).withDescription("lldpRemTable").withLocation(null).execute().get();
        }
        catch (ExecutionException e) {
            LOG.error("run: collection failed, exiting", (Throwable)e);
            return;
        }
        catch (InterruptedException e) {
            LOG.error("run: collection interrupted, exiting", (Throwable)e);
            return;
        }
        LldpLocPortGetter lldpLocPort = new LldpLocPortGetter(config, this.m_client, null);
        for (LldpLink link : links) {
            Assert.assertNotNull((Object)link);
            Assert.assertNotNull((Object)link.getLldpLocalPortNum());
            Assert.assertNull((Object)link.getLldpPortId());
            Assert.assertNull((Object)link.getLldpPortIdSubType());
            Assert.assertNull((Object)link.getLldpPortDescr());
            LldpLink updated = lldpLocPort.getLldpLink(link);
            Assert.assertNotNull((Object)updated.getLldpPortId());
            Assert.assertEquals((long)5L, (long)updated.getLldpPortIdSubType().getValue().intValue());
            Assert.assertNotNull((Object)updated.getLldpPortDescr());
        }
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.16.10.1", port=161, resource="classpath:/linkd/nms17216/switch1-walk.txt")})
    public void testLldpRemTableWalk() throws Exception {
        SnmpAgentConfig config = SnmpPeerFactory.getInstance().getAgentConfig(InetAddress.getByName("172.16.10.1"));
        LldpRemTableTracker lldpRemTable = new LldpRemTableTracker(){

            public void processLldpRemRow(LldpRemTableTracker.LldpRemRow row) {
                System.err.println("----------lldp rem----------------");
                System.err.println("columns number in the row: " + row.getColumnCount());
                Assert.assertEquals((long)6L, (long)row.getColumnCount());
                LldpLink link = row.getLldpLink();
                System.err.println("local port number: " + row.getLldpRemLocalPortNum());
                System.err.println("remote chassis: " + link.getLldpRemChassisId());
                System.err.println("remote chassis type: " + LldpUtils.LldpChassisIdSubType.getTypeString((Integer)link.getLldpRemChassisIdSubType().getValue()));
                Assert.assertEquals((Object)LldpUtils.LldpChassisIdSubType.LLDP_CHASSISID_SUBTYPE_MACADDRESS, (Object)link.getLldpRemChassisIdSubType());
                System.err.println("remote port id: " + link.getLldpRemPortId());
                System.err.println("remote port type: " + LldpUtils.LldpPortIdSubType.getTypeString((Integer)link.getLldpRemPortIdSubType().getValue()));
                Assert.assertEquals((Object)LldpUtils.LldpPortIdSubType.LLDP_PORTID_SUBTYPE_INTERFACENAME, (Object)link.getLldpRemPortIdSubType());
            }
        };
        try {
            this.m_client.walk(config, (CollectionTracker)lldpRemTable).withDescription("lldpRemTable").withLocation(null).execute().get();
        }
        catch (InterruptedException e) {
            Assert.assertEquals((Object)false, (Object)true);
        }
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="192.168.239.54", port=161, resource="classpath:/linkd/nms0001/siegfrie-192.168.239.54-walk.txt")})
    public void testIsisSysObjectWalk() throws Exception {
        String trackerName = "isisSysObject";
        SnmpAgentConfig config = SnmpPeerFactory.getInstance().getAgentConfig(InetAddress.getByName("192.168.239.54"));
        IsisSysObjectGroupTracker tracker = new IsisSysObjectGroupTracker();
        try {
            this.m_client.walk(config, (CollectionTracker)tracker).withDescription(trackerName).withLocation(null).execute().get();
        }
        catch (InterruptedException e) {
            LOG.error("run: collection interrupted, exiting", (Throwable)e);
            return;
        }
        IsIsElement eiA = tracker.getIsisElement();
        System.err.println("Is-Is Sys Id: " + eiA.getIsisSysID());
        System.err.println("Is-Is Sys Admin State: " + IsIsElement.IsisAdminState.getTypeString((Integer)eiA.getIsisSysAdminState().getValue()));
        Assert.assertEquals((Object)"000110255054", (Object)eiA.getIsisSysID());
        Assert.assertEquals((Object)IsIsElement.IsisAdminState.on, (Object)eiA.getIsisSysAdminState());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="192.168.239.54", port=161, resource="classpath:/linkd/nms0001/siegfrie-192.168.239.54-walk.txt")})
    public void testIsisISAdjTableWalk() throws Exception {
        final ArrayList links = new ArrayList();
        String trackerName = "isisISAdjTable";
        SnmpAgentConfig config = SnmpPeerFactory.getInstance().getAgentConfig(InetAddress.getByName("192.168.239.54"));
        IsisISAdjTableTracker tracker = new IsisISAdjTableTracker(){

            public void processIsisAdjRow(IsisISAdjTableTracker.IsIsAdjRow row) {
                Assert.assertEquals((long)5L, (long)row.getColumnCount());
                links.add(row.getIsisLink());
            }
        };
        try {
            this.m_client.walk(config, (CollectionTracker)tracker).withDescription(trackerName).withLocation(null).execute().get();
        }
        catch (InterruptedException e) {
            LOG.error("run: collection interrupted, exiting", (Throwable)e);
            return;
        }
        Assert.assertEquals((long)2L, (long)links.size());
        for (IsIsLink link : links) {
            Assert.assertEquals((long)1L, (long)link.getIsisISAdjIndex().intValue());
            Assert.assertEquals((Object)IsIsLink.IsisISAdjState.up, (Object)link.getIsisISAdjState());
            Assert.assertEquals((Object)IsIsLink.IsisISAdjNeighSysType.l1_IntermediateSystem, (Object)link.getIsisISAdjNeighSysType());
            Assert.assertEquals((long)0L, (long)link.getIsisISAdjNbrExtendedCircID().intValue());
            if (link.getIsisCircIndex() == 533) {
                Assert.assertEquals((Object)"001f12accbf0", (Object)link.getIsisISAdjNeighSNPAAddress());
                Assert.assertEquals((Object)"000110255062", (Object)link.getIsisISAdjNeighSysID());
                continue;
            }
            if (link.getIsisCircIndex() == 552) {
                Assert.assertEquals((Object)"0021590e47c2", (Object)link.getIsisISAdjNeighSNPAAddress());
                Assert.assertEquals((Object)"000110088500", (Object)link.getIsisISAdjNeighSysID());
                continue;
            }
            Assert.assertEquals((Object)true, (Object)false);
        }
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="192.168.239.54", port=161, resource="classpath:/linkd/nms0001/siegfrie-192.168.239.54-walk.txt")})
    public void testIsisCircTableWalk() throws Exception {
        final ArrayList links = new ArrayList();
        String trackerName = "isisCircTable";
        SnmpAgentConfig config = SnmpPeerFactory.getInstance().getAgentConfig(InetAddress.getByName("192.168.239.54"));
        IsisCircTableTracker tracker = new IsisCircTableTracker(){

            public void processIsisCircRow(IsisCircTableTracker.IsIsCircRow row) {
                Assert.assertEquals((long)2L, (long)row.getColumnCount());
                links.add(row.getIsisLink());
            }
        };
        try {
            this.m_client.walk(config, (CollectionTracker)tracker).withDescription(trackerName).withLocation(null).execute().get();
        }
        catch (InterruptedException e) {
            LOG.error("run: collection interrupted, exiting", (Throwable)e);
            return;
        }
        Assert.assertEquals((long)12L, (long)links.size());
        for (IsIsLink link : links) {
            if (link.getIsisCircIndex() == 533) {
                Assert.assertEquals((long)533L, (long)link.getIsisCircIfIndex().intValue());
                Assert.assertEquals((Object)IsIsElement.IsisAdminState.on, (Object)link.getIsisCircAdminState());
                continue;
            }
            if (link.getIsisCircIndex() == 552) {
                Assert.assertEquals((long)552L, (long)link.getIsisCircIfIndex().intValue());
                Assert.assertEquals((Object)IsIsElement.IsisAdminState.on, (Object)link.getIsisCircAdminState());
                continue;
            }
            if (link.getIsisCircIndex() == 13) {
                Assert.assertEquals((long)13L, (long)link.getIsisCircIfIndex().intValue());
                Assert.assertEquals((Object)IsIsElement.IsisAdminState.off, (Object)link.getIsisCircAdminState());
                continue;
            }
            if (link.getIsisCircIndex() == 16) {
                Assert.assertEquals((long)16L, (long)link.getIsisCircIfIndex().intValue());
                Assert.assertEquals((Object)IsIsElement.IsisAdminState.on, (Object)link.getIsisCircAdminState());
                continue;
            }
            if (link.getIsisCircIndex() == 504) {
                Assert.assertEquals((long)504L, (long)link.getIsisCircIfIndex().intValue());
                Assert.assertEquals((Object)IsIsElement.IsisAdminState.on, (Object)link.getIsisCircAdminState());
                continue;
            }
            if (link.getIsisCircIndex() == 507) {
                Assert.assertEquals((long)507L, (long)link.getIsisCircIfIndex().intValue());
                Assert.assertEquals((Object)IsIsElement.IsisAdminState.on, (Object)link.getIsisCircAdminState());
                continue;
            }
            if (link.getIsisCircIndex() == 508) {
                Assert.assertEquals((long)508L, (long)link.getIsisCircIfIndex().intValue());
                Assert.assertEquals((Object)IsIsElement.IsisAdminState.on, (Object)link.getIsisCircAdminState());
                continue;
            }
            if (link.getIsisCircIndex() == 512) {
                Assert.assertEquals((long)512L, (long)link.getIsisCircIfIndex().intValue());
                Assert.assertEquals((Object)IsIsElement.IsisAdminState.on, (Object)link.getIsisCircAdminState());
                continue;
            }
            if (link.getIsisCircIndex() == 514) {
                Assert.assertEquals((long)514L, (long)link.getIsisCircIfIndex().intValue());
                Assert.assertEquals((Object)IsIsElement.IsisAdminState.on, (Object)link.getIsisCircAdminState());
                continue;
            }
            if (link.getIsisCircIndex() == 531) {
                Assert.assertEquals((long)531L, (long)link.getIsisCircIfIndex().intValue());
                Assert.assertEquals((Object)IsIsElement.IsisAdminState.on, (Object)link.getIsisCircAdminState());
                continue;
            }
            if (link.getIsisCircIndex() == 572) {
                Assert.assertEquals((long)572L, (long)link.getIsisCircIfIndex().intValue());
                Assert.assertEquals((Object)IsIsElement.IsisAdminState.on, (Object)link.getIsisCircAdminState());
                continue;
            }
            if (link.getIsisCircIndex() == 573) {
                Assert.assertEquals((long)573L, (long)link.getIsisCircIfIndex().intValue());
                Assert.assertEquals((Object)IsIsElement.IsisAdminState.on, (Object)link.getIsisCircAdminState());
                continue;
            }
            Assert.assertEquals((Object)true, (Object)false);
        }
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="192.168.0.1", port=161, resource="classpath:/linkd/nms102/mikrotik-192.168.0.1-walk.txt")})
    public void testIpNetToMediaTableWalk() throws Exception {
        final ArrayList rows = new ArrayList();
        String trackerName = "ipNetToMediaTable";
        SnmpAgentConfig config = SnmpPeerFactory.getInstance().getAgentConfig(InetAddress.getByName("192.168.0.1"));
        IpNetToMediaTableTracker tracker = new IpNetToMediaTableTracker(){

            public void processIpNetToMediaRow(IpNetToMediaTableTracker.IpNetToMediaRow row) {
                rows.add(row.getIpNetToMedia());
            }
        };
        try {
            this.m_client.walk(config, (CollectionTracker)tracker).withDescription(trackerName).withLocation(null).execute().get();
        }
        catch (InterruptedException e) {
            LOG.error("run: collection interrupted, exiting", (Throwable)e);
            return;
        }
        Assert.assertEquals((long)6L, (long)rows.size());
        for (IpNetToMedia row : rows) {
            Assert.assertEquals((Object)IpNetToMedia.IpNetToMediaType.IPNETTOMEDIA_TYPE_DYNAMIC, (Object)row.getIpNetToMediaType());
            if (row.getPhysAddress().equals("00901a4222f8")) {
                Assert.assertEquals((Object)InetAddressUtils.addr((String)"10.129.16.1"), (Object)row.getNetAddress());
                Assert.assertEquals((long)1L, (long)row.getSourceIfIndex().intValue());
                continue;
            }
            if (row.getPhysAddress().equals("0013c8f1d242")) {
                Assert.assertEquals((Object)InetAddressUtils.addr((String)"10.129.16.164"), (Object)row.getNetAddress());
                Assert.assertEquals((long)1L, (long)row.getSourceIfIndex().intValue());
                continue;
            }
            if (row.getPhysAddress().equals("f0728c99994d")) {
                Assert.assertEquals((Object)InetAddressUtils.addr((String)"192.168.0.13"), (Object)row.getNetAddress());
                Assert.assertEquals((long)2L, (long)row.getSourceIfIndex().intValue());
                continue;
            }
            if (row.getPhysAddress().equals("0015999f07ef")) {
                Assert.assertEquals((Object)InetAddressUtils.addr((String)"192.168.0.14"), (Object)row.getNetAddress());
                Assert.assertEquals((long)2L, (long)row.getSourceIfIndex().intValue());
                continue;
            }
            if (row.getPhysAddress().equals("60334b0817a8")) {
                Assert.assertEquals((Object)InetAddressUtils.addr((String)"192.168.0.16"), (Object)row.getNetAddress());
                Assert.assertEquals((long)2L, (long)row.getSourceIfIndex().intValue());
                continue;
            }
            if (row.getPhysAddress().equals("001b63cda9fd")) {
                Assert.assertEquals((Object)InetAddressUtils.addr((String)"192.168.0.17"), (Object)row.getNetAddress());
                Assert.assertEquals((long)2L, (long)row.getSourceIfIndex().intValue());
                continue;
            }
            Assert.assertEquals((Object)false, (Object)true);
        }
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.1.1.2", port=161, resource="classpath:/linkd/nms4930/dlink_DES-3026.properties")})
    public void testDot1dBaseWalk() throws Exception {
        String trackerName = "dot1dbase";
        SnmpAgentConfig config = SnmpPeerFactory.getInstance().getAgentConfig(InetAddress.getByName("10.1.1.2"));
        Dot1dBaseTracker tracker = new Dot1dBaseTracker();
        try {
            this.m_client.walk(config, (CollectionTracker)tracker).withDescription(trackerName).withLocation(null).execute().get();
        }
        catch (InterruptedException e) {
            LOG.error("run: collection interrupted, exiting", (Throwable)e);
            return;
        }
        BridgeElement bridge = tracker.getBridgeElement();
        Assert.assertEquals((Object)"001e58a32fcd", (Object)bridge.getBaseBridgeAddress());
        Assert.assertEquals((long)26L, (long)bridge.getBaseNumPorts().intValue());
        Assert.assertEquals((Object)BridgeElement.BridgeDot1dBaseType.DOT1DBASETYPE_TRANSPARENT_ONLY, (Object)bridge.getBaseType());
        Assert.assertEquals((Object)BridgeElement.BridgeDot1dStpProtocolSpecification.DOT1D_STP_PROTOCOL_SPECIFICATION_IEEE8021D, (Object)bridge.getStpProtocolSpecification());
        Assert.assertEquals((long)32768L, (long)bridge.getStpPriority().intValue());
        Assert.assertEquals((Object)"0000000000000000", (Object)bridge.getStpDesignatedRoot());
        Assert.assertEquals((long)0L, (long)bridge.getStpRootCost().intValue());
        Assert.assertEquals((long)0L, (long)bridge.getStpRootPort().intValue());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.1.1.2", port=161, resource="classpath:/linkd/nms4930/dlink_DES-3026.properties")})
    public void testDot1dBasePortTableWalk() throws Exception {
        String trackerName = "dot1dbasePortTable";
        final ArrayList rows = new ArrayList();
        SnmpAgentConfig config = SnmpPeerFactory.getInstance().getAgentConfig(InetAddress.getByName("10.1.1.2"));
        Dot1dBasePortTableTracker tracker = new Dot1dBasePortTableTracker(){

            public void processDot1dBasePortRow(Dot1dBasePortTableTracker.Dot1dBasePortRow row) {
                rows.add(row);
            }
        };
        try {
            this.m_client.walk(config, (CollectionTracker)tracker).withDescription(trackerName).withLocation(null).execute().get();
        }
        catch (InterruptedException e) {
            LOG.error("run: collection interrupted, exiting", (Throwable)e);
            return;
        }
        Assert.assertEquals((long)26L, (long)rows.size());
        for (Dot1dBasePortTableTracker.Dot1dBasePortRow row : rows) {
            Assert.assertEquals((long)row.getBaseBridgePort().intValue(), (long)row.getBaseBridgePortIfindex().intValue());
        }
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.1.1.2", port=161, resource="classpath:/linkd/nms4930/dlink_DES-3026.properties")})
    public void testDot1dStpPortTableWalk() throws Exception {
        String trackerName = "dot1dbaseStpTable";
        final ArrayList links = new ArrayList();
        SnmpAgentConfig config = SnmpPeerFactory.getInstance().getAgentConfig(InetAddress.getByName("10.1.1.2"));
        Dot1dStpPortTableTracker tracker = new Dot1dStpPortTableTracker(){

            public void processDot1dStpPortRow(Dot1dStpPortTableTracker.Dot1dStpPortRow row) {
                links.add(row.getLink());
            }
        };
        try {
            this.m_client.walk(config, (CollectionTracker)tracker).withDescription(trackerName).withLocation(null).execute().get();
        }
        catch (InterruptedException e) {
            LOG.error("run: collection interrupted, exiting", (Throwable)e);
            return;
        }
        Assert.assertEquals((long)26L, (long)links.size());
        int i = 0;
        for (BridgeStpLink link : links) {
            Assert.assertEquals((long)(++i), (long)link.getStpPort().intValue());
            Assert.assertEquals((long)128L, (long)link.getStpPortPriority().intValue());
            if (link.getStpPort() <= 6 || link.getStpPort() == 24) {
                Assert.assertEquals((Object)BridgeStpLink.BridgeDot1dStpPortState.DOT1D_STP_PORT_STATUS_FORWARDING, (Object)link.getStpPortState());
            } else {
                Assert.assertEquals((Object)BridgeStpLink.BridgeDot1dStpPortState.DOT1D_STP_PORT_STATUS_DISABLED, (Object)link.getStpPortState());
            }
            Assert.assertEquals((Object)BridgeStpLink.BridgeDot1dStpPortEnable.DOT1D_STP_PORT_ENABLED, (Object)link.getStpPortEnable());
            Assert.assertEquals((long)2000000L, (long)link.getStpPortPathCost().intValue());
            Assert.assertEquals((Object)"0000000000000000", (Object)link.getDesignatedRoot());
            Assert.assertEquals((long)0L, (long)link.getDesignatedCost().intValue());
            Assert.assertEquals((Object)"0000000000000000", (Object)link.getDesignatedBridge());
            Assert.assertEquals((Object)"0000", (Object)link.getDesignatedPort());
        }
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.1.1.2", port=161, resource="classpath:/linkd/nms4930/dlink_DES-3026.properties")})
    public void testDot1dTpFdbTableWalk() throws Exception {
        String trackerName = "dot1dTpFdbTable";
        final ArrayList links = new ArrayList();
        SnmpAgentConfig config = SnmpPeerFactory.getInstance().getAgentConfig(InetAddress.getByName("10.1.1.2"));
        Dot1dTpFdbTableTracker tracker = new Dot1dTpFdbTableTracker(){

            public void processDot1dTpFdbRow(Dot1dTpFdbTableTracker.Dot1dTpFdbRow row) {
                links.add(row.getLink());
            }
        };
        try {
            this.m_client.walk(config, (CollectionTracker)tracker).withDescription(trackerName).withLocation(null).execute().get();
        }
        catch (InterruptedException e) {
            LOG.error("run: collection interrupted, exiting", (Throwable)e);
            return;
        }
        Assert.assertEquals((long)17L, (long)links.size());
        for (BridgeMacLink link : links) {
            Assert.assertEquals((Object)BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED, (Object)link.getBridgeDot1qTpFdbStatus());
            System.out.println(link.getMacAddress());
            if (link.getMacAddress().equals("000c29dcc076")) {
                Assert.assertEquals((long)24L, (long)link.getBridgePort().intValue());
                continue;
            }
            if (link.getMacAddress().equals("000ffeb10d1e")) {
                Assert.assertEquals((long)6L, (long)link.getBridgePort().intValue());
                continue;
            }
            if (link.getMacAddress().equals("000ffeb10e26")) {
                Assert.assertEquals((long)6L, (long)link.getBridgePort().intValue());
                continue;
            }
            if (link.getMacAddress().equals("001a4b802790")) {
                Assert.assertEquals((long)6L, (long)link.getBridgePort().intValue());
                continue;
            }
            if (link.getMacAddress().equals("001d6004acbc")) {
                Assert.assertEquals((long)6L, (long)link.getBridgePort().intValue());
                continue;
            }
            if (link.getMacAddress().equals("001e58865d0f")) {
                Assert.assertEquals((long)6L, (long)link.getBridgePort().intValue());
                continue;
            }
            if (link.getMacAddress().equals("0021913b5108")) {
                Assert.assertEquals((long)6L, (long)link.getBridgePort().intValue());
                continue;
            }
            if (link.getMacAddress().equals("002401ad3416")) {
                Assert.assertEquals((long)6L, (long)link.getBridgePort().intValue());
                continue;
            }
            if (link.getMacAddress().equals("00248c4c8bd0")) {
                Assert.assertEquals((long)6L, (long)link.getBridgePort().intValue());
                continue;
            }
            if (link.getMacAddress().equals("0024d608693e")) {
                Assert.assertEquals((long)6L, (long)link.getBridgePort().intValue());
                continue;
            }
            if (link.getMacAddress().equals("000ffeb10d1e")) {
                Assert.assertEquals((long)6L, (long)link.getBridgePort().intValue());
                continue;
            }
            if (link.getMacAddress().equals("1caff737cc33")) {
                Assert.assertEquals((long)6L, (long)link.getBridgePort().intValue());
                continue;
            }
            if (link.getMacAddress().equals("1caff7443339")) {
                Assert.assertEquals((long)6L, (long)link.getBridgePort().intValue());
                continue;
            }
            if (link.getMacAddress().equals("1cbdb9b56160")) {
                Assert.assertEquals((long)6L, (long)link.getBridgePort().intValue());
                continue;
            }
            if (link.getMacAddress().equals("5cd998667abb")) {
                Assert.assertEquals((long)6L, (long)link.getBridgePort().intValue());
                continue;
            }
            if (link.getMacAddress().equals("e0cb4e3e7fc0")) {
                Assert.assertEquals((long)6L, (long)link.getBridgePort().intValue());
                continue;
            }
            if (link.getMacAddress().equals("f07d68711f89")) {
                Assert.assertEquals((long)24L, (long)link.getBridgePort().intValue());
                continue;
            }
            if (link.getMacAddress().equals("f07d6876c565")) {
                Assert.assertEquals((long)24L, (long)link.getBridgePort().intValue());
                continue;
            }
            Assert.assertEquals((Object)false, (Object)true);
        }
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.1.1.2", port=161, resource="classpath:/linkd/nms4930/dlink_DES-3026.properties"), @JUnitSnmpAgent(host="10.1.2.2", port=161, resource="classpath:/linkd/nms4930/dlink_DGS-3612G.properties")})
    public void testDot1qTpFdbTableWalk() throws Exception {
        String trackerName = "dot1qTpFdbTable";
        final HashMap macs1 = new HashMap();
        final HashMap macs2 = new HashMap();
        SnmpAgentConfig config1 = SnmpPeerFactory.getInstance().getAgentConfig(InetAddress.getByName("10.1.1.2"));
        Dot1qTpFdbTableTracker tracker1 = new Dot1qTpFdbTableTracker(){

            public void processDot1qTpFdbRow(Dot1qTpFdbTableTracker.Dot1qTpFdbRow row) {
                macs1.put(row.getDot1qTpFdbAddress(), row.getDot1qTpFdbPort());
            }
        };
        try {
            this.m_client.walk(config1, (CollectionTracker)tracker1).withDescription(trackerName).withLocation(null).execute().get();
        }
        catch (InterruptedException e) {
            LOG.error("run: collection interrupted, exiting", (Throwable)e);
            return;
        }
        SnmpAgentConfig config2 = SnmpPeerFactory.getInstance().getAgentConfig(InetAddress.getByName("10.1.2.2"));
        Dot1qTpFdbTableTracker tracker2 = new Dot1qTpFdbTableTracker(){

            public void processDot1qTpFdbRow(Dot1qTpFdbTableTracker.Dot1qTpFdbRow row) {
                macs2.put(row.getDot1qTpFdbAddress(), row.getDot1qTpFdbPort());
            }
        };
        try {
            this.m_client.walk(config2, (CollectionTracker)tracker2).withDescription(trackerName).withLocation(null).execute().get();
        }
        catch (InterruptedException e) {
            LOG.error("run: collection interrupted, exiting", (Throwable)e);
            return;
        }
        Assert.assertEquals((long)59L, (long)macs1.size());
        Assert.assertEquals((long)979L, (long)macs2.size());
        for (Map.Entry entry : macs1.entrySet()) {
            if (macs2.containsKey(entry.getKey())) {
                System.out.println("-----------mac on 1 learned on 2 port-----------------");
                System.out.println("Mac: " + (String)entry.getKey());
                System.out.println("learned on PortOn1: " + entry.getValue());
                System.out.println("learned on PortOn2: " + macs2.get(entry.getKey()));
                continue;
            }
            System.out.println("-----------mac found on 1 not learned on 2 port-----------------");
            System.out.println("Mac: " + (String)entry.getKey());
            System.out.println("learned on PortOn1: " + entry.getValue());
        }
        for (Map.Entry entry : macs2.entrySet()) {
            if (!macs1.containsKey(entry.getKey())) continue;
            System.out.println("-----------mac on 2 learned on 1 port-----------------");
            System.out.println("Mac: " + (String)entry.getKey());
            System.out.println("learned on PortOn2: " + entry.getValue());
            System.out.println("learned on PortOn1: " + macs1.get(entry.getKey()));
        }
    }
}

