/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.io.Serializable;
import java.net.InetAddress;
import org.junit.After;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.opennms.netmgt.collectd.DefaultCollectionAgent;
import org.opennms.netmgt.collectd.SnmpCollectionAgent;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.springframework.transaction.PlatformTransactionManager;

public class DefaultCollectionAgentTest {
    @After
    public void tearDown() {
        SnmpPeerFactory.setInstance(null);
    }

    @Test
    public void canGetLocationAwareAgentConfig() {
        SnmpPeerFactory snmpPeerFactory = (SnmpPeerFactory)Mockito.mock(SnmpPeerFactory.class);
        SnmpPeerFactory.setInstance((SnmpPeerFactory)snmpPeerFactory);
        Integer ifaceId = 1;
        IpInterfaceDao ifaceDao = (IpInterfaceDao)Mockito.mock(IpInterfaceDao.class);
        PlatformTransactionManager transMgr = (PlatformTransactionManager)Mockito.mock(PlatformTransactionManager.class);
        OnmsIpInterface ipIface = (OnmsIpInterface)Mockito.mock(OnmsIpInterface.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)ifaceDao.load((Serializable)ifaceId)).thenReturn((Object)ipIface);
        Mockito.when((Object)ipIface.getNode().getLocation().getLocationName()).thenReturn((Object)"Ocracoke");
        SnmpCollectionAgent agent = DefaultCollectionAgent.create((Integer)ifaceId, (IpInterfaceDao)ifaceDao, (PlatformTransactionManager)transMgr);
        agent.getAgentConfig();
        ((SnmpPeerFactory)Mockito.verify((Object)snmpPeerFactory, (VerificationMode)Mockito.times((int)1))).getAgentConfig((InetAddress)Mockito.any(), (String)Mockito.eq((Object)"Ocracoke"));
    }
}

