/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.tl1d;

import java.text.SimpleDateFormat;
import junit.framework.TestCase;
import org.opennms.netmgt.tl1d.Tl1AutonomousMessage;
import org.opennms.netmgt.tl1d.Tl1AutonomousMessageProcessor;

public class Tl1AutonomousMessageProcessorTest
extends TestCase {
    Tl1AutonomousMessageProcessor m_processor = new Tl1AutonomousMessageProcessor();

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testProcess() {
        String sampleMessage = "   GPON15000 2008-07-31 18:29:49\n*C 0 REPT ALM BITS\n   \"1-4:NTFCNCDE=CR,CONDTYPE=FAIL,SRVEFF=SA,OCRDAT=09-23,OCRTM=02-03-04,LOCN=NEND,DIRN=RCV\"\n;\n";
        Tl1AutonomousMessage alarm = this.m_processor.process(sampleMessage, 4);
        Tl1AutonomousMessageProcessorTest.assertNotNull((Object)alarm.getRawMessage());
        Tl1AutonomousMessageProcessorTest.assertNotNull((Object)alarm.getHeader());
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        Tl1AutonomousMessageProcessorTest.assertEquals((String)"2008-07-31", (String)formatter.format(alarm.getHeader().getTimestamp()));
        formatter = new SimpleDateFormat("HH:mm:ss");
        Tl1AutonomousMessageProcessorTest.assertEquals((String)"18:29:49", (String)formatter.format(alarm.getHeader().getTimestamp()));
        Tl1AutonomousMessageProcessorTest.assertEquals((String)"GPON15000", (String)alarm.getHost());
        Tl1AutonomousMessageProcessorTest.assertEquals((String)"GPON15000", (String)alarm.getHeader().getSid());
        Tl1AutonomousMessageProcessorTest.assertEquals((Object)alarm.getTimestamp(), (Object)alarm.getHeader().getTimestamp());
        Tl1AutonomousMessageProcessorTest.assertEquals((String)"*C 0 REPT ALM BITS", (String)alarm.getId().getRawMessage());
        Tl1AutonomousMessageProcessorTest.assertEquals((String)"*C", (String)alarm.getId().getAlarmCode());
        Tl1AutonomousMessageProcessorTest.assertEquals((String)"0", (String)alarm.getId().getAlarmTag());
        Tl1AutonomousMessageProcessorTest.assertEquals((String)"REPT ALM BITS", (String)alarm.getId().getVerb());
        Tl1AutonomousMessageProcessorTest.assertEquals((String)"\"1-4:NTFCNCDE=CR,CONDTYPE=FAIL,SRVEFF=SA,OCRDAT=09-23,OCRTM=02-03-04,LOCN=NEND,DIRN=RCV\"", (String)alarm.getAutoBlock().getBlock());
        Tl1AutonomousMessageProcessorTest.assertEquals((String)"CR", (String)alarm.getAutoBlock().getNtfcncde());
    }

    public void testProcessAlcatel() {
        String sampleMessage = "DSALC003 09-04-20 07:38:35\n** 169 REPT ALM ENV\n   \"ENV-2:MJ,MISC,4-7,7-30-15,\\\"Miscellaneous environment alarm\\\"\"\n;\n";
        Tl1AutonomousMessage alarm = this.m_processor.process(sampleMessage, 4);
        Tl1AutonomousMessageProcessorTest.assertNotNull((Object)alarm.getRawMessage());
        Tl1AutonomousMessageProcessorTest.assertNotNull((Object)alarm.getHeader());
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        Tl1AutonomousMessageProcessorTest.assertEquals((String)"2009-04-20", (String)formatter.format(alarm.getHeader().getTimestamp()));
        formatter = new SimpleDateFormat("HH:mm:ss");
        Tl1AutonomousMessageProcessorTest.assertEquals((String)"07:38:35", (String)formatter.format(alarm.getHeader().getTimestamp()));
        Tl1AutonomousMessageProcessorTest.assertEquals((String)"DSALC003", (String)alarm.getHost());
        Tl1AutonomousMessageProcessorTest.assertEquals((String)"DSALC003", (String)alarm.getHeader().getSid());
        Tl1AutonomousMessageProcessorTest.assertEquals((Object)alarm.getTimestamp(), (Object)alarm.getHeader().getTimestamp());
        Tl1AutonomousMessageProcessorTest.assertEquals((String)"** 169 REPT ALM ENV", (String)alarm.getId().getRawMessage());
        Tl1AutonomousMessageProcessorTest.assertEquals((String)"**", (String)alarm.getId().getAlarmCode());
        Tl1AutonomousMessageProcessorTest.assertEquals((String)"169", (String)alarm.getId().getAlarmTag());
        Tl1AutonomousMessageProcessorTest.assertEquals((String)"REPT ALM ENV", (String)alarm.getId().getVerb());
        Tl1AutonomousMessageProcessorTest.assertEquals((String)"\"ENV-2:MJ,MISC,4-7,7-30-15,\\\"Miscellaneous environment alarm\\\"\"", (String)alarm.getAutoBlock().getBlock());
        Tl1AutonomousMessageProcessorTest.assertEquals((String)"MJ", (String)alarm.getAutoBlock().getNtfcncde());
    }

    public void testInstanitateClass() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Class.forName("org.opennms.netmgt.tl1d.Tl1ClientImpl").newInstance();
    }
}

