/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.scheduler;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import org.opennms.core.concurrent.LogPreservingThreadFactory;
import org.opennms.core.fiber.PausableFiber;
import org.opennms.netmgt.enlinkd.scheduler.ReadyRunnable;
import org.opennms.netmgt.enlinkd.scheduler.ScheduleTimer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Scheduler
implements Runnable,
PausableFiber,
ScheduleTimer {
    private static final Logger LOG = LoggerFactory.getLogger(Scheduler.class);
    public Map<Long, BlockingQueue<ReadyRunnable>> m_queues;
    private volatile int m_scheduled;
    private final ExecutorService m_runner;
    private volatile int m_status = 0;
    private volatile Thread m_worker;
    private volatile long m_numTasksExecuted = 0L;

    public Scheduler(String parent, int maxSize) {
        this.m_runner = Executors.newFixedThreadPool(maxSize, (ThreadFactory)new LogPreservingThreadFactory(parent, maxSize));
        this.m_queues = new ConcurrentSkipListMap<Long, BlockingQueue<ReadyRunnable>>();
        this.m_scheduled = 0;
        this.m_worker = null;
    }

    public Scheduler(String parent, int maxSize, float lowMark, float hiMark) {
        this(parent, maxSize);
    }

    public synchronized void schedule(ReadyRunnable runnable, long interval) {
        LOG.debug("schedule: Adding ready runnable at interval {}", (Object)interval);
        if (!this.m_queues.containsKey(interval)) {
            LOG.debug("schedule: interval queue did not exist, a new one has been created");
            this.m_queues.put(interval, new LinkedBlockingQueue());
        }
        this.m_queues.get(interval).add(runnable);
        if (this.m_scheduled++ == 0) {
            LOG.debug("schedule: queue element added, calling notify all since none were scheduled");
            this.notifyAll();
        } else {
            LOG.debug("schedule: queue element added, notification not performed");
        }
    }

    @Override
    public synchronized void schedule(long interval, final ReadyRunnable runnable) {
        final long timeToRun = this.getCurrentTime() + interval;
        ReadyRunnable timeKeeper = new ReadyRunnable(){

            @Override
            public boolean isReady() {
                return Scheduler.this.getCurrentTime() >= timeToRun && runnable.isReady();
            }

            @Override
            public String getInfo() {
                return runnable.getInfo();
            }

            @Override
            public void run() {
                runnable.run();
            }

            @Override
            public void schedule() {
                runnable.schedule();
            }

            @Override
            public void suspend() {
                runnable.suspend();
            }

            @Override
            public void wakeUp() {
                runnable.wakeUp();
            }

            @Override
            public boolean isSuspended() {
                return runnable.isSuspended();
            }

            public boolean equals(Object r) {
                return runnable.equals(r);
            }

            @Override
            public void unschedule() {
                runnable.unschedule();
            }

            public String toString() {
                return runnable.toString() + " (ready in " + Math.max(0L, timeToRun - Scheduler.this.getCurrentTime()) + "ms)";
            }

            @Override
            public String getPackageName() {
                return runnable.getPackageName();
            }

            @Override
            public void setPackageName(String pkg) {
                runnable.setPackageName(pkg);
            }
        };
        this.schedule(timeKeeper, interval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void unschedule(ReadyRunnable runnable) {
        LOG.debug("unschedule: Removing all {}", (Object)runnable.getInfo());
        Map<Long, BlockingQueue<ReadyRunnable>> map = this.m_queues;
        synchronized (map) {
            for (Long key : this.m_queues.keySet()) {
                this.unschedule(runnable, key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void unschedule(ReadyRunnable runnable, long interval) {
        LOG.debug("unschedule: Removing {} at interval {}", (Object)runnable.getInfo(), (Object)interval);
        Map<Long, BlockingQueue<ReadyRunnable>> map = this.m_queues;
        synchronized (map) {
            if (!this.m_queues.containsKey(interval)) {
                LOG.debug("unschedule: interval queue did not exist, exit");
                return;
            }
            BlockingQueue<ReadyRunnable> in = this.m_queues.get(interval);
            if (in.isEmpty()) {
                LOG.debug("unschedule: interval queue is empty, exit");
                return;
            }
            ReadyRunnable readyRun = null;
            int maxLoops = in.size();
            boolean first = true;
            do {
                try {
                    readyRun = in.take();
                    if (in.size() == maxLoops && first) {
                        ++maxLoops;
                    }
                    first = false;
                    if (readyRun != null && readyRun.equals(runnable)) {
                        LOG.debug("unschedule: removing found {}", (Object)readyRun.getInfo());
                        --this.m_scheduled;
                        continue;
                    }
                    in.add(readyRun);
                }
                catch (InterruptedException ie) {
                    LOG.info("unschedule: failed to remove instance {} from scheduler", (Object)runnable.getInfo(), (Object)ie);
                    Thread.currentThread().interrupt();
                }
            } while (--maxLoops > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ReadyRunnable getReadyRunnable(ReadyRunnable runnable) {
        ReadyRunnable rr = null;
        Map<Long, BlockingQueue<ReadyRunnable>> map = this.m_queues;
        synchronized (map) {
            Iterator<Long> iter = this.m_queues.keySet().iterator();
            while (iter.hasNext() && rr == null) {
                Long interval = iter.next();
                rr = this.getReadyRunnable(runnable, interval);
            }
        }
        return rr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ReadyRunnable getReadyRunnable(ReadyRunnable runnable, long interval) {
        LOG.debug("getReadyRunnable: Retrieving {} at interval {}", (Object)runnable.getInfo(), (Object)interval);
        if (!this.m_queues.containsKey(interval)) {
            LOG.debug("getReadyRunnable: interval queue did not exist, exit");
            return null;
        }
        ReadyRunnable rr = null;
        Map<Long, BlockingQueue<ReadyRunnable>> map = this.m_queues;
        synchronized (map) {
            BlockingQueue<ReadyRunnable> in = this.m_queues.get(interval);
            if (in.isEmpty()) {
                LOG.warn("getReadyRunnable: queue is Empty");
                return null;
            }
            int maxLoops = in.size();
            ReadyRunnable readyRun = null;
            boolean first = true;
            do {
                try {
                    readyRun = in.take();
                    LOG.debug("getReadyRunnable: parsing ready runnable {}", (Object)readyRun);
                    if (in.size() == maxLoops && first) {
                        ++maxLoops;
                    }
                    first = false;
                    if (readyRun != null && readyRun.equals(runnable)) {
                        LOG.debug("getReadyRunnable: found ready runnable {}", (Object)readyRun);
                        rr = readyRun;
                    }
                    in.add(readyRun);
                }
                catch (InterruptedException ie) {
                    LOG.info("getReadyRunnable: failed to get instance {} from scheduler", (Object)readyRun.getInfo(), (Object)ie);
                    Thread.currentThread().interrupt();
                }
            } while (--maxLoops > 0);
        }
        if (rr == null) {
            LOG.info("getReadyRunnable: instance {} not found on scheduler", (Object)runnable.getInfo());
        }
        return rr;
    }

    @Override
    public long getCurrentTime() {
        return System.currentTimeMillis();
    }

    public synchronized void start() {
        if (this.m_worker != null) {
            throw new IllegalStateException("The fiber has already run or is running");
        }
        this.m_worker = new Thread((Runnable)this, this.getName());
        this.m_worker.start();
        this.m_status = 1;
        LOG.debug("start: scheduler started");
    }

    public synchronized void stop() {
        if (this.m_worker == null) {
            throw new IllegalStateException("The fiber has never been started");
        }
        this.m_status = 3;
        this.m_worker.interrupt();
        this.m_runner.shutdown();
        LOG.debug("stop: scheduler stopped");
    }

    public synchronized void pause() {
        if (this.m_worker == null) {
            throw new IllegalStateException("The fiber has never been started");
        }
        if (this.m_status == 4 || this.m_status == 3) {
            throw new IllegalStateException("The fiber is not running or a stop is pending");
        }
        if (this.m_status == 6) {
            return;
        }
        this.m_status = 5;
        this.notifyAll();
    }

    public synchronized void resume() {
        if (this.m_worker == null) {
            throw new IllegalStateException("The fiber has never been started");
        }
        if (this.m_status == 4 || this.m_status == 3) {
            throw new IllegalStateException("The fiber is not running or a stop is pending");
        }
        if (this.m_status == 2) {
            return;
        }
        this.m_status = 7;
        this.notifyAll();
    }

    public synchronized int getStatus() {
        if (this.m_worker != null && !this.m_worker.isAlive()) {
            this.m_status = 4;
        }
        return this.m_status;
    }

    public String getName() {
        return this.m_runner.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Scheduler scheduler = this;
        synchronized (scheduler) {
            this.m_status = 2;
        }
        LOG.debug("run: scheduler running");
        while (true) {
            scheduler = this;
            synchronized (scheduler) {
                if (this.m_status != 2 && this.m_status != 6 && this.m_status != 5 && this.m_status != 7) {
                    LOG.debug("run: status = {}, time to exit", (Object)this.m_status);
                    break;
                }
                if (this.m_scheduled == 0) {
                    try {
                        LOG.debug("run: no interfaces scheduled, waiting...");
                        this.wait();
                    }
                    catch (InterruptedException ex) {
                        break;
                    }
                }
            }
            int runned = 0;
            Object object = this.m_queues;
            synchronized (object) {
                for (Map.Entry<Long, BlockingQueue<ReadyRunnable>> entry : this.m_queues.entrySet()) {
                    Long key = entry.getKey();
                    BlockingQueue<ReadyRunnable> in = this.m_queues.get(key);
                    if (in == null || in.isEmpty()) continue;
                    ReadyRunnable readyRun = null;
                    int maxLoops = in.size();
                    do {
                        try {
                            readyRun = (ReadyRunnable)in.peek();
                            if (readyRun == null) continue;
                            in.take();
                            if (readyRun.isReady()) {
                                LOG.debug("run: runnable {}, executing", (Object)readyRun.getInfo());
                                this.m_runner.execute(readyRun);
                                ++runned;
                                ++this.m_numTasksExecuted;
                                if (!(this.m_runner instanceof ThreadPoolExecutor)) continue;
                                ThreadPoolExecutor e = (ThreadPoolExecutor)this.m_runner;
                                String ratio = String.format("%.3f", e.getTaskCount() > 0L ? new Double(e.getCompletedTaskCount()) / new Double(e.getTaskCount()) : 0.0);
                                LOG.debug("thread pool statistics: activeCount={}, taskCount={}, completedTaskCount={}, completedRatio={}, poolSize={}", new Object[]{e.getActiveCount(), e.getTaskCount(), e.getCompletedTaskCount(), ratio, e.getPoolSize()});
                                continue;
                            }
                            in.add(readyRun);
                        }
                        catch (InterruptedException ex) {
                            return;
                        }
                    } while (--maxLoops > 0);
                }
            }
            object = this;
            synchronized (object) {
                this.m_scheduled -= runned;
                if (runned == 0) {
                    try {
                        this.wait(1000L);
                    }
                    catch (InterruptedException ex) {
                        break;
                    }
                }
            }
        }
        LOG.debug("run: scheduler exiting, state = STOPPED");
        Scheduler scheduler2 = this;
        synchronized (scheduler2) {
            this.m_status = 4;
        }
    }

    public long getNumTasksExecuted() {
        return this.m_numTasksExecuted;
    }
}

