/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.net.InetAddress;
import java.util.LinkedHashSet;
import java.util.Set;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.collectd.CollectionAgentService;
import org.opennms.netmgt.collectd.DefaultCollectionAgentService;
import org.opennms.netmgt.collectd.IfInfo;
import org.opennms.netmgt.collectd.IfResourceType;
import org.opennms.netmgt.collectd.SnmpCollectionAgent;
import org.opennms.netmgt.collectd.SnmpIfData;
import org.opennms.netmgt.collection.api.CollectionInitializationException;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.model.PrimaryType;
import org.opennms.netmgt.model.ResourcePath;
import org.opennms.netmgt.model.ResourceTypeUtils;
import org.opennms.netmgt.poller.support.InetNetworkInterface;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;

public class DefaultCollectionAgent
extends InetNetworkInterface
implements SnmpCollectionAgent {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultCollectionAgent.class);
    private static final long serialVersionUID = 6694654071513990997L;
    private int m_ifCount = -1;
    private long m_sysUpTime = -1L;
    private int m_nodeId = -1;
    private InetAddress m_inetAddress = null;
    private int m_ifIndex = -1;
    private PrimaryType m_isSnmpPrimary = null;
    private String m_sysObjId = null;
    private String m_foreignSource = null;
    private String m_foreignId = null;
    private String m_locationName = null;
    private String m_nodeLabel = null;
    private ResourcePath m_storageResourcePath = null;
    private CollectionAgentService m_agentService;
    private Set<SnmpIfData> m_snmpIfData;

    public static SnmpCollectionAgent create(Integer ifaceId, IpInterfaceDao ifaceDao, PlatformTransactionManager transMgr) {
        return new DefaultCollectionAgent(DefaultCollectionAgentService.create(ifaceId, ifaceDao, transMgr));
    }

    public static SnmpCollectionAgent create(Integer ifaceId, IpInterfaceDao ifaceDao, PlatformTransactionManager transMgr, String location) {
        return new DefaultCollectionAgent(DefaultCollectionAgentService.create(ifaceId, ifaceDao, transMgr), location);
    }

    private DefaultCollectionAgent(CollectionAgentService agentService) {
        this(agentService, null);
    }

    private DefaultCollectionAgent(CollectionAgentService agentService, String location) {
        super(null);
        this.m_agentService = agentService;
        this.m_storageResourcePath = agentService.getStorageResourcePath();
        this.m_locationName = location;
        if (Boolean.getBoolean("org.opennms.netmgt.collectd.DefaultCollectionAgent.loadSnmpDataOnInit")) {
            this.getSnmpInterfaceData();
        }
    }

    public InetAddress getAddress() {
        if (this.m_inetAddress == null) {
            this.m_inetAddress = this.m_agentService.getInetAddress();
        }
        return this.m_inetAddress;
    }

    public Boolean isStoreByForeignSource() {
        return ResourceTypeUtils.isStoreByForeignSource();
    }

    public String getHostAddress() {
        return InetAddressUtils.str((InetAddress)this.getAddress());
    }

    @Override
    public void setSavedIfCount(int ifCount) {
        this.m_ifCount = ifCount;
    }

    @Override
    public int getSavedIfCount() {
        return this.m_ifCount;
    }

    public int getNodeId() {
        if (this.m_nodeId == -1) {
            this.m_nodeId = this.m_agentService.getNodeId();
        }
        return this.m_nodeId;
    }

    public String getNodeLabel() {
        if (this.m_nodeLabel == null) {
            this.m_nodeLabel = this.m_agentService.getNodeLabel();
        }
        return this.m_nodeLabel;
    }

    public String getForeignSource() {
        if (this.m_foreignSource == null) {
            this.m_foreignSource = this.m_agentService.getForeignSource();
        }
        return this.m_foreignSource;
    }

    public String getForeignId() {
        if (this.m_foreignId == null) {
            this.m_foreignId = this.m_agentService.getForeignId();
        }
        return this.m_foreignId;
    }

    public String getLocationName() {
        if (this.m_locationName == null) {
            this.m_locationName = this.m_agentService.getLocationName();
        }
        return this.m_locationName;
    }

    public ResourcePath getStorageResourcePath() {
        return this.m_storageResourcePath;
    }

    private int getIfIndex() {
        if (this.m_ifIndex == -1) {
            this.m_ifIndex = this.m_agentService.getIfIndex();
        }
        return this.m_ifIndex;
    }

    @Override
    public String getSysObjectId() {
        if (this.m_sysObjId == null) {
            this.m_sysObjId = this.m_agentService.getSysObjectId();
            this.m_sysObjId = this.m_sysObjId == null ? null : this.m_sysObjId.intern();
        }
        return this.m_sysObjId;
    }

    private PrimaryType getIsSnmpPrimary() {
        if (this.m_isSnmpPrimary == null) {
            this.m_isSnmpPrimary = this.m_agentService.getIsSnmpPrimary();
        }
        return this.m_isSnmpPrimary;
    }

    private void logCompletion() {
        LOG.debug("initialize: initialization completed: nodeid = {}, address = {}, primaryIfIndex = {}, isSnmpPrimary = {}, sysoid = {}", new Object[]{this.getNodeId(), this.getHostAddress(), this.getIfIndex(), this.getIsSnmpPrimary(), this.getSysObjectId()});
    }

    private void validateSysObjId() throws CollectionInitializationException {
        if (this.getSysObjectId() == null) {
            throw new CollectionInitializationException("System Object ID for interface " + this.getHostAddress() + " does not exist in the database.");
        }
    }

    private void logCollectionParms() {
        LOG.debug("initialize: db retrieval info: nodeid = {}, address = {}, primaryIfIndex = {}, isSnmpPrimary = {}, sysoid = {}", new Object[]{this.getNodeId(), this.getHostAddress(), this.getIfIndex(), this.getIsSnmpPrimary(), this.getSysObjectId()});
    }

    private void validateIsSnmpPrimary() throws CollectionInitializationException {
        if (!PrimaryType.PRIMARY.equals((Object)this.getIsSnmpPrimary())) {
            throw new CollectionInitializationException("Interface " + this.getHostAddress() + " is not the primary SNMP interface for nodeid " + this.getNodeId());
        }
    }

    private void validatePrimaryIfIndex() {
        if (this.getIfIndex() < 0) {
            LOG.debug("initialize: db retrieval info: node {} does not have a legitimate primaryIfIndex.  Assume node does not supply ipAddrTable and continue...", (Object)this.getNodeId());
        }
    }

    @Override
    public void validateAgent() throws CollectionInitializationException {
        this.logCollectionParms();
        this.validateIsSnmpPrimary();
        this.validatePrimaryIfIndex();
        this.validateSysObjId();
        this.logCompletion();
    }

    public String toString() {
        return "Agent[nodeid = " + this.getNodeId() + " ipaddr= " + this.getHostAddress() + ']';
    }

    @Override
    public SnmpAgentConfig getAgentConfig() {
        return SnmpPeerFactory.getInstance().getAgentConfig(this.getAddress(), this.getLocationName());
    }

    private Set<SnmpIfData> getSnmpInterfaceData() {
        if (this.m_snmpIfData == null) {
            this.m_snmpIfData = this.m_agentService.getSnmpInterfaceData();
        }
        return this.m_snmpIfData;
    }

    @Override
    public Set<IfInfo> getSnmpInterfaceInfo(IfResourceType type) {
        Set<SnmpIfData> snmpIfData = this.getSnmpInterfaceData();
        LinkedHashSet<IfInfo> ifInfos = new LinkedHashSet<IfInfo>(snmpIfData.size());
        for (SnmpIfData ifData : snmpIfData) {
            ifInfos.add(new IfInfo(type, this, ifData));
        }
        return ifInfos;
    }

    public String getSnmpInterfaceLabel(int ifIndex) {
        for (SnmpIfData ifData : this.getSnmpInterfaceData()) {
            if (ifData.getIfIndex() != ifIndex) continue;
            return ifData.getLabelForRRD();
        }
        return null;
    }

    public long getSavedSysUpTime() {
        return this.m_sysUpTime;
    }

    public void setSavedSysUpTime(long sysUpTime) {
        this.m_sysUpTime = sysUpTime;
    }
}

