/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.rtc.datablock;

import java.net.InetAddress;
import org.opennms.core.utils.InetAddressComparator;
import org.opennms.core.utils.InetAddressUtils;

public class RTCNodeKey
implements Comparable<RTCNodeKey> {
    private final int m_nodeID;
    private final InetAddress m_ip;
    private final String m_svcName;

    public RTCNodeKey(int nodeid, InetAddress ip, String svcname) {
        this.m_nodeID = nodeid;
        this.m_ip = ip;
        this.m_svcName = svcname;
    }

    public int getNodeID() {
        return this.m_nodeID;
    }

    public String getSvcName() {
        return this.m_svcName;
    }

    public InetAddress getIP() {
        return this.m_ip;
    }

    public int hashCode() {
        int hcode = this.m_nodeID + (this.m_ip == null ? 0 : this.m_ip.hashCode()) + (this.m_svcName == null ? 0 : this.m_svcName.hashCode());
        return hcode;
    }

    public boolean equals(Object o) {
        if (!(o instanceof RTCNodeKey)) {
            return false;
        }
        return this.compareTo((RTCNodeKey)o) == 0;
    }

    @Override
    public int compareTo(RTCNodeKey obj) {
        int rc = this.m_nodeID - obj.getNodeID();
        if (rc != 0) {
            return rc;
        }
        rc = this.m_ip == null && obj.getIP() == null ? 0 : new InetAddressComparator().compare(this.m_ip, obj.getIP());
        if (rc != 0) {
            return rc;
        }
        if (this.m_svcName == null) {
            if (obj.getSvcName() == null) {
                return 0;
            }
            return -1;
        }
        return this.m_svcName.compareTo(obj.getSvcName());
    }

    public String toString() {
        return "RTCNodeKey\n[\n\tnodeID    = " + this.m_nodeID + "\n\t" + "IP        = " + InetAddressUtils.str((InetAddress)this.m_ip) + "\n\t" + "Service   = " + this.m_svcName + "\n]\n";
    }
}

