/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.io.File;
import java.io.FileWriter;
import java.net.InetAddress;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.test.MockLogAppender;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.MockDatabase;
import org.opennms.core.test.db.TemporaryDatabaseAware;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.PollOutagesConfigFactory;
import org.opennms.netmgt.config.ThreshdConfigFactory;
import org.opennms.netmgt.config.ThresholdingConfigFactory;
import org.opennms.netmgt.dao.api.ResourceStorageDao;
import org.opennms.netmgt.dao.mock.EventAnticipator;
import org.opennms.netmgt.dao.mock.MockEventIpcManager;
import org.opennms.netmgt.dao.support.FilesystemResourceStorageDao;
import org.opennms.netmgt.filter.FilterDaoFactory;
import org.opennms.netmgt.filter.api.FilterDao;
import org.opennms.netmgt.mock.MockNetwork;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.rrd.RrdRepository;
import org.opennms.netmgt.threshd.CollectionResourceWrapper;
import org.opennms.netmgt.threshd.LatencyThresholdingSet;
import org.opennms.netmgt.threshd.ThresholdingEventProxy;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.test.FileAnticipator;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath:/META-INF/opennms/applicationContext-daemon.xml", "classpath:/META-INF/opennms/mockEventIpcManager.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase(tempDbClass=MockDatabase.class)
public class LatencyThresholdingSetIT
implements TemporaryDatabaseAware<MockDatabase> {
    private static final Logger LOG = LoggerFactory.getLogger(LatencyThresholdingSetIT.class);
    private FileAnticipator m_fileAnticipator;
    private List<Event> m_anticipatedEvents;
    private MockDatabase m_db;
    @Autowired
    private MockEventIpcManager m_eventIpcManager;
    @Autowired
    private JdbcTemplate m_jdbcTemplate;
    @Autowired
    private ApplicationContext m_context;
    private FilesystemResourceStorageDao m_resourceStorageDao;
    private static final Comparator<Parm> PARM_COMPARATOR = new Comparator<Parm>(){

        @Override
        public int compare(Parm o1, Parm o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null && o2 != null) {
                return 1;
            }
            if (o1 != null && o2 == null) {
                return -1;
            }
            int retVal = o1.getParmName().compareTo(o2.getParmName());
            if (retVal == 0) {
                String c1 = o1.getValue().getContent();
                String c2 = o2.getValue().getContent();
                if (c1 == null && c2 == null) {
                    return 0;
                }
                if (c1 == null && c2 != null) {
                    return 1;
                }
                if (c1 != null && c2 == null) {
                    return -1;
                }
                retVal = c1.compareTo(c2);
            }
            return retVal;
        }
    };
    private static final Comparator<Event> EVENT_COMPARATOR = new Comparator<Event>(){

        private int compareStrings(String s1, String s2) {
            if (s1 == null && s2 == null) {
                return 0;
            }
            if (s1 == null && s2 != null) {
                return 1;
            }
            if (s1 != null && s2 == null) {
                return -1;
            }
            return s1.compareTo(s2);
        }

        @Override
        public int compare(Event e1, Event e2) {
            if (e1 == null && e2 == null) {
                return 0;
            }
            if (e1 == null && e2 != null) {
                return 1;
            }
            if (e1 != null && e2 == null) {
                return -1;
            }
            int retVal = this.compareStrings(e1.getUei(), e2.getUei());
            if (retVal == 0) {
                retVal = InetAddressUtils.toInteger((InetAddress)e1.getInterfaceAddress()).compareTo(InetAddressUtils.toInteger((InetAddress)e2.getInterfaceAddress()));
            }
            if (retVal == 0) {
                retVal = this.compareStrings(e1.getService(), e2.getService());
            }
            if (retVal == 0) {
                List anticipatedParms = e1.getParmCollection();
                List receivedParms = e2.getParmCollection();
                Collections.sort(anticipatedParms, PARM_COMPARATOR);
                Collections.sort(receivedParms, PARM_COMPARATOR);
                if (anticipatedParms.size() != receivedParms.size()) {
                    retVal = Integer.valueOf(anticipatedParms.size()).compareTo(receivedParms.size());
                }
                if (retVal == 0) {
                    for (int i = 0; i < anticipatedParms.size(); ++i) {
                        Parm anticipated = (Parm)anticipatedParms.get(i);
                        Parm received = (Parm)receivedParms.get(i);
                        retVal = this.compareStrings(anticipated.getParmName(), received.getParmName());
                        if (retVal == 0) {
                            retVal = this.compareStrings(anticipated.getValue().getContent(), received.getValue().getContent());
                        }
                        if (retVal != 0) break;
                    }
                }
            }
            return retVal;
        }
    };

    public void setTemporaryDatabase(MockDatabase database) {
        this.m_db = database;
    }

    @Before
    public void setUp() throws Exception {
        BeanUtils.setStaticApplicationContext((ApplicationContext)this.m_context);
        CollectionResourceWrapper.s_cache.clear();
        MockLogAppender.setupLogging();
        this.m_fileAnticipator = new FileAnticipator();
        this.m_resourceStorageDao = new FilesystemResourceStorageDao();
        this.m_resourceStorageDao.setRrdDirectory(this.m_fileAnticipator.getTempDir());
        FilterDao filterDao = (FilterDao)EasyMock.createMock(FilterDao.class);
        EasyMock.expect((Object)filterDao.getActiveIPAddressList((String)EasyMock.anyObject())).andReturn(Collections.singletonList(InetAddressUtils.addr((String)"127.0.0.1"))).anyTimes();
        filterDao.flushActiveIpAddressListCache();
        EasyMock.expectLastCall().anyTimes();
        FilterDaoFactory.setInstance((FilterDao)filterDao);
        EasyMock.replay((Object[])new Object[]{filterDao});
        SimpleDateFormat formatter = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
        StringBuffer sb = new StringBuffer("<?xml version=\"1.0\"?>");
        sb.append("<outages>");
        sb.append("<outage name=\"junit outage\" type=\"specific\">");
        sb.append("<time begins=\"");
        sb.append(formatter.format(new Date(System.currentTimeMillis() - 3600000L)));
        sb.append("\" ends=\"");
        sb.append(formatter.format(new Date(System.currentTimeMillis() + 3600000L)));
        sb.append("\"/>");
        sb.append("<interface address=\"match-any\"/>");
        sb.append("</outage>");
        sb.append("</outages>");
        File file = new File("target/poll-outages.xml");
        FileWriter writer = new FileWriter(file);
        writer.write(sb.toString());
        writer.close();
        PollOutagesConfigFactory.setInstance((PollOutagesConfigFactory)new PollOutagesConfigFactory((Resource)new FileSystemResource(file)));
        PollOutagesConfigFactory.getInstance().afterPropertiesSet();
        this.initFactories("/threshd-configuration.xml", "/test-thresholds.xml");
        this.m_anticipatedEvents = new ArrayList<Event>();
    }

    private void initFactories(String threshd, String thresholds) throws Exception {
        LOG.info("Initialize Threshold Factories");
        ThresholdingConfigFactory.setInstance((ThresholdingConfigFactory)new ThresholdingConfigFactory(this.getClass().getResourceAsStream(thresholds)));
        ThreshdConfigFactory.setInstance((ThreshdConfigFactory)new ThreshdConfigFactory(this.getClass().getResourceAsStream(threshd), "127.0.0.1", false));
    }

    @After
    public void tearDown() throws Exception {
        this.m_fileAnticipator.deleteExpected();
        this.m_fileAnticipator.tearDown();
        this.m_anticipatedEvents.clear();
        this.m_eventIpcManager.reset();
    }

    @Test
    @JUnitTemporaryDatabase(tempDbClass=MockDatabase.class)
    public void testBug3488() throws Exception {
        String ipAddress = "127.0.0.1";
        this.setupSnmpInterfaceDatabase(this.m_db, ipAddress, null);
        LatencyThresholdingSet thresholdingSet = new LatencyThresholdingSet(1, ipAddress, "HTTP", null, this.getRepository(), (ResourceStorageDao)this.m_resourceStorageDao);
        Assert.assertTrue((boolean)thresholdingSet.hasThresholds());
        HashMap<String, Double> attributes = new HashMap<String, Double>();
        attributes.put("http", 200.0);
        Assert.assertTrue((boolean)thresholdingSet.hasThresholds(attributes));
        ArrayList triggerEvents = new ArrayList();
        for (int i = 0; i < 5; ++i) {
            triggerEvents.addAll(thresholdingSet.applyThresholds("http", attributes));
        }
        Assert.assertTrue((triggerEvents.size() == 1 ? 1 : 0) != 0);
        LatencyThresholdingSetIT.addEvent("uei.opennms.org/threshold/highThresholdExceeded", "127.0.0.1", "HTTP", 5, 100.0, 50.0, 200.0, "no_ifLabel", "127.0.0.1[http]", "http", "no_ifLabel", null, this.m_eventIpcManager.getEventAnticipator(), this.m_anticipatedEvents);
        ThresholdingEventProxy proxy = new ThresholdingEventProxy();
        proxy.add(triggerEvents);
        proxy.sendAllEvents();
        this.verifyEvents(0);
    }

    @Test
    @JUnitTemporaryDatabase(tempDbClass=MockDatabase.class)
    public void testBug3575() throws Exception {
        this.initFactories("/threshd-configuration-bug3575.xml", "/test-thresholds-bug3575.xml");
        String ipAddress = "127.0.0.1";
        String ifName = "eth0";
        this.setupSnmpInterfaceDatabase(this.m_db, ipAddress, ifName);
        LatencyThresholdingSet thresholdingSet = new LatencyThresholdingSet(1, ipAddress, "StrafePing", null, this.getRepository(), (ResourceStorageDao)this.m_resourceStorageDao);
        Assert.assertTrue((boolean)thresholdingSet.hasThresholds());
        HashMap<String, Double> attributes = new HashMap<String, Double>();
        for (double i = 1.0; i < 21.0; i += 1.0) {
            attributes.put("ping" + i, 2.0 * i);
        }
        attributes.put("loss", 60.0);
        attributes.put("median", 100.0);
        attributes.put("response-time", 100.0);
        Assert.assertTrue((boolean)thresholdingSet.hasThresholds(attributes));
        List triggerEvents = thresholdingSet.applyThresholds("StrafePing", attributes);
        Assert.assertTrue((triggerEvents.size() == 1 ? 1 : 0) != 0);
        LatencyThresholdingSetIT.addEvent("uei.opennms.org/threshold/highThresholdExceeded", "127.0.0.1", "StrafePing", 1, 50.0, 25.0, 60.0, ifName, "127.0.0.1[StrafePing]", "loss", "eth0", null, this.m_eventIpcManager.getEventAnticipator(), this.m_anticipatedEvents);
        ThresholdingEventProxy proxy = new ThresholdingEventProxy();
        proxy.add(triggerEvents);
        proxy.sendAllEvents();
        this.verifyEvents(0);
    }

    @Test
    @JUnitTemporaryDatabase(tempDbClass=MockDatabase.class)
    public void testLatencyThresholdingSet() throws Exception {
        Integer ifIndex = 1;
        String ifName = "lo0";
        this.setupSnmpInterfaceDatabase(this.m_db, "127.0.0.1", ifName);
        LatencyThresholdingSet thresholdingSet = new LatencyThresholdingSet(1, "127.0.0.1", "HTTP", null, this.getRepository(), (ResourceStorageDao)this.m_resourceStorageDao);
        Assert.assertTrue((boolean)thresholdingSet.hasThresholds());
        HashMap<String, Double> attributes = new HashMap<String, Double>();
        attributes.put("http", 90.0);
        Assert.assertTrue((boolean)thresholdingSet.hasThresholds(attributes));
        List triggerEvents = thresholdingSet.applyThresholds("http", attributes);
        Assert.assertTrue((triggerEvents.size() == 0 ? 1 : 0) != 0);
        attributes.put("http", 200.0);
        for (int i = 1; i < 5; ++i) {
            LOG.debug("testLatencyThresholdingSet: run number {}", (Object)i);
            if (!thresholdingSet.hasThresholds(attributes)) continue;
            triggerEvents = thresholdingSet.applyThresholds("http", attributes);
            Assert.assertTrue((triggerEvents.size() == 0 ? 1 : 0) != 0);
        }
        if (thresholdingSet.hasThresholds(attributes)) {
            LOG.debug("testLatencyThresholdingSet: run number 5");
            triggerEvents = thresholdingSet.applyThresholds("http", attributes);
            Assert.assertTrue((triggerEvents.size() == 1 ? 1 : 0) != 0);
        }
        List rearmEvents = null;
        if (thresholdingSet.hasThresholds(attributes)) {
            attributes.put("http", 40.0);
            rearmEvents = thresholdingSet.applyThresholds("http", attributes);
            Assert.assertTrue((rearmEvents.size() == 1 ? 1 : 0) != 0);
        }
        LatencyThresholdingSetIT.addEvent("uei.opennms.org/threshold/highThresholdExceeded", "127.0.0.1", "HTTP", 5, 100.0, 50.0, 200.0, ifName, "127.0.0.1[http]", "http", ifName, ifIndex.toString(), this.m_eventIpcManager.getEventAnticipator(), this.m_anticipatedEvents);
        LatencyThresholdingSetIT.addEvent("uei.opennms.org/threshold/highThresholdRearmed", "127.0.0.1", "HTTP", 5, 100.0, 50.0, 40.0, ifName, "127.0.0.1[http]", "http", ifName, ifIndex.toString(), this.m_eventIpcManager.getEventAnticipator(), this.m_anticipatedEvents);
        ThresholdingEventProxy proxy = new ThresholdingEventProxy();
        proxy.add(triggerEvents);
        proxy.add(rearmEvents);
        proxy.sendAllEvents();
        this.verifyEvents(0);
    }

    @Test
    @JUnitTemporaryDatabase(tempDbClass=MockDatabase.class)
    public void testCounterReset() throws Exception {
        int i;
        String ifName = "lo0";
        this.setupSnmpInterfaceDatabase(this.m_db, "127.0.0.1", ifName);
        LatencyThresholdingSet thresholdingSet = new LatencyThresholdingSet(1, "127.0.0.1", "HTTP", null, this.getRepository(), (ResourceStorageDao)this.m_resourceStorageDao);
        Assert.assertTrue((boolean)thresholdingSet.hasThresholds());
        HashMap<String, Double> attributes = new HashMap<String, Double>();
        attributes.put("http", 90.0);
        Assert.assertTrue((boolean)thresholdingSet.hasThresholds(attributes));
        List triggerEvents = thresholdingSet.applyThresholds("http", attributes);
        Assert.assertTrue((triggerEvents.size() == 0 ? 1 : 0) != 0);
        attributes.put("http", 200.0);
        for (i = 1; i <= 3; ++i) {
            LOG.debug("testLatencyThresholdingSet: ------------------------------------ trigger number {}", (Object)i);
            if (!thresholdingSet.hasThresholds(attributes)) continue;
            triggerEvents = thresholdingSet.applyThresholds("http", attributes);
            Assert.assertTrue((triggerEvents.size() == 0 ? 1 : 0) != 0);
        }
        Assert.assertTrue((triggerEvents.size() == 0 ? 1 : 0) != 0);
        attributes.put("http", 40.0);
        LOG.debug("testLatencyThresholdingSet: ------------------------------------ reseting counter");
        triggerEvents = thresholdingSet.applyThresholds("http", attributes);
        attributes.put("http", 300.0);
        for (i = 4; i <= 5; ++i) {
            LOG.debug("testLatencyThresholdingSet: ------------------------------------ trigger number {}", (Object)i);
            if (!thresholdingSet.hasThresholds(attributes)) continue;
            triggerEvents = thresholdingSet.applyThresholds("http", attributes);
            Assert.assertTrue((triggerEvents.size() == 0 ? 1 : 0) != 0);
        }
        for (i = 6; i <= 8; ++i) {
            LOG.debug("testLatencyThresholdingSet: ------------------------------------ trigger number {}", (Object)i);
            if (!thresholdingSet.hasThresholds(attributes)) continue;
            triggerEvents = thresholdingSet.applyThresholds("http", attributes);
            if (i >= 8) continue;
            Assert.assertTrue((triggerEvents.size() == 0 ? 1 : 0) != 0);
        }
        Assert.assertTrue((triggerEvents.size() == 1 ? 1 : 0) != 0);
    }

    private RrdRepository getRepository() {
        RrdRepository repo = new RrdRepository();
        repo.setRrdBaseDir(this.m_fileAnticipator.getTempDir());
        return repo;
    }

    private static void addEvent(String uei, String ipaddr, String service, Integer trigger, Double threshold, Double rearm, Double value, String label, String instance, String ds, String ifLabel, String ifIndex, EventAnticipator anticipator, List<Event> anticipatedEvents) {
        EventBuilder bldr = new EventBuilder(uei, "ThresholdingVisitorTest");
        bldr.setNodeid(1L);
        bldr.setInterface(InetAddressUtils.addr((String)ipaddr));
        bldr.setService(service);
        bldr.addParam("label", label);
        if (ifLabel != null) {
            bldr.addParam("ifLabel", ifLabel);
        }
        if (ifIndex != null) {
            bldr.addParam("ifIndex", ifIndex);
        }
        bldr.addParam("ds", ds);
        if (value != null) {
            String pattern = System.getProperty("org.opennms.threshd.value.decimalformat", "###.##");
            DecimalFormat valueFormatter = new DecimalFormat(pattern);
            bldr.addParam("value", value.isNaN() ? "NaN (the threshold definition has been changed)" : valueFormatter.format(value));
        }
        bldr.addParam("instance", instance);
        bldr.addParam("trigger", trigger.intValue());
        if (threshold != null) {
            bldr.addParam("threshold", threshold.doubleValue());
        }
        if (rearm != null) {
            bldr.addParam("rearm", rearm.doubleValue());
        }
        Event event = bldr.getEvent();
        anticipator.anticipateEvent(event, true);
        anticipatedEvents.add(event);
    }

    private void verifyEvents(int remainEvents) {
        if (remainEvents == 0) {
            ArrayList receivedList = new ArrayList(this.m_eventIpcManager.getEventAnticipator().getAnticipatedEventsReceived());
            Collections.sort(receivedList, EVENT_COMPARATOR);
            Collections.sort(this.m_anticipatedEvents, EVENT_COMPARATOR);
            LOG.info("verifyEvents: Anticipated={}, Received= {}", (Object)receivedList.size(), (Object)this.m_anticipatedEvents.size());
            if (this.m_anticipatedEvents.size() != receivedList.size()) {
                for (Event e : this.m_anticipatedEvents) {
                    System.err.println("expected event " + e.getUei() + ": " + e.getDescr());
                }
                System.err.println("anticipated = " + this.m_anticipatedEvents + "\nreceived = " + receivedList);
                Assert.fail((String)("Anticipated event count (" + this.m_anticipatedEvents.size() + ") is different from received event count (" + receivedList.size() + ")."));
            }
            for (int i = 0; i < this.m_anticipatedEvents.size(); ++i) {
                LOG.info("verifyEvents: processing event {}", (Object)(i + 1));
                LatencyThresholdingSetIT.compareEvents(this.m_anticipatedEvents.get(i), (Event)receivedList.get(i));
            }
        }
        this.m_eventIpcManager.getEventAnticipator().verifyAnticipated(0L, 0L, 0L, remainEvents, 0);
    }

    private static void compareEvents(Event anticipated, Event received) {
        Assert.assertEquals((String)"UEIs must match", (Object)anticipated.getUei(), (Object)received.getUei());
        Assert.assertEquals((String)"NodeIDs must match", (Object)anticipated.getNodeid(), (Object)received.getNodeid());
        Assert.assertEquals((String)"interfaces must match", (Object)anticipated.getInterface(), (Object)received.getInterface());
        Assert.assertEquals((String)"services must match", (Object)anticipated.getService(), (Object)received.getService());
        LatencyThresholdingSetIT.compareParms(anticipated.getParmCollection(), received.getParmCollection());
    }

    private static void compareParms(List<Parm> anticipatedParms, List<Parm> receivedParms) {
        Collections.sort(anticipatedParms, PARM_COMPARATOR);
        Collections.sort(receivedParms, PARM_COMPARATOR);
        for (Parm source : anticipatedParms) {
            Parm found = null;
            for (Parm p : receivedParms) {
                if (!p.getParmName().equals(source.getParmName())) continue;
                found = p;
            }
            Assert.assertNotNull((String)("parameter " + source.getParmName() + " must be found on the received event"), (Object)found);
            if (source.getValue().getContent() == null) {
                source.getValue().setContent("null");
            }
            Assert.assertEquals((String)("content must match for parameter " + source.getParmName()), (Object)source.getValue().getContent(), (Object)found.getValue().getContent());
        }
    }

    private void setupSnmpInterfaceDatabase(MockDatabase db, String ipAddress, String ifName) throws Exception {
        MockNetwork network = new MockNetwork();
        network.setCriticalService("ICMP");
        network.addNode(1, "testNode");
        network.addInterface(ipAddress);
        network.setIfIndex(1);
        if (ifName != null) {
            network.setIfAlias(ifName);
        }
        network.addService("ICMP");
        network.addService("SNMP");
        network.addService("HTTP");
        network.addPathOutage(1, InetAddressUtils.addr((String)"192.168.1.1"), "ICMP");
        db.populate(network);
        Assert.assertEquals((Object)new Integer(1), (Object)this.m_jdbcTemplate.queryForObject("select count(*) from node where nodeid = '1' and nodelabel = 'testNode'", Integer.class));
        Assert.assertEquals((Object)new Integer(1), (Object)this.m_jdbcTemplate.queryForObject("select count(*) from ipinterface where nodeid = '1' and ipaddr = '" + ipAddress + "'", Integer.class));
        if (ifName == null) {
            Assert.assertEquals((Object)new Integer(1), (Object)this.m_jdbcTemplate.queryForObject("select count(*) from snmpInterface where id = '1' and nodeid = '1' and snmpifIndex = '1'", Integer.class));
        } else {
            Assert.assertEquals((Object)new Integer(1), (Object)this.m_jdbcTemplate.queryForObject("select count(*) from snmpInterface where id = '1' and nodeid = '1' and snmpifIndex = '1' and snmpifalias = '" + ifName + "' and snmpifdescr = '" + ifName + "'", Integer.class));
        }
    }
}

